/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.resourcepackupdater.io.network;

import cn.zbx1425.resourcepackupdater.ResourcePackUpdater;
import cn.zbx1425.resourcepackupdater.ResourcePackUpdaterClient;
import cn.zbx1425.resourcepackupdater.io.network.DownloadDispatcher;
import cn.zbx1425.resourcepackupdater.io.network.ProgressOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

public class DownloadTask {
    public long totalBytes;
    public long downloadedBytes;
    public final long expectedSize;
    protected final DownloadDispatcher dispatcher;
    private final URI requestUri;
    public String fileName;
    public int failedAttempts = 0;

    public DownloadTask(DownloadDispatcher dispatcher, String url, String fileName, long expectedSize) {
        this.dispatcher = dispatcher;
        this.requestUri = URI.create(url);
        this.fileName = fileName;
        this.expectedSize = expectedSize;
    }

    public void runBlocking(OutputStream target) throws IOException {
        HttpResponse<InputStream> httpResponse = DownloadTask.sendHttpRequest(this.requestUri);
        if (httpResponse.statusCode() >= 400) {
            throw new IOException("Server returned HTTP " + httpResponse.statusCode() + " " + new String(httpResponse.body().readAllBytes(), StandardCharsets.UTF_8));
        }
        this.totalBytes = Long.parseLong(httpResponse.headers().firstValue("Content-Length").orElse(Long.toString(this.expectedSize)));
        final long[] accountedAmount = new long[]{0L};
        try {
            try (BufferedOutputStream bos = new BufferedOutputStream(target);
                 InputStream inputStream = DownloadTask.unwrapHttpResponse(httpResponse);){
                ProgressOutputStream pOfs = new ProgressOutputStream(bos, new ProgressOutputStream.WriteListener(){
                    final long noticeDivisor = 8192L;

                    @Override
                    public void registerWrite(long amountOfBytesWritten) throws IOException {
                        if (accountedAmount[0] / 8192L != amountOfBytesWritten / 8192L) {
                            DownloadTask.this.downloadedBytes += amountOfBytesWritten - accountedAmount[0];
                            DownloadTask.this.dispatcher.onDownloadProgress(amountOfBytesWritten - accountedAmount[0]);
                            accountedAmount[0] = amountOfBytesWritten;
                        }
                    }
                });
                IOUtils.copy((InputStream)new BufferedInputStream(inputStream), (OutputStream)pOfs);
            }
            target.close();
        }
        catch (Exception ex) {
            this.dispatcher.onDownloadProgress(-accountedAmount[0]);
            this.downloadedBytes = 0L;
            throw ex;
        }
        this.dispatcher.onDownloadProgress(this.totalBytes - accountedAmount[0]);
        this.downloadedBytes = this.totalBytes;
    }

    public static HttpResponse<InputStream> sendHttpRequest(URI requestUri) throws IOException {
        HttpResponse<InputStream> httpResponse;
        HttpRequest httpRequest = HttpRequest.newBuilder(requestUri).timeout(Duration.ofSeconds(20L)).setHeader("User-Agent", "ResourcePackUpdater/" + ResourcePackUpdater.MOD_VERSION + " +https://www.zbx1425.cn").setHeader("Accept-Encoding", "gzip").GET().build();
        try {
            httpResponse = ResourcePackUpdaterClient.HTTP_CLIENT.send(httpRequest, HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
        return httpResponse;
    }

    public static InputStream unwrapHttpResponse(HttpResponse<InputStream> response) throws IOException {
        String contentEncoding;
        return switch (contentEncoding = response.headers().firstValue("Content-Encoding").orElse("").toLowerCase(Locale.ROOT)) {
            case "" -> response.body();
            case "gzip" -> new GZIPInputStream(response.body());
            default -> throw new IOException("Unsupported Content-Encoding: " + contentEncoding);
        };
    }
}

