/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.resourcepackupdater.mixin;

import cn.zbx1425.resourcepackupdater.ResourcePackUpdater;
import cn.zbx1425.resourcepackupdater.drm.AssetEncryption;
import cn.zbx1425.resourcepackupdater.drm.ServerLockRegistry;
import cn.zbx1425.resourcepackupdater.drm.WrappedResourceOutput;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.datafixers.util.Either;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3797;
import net.minecraft.class_4239;
import net.minecraft.class_7367;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3259.class})
public abstract class FolderPackResourcesMixin
extends class_3255 {
    @Unique
    private Path canonicalRoot;
    @Shadow
    @Final
    private Path field_40001;

    @Unique
    private Path getCanonicalRoot() {
        if (this.canonicalRoot == null) {
            try {
                this.canonicalRoot = this.field_40001.toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                this.canonicalRoot = this.field_40001;
            }
        }
        return this.canonicalRoot;
    }

    private FolderPackResourcesMixin(String string, boolean bl) {
        super(string, bl);
    }

    @Inject(method={"getRootResource"}, at={@At(value="HEAD")}, cancellable=true)
    public void getRootResource(String[] elements, CallbackInfoReturnable<class_7367<InputStream>> cir) {
        if (this.getCanonicalRoot().equals(ResourcePackUpdater.CONFIG.packBaseDirFile.value)) {
            Path path = class_4239.method_46344((Path)this.field_40001, List.of(elements));
            if (Files.exists(path, new LinkOption[0])) {
                if (Arrays.equals(elements, new String[]{"pack.mcmeta"})) {
                    cir.setReturnValue(() -> FolderPackResourcesMixin.patchPackMeta(AssetEncryption.wrapInputStream(new FileInputStream(path.toFile()))));
                } else {
                    cir.setReturnValue(() -> AssetEncryption.wrapInputStream(new FileInputStream(path.toFile())));
                }
            } else {
                cir.setReturnValue(null);
            }
        }
    }

    @Inject(method={"getResource(Lnet/minecraft/server/packs/PackType;Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/server/packs/resources/IoSupplier;"}, at={@At(value="HEAD")}, cancellable=true)
    void getResource(class_3264 packType, class_2960 location, CallbackInfoReturnable<class_7367<InputStream>> cir) throws IOException {
        if (this.getCanonicalRoot().equals(ResourcePackUpdater.CONFIG.packBaseDirFile.value)) {
            Path path = this.field_40001.resolve(packType.method_14413()).resolve(location.method_12836());
            Either decomposeResult = class_4239.method_46346((String)location.method_12832()).get();
            if (decomposeResult.left().isEmpty()) {
                cir.setReturnValue(null);
                return;
            }
            Path path2 = class_4239.method_46344((Path)path, (List)((List)decomposeResult.left().get()));
            if (ServerLockRegistry.shouldRefuseProvidingFile(path2.toString())) {
                cir.setReturnValue(null);
                return;
            }
            if (Files.exists(path2, new LinkOption[0])) {
                cir.setReturnValue(() -> AssetEncryption.wrapInputStream(new FileInputStream(path2.toFile())));
            } else {
                cir.setReturnValue(null);
            }
        }
    }

    @WrapMethod(method={"listResources"})
    void getResources(class_3264 packType, String namespace, String path, class_3262.class_7664 resourceOutput, Operation<Void> original) {
        if (this.getCanonicalRoot().equals(ResourcePackUpdater.CONFIG.packBaseDirFile.value)) {
            if (ServerLockRegistry.shouldRefuseProvidingFile(null)) {
                return;
            }
            original.call(new Object[]{packType, namespace, path, new WrappedResourceOutput(resourceOutput)});
            return;
        }
        original.call(new Object[]{packType, namespace, path, resourceOutput});
    }

    @Inject(method={"getNamespaces"}, at={@At(value="HEAD")}, cancellable=true)
    void getNamespaces(class_3264 type, CallbackInfoReturnable<Set<String>> cir) {
        if (this.getCanonicalRoot().equals(ResourcePackUpdater.CONFIG.packBaseDirFile.value) && ServerLockRegistry.shouldRefuseProvidingFile(null)) {
            cir.setReturnValue(Collections.emptySet());
        }
    }

    @Unique
    private static InputStream patchPackMeta(InputStream inputStream) throws IOException {
        JsonObject jsonObject = JsonParser.parseString((String)IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8)).getAsJsonObject();
        jsonObject.getAsJsonObject("pack").addProperty("pack_format", (Number)class_3797.method_16672().method_48017(class_3264.field_14188));
        return IOUtils.toInputStream((String)jsonObject.toString(), (Charset)StandardCharsets.UTF_8);
    }
}

