/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.generated.map;

import javax.annotation.Nonnull;
import org.mtr.core.data.Route;
import org.mtr.core.map.RouteStation;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.core.tool.EnumHelper;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public abstract class RouteSchema
implements SerializedDataBase {
    protected final String id;
    protected final String name;
    protected final long color;
    protected final String number;
    protected final String type;
    protected final Route.CircularState circularState;
    protected final boolean hidden;
    protected final ObjectArrayList<RouteStation> stations = new ObjectArrayList();
    protected final LongArrayList durations = new LongArrayList();
    protected final ObjectArrayList<String> depots = new ObjectArrayList();

    protected RouteSchema(String id, String name, long color, String number, String type, Route.CircularState circularState, boolean hidden) {
        this.id = id;
        this.name = name;
        this.color = color;
        this.number = number;
        this.type = type;
        this.circularState = circularState;
        this.hidden = hidden;
    }

    protected RouteSchema(ReaderBase readerBase) {
        this.id = readerBase.getString("id", "");
        this.name = readerBase.getString("name", "");
        this.color = readerBase.getLong("color", 0L);
        this.number = readerBase.getString("number", "");
        this.type = readerBase.getString("type", "");
        this.circularState = EnumHelper.valueOf(Route.CircularState.values()[0], readerBase.getString("circularState", ""));
        this.hidden = readerBase.getBoolean("hidden", false);
    }

    @Override
    public void updateData(ReaderBase readerBase) {
        readerBase.iterateReaderArray("stations", this.stations::clear, readerBaseChild -> this.stations.add(new RouteStation((ReaderBase)readerBaseChild)));
        readerBase.iterateLongArray("durations", this.durations::clear, this.durations::add);
        readerBase.iterateStringArray("depots", this.depots::clear, this.depots::add);
    }

    @Override
    public void serializeData(WriterBase writerBase) {
        writerBase.writeString("id", this.id);
        writerBase.writeString("name", this.name);
        writerBase.writeLong("color", this.color);
        writerBase.writeString("number", this.number);
        writerBase.writeString("type", this.type);
        writerBase.writeString("circularState", this.circularState.toString());
        writerBase.writeBoolean("hidden", this.hidden);
        this.serializeStations(writerBase);
        this.serializeDurations(writerBase);
        this.serializeDepots(writerBase);
    }

    @Nonnull
    public String toString() {
        return "id: " + this.id + "\nname: " + this.name + "\ncolor: " + this.color + "\nnumber: " + this.number + "\ntype: " + this.type + "\ncircularState: " + (Object)((Object)this.circularState) + "\nhidden: " + this.hidden + "\nstations: " + this.stations + "\ndurations: " + this.durations + "\ndepots: " + this.depots + "\n";
    }

    protected void serializeStations(WriterBase writerBase) {
        writerBase.writeDataset(this.stations, "stations");
    }

    protected void serializeDurations(WriterBase writerBase) {
        WriterBase.Array durationsWriterBaseArray = writerBase.writeArray("durations");
        this.durations.forEach(durationsWriterBaseArray::writeLong);
    }

    protected void serializeDepots(WriterBase writerBase) {
        WriterBase.Array depotsWriterBaseArray = writerBase.writeArray("depots");
        this.depots.forEach(depotsWriterBaseArray::writeString);
    }
}

