/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_2769;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.StringIdentifiable;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockPSDAPGBase;
import org.mtr.mod.block.BlockPSDAPGDoorBase;
import org.mtr.mod.block.BlockPSDAPGGlassBase;
import org.mtr.mod.block.IBlock;

public abstract class BlockPSDAPGGlassEndBase
extends BlockPSDAPGGlassBase {
    public static final EnumProperty<EnumPSDAPGGlassEndSide> TOUCHING_LEFT = EnumProperty.of("touching_left", EnumPSDAPGGlassEndSide.class);
    public static final EnumProperty<EnumPSDAPGGlassEndSide> TOUCHING_RIGHT = EnumProperty.of("touching_right", EnumPSDAPGGlassEndSide.class);

    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        BlockState superState = super.getStateForNeighborUpdate2(state, direction, neighborState, world, pos, neighborPos);
        if (superState.getBlock().equals(Blocks.getAirMapped())) {
            return superState;
        }
        Direction facing = IBlock.getStatePropertySafe(state, FACING);
        EnumPSDAPGGlassEndSide touchingLeft = this.getSideEnd(world, pos, facing.rotateYCounterclockwise());
        EnumPSDAPGGlassEndSide touchingRight = this.getSideEnd(world, pos, facing.rotateYClockwise());
        return superState.with(new Property((class_2769)BlockPSDAPGGlassEndBase.TOUCHING_LEFT.data), touchingLeft).with(new Property((class_2769)BlockPSDAPGGlassEndBase.TOUCHING_RIGHT.data), touchingRight);
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        VoxelShape superShape = super.getOutlineShape2(state, world, pos, context);
        int height = this.isAPG() && IBlock.getStatePropertySafe(state, HALF) == IBlock.DoubleBlockHalf.UPPER ? 9 : 16;
        boolean leftAir = IBlock.getStatePropertySafe(state, new Property((class_2769)BlockPSDAPGGlassEndBase.TOUCHING_LEFT.data)) == EnumPSDAPGGlassEndSide.AIR;
        boolean rightAir = IBlock.getStatePropertySafe(state, new Property((class_2769)BlockPSDAPGGlassEndBase.TOUCHING_RIGHT.data)) == EnumPSDAPGGlassEndSide.AIR;
        return BlockPSDAPGGlassEndBase.getEndOutlineShape(superShape, state, height, 4, leftAir, rightAir);
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
        properties.add(HALF);
        properties.add(SIDE_EXTENDED);
        properties.add(TOUCHING_LEFT);
        properties.add(TOUCHING_RIGHT);
    }

    private EnumPSDAPGGlassEndSide getSideEnd(WorldAccess world, BlockPos pos, Direction offset) {
        BlockPos checkPos = pos.offset(offset);
        if (world.getBlockState((BlockPos)checkPos).getBlock().data instanceof BlockPSDAPGDoorBase) {
            return EnumPSDAPGGlassEndSide.DOOR;
        }
        if (world.getBlockState((BlockPos)checkPos).getBlock().data instanceof BlockPSDAPGBase) {
            return EnumPSDAPGGlassEndSide.NONE;
        }
        return EnumPSDAPGGlassEndSide.AIR;
    }

    public static VoxelShape getEndOutlineShape(VoxelShape baseShape, BlockState state, int height, int thickness, boolean leftAir, boolean rightAir) {
        Direction facing = IBlock.getStatePropertySafe(state, FACING);
        if (facing == Direction.NORTH && leftAir || facing == Direction.SOUTH && rightAir) {
            baseShape = VoxelShapes.union(baseShape, Block.createCuboidShape(0.0, 0.0, 0.0, thickness, height, 16.0));
        }
        if (facing == Direction.EAST && leftAir || facing == Direction.WEST && rightAir) {
            baseShape = VoxelShapes.union(baseShape, Block.createCuboidShape(0.0, 0.0, 0.0, 16.0, height, thickness));
        }
        if (facing == Direction.SOUTH && leftAir || facing == Direction.NORTH && rightAir) {
            baseShape = VoxelShapes.union(baseShape, Block.createCuboidShape(16 - thickness, 0.0, 0.0, 16.0, height, 16.0));
        }
        if (facing == Direction.WEST && leftAir || facing == Direction.EAST && rightAir) {
            baseShape = VoxelShapes.union(baseShape, Block.createCuboidShape(0.0, 0.0, 16 - thickness, 16.0, height, 16.0));
        }
        return baseShape;
    }

    public static enum EnumPSDAPGGlassEndSide implements StringIdentifiable
    {
        AIR("air"),
        DOOR("door"),
        NONE("none");

        private final String name;

        private EnumPSDAPGGlassEndSide(String nameIn) {
            this.name = nameIn;
        }

        @Override
        @Nonnull
        public String asString2() {
            return this.name;
        }
    }
}

