/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_2769;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.block.PlatformHelper;

public class BlockPlatform
extends BlockExtension
implements PlatformHelper {
    private final boolean isIndented;

    public BlockPlatform(BlockSettings blockSettings, boolean isIndented) {
        super(blockSettings);
        this.isIndented = isIndented;
    }

    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        return PlatformHelper.getActualState(BlockView.cast(world), pos, state);
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        return this.getDefaultState2().with(new Property((class_2769)BlockPlatform.FACING.data), ctx.getPlayerFacing().data);
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        if (this.isIndented) {
            Direction facing = IBlock.getStatePropertySafe(state, FACING);
            return VoxelShapes.union(IBlock.getVoxelShapeByDirection(0.0, 0.0, 6.0, 16.0, 13.0, 16.0, facing), Block.createCuboidShape(0.0, 13.0, 0.0, 16.0, 16.0, 16.0));
        }
        return super.getOutlineShape2(state, world, pos, context);
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
        properties.add(DOOR_TYPE);
        properties.add(SIDE);
    }
}

