/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import org.mtr.core.data.VehicleCar;
import org.mtr.core.tool.Utilities;
import org.mtr.core.tool.Vector;
import org.mtr.libraries.com.logisticscraft.occlusionculling.util.Vec3d;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntObjectImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectBooleanImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectDoubleImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.LightType;
import org.mtr.mapping.holder.LightmapTextureManager;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.EntityHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.OptimizedRenderer;
import org.mtr.mod.Init;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.client.GangwayMovementPositions;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.client.VehicleRidingMovement;
import org.mtr.mod.config.Config;
import org.mtr.mod.data.IGui;
import org.mtr.mod.data.VehicleExtension;
import org.mtr.mod.item.ItemDriverKey;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.PositionAndRotation;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.RenderVehicleHelper;
import org.mtr.mod.render.StoredMatrixTransformations;
import org.mtr.mod.resource.Interpolation;
import org.mtr.mod.resource.VehicleResource;
import org.mtr.mod.resource.VehicleResourceCache;
import org.mtr.mod.servlet.ResourcePackCreatorOperationServlet;

public class RenderVehicles
implements IGui {
    public static final ObjectArrayList<RidingPlayerInterpolation> RIDING_PLAYER_INTERPOLATIONS = new ObjectArrayList();

    public static void render(long millisElapsed, Vector3d cameraShakeOffset) {
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        ClientWorld clientWorld = minecraftClient.getWorldMapped();
        ClientPlayerEntity clientPlayerEntity = minecraftClient.getPlayerMapped();
        if (clientWorld == null || clientPlayerEntity == null) {
            return;
        }
        ObjectArrayList cullingTasks = new ObjectArrayList();
        Vector3d cameraPosition = minecraftClient.getGameRendererMapped().getCamera().getPos();
        Vec3d camera = new Vec3d(cameraPosition.getXMapped(), cameraPosition.getYMapped(), cameraPosition.getZMapped());
        boolean canRide = !clientPlayerEntity.isSpectator();
        MinecraftClientData.getInstance().vehicles.forEach(vehicle -> {
            Double offsetRotation;
            Vector3d offsetVector;
            PositionAndRotation ridingCarPositionAndRotation;
            int ridingCarNumber;
            ObjectArrayList previousGangwayPositionsList = new ObjectArrayList();
            ObjectArrayList previousBarrierPositionsList = new ObjectArrayList();
            PreviousGangwayMovementPositions previousGangwayMovementPositions = new PreviousGangwayMovementPositions();
            ObjectArrayList vehiclePropertiesList = vehicle.getSmoothedVehicleCarsAndPositions(millisElapsed).stream().map(vehicleCarAndPosition -> {
                ObjectArrayList bogiePositions = ((ObjectArrayList)vehicleCarAndPosition.right()).stream().map(bogiePositionPair -> new PositionAndRotation((Vector)bogiePositionPair.left(), (Vector)bogiePositionPair.right(), true)).collect(Collectors.toCollection(ObjectArrayList::new));
                return new ObjectObjectImmutablePair<VehicleCar, ObjectObjectImmutablePair<ObjectArrayList, PositionAndRotation>>((VehicleCar)vehicleCarAndPosition.left(), new ObjectObjectImmutablePair<ObjectArrayList, PositionAndRotation>(bogiePositions, new PositionAndRotation(bogiePositions, (VehicleCar)vehicleCarAndPosition.left(), vehicle.getTransportMode().hasPitchAscending || vehicle.getTransportMode().hasPitchDescending)));
            }).collect(Collectors.toCollection(ObjectArrayList::new));
            IntObjectImmutablePair<ObjectObjectImmutablePair<Vector3d, Double>> ridingVehicleCarNumberAndOffset = VehicleRidingMovement.getRidingVehicleCarNumberAndOffset(vehicle.getId());
            if (ridingVehicleCarNumberAndOffset == null) {
                ridingCarNumber = -1;
                ridingCarPositionAndRotation = null;
                offsetVector = null;
                offsetRotation = null;
            } else {
                ridingCarNumber = ridingVehicleCarNumberAndOffset.leftInt();
                ridingCarPositionAndRotation = (PositionAndRotation)((ObjectObjectImmutablePair)((ObjectObjectImmutablePair)vehiclePropertiesList.get(ridingCarNumber)).right()).right();
                offsetVector = ridingVehicleCarNumberAndOffset.right().left();
                Double tempOffsetRotation = ridingVehicleCarNumberAndOffset.right().right();
                offsetRotation = tempOffsetRotation == null ? null : Double.valueOf(tempOffsetRotation + (Math.abs(Utilities.circularDifference(Math.round(EntityHelper.getYaw(new Entity((class_1297)clientPlayerEntity.data))), Math.round(minecraftClient.getGameRendererMapped().getCamera().getYaw()), 360L)) > 90L ? Math.PI : 0.0));
            }
            RenderVehicles.iterateWithIndex(vehiclePropertiesList, (carNumber, vehicleCarDetails) -> {
                cullingTasks.add(occlusionCullingInstance -> {
                    double longestDimension = vehicle.persistentVehicleData.longestDimensions[carNumber];
                    boolean shouldRender = occlusionCullingInstance.isAABBVisible(new Vec3d(((PositionAndRotation)((ObjectObjectImmutablePair)vehicleCarDetails.right()).right()).position.x - longestDimension, ((PositionAndRotation)((ObjectObjectImmutablePair)vehicleCarDetails.right()).right()).position.y - 8.0, ((PositionAndRotation)((ObjectObjectImmutablePair)vehicleCarDetails.right()).right()).position.z - longestDimension), new Vec3d(((PositionAndRotation)((ObjectObjectImmutablePair)vehicleCarDetails.right()).right()).position.x + longestDimension, ((PositionAndRotation)((ObjectObjectImmutablePair)vehicleCarDetails.right()).right()).position.y + 8.0, ((PositionAndRotation)((ObjectObjectImmutablePair)vehicleCarDetails.right()).right()).position.z + longestDimension), camera);
                    return () -> {
                        vehicle.persistentVehicleData.rayTracing[carNumber] = shouldRender;
                    };
                });
                if (vehicle.persistentVehicleData.rayTracing[carNumber] || VehicleRidingMovement.isRiding(vehicle.getId())) {
                    CustomResourceLoader.getVehicleById(vehicle.getTransportMode(), ((VehicleCar)vehicleCarDetails.left()).getVehicleId(), vehicleResourceDetails -> {
                        ObjectArrayList<ObjectDoubleImmutablePair> openDoorways;
                        VehicleResource vehicleResource = (VehicleResource)vehicleResourceDetails.left();
                        boolean fromResourcePackCreator = vehicleResourceDetails.rightBoolean() && !vehicle.getIsOnRoute();
                        int[] scrollingDisplayIndexTracker = new int[]{0};
                        PositionAndRotation absoluteVehicleCarPositionAndRotation = (PositionAndRotation)((ObjectObjectImmutablePair)vehicleCarDetails.right()).right();
                        PositionAndRotation vehicleCarRenderingPositionAndRotation = RenderVehicles.getRenderPositionAndRotation(offsetVector, offsetRotation, ridingCarPositionAndRotation, absoluteVehicleCarPositionAndRotation, cameraShakeOffset);
                        RenderVehicles.iterateWithIndex((ObjectArrayList)((ObjectObjectImmutablePair)vehicleCarDetails.right()).left(), (bogieIndex, absoluteBogiePositionAndRotation) -> {
                            PositionAndRotation bogieRenderingPositionAndRotation = RenderVehicles.getRenderPositionAndRotation(offsetVector, offsetRotation, ridingCarPositionAndRotation, absoluteBogiePositionAndRotation, cameraShakeOffset);
                            StoredMatrixTransformations storedMatrixTransformations = RenderVehicles.getStoredMatrixTransformations(offsetVector == null, bogieRenderingPositionAndRotation, 0.0);
                            if (OptimizedRenderer.hasOptimizedRendering()) {
                                vehicleResource.queueBogie(bogieIndex, storedMatrixTransformations, (VehicleExtension)vehicle, absoluteVehicleCarPositionAndRotation.light);
                            } else {
                                vehicleResource.iterateBogieModels(bogieIndex, (modelIndex, model) -> model.render(storedMatrixTransformations, (VehicleExtension)vehicle, carNumber, scrollingDisplayIndexTracker, absoluteVehicleCarPositionAndRotation.light, new ObjectArrayList<ObjectDoubleImmutablePair<Box>>(), fromResourcePackCreator));
                            }
                        });
                        Vector3d playerPosition = absoluteVehicleCarPositionAndRotation.transformBackwards(clientPlayerEntity.getPos(), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
                        ObjectArrayList<ObjectBooleanImmutablePair<Box>> floorsAndDoorways = new ObjectArrayList<ObjectBooleanImmutablePair<Box>>();
                        GangwayMovementPositions gangwayMovementPositions1 = new GangwayMovementPositions(absoluteVehicleCarPositionAndRotation, false);
                        GangwayMovementPositions gangwayMovementPositions2 = new GangwayMovementPositions(absoluteVehicleCarPositionAndRotation, true);
                        VehicleResourceCache vehicleResourceCache = vehicleResource.getCachedVehicleResource(carNumber, vehicle.vehicleExtraData.immutableVehicleCars.size(), false);
                        if (vehicleResourceCache != null && fromResourcePackCreator) {
                            openDoorways = vehicle.persistentVehicleData.checkCanOpenDoors() ? vehicleResourceCache.doorways.stream().map(doorway -> new ObjectDoubleImmutablePair<Box>((Box)doorway, 0.0)).collect(Collectors.toCollection(ObjectArrayList::new)) : new ObjectArrayList();
                            vehicle.persistentVehicleData.overrideDoorMultiplier(ResourcePackCreatorOperationServlet.getDoorMultiplier());
                        } else if (vehicleResourceCache == null || !vehicle.getTransportMode().continuousMovement && vehicle.isMoving()) {
                            openDoorways = new ObjectArrayList<ObjectDoubleImmutablePair>();
                        } else {
                            ObjectArrayList<Vector3d> doorHoldingPlayerOffsetPositions = new ObjectArrayList<Vector3d>();
                            if (ridingCarNumber == carNumber && offsetVector != null) {
                                doorHoldingPlayerOffsetPositions.add(offsetVector);
                            }
                            vehicle.vehicleExtraData.iterateRidingEntities(vehicleRidingEntity -> {
                                if (vehicleRidingEntity.getRidingCar() == (long)carNumber && !vehicleRidingEntity.uuid.equals(clientPlayerEntity.getUuid())) {
                                    doorHoldingPlayerOffsetPositions.add(new Vector3d(vehicleRidingEntity.getX(), vehicleRidingEntity.getY(), vehicleRidingEntity.getZ()));
                                }
                            });
                            openDoorways = new ObjectArrayList();
                            vehicleResourceCache.doorways.forEach(doorway -> {
                                double[] doorBlockedAmount = new double[]{0.0};
                                doorHoldingPlayerOffsetPositions.forEach(doorHoldingPlayerOffset -> {
                                    double thisDoorBlockedAmount = RenderVehicleHelper.getDoorBlockedAmount(doorway, doorHoldingPlayerOffset.getXMapped(), doorHoldingPlayerOffset.getYMapped(), doorHoldingPlayerOffset.getZMapped());
                                    if (thisDoorBlockedAmount > 0.0 && doorHoldingPlayerOffset == offsetVector) {
                                        VehicleRidingMovement.overrideDoors();
                                    }
                                    if (thisDoorBlockedAmount > doorBlockedAmount[0]) {
                                        doorBlockedAmount[0] = thisDoorBlockedAmount;
                                    }
                                });
                                boolean canOpenDoors = RenderVehicleHelper.canOpenDoors(doorway, absoluteVehicleCarPositionAndRotation, Math.max(doorBlockedAmount[0], vehicle.persistentVehicleData.getDoorValue() * 2.0));
                                if ((doorBlockedAmount[0] > 0.0 || vehicle.persistentVehicleData.checkCanOpenDoors()) && canOpenDoors) {
                                    openDoorways.add(new ObjectDoubleImmutablePair<Box>((Box)doorway, doorBlockedAmount[0]));
                                }
                            });
                        }
                        double oscillationAmount = vehicle.persistentVehicleData.getOscillation(carNumber).getAmount() * Config.getClient().getVehicleOscillationMultiplier();
                        if (canRide) {
                            ObjectArrayList<Box> openFloorsAndDoorways = new ObjectArrayList<Box>();
                            if (vehicleResourceCache != null) {
                                vehicleResourceCache.floors.forEach(floor -> {
                                    ItemDriverKey driverKey;
                                    floorsAndDoorways.add(new ObjectBooleanImmutablePair<Box>((Box)floor, true));
                                    if (!VehicleRidingMovement.isRiding(vehicle.getId()) && (driverKey = VehicleRidingMovement.getValidHoldingKey(vehicle.vehicleExtraData.getDepotId())) != null && (driverKey.canBoardAnyVehicle || vehicle.vehicleExtraData.getIsManualAllowed())) {
                                        openFloorsAndDoorways.add((Box)floor);
                                    }
                                    RenderVehicleHelper.renderFloorOrDoorway(floor, -1, playerPosition, vehicleCarRenderingPositionAndRotation, offsetVector == null);
                                    gangwayMovementPositions1.check((Box)floor);
                                    gangwayMovementPositions2.check((Box)floor);
                                });
                            }
                            openDoorways.forEach(openDoorway -> {
                                Box doorway = (Box)openDoorway.left();
                                floorsAndDoorways.add(new ObjectBooleanImmutablePair<Box>(doorway, false));
                                openFloorsAndDoorways.add(doorway);
                                RenderVehicleHelper.renderFloorOrDoorway(doorway, -65536, playerPosition, vehicleCarRenderingPositionAndRotation, offsetVector == null);
                            });
                            VehicleRidingMovement.startRiding(openFloorsAndDoorways, vehicle.vehicleExtraData.getDepotId(), vehicle.vehicleExtraData.getSidingId(), vehicle.getId(), carNumber, playerPosition.getXMapped(), playerPosition.getYMapped(), playerPosition.getZMapped(), absoluteVehicleCarPositionAndRotation.yaw);
                        }
                        if (!OptimizedRenderer.renderingShadows()) {
                            vehicle.playMotorSound(vehicleResource, carNumber, absoluteVehicleCarPositionAndRotation.position);
                            if (!openDoorways.isEmpty()) {
                                vehicle.playDoorSound(vehicleResource, carNumber, absoluteVehicleCarPositionAndRotation.position);
                            }
                        }
                        StoredMatrixTransformations storedMatrixTransformations = RenderVehicles.getStoredMatrixTransformations(offsetVector == null, vehicleCarRenderingPositionAndRotation, oscillationAmount);
                        if (OptimizedRenderer.hasOptimizedRendering()) {
                            vehicleResource.queue(storedMatrixTransformations, (VehicleExtension)vehicle, carNumber, vehicle.vehicleExtraData.immutableVehicleCars.size(), absoluteVehicleCarPositionAndRotation.light, openDoorways.isEmpty());
                        }
                        vehicleResource.iterateModels(carNumber, vehicle.vehicleExtraData.immutableVehicleCars.size(), (modelIndex, model) -> {
                            model.render(storedMatrixTransformations, (VehicleExtension)vehicle, carNumber, scrollingDisplayIndexTracker, absoluteVehicleCarPositionAndRotation.light, (ObjectArrayList<ObjectDoubleImmutablePair<Box>>)openDoorways, fromResourcePackCreator);
                            while (modelIndex >= previousGangwayPositionsList.size()) {
                                previousGangwayPositionsList.add(new PreviousConnectionPositions());
                            }
                            while (modelIndex >= previousBarrierPositionsList.size()) {
                                previousBarrierPositionsList.add(new PreviousConnectionPositions());
                            }
                            RenderVehicles.renderConnection(vehicleResource.hasGangway1(), vehicleResource.hasGangway2(), true, (PreviousConnectionPositions)previousGangwayPositionsList.get(modelIndex), model.modelProperties.gangwayInnerSideTexture, model.modelProperties.gangwayInnerTopTexture, model.modelProperties.gangwayInnerBottomTexture, model.modelProperties.gangwayOuterSideTexture, model.modelProperties.gangwayOuterTopTexture, model.modelProperties.gangwayOuterBottomTexture, vehicleCarRenderingPositionAndRotation, offsetVector == null, ((VehicleCar)vehicleCarDetails.left()).getLength(), model.modelProperties.getGangwayWidth(), model.modelProperties.getGangwayHeight(), model.modelProperties.getGangwayYOffset(), model.modelProperties.getGangwayZOffset(), oscillationAmount, vehicle.getIsOnRoute());
                            RenderVehicles.renderConnection(vehicleResource.hasBarrier1(), vehicleResource.hasBarrier2(), false, (PreviousConnectionPositions)previousBarrierPositionsList.get(modelIndex), model.modelProperties.barrierInnerSideTexture, model.modelProperties.barrierInnerTopTexture, model.modelProperties.barrierInnerBottomTexture, model.modelProperties.barrierOuterSideTexture, model.modelProperties.barrierOuterTopTexture, model.modelProperties.barrierOuterBottomTexture, vehicleCarRenderingPositionAndRotation, offsetVector == null, ((VehicleCar)vehicleCarDetails.left()).getLength(), model.modelProperties.getBarrierWidth(), model.modelProperties.getBarrierHeight(), model.modelProperties.getBarrierYOffset(), model.modelProperties.getBarrierZOffset(), oscillationAmount, vehicle.getIsOnRoute());
                        });
                        Box gangwayConnectionFloor1 = gangwayMovementPositions1.getBox();
                        if (vehicleResource.hasGangway1()) {
                            RenderVehicleHelper.renderFloorOrDoorway(gangwayConnectionFloor1, -16776961, playerPosition, vehicleCarRenderingPositionAndRotation, offsetVector == null);
                            floorsAndDoorways.add(new ObjectBooleanImmutablePair<Box>(gangwayConnectionFloor1, true));
                        }
                        Box gangwayConnectionFloor2 = gangwayMovementPositions2.getBox();
                        if (vehicleResource.hasGangway2()) {
                            RenderVehicleHelper.renderFloorOrDoorway(gangwayConnectionFloor2, -16776961, playerPosition, vehicleCarRenderingPositionAndRotation, offsetVector == null);
                            floorsAndDoorways.add(new ObjectBooleanImmutablePair<Box>(gangwayConnectionFloor2, true));
                        }
                        if (ridingCarNumber == carNumber && offsetVector != null && minecraftClient.getGameRendererMapped().getCamera().isThirdPerson()) {
                            RenderVehicles.renderPlayer(new Entity((class_1297)clientPlayerEntity.data), -1, 0.0, 0.0, offsetVector, offsetVector, offsetRotation, absoluteVehicleCarPositionAndRotation, absoluteVehicleCarPositionAndRotation, cameraShakeOffset);
                        }
                        vehicle.vehicleExtraData.iterateRidingEntities(vehicleRidingEntity -> {
                            PlayerEntity ridingPlayer;
                            boolean isOnBackGangway = vehicleRidingEntity.getIsOnGangway() && vehicleRidingEntity.getZ() < 0.5;
                            if (vehicleRidingEntity.getRidingCar() - (long)(isOnBackGangway ? 1 : 0) == (long)carNumber && !vehicleRidingEntity.uuid.equals(clientPlayerEntity.getUuid()) && (ridingPlayer = clientWorld.getPlayerByUuid(vehicleRidingEntity.uuid)) != null) {
                                double playerRidingZ;
                                double playerRidingY;
                                double playerRidingX;
                                if (vehicleRidingEntity.getIsOnGangway()) {
                                    if (isOnBackGangway) {
                                        playerRidingX = RenderVehicles.getPositionFromPercentage(vehicleRidingEntity.getX(), gangwayConnectionFloor2.getMinXMapped() + (double)0.3f, gangwayConnectionFloor2.getMaxXMapped() - (double)0.3f);
                                        playerRidingY = RenderVehicles.getPositionFromPercentage(vehicleRidingEntity.getY(), gangwayConnectionFloor2.getMinYMapped(), gangwayConnectionFloor2.getMaxYMapped());
                                        playerRidingZ = RenderVehicles.getPositionFromPercentage(vehicleRidingEntity.getZ(), gangwayConnectionFloor2.getMinZMapped() + (gangwayConnectionFloor2.getMaxZMapped() - gangwayConnectionFloor2.getMinZMapped()) / 2.0, gangwayConnectionFloor2.getMaxZMapped());
                                    } else {
                                        playerRidingX = RenderVehicles.getPositionFromPercentage(vehicleRidingEntity.getX(), gangwayConnectionFloor1.getMinXMapped() + (double)0.3f, gangwayConnectionFloor1.getMaxXMapped() - (double)0.3f);
                                        playerRidingY = RenderVehicles.getPositionFromPercentage(vehicleRidingEntity.getY(), gangwayConnectionFloor1.getMinYMapped(), gangwayConnectionFloor1.getMaxYMapped());
                                        playerRidingZ = RenderVehicles.getPositionFromPercentage(vehicleRidingEntity.getZ(), gangwayConnectionFloor1.getMinZMapped(), gangwayConnectionFloor1.getMaxZMapped() - (gangwayConnectionFloor1.getMaxZMapped() - gangwayConnectionFloor1.getMinZMapped()) / 2.0);
                                    }
                                } else {
                                    playerRidingX = vehicleRidingEntity.getX();
                                    playerRidingY = vehicleRidingEntity.getY();
                                    playerRidingZ = vehicleRidingEntity.getZ();
                                }
                                RenderVehicles.renderPlayer(new Entity((class_1297)ridingPlayer.data), carNumber, gangwayConnectionFloor1.getMinZMapped(), gangwayConnectionFloor2.getMaxZMapped(), new Vector3d(playerRidingX, playerRidingY, playerRidingZ), offsetVector, offsetRotation, absoluteVehicleCarPositionAndRotation, ridingCarPositionAndRotation, cameraShakeOffset);
                            }
                        });
                        if (canRide) {
                            VehicleRidingMovement.movePlayer(millisElapsed, vehicle.getId(), carNumber, floorsAndDoorways, vehicleResource.hasGangway1() ? previousGangwayMovementPositions.gangwayMovementPositions : null, vehicleResource.hasGangway1() ? gangwayMovementPositions1 : null, vehicleResource.hasGangway2() ? gangwayMovementPositions2 : null, absoluteVehicleCarPositionAndRotation);
                        }
                        previousGangwayMovementPositions.gangwayMovementPositions = gangwayMovementPositions2;
                    });
                }
            });
        });
        if (!OptimizedRenderer.renderingShadows()) {
            MainRenderer.WORKER_THREAD.scheduleVehicles(occlusionCullingInstance -> {
                ObjectArrayList tasks = new ObjectArrayList();
                cullingTasks.forEach(occlusionCullingInstanceRunnableFunction -> tasks.add((Runnable)occlusionCullingInstanceRunnableFunction.apply(occlusionCullingInstance)));
                minecraftClient.execute(() -> tasks.forEach(Runnable::run));
            });
        }
    }

    public static PositionAndRotation getRenderPositionAndRotation(@Nullable Vector3d offsetVector, @Nullable Double offsetRotation, @Nullable PositionAndRotation ridingCarPositionAndRotation, PositionAndRotation renderingPositionAndRotation, Vector3d cameraShakeOffset) {
        if (offsetVector == null || ridingCarPositionAndRotation == null) {
            return renderingPositionAndRotation;
        }
        if (offsetRotation == null) {
            return new PositionAndRotation(new Vector(-offsetVector.getXMapped(), -offsetVector.getYMapped(), -offsetVector.getZMapped()).rotateX(ridingCarPositionAndRotation.pitch).rotateY(ridingCarPositionAndRotation.yaw).add(cameraShakeOffset.getXMapped() + renderingPositionAndRotation.position.x - ridingCarPositionAndRotation.position.x, cameraShakeOffset.getYMapped() + renderingPositionAndRotation.position.y - ridingCarPositionAndRotation.position.y, cameraShakeOffset.getZMapped() + renderingPositionAndRotation.position.z - ridingCarPositionAndRotation.position.z), renderingPositionAndRotation.yaw, renderingPositionAndRotation.pitch);
        }
        double ridingRotation = offsetRotation - ridingCarPositionAndRotation.yaw - Math.toRadians(MinecraftClient.getInstance().getGameRendererMapped().getCamera().getYaw());
        return new PositionAndRotation(new Vector(-offsetVector.getXMapped(), -offsetVector.getYMapped(), -offsetVector.getZMapped()).rotateX(ridingCarPositionAndRotation.pitch).rotateY(ridingCarPositionAndRotation.yaw).add(renderingPositionAndRotation.position.x - ridingCarPositionAndRotation.position.x, renderingPositionAndRotation.position.y - ridingCarPositionAndRotation.position.y, renderingPositionAndRotation.position.z - ridingCarPositionAndRotation.position.z).rotateY(ridingRotation).add(cameraShakeOffset.getXMapped(), cameraShakeOffset.getYMapped(), cameraShakeOffset.getZMapped()), renderingPositionAndRotation.yaw + ridingRotation, renderingPositionAndRotation.pitch);
    }

    public static StoredMatrixTransformations getStoredMatrixTransformations(boolean useOffset, PositionAndRotation renderingPositionAndRotation, double oscillationAmount) {
        StoredMatrixTransformations storedMatrixTransformations;
        if (useOffset) {
            storedMatrixTransformations = new StoredMatrixTransformations(renderingPositionAndRotation.position.x, renderingPositionAndRotation.position.y, renderingPositionAndRotation.position.z);
        } else {
            storedMatrixTransformations = new StoredMatrixTransformations();
            storedMatrixTransformations.add(graphicsHolder -> graphicsHolder.translate(renderingPositionAndRotation.position.x, renderingPositionAndRotation.position.y, renderingPositionAndRotation.position.z));
        }
        storedMatrixTransformations.add(graphicsHolder -> {
            graphicsHolder.rotateYRadians((float)(renderingPositionAndRotation.yaw + Math.PI));
            graphicsHolder.rotateXRadians((float)(renderingPositionAndRotation.pitch + Math.PI));
            graphicsHolder.rotateZDegrees((float)oscillationAmount);
        });
        return storedMatrixTransformations;
    }

    public static void renderPlayer(Entity entity, int ridingCar, double minZ, double maxZ, Vector3d playerOffsetVector, @Nullable Vector3d offsetVector, @Nullable Double offsetRotation, PositionAndRotation playerCarPositionAndRotation, @Nullable PositionAndRotation ridingCarPositionAndRotation, Vector3d cameraShakeOffset) {
        Vector interpolatedPosition = null;
        for (RidingPlayerInterpolation ridingPlayerInterpolation : RIDING_PLAYER_INTERPOLATIONS) {
            if (!ridingPlayerInterpolation.uuid.equals(entity.getUuid())) continue;
            if (ridingCar >= 0 && ridingPlayerInterpolation.ridingCar == ridingCar) {
                ridingPlayerInterpolation.interpolationX.setValue(playerOffsetVector.getXMapped(), ridingPlayerInterpolation.previousX != playerOffsetVector.getXMapped());
                ridingPlayerInterpolation.interpolationY.setValue(playerOffsetVector.getYMapped(), ridingPlayerInterpolation.previousY != playerOffsetVector.getYMapped());
                ridingPlayerInterpolation.interpolationZ.setValue(playerOffsetVector.getZMapped(), ridingPlayerInterpolation.previousZ != playerOffsetVector.getZMapped());
            } else {
                ridingPlayerInterpolation.interpolationX.setValueDirect(playerOffsetVector.getXMapped());
                ridingPlayerInterpolation.interpolationY.setValueDirect(playerOffsetVector.getYMapped());
                if (ridingCar >= 0) {
                    ridingPlayerInterpolation.interpolationZ.setValueDirect(ridingCar > ridingPlayerInterpolation.ridingCar ? minZ : maxZ);
                    ridingPlayerInterpolation.interpolationZ.setValue(playerOffsetVector.getZMapped(), true);
                } else {
                    ridingPlayerInterpolation.interpolationZ.setValueDirect(playerOffsetVector.getZMapped());
                }
            }
            ridingPlayerInterpolation.ridingCar = ridingCar;
            ridingPlayerInterpolation.previousX = playerOffsetVector.getXMapped();
            ridingPlayerInterpolation.previousY = playerOffsetVector.getYMapped();
            ridingPlayerInterpolation.previousZ = playerOffsetVector.getZMapped();
            interpolatedPosition = new Vector(ridingPlayerInterpolation.interpolationX.getValue(), ridingPlayerInterpolation.interpolationY.getValue(), ridingPlayerInterpolation.interpolationZ.getValue());
            break;
        }
        if (interpolatedPosition == null) {
            interpolatedPosition = new Vector(playerOffsetVector.getXMapped(), playerOffsetVector.getYMapped(), playerOffsetVector.getZMapped());
            RidingPlayerInterpolation ridingPlayerInterpolation = new RidingPlayerInterpolation(entity.getUuid());
            RIDING_PLAYER_INTERPOLATIONS.add(ridingPlayerInterpolation);
            ridingPlayerInterpolation.interpolationX.setValueDirect(playerOffsetVector.getXMapped());
            ridingPlayerInterpolation.interpolationY.setValueDirect(playerOffsetVector.getYMapped());
            ridingPlayerInterpolation.interpolationZ.setValueDirect(playerOffsetVector.getZMapped());
            ridingPlayerInterpolation.ridingCar = ridingCar;
            ridingPlayerInterpolation.previousX = playerOffsetVector.getXMapped();
            ridingPlayerInterpolation.previousY = playerOffsetVector.getYMapped();
            ridingPlayerInterpolation.previousZ = playerOffsetVector.getZMapped();
        }
        PositionAndRotation playerRenderingPositionAndRotation = RenderVehicles.getRenderPositionAndRotation(offsetVector, offsetRotation, ridingCarPositionAndRotation, new PositionAndRotation(playerCarPositionAndRotation.position.add(interpolatedPosition.rotateX(playerCarPositionAndRotation.pitch).rotateY(playerCarPositionAndRotation.yaw)), 0.0, 0.0), cameraShakeOffset);
        StoredMatrixTransformations storedMatrixTransformations = RenderVehicles.getStoredMatrixTransformations(offsetVector == null, playerRenderingPositionAndRotation, 0.0);
        MainRenderer.scheduleRender(QueuedRenderLayer.INTERIOR, (graphicsHolder, offset) -> {
            storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
            graphicsHolder.rotateXDegrees(180.0f);
            graphicsHolder.rotateYDegrees(180.0f);
            graphicsHolder.renderEntity(entity, 0.0, 1000.0, 0.0, 0.0f, 0.0f, GraphicsHolder.getDefaultLight());
            graphicsHolder.pop();
        });
    }

    private static void renderConnection(boolean shouldRender1, boolean shouldRender2, boolean canHaveLight, PreviousConnectionPositions previousConnectionPositions, @Nullable Identifier innerSideTexture, @Nullable Identifier innerTopTexture, @Nullable Identifier innerBottomTexture, @Nullable Identifier outerSideTexture, @Nullable Identifier outerTopTexture, @Nullable Identifier outerBottomTexture, PositionAndRotation positionAndRotation, boolean useOffset, double vehicleLength, double width, double height, double yOffset, double zOffset, double oscillationAmount, boolean isOnRoute) {
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (clientWorld == null) {
            return;
        }
        double halfLength = vehicleLength / 2.0;
        double newOscillationAmount = -Math.toRadians(oscillationAmount);
        if (shouldRender1 && previousConnectionPositions.isValid()) {
            Vector position1 = positionAndRotation.transformForwards(new Vector(-width / 2.0, yOffset + (double)0.003125f, zOffset - halfLength).rotateZ(newOscillationAmount), Vector::rotateX, Vector::rotateY, Vector::add);
            Vector position2 = positionAndRotation.transformForwards(new Vector(-width / 2.0, height + yOffset + (double)0.003125f, zOffset - halfLength).rotateZ(newOscillationAmount), Vector::rotateX, Vector::rotateY, Vector::add);
            Vector position3 = positionAndRotation.transformForwards(new Vector(width / 2.0, height + yOffset + (double)0.003125f, zOffset - halfLength).rotateZ(newOscillationAmount), Vector::rotateX, Vector::rotateY, Vector::add);
            Vector position4 = positionAndRotation.transformForwards(new Vector(width / 2.0, yOffset + (double)0.003125f, zOffset - halfLength).rotateZ(newOscillationAmount), Vector::rotateX, Vector::rotateY, Vector::add);
            Vector position5 = previousConnectionPositions.position1;
            Vector position6 = previousConnectionPositions.position2;
            Vector position7 = previousConnectionPositions.position3;
            Vector position8 = previousConnectionPositions.position4;
            BlockPos blockPosConnection = Init.newBlockPos(position1.x, position1.y + 1.0, position1.z);
            int lightConnection = LightmapTextureManager.pack(clientWorld.getLightLevel(LightType.getBlockMapped(), blockPosConnection), clientWorld.getLightLevel(LightType.getSkyMapped(), blockPosConnection));
            Vector3d zeroVector = Vector3d.getZeroMapped();
            MainRenderer.scheduleRender(outerSideTexture, false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> {
                RenderVehicles.drawTexture(graphicsHolder, position2, position7, position8, position1, useOffset ? offset : zeroVector, lightConnection);
                RenderVehicles.drawTexture(graphicsHolder, position6, position3, position4, position5, useOffset ? offset : zeroVector, lightConnection);
            });
            MainRenderer.scheduleRender(outerTopTexture, false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> RenderVehicles.drawTexture(graphicsHolder, position3, position6, position7, position2, useOffset ? offset : zeroVector, lightConnection));
            MainRenderer.scheduleRender(outerBottomTexture, false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> RenderVehicles.drawTexture(graphicsHolder, position1, position8, position5, position4, useOffset ? offset : zeroVector, lightConnection));
            MainRenderer.scheduleRender(innerSideTexture, false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> {
                RenderVehicles.drawTexture(graphicsHolder, position7, position2, position1, position8, useOffset ? offset : zeroVector, canHaveLight && isOnRoute ? GraphicsHolder.getDefaultLight() : lightConnection);
                RenderVehicles.drawTexture(graphicsHolder, position3, position6, position5, position4, useOffset ? offset : zeroVector, canHaveLight && isOnRoute ? GraphicsHolder.getDefaultLight() : lightConnection);
            });
            MainRenderer.scheduleRender(innerTopTexture, false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> RenderVehicles.drawTexture(graphicsHolder, position6, position3, position2, position7, useOffset ? offset : zeroVector, canHaveLight && isOnRoute ? GraphicsHolder.getDefaultLight() : lightConnection));
            MainRenderer.scheduleRender(innerBottomTexture, false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> RenderVehicles.drawTexture(graphicsHolder, position8, position1, position4, position5, useOffset ? offset : zeroVector, canHaveLight && isOnRoute ? GraphicsHolder.getDefaultLight() : lightConnection));
        }
        if (shouldRender2) {
            previousConnectionPositions.position1 = positionAndRotation.transformForwards(new Vector(width / 2.0, yOffset + (double)0.003125f, -zOffset + halfLength).rotateZ(newOscillationAmount), Vector::rotateX, Vector::rotateY, Vector::add);
            previousConnectionPositions.position2 = positionAndRotation.transformForwards(new Vector(width / 2.0, height + yOffset + (double)0.003125f, -zOffset + halfLength).rotateZ(newOscillationAmount), Vector::rotateX, Vector::rotateY, Vector::add);
            previousConnectionPositions.position3 = positionAndRotation.transformForwards(new Vector(-width / 2.0, height + yOffset + (double)0.003125f, -zOffset + halfLength).rotateZ(newOscillationAmount), Vector::rotateX, Vector::rotateY, Vector::add);
            previousConnectionPositions.position4 = positionAndRotation.transformForwards(new Vector(-width / 2.0, yOffset + (double)0.003125f, -zOffset + halfLength).rotateZ(newOscillationAmount), Vector::rotateX, Vector::rotateY, Vector::add);
        } else {
            previousConnectionPositions.position1 = null;
            previousConnectionPositions.position2 = null;
            previousConnectionPositions.position3 = null;
            previousConnectionPositions.position4 = null;
        }
    }

    private static void drawTexture(GraphicsHolder graphicsHolder, Vector position1, Vector position2, Vector position3, Vector position4, Vector3d offset, int light) {
        IDrawing.drawTexture(graphicsHolder, position1.x, position1.y, position1.z, position2.x, position2.y, position2.z, position3.x, position3.y, position3.z, position4.x, position4.y, position4.z, offset, 0.0f, 0.0f, 1.0f, 1.0f, Direction.UP, -1, light);
    }

    private static <T> void iterateWithIndex(ObjectArrayList<T> list, IndexedConsumer<T> indexedConsumer) {
        for (int i = 0; i < list.size(); ++i) {
            indexedConsumer.accept(i, list.get(i));
        }
    }

    private static double getPositionFromPercentage(double percentage, double min, double max) {
        return min + Math.max(0.0, max - min) * percentage;
    }

    public static class RidingPlayerInterpolation {
        private int ridingCar;
        private double previousX;
        private double previousY;
        private double previousZ;
        public final UUID uuid;
        private final Interpolation interpolationX;
        private final Interpolation interpolationY;
        private final Interpolation interpolationZ;

        public RidingPlayerInterpolation(UUID uuid) {
            this.uuid = uuid;
            this.interpolationX = new Interpolation(1000);
            this.interpolationY = new Interpolation(1000);
            this.interpolationZ = new Interpolation(1000);
        }
    }

    public static class PreviousConnectionPositions {
        private Vector position1;
        private Vector position2;
        private Vector position3;
        private Vector position4;

        private boolean isValid() {
            return this.position1 != null && this.position2 != null && this.position3 != null && this.position4 != null;
        }
    }

    @FunctionalInterface
    private static interface IndexedConsumer<T> {
        public void accept(int var1, T var2);
    }

    private static class PreviousGangwayMovementPositions {
        private GangwayMovementPositions gangwayMovementPositions;

        private PreviousGangwayMovementPositions() {
        }
    }
}

