/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public final class CachedResource<T> {
    @Nullable
    private T data;
    private long expiry;
    private final Supplier<T> dataSupplier;
    private final long lifespan;
    private static boolean canFetchCache;
    private static final ObjectArrayList<CachedResource<?>> CACHED_RESOURCES;

    public CachedResource(Supplier<T> dataSupplier, long lifespan) {
        this.dataSupplier = dataSupplier;
        this.lifespan = lifespan;
        CACHED_RESOURCES.add(this);
    }

    @Nullable
    public T getData(boolean force) {
        if (force || canFetchCache) {
            long currentMillis = System.currentTimeMillis();
            if (this.data == null || currentMillis > this.expiry) {
                this.data = this.dataSupplier.get();
                canFetchCache = false;
            }
            this.expiry = currentMillis + this.lifespan;
        }
        return this.data;
    }

    public static void tick() {
        canFetchCache = true;
        long currentMillis = System.currentTimeMillis();
        CACHED_RESOURCES.forEach((Consumer<CachedResource<?>>)((Consumer<CachedResource>)cachedResource -> {
            if (currentMillis > cachedResource.expiry) {
                cachedResource.data = null;
            }
        }));
    }

    static {
        CACHED_RESOURCES = new ObjectArrayList();
    }
}

