/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import java.util.Objects;
import org.mtr.core.data.Lift;
import org.mtr.core.operation.UpdateDataRequest;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.packet.PacketUpdateData;
import org.mtr.mod.resource.LiftResource;
import org.mtr.mod.screen.DashboardListItem;
import org.mtr.mod.screen.DashboardListSelectorScreen;

public class LiftStyleSelectorScreen
extends DashboardListSelectorScreen {
    private final Lift lift;
    private final ObjectImmutableList<LiftResource> allLifts = CustomResourceLoader.getLifts();

    private LiftStyleSelectorScreen(Lift lift, ObjectImmutableList<DashboardListItem> lifts, LongArrayList selectedLiftIndices, ScreenExtension previousScreenExtension) {
        super(lifts, selectedLiftIndices, true, false, previousScreenExtension);
        this.lift = lift;
    }

    @Override
    public void onClose2() {
        super.onClose2();
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        this.selectedIds.forEach(index -> this.lift.setStyle(this.allLifts.get((int)index).getId()));
        if (clientPlayerEntity != null) {
            InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getInstance()).addLift(this.lift)));
        }
    }

    @Override
    protected void updateList() {
        super.updateList();
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getInstance()).addLift(this.lift)));
    }

    public static LiftStyleSelectorScreen create(Lift lift, ScreenExtension previousScreenExtension) {
        ObjectImmutableList<LiftResource> allLifts = CustomResourceLoader.getLifts();
        ObjectArrayList<DashboardListItem> liftsForList = new ObjectArrayList<DashboardListItem>();
        LongArrayList selectedIds = new LongArrayList();
        for (int i = 0; i < allLifts.size(); ++i) {
            LiftResource liftResource = allLifts.get(i);
            liftsForList.add(new DashboardListItem(i, liftResource.getName(), liftResource.getColor() | 0xFF000000));
            if (!Objects.equals(liftResource.getId(), lift.getStyle())) continue;
            selectedIds.add(i);
        }
        return new LiftStyleSelectorScreen(lift, new ObjectImmutableList<DashboardListItem>((ObjectList<DashboardListItem>)liftsForList), selectedIds, previousScreenExtension);
    }
}

