/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.cache;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.teacon.slides.Slideshow;
import org.teacon.slides.cache.CacheStorage;
import org.teacon.slides.cache.WebpToPng;
import org.teacon.slides.config.Config;
import org.teacon.slides.http.client.cache.HttpCacheContext;
import org.teacon.slides.http.impl.client.cache.CacheConfig;
import org.teacon.slides.http.impl.client.cache.CachingHttpClients;

public final class ImageCache {
    private static final Path LOCAL_CACHE_PATH = Paths.get("slideshow", new String[0]);
    @Nullable
    private static volatile ImageCache sInstance;
    private static final int MAX_CACHE_OBJECT_SIZE = 0x20000000;
    private static final CacheConfig CONFIG;
    private static final String DEFAULT_REFERER = "https://github.com/AIDA64S/Slideshow";
    private static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11";
    private final CloseableHttpClient mHttpClient;
    private final CacheStorage mCacheStorage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageCache getInstance() {
        ImageCache result = sInstance;
        if (result != null) return result;
        Class<ImageCache> clazz = ImageCache.class;
        synchronized (ImageCache.class) {
            result = sInstance;
            if (result != null) return result;
            sInstance = result = new ImageCache(LOCAL_CACHE_PATH);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private ImageCache(Path dir) {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create cache directory for slide images.", e);
        }
        this.mCacheStorage = new CacheStorage(dir);
        this.mHttpClient = Config.isProxySwitch() ? CachingHttpClients.custom().setCacheConfig(CONFIG).setHttpCacheStorage(this.mCacheStorage).setProxy(Config.getPROXY()).build() : CachingHttpClients.custom().setCacheConfig(CONFIG).setHttpCacheStorage(this.mCacheStorage).build();
    }

    @Nonnull
    public CompletableFuture<byte[]> getResource(@Nonnull URI location, boolean online) {
        return CompletableFuture.supplyAsync(() -> {
            HttpCacheContext context = HttpCacheContext.create();
            try {
                CloseableHttpResponse response = this.createResponse(location, context, online);
                try {
                    byte[] byArray = WebpToPng.webpToPng(IOUtils.toByteArray((InputStream)response.getEntity().getContent()));
                    return byArray;
                }
                catch (IOException e) {
                    if (!online) throw new CompletionException(e);
                    Slideshow.LOGGER.warn("Failed to read bytes from remote source.", (Throwable)e);
                    throw new CompletionException(e);
                }
                finally {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            catch (ClientProtocolException protocolError) {
                Slideshow.LOGGER.warn("Detected invalid client protocol.", (Throwable)protocolError);
                throw new CompletionException(protocolError);
            }
            catch (IOException connError) {
                Slideshow.LOGGER.warn("Failed to establish connection.", (Throwable)connError);
                throw new CompletionException(connError);
            }
        });
    }

    private CloseableHttpResponse createResponse(URI location, HttpCacheContext context, boolean online) throws IOException {
        HttpGet request = new HttpGet(location);
        request.addHeader("Referer", DEFAULT_REFERER);
        request.addHeader("User-Agent", DEFAULT_USER_AGENT);
        request.addHeader("Accept", String.join((CharSequence)", ", ImageIO.getReaderMIMETypes()));
        if (!online) {
            request.addHeader("Cache-Control", "max-stale=2147483647");
            request.addHeader("Cache-Control", "only-if-cached");
        } else {
            request.addHeader("Cache-Control", "must-revalidate");
        }
        return this.mHttpClient.execute((HttpUriRequest)request, context);
    }

    public int cleanResources() {
        return this.mCacheStorage.cleanResources();
    }

    static {
        CONFIG = CacheConfig.custom().setMaxObjectSize(0x20000000L).setSharedCache(false).build();
    }
}

