/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4264;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.teacon.slides.packet.UpdatePacket;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.projector.ProjectorContainerMenu;
import org.teacon.slides.renderer.SlideState;
import org.teacon.slides.screen.LazyWidget;
import org.teacon.slides.slide.Slide;

public final class ProjectorScreen
extends class_465<ProjectorContainerMenu> {
    private static final class_2960 GUI_TEXTURE = new class_2960("slide_show", "textures/gui/projector.png");
    private static final int URL_MAX_LENGTH = 512;
    private static final int COLOR_MAX_LENGTH = 8;
    private static final class_2561 IMAGE_TEXT = class_2561.method_43471((String)"gui.slide_show.section.image");
    private static final class_2561 OFFSET_TEXT = class_2561.method_43471((String)"gui.slide_show.section.offset");
    private static final class_2561 OTHERS_TEXT = class_2561.method_43471((String)"gui.slide_show.section.others");
    private static final class_2561 URL_TEXT = class_2561.method_43471((String)"gui.slide_show.url");
    private static final class_2561 COLOR_TEXT = class_2561.method_43471((String)"gui.slide_show.color");
    private static final class_2561 WIDTH_TEXT = class_2561.method_43471((String)"gui.slide_show.width");
    private static final class_2561 HEIGHT_TEXT = class_2561.method_43471((String)"gui.slide_show.height");
    private static final class_2561 KEEP_ASPECT_RATIO_TEXT = class_2561.method_43471((String)"gui.slide_show.keep_aspect_ratio");
    private static final class_2561 OFFSET_X_TEXT = class_2561.method_43471((String)"gui.slide_show.offset_x");
    private static final class_2561 OFFSET_Y_TEXT = class_2561.method_43471((String)"gui.slide_show.offset_y");
    private static final class_2561 OFFSET_Z_TEXT = class_2561.method_43471((String)"gui.slide_show.offset_z");
    private static final class_2561 FLIP_TEXT = class_2561.method_43471((String)"gui.slide_show.flip");
    private static final class_2561 ROTATE_TEXT = class_2561.method_43471((String)"gui.slide_show.rotate");
    private static final class_2561 SINGLE_DOUBLE_SIDED_TEXT = class_2561.method_43471((String)"gui.slide_show.single_double_sided");
    private final LazyWidget<class_342> mURLInput;
    private final LazyWidget<class_342> mColorInput;
    private final LazyWidget<class_342> mWidthInput;
    private final LazyWidget<class_342> mHeightInput;
    private final LazyWidget<class_342> mOffsetXInput;
    private final LazyWidget<class_342> mOffsetYInput;
    private final LazyWidget<class_342> mOffsetZInput;
    private final LazyWidget<Button> mFlipRotation;
    private final LazyWidget<Button> mCycleRotation;
    private final LazyWidget<Button> mSwitchSingleSided;
    private final LazyWidget<Button> mSwitchDoubleSided;
    private final LazyWidget<Button> mKeepAspectChecked;
    private final LazyWidget<Button> mKeepAspectUnchecked;
    private String mImgUrl;
    private int mImageColor;
    private Vector2f mImageSize;
    private Vector3f mImageOffset;
    private boolean mDoubleSided;
    private boolean mKeepAspectRatio;
    private SyncAspectRatio mSyncAspectRatio;
    private ProjectorBlock.InternalRotation mRotation;
    private boolean mInvalidColor;
    private boolean mInvalidWidth;
    private boolean mInvalidHeight;
    private boolean mInvalidOffsetX;
    private boolean mInvalidOffsetY;
    private boolean mInvalidOffsetZ;
    private ImageUrlStatus mImageUrlStatus;
    private final class_2338 blockPos;
    private final ProjectorBlockEntity.ProjectorBlockEntityData data;

    public ProjectorScreen(ProjectorContainerMenu projectorContainerMenu, class_1661 inventory, class_2561 component) {
        super((class_1703)projectorContainerMenu, inventory, component);
        this.field_2792 = 176;
        this.field_2779 = 217;
        this.blockPos = projectorContainerMenu.getBlockPos();
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            throw new RuntimeException("Error! Client level is null!");
        }
        class_2586 blockEntity = level.method_8321(this.blockPos);
        if (blockEntity instanceof ProjectorBlockEntity) {
            ProjectorBlockEntity projectorBlockEntity = (ProjectorBlockEntity)blockEntity;
            this.data = projectorBlockEntity.getProjectorBlockEntityData();
            ProjectorBlock.InternalRotation rotation = (ProjectorBlock.InternalRotation)((Object)projectorBlockEntity.method_11010().method_11654(ProjectorBlock.ROTATION));
            this.mImgUrl = this.data.getLocation();
            this.mImageColor = this.data.getColor();
            this.mImageSize = new Vector2f(this.data.getWidth(), this.data.getHeight());
            this.mImageOffset = new Vector3f(this.data.getOffsetX(), this.data.getOffsetY(), this.data.getOffsetZ());
            this.mDoubleSided = this.data.isDoubleSided();
            this.mKeepAspectRatio = this.data.isKeepAspectRatio();
            this.mSyncAspectRatio = this.mKeepAspectRatio ? SyncAspectRatio.SYNC_WIDTH_WITH_HEIGHT : SyncAspectRatio.SYNCED;
            this.mRotation = rotation;
            this.mInvalidColor = true;
            this.mInvalidWidth = true;
            this.mInvalidHeight = true;
            this.mInvalidOffsetX = true;
            this.mInvalidOffsetY = true;
            this.mInvalidOffsetZ = true;
            this.mImageUrlStatus = ImageUrlStatus.EMPTY;
            this.mURLInput = LazyWidget.of(this.data.getLocation(), class_342::method_1882, value -> {
                class_342 input = new class_342(this.field_22793, this.field_2776 + 30, this.field_2800 + 29, 136, 16, URL_TEXT);
                input.method_1880(512);
                input.method_1863(text -> {
                    this.mImgUrl = text;
                    if (StringUtils.isNotBlank((CharSequence)text)) {
                        this.mImageUrlStatus = SlideState.createURI(this.mImgUrl) != null ? ImageUrlStatus.NORMAL : ImageUrlStatus.INVALID;
                    }
                    input.method_1868(switch (this.mImageUrlStatus) {
                        default -> throw new IncompatibleClassChangeError();
                        case ImageUrlStatus.NORMAL -> 0xE0E0E0;
                        case ImageUrlStatus.INVALID -> 0xFF0000;
                        case ImageUrlStatus.EMPTY -> 0xFFFFFF;
                    });
                });
                input.method_1852(value);
                return input;
            });
            this.mColorInput = LazyWidget.of(String.format("%08X", this.data.getColor()), class_342::method_1882, value -> {
                class_342 input = new class_342(this.field_22793, this.field_2776 + 55, this.field_2800 + 155, 56, 16, COLOR_TEXT);
                input.method_1880(8);
                input.method_1863(text -> {
                    try {
                        this.mImageColor = Integer.parseUnsignedInt(text, 16);
                        this.mInvalidColor = false;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    input.method_1868(this.mInvalidColor ? 14699339 : 0xE0E0E0);
                });
                input.method_1852(value);
                return input;
            });
            this.mWidthInput = LazyWidget.of(ProjectorScreen.toOptionalSignedString(this.data.getWidth()), class_342::method_1882, value -> {
                class_342 input = new class_342(this.field_22793, this.field_2776 + 30, this.field_2800 + 51, 46, 16, WIDTH_TEXT);
                input.method_1863(text -> {
                    try {
                        Vector2f newSize = new Vector2f(ProjectorScreen.parseFloatOrDefault(text, 1.0f), this.mImageSize.y);
                        this.updateOffsetByDimension(newSize);
                        this.mInvalidWidth = false;
                    }
                    catch (Exception e) {
                        this.mInvalidWidth = true;
                    }
                    input.method_1868(this.mInvalidWidth ? 14699339 : 0xE0E0E0);
                    if (!this.mInvalidWidth && this.mKeepAspectRatio) {
                        this.mSyncAspectRatio = SyncAspectRatio.SYNC_HEIGHT_WITH_WIDTH;
                    }
                });
                input.method_1852(value);
                return input;
            });
            this.mHeightInput = LazyWidget.of(ProjectorScreen.toOptionalSignedString(this.data.getHeight()), class_342::method_1882, value -> {
                class_342 input = new class_342(this.field_22793, this.field_2776 + 100, this.field_2800 + 51, 46, 16, HEIGHT_TEXT);
                input.method_1863(text -> {
                    try {
                        Vector2f newSize = new Vector2f(this.mImageSize.x, ProjectorScreen.parseFloatOrDefault(text, 1.0f));
                        this.updateOffsetByDimension(newSize);
                        this.mInvalidHeight = false;
                    }
                    catch (Exception e) {
                        this.mInvalidHeight = true;
                    }
                    input.method_1868(this.mInvalidHeight ? 14699339 : 0xE0E0E0);
                    if (!this.mInvalidHeight && this.mKeepAspectRatio) {
                        this.mSyncAspectRatio = SyncAspectRatio.SYNC_WIDTH_WITH_HEIGHT;
                    }
                });
                input.method_1852(value);
                return input;
            });
            this.mOffsetXInput = LazyWidget.of(ProjectorScreen.toSignedString(this.data.getOffsetX()), class_342::method_1882, value -> {
                class_342 input = new class_342(this.field_22793, this.field_2776 + 30, this.field_2800 + 103, 29, 16, OFFSET_X_TEXT);
                input.method_1863(text -> {
                    try {
                        this.mImageOffset = new Vector3f(ProjectorScreen.parseFloatOrDefault(text, 0.0f), this.mImageOffset.y(), this.mImageOffset.z());
                        this.mInvalidOffsetX = false;
                    }
                    catch (Exception e) {
                        this.mInvalidOffsetX = true;
                    }
                    input.method_1868(this.mInvalidOffsetX ? 14699339 : 0xE0E0E0);
                });
                input.method_1852(value);
                return input;
            });
            this.mOffsetYInput = LazyWidget.of(ProjectorScreen.toSignedString(this.data.getOffsetY()), class_342::method_1882, value -> {
                class_342 input = new class_342(this.field_22793, this.field_2776 + 84, this.field_2800 + 103, 29, 16, OFFSET_Y_TEXT);
                input.method_1863(text -> {
                    try {
                        this.mImageOffset = new Vector3f(this.mImageOffset.x(), ProjectorScreen.parseFloatOrDefault(text, 0.0f), this.mImageOffset.z());
                        this.mInvalidOffsetY = false;
                    }
                    catch (Exception e) {
                        this.mInvalidOffsetY = true;
                    }
                    input.method_1868(this.mInvalidOffsetY ? 14699339 : 0xE0E0E0);
                });
                input.method_1852(value);
                return input;
            });
            this.mOffsetZInput = LazyWidget.of(ProjectorScreen.toSignedString(this.data.getOffsetZ()), class_342::method_1882, value -> {
                class_342 input = new class_342(this.field_22793, this.field_2776 + 138, this.field_2800 + 103, 29, 16, OFFSET_Z_TEXT);
                input.method_1863(text -> {
                    try {
                        this.mImageOffset = new Vector3f(this.mImageOffset.x(), this.mImageOffset.y(), ProjectorScreen.parseFloatOrDefault(text, 1.0f));
                        this.mInvalidOffsetZ = false;
                    }
                    catch (Exception e) {
                        this.mInvalidOffsetZ = true;
                    }
                    input.method_1868(this.mInvalidOffsetZ ? 14699339 : 0xE0E0E0);
                });
                input.method_1852(value);
                return input;
            });
            this.mFlipRotation = LazyWidget.of(true, b -> b.field_22764, value -> {
                Button button = new Button(this.field_2776 + 117, this.field_2800 + 153, 179, 153, 18, 19, FLIP_TEXT, () -> {
                    ProjectorBlock.InternalRotation newRotation = this.mRotation.flip();
                    this.updateOffsetByRotation(newRotation);
                });
                button.field_22764 = value;
                return button;
            });
            this.mCycleRotation = LazyWidget.of(true, b -> b.field_22764, value -> {
                Button button = new Button(this.field_2776 + 142, this.field_2800 + 153, 179, 173, 18, 19, ROTATE_TEXT, () -> {
                    ProjectorBlock.InternalRotation newRotation = this.mRotation.compose(class_2470.field_11463);
                    this.updateOffsetByRotation(newRotation);
                });
                button.field_22764 = value;
                return button;
            });
            this.mSwitchSingleSided = LazyWidget.of(this.data.isDoubleSided(), b -> b.field_22764, value -> {
                Button button = new Button(this.field_2776 + 9, this.field_2800 + 153, 179, 113, 18, 19, SINGLE_DOUBLE_SIDED_TEXT, () -> {
                    if (this.mDoubleSided) {
                        this.updateDoubleSided(false);
                    }
                });
                button.field_22764 = value;
                return button;
            });
            this.mSwitchDoubleSided = LazyWidget.of(!this.data.isDoubleSided(), b -> b.field_22764, value -> {
                Button button = new Button(this.field_2776 + 9, this.field_2800 + 153, 179, 133, 18, 19, SINGLE_DOUBLE_SIDED_TEXT, () -> {
                    if (!this.mDoubleSided) {
                        this.updateDoubleSided(true);
                    }
                });
                button.field_22764 = value;
                return button;
            });
            this.mKeepAspectChecked = LazyWidget.of(this.mKeepAspectRatio, b -> b.field_22764, value -> {
                Button button = new Button(this.field_2776 + 149, this.field_2800 + 49, 179, 93, 18, 19, KEEP_ASPECT_RATIO_TEXT, () -> {
                    if (this.mKeepAspectRatio) {
                        this.updateKeepAspectRatio(false);
                    }
                });
                button.field_22764 = value;
                return button;
            });
            this.mKeepAspectUnchecked = LazyWidget.of(!this.mKeepAspectRatio, b -> b.field_22764, value -> {
                Button button = new Button(this.field_2776 + 149, this.field_2800 + 49, 179, 73, 18, 19, KEEP_ASPECT_RATIO_TEXT, () -> {
                    if (!this.mKeepAspectRatio) {
                        this.updateKeepAspectRatio(true);
                    }
                });
                button.field_22764 = value;
                return button;
            });
            return;
        }
        this.data = null;
        Object rotation = null;
        this.mURLInput = null;
        this.mColorInput = null;
        this.mWidthInput = null;
        this.mHeightInput = null;
        this.mOffsetXInput = null;
        this.mOffsetYInput = null;
        this.mOffsetZInput = null;
        this.mFlipRotation = null;
        this.mCycleRotation = null;
        this.mSwitchSingleSided = null;
        this.mSwitchDoubleSided = null;
        this.mKeepAspectChecked = null;
        this.mKeepAspectUnchecked = null;
    }

    public void method_25426() {
        super.method_25426();
        if (this.data != null) {
            this.method_37063((class_364)this.mURLInput.refresh());
            this.method_37063((class_364)this.mColorInput.refresh());
            this.method_37063((class_364)this.mWidthInput.refresh());
            this.method_37063((class_364)this.mHeightInput.refresh());
            this.method_37063((class_364)this.mOffsetXInput.refresh());
            this.method_37063((class_364)this.mOffsetYInput.refresh());
            this.method_37063((class_364)this.mOffsetZInput.refresh());
            this.method_37063((class_364)this.mFlipRotation.refresh());
            this.method_37063((class_364)this.mCycleRotation.refresh());
            this.method_37063((class_364)this.mSwitchSingleSided.refresh());
            this.method_37063((class_364)this.mSwitchDoubleSided.refresh());
            this.method_37063((class_364)this.mKeepAspectChecked.refresh());
            this.method_37063((class_364)this.mKeepAspectUnchecked.refresh());
            this.method_48265((class_364)this.mURLInput.get());
        }
    }

    protected void method_37432() {
        if (!(this.data == null || this.mURLInput.get().method_25370() || this.mSyncAspectRatio == SyncAspectRatio.SYNCED || this.mInvalidWidth || this.mInvalidHeight)) {
            float aspect;
            Slide slide = SlideState.getSlide(this.data.getLocation());
            float f = aspect = slide == null ? Float.NaN : slide.getImageAspectRatio();
            if (!Float.isNaN(aspect)) {
                if (this.mSyncAspectRatio == SyncAspectRatio.SYNC_WIDTH_WITH_HEIGHT) {
                    Vector2f newSizeByHeight = new Vector2f(this.mImageSize.y * aspect, this.mImageSize.y);
                    this.updateOffsetByDimension(newSizeByHeight);
                    if (!this.mWidthInput.get().method_25370()) {
                        this.mWidthInput.get().method_1852(ProjectorScreen.toOptionalSignedString(newSizeByHeight.x()));
                    }
                }
                if (this.mSyncAspectRatio == SyncAspectRatio.SYNC_HEIGHT_WITH_WIDTH) {
                    Vector2f newSizeByWidth = new Vector2f(this.mImageSize.x, this.mImageSize.x / aspect);
                    this.updateOffsetByDimension(newSizeByWidth);
                    if (!this.mHeightInput.get().method_25370()) {
                        this.mHeightInput.get().method_1852(ProjectorScreen.toOptionalSignedString(newSizeByWidth.y()));
                    }
                }
                this.mSyncAspectRatio = SyncAspectRatio.SYNCED;
            }
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifier) {
        if (this.data != null) {
            boolean isEscape = false;
            if (keyCode == 256) {
                Objects.requireNonNull(Objects.requireNonNull(this.field_22787).field_1724).method_7346();
                isEscape = true;
            }
            return isEscape || this.mURLInput.get().method_25404(keyCode, scanCode, modifier) || this.mURLInput.get().method_20315() || this.mColorInput.get().method_25404(keyCode, scanCode, modifier) || this.mColorInput.get().method_20315() || this.mWidthInput.get().method_25404(keyCode, scanCode, modifier) || this.mWidthInput.get().method_20315() || this.mHeightInput.get().method_25404(keyCode, scanCode, modifier) || this.mHeightInput.get().method_20315() || this.mOffsetXInput.get().method_25404(keyCode, scanCode, modifier) || this.mOffsetXInput.get().method_20315() || this.mOffsetYInput.get().method_25404(keyCode, scanCode, modifier) || this.mOffsetYInput.get().method_20315() || this.mOffsetZInput.get().method_25404(keyCode, scanCode, modifier) || this.mOffsetZInput.get().method_20315() || super.method_25404(keyCode, scanCode, modifier);
        }
        return super.method_25404(keyCode, scanCode, modifier);
    }

    public void method_2389(class_332 gui, float partialTicks, int mouseX, int mouseY) {
        if (this.data != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)GUI_TEXTURE);
            gui.method_25302(GUI_TEXTURE, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
            if (this.mImageUrlStatus == ImageUrlStatus.INVALID) {
                gui.method_25302(GUI_TEXTURE, this.field_2776 + 9, this.field_2800 + 27, 179, 53, 18, 19);
            }
        }
    }

    public void method_2388(@Nonnull class_332 gui, int mouseX, int mouseY) {
        if (this.data != null) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderTexture((int)0, (class_2960)GUI_TEXTURE);
            int alpha = this.mImageColor >>> 24;
            if (alpha > 0) {
                int red = this.mImageColor >> 16 & 0xFF;
                int green = this.mImageColor >> 8 & 0xFF;
                int blue = this.mImageColor & 0xFF;
                RenderSystem.setShaderColor((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)((float)alpha / 255.0f));
                gui.method_25302(GUI_TEXTURE, 38, 157, 180, 194, 10, 10);
                gui.method_25302(GUI_TEXTURE, 82, 185, 180, 194, 17, 17);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.method_25302(GUI_TEXTURE, 82, 185, 202, 194 - this.mRotation.ordinal() * 20, 17, 17);
            ProjectorScreen.drawCenteredStringWithoutShadow(gui, this.field_22793, IMAGE_TEXT, 12);
            ProjectorScreen.drawCenteredStringWithoutShadow(gui, this.field_22793, OFFSET_TEXT, 86);
            ProjectorScreen.drawCenteredStringWithoutShadow(gui, this.field_22793, OTHERS_TEXT, 138);
            int offsetX = mouseX - this.field_2776;
            int offsetY = mouseY - this.field_2800;
            if (offsetX >= 9 && offsetY >= 27 && offsetX < 27 && offsetY < 46) {
                gui.method_51438(this.field_22793, URL_TEXT, offsetX, offsetY);
            } else if (offsetX >= 34 && offsetY >= 153 && offsetX < 52 && offsetY < 172) {
                gui.method_51438(this.field_22793, COLOR_TEXT, offsetX, offsetY);
            } else if (offsetX >= 9 && offsetY >= 49 && offsetX < 27 && offsetY < 68) {
                gui.method_51438(this.field_22793, WIDTH_TEXT, offsetX, offsetY);
            } else if (offsetX >= 79 && offsetY >= 49 && offsetX < 97 && offsetY < 68) {
                gui.method_51438(this.field_22793, HEIGHT_TEXT, offsetX, offsetY);
            } else if (offsetX >= 149 && offsetY >= 49 && offsetX < 167 && offsetY < 68) {
                gui.method_51438(this.field_22793, KEEP_ASPECT_RATIO_TEXT, offsetX, offsetY);
            } else if (offsetX >= 9 && offsetY >= 101 && offsetX < 27 && offsetY < 120) {
                gui.method_51438(this.field_22793, OFFSET_X_TEXT, offsetX, offsetY);
            } else if (offsetX >= 63 && offsetY >= 101 && offsetX < 81 && offsetY < 120) {
                gui.method_51438(this.field_22793, OFFSET_Y_TEXT, offsetX, offsetY);
            } else if (offsetX >= 117 && offsetY >= 101 && offsetX < 135 && offsetY < 120) {
                gui.method_51438(this.field_22793, OFFSET_Z_TEXT, offsetX, offsetY);
            } else if (offsetX >= 117 && offsetY >= 153 && offsetX < 135 && offsetY < 172) {
                gui.method_51438(this.field_22793, FLIP_TEXT, offsetX, offsetY);
            } else if (offsetX >= 142 && offsetY >= 153 && offsetX < 160 && offsetY < 172) {
                gui.method_51438(this.field_22793, ROTATE_TEXT, offsetX, offsetY);
            } else if (offsetX >= 9 && offsetY >= 153 && offsetX < 27 && offsetY < 172) {
                gui.method_51438(this.field_22793, SINGLE_DOUBLE_SIDED_TEXT, offsetX, offsetY);
            }
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.data != null) {
            if (this.mWidthInput.get().method_25405(mouseX, mouseY)) {
                if (!this.mInvalidWidth) {
                    this.mWidthInput.get().method_1852(ProjectorScreen.toOptionalSignedString((float)Math.round((double)this.mImageSize.x * 2.0 + scrollY) * 0.5f));
                    if (this.mKeepAspectRatio) {
                        this.mSyncAspectRatio = SyncAspectRatio.SYNC_HEIGHT_WITH_WIDTH;
                    }
                    return true;
                }
            } else if (this.mHeightInput.get().method_25405(mouseX, mouseY) && !this.mInvalidHeight) {
                this.mHeightInput.get().method_1852(ProjectorScreen.toOptionalSignedString((float)Math.round((double)this.mImageSize.y * 2.0 + scrollY) * 0.5f));
                if (this.mKeepAspectRatio) {
                    this.mSyncAspectRatio = SyncAspectRatio.SYNC_WIDTH_WITH_HEIGHT;
                }
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public void method_25432() {
        super.method_25432();
        if (this.data != null) {
            class_2586 class_25862;
            ProjectorBlockEntity.ProjectorBlockEntityData networkData = this.data.copy();
            if (this.mImageUrlStatus == ImageUrlStatus.NORMAL) {
                networkData.setLocation(this.mImgUrl);
            }
            if (!this.mInvalidColor) {
                networkData.setColor(this.mImageColor);
            }
            if (!this.mInvalidWidth) {
                networkData.setWidth(this.mImageSize.x());
            }
            if (!this.mInvalidHeight) {
                networkData.setHeight(this.mImageSize.y());
            }
            if (!this.mInvalidOffsetX) {
                networkData.setOffsetX(this.mImageOffset.x());
            }
            if (!this.mInvalidOffsetY) {
                networkData.setOffsetY(this.mImageOffset.y());
            }
            if (!this.mInvalidOffsetZ) {
                networkData.setOffsetZ(this.mImageOffset.z());
            }
            networkData.setDoubleSided(this.mDoubleSided);
            networkData.setKeepAspectRatio(this.mKeepAspectRatio);
            class_638 level = class_310.method_1551().field_1687;
            if (level != null && (class_25862 = level.method_8321(this.blockPos)) instanceof ProjectorBlockEntity) {
                ProjectorBlockEntity blockEntity = (ProjectorBlockEntity)class_25862;
                blockEntity.setProjectorBlockEntityData(networkData);
                class_2680 blockState = (class_2680)blockEntity.method_11010().method_11657(ProjectorBlock.ROTATION, (Comparable)((Object)this.mRotation));
                level.method_8652(this.blockPos, blockState, 4);
            }
            new UpdatePacket(this.blockPos, networkData, this.mRotation).sendToServer();
        }
    }

    private void updateOffsetByRotation(ProjectorBlock.InternalRotation newRotation) {
        if (!(this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ)) {
            Vector3f absolute = ProjectorScreen.relativeToAbsolute(this.mImageOffset, this.mImageSize, this.mRotation);
            Vector3f newRelative = ProjectorScreen.absoluteToRelative(absolute, this.mImageSize, newRotation);
            this.mOffsetXInput.get().method_1852(ProjectorScreen.toSignedString(newRelative.x()));
            this.mOffsetYInput.get().method_1852(ProjectorScreen.toSignedString(newRelative.y()));
            this.mOffsetZInput.get().method_1852(ProjectorScreen.toSignedString(newRelative.z()));
        }
        this.mRotation = newRotation;
    }

    private void updateOffsetByDimension(Vector2f newDimension) {
        if (!(this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ)) {
            Vector3f absolute = ProjectorScreen.relativeToAbsolute(this.mImageOffset, this.mImageSize, this.mRotation);
            Vector3f newRelative = ProjectorScreen.absoluteToRelative(absolute, newDimension, this.mRotation);
            this.mOffsetXInput.get().method_1852(ProjectorScreen.toSignedString(newRelative.x()));
            this.mOffsetYInput.get().method_1852(ProjectorScreen.toSignedString(newRelative.y()));
            this.mOffsetZInput.get().method_1852(ProjectorScreen.toSignedString(newRelative.z()));
        }
        this.mImageSize = newDimension;
    }

    private void updateDoubleSided(boolean doubleSided) {
        this.mDoubleSided = doubleSided;
        this.mSwitchSingleSided.get().field_22764 = doubleSided;
        this.mSwitchDoubleSided.get().field_22764 = !doubleSided;
    }

    private void updateKeepAspectRatio(boolean keepAspectRatio) {
        this.mKeepAspectRatio = keepAspectRatio;
        this.mKeepAspectUnchecked.get().field_22764 = !keepAspectRatio;
        this.mKeepAspectChecked.get().field_22764 = keepAspectRatio;
        this.mSyncAspectRatio = this.mKeepAspectRatio ? SyncAspectRatio.SYNC_WIDTH_WITH_HEIGHT : SyncAspectRatio.SYNCED;
    }

    private static void drawCenteredStringWithoutShadow(class_332 gui, class_327 renderer, class_2561 string, int y) {
        gui.method_51433(renderer, string.getString(), 88 - renderer.method_27525((class_5348)string) / 2, y, 0x404040, false);
    }

    private static float parseFloatOrDefault(String text, float defaultValue) {
        try {
            return Float.parseFloat(text);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static String toOptionalSignedString(float f) {
        return Float.toString((float)Math.round(f * 1000.0f) / 1000.0f);
    }

    private static String toSignedString(float f) {
        return Float.isNaN(f) ? String.valueOf(f) : (Math.copySign(1.0f, f) <= 0.0f ? "-" + (float)Math.round(0.0f - f * 1000.0f) / 1000.0f : "+" + (float)Math.round(f * 1000.0f) / 1000.0f);
    }

    private static Vector3f relativeToAbsolute(Vector3f relatedOffset, Vector2f size, ProjectorBlock.InternalRotation rotation) {
        Vector4f center = new Vector4f(0.5f * size.x, 0.0f, 0.5f * size.y, 1.0f);
        center.mul((Matrix4fc)new Matrix4f().translate(relatedOffset.x(), -relatedOffset.z(), relatedOffset.y()));
        center.mul((Matrix4fc)new Matrix4f().translate(-0.5f, 0.0f, 0.5f - size.y()));
        rotation.transform(center);
        return new Vector3f(center.x() / center.w(), center.y() / center.w(), center.z() / center.w());
    }

    private static Vector3f absoluteToRelative(Vector3f absoluteOffset, Vector2f size, ProjectorBlock.InternalRotation rotation) {
        Vector4f center = new Vector4f((Vector3fc)absoluteOffset, 1.0f);
        rotation.invert().transform(center);
        center.mul((Matrix4fc)new Matrix4f().translate(0.5f, 0.0f, -0.5f + size.y()));
        center.mul((Matrix4fc)new Matrix4f().translate(-0.5f * size.x, 0.0f, -0.5f * size.y));
        return new Vector3f(center.x() / center.w(), center.z() / center.w(), -center.y() / center.w());
    }

    private static enum SyncAspectRatio {
        SYNCED,
        SYNC_WIDTH_WITH_HEIGHT,
        SYNC_HEIGHT_WITH_WIDTH;

    }

    private static enum ImageUrlStatus {
        NORMAL,
        INVALID,
        EMPTY;

    }

    private static class Button
    extends class_4264 {
        private final Runnable callback;
        private final class_2561 msg;
        private final int u;
        private final int v;

        public Button(int x, int y, int u, int v, int width, int height, class_2561 msg, Runnable callback) {
            super(x, y, width, height, msg);
            this.callback = callback;
            this.msg = msg;
            this.u = u;
            this.v = v;
        }

        public void method_25306() {
            this.callback.run();
        }

        public void method_48579(class_332 gui, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
            gui.method_25302(GUI_TEXTURE, this.method_46426(), this.method_46427(), this.u, this.v, this.field_22758, this.field_22759);
        }

        protected void method_47399(class_6382 output) {
            output.method_37034(class_6381.field_33788, this.msg);
        }
    }
}

