/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.system.MemoryUtil;
import org.teacon.slides.renderer.SlideRenderType;
import org.teacon.slides.texture.GIFDecoder;
import org.teacon.slides.texture.LZWDecoder;
import org.teacon.slides.texture.TextureProvider;

public final class AnimatedTextureProvider
implements TextureProvider {
    private static final LZWDecoder gRenderThreadDecoder = new LZWDecoder();
    private final GIFDecoder mDecoder;
    private int mTexture;
    private final SlideRenderType mRenderType;
    private long mFrameStartTime;
    private long mFrameDelayTime;
    @Nullable
    private ByteBuffer mFrame;

    public AnimatedTextureProvider(byte[] data) {
        try {
            this.mDecoder = new GIFDecoder(ByteBuffer.wrap(data), gRenderThreadDecoder);
            int width = this.mDecoder.getScreenWidth();
            int height = this.mDecoder.getScreenHeight();
            if (width > Integer.MAX_VALUE || height > Integer.MAX_VALUE) {
                throw new IOException("Image is too big: " + width + "x" + height);
            }
            this.mFrame = MemoryUtil.memAlloc((int)(width * height * 4));
            this.mFrameDelayTime = this.mDecoder.decodeNextFrame(this.mFrame);
            this.mTexture = GlStateManager._genTexture();
            GlStateManager._bindTexture((int)this.mTexture);
            GL11C.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11C.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11C.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11C.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL11C.glPixelStorei((int)3314, (int)0);
            GL11C.glPixelStorei((int)3316, (int)0);
            GL11C.glPixelStorei((int)3315, (int)0);
            GL11C.glPixelStorei((int)3317, (int)1);
            GL11C.glTexImage2D((int)3553, (int)0, (int)32856, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)this.mFrame.rewind());
            this.mRenderType = new SlideRenderType(this.mTexture);
        }
        catch (Throwable t) {
            this.close();
            throw new CompletionException(t);
        }
    }

    @Override
    @Nonnull
    public SlideRenderType updateAndGet(long tick, float partialTick) {
        long timeMillis = (long)(((float)tick + partialTick) * 50.0f);
        if (this.mFrameStartTime == 0L) {
            this.mFrameStartTime = timeMillis;
        } else if (this.mFrameStartTime + this.mFrameDelayTime <= timeMillis) {
            try {
                int width = this.getWidth();
                int height = this.getHeight();
                assert (this.mFrame != null);
                this.mFrameDelayTime = this.mDecoder.decodeNextFrame(this.mFrame);
                GlStateManager._bindTexture((int)this.mTexture);
                GL11C.glPixelStorei((int)3314, (int)0);
                GL11C.glPixelStorei((int)3316, (int)0);
                GL11C.glPixelStorei((int)3315, (int)0);
                GL11C.glPixelStorei((int)3317, (int)1);
                GL11C.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (ByteBuffer)this.mFrame.rewind());
            }
            catch (Exception e) {
                this.mFrameDelayTime = Integer.MAX_VALUE;
            }
            this.mFrameStartTime = timeMillis;
        }
        return this.mRenderType;
    }

    @Override
    public int getWidth() {
        return this.mDecoder.getScreenWidth();
    }

    @Override
    public int getHeight() {
        return this.mDecoder.getScreenHeight();
    }

    @Override
    public void close() {
        if (this.mTexture != 0) {
            GlStateManager._deleteTexture((int)this.mTexture);
        }
        this.mTexture = 0;
        MemoryUtil.memFree((Buffer)this.mFrame);
        this.mFrame = null;
    }
}

