// This file is auto-generated by @hey-api/openapi-ts

import type { Options as ClientOptions, TDataShape, Client } from "./client/index.js"
import type {
  GlobalEventData,
  GlobalEventResponses,
  ProjectListData,
  ProjectListResponses,
  ProjectCurrentData,
  ProjectCurrentResponses,
  PtyListData,
  PtyListResponses,
  PtyCreateData,
  PtyCreateResponses,
  PtyCreateErrors,
  PtyRemoveData,
  PtyRemoveResponses,
  PtyRemoveErrors,
  PtyGetData,
  PtyGetResponses,
  PtyGetErrors,
  PtyUpdateData,
  PtyUpdateResponses,
  PtyUpdateErrors,
  PtyConnectData,
  PtyConnectResponses,
  PtyConnectErrors,
  ConfigGetData,
  ConfigGetResponses,
  ConfigUpdateData,
  ConfigUpdateResponses,
  ConfigUpdateErrors,
  ToolIdsData,
  ToolIdsResponses,
  ToolIdsErrors,
  ToolListData,
  ToolListResponses,
  ToolListErrors,
  InstanceDisposeData,
  InstanceDisposeResponses,
  PathGetData,
  PathGetResponses,
  VcsGetData,
  VcsGetResponses,
  SessionListData,
  SessionListResponses,
  SessionCreateData,
  SessionCreateResponses,
  SessionCreateErrors,
  SessionStatusData,
  SessionStatusResponses,
  SessionStatusErrors,
  SessionDeleteData,
  SessionDeleteResponses,
  SessionDeleteErrors,
  SessionGetData,
  SessionGetResponses,
  SessionGetErrors,
  SessionUpdateData,
  SessionUpdateResponses,
  SessionUpdateErrors,
  SessionChildrenData,
  SessionChildrenResponses,
  SessionChildrenErrors,
  SessionTodoData,
  SessionTodoResponses,
  SessionTodoErrors,
  SessionInitData,
  SessionInitResponses,
  SessionInitErrors,
  SessionForkData,
  SessionForkResponses,
  SessionAbortData,
  SessionAbortResponses,
  SessionAbortErrors,
  SessionUnshareData,
  SessionUnshareResponses,
  SessionUnshareErrors,
  SessionShareData,
  SessionShareResponses,
  SessionShareErrors,
  SessionDiffData,
  SessionDiffResponses,
  SessionDiffErrors,
  SessionSummarizeData,
  SessionSummarizeResponses,
  SessionSummarizeErrors,
  SessionMessagesData,
  SessionMessagesResponses,
  SessionMessagesErrors,
  SessionPromptData,
  SessionPromptResponses,
  SessionPromptErrors,
  SessionMessageData,
  SessionMessageResponses,
  SessionMessageErrors,
  SessionPromptAsyncData,
  SessionPromptAsyncResponses,
  SessionPromptAsyncErrors,
  SessionCommandData,
  SessionCommandResponses,
  SessionCommandErrors,
  SessionShellData,
  SessionShellResponses,
  SessionShellErrors,
  SessionRevertData,
  SessionRevertResponses,
  SessionRevertErrors,
  SessionUnrevertData,
  SessionUnrevertResponses,
  SessionUnrevertErrors,
  PostSessionIdPermissionsPermissionIdData,
  PostSessionIdPermissionsPermissionIdResponses,
  PostSessionIdPermissionsPermissionIdErrors,
  CommandListData,
  CommandListResponses,
  ConfigProvidersData,
  ConfigProvidersResponses,
  ProviderListData,
  ProviderListResponses,
  ProviderAuthData,
  ProviderAuthResponses,
  ProviderOauthAuthorizeData,
  ProviderOauthAuthorizeResponses,
  ProviderOauthAuthorizeErrors,
  ProviderOauthCallbackData,
  ProviderOauthCallbackResponses,
  ProviderOauthCallbackErrors,
  FindTextData,
  FindTextResponses,
  FindFilesData,
  FindFilesResponses,
  FindSymbolsData,
  FindSymbolsResponses,
  FileListData,
  FileListResponses,
  FileReadData,
  FileReadResponses,
  FileStatusData,
  FileStatusResponses,
  AppLogData,
  AppLogResponses,
  AppLogErrors,
  AppAgentsData,
  AppAgentsResponses,
  McpStatusData,
  McpStatusResponses,
  McpAddData,
  McpAddResponses,
  McpAddErrors,
  McpAuthRemoveData,
  McpAuthRemoveResponses,
  McpAuthRemoveErrors,
  McpAuthStartData,
  McpAuthStartResponses,
  McpAuthStartErrors,
  McpAuthCallbackData,
  McpAuthCallbackResponses,
  McpAuthCallbackErrors,
  McpAuthAuthenticateData,
  McpAuthAuthenticateResponses,
  McpAuthAuthenticateErrors,
  McpConnectData,
  McpConnectResponses,
  McpDisconnectData,
  McpDisconnectResponses,
  LspStatusData,
  LspStatusResponses,
  FormatterStatusData,
  FormatterStatusResponses,
  TuiAppendPromptData,
  TuiAppendPromptResponses,
  TuiAppendPromptErrors,
  TuiOpenHelpData,
  TuiOpenHelpResponses,
  TuiOpenSessionsData,
  TuiOpenSessionsResponses,
  TuiOpenThemesData,
  TuiOpenThemesResponses,
  TuiOpenModelsData,
  TuiOpenModelsResponses,
  TuiSubmitPromptData,
  TuiSubmitPromptResponses,
  TuiClearPromptData,
  TuiClearPromptResponses,
  TuiExecuteCommandData,
  TuiExecuteCommandResponses,
  TuiExecuteCommandErrors,
  TuiShowToastData,
  TuiShowToastResponses,
  TuiPublishData,
  TuiPublishResponses,
  TuiPublishErrors,
  TuiControlNextData,
  TuiControlNextResponses,
  TuiControlResponseData,
  TuiControlResponseResponses,
  AuthSetData,
  AuthSetResponses,
  AuthSetErrors,
  EventSubscribeData,
  EventSubscribeResponses,
} from "./types.gen.js"
import { client as _heyApiClient } from "./client.gen.js"

export type Options<TData extends TDataShape = TDataShape, ThrowOnError extends boolean = boolean> = ClientOptions<
  TData,
  ThrowOnError
> & {
  /**
   * You can provide a client instance returned by `createClient()` instead of
   * individual options. This might be also useful if you want to implement a
   * custom client.
   */
  client?: Client
  /**
   * You can pass arbitrary values through the `meta` object. This can be
   * used to access values that aren't defined as part of the SDK function.
   */
  meta?: Record<string, unknown>
}

class _HeyApiClient {
  protected _client: Client = _heyApiClient

  constructor(args?: { client?: Client }) {
    if (args?.client) {
      this._client = args.client
    }
  }
}

class Global extends _HeyApiClient {
  /**
   * Get events
   */
  public event<ThrowOnError extends boolean = false>(options?: Options<GlobalEventData, ThrowOnError>) {
    return (options?.client ?? this._client).get.sse<GlobalEventResponses, unknown, ThrowOnError>({
      url: "/global/event",
      ...options,
    })
  }
}

class Project extends _HeyApiClient {
  /**
   * List all projects
   */
  public list<ThrowOnError extends boolean = false>(options?: Options<ProjectListData, ThrowOnError>) {
    return (options?.client ?? this._client).get<ProjectListResponses, unknown, ThrowOnError>({
      url: "/project",
      ...options,
    })
  }

  /**
   * Get the current project
   */
  public current<ThrowOnError extends boolean = false>(options?: Options<ProjectCurrentData, ThrowOnError>) {
    return (options?.client ?? this._client).get<ProjectCurrentResponses, unknown, ThrowOnError>({
      url: "/project/current",
      ...options,
    })
  }
}

class Pty extends _HeyApiClient {
  /**
   * List all PTY sessions
   */
  public list<ThrowOnError extends boolean = false>(options?: Options<PtyListData, ThrowOnError>) {
    return (options?.client ?? this._client).get<PtyListResponses, unknown, ThrowOnError>({
      url: "/pty",
      ...options,
    })
  }

  /**
   * Create a new PTY session
   */
  public create<ThrowOnError extends boolean = false>(options?: Options<PtyCreateData, ThrowOnError>) {
    return (options?.client ?? this._client).post<PtyCreateResponses, PtyCreateErrors, ThrowOnError>({
      url: "/pty",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
      },
    })
  }

  /**
   * Remove a PTY session
   */
  public remove<ThrowOnError extends boolean = false>(options: Options<PtyRemoveData, ThrowOnError>) {
    return (options.client ?? this._client).delete<PtyRemoveResponses, PtyRemoveErrors, ThrowOnError>({
      url: "/pty/{id}",
      ...options,
    })
  }

  /**
   * Get PTY session info
   */
  public get<ThrowOnError extends boolean = false>(options: Options<PtyGetData, ThrowOnError>) {
    return (options.client ?? this._client).get<PtyGetResponses, PtyGetErrors, ThrowOnError>({
      url: "/pty/{id}",
      ...options,
    })
  }

  /**
   * Update PTY session
   */
  public update<ThrowOnError extends boolean = false>(options: Options<PtyUpdateData, ThrowOnError>) {
    return (options.client ?? this._client).put<PtyUpdateResponses, PtyUpdateErrors, ThrowOnError>({
      url: "/pty/{id}",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options.headers,
      },
    })
  }

  /**
   * Connect to a PTY session
   */
  public connect<ThrowOnError extends boolean = false>(options: Options<PtyConnectData, ThrowOnError>) {
    return (options.client ?? this._client).get<PtyConnectResponses, PtyConnectErrors, ThrowOnError>({
      url: "/pty/{id}/connect",
      ...options,
    })
  }
}

class Config extends _HeyApiClient {
  /**
   * Get config info
   */
  public get<ThrowOnError extends boolean = false>(options?: Options<ConfigGetData, ThrowOnError>) {
    return (options?.client ?? this._client).get<ConfigGetResponses, unknown, ThrowOnError>({
      url: "/config",
      ...options,
    })
  }

  /**
   * Update config
   */
  public update<ThrowOnError extends boolean = false>(options?: Options<ConfigUpdateData, ThrowOnError>) {
    return (options?.client ?? this._client).patch<ConfigUpdateResponses, ConfigUpdateErrors, ThrowOnError>({
      url: "/config",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
      },
    })
  }

  /**
   * List all providers
   */
  public providers<ThrowOnError extends boolean = false>(options?: Options<ConfigProvidersData, ThrowOnError>) {
    return (options?.client ?? this._client).get<ConfigProvidersResponses, unknown, ThrowOnError>({
      url: "/config/providers",
      ...options,
    })
  }
}

class Tool extends _HeyApiClient {
  /**
   * List all tool IDs (including built-in and dynamically registered)
   */
  public ids<ThrowOnError extends boolean = false>(options?: Options<ToolIdsData, ThrowOnError>) {
    return (options?.client ?? this._client).get<ToolIdsResponses, ToolIdsErrors, ThrowOnError>({
      url: "/experimental/tool/ids",
      ...options,
    })
  }

  /**
   * List tools with JSON schema parameters for a provider/model
   */
  public list<ThrowOnError extends boolean = false>(options: Options<ToolListData, ThrowOnError>) {
    return (options.client ?? this._client).get<ToolListResponses, ToolListErrors, ThrowOnError>({
      url: "/experimental/tool",
      ...options,
    })
  }
}

class Instance extends _HeyApiClient {
  /**
   * Dispose the current instance
   */
  public dispose<ThrowOnError extends boolean = false>(options?: Options<InstanceDisposeData, ThrowOnError>) {
    return (options?.client ?? this._client).post<InstanceDisposeResponses, unknown, ThrowOnError>({
      url: "/instance/dispose",
      ...options,
    })
  }
}

class Path extends _HeyApiClient {
  /**
   * Get the current path
   */
  public get<ThrowOnError extends boolean = false>(options?: Options<PathGetData, ThrowOnError>) {
    return (options?.client ?? this._client).get<PathGetResponses, unknown, ThrowOnError>({
      url: "/path",
      ...options,
    })
  }
}

class Vcs extends _HeyApiClient {
  /**
   * Get VCS info for the current instance
   */
  public get<ThrowOnError extends boolean = false>(options?: Options<VcsGetData, ThrowOnError>) {
    return (options?.client ?? this._client).get<VcsGetResponses, unknown, ThrowOnError>({
      url: "/vcs",
      ...options,
    })
  }
}

class Session extends _HeyApiClient {
  /**
   * List all sessions
   */
  public list<ThrowOnError extends boolean = false>(options?: Options<SessionListData, ThrowOnError>) {
    return (options?.client ?? this._client).get<SessionListResponses, unknown, ThrowOnError>({
      url: "/session",
      ...options,
    })
  }

  /**
   * Create a new session
   */
  public create<ThrowOnError extends boolean = false>(options?: Options<SessionCreateData, ThrowOnError>) {
    return (options?.client ?? this._client).post<SessionCreateResponses, SessionCreateErrors, ThrowOnError>({
      url: "/session",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
      },
    })
  }

  /**
   * Get session status
   */
  public status<ThrowOnError extends boolean = false>(options?: Options<SessionStatusData, ThrowOnError>) {
    return (options?.client ?? this._client).get<SessionStatusResponses, SessionStatusErrors, ThrowOnError>({
      url: "/session/status",
      ...options,
    })
  }

  /**
   * Delete a session and all its data
   */
  public delete<ThrowOnError extends boolean = false>(options: Options<SessionDeleteData, ThrowOnError>) {
    return (options.client ?? this._client).delete<SessionDeleteResponses, SessionDeleteErrors, ThrowOnError>({
      url: "/session/{id}",
      ...options,
    })
  }

  /**
   * Get session
   */
  public get<ThrowOnError extends boolean = false>(options: Options<SessionGetData, ThrowOnError>) {
    return (options.client ?? this._client).get<SessionGetResponses, SessionGetErrors, ThrowOnError>({
      url: "/session/{id}",
      ...options,
    })
  }

  /**
   * Update session properties
   */
  public update<ThrowOnError extends boolean = false>(options: Options<SessionUpdateData, ThrowOnError>) {
    return (options.client ?? this._client).patch<SessionUpdateResponses, SessionUpdateErrors, ThrowOnError>({
      url: "/session/{id}",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options.headers,
      },
    })
  }

  /**
   * Get a session's children
   */
  public children<ThrowOnError extends boolean = false>(options: Options<SessionChildrenData, ThrowOnError>) {
    return (options.client ?? this._client).get<SessionChildrenResponses, SessionChildrenErrors, ThrowOnError>({
      url: "/session/{id}/children",
      ...options,
    })
  }

  /**
   * Get the todo list for a session
   */
  public todo<ThrowOnError extends boolean = false>(options: Options<SessionTodoData, ThrowOnError>) {
    return (options.client ?? this._client).get<SessionTodoResponses, SessionTodoErrors, ThrowOnError>({
      url: "/session/{id}/todo",
      ...options,
    })
  }

  /**
   * Analyze the app and create an AGENTS.md file
   */
  public init<ThrowOnError extends boolean = false>(options: Options<SessionInitData, ThrowOnError>) {
    return (options.client ?? this._client).post<SessionInitResponses, SessionInitErrors, ThrowOnError>({
      url: "/session/{id}/init",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options.headers,
      },
    })
  }

  /**
   * Fork an existing session at a specific message
   */
  public fork<ThrowOnError extends boolean = false>(options: Options<SessionForkData, ThrowOnError>) {
    return (options.client ?? this._client).post<SessionForkResponses, unknown, ThrowOnError>({
      url: "/session/{id}/fork",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options.headers,
      },
    })
  }

  /**
   * Abort a session
   */
  public abort<ThrowOnError extends boolean = false>(options: Options<SessionAbortData, ThrowOnError>) {
    return (options.client ?? this._client).post<SessionAbortResponses, SessionAbortErrors, ThrowOnError>({
      url: "/session/{id}/abort",
      ...options,
    })
  }

  /**
   * Unshare the session
   */
  public unshare<ThrowOnError extends boolean = false>(options: Options<SessionUnshareData, ThrowOnError>) {
    return (options.client ?? this._client).delete<SessionUnshareResponses, SessionUnshareErrors, ThrowOnError>({
      url: "/session/{id}/share",
      ...options,
    })
  }

  /**
   * Share a session
   */
  public share<ThrowOnError extends boolean = false>(options: Options<SessionShareData, ThrowOnError>) {
    return (options.client ?? this._client).post<SessionShareResponses, SessionShareErrors, ThrowOnError>({
      url: "/session/{id}/share",
      ...options,
    })
  }

  /**
   * Get the diff for this session
   */
  public diff<ThrowOnError extends boolean = false>(options: Options<SessionDiffData, ThrowOnError>) {
    return (options.client ?? this._client).get<SessionDiffResponses, SessionDiffErrors, ThrowOnError>({
      url: "/session/{id}/diff",
      ...options,
    })
  }

  /**
   * Summarize the session
   */
  public summarize<ThrowOnError extends boolean = false>(options: Options<SessionSummarizeData, ThrowOnError>) {
    return (options.client ?? this._client).post<SessionSummarizeResponses, SessionSummarizeErrors, ThrowOnError>({
      url: "/session/{id}/summarize",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options.headers,
      },
    })
  }

  /**
   * List messages for a session
   */
  public messages<ThrowOnError extends boolean = false>(options: Options<SessionMessagesData, ThrowOnError>) {
    return (options.client ?? this._client).get<SessionMessagesResponses, SessionMessagesErrors, ThrowOnError>({
      url: "/session/{id}/message",
      ...options,
    })
  }

  /**
   * Create and send a new message to a session
   */
  public prompt<ThrowOnError extends boolean = false>(options: Options<SessionPromptData, ThrowOnError>) {
    return (options.client ?? this._client).post<SessionPromptResponses, SessionPromptErrors, ThrowOnError>({
      url: "/session/{id}/message",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options.headers,
      },
    })
  }

  /**
   * Get a message from a session
   */
  public message<ThrowOnError extends boolean = false>(options: Options<SessionMessageData, ThrowOnError>) {
    return (options.client ?? this._client).get<SessionMessageResponses, SessionMessageErrors, ThrowOnError>({
      url: "/session/{id}/message/{messageID}",
      ...options,
    })
  }

  /**
   * Create and send a new message to a session, start if needed and return immediately
   */
  public promptAsync<ThrowOnError extends boolean = false>(options: Options<SessionPromptAsyncData, ThrowOnError>) {
    return (options.client ?? this._client).post<SessionPromptAsyncResponses, SessionPromptAsyncErrors, ThrowOnError>({
      url: "/session/{id}/prompt_async",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options.headers,
      },
    })
  }

  /**
   * Send a new command to a session
   */
  public command<ThrowOnError extends boolean = false>(options: Options<SessionCommandData, ThrowOnError>) {
    return (options.client ?? this._client).post<SessionCommandResponses, SessionCommandErrors, ThrowOnError>({
      url: "/session/{id}/command",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options.headers,
      },
    })
  }

  /**
   * Run a shell command
   */
  public shell<ThrowOnError extends boolean = false>(options: Options<SessionShellData, ThrowOnError>) {
    return (options.client ?? this._client).post<SessionShellResponses, SessionShellErrors, ThrowOnError>({
      url: "/session/{id}/shell",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options.headers,
      },
    })
  }

  /**
   * Revert a message
   */
  public revert<ThrowOnError extends boolean = false>(options: Options<SessionRevertData, ThrowOnError>) {
    return (options.client ?? this._client).post<SessionRevertResponses, SessionRevertErrors, ThrowOnError>({
      url: "/session/{id}/revert",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options.headers,
      },
    })
  }

  /**
   * Restore all reverted messages
   */
  public unrevert<ThrowOnError extends boolean = false>(options: Options<SessionUnrevertData, ThrowOnError>) {
    return (options.client ?? this._client).post<SessionUnrevertResponses, SessionUnrevertErrors, ThrowOnError>({
      url: "/session/{id}/unrevert",
      ...options,
    })
  }
}

class Command extends _HeyApiClient {
  /**
   * List all commands
   */
  public list<ThrowOnError extends boolean = false>(options?: Options<CommandListData, ThrowOnError>) {
    return (options?.client ?? this._client).get<CommandListResponses, unknown, ThrowOnError>({
      url: "/command",
      ...options,
    })
  }
}

class Oauth extends _HeyApiClient {
  /**
   * Authorize a provider using OAuth
   */
  public authorize<ThrowOnError extends boolean = false>(options: Options<ProviderOauthAuthorizeData, ThrowOnError>) {
    return (options.client ?? this._client).post<
      ProviderOauthAuthorizeResponses,
      ProviderOauthAuthorizeErrors,
      ThrowOnError
    >({
      url: "/provider/{id}/oauth/authorize",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options.headers,
      },
    })
  }

  /**
   * Handle OAuth callback for a provider
   */
  public callback<ThrowOnError extends boolean = false>(options: Options<ProviderOauthCallbackData, ThrowOnError>) {
    return (options.client ?? this._client).post<
      ProviderOauthCallbackResponses,
      ProviderOauthCallbackErrors,
      ThrowOnError
    >({
      url: "/provider/{id}/oauth/callback",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options.headers,
      },
    })
  }
}

class Provider extends _HeyApiClient {
  /**
   * List all providers
   */
  public list<ThrowOnError extends boolean = false>(options?: Options<ProviderListData, ThrowOnError>) {
    return (options?.client ?? this._client).get<ProviderListResponses, unknown, ThrowOnError>({
      url: "/provider",
      ...options,
    })
  }

  /**
   * Get provider authentication methods
   */
  public auth<ThrowOnError extends boolean = false>(options?: Options<ProviderAuthData, ThrowOnError>) {
    return (options?.client ?? this._client).get<ProviderAuthResponses, unknown, ThrowOnError>({
      url: "/provider/auth",
      ...options,
    })
  }
  oauth = new Oauth({ client: this._client })
}

class Find extends _HeyApiClient {
  /**
   * Find text in files
   */
  public text<ThrowOnError extends boolean = false>(options: Options<FindTextData, ThrowOnError>) {
    return (options.client ?? this._client).get<FindTextResponses, unknown, ThrowOnError>({
      url: "/find",
      ...options,
    })
  }

  /**
   * Find files
   */
  public files<ThrowOnError extends boolean = false>(options: Options<FindFilesData, ThrowOnError>) {
    return (options.client ?? this._client).get<FindFilesResponses, unknown, ThrowOnError>({
      url: "/find/file",
      ...options,
    })
  }

  /**
   * Find workspace symbols
   */
  public symbols<ThrowOnError extends boolean = false>(options: Options<FindSymbolsData, ThrowOnError>) {
    return (options.client ?? this._client).get<FindSymbolsResponses, unknown, ThrowOnError>({
      url: "/find/symbol",
      ...options,
    })
  }
}

class File extends _HeyApiClient {
  /**
   * List files and directories
   */
  public list<ThrowOnError extends boolean = false>(options: Options<FileListData, ThrowOnError>) {
    return (options.client ?? this._client).get<FileListResponses, unknown, ThrowOnError>({
      url: "/file",
      ...options,
    })
  }

  /**
   * Read a file
   */
  public read<ThrowOnError extends boolean = false>(options: Options<FileReadData, ThrowOnError>) {
    return (options.client ?? this._client).get<FileReadResponses, unknown, ThrowOnError>({
      url: "/file/content",
      ...options,
    })
  }

  /**
   * Get file status
   */
  public status<ThrowOnError extends boolean = false>(options?: Options<FileStatusData, ThrowOnError>) {
    return (options?.client ?? this._client).get<FileStatusResponses, unknown, ThrowOnError>({
      url: "/file/status",
      ...options,
    })
  }
}

class App extends _HeyApiClient {
  /**
   * Write a log entry to the server logs
   */
  public log<ThrowOnError extends boolean = false>(options?: Options<AppLogData, ThrowOnError>) {
    return (options?.client ?? this._client).post<AppLogResponses, AppLogErrors, ThrowOnError>({
      url: "/log",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
      },
    })
  }

  /**
   * List all agents
   */
  public agents<ThrowOnError extends boolean = false>(options?: Options<AppAgentsData, ThrowOnError>) {
    return (options?.client ?? this._client).get<AppAgentsResponses, unknown, ThrowOnError>({
      url: "/agent",
      ...options,
    })
  }
}

class Auth extends _HeyApiClient {
  /**
   * Remove OAuth credentials for an MCP server
   */
  public remove<ThrowOnError extends boolean = false>(options: Options<McpAuthRemoveData, ThrowOnError>) {
    return (options.client ?? this._client).delete<McpAuthRemoveResponses, McpAuthRemoveErrors, ThrowOnError>({
      url: "/mcp/{name}/auth",
      ...options,
    })
  }

  /**
   * Start OAuth authentication flow for an MCP server
   */
  public start<ThrowOnError extends boolean = false>(options: Options<McpAuthStartData, ThrowOnError>) {
    return (options.client ?? this._client).post<McpAuthStartResponses, McpAuthStartErrors, ThrowOnError>({
      url: "/mcp/{name}/auth",
      ...options,
    })
  }

  /**
   * Complete OAuth authentication with authorization code
   */
  public callback<ThrowOnError extends boolean = false>(options: Options<McpAuthCallbackData, ThrowOnError>) {
    return (options.client ?? this._client).post<McpAuthCallbackResponses, McpAuthCallbackErrors, ThrowOnError>({
      url: "/mcp/{name}/auth/callback",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options.headers,
      },
    })
  }

  /**
   * Start OAuth flow and wait for callback (opens browser)
   */
  public authenticate<ThrowOnError extends boolean = false>(options: Options<McpAuthAuthenticateData, ThrowOnError>) {
    return (options.client ?? this._client).post<McpAuthAuthenticateResponses, McpAuthAuthenticateErrors, ThrowOnError>(
      {
        url: "/mcp/{name}/auth/authenticate",
        ...options,
      },
    )
  }

  /**
   * Set authentication credentials
   */
  public set<ThrowOnError extends boolean = false>(options: Options<AuthSetData, ThrowOnError>) {
    return (options.client ?? this._client).put<AuthSetResponses, AuthSetErrors, ThrowOnError>({
      url: "/auth/{id}",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options.headers,
      },
    })
  }
}

class Mcp extends _HeyApiClient {
  /**
   * Get MCP server status
   */
  public status<ThrowOnError extends boolean = false>(options?: Options<McpStatusData, ThrowOnError>) {
    return (options?.client ?? this._client).get<McpStatusResponses, unknown, ThrowOnError>({
      url: "/mcp",
      ...options,
    })
  }

  /**
   * Add MCP server dynamically
   */
  public add<ThrowOnError extends boolean = false>(options?: Options<McpAddData, ThrowOnError>) {
    return (options?.client ?? this._client).post<McpAddResponses, McpAddErrors, ThrowOnError>({
      url: "/mcp",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
      },
    })
  }

  /**
   * Connect an MCP server
   */
  public connect<ThrowOnError extends boolean = false>(options: Options<McpConnectData, ThrowOnError>) {
    return (options.client ?? this._client).post<McpConnectResponses, unknown, ThrowOnError>({
      url: "/mcp/{name}/connect",
      ...options,
    })
  }

  /**
   * Disconnect an MCP server
   */
  public disconnect<ThrowOnError extends boolean = false>(options: Options<McpDisconnectData, ThrowOnError>) {
    return (options.client ?? this._client).post<McpDisconnectResponses, unknown, ThrowOnError>({
      url: "/mcp/{name}/disconnect",
      ...options,
    })
  }

  auth = new Auth({ client: this._client })
}

class Lsp extends _HeyApiClient {
  /**
   * Get LSP server status
   */
  public status<ThrowOnError extends boolean = false>(options?: Options<LspStatusData, ThrowOnError>) {
    return (options?.client ?? this._client).get<LspStatusResponses, unknown, ThrowOnError>({
      url: "/lsp",
      ...options,
    })
  }
}

class Formatter extends _HeyApiClient {
  /**
   * Get formatter status
   */
  public status<ThrowOnError extends boolean = false>(options?: Options<FormatterStatusData, ThrowOnError>) {
    return (options?.client ?? this._client).get<FormatterStatusResponses, unknown, ThrowOnError>({
      url: "/formatter",
      ...options,
    })
  }
}

class Control extends _HeyApiClient {
  /**
   * Get the next TUI request from the queue
   */
  public next<ThrowOnError extends boolean = false>(options?: Options<TuiControlNextData, ThrowOnError>) {
    return (options?.client ?? this._client).get<TuiControlNextResponses, unknown, ThrowOnError>({
      url: "/tui/control/next",
      ...options,
    })
  }

  /**
   * Submit a response to the TUI request queue
   */
  public response<ThrowOnError extends boolean = false>(options?: Options<TuiControlResponseData, ThrowOnError>) {
    return (options?.client ?? this._client).post<TuiControlResponseResponses, unknown, ThrowOnError>({
      url: "/tui/control/response",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
      },
    })
  }
}

class Tui extends _HeyApiClient {
  /**
   * Append prompt to the TUI
   */
  public appendPrompt<ThrowOnError extends boolean = false>(options?: Options<TuiAppendPromptData, ThrowOnError>) {
    return (options?.client ?? this._client).post<TuiAppendPromptResponses, TuiAppendPromptErrors, ThrowOnError>({
      url: "/tui/append-prompt",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
      },
    })
  }

  /**
   * Open the help dialog
   */
  public openHelp<ThrowOnError extends boolean = false>(options?: Options<TuiOpenHelpData, ThrowOnError>) {
    return (options?.client ?? this._client).post<TuiOpenHelpResponses, unknown, ThrowOnError>({
      url: "/tui/open-help",
      ...options,
    })
  }

  /**
   * Open the session dialog
   */
  public openSessions<ThrowOnError extends boolean = false>(options?: Options<TuiOpenSessionsData, ThrowOnError>) {
    return (options?.client ?? this._client).post<TuiOpenSessionsResponses, unknown, ThrowOnError>({
      url: "/tui/open-sessions",
      ...options,
    })
  }

  /**
   * Open the theme dialog
   */
  public openThemes<ThrowOnError extends boolean = false>(options?: Options<TuiOpenThemesData, ThrowOnError>) {
    return (options?.client ?? this._client).post<TuiOpenThemesResponses, unknown, ThrowOnError>({
      url: "/tui/open-themes",
      ...options,
    })
  }

  /**
   * Open the model dialog
   */
  public openModels<ThrowOnError extends boolean = false>(options?: Options<TuiOpenModelsData, ThrowOnError>) {
    return (options?.client ?? this._client).post<TuiOpenModelsResponses, unknown, ThrowOnError>({
      url: "/tui/open-models",
      ...options,
    })
  }

  /**
   * Submit the prompt
   */
  public submitPrompt<ThrowOnError extends boolean = false>(options?: Options<TuiSubmitPromptData, ThrowOnError>) {
    return (options?.client ?? this._client).post<TuiSubmitPromptResponses, unknown, ThrowOnError>({
      url: "/tui/submit-prompt",
      ...options,
    })
  }

  /**
   * Clear the prompt
   */
  public clearPrompt<ThrowOnError extends boolean = false>(options?: Options<TuiClearPromptData, ThrowOnError>) {
    return (options?.client ?? this._client).post<TuiClearPromptResponses, unknown, ThrowOnError>({
      url: "/tui/clear-prompt",
      ...options,
    })
  }

  /**
   * Execute a TUI command (e.g. agent_cycle)
   */
  public executeCommand<ThrowOnError extends boolean = false>(options?: Options<TuiExecuteCommandData, ThrowOnError>) {
    return (options?.client ?? this._client).post<TuiExecuteCommandResponses, TuiExecuteCommandErrors, ThrowOnError>({
      url: "/tui/execute-command",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
      },
    })
  }

  /**
   * Show a toast notification in the TUI
   */
  public showToast<ThrowOnError extends boolean = false>(options?: Options<TuiShowToastData, ThrowOnError>) {
    return (options?.client ?? this._client).post<TuiShowToastResponses, unknown, ThrowOnError>({
      url: "/tui/show-toast",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
      },
    })
  }

  /**
   * Publish a TUI event
   */
  public publish<ThrowOnError extends boolean = false>(options?: Options<TuiPublishData, ThrowOnError>) {
    return (options?.client ?? this._client).post<TuiPublishResponses, TuiPublishErrors, ThrowOnError>({
      url: "/tui/publish",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
      },
    })
  }
  control = new Control({ client: this._client })
}

class Event extends _HeyApiClient {
  /**
   * Get events
   */
  public subscribe<ThrowOnError extends boolean = false>(options?: Options<EventSubscribeData, ThrowOnError>) {
    return (options?.client ?? this._client).get.sse<EventSubscribeResponses, unknown, ThrowOnError>({
      url: "/event",
      ...options,
    })
  }
}

export class OpencodeClient extends _HeyApiClient {
  /**
   * Respond to a permission request
   */
  public postSessionIdPermissionsPermissionId<ThrowOnError extends boolean = false>(
    options: Options<PostSessionIdPermissionsPermissionIdData, ThrowOnError>,
  ) {
    return (options.client ?? this._client).post<
      PostSessionIdPermissionsPermissionIdResponses,
      PostSessionIdPermissionsPermissionIdErrors,
      ThrowOnError
    >({
      url: "/session/{id}/permissions/{permissionID}",
      ...options,
      headers: {
        "Content-Type": "application/json",
        ...options.headers,
      },
    })
  }
  global = new Global({ client: this._client })
  project = new Project({ client: this._client })
  pty = new Pty({ client: this._client })
  config = new Config({ client: this._client })
  tool = new Tool({ client: this._client })
  instance = new Instance({ client: this._client })
  path = new Path({ client: this._client })
  vcs = new Vcs({ client: this._client })
  session = new Session({ client: this._client })
  command = new Command({ client: this._client })
  provider = new Provider({ client: this._client })
  find = new Find({ client: this._client })
  file = new File({ client: this._client })
  app = new App({ client: this._client })
  mcp = new Mcp({ client: this._client })
  lsp = new Lsp({ client: this._client })
  formatter = new Formatter({ client: this._client })
  tui = new Tui({ client: this._client })
  auth = new Auth({ client: this._client })
  event = new Event({ client: this._client })
}
