/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.controller;

import com.lilithsthrone.controller.MainController;
import com.lilithsthrone.controller.eventListeners.EnchantmentEventListener;
import com.lilithsthrone.controller.eventListeners.tooltips.TooltipInformationEventListener;
import com.lilithsthrone.controller.eventListeners.tooltips.TooltipInventoryEventListener;
import com.lilithsthrone.game.character.markings.Tattoo;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.EnchantmentDialogue;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.enchanting.AbstractItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.EnchantingUtils;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.game.inventory.enchanting.TFPotency;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.main.Main;
import org.w3c.dom.events.EventTarget;

public class EnchantmentController {
    static void initEnchantmentMenuListeners() {
        TooltipInventoryEventListener el;
        Object id = "apply_enchanted_item_name";
        if (MainController.document.getElementById((String)id) != null) {
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('output_name').value;");
                EnchantmentDialogue.setOutputName(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
                Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
            }, false);
        }
        if (MainController.document.getElementById((String)(id = "MOD_PRIMARY_ENCHANTING")) != null) {
            MainController.addTooltipListeners((String)id, new TooltipInventoryEventListener().setTFModifier(EnchantmentDialogue.getPrimaryMod()), new EnchantmentEventListener().setPrimaryModifier(TFModifier.NONE), false);
        }
        if (MainController.document.getElementById((String)(id = "MOD_SECONDARY_ENCHANTING")) != null) {
            MainController.addTooltipListeners((String)id, new TooltipInventoryEventListener().setTFModifier(EnchantmentDialogue.getSecondaryMod()), new EnchantmentEventListener().setSecondaryModifier(TFModifier.NONE), false);
        }
        for (TFPotency potency : TFPotency.values()) {
            id = "POTENCY_" + String.valueOf((Object)potency);
            if (MainController.document.getElementById((String)id) == null) continue;
            MainController.addEventListener(MainController.document, (String)id, "click", new EnchantmentEventListener().setPotency(potency), false);
        }
        for (int effectCount = 0; effectCount < EnchantmentDialogue.getEffects().size(); ++effectCount) {
            id = "DELETE_EFFECT_" + effectCount;
            if (MainController.document.getElementById((String)id) == null) continue;
            MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u53bb\u9664\u6548\u679c", ""), new EnchantmentEventListener().removeEffect(effectCount), false);
        }
        AbstractItemEffectType effect = EnchantmentDialogue.getIngredient().getEnchantmentEffect();
        int maxLimit = effect.getMaximumLimit(EnchantmentDialogue.getPrimaryMod(), EnchantmentDialogue.getSecondaryMod());
        int currentLimit = EnchantmentDialogue.getLimit();
        if (currentLimit > 0) {
            id = "LIMIT_MINIMUM";
            if (MainController.document.getElementById((String)id) != null) {
                MainController.addEventListener(MainController.document, (String)id, "click", new EnchantmentEventListener().setLimit(0), false);
            }
            if (MainController.document.getElementById((String)(id = "LIMIT_DECREASE_LARGE")) != null) {
                MainController.addEventListener(MainController.document, (String)id, "click", new EnchantmentEventListener().setLimit(Math.max(0, EnchantmentDialogue.getLimit() - effect.getLargeLimitChange(EnchantmentDialogue.getPrimaryMod(), EnchantmentDialogue.getSecondaryMod()))), false);
            }
            if (MainController.document.getElementById((String)(id = "LIMIT_DECREASE")) != null) {
                MainController.addEventListener(MainController.document, (String)id, "click", new EnchantmentEventListener().setLimit(EnchantmentDialogue.getLimit() - effect.getSmallLimitChange(EnchantmentDialogue.getPrimaryMod(), EnchantmentDialogue.getSecondaryMod())), false);
            }
        }
        if (currentLimit < maxLimit) {
            id = "LIMIT_INCREASE";
            if (MainController.document.getElementById((String)id) != null) {
                MainController.addEventListener(MainController.document, (String)id, "click", new EnchantmentEventListener().setLimit(EnchantmentDialogue.getLimit() + effect.getSmallLimitChange(EnchantmentDialogue.getPrimaryMod(), EnchantmentDialogue.getSecondaryMod())), false);
            }
            if (MainController.document.getElementById((String)(id = "LIMIT_INCREASE_LARGE")) != null) {
                MainController.addEventListener(MainController.document, (String)id, "click", new EnchantmentEventListener().setLimit(Math.min(maxLimit, EnchantmentDialogue.getLimit() + effect.getLargeLimitChange(EnchantmentDialogue.getPrimaryMod(), EnchantmentDialogue.getSecondaryMod()))), false);
            }
            if (MainController.document.getElementById((String)(id = "LIMIT_MAXIMUM")) != null) {
                MainController.addEventListener(MainController.document, (String)id, "click", new EnchantmentEventListener().setLimit(maxLimit), false);
            }
        }
        if (MainController.document.getElementById((String)(id = "INGREDIENT_ENCHANTING")) != null) {
            el = null;
            if (EnchantmentDialogue.getIngredient() instanceof AbstractItem) {
                el = new TooltipInventoryEventListener().setItem((AbstractItem)EnchantmentDialogue.getIngredient(), Main.game.getPlayer(), null);
            } else if (EnchantmentDialogue.getIngredient() instanceof AbstractClothing) {
                el = new TooltipInventoryEventListener().setClothing((AbstractClothing)EnchantmentDialogue.getIngredient(), Main.game.getPlayer(), null);
            } else if (EnchantmentDialogue.getIngredient() instanceof AbstractWeapon) {
                el = new TooltipInventoryEventListener().setWeapon((AbstractWeapon)EnchantmentDialogue.getIngredient(), Main.game.getPlayer(), false);
            } else if (EnchantmentDialogue.getIngredient() instanceof Tattoo) {
                el = new TooltipInventoryEventListener().setTattoo(EnchantmentDialogue.getTattooSlot(), (Tattoo)EnchantmentDialogue.getIngredient(), EnchantmentDialogue.getTattooBearer(), EnchantmentDialogue.getTattooBearer());
            }
            MainController.addTooltipListeners((String)id, el);
        }
        if (MainController.document.getElementById((String)(id = "OUTPUT_ENCHANTING")) != null) {
            el = null;
            if (EnchantmentDialogue.getIngredient() instanceof AbstractItem) {
                el = new TooltipInventoryEventListener().setItem(EnchantingUtils.craftItem(EnchantmentDialogue.getIngredient(), EnchantmentDialogue.getEffects()), Main.game.getPlayer(), null);
            } else if (EnchantmentDialogue.getIngredient() instanceof AbstractClothing) {
                el = new TooltipInventoryEventListener().setClothing(EnchantingUtils.craftClothing(EnchantmentDialogue.getIngredient(), EnchantmentDialogue.getEffects()), Main.game.getPlayer(), null);
            } else if (EnchantmentDialogue.getIngredient() instanceof AbstractWeapon) {
                el = new TooltipInventoryEventListener().setWeapon(EnchantingUtils.craftWeapon(EnchantmentDialogue.getIngredient(), EnchantmentDialogue.getEffects()), Main.game.getPlayer(), false);
            } else if (EnchantmentDialogue.getIngredient() instanceof Tattoo) {
                el = new TooltipInventoryEventListener().setTattoo(EnchantmentDialogue.getTattooSlot(), EnchantingUtils.craftTattoo(EnchantmentDialogue.getIngredient(), EnchantmentDialogue.getEffects()), EnchantmentDialogue.getTattooBearer(), EnchantmentDialogue.getTattooBearer());
            }
            MainController.addTooltipListeners((String)id, el);
        }
        if (MainController.document.getElementById((String)(id = "ENCHANT_ADD_BUTTON")) != null) {
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                if (EnchantmentDialogue.getIngredient().getEnchantmentEffect().getEffectsDescription(EnchantmentDialogue.getPrimaryMod(), EnchantmentDialogue.getSecondaryMod(), EnchantmentDialogue.getPotency(), EnchantmentDialogue.getLimit(), Main.game.getPlayer(), Main.game.getPlayer()) != null) {
                    Main.game.setContent(new Response("\u6dfb\u52a0", "\u6dfb\u52a0\u8be5\u6548\u679c\u3002", EnchantmentDialogue.ENCHANTMENT_MENU){

                        @Override
                        public void effects() {
                            EnchantmentDialogue.addEffect(new ItemEffect(EnchantmentDialogue.getIngredient().getEnchantmentEffect(), EnchantmentDialogue.getPrimaryMod(), EnchantmentDialogue.getSecondaryMod(), EnchantmentDialogue.getPotency(), EnchantmentDialogue.getLimit()));
                        }
                    });
                }
            }, false);
            MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u6dfb\u52a0\u6548\u679c", ""));
        }
        if (MainController.document.getElementById((String)(id = "ENCHANT_ADD_BUTTON_DISABLED")) != null) {
            String blockedString = EnchantmentDialogue.getEnchantmentEffectBlockedReason(EnchantmentDialogue.getCurrentEffect());
            MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u6dfb\u52a0\u6548\u679c", EnchantmentDialogue.getEffects().size() >= EnchantmentDialogue.getIngredient().getEnchantmentLimit() ? "\u4f60\u5bf9\u8fd9\u4ef6\u7269\u54c1\u6dfb\u52a0\u7684\u6548\u679c\u5df2\u8fbe\u4e0a\u9650\uff01" : (blockedString != null ? blockedString : "")));
        }
        for (TFModifier tfMod : EnchantmentDialogue.getIngredient().getEnchantmentEffect().getPrimaryModifiers(EnchantmentDialogue.getIngredient())) {
            id = "MOD_PRIMARY_" + tfMod.hashCode();
            if (MainController.document.getElementById((String)id) == null) continue;
            MainController.addTooltipListeners((String)id, new TooltipInventoryEventListener().setTFModifier(tfMod), new EnchantmentEventListener().setPrimaryModifier(tfMod), false);
        }
        for (TFModifier tfMod : EnchantmentDialogue.getIngredient().getEnchantmentEffect().getSecondaryModifiers(EnchantmentDialogue.getIngredient(), EnchantmentDialogue.getPrimaryMod())) {
            id = "MOD_SECONDARY_" + tfMod.hashCode();
            if (MainController.document.getElementById((String)id) == null) continue;
            MainController.addTooltipListeners((String)id, new TooltipInventoryEventListener().setTFModifier(tfMod), new EnchantmentEventListener().setSecondaryModifier(tfMod), false);
        }
    }
}

