/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.controller;

import com.lilithsthrone.controller.MainController;
import com.lilithsthrone.controller.eventListeners.tooltips.TooltipInformationEventListener;
import com.lilithsthrone.controller.eventListeners.tooltips.TooltipInventoryEventListener;
import com.lilithsthrone.game.Game;
import com.lilithsthrone.game.PropertyValue;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.PlayerCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.markings.Tattoo;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.dialogue.companions.CompanionManagement;
import com.lilithsthrone.game.dialogue.places.dominion.cityHall.CityHall;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.LilayaDressingRoomDialogue;
import com.lilithsthrone.game.dialogue.places.dominion.slaverAlley.SlaverAlleyDialogue;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.BodyChanging;
import com.lilithsthrone.game.dialogue.utils.CharacterModificationUtils;
import com.lilithsthrone.game.dialogue.utils.CharactersPresentDialogue;
import com.lilithsthrone.game.dialogue.utils.CosmeticsDialogue;
import com.lilithsthrone.game.dialogue.utils.EnchantmentDialogue;
import com.lilithsthrone.game.dialogue.utils.OptionsDialogue;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.PhoneDialogue;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.LoadedEnchantment;
import com.lilithsthrone.game.inventory.outfit.Outfit;
import com.lilithsthrone.game.inventory.outfit.OutfitSource;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.Artwork;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.PresetColour;
import java.io.File;
import java.util.List;
import java.util.Map;
import javafx.stage.FileChooser;
import org.w3c.dom.events.EventTarget;

public class FileController {
    private static File lastOpened = null;

    public static void initArtworkListeners() {
        PlayerCharacter character = Main.game.getCurrentDialogueNode().equals(PhoneDialogue.CHARACTER_APPEARANCE) ? Main.game.getPlayer() : (Main.game.getCurrentDialogueNode().equals(CompanionManagement.SLAVE_MANAGEMENT_INSPECT) ? Main.game.getDialogueFlags().getManagementCompanion() : CharactersPresentDialogue.characterViewed);
        String id = "ARTWORK_ADD";
        if (MainController.document.getElementById(id) != null) {
            ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                List<File> files;
                FileChooser chooser = new FileChooser();
                chooser.setTitle("Add Images");
                chooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("Images", "*.jpg", "*.png", "*.gif"));
                if (lastOpened != null) {
                    chooser.setInitialDirectory(lastOpened);
                }
                if ((files = chooser.showOpenMultipleDialog(Main.primaryStage)) != null && !files.isEmpty()) {
                    lastOpened = files.get(0).getParentFile();
                    character.importImages(files);
                    if (!character.isPlayer()) {
                        CharactersPresentDialogue.resetContent(character);
                    }
                    Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                }
            }, false);
            MainController.addTooltipListeners(id, new TooltipInformationEventListener().setInformation("\u6dfb\u52a0\u81ea\u5b9a\u4e49\u56fe\u50cf", "\u6d4f\u89c8\u4f60\u62e5\u6709\u7684\u56fe\u50cf\uff0c\u5e76\u6dfb\u52a0\u7ed9\u8be5\u89d2\u8272\u3002\u8bf7\u6ce8\u610fGIF\u52a8\u56fe<b>\u6700\u5927\u9650\u5236\u572810MB\u4ee5\u5185</b>\uff0c\u4e00\u65e6\u5927\u4e8e1MB\uff0c\u5219\u6839\u636e\u7cfb\u7edf\u4e0d\u540c\uff0c<b>\u53ef\u80fd</b>\u9020\u6210[style.italicsBad(\u4e25\u91cd\u5361\u987f)]\u3002<br/>\u5f53\u524d\u6e38\u620f\u7684\u81ea\u5b9a\u4e49\u56fe\u50cf\u4f4d\u4e8e\u6587\u4ef6\u5939:<b>'data/images/" + Main.game.getId() + "'</b>\u5185<br/>\u8be5\u89d2\u8272\u7684ID\u4e3a<b>'" + ((GameCharacter)character).getId() + "'</b>", 130));
        }
        if (character.hasArtwork()) {
            try {
                Artwork artwork = character.getCurrentArtwork();
                id = "ARTWORK_INFO";
                if (MainController.document.getElementById(id) != null) {
                    ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                        if (!artwork.getArtist().getWebsites().isEmpty()) {
                            Util.openLinkInDefaultBrowser(artwork.getArtist().getWebsites().get(0).getURL());
                        }
                    }, false);
                    Object description = artwork.getArtist().getName().equals("Custom") ? "\u7531\u4f60\u81ea\u884c\u6dfb\u52a0\u3002" : (artwork.getArtist().getWebsites().isEmpty() ? "\u8be5\u753b\u5e08\u6ca1\u6709\u63d0\u4f9b\u76f8\u5173\u7f51\u7ad9\uff01" : "\u70b9\u51fb\u540e\u6253\u5f00<b style='color:" + artwork.getArtist().getColour().toWebHexString() + ";'>" + artwork.getArtist().getWebsites().get(0).getName() + "</b>(" + artwork.getArtist().getWebsites().get(0).getURL() + ")\u901a\u8fc7\u4f60\u7684\u9ed8\u8ba4<b>\u5916\u90e8</b>\u6d4f\u89c8\u5668\uff01");
                    MainController.addTooltipListeners(id, new TooltipInformationEventListener().setInformation("<b style='color:" + artwork.getArtist().getColour().toWebHexString() + ";'>" + artwork.getArtist().getName() + "</b>\u521b\u4f5c\u7684\u56fe\u50cf", (String)description));
                }
                if (MainController.document.getElementById(id = "ARTWORK_PREVIOUS") != null) {
                    ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                        if (artwork.getTotalArtworkCount() > 1) {
                            artwork.incrementIndex(-1);
                            if (!character.isPlayer()) {
                                CharactersPresentDialogue.resetContent(character);
                            }
                            Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                        }
                    }, false);
                }
                if (MainController.document.getElementById(id = "ARTWORK_NEXT") != null) {
                    ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                        if (artwork.getTotalArtworkCount() > 1) {
                            artwork.incrementIndex(1);
                            if (!character.isPlayer()) {
                                CharactersPresentDialogue.resetContent(character);
                            }
                            Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                        }
                    }, false);
                }
                if (MainController.document.getElementById(id = "ARTWORK_ARTIST_PREVIOUS") != null) {
                    ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                        if (character.getArtworkList().size() > 1) {
                            character.incrementArtworkIndex(-1);
                            if (!character.isPlayer()) {
                                CharactersPresentDialogue.resetContent(character);
                            }
                            Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                        }
                    }, false);
                }
                if (MainController.document.getElementById(id = "ARTWORK_ARTIST_NEXT") != null) {
                    ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                        if (character.getArtworkList().size() > 1) {
                            character.incrementArtworkIndex(1);
                            if (!character.isPlayer()) {
                                CharactersPresentDialogue.resetContent(character);
                            }
                            Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                        }
                    }, false);
                }
                if (MainController.document.getElementById(id = "ARTWORK_DELETE") != null) {
                    ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                        artwork.getCurrentImage().delete();
                        character.updateImages();
                        if (!character.isPlayer()) {
                            CharactersPresentDialogue.resetContent(character);
                        }
                        Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                    }, false);
                    MainController.addTooltipListeners(id, new TooltipInformationEventListener().setInformation("\u79fb\u9664\u81ea\u5b9a\u4e49\u56fe\u50cf", "\u79fb\u9664\u8be5\u89d2\u8272\u5f53\u524d\u7684\u56fe\u50cf\u3002<br/>[style.italicsBad(\u8bf7\u6ce8\u610f\u8fd9\u5c06\u4ece\u6e38\u620f\u6587\u4ef6\u5939\u4e2d\u5220\u9664\u8be5\u56fe\u50cf\uff01)]"));
                }
            }
            catch (Exception ex) {
                System.err.println("MainController Artwork handling error.");
            }
        }
    }

    public static void initSaveLoadListeners() {
        Object id;
        for (File f : Main.getSavedGames(false)) {
            String fileIdentifier = Util.getFileIdentifier(f);
            String fileName = Util.getFileName(f);
            id = "OVERWRITE_" + fileIdentifier;
            if (MainController.document.getElementById((String)id) != null) {
                ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                    if (!Main.getProperties().hasValue(PropertyValue.overwriteWarning) || OptionsDialogue.overwriteConfirmationName.equals(f.getName())) {
                        OptionsDialogue.overwriteConfirmationName = "";
                        Main.saveGame(fileName, true, false);
                    } else {
                        OptionsDialogue.overwriteConfirmationName = f.getName();
                        OptionsDialogue.loadConfirmationName = "";
                        OptionsDialogue.deleteConfirmationName = "";
                        Main.game.setContent(new Response("\u4fdd\u5b58/\u52a0\u8f7d", "\u6253\u5f00\u4fdd\u5b58/\u52a0\u8f7d\u6e38\u620f\u7a97\u53e3", OptionsDialogue.SAVE_LOAD));
                    }
                }, false);
                MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u8986\u76d6", ""));
            } else {
                id = "OVERWRITE_" + fileIdentifier + "_DISABLED";
                if (MainController.document.getElementById((String)id) != null) {
                    MainController.addEventListener(MainController.document, (String)id, "mousemove", MainController.moveTooltipListener, false);
                    MainController.addEventListener(MainController.document, (String)id, "mouseleave", MainController.hideTooltipListener, false);
                    TooltipInformationEventListener el2 = new TooltipInformationEventListener().setInformation("\u8986\u76d6(\u7981\u7528)", !Main.game.isStarted() ? "\u4f60\u9700\u8981\u5148\u5f00\u59cb\u6e38\u620f\u624d\u80fd\u8986\u76d6\u5b58\u6863\uff01" : "\u9664\u975e\u4f4d\u4e8e\u67d0\u5730\u5757\u7684\u9ed8\u8ba4\u573a\u666f\uff0c\u5426\u5219\u65e0\u6cd5\u8986\u76d6\u5b58\u6863\u6587\u4ef6\uff01");
                    MainController.addEventListener(MainController.document, (String)id, "mouseenter", el2, false);
                }
            }
            id = "LOAD_" + fileIdentifier;
            if (MainController.document.getElementById((String)id) != null) {
                ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                    if (!Main.getProperties().hasValue(PropertyValue.overwriteWarning) || OptionsDialogue.loadConfirmationName.equals(f.getName())) {
                        OptionsDialogue.loadConfirmationName = "";
                        Main.loadGame(fileName);
                    } else {
                        OptionsDialogue.overwriteConfirmationName = "";
                        OptionsDialogue.loadConfirmationName = f.getName();
                        OptionsDialogue.deleteConfirmationName = "";
                        Main.game.setContent(new Response("\u4fdd\u5b58/\u52a0\u8f7d", "\u6253\u5f00\u4fdd\u5b58/\u52a0\u8f7d\u6e38\u620f\u7a97\u53e3", OptionsDialogue.SAVE_LOAD));
                    }
                }, false);
                MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u52a0\u8f7d", ""));
            }
            if (MainController.document.getElementById((String)(id = "DELETE_" + fileIdentifier)) == null) continue;
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                if (!Main.getProperties().hasValue(PropertyValue.overwriteWarning) || OptionsDialogue.deleteConfirmationName.equals(f.getName())) {
                    OptionsDialogue.deleteConfirmationName = "";
                    Main.deleteGame(fileName);
                    Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                } else {
                    OptionsDialogue.overwriteConfirmationName = "";
                    OptionsDialogue.loadConfirmationName = "";
                    OptionsDialogue.deleteConfirmationName = f.getName();
                    Main.game.setContent(new Response("\u4fdd\u5b58/\u52a0\u8f7d", "\u6253\u5f00\u4fdd\u5b58/\u52a0\u8f7d\u6e38\u620f\u7a97\u53e3", OptionsDialogue.SAVE_LOAD));
                }
            }, false);
            MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u5220\u9664", ""));
        }
        id = "NEW_SAVE";
        if (MainController.document.getElementById((String)id) != null) {
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('new_save_name').value;");
                Main.saveGame(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent(), false, false);
            }, false);
            MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u4fdd\u5b58", ""));
        } else {
            id = "NEW_SAVE_DISABLED";
            if (MainController.document.getElementById((String)id) != null) {
                MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u4fdd\u5b58(\u7981\u7528)", !Main.game.isStarted() ? "\u4f60\u9700\u8981\u5148\u5f00\u59cb\u6e38\u620f\u624d\u80fd\u5b58\u6863\uff01" : "\u9664\u975e\u4f4d\u4e8e\u67d0\u5730\u5757\u7684\u9ed8\u8ba4\u573a\u666f\uff0c\u5426\u5219\u65e0\u6cd5\u5b58\u6863\uff01"));
            }
        }
    }

    public static void initImportExportListeners() {
        for (File f : Main.getCharactersForImport()) {
            String fileIdentifier = Util.getFileIdentifier(f);
            String fileName = Util.getFileName(f);
            String id = "DELETE_CHARACTER_" + fileIdentifier;
            if (MainController.document.getElementById(id) == null) continue;
            ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                if (!Main.getProperties().hasValue(PropertyValue.overwriteWarning) || OptionsDialogue.deleteConfirmationName.equals(f.getName())) {
                    OptionsDialogue.deleteConfirmationName = "";
                    Main.deleteExportedCharacter(fileName);
                } else {
                    OptionsDialogue.overwriteConfirmationName = "";
                    OptionsDialogue.loadConfirmationName = "";
                    OptionsDialogue.deleteConfirmationName = f.getName();
                    Main.game.setContent(new Response("\u5bfc\u5165/\u5bfc\u51fa", "\u6253\u5f00\u5bfc\u5165/\u5bfc\u51fa\u7a97\u53e3\u3002", OptionsDialogue.IMPORT_EXPORT));
                }
            }, false);
            MainController.addTooltipListeners(id, new TooltipInformationEventListener().setInformation("\u5220\u9664", ""));
        }
        if (MainController.document.getElementById("NEW_SAVE") != null) {
            ((EventTarget)((Object)MainController.document.getElementById("NEW_SAVE"))).addEventListener("click", e -> {
                Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('new_save_name').value;");
                Main.saveGame(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent(), false, false);
            }, false);
        }
    }

    public static void initPlayerImportListeners() {
        for (File f : Main.getCharactersForImport()) {
            String fileIdentifier = Util.getFileIdentifier(f);
            if (MainController.document.getElementById("IMPORT_CHARACTER_" + fileIdentifier) == null) continue;
            ((EventTarget)((Object)MainController.document.getElementById("IMPORT_CHARACTER_" + fileIdentifier))).addEventListener("click", e -> Main.importCharacter(f), false);
        }
    }

    public static void initSlaveImportListeners() {
        for (File f : Main.getSlavesForImport()) {
            String fileIdentifier = Util.getFileIdentifier(f);
            String fileName = Util.getFileName(f);
            if (MainController.document.getElementById("IMPORT_SLAVE_" + fileIdentifier) == null) continue;
            ((EventTarget)((Object)MainController.document.getElementById("IMPORT_SLAVE_" + fileIdentifier))).addEventListener("click", e -> {
                try {
                    Game.importCharacterAsSlave(fileName);
                    MainController.updateUI();
                    Main.game.flashMessage(PresetColour.GENERIC_GOOD, "\u89d2\u8272\u5df2\u5bfc\u5165\uff01");
                }
                catch (Exception ex) {
                    Main.game.flashMessage(PresetColour.GENERIC_BAD, "\u5bfc\u5165\u5931\u8d25\uff01");
                }
            }, false);
        }
    }

    public static void initAuctionListeners() {
        for (NPC npc : Main.game.getCharactersPresent()) {
            String id = npc.getId() + "_BID";
            if (MainController.document.getElementById(id) == null) continue;
            if (Main.game.getPlayer().isHasSlaverLicense()) {
                ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                    SlaverAlleyDialogue.setupBidding(npc);
                    Main.game.setContent(new Response("", "", SlaverAlleyDialogue.AUCTION_BIDDING));
                }, false);
                MainController.addTooltipListeners(id, new TooltipInformationEventListener().setInformation(UtilText.parse((GameCharacter)npc, "\u7ed9[npc.name]\u7ade\u4ef7", new ParserTag[0]), UtilText.parse((GameCharacter)npc, "\u5f00\u59cb\u7ed9[npc.name]\u7ade\u4ef7\u3002\u6709\u53ef\u80fd\u7ade\u4ef7\u4f1a\u8d85\u8fc7[npc.her]\u7684\u4ef7\u503c\uff0c\u6240\u4ee5\u8bf7\u5148\u51c6\u5907\u597d\u8db3\u591f\u7684\u94b1\uff01", new ParserTag[0])));
                continue;
            }
            MainController.addTooltipListeners(id, new TooltipInformationEventListener().setInformation(UtilText.parse((GameCharacter)npc, "\u7ed9[npc.name]\u7ade\u4ef7", new ParserTag[0]), UtilText.parse((GameCharacter)npc, "\u4f60\u6ca1\u6709\u8d29\u5974\u8bb8\u53ef\uff0c\u6240\u4ee5\u65e0\u6cd5\u4e3a\u4efb\u4f55\u5974\u96b6\u7ade\u4ef7\uff01", new ParserTag[0])));
        }
    }

    public static void initLodgerImportListeners() {
        for (File f : Main.getSlavesForImport()) {
            String fileIdentifier = Util.getFileIdentifier(f);
            String fileName = Util.getFileName(f);
            if (MainController.document.getElementById("IMPORT_LODGER_" + fileIdentifier) == null) continue;
            ((EventTarget)((Object)MainController.document.getElementById("IMPORT_LODGER_" + fileIdentifier))).addEventListener("click", e -> {
                try {
                    Game.importCharacterAsLodger(fileName);
                    MainController.updateUI();
                    Main.game.flashMessage(PresetColour.GENERIC_GOOD, "\u89d2\u8272\u5df2\u5bfc\u5165\uff01");
                }
                catch (Exception ex) {
                    Main.game.flashMessage(PresetColour.GENERIC_BAD, "\u5bfc\u5165\u5931\u8d25\uff01");
                }
            }, false);
        }
    }

    public static void initLodgerWaitingListeners() {
        for (NPC npc : Main.game.getCharactersPresent()) {
            String id = npc.getId() + "_LODGER";
            if (MainController.document.getElementById(id) == null) continue;
            ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                CityHall.setupLodger(npc);
                Main.game.setContent(new Response("", "", CityHall.CITY_HALL_APPROACH_LODGER));
            }, false);
            MainController.addTooltipListeners(id, new TooltipInformationEventListener().setInformation(UtilText.parse((GameCharacter)npc, "\u5bfb\u627e[npc.name]", new ParserTag[0]), UtilText.parse((GameCharacter)npc, "\u73af\u987e\u56db\u5468\uff0c\u770b\u770b\u80fd\u5426\u5728\u7b49\u5f85\u533a\u627e\u5230[npc.name]\u2026\u2026", new ParserTag[0])));
        }
    }

    public static void initClubberImportListeners() {
        for (File f : Main.getSlavesForImport()) {
            String fileIdentifier = Util.getFileIdentifier(f);
            String fileName = Util.getFileName(f);
            if (MainController.document.getElementById("IMPORT_CLUBBER_" + fileIdentifier) == null) continue;
            ((EventTarget)((Object)MainController.document.getElementById("IMPORT_CLUBBER_" + fileIdentifier))).addEventListener("click", e -> {
                try {
                    Game.importCharacterAsClubber(fileName);
                    MainController.updateUI();
                    Main.game.setContent(new Response("", "", Main.game.getDefaultDialogue()));
                    Main.game.flashMessage(PresetColour.GENERIC_GOOD, "\u89d2\u8272\u5df2\u5bfc\u5165\uff01");
                }
                catch (Exception ex) {
                    Main.game.flashMessage(PresetColour.GENERIC_BAD, "\u5bfc\u5165\u5931\u8d25\uff01");
                }
            }, false);
        }
    }

    public static void initEnchantmentSaveLoadListeners() {
        Object id;
        for (File file : EnchantmentDialogue.getSavedEnchants()) {
            String fileIdentifier = Util.getFileIdentifier(file);
            String fileName = Util.getFileName(file);
            id = "OVERWRITE_" + fileIdentifier;
            if (MainController.document.getElementById((String)id) != null) {
                ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                    if (!Main.getProperties().hasValue(PropertyValue.overwriteWarning) || EnchantmentDialogue.overwriteConfirmationName.equals(f.getName())) {
                        EnchantmentDialogue.overwriteConfirmationName = "";
                        EnchantmentDialogue.saveEnchant(fileName, true, EnchantmentDialogue.ENCHANTMENT_SAVE_LOAD);
                    } else {
                        EnchantmentDialogue.overwriteConfirmationName = f.getName();
                        EnchantmentDialogue.loadConfirmationName = "";
                        EnchantmentDialogue.deleteConfirmationName = "";
                        Main.game.setContent(new Response("\u4fdd\u5b58/\u52a0\u8f7d", "\u6253\u5f00\u4fdd\u5b58/\u52a0\u8f7d\u9644\u9b54\u7a97\u53e3\u3002", EnchantmentDialogue.ENCHANTMENT_SAVE_LOAD));
                    }
                }, false);
                MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u8986\u76d6", ""));
            }
            if (MainController.document.getElementById((String)(id = "LOAD_" + fileIdentifier)) != null) {
                ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                    if (!Main.getProperties().hasValue(PropertyValue.overwriteWarning) || EnchantmentDialogue.loadConfirmationName.equals(f.getName())) {
                        EnchantmentDialogue.loadConfirmationName = "";
                        LoadedEnchantment lEnch = EnchantmentDialogue.loadEnchant(fileName);
                        EnchantmentDialogue.resetNonTattooEnchantmentVariables();
                        AbstractCoreItem abstractItem = lEnch.getSuitableItem();
                        EnchantmentDialogue.initModifiers(abstractItem);
                        EnchantmentDialogue.getEffects().clear();
                        for (ItemEffect ie : lEnch.getEffects()) {
                            EnchantmentDialogue.addEffect(ie);
                        }
                        EnchantmentDialogue.setOutputName(lEnch.getName());
                        Main.game.setContent(new Response("\u4fdd\u5b58/\u52a0\u8f7d", "\u6253\u5f00\u4fdd\u5b58/\u52a0\u8f7d\u9644\u9b54\u7a97\u53e3\u3002", EnchantmentDialogue.ENCHANTMENT_MENU));
                    } else {
                        EnchantmentDialogue.overwriteConfirmationName = "";
                        EnchantmentDialogue.loadConfirmationName = f.getName();
                        EnchantmentDialogue.deleteConfirmationName = "";
                        Main.game.setContent(new Response("\u4fdd\u5b58/\u52a0\u8f7d", "\u6253\u5f00\u4fdd\u5b58/\u52a0\u8f7d\u9644\u9b54\u7a97\u53e3\u3002", EnchantmentDialogue.ENCHANTMENT_SAVE_LOAD));
                    }
                }, false);
                MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u52a0\u8f7d", ""));
            }
            if (MainController.document.getElementById((String)(id = "DELETE_" + fileIdentifier)) == null) continue;
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                if (!Main.getProperties().hasValue(PropertyValue.overwriteWarning) || EnchantmentDialogue.deleteConfirmationName.equals(f.getName())) {
                    EnchantmentDialogue.deleteConfirmationName = "";
                    EnchantmentDialogue.deleteEnchant(fileName);
                    EnchantmentDialogue.initSaveLoadMenu();
                    Main.game.setContent(new Response("\u4fdd\u5b58/\u52a0\u8f7d", "", EnchantmentDialogue.ENCHANTMENT_SAVE_LOAD));
                } else {
                    EnchantmentDialogue.overwriteConfirmationName = "";
                    EnchantmentDialogue.loadConfirmationName = "";
                    EnchantmentDialogue.deleteConfirmationName = f.getName();
                    Main.game.setContent(new Response("\u4fdd\u5b58/\u52a0\u8f7d", "", EnchantmentDialogue.ENCHANTMENT_SAVE_LOAD));
                }
            }, false);
            MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u5220\u9664", ""));
        }
        id = "NEW_SAVE";
        if (MainController.document.getElementById((String)id) != null) {
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('new_save_name').value;");
                EnchantmentDialogue.saveEnchant(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent(), false, EnchantmentDialogue.ENCHANTMENT_SAVE_LOAD);
            }, false);
            MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u4fdd\u5b58", ""));
        }
        for (Map.Entry entry : EnchantmentDialogue.getLoadedEnchantmentsMap().entrySet()) {
            id = "LOADED_ENCHANTMENT_" + (String)entry.getKey();
            if (MainController.document.getElementById((String)id) == null) continue;
            MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setLoadedEnchantment((LoadedEnchantment)entry.getValue()));
        }
        id = "LOADED_ENCHANTMENT_CURRENT";
        if (MainController.document.getElementById((String)id) != null) {
            MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setLoadedEnchantment(EnchantmentDialogue.getCurrentEnchantmentAsLoadedEnchantment()));
        }
    }

    public static void initTattooSaveLoadListeners() {
        Object id;
        for (File file : CosmeticsDialogue.getSavedTattoos()) {
            String fileIdentifier = Util.getFileIdentifier(file);
            String fileName = Util.getFileName(file);
            id = "OVERWRITE_" + fileIdentifier;
            if (MainController.document.getElementById((String)id) != null) {
                ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                    if (!Main.getProperties().hasValue(PropertyValue.overwriteWarning) || CosmeticsDialogue.overwriteConfirmationName.equals(f.getName())) {
                        CosmeticsDialogue.overwriteConfirmationName = "";
                        CosmeticsDialogue.saveTattoo(fileName, true, CosmeticsDialogue.TATTOO_SAVE_LOAD);
                    } else {
                        CosmeticsDialogue.overwriteConfirmationName = f.getName();
                        CosmeticsDialogue.loadConfirmationName = "";
                        CosmeticsDialogue.deleteConfirmationName = "";
                        Main.game.setContent(new Response("\u4fdd\u5b58/\u52a0\u8f7d", "\u6253\u5f00\u4fdd\u5b58/\u52a0\u8f7d\u7eb9\u8eab\u7a97\u53e3\u3002", CosmeticsDialogue.TATTOO_SAVE_LOAD));
                    }
                }, false);
                MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u8986\u76d6", ""));
            }
            if (MainController.document.getElementById((String)(id = "LOAD_" + fileIdentifier)) != null) {
                ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                    if (!Main.getProperties().hasValue(PropertyValue.overwriteWarning) || CosmeticsDialogue.loadConfirmationName.equals(f.getName())) {
                        Tattoo loadedTattoo;
                        CosmeticsDialogue.loadConfirmationName = "";
                        CharacterModificationUtils.tattoo = loadedTattoo = CosmeticsDialogue.loadTattoo(fileName);
                        Main.game.setContent(new Response("\u4fdd\u5b58/\u52a0\u8f7d", "\u6253\u5f00\u4fdd\u5b58/\u52a0\u8f7d\u7eb9\u8eab\u7a97\u53e3\u3002", CosmeticsDialogue.getReturnToNodeFromTattooSaveLoad()));
                    } else {
                        CosmeticsDialogue.overwriteConfirmationName = "";
                        CosmeticsDialogue.loadConfirmationName = f.getName();
                        CosmeticsDialogue.deleteConfirmationName = "";
                        Main.game.setContent(new Response("\u4fdd\u5b58/\u52a0\u8f7d", "\u6253\u5f00\u4fdd\u5b58/\u52a0\u8f7d\u7eb9\u8eab\u7a97\u53e3\u3002", CosmeticsDialogue.TATTOO_SAVE_LOAD));
                    }
                }, false);
                MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u52a0\u8f7d", ""));
            }
            if (MainController.document.getElementById((String)(id = "DELETE_" + fileIdentifier)) == null) continue;
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                if (!Main.getProperties().hasValue(PropertyValue.overwriteWarning) || CosmeticsDialogue.deleteConfirmationName.equals(f.getName())) {
                    CosmeticsDialogue.deleteConfirmationName = "";
                    CosmeticsDialogue.deleteTattoo(fileName);
                    CosmeticsDialogue.initSaveLoadMenu();
                    Main.game.setContent(new Response("\u4fdd\u5b58/\u52a0\u8f7d", ".", CosmeticsDialogue.TATTOO_SAVE_LOAD));
                } else {
                    CosmeticsDialogue.overwriteConfirmationName = "";
                    CosmeticsDialogue.loadConfirmationName = "";
                    CosmeticsDialogue.deleteConfirmationName = f.getName();
                    Main.game.setContent(new Response("\u4fdd\u5b58/\u52a0\u8f7d", ".", CosmeticsDialogue.TATTOO_SAVE_LOAD));
                }
            }, false);
            MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u5220\u9664", ""));
        }
        id = "NEW_SAVE";
        if (MainController.document.getElementById((String)id) != null) {
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('new_save_name').value;");
                CosmeticsDialogue.saveTattoo(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent(), false, CosmeticsDialogue.TATTOO_SAVE_LOAD);
            }, false);
            MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u4fdd\u5b58", ""));
        }
        for (Map.Entry entry : CosmeticsDialogue.getLoadedTattoosMap().entrySet()) {
            id = "LOADED_TATTOO_" + (String)entry.getKey();
            if (MainController.document.getElementById((String)id) == null) continue;
            MainController.addTooltipListeners((String)id, new TooltipInventoryEventListener().setTattoo(CharacterModificationUtils.tattooInventorySlot, (Tattoo)entry.getValue(), BodyChanging.getTarget(), BodyChanging.getTarget()));
        }
        id = "LOADED_TATTOO_CURRENT";
        if (MainController.document.getElementById((String)id) != null) {
            MainController.addTooltipListeners((String)id, new TooltipInventoryEventListener().setTattoo(CharacterModificationUtils.tattooInventorySlot, CharacterModificationUtils.tattoo, BodyChanging.getTarget(), BodyChanging.getTarget()));
        }
    }

    public static void initBodySaveLoadListeners() {
        Object id;
        for (File file : BodyChanging.getSavedBodies()) {
            String fileIdentifier = Util.getFileIdentifier(file);
            String fileName = Util.getFileName(file);
            id = "OVERWRITE_" + fileIdentifier;
            if (MainController.document.getElementById((String)id) != null) {
                ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                    if (!Main.getProperties().hasValue(PropertyValue.overwriteWarning) || BodyChanging.overwriteConfirmationName.equals(f.getName())) {
                        BodyChanging.overwriteConfirmationName = "";
                        BodyChanging.saveBody(fileName, true);
                    } else {
                        BodyChanging.overwriteConfirmationName = f.getName();
                        BodyChanging.loadConfirmationName = "";
                        BodyChanging.deleteConfirmationName = "";
                        Main.game.setContent(new Response("\u4fdd\u5b58/\u52a0\u8f7d", "\u6253\u5f00\u4fdd\u5b58/\u52a0\u8f7d\u8f6c\u5316\u7a97\u53e3\u3002", BodyChanging.BODY_CHANGING_SAVE_LOAD));
                    }
                }, false);
                MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u8986\u76d6", ""));
            }
            if (MainController.document.getElementById((String)(id = "LOAD_" + fileIdentifier)) != null) {
                ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                    Body loadedBody = BodyChanging.loadBody(fileName);
                    if (BodyChanging.isPresetTransformationAvailable(loadedBody)) {
                        if (!Main.getProperties().hasValue(PropertyValue.overwriteWarning) || BodyChanging.loadConfirmationName.equals(f.getName())) {
                            BodyChanging.loadConfirmationName = "";
                            BodyChanging.applyLoadedBody(loadedBody);
                            Main.game.setContent(new Response("\u4fdd\u5b58/\u52a0\u8f7d", "\u6253\u5f00\u4fdd\u5b58/\u52a0\u8f7d\u8f6c\u5316\u7a97\u53e3\u3002", BodyChanging.BODY_CHANGING_CORE));
                        } else {
                            BodyChanging.overwriteConfirmationName = "";
                            BodyChanging.loadConfirmationName = f.getName();
                            BodyChanging.deleteConfirmationName = "";
                            Main.game.setContent(new Response("\u4fdd\u5b58/\u52a0\u8f7d", "\u6253\u5f00\u4fdd\u5b58/\u52a0\u8f7d\u8f6c\u5316\u7a97\u53e3\u3002", BodyChanging.BODY_CHANGING_SAVE_LOAD));
                        }
                    }
                }, false);
                MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u8bfb\u53d6", BodyChanging.isPresetTransformationAvailable(BodyChanging.loadBody(fileName)) ? "" : BodyChanging.getPresetTransformationUnavailabilityText(BodyChanging.loadBody(fileName))));
            }
            if (MainController.document.getElementById((String)(id = "DELETE_" + fileIdentifier)) == null) continue;
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                if (!Main.getProperties().hasValue(PropertyValue.overwriteWarning) || BodyChanging.deleteConfirmationName.equals(f.getName())) {
                    BodyChanging.deleteConfirmationName = "";
                    BodyChanging.deleteBody(fileName);
                    BodyChanging.initSaveLoadMenu();
                    Main.game.setContent(new Response("\u4fdd\u5b58/\u52a0\u8f7d", "", BodyChanging.BODY_CHANGING_SAVE_LOAD));
                } else {
                    BodyChanging.overwriteConfirmationName = "";
                    BodyChanging.loadConfirmationName = "";
                    BodyChanging.deleteConfirmationName = f.getName();
                    Main.game.setContent(new Response("\u4fdd\u5b58/\u52a0\u8f7d", "", BodyChanging.BODY_CHANGING_SAVE_LOAD));
                }
            }, false);
            MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u5220\u9664", ""));
        }
        id = "NEW_SAVE";
        if (MainController.document.getElementById((String)id) != null) {
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('new_save_name').value;");
                BodyChanging.saveBody(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent(), false);
            }, false);
            MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setInformation("\u4fdd\u5b58", ""));
        }
        for (Map.Entry entry : BodyChanging.getPresetTransformationsMap().entrySet()) {
            id = "LOADED_BODY_" + (String)entry.getKey();
            if (MainController.document.getElementById((String)id) == null) continue;
            MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setLoadedBody((Body)((Util.Value)entry.getValue()).getValue(), BodyChanging.getTarget()));
        }
    }

    public static void initOutfitListeners() {
        for (File f : LilayaDressingRoomDialogue.getSavedOutfits()) {
            String fileIdentifier = Util.getFileIdentifier(f);
            String fileName = Util.getFileName(f);
            String id = "LOADED_OUTFIT_" + fileIdentifier;
            if (MainController.document.getElementById(id) != null) {
                ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                    String name = Util.getFileIdentifier(f);
                    Outfit loadedOutfit = LilayaDressingRoomDialogue.loadOutfit(name);
                    LilayaDressingRoomDialogue.setActiveOutfit(loadedOutfit);
                    Main.game.setContent(new Response("", "", LilayaDressingRoomDialogue.OUTFIT_EDITOR));
                }, false);
                String name = Util.getFileIdentifier(f);
                Outfit loadedOutfit = LilayaDressingRoomDialogue.loadOutfit(name);
                int availabeOutfits = LilayaDressingRoomDialogue.getOutfitAvailabilityFromTile(loadedOutfit);
                int essenceCost = loadedOutfit.getEssenceCost();
                MainController.addTooltipListeners(id, new TooltipInformationEventListener().setInformation(Util.capitaliseSentence(loadedOutfit.getName()), "\u8be5\u5957\u88c5\u4e2d\u7684\u8863\u7269\u603b\u6570\uff1a" + loadedOutfit.getClothing().size() + "<br/>\u8be5\u5957\u88c5\u4e2d\u7684\u6b66\u5668\u603b\u6570\uff1a" + loadedOutfit.getWeapons().size() + "<br/>\u5b58\u50a8\u5728\u533a\u57df\u4e2d\u7684\u53ef\u7528\u7269\u54c1\u6570\uff1a" + availabeOutfits + "<br/>\u8d2d\u4e70\u5b8c\u6574\u5957\u88c5\u7684\u8d39\u7528\uff1a" + UtilText.formatAsMoney(loadedOutfit.getCost(), "b") + "\uff0c" + (essenceCost == 0 ? UtilText.formatAsEssencesUncoloured(essenceCost, "b", false) : UtilText.formatAsEssences(essenceCost, "b", false)) + "</div>", 72));
            }
            if (MainController.document.getElementById(id = "WEAR_OUTFIT_" + fileIdentifier) != null) {
                ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                    String name = Util.getFileIdentifier(f);
                    Outfit loadedOutfit = LilayaDressingRoomDialogue.loadOutfit(name);
                    Main.game.getPlayer().loadOutfit(loadedOutfit, OutfitSource.CELL, OutfitSource.NOWHERE);
                    Main.game.setContent(new Response("", "", LilayaDressingRoomDialogue.OUTFITS));
                }, false);
                MainController.addTooltipListeners(id, new TooltipInformationEventListener().setInformation("\u88c5\u5907", "\u4f60\u7684\u89d2\u8272\u5c06\u4f1a\u88c5\u5907\u6b64\u5957\u88c5\u6240\u5b9a\u4e49\u7684\u6240\u6709\u8863\u7269\u548c\u6b66\u5668\u3002\u4efb\u4f55\u4f60\u5f53\u524d\u88c5\u5907\u7684\u8863\u7269\u548c\u6b66\u5668\uff0c\u5982\u679c\u5728\u5e94\u7528\u6b64\u5957\u88c5\u65f6\u88ab\u5378\u4e0b\uff0c\u5c06\u88ab\u653e\u5165\u4f60\u7684\u66f4\u8863\u5ba4\u3002"));
            }
            if (MainController.document.getElementById(id = "EDIT_OUTFIT_" + fileIdentifier) != null) {
                ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                    String name = Util.getFileIdentifier(f);
                    Outfit loadedOutfit = LilayaDressingRoomDialogue.loadOutfit(name);
                    LilayaDressingRoomDialogue.setActiveOutfit(loadedOutfit);
                    Main.game.setContent(new Response("", "", LilayaDressingRoomDialogue.OUTFIT_EDITOR));
                }, false);
            }
            if (MainController.document.getElementById(id = "DELETE_OUTFIT_" + fileIdentifier) == null) continue;
            ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                if (!Main.getProperties().hasValue(PropertyValue.overwriteWarning) || LilayaDressingRoomDialogue.deleteConfirmationName.equals(f.getName())) {
                    LilayaDressingRoomDialogue.deleteConfirmationName = "";
                    LilayaDressingRoomDialogue.deleteOutfit(fileName);
                    Main.game.setContent(new Response("", "", LilayaDressingRoomDialogue.OUTFITS));
                } else {
                    LilayaDressingRoomDialogue.deleteConfirmationName = f.getName();
                    Main.game.setContent(new Response("", "", LilayaDressingRoomDialogue.OUTFITS));
                }
            }, false);
        }
    }
}

