/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.controller;

import com.lilithsthrone.controller.MainController;
import com.lilithsthrone.controller.eventListeners.InventorySelectedItemEventListener;
import com.lilithsthrone.controller.eventListeners.tooltips.TooltipInformationEventListener;
import com.lilithsthrone.controller.eventListeners.tooltips.TooltipInventoryEventListener;
import com.lilithsthrone.game.combat.DamageType;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.InventoryDialogue;
import com.lilithsthrone.game.dialogue.utils.InventoryInteraction;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.ColourReplacement;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.ShopTransaction;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.AbstractClothingType;
import com.lilithsthrone.game.inventory.clothing.Sticker;
import com.lilithsthrone.game.inventory.clothing.StickerCategory;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.game.inventory.weapon.AbstractWeaponType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.Pattern;
import com.lilithsthrone.rendering.RenderingEngine;
import com.lilithsthrone.utils.colours.Colour;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.events.EventTarget;

public class InventoryController {
    public static void initInventoryListeners() {
        for (int i = 0; i < 5; ++i) {
            MainController.setInventoryPageLeft(i);
            MainController.setInventoryPageRight(i);
        }
        MainController.setInventoryPageLeft(5);
        MainController.setInventoryPageRight(5);
        Object id = "FLOOR_SCROLL_LEFT_DOUBLE";
        if (MainController.document.getElementById((String)id) != null) {
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                RenderingEngine.setPageRight(RenderingEngine.getPageRight() - 5);
                Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
            }, false);
        }
        if (MainController.document.getElementById((String)(id = "FLOOR_SCROLL_LEFT")) != null) {
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                RenderingEngine.setPageRight(RenderingEngine.getPageRight() - 1);
                Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
            }, false);
        }
        if (MainController.document.getElementById((String)(id = "FLOOR_SCROLL_RIGHT")) != null) {
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                RenderingEngine.setPageRight(Math.min(RenderingEngine.getPageRight() + 1, RenderingEngine.getMaximumFloorPageIndex()));
                Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
            }, false);
        }
        if (MainController.document.getElementById((String)(id = "FLOOR_SCROLL_RIGHT_DOUBLE")) != null) {
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                RenderingEngine.setPageRight(Math.min(RenderingEngine.getPageRight() + 5, RenderingEngine.getMaximumFloorPageIndex()));
                Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
            }, false);
        }
        for (Map.Entry<AbstractWeapon, Integer> entry : Main.game.getPlayer().getAllWeaponsInInventory().entrySet()) {
            id = "PLAYER_WEAPON_" + entry.getKey().hashCode();
            if (MainController.document.getElementById((String)id) == null) continue;
            MainController.addTooltipListeners((String)id, new TooltipInventoryEventListener().setWeapon(entry.getKey(), Main.game.getPlayer(), false), new InventorySelectedItemEventListener().setWeaponInventory(entry.getKey(), Main.game.getPlayer()), false);
        }
        for (Map.Entry<AbstractCoreItem, Integer> entry : Main.game.getPlayer().getAllItemsInInventory().entrySet()) {
            id = "PLAYER_ITEM_" + ((AbstractItem)entry.getKey()).hashCode();
            if (MainController.document.getElementById((String)id) == null) continue;
            MainController.addTooltipListeners((String)id, new TooltipInventoryEventListener().setItem((AbstractItem)entry.getKey(), Main.game.getPlayer(), null), new InventorySelectedItemEventListener().setItemInventory((AbstractItem)entry.getKey(), Main.game.getPlayer()), false);
        }
        for (Map.Entry<AbstractCoreItem, Integer> entry : Main.game.getPlayer().getAllClothingInInventory().entrySet()) {
            id = "PLAYER_CLOTHING_" + ((AbstractClothing)entry.getKey()).hashCode();
            if (MainController.document.getElementById((String)id) == null) continue;
            MainController.addTooltipListeners((String)id, new TooltipInventoryEventListener().setClothing((AbstractClothing)entry.getKey(), Main.game.getPlayer(), null), new InventorySelectedItemEventListener().setClothingInventory((AbstractClothing)entry.getKey(), Main.game.getPlayer()), false);
        }
        id = "PLAYER_MONEY_TRANSFER_SMALL";
        if (MainController.document.getElementById((String)id) != null) {
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                if (Main.game.getPlayer().getMoney() > 0L && InventoryDialogue.getNPCInventoryInteraction() == InventoryInteraction.FULL_MANAGEMENT) {
                    if (InventoryDialogue.getInventoryNPC() == null) {
                        Main.game.getPlayerCell().getInventory().incrementMoney((long)Math.max(1.0f, (float)Main.game.getPlayer().getMoney() * 0.01f));
                    } else {
                        InventoryDialogue.getInventoryNPC().incrementMoney((long)Math.max(1.0f, (float)Main.game.getPlayer().getMoney() * 0.01f));
                    }
                    Main.game.getPlayer().incrementMoney((long)(-Math.max(1.0f, (float)Main.game.getPlayer().getMoney() * 0.01f)));
                    Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                }
            }, false);
            MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setMoneyTransferTarget(Main.game.getPlayer(), InventoryDialogue.getInventoryNPC(), 1));
        }
        if (MainController.document.getElementById((String)(id = "PLAYER_MONEY_TRANSFER_AVERAGE")) != null) {
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                if (Main.game.getPlayer().getMoney() > 0L && InventoryDialogue.getNPCInventoryInteraction() == InventoryInteraction.FULL_MANAGEMENT) {
                    if (InventoryDialogue.getInventoryNPC() == null) {
                        Main.game.getPlayerCell().getInventory().incrementMoney((long)Math.max(1.0f, (float)Main.game.getPlayer().getMoney() * 0.1f));
                    } else {
                        InventoryDialogue.getInventoryNPC().incrementMoney((long)Math.max(1.0f, (float)Main.game.getPlayer().getMoney() * 0.1f));
                    }
                    Main.game.getPlayer().incrementMoney((long)(-Math.max(1.0f, (float)Main.game.getPlayer().getMoney() * 0.1f)));
                    Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                }
            }, false);
            MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setMoneyTransferTarget(Main.game.getPlayer(), InventoryDialogue.getInventoryNPC(), 10));
        }
        if (MainController.document.getElementById((String)(id = "PLAYER_MONEY_TRANSFER_BIG")) != null) {
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                if (Main.game.getPlayer().getMoney() > 0L && InventoryDialogue.getNPCInventoryInteraction() == InventoryInteraction.FULL_MANAGEMENT) {
                    if (InventoryDialogue.getInventoryNPC() == null) {
                        Main.game.getPlayerCell().getInventory().incrementMoney(Math.max(1L, Main.game.getPlayer().getMoney()));
                    } else {
                        InventoryDialogue.getInventoryNPC().incrementMoney(Math.max(1L, Main.game.getPlayer().getMoney()));
                    }
                    Main.game.getPlayer().incrementMoney(-Math.max(1L, Main.game.getPlayer().getMoney()));
                    Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                }
            }, false);
            MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setMoneyTransferTarget(Main.game.getPlayer(), InventoryDialogue.getInventoryNPC(), 100));
        }
        if (InventoryDialogue.getInventoryNPC() != null) {
            Iterator<Map.Entry<AbstractCoreItem, Integer>> idModifier = "NPC_" + InventoryDialogue.getInventoryNPC().getId() + "_";
            for (Map.Entry<AbstractWeapon, Integer> entry : InventoryDialogue.getInventoryNPC().getAllWeaponsInInventory().entrySet()) {
                id = idModifier + "WEAPON_" + entry.getKey().hashCode();
                if (MainController.document.getElementById((String)id) == null) continue;
                MainController.addTooltipListeners((String)id, new TooltipInventoryEventListener().setWeapon(entry.getKey(), InventoryDialogue.getInventoryNPC(), false), new InventorySelectedItemEventListener().setWeaponInventory(entry.getKey(), InventoryDialogue.getInventoryNPC()), false);
            }
            for (Map.Entry<AbstractClothing, Integer> entry : InventoryDialogue.getInventoryNPC().getAllClothingInInventory().entrySet()) {
                id = idModifier + "CLOTHING_" + entry.getKey().hashCode();
                if (MainController.document.getElementById((String)id) == null) continue;
                MainController.addTooltipListeners((String)id, new TooltipInventoryEventListener().setClothing(entry.getKey(), InventoryDialogue.getInventoryNPC(), null), new InventorySelectedItemEventListener().setClothingInventory(entry.getKey(), InventoryDialogue.getInventoryNPC()), false);
            }
            for (Map.Entry<AbstractItem, Integer> entry : InventoryDialogue.getInventoryNPC().getAllItemsInInventory().entrySet()) {
                id = idModifier + "ITEM_" + entry.getKey().hashCode();
                if (MainController.document.getElementById((String)id) == null) continue;
                MainController.addTooltipListeners((String)id, new TooltipInventoryEventListener().setItem(entry.getKey(), InventoryDialogue.getInventoryNPC(), null), new InventorySelectedItemEventListener().setItemInventory(entry.getKey(), InventoryDialogue.getInventoryNPC()), false);
            }
            id = idModifier + "MONEY_TRANSFER_SMALL";
            if (MainController.document.getElementById((String)id) != null) {
                ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                    if (InventoryDialogue.getInventoryNPC().getMoney() > 0L && InventoryDialogue.getNPCInventoryInteraction() == InventoryInteraction.FULL_MANAGEMENT) {
                        Main.game.getPlayer().incrementMoney((long)Math.max(1.0f, (float)InventoryDialogue.getInventoryNPC().getMoney() * 0.01f));
                        InventoryDialogue.getInventoryNPC().incrementMoney((long)(-Math.max(1.0f, (float)InventoryDialogue.getInventoryNPC().getMoney() * 0.01f)));
                        Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                    }
                }, false);
                MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setMoneyTransferTarget(InventoryDialogue.getInventoryNPC(), Main.game.getPlayer(), 1));
            }
            if (MainController.document.getElementById((String)(id = idModifier + "MONEY_TRANSFER_AVERAGE")) != null) {
                ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                    if (InventoryDialogue.getInventoryNPC().getMoney() > 0L && InventoryDialogue.getNPCInventoryInteraction() == InventoryInteraction.FULL_MANAGEMENT) {
                        Main.game.getPlayer().incrementMoney((long)Math.max(1.0f, (float)InventoryDialogue.getInventoryNPC().getMoney() * 0.1f));
                        InventoryDialogue.getInventoryNPC().incrementMoney((long)(-Math.max(1.0f, (float)InventoryDialogue.getInventoryNPC().getMoney() * 0.1f)));
                        Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                    }
                }, false);
                MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setMoneyTransferTarget(InventoryDialogue.getInventoryNPC(), Main.game.getPlayer(), 10));
            }
            if (MainController.document.getElementById((String)(id = idModifier + "MONEY_TRANSFER_BIG")) != null) {
                ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                    if (InventoryDialogue.getInventoryNPC().getMoney() > 0L && InventoryDialogue.getNPCInventoryInteraction() == InventoryInteraction.FULL_MANAGEMENT) {
                        Main.game.getPlayer().incrementMoney(Math.max(1L, InventoryDialogue.getInventoryNPC().getMoney()));
                        InventoryDialogue.getInventoryNPC().incrementMoney(-Math.max(1L, InventoryDialogue.getInventoryNPC().getMoney()));
                        Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                    }
                }, false);
                MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setMoneyTransferTarget(InventoryDialogue.getInventoryNPC(), Main.game.getPlayer(), 100));
            }
        } else {
            for (Map.Entry entry : Main.game.getPlayerCell().getInventory().getAllWeaponsInInventory().entrySet()) {
                id = "FLOOR_WEAPON_" + ((AbstractWeapon)entry.getKey()).hashCode();
                if (MainController.document.getElementById((String)id) == null) continue;
                MainController.addTooltipListeners((String)id, new TooltipInventoryEventListener().setWeapon((AbstractWeapon)entry.getKey(), null, false), new InventorySelectedItemEventListener().setWeaponInventory((AbstractWeapon)entry.getKey(), null), false);
            }
            for (Map.Entry<AbstractClothing, Integer> entry : Main.game.getPlayerCell().getInventory().getAllClothingInInventory().entrySet()) {
                id = "FLOOR_CLOTHING_" + entry.getKey().hashCode();
                if (MainController.document.getElementById((String)id) == null) continue;
                MainController.addTooltipListeners((String)id, new TooltipInventoryEventListener().setClothing(entry.getKey(), null, null), new InventorySelectedItemEventListener().setClothingInventory(entry.getKey(), null), false);
            }
            for (Map.Entry<AbstractCoreItem, Integer> entry : Main.game.getPlayerCell().getInventory().getAllItemsInInventory().entrySet()) {
                id = "FLOOR_ITEM_" + ((AbstractItem)entry.getKey()).hashCode();
                if (MainController.document.getElementById((String)id) == null) continue;
                MainController.addTooltipListeners((String)id, new TooltipInventoryEventListener().setItem((AbstractItem)entry.getKey(), null, null), new InventorySelectedItemEventListener().setItemInventory((AbstractItem)entry.getKey(), null), false);
            }
            id = "FLOOR_MONEY_TRANSFER_SMALL";
            if (MainController.document.getElementById((String)id) != null) {
                ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                    if (Main.game.getPlayerCell().getInventory().getMoney() > 0L && InventoryDialogue.getNPCInventoryInteraction() == InventoryInteraction.FULL_MANAGEMENT) {
                        Main.game.getPlayer().incrementMoney((long)Math.max(1.0f, (float)Main.game.getPlayerCell().getInventory().getMoney() * 0.01f));
                        Main.game.getPlayerCell().getInventory().incrementMoney((long)(-Math.max(1.0f, (float)Main.game.getPlayerCell().getInventory().getMoney() * 0.01f)));
                        Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                    }
                }, false);
                MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setMoneyTransferTarget(null, Main.game.getPlayer(), 1));
            }
            if (MainController.document.getElementById((String)(id = "FLOOR_MONEY_TRANSFER_AVERAGE")) != null) {
                ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                    if (Main.game.getPlayerCell().getInventory().getMoney() > 0L && InventoryDialogue.getNPCInventoryInteraction() == InventoryInteraction.FULL_MANAGEMENT) {
                        Main.game.getPlayer().incrementMoney((long)Math.max(1.0f, (float)Main.game.getPlayerCell().getInventory().getMoney() * 0.1f));
                        Main.game.getPlayerCell().getInventory().incrementMoney((long)(-Math.max(1.0f, (float)Main.game.getPlayerCell().getInventory().getMoney() * 0.1f)));
                        Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                    }
                }, false);
                MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setMoneyTransferTarget(null, Main.game.getPlayer(), 10));
            }
            if (MainController.document.getElementById((String)(id = "FLOOR_MONEY_TRANSFER_BIG")) != null) {
                ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                    if (Main.game.getPlayerCell().getInventory().getMoney() > 0L && InventoryDialogue.getNPCInventoryInteraction() == InventoryInteraction.FULL_MANAGEMENT) {
                        Main.game.getPlayer().incrementMoney(Math.max(1L, Main.game.getPlayerCell().getInventory().getMoney()));
                        Main.game.getPlayerCell().getInventory().incrementMoney(-Math.max(1L, Main.game.getPlayerCell().getInventory().getMoney()));
                        Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                    }
                }, false);
                MainController.addTooltipListeners((String)id, new TooltipInformationEventListener().setMoneyTransferTarget(null, Main.game.getPlayer(), 100));
            }
        }
        if (InventoryDialogue.getNPCInventoryInteraction() == InventoryInteraction.TRADING && InventoryDialogue.getInventoryNPC() != null) {
            for (int i = Main.game.getPlayer().getBuybackStack().size() - 1; i >= 0; --i) {
                if (MainController.document.getElementById("WEAPON_" + i) != null) {
                    MainController.addTooltipListeners("WEAPON_" + i, new TooltipInventoryEventListener().setWeapon((AbstractWeapon)((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(i)).getAbstractItemSold(), InventoryDialogue.getInventoryNPC(), false), new InventorySelectedItemEventListener().setWeaponInventory((AbstractWeapon)((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(i)).getAbstractItemSold(), InventoryDialogue.getInventoryNPC(), i), false);
                    continue;
                }
                if (MainController.document.getElementById("CLOTHING_" + i) != null) {
                    MainController.addTooltipListeners("CLOTHING_" + i, new TooltipInventoryEventListener().setClothing((AbstractClothing)((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(i)).getAbstractItemSold(), InventoryDialogue.getInventoryNPC(), null), new InventorySelectedItemEventListener().setClothingInventory((AbstractClothing)((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(i)).getAbstractItemSold(), InventoryDialogue.getInventoryNPC(), i), false);
                    continue;
                }
                if (MainController.document.getElementById("ITEM_" + i) == null) continue;
                MainController.addTooltipListeners("ITEM_" + i, new TooltipInventoryEventListener().setItem((AbstractItem)((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(i)).getAbstractItemSold(), InventoryDialogue.getInventoryNPC(), null), new InventorySelectedItemEventListener().setItemInventory((AbstractItem)((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(i)).getAbstractItemSold(), InventoryDialogue.getInventoryNPC(), i), false);
            }
        }
    }

    public static void initClothingDyeListeners() {
        AbstractClothingType clothing = InventoryDialogue.getClothing().getClothingType();
        for (int i = 0; i < clothing.getColourReplacements().size(); ++i) {
            int index = i;
            ColourReplacement cr = clothing.getColourReplacement(i);
            for (Colour c : cr.getAllColours()) {
                String id = "DYE_CLOTHING_" + i + "_" + c.getId();
                if (MainController.document.getElementById(id) == null) continue;
                ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                    if (cr.isRecolouringAllowed()) {
                        InventoryDialogue.dyePreviews.remove(index);
                        InventoryDialogue.dyePreviews.add(index, c);
                    }
                    Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                }, false);
                MainController.addTooltipListeners(id, new TooltipInventoryEventListener().setDyeClothing(InventoryDialogue.getClothing(), i, c));
            }
        }
    }

    public static void initPatternListeners() {
        for (Pattern pattern : Pattern.getAllPatterns()) {
            String id = "ITEM_PATTERN_" + pattern.getId();
            if (MainController.document.getElementById(id) == null) continue;
            ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                if (!InventoryDialogue.dyePreviewPattern.equals(pattern.getId())) {
                    InventoryDialogue.dyePreviewPattern = pattern.getId();
                    Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                }
            }, false);
        }
    }

    public static void initPatternRecolourListeners() {
        AbstractClothingType clothing = InventoryDialogue.getClothing().getClothingType();
        for (int i = 0; i < clothing.getPatternColourReplacements().size(); ++i) {
            ColourReplacement cr = clothing.getPatternColourReplacement(i);
            for (Colour c : cr.getAllColours()) {
                String id = "DYE_CLOTHING_PATTERN_" + i + "_" + c.getId();
                if (MainController.document.getElementById(id) == null) continue;
                int finalI = i;
                ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                    InventoryDialogue.dyePreviewPatternColours.remove(finalI);
                    InventoryDialogue.dyePreviewPatternColours.add(finalI, c);
                    Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                }, false);
                MainController.addTooltipListeners(id, new TooltipInventoryEventListener().setDyeClothingPattern(InventoryDialogue.getClothing(), i, c));
            }
        }
    }

    public static void initStickerListeners() {
        AbstractClothingType clothing = InventoryDialogue.getClothing().getClothingType();
        for (Map.Entry<StickerCategory, List<Sticker>> stickerEntry : clothing.getStickers().entrySet()) {
            for (Sticker s : stickerEntry.getValue()) {
                String id = "ITEM_STICKER_" + stickerEntry.getKey().getId() + s.getId();
                String requirements = UtilText.parse(s.getUnavailabilityText(), new ParserTag[0]).trim();
                if (MainController.document.getElementById(id) == null) continue;
                ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                    if (InventoryDialogue.dyePreviewStickers.get(stickerEntry.getKey()) != s && requirements.isEmpty()) {
                        InventoryDialogue.dyePreviewStickers.put((StickerCategory)stickerEntry.getKey(), s);
                        Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                    }
                }, false);
                int lineHeight = 0;
                StringBuilder tooltipDescriptionSB = new StringBuilder();
                if (!requirements.isEmpty()) {
                    tooltipDescriptionSB.append("[style.boldBad(\u5df2\u4e0a\u9501\uff1a)]<i>" + requirements + "</i><br/>");
                    lineHeight += 2;
                } else {
                    if (!s.getAvailabilityText().isEmpty()) {
                        tooltipDescriptionSB.append("[style.boldGood(\u5df2\u89e3\u9501:)]<i>" + s.getAvailabilityText() + "</i><br/>");
                        lineHeight += 2;
                    }
                    boolean tagApplicationFound = false;
                    for (ItemTag tag : s.getTagsApplied()) {
                        for (String tagTooltip : tag.getClothingTooltipAdditions()) {
                            if (!tagApplicationFound) {
                                tooltipDescriptionSB.append("[style.boldMinorGood(\u6dfb\u52a0\u6548\u679c:)]<br/>");
                                tagApplicationFound = true;
                                ++lineHeight;
                            }
                            tooltipDescriptionSB.append(tagTooltip + "<br/>");
                            ++lineHeight;
                        }
                    }
                    tagApplicationFound = false;
                    for (ItemTag tag : s.getTagsRemoved()) {
                        for (String tagTooltip : tag.getClothingTooltipAdditions()) {
                            if (!tagApplicationFound) {
                                tooltipDescriptionSB.append("[style.boldMinorBad(\u79fb\u9664\u6548\u679c:)]<br/>");
                                tagApplicationFound = true;
                                ++lineHeight;
                            }
                            tooltipDescriptionSB.append(tagTooltip + "<br/>");
                            ++lineHeight;
                        }
                    }
                }
                TooltipInformationEventListener el = new TooltipInformationEventListener();
                if (lineHeight > 0) {
                    el.setInformation("\u7279\u6b8a\u6548\u679c", tooltipDescriptionSB.toString(), lineHeight * 16);
                } else {
                    el.setInformation("\u65e0\u7279\u6b8a\u6548\u679c", "");
                }
                MainController.addTooltipListeners(id, el);
            }
        }
    }

    public static void initWeaponDyeListeners() {
        AbstractWeaponType weapon = InventoryDialogue.getWeapon().getWeaponType();
        for (int i = 0; i < weapon.getColourReplacements(false).size(); ++i) {
            int index = i;
            ColourReplacement cr = weapon.getColourReplacement(false, i);
            for (Colour c : cr.getAllColours()) {
                String id = "DYE_WEAPON_" + i + "_" + c.getId();
                if (MainController.document.getElementById(id) == null) continue;
                ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                    if (cr.isRecolouringAllowed()) {
                        InventoryDialogue.dyePreviews.remove(index);
                        InventoryDialogue.dyePreviews.add(index, c);
                    }
                    Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
                }, false);
                MainController.addTooltipListeners(id, new TooltipInventoryEventListener().setDyeWeapon(InventoryDialogue.getWeapon(), i, c));
            }
        }
    }

    public static void initDamageTypeListeners() {
        AbstractWeaponType weapon = InventoryDialogue.getWeapon().getWeaponType();
        for (DamageType dt : weapon.getAvailableDamageTypes()) {
            String id = "DAMAGE_TYPE_" + dt.toString();
            if (MainController.document.getElementById(id) == null) continue;
            ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                InventoryDialogue.damageTypePreview = dt;
                Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
            }, false);
            MainController.addTooltipListeners(id, new TooltipInventoryEventListener().setDamageTypeWeapon(InventoryDialogue.getWeapon(), dt));
        }
    }
}

