/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game;

import com.lilithsthrone.controller.MainController;
import com.lilithsthrone.controller.TooltipUpdateThread;
import com.lilithsthrone.controller.eventListeners.tooltips.TooltipInformationEventListener;
import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.PropertyValue;
import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.CharacterUtils;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.PlayerCharacter;
import com.lilithsthrone.game.character.SexCount;
import com.lilithsthrone.game.character.attributes.AffectionLevel;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.attributes.ObedienceLevel;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.body.FluidCum;
import com.lilithsthrone.game.character.body.FluidGirlCum;
import com.lilithsthrone.game.character.body.FluidMilk;
import com.lilithsthrone.game.character.body.coverings.Covering;
import com.lilithsthrone.game.character.body.types.FluidType;
import com.lilithsthrone.game.character.body.valueEnums.GenitalArrangement;
import com.lilithsthrone.game.character.body.valueEnums.HairLength;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.effects.PerkManager;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.fetishes.FetishDesire;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.dominion.Amber;
import com.lilithsthrone.game.character.npc.dominion.Angel;
import com.lilithsthrone.game.character.npc.dominion.Arthur;
import com.lilithsthrone.game.character.npc.dominion.Ashley;
import com.lilithsthrone.game.character.npc.dominion.Brax;
import com.lilithsthrone.game.character.npc.dominion.Bunny;
import com.lilithsthrone.game.character.npc.dominion.Callie;
import com.lilithsthrone.game.character.npc.dominion.CandiReceptionist;
import com.lilithsthrone.game.character.npc.dominion.Cultist;
import com.lilithsthrone.game.character.npc.dominion.Daddy;
import com.lilithsthrone.game.character.npc.dominion.DominionAlleywayAttacker;
import com.lilithsthrone.game.character.npc.dominion.DominionClubNPC;
import com.lilithsthrone.game.character.npc.dominion.Elle;
import com.lilithsthrone.game.character.npc.dominion.EnforcerPatrol;
import com.lilithsthrone.game.character.npc.dominion.Felicia;
import com.lilithsthrone.game.character.npc.dominion.Fiammetta;
import com.lilithsthrone.game.character.npc.dominion.Finch;
import com.lilithsthrone.game.character.npc.dominion.Hannah;
import com.lilithsthrone.game.character.npc.dominion.HarpyBimbo;
import com.lilithsthrone.game.character.npc.dominion.HarpyBimboCompanion;
import com.lilithsthrone.game.character.npc.dominion.HarpyDominant;
import com.lilithsthrone.game.character.npc.dominion.HarpyDominantCompanion;
import com.lilithsthrone.game.character.npc.dominion.HarpyNympho;
import com.lilithsthrone.game.character.npc.dominion.HarpyNymphoCompanion;
import com.lilithsthrone.game.character.npc.dominion.Helena;
import com.lilithsthrone.game.character.npc.dominion.Jules;
import com.lilithsthrone.game.character.npc.dominion.Kalahari;
import com.lilithsthrone.game.character.npc.dominion.Kate;
import com.lilithsthrone.game.character.npc.dominion.Kay;
import com.lilithsthrone.game.character.npc.dominion.Kruger;
import com.lilithsthrone.game.character.npc.dominion.Lilaya;
import com.lilithsthrone.game.character.npc.dominion.Loppy;
import com.lilithsthrone.game.character.npc.dominion.Lovienne;
import com.lilithsthrone.game.character.npc.dominion.Lumi;
import com.lilithsthrone.game.character.npc.dominion.Natalya;
import com.lilithsthrone.game.character.npc.dominion.Nyan;
import com.lilithsthrone.game.character.npc.dominion.NyanMum;
import com.lilithsthrone.game.character.npc.dominion.Pazu;
import com.lilithsthrone.game.character.npc.dominion.Pix;
import com.lilithsthrone.game.character.npc.dominion.Ralph;
import com.lilithsthrone.game.character.npc.dominion.ReindeerOverseer;
import com.lilithsthrone.game.character.npc.dominion.RentalMommy;
import com.lilithsthrone.game.character.npc.dominion.Rose;
import com.lilithsthrone.game.character.npc.dominion.Saellatrix;
import com.lilithsthrone.game.character.npc.dominion.Scarlett;
import com.lilithsthrone.game.character.npc.dominion.Sean;
import com.lilithsthrone.game.character.npc.dominion.SupplierLeader;
import com.lilithsthrone.game.character.npc.dominion.SupplierPartner;
import com.lilithsthrone.game.character.npc.dominion.TestNPC;
import com.lilithsthrone.game.character.npc.dominion.Vanessa;
import com.lilithsthrone.game.character.npc.dominion.Vicky;
import com.lilithsthrone.game.character.npc.dominion.Wes;
import com.lilithsthrone.game.character.npc.dominion.Zaranix;
import com.lilithsthrone.game.character.npc.dominion.ZaranixMaidKatherine;
import com.lilithsthrone.game.character.npc.dominion.ZaranixMaidKelly;
import com.lilithsthrone.game.character.npc.fields.Angelixx;
import com.lilithsthrone.game.character.npc.fields.Arion;
import com.lilithsthrone.game.character.npc.fields.Astrapi;
import com.lilithsthrone.game.character.npc.fields.Aurokaris;
import com.lilithsthrone.game.character.npc.fields.Belle;
import com.lilithsthrone.game.character.npc.fields.Ceridwen;
import com.lilithsthrone.game.character.npc.fields.Dale;
import com.lilithsthrone.game.character.npc.fields.Daphne;
import com.lilithsthrone.game.character.npc.fields.Eisek;
import com.lilithsthrone.game.character.npc.fields.Evelyx;
import com.lilithsthrone.game.character.npc.fields.EvelyxMilker;
import com.lilithsthrone.game.character.npc.fields.EvelyxSexualPartner;
import com.lilithsthrone.game.character.npc.fields.Fae;
import com.lilithsthrone.game.character.npc.fields.Farah;
import com.lilithsthrone.game.character.npc.fields.FieldsBandit;
import com.lilithsthrone.game.character.npc.fields.Flash;
import com.lilithsthrone.game.character.npc.fields.Ghost;
import com.lilithsthrone.game.character.npc.fields.Golix;
import com.lilithsthrone.game.character.npc.fields.Hale;
import com.lilithsthrone.game.character.npc.fields.Hammer;
import com.lilithsthrone.game.character.npc.fields.HeadlessHorseman;
import com.lilithsthrone.game.character.npc.fields.Heather;
import com.lilithsthrone.game.character.npc.fields.Imsu;
import com.lilithsthrone.game.character.npc.fields.Jess;
import com.lilithsthrone.game.character.npc.fields.Kazik;
import com.lilithsthrone.game.character.npc.fields.Kheiron;
import com.lilithsthrone.game.character.npc.fields.Lunette;
import com.lilithsthrone.game.character.npc.fields.LunetteMelee;
import com.lilithsthrone.game.character.npc.fields.LunetteRanged;
import com.lilithsthrone.game.character.npc.fields.Lunexis;
import com.lilithsthrone.game.character.npc.fields.Minotallys;
import com.lilithsthrone.game.character.npc.fields.Monica;
import com.lilithsthrone.game.character.npc.fields.Moreno;
import com.lilithsthrone.game.character.npc.fields.Nir;
import com.lilithsthrone.game.character.npc.fields.Nizhoni;
import com.lilithsthrone.game.character.npc.fields.Oglix;
import com.lilithsthrone.game.character.npc.fields.Penelope;
import com.lilithsthrone.game.character.npc.fields.Silvia;
import com.lilithsthrone.game.character.npc.fields.Sleip;
import com.lilithsthrone.game.character.npc.fields.Sterope;
import com.lilithsthrone.game.character.npc.fields.Ursa;
import com.lilithsthrone.game.character.npc.fields.Vronti;
import com.lilithsthrone.game.character.npc.fields.Wynter;
import com.lilithsthrone.game.character.npc.fields.Yui;
import com.lilithsthrone.game.character.npc.fields.Ziva;
import com.lilithsthrone.game.character.npc.misc.ClubberImport;
import com.lilithsthrone.game.character.npc.misc.Elemental;
import com.lilithsthrone.game.character.npc.misc.GenericAndrogynousNPC;
import com.lilithsthrone.game.character.npc.misc.GenericFemaleNPC;
import com.lilithsthrone.game.character.npc.misc.GenericMaleNPC;
import com.lilithsthrone.game.character.npc.misc.GenericSexualPartner;
import com.lilithsthrone.game.character.npc.misc.GenericTrader;
import com.lilithsthrone.game.character.npc.misc.LodgerImport;
import com.lilithsthrone.game.character.npc.misc.ModdedCharacter;
import com.lilithsthrone.game.character.npc.misc.NPCOffspring;
import com.lilithsthrone.game.character.npc.misc.OffspringSeed;
import com.lilithsthrone.game.character.npc.misc.PrologueFemale;
import com.lilithsthrone.game.character.npc.misc.PrologueMale;
import com.lilithsthrone.game.character.npc.misc.SlaveForSale;
import com.lilithsthrone.game.character.npc.misc.SlaveImport;
import com.lilithsthrone.game.character.npc.submission.Axel;
import com.lilithsthrone.game.character.npc.submission.Claire;
import com.lilithsthrone.game.character.npc.submission.DarkSiren;
import com.lilithsthrone.game.character.npc.submission.Elizabeth;
import com.lilithsthrone.game.character.npc.submission.Epona;
import com.lilithsthrone.game.character.npc.submission.FortressAlphaLeader;
import com.lilithsthrone.game.character.npc.submission.FortressFemalesLeader;
import com.lilithsthrone.game.character.npc.submission.FortressMalesLeader;
import com.lilithsthrone.game.character.npc.submission.GamblingDenPatron;
import com.lilithsthrone.game.character.npc.submission.HazmatRat;
import com.lilithsthrone.game.character.npc.submission.Lyssieth;
import com.lilithsthrone.game.character.npc.submission.Murk;
import com.lilithsthrone.game.character.npc.submission.RatWarrensCaptive;
import com.lilithsthrone.game.character.npc.submission.Roxy;
import com.lilithsthrone.game.character.npc.submission.Shadow;
import com.lilithsthrone.game.character.npc.submission.Silence;
import com.lilithsthrone.game.character.npc.submission.SlimeGuardFire;
import com.lilithsthrone.game.character.npc.submission.SlimeGuardIce;
import com.lilithsthrone.game.character.npc.submission.SlimeQueen;
import com.lilithsthrone.game.character.npc.submission.SlimeRoyalGuard;
import com.lilithsthrone.game.character.npc.submission.Takahashi;
import com.lilithsthrone.game.character.npc.submission.Vengar;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.persona.Relationship;
import com.lilithsthrone.game.character.persona.SexualOrientation;
import com.lilithsthrone.game.character.pregnancy.FertilisationType;
import com.lilithsthrone.game.character.pregnancy.Litter;
import com.lilithsthrone.game.character.quests.Quest;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.RacialBody;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.combat.spells.Spell;
import com.lilithsthrone.game.dialogue.AbstractDialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueFlags;
import com.lilithsthrone.game.dialogue.DialogueManager;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.DialogueNodeType;
import com.lilithsthrone.game.dialogue.companions.OccupantManagementDialogue;
import com.lilithsthrone.game.dialogue.encounters.AbstractEncounter;
import com.lilithsthrone.game.dialogue.encounters.Encounter;
import com.lilithsthrone.game.dialogue.eventLog.EventLogEntry;
import com.lilithsthrone.game.dialogue.eventLog.SlaveryEventLogEntry;
import com.lilithsthrone.game.dialogue.npcDialogue.QuickTransformations;
import com.lilithsthrone.game.dialogue.places.dominion.RedLightDistrict;
import com.lilithsthrone.game.dialogue.places.dominion.enforcerHQ.EnforcerHQDialogue;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.Lab;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.LilayaHomeGeneric;
import com.lilithsthrone.game.dialogue.places.dominion.slaverAlley.SlaverAlleyDialogue;
import com.lilithsthrone.game.dialogue.places.dominion.warehouseDistrict.DominionExpress;
import com.lilithsthrone.game.dialogue.places.dominion.zaranixHome.ZaranixHomeGroundFloor;
import com.lilithsthrone.game.dialogue.places.submission.dicePoker.DicePokerTable;
import com.lilithsthrone.game.dialogue.places.submission.impFortress.ImpCitadelDialogue;
import com.lilithsthrone.game.dialogue.places.submission.impFortress.ImpFortressDialogue;
import com.lilithsthrone.game.dialogue.places.submission.ratWarrens.RatWarrensDialogue;
import com.lilithsthrone.game.dialogue.places.submission.ratWarrens.VengarCaptiveDialogue;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseCombat;
import com.lilithsthrone.game.dialogue.responses.ResponseEffectsOnly;
import com.lilithsthrone.game.dialogue.responses.ResponseSex;
import com.lilithsthrone.game.dialogue.responses.ResponseTag;
import com.lilithsthrone.game.dialogue.responses.ResponseTrade;
import com.lilithsthrone.game.dialogue.utils.BodyChanging;
import com.lilithsthrone.game.dialogue.utils.CharactersPresentDialogue;
import com.lilithsthrone.game.dialogue.utils.CosmeticsDialogue;
import com.lilithsthrone.game.dialogue.utils.DebugDialogue;
import com.lilithsthrone.game.dialogue.utils.InventoryDialogue;
import com.lilithsthrone.game.dialogue.utils.InventoryInteraction;
import com.lilithsthrone.game.dialogue.utils.MapTravelType;
import com.lilithsthrone.game.dialogue.utils.MiscDialogue;
import com.lilithsthrone.game.dialogue.utils.OptionsDialogue;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.ParserTarget;
import com.lilithsthrone.game.dialogue.utils.PhoneDialogue;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.game.inventory.ItemGeneration;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.Rarity;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.AbstractClothingType;
import com.lilithsthrone.game.inventory.clothing.ClothingType;
import com.lilithsthrone.game.inventory.enchanting.AbstractItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectType;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.item.AbstractItemType;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.game.inventory.weapon.AbstractWeaponType;
import com.lilithsthrone.game.inventory.weapon.WeaponType;
import com.lilithsthrone.game.occupantManagement.MilkingRoom;
import com.lilithsthrone.game.occupantManagement.OccupancyUtil;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJob;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJobFlag;
import com.lilithsthrone.game.occupantManagement.slave.SlavePermission;
import com.lilithsthrone.game.occupantManagement.slave.SlavePermissionSetting;
import com.lilithsthrone.game.occupantManagement.slaveEvent.SlaveEvent;
import com.lilithsthrone.game.settings.KeyCodeWithModifiers;
import com.lilithsthrone.game.settings.KeyboardAction;
import com.lilithsthrone.game.sex.SexAreaOrifice;
import com.lilithsthrone.game.sex.SexType;
import com.lilithsthrone.game.sex.managers.universal.SMGeneric;
import com.lilithsthrone.game.sex.sexActions.SexActionType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.Artwork;
import com.lilithsthrone.rendering.SVGImages;
import com.lilithsthrone.utils.SizedStack;
import com.lilithsthrone.utils.Units;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.Vector2i;
import com.lilithsthrone.utils.XMLSaving;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.utils.time.DateAndTime;
import com.lilithsthrone.utils.time.DayPeriod;
import com.lilithsthrone.utils.time.SolarElevationAngle;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.Generation;
import com.lilithsthrone.world.Season;
import com.lilithsthrone.world.Weather;
import com.lilithsthrone.world.World;
import com.lilithsthrone.world.WorldRegion;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.GenericPlace;
import com.lilithsthrone.world.places.PlaceType;
import com.lilithsthrone.world.places.PlaceUpgrade;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Game
implements XMLSaving {
    public static final int FONT_SIZE_MINIMUM = 12;
    public static final int FONT_SIZE_NORMAL = 15;
    public static final int FONT_SIZE_LARGE = 24;
    public static final int FONT_SIZE_HUGE = 36;
    public static final int TIME_SKIP_YEARS = 3;
    public static final int TIME_START_SECONDS = 74040;
    public static final double DOMINION_LONGITUDE = 0.0;
    public static final double DOMINION_LATITUDE = 51.4934;
    public static String loadingVersion = "0.4.11.3";
    private long id;
    private PlayerCharacter player;
    private ItemGeneration itemGeneration;
    private CharacterUtils characterUtils;
    private NPC activeNPC;
    private AtomicInteger npcTally = new AtomicInteger(0);
    private AtomicInteger offspringSeedTally = new AtomicInteger(0);
    private Map<String, NPC> NPCMap;
    private Map<String, OffspringSeed> OffspringSeedMap;
    private Map<AbstractWorldType, List<List<String>>> savedEnforcers;
    private Map<AbstractWorldType, World> worlds;
    private long lastAutoSaveTime = 0L;
    private long secondsPassed;
    private LocalDateTime startingDate;
    private boolean renderAttributesSection;
    private boolean renderMap;
    private boolean inCombat;
    private boolean inSex;
    private boolean requestAutosave;
    private Weather currentWeather;
    private long nextStormTimeInSeconds;
    private int gatheringStormDurationInSeconds;
    private int weatherTimeRemainingInSeconds;
    private Encounter currentEncounter;
    public Util.Value<Long, DialogueNode> forcedEncounterAtSeconds = new Util.Value<Long, Object>(-1L, null);
    public Util.Value<Long, DialogueNode> encounterAtSeconds = new Util.Value<Long, Object>(-1L, null);
    private boolean started;
    private static Map<String, CharacterInventory> savedInventories;
    private DialogueManager dialogueManager;
    private DialogueFlags dialogueFlags;
    private int responsePointer = 0;
    private DialogueNode currentDialogueNode;
    private DialogueNode savedDialogueNode = null;
    private String currentDialogue;
    private String savedDialogue;
    private String previousPastDialogueSBContents = "";
    private int initialPositionAnchor = 0;
    private int responsePage = 0;
    private int responseTab = 0;
    private int savedResponseTab = 0;
    private StringBuilder pastDialogueSB = new StringBuilder();
    private StringBuilder choicesDialogueSB = new StringBuilder();
    private StringBuilder textEndStringBuilder = new StringBuilder();
    private StringBuilder textStartStringBuilder = new StringBuilder();
    public static Map<String, TooltipInformationEventListener> informationTooltips;
    private SizedStack<EventLogEntry> eventLog = new SizedStack(50);
    private SizedStack<Util.Value<Integer, List<SlaveryEventLogEntry>>> slaveryEventLog = new SizedStack(7);
    private OccupancyUtil occupancyUtil = new OccupancyUtil();
    private static boolean timeLog;
    private static long timeStart;
    private static boolean debug;
    private boolean isInNPCUpdateLoop = false;
    public boolean pendingSlaveInStocksReset = false;
    public boolean pendingSlaveShopsReset = false;
    private List<NPC> npcsToRemove = new ArrayList<NPC>();
    private List<NPC> npcsToAdd = new ArrayList<NPC>();
    public float endTurnTimeTaken = 0.0f;
    public float endTurnTimeTakenAddition = 0.0f;
    private int positionAnchor = 0;
    private String dialogueTitle = "";
    AbstractCoreItem randomItem = null;

    public Game() {
        this.id = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);
        this.worlds = new HashMap<AbstractWorldType, World>();
        for (AbstractWorldType type : WorldType.getAllWorldTypes()) {
            this.worlds.put(type, null);
        }
        this.itemGeneration = new ItemGeneration();
        this.characterUtils = new CharacterUtils();
        OccupantManagementDialogue.resetImportantCells();
        this.startingDate = LocalDateTime.of(2019, LocalDateTime.now().getMonth(), LocalDateTime.now().getMonth() == Month.FEBRUARY && LocalDateTime.now().getDayOfMonth() == 29 ? 28 : LocalDateTime.now().getDayOfMonth(), 0, 0);
        this.secondsPassed = 74040L;
        this.inCombat = false;
        this.inSex = false;
        this.renderAttributesSection = false;
        this.renderMap = false;
        this.dialogueManager = new DialogueManager();
        this.dialogueFlags = new DialogueFlags();
        this.started = false;
        this.NPCMap = new ConcurrentHashMap<String, NPC>();
        this.OffspringSeedMap = new ConcurrentHashMap<String, OffspringSeed>();
        this.savedEnforcers = new HashMap<AbstractWorldType, List<List<String>>>();
        savedInventories = new HashMap<String, CharacterInventory>();
        this.currentWeather = Weather.CLOUD;
        this.weatherTimeRemainingInSeconds = 18000;
        this.nextStormTimeInSeconds = this.getSecondsPassed() + (long)((2880 + 60 * Util.random.nextInt(24)) * 60);
        UtilText.resetParsingEngine();
    }

    public static void exportCharacter(GameCharacter character) {
        try {
            if (timeLog) {
                timeStart = System.nanoTime();
                System.out.println(timeStart);
            }
            Document doc = Main.getDocBuilder().newDocument();
            Element characterNode = doc.createElement("exportedCharacter");
            doc.appendChild(characterNode);
            character.saveAsXML(characterNode, doc);
            Transformer transformer1 = Main.transformerFactory.newTransformer();
            transformer1.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer1.transform(new DOMSource(doc), new StreamResult(writer));
            Transformer transformer = Main.transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(doc);
            File dir = new File("data/");
            dir.mkdir();
            File dirCharacter = new File("data/characters/");
            dirCharacter.mkdir();
            int saveNumber = 0;
            String savePostfix = "_export_day" + Main.game.getDayNumber();
            String characterName = character.getName(false).replaceAll("\\s", "");
            String saveLocation = "data/characters/" + characterName + savePostfix + ".xml";
            while (new File(saveLocation).exists()) {
                saveLocation = "data/characters/" + characterName + savePostfix + "(" + ++saveNumber + ").xml";
            }
            StreamResult result = new StreamResult(saveLocation);
            transformer.transform(source, result);
            if (character.hasArtwork()) {
                try {
                    Path destination = Paths.get("data", "characters", characterName + savePostfix);
                    Files.createDirectories(destination, new FileAttribute[0]);
                    for (Artwork art : character.getArtworkList()) {
                        for (String s : art.getAllImagePaths()) {
                            File f = new File(s);
                            System.out.println("x: " + s);
                            Path tmp = destination.resolve(f.getName() + ".tmp");
                            Files.copy(f.toPath(), tmp, new CopyOption[0]);
                            Files.move(tmp, destination.resolve(f.getName()), StandardCopyOption.ATOMIC_MOVE);
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (timeLog) {
                System.out.println("Difference: " + (float)(System.nanoTime() - timeStart) / 1.0E9f);
            }
        }
        catch (TransformerException tfe) {
            tfe.printStackTrace();
        }
    }

    private static void handleCharacterImportImages(GameCharacter importedCharacter, String fileName) {
        File potentialArtworkFolder = new File("data/characters/" + fileName);
        if (potentialArtworkFolder.exists() && potentialArtworkFolder.isDirectory()) {
            ArrayList<File> imageFiles = new ArrayList<File>();
            for (File f : potentialArtworkFolder.listFiles()) {
                if (!f.getName().endsWith(".jpg") && !f.getName().endsWith(".png") && !f.getName().endsWith(".gif")) continue;
                imageFiles.add(f);
            }
            importedCharacter.importImages(imageFiles);
        }
    }

    public static GameCharacter importCharacterAsSlave(String name) {
        File file = new File("data/characters/" + name + ".xml");
        if (file.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(file);
                doc.getDocumentElement().normalize();
                Element characterElement = (Element)doc.getElementsByTagName("exportedCharacter").item(0);
                if (characterElement == null) {
                    characterElement = (Element)doc.getElementsByTagName("playerCharacter").item(0);
                }
                SlaveImport importedSlave = new SlaveImport();
                importedSlave.loadFromXML(characterElement, doc, CharacterImportSetting.NO_PREGNANCY, CharacterImportSetting.NO_COMPANIONS, CharacterImportSetting.NO_ELEMENTAL, CharacterImportSetting.CLEAR_SLAVERY, CharacterImportSetting.NO_LOCATION_SETUP, CharacterImportSetting.CLEAR_KEY_ITEMS, CharacterImportSetting.CLEAR_COMBAT_HISTORY, CharacterImportSetting.CLEAR_SEX_HISTORY, CharacterImportSetting.REMOVE_RACE_CONCEALED, CharacterImportSetting.CLEAR_FAMILY_ID);
                try {
                    if (((Element)((Element)((Element)characterElement.getElementsByTagName("character").item(0)).getElementsByTagName("core").item(0)).getElementsByTagName("id").item(0)).getAttribute("value").equals("PlayerCharacter")) {
                        importedSlave.setBirthday(importedSlave.getBirthday().plusYears(18L));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Main.game.addNPC(importedSlave, false);
                importedSlave.applyNewlyImportedSlaveVariables();
                Game.handleCharacterImportImages(importedSlave, name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Integer importModdedCharacter(String path, String parserTarget) {
        File file = new File(path);
        if (file.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(file);
                doc.getDocumentElement().normalize();
                Element characterElement = (Element)doc.getElementsByTagName("exportedCharacter").item(0);
                ModdedCharacter npc = new ModdedCharacter();
                npc.loadFromXML(characterElement, doc, CharacterImportSetting.NO_LOCATION_SETUP);
                Main.game.addNPC(npc, false, true);
                if (parserTarget != null && !parserTarget.isEmpty()) {
                    ParserTarget.addAdditionalParserTarget(parserTarget, npc);
                }
                return Integer.parseInt(npc.getId().split(",")[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setModdedCharacterParserTarget(Long id, String parserTarget) {
        try {
            ParserTarget.addAdditionalParserTarget(parserTarget, (NPC)this.getNPCById(id + ",ModdedCharacter"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static GameCharacter importCharacterAsLodger(String name) {
        File file = new File("data/characters/" + name + ".xml");
        if (file.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(file);
                doc.getDocumentElement().normalize();
                Element characterElement = (Element)doc.getElementsByTagName("exportedCharacter").item(0);
                if (characterElement == null) {
                    characterElement = (Element)doc.getElementsByTagName("playerCharacter").item(0);
                }
                LodgerImport importedLodger = new LodgerImport();
                importedLodger.loadFromXML(characterElement, doc, CharacterImportSetting.NO_PREGNANCY, CharacterImportSetting.NO_COMPANIONS, CharacterImportSetting.NO_ELEMENTAL, CharacterImportSetting.CLEAR_SLAVERY, CharacterImportSetting.NO_LOCATION_SETUP, CharacterImportSetting.CLEAR_KEY_ITEMS, CharacterImportSetting.CLEAR_COMBAT_HISTORY, CharacterImportSetting.CLEAR_SEX_HISTORY, CharacterImportSetting.REMOVE_RACE_CONCEALED, CharacterImportSetting.CLEAR_FAMILY_ID);
                try {
                    if (((Element)((Element)((Element)characterElement.getElementsByTagName("character").item(0)).getElementsByTagName("core").item(0)).getElementsByTagName("id").item(0)).getAttribute("value").equals("PlayerCharacter")) {
                        importedLodger.setBirthday(importedLodger.getBirthday().plusYears(18L));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Main.game.addNPC(importedLodger, false);
                importedLodger.applyNewlyImportedLodgerVariables();
                Game.handleCharacterImportImages(importedLodger, name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static GameCharacter importCharacterAsClubber(String name) {
        File file = new File("data/characters/" + name + ".xml");
        if (file.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(file);
                doc.getDocumentElement().normalize();
                Element characterElement = (Element)doc.getElementsByTagName("exportedCharacter").item(0);
                if (characterElement == null) {
                    characterElement = (Element)doc.getElementsByTagName("playerCharacter").item(0);
                }
                ClubberImport importedClubber = new ClubberImport();
                importedClubber.loadFromXML(characterElement, doc, CharacterImportSetting.NO_PREGNANCY, CharacterImportSetting.NO_COMPANIONS, CharacterImportSetting.NO_ELEMENTAL, CharacterImportSetting.CLEAR_SLAVERY, CharacterImportSetting.NO_LOCATION_SETUP, CharacterImportSetting.CLEAR_KEY_ITEMS, CharacterImportSetting.CLEAR_COMBAT_HISTORY, CharacterImportSetting.CLEAR_SEX_HISTORY, CharacterImportSetting.REMOVE_RACE_CONCEALED, CharacterImportSetting.CLEAR_FAMILY_ID);
                try {
                    if (((Element)((Element)((Element)characterElement.getElementsByTagName("character").item(0)).getElementsByTagName("core").item(0)).getElementsByTagName("id").item(0)).getAttribute("value").equals("PlayerCharacter")) {
                        importedClubber.setBirthday(importedClubber.getBirthday().plusYears(18L));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Main.game.addNPC(importedClubber, false);
                importedClubber.applyNewlyImportedClubberVariables();
                Game.handleCharacterImportImages(importedClubber, name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void exportGame(String exportFileName, boolean allowOverwrite, boolean isAutoSave) {
        File[] directoryListing;
        File dir = new File("data/");
        dir.mkdir();
        dir = new File("data/saves");
        dir.mkdir();
        boolean overwrite = false;
        if (dir.isDirectory() && (directoryListing = dir.listFiles((path, filename) -> filename.endsWith(".xml"))) != null) {
            void var8_18;
            File[] fileArray = directoryListing;
            int n = fileArray.length;
            boolean bl = false;
            while (var8_18 < n) {
                File file = fileArray[var8_18];
                if (file.getName().equals(exportFileName + ".xml")) {
                    if (!allowOverwrite) {
                        Main.game.flashMessage(PresetColour.GENERIC_BAD, "\u540d\u79f0\u5df2\u5b58\u5728\uff01");
                        return;
                    }
                    overwrite = true;
                }
                ++var8_18;
            }
        }
        if (timeLog) {
            timeStart = System.nanoTime();
            System.out.println(timeStart);
        }
        Document doc = Main.getDocBuilder().newDocument();
        Element game = doc.createElement("game");
        doc.appendChild(game);
        try {
            Element informationNode = doc.createElement("coreInfo");
            game.appendChild(informationNode);
            XMLUtil.addAttribute(doc, informationNode, "version", "0.4.11.3");
            XMLUtil.addAttribute(doc, informationNode, "id", String.valueOf(Main.game.id));
            XMLUtil.addAttribute(doc, informationNode, "lastAutoSaveTime", String.valueOf(Main.game.lastAutoSaveTime));
            XMLUtil.addAttribute(doc, informationNode, "secondsPassed", String.valueOf(Main.game.secondsPassed));
            XMLUtil.addAttribute(doc, informationNode, "weather", Main.game.currentWeather.toString());
            XMLUtil.addAttribute(doc, informationNode, "nextStormTimeInSeconds", String.valueOf(Main.game.nextStormTimeInSeconds));
            XMLUtil.addAttribute(doc, informationNode, "gatheringStormDurationInSeconds", String.valueOf(Main.game.gatheringStormDurationInSeconds));
            XMLUtil.addAttribute(doc, informationNode, "weatherTimeRemainingInSeconds", String.valueOf(Main.game.weatherTimeRemainingInSeconds));
            Element element = doc.createElement("savedInventories");
            game.appendChild(element);
            for (Map.Entry<String, CharacterInventory> entry : savedInventories.entrySet()) {
                Element element2 = doc.createElement("savedInventory");
                XMLUtil.addAttribute(doc, element2, "character", entry.getKey());
                element.appendChild(element2);
                entry.getValue().saveAsXML(element2, doc);
            }
            Element element3 = doc.createElement("savedEnforcers");
            game.appendChild(element3);
            for (Map.Entry<AbstractWorldType, List<List<String>>> entry : Main.game.savedEnforcers.entrySet()) {
                Element element4 = doc.createElement("world");
                element3.appendChild(element4);
                XMLUtil.addAttribute(doc, element4, "type", WorldType.getIdFromWorldType(entry.getKey()));
                for (List<String> ids : entry.getValue()) {
                    Element enforcersElement = doc.createElement("enforcers");
                    element4.appendChild(enforcersElement);
                    for (String s : ids) {
                        Element idElement = doc.createElement("id");
                        enforcersElement.appendChild(idElement);
                        idElement.setTextContent(s);
                    }
                }
            }
            try {
                Main.game.getOccupancyUtil().saveAsXML(game, doc);
            }
            catch (Exception exception) {
                System.err.println("SlaveryUtil saving failed!");
                Main.game.addEvent(new EventLogEntry("<style='color:" + PresetColour.GENERIC_TERRIBLE.toWebHexString() + ";'>\u90e8\u5206\u5b58\u6863\u5931\u6548<b>", "SlaveryUtil\u5931\u8d25"), false);
            }
            Element element5 = doc.createElement("date");
            informationNode.appendChild(element5);
            XMLUtil.addAttribute(doc, element5, "year", String.valueOf(Main.game.startingDate.getYear()));
            XMLUtil.addAttribute(doc, element5, "month", String.valueOf(Main.game.startingDate.getMonthValue()));
            XMLUtil.addAttribute(doc, element5, "dayOfMonth", String.valueOf(Main.game.startingDate.getDayOfMonth()));
            XMLUtil.addAttribute(doc, element5, "hour", String.valueOf(Main.game.startingDate.getHour()));
            XMLUtil.addAttribute(doc, element5, "minute", String.valueOf(Main.game.startingDate.getMinute()));
        }
        catch (Exception ex) {
            System.err.println("coreInfo saving failed!");
            Main.game.addEvent(new EventLogEntry("<style='color:" + PresetColour.GENERIC_TERRIBLE.toWebHexString() + ";'>\u90e8\u5206\u5b58\u6863\u5931\u6548<b>", "coreInfo\u5931\u8d25"), false);
        }
        Main.game.dialogueFlags.saveAsXML(game, doc);
        try {
            Element eventLogNode = doc.createElement("eventLog");
            game.appendChild(eventLogNode);
            for (EventLogEntry eventLogEntry : Main.game.getEventLog()) {
                eventLogEntry.saveAsXML(eventLogNode, doc);
            }
        }
        catch (Exception ex) {
            System.err.println("eventLog saving failed!");
            Main.game.addEvent(new EventLogEntry("<style='color:" + PresetColour.GENERIC_TERRIBLE.toWebHexString() + ";'>\u90e8\u5206\u5b58\u6863\u5931\u6548<b>", "eventLog\u5931\u8d25"), false);
        }
        try {
            Element slaveryEventLogNode = doc.createElement("slaveryEventLog");
            game.appendChild(slaveryEventLogNode);
            for (Util.Value value : Main.game.getSlaveryEventLog()) {
                Element element = doc.createElement("day");
                slaveryEventLogNode.appendChild(element);
                XMLUtil.addAttribute(doc, element, "value", String.valueOf(value.getKey()));
                for (SlaveryEventLogEntry event : (List)value.getValue()) {
                    event.saveAsXML(element, doc);
                }
            }
        }
        catch (Exception ex) {
            System.err.println("slaveryEventLog saving failed!");
            Main.game.addEvent(new EventLogEntry("<style='color:" + PresetColour.GENERIC_TERRIBLE.toWebHexString() + ";'>\u90e8\u5206\u5b58\u6863\u5931\u6548<b>", "slaveryEventLog\u5931\u8d25"), false);
        }
        try {
            Element mapNode = doc.createElement("maps");
            game.appendChild(mapNode);
            for (World world : Main.game.getWorlds().values()) {
                world.saveAsXML(mapNode, doc);
            }
        }
        catch (Exception ex) {
            System.err.println("maps saving failed!");
            Main.game.addEvent(new EventLogEntry("<style='color:" + PresetColour.GENERIC_TERRIBLE.toWebHexString() + ";'>\u90e8\u5206\u5b58\u6863\u5931\u6548<b>", "maps\u5931\u8d25"), false);
        }
        try {
            Element characterNode2 = doc.createElement("playerCharacter");
            game.appendChild(characterNode2);
            Main.game.getPlayer().saveAsXML(characterNode2, doc);
        }
        catch (Exception ex) {
            System.err.println("playerCharacter saving failed!");
            Main.game.addEvent(new EventLogEntry("<style='color:" + PresetColour.GENERIC_TERRIBLE.toWebHexString() + ";'>\u90e8\u5206\u5b58\u6863\u5931\u6548<b>", "playerCharacter\u5931\u8d25"), false);
        }
        try {
            for (GameCharacter gameCharacter : Main.game.getNPCMap().values()) {
                Element element = doc.createElement("NPC");
                game.appendChild(element);
                gameCharacter.saveAsXML(element, doc);
            }
        }
        catch (Exception ex) {
            System.err.println("NPC saving failed!");
            ex.printStackTrace();
            Main.game.addEvent(new EventLogEntry("<style='color:" + PresetColour.GENERIC_TERRIBLE.toWebHexString() + ";'>\u90e8\u5206\u5b58\u6863\u5931\u6548<b>", "NPC\u5931\u8d25"), false);
        }
        try {
            for (OffspringSeed offspringSeed : Main.game.getOffspringSeedMap().values()) {
                Element element = doc.createElement("OffspringSeed");
                game.appendChild(element);
                offspringSeed.saveAsXML(element, doc);
            }
        }
        catch (Exception ex) {
            System.err.println("offspringSeed saving failed!");
            ex.printStackTrace();
            Main.game.addEvent(new EventLogEntry("<style='color:" + PresetColour.GENERIC_TERRIBLE.toWebHexString() + ";'>\u90e8\u5206\u5b58\u6863\u5931\u6548<b>", "offspringSeed\u5931\u8d25"), false);
        }
        try {
            Transformer transformer1 = Main.transformerFactory.newTransformer();
            transformer1.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter stringWriter = new StringWriter();
            transformer1.transform(new DOMSource(doc), new StreamResult(stringWriter));
            Transformer transformer = Main.transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource dOMSource = new DOMSource(doc);
            String string = "data/saves/" + exportFileName + ".xml";
            StreamResult result = new StreamResult(string);
            transformer.transform(dOMSource, result);
            if (!isAutoSave) {
                if (overwrite) {
                    Main.game.addEvent(new EventLogEntry("[style.colourGood(\u6e38\u620f\u5df2\u4fdd\u5b58)]", string), false);
                    Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()), false, PresetColour.GENERIC_GOOD, "\u5b58\u6863\u88ab\u8986\u76d6\uff01");
                } else {
                    Main.game.addEvent(new EventLogEntry("[style.colourGood(\u6e38\u620f\u5df2\u4fdd\u5b58)]", string), false);
                    Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()), false, PresetColour.GENERIC_GOOD, "\u6e38\u620f\u5df2\u4fdd\u5b58\uff01");
                }
            }
        }
        catch (Exception ex) {
            System.err.println("XML writing failed!");
            ex.printStackTrace();
            Main.game.addEvent(new EventLogEntry("<style='color:" + PresetColour.GENERIC_TERRIBLE.toWebHexString() + ";'>\u90e8\u5206\u5b58\u6863\u5931\u6548</span>", "XML\u5199\u5165\u5931\u8d25"), false);
        }
        if (timeLog) {
            System.out.println("Difference: " + (float)(System.nanoTime() - timeStart) / 1.0E9f);
        }
    }

    public static void importGame(String name) {
        File file = new File("data" + System.getProperty("file.separator") + "saves" + System.getProperty("file.separator"), name + ".xml");
        Game.importGame(file);
    }

    public static void importGame(File file) {
        Main.game = new Game();
        UtilText.initScriptEngine();
        if (file.exists()) {
            try {
                Object c;
                Vector2i vec;
                Document doc = Main.getDocBuilder().parse(file);
                long time = System.nanoTime();
                if (debug) {
                    System.out.println("Load game start");
                }
                doc.getDocumentElement().normalize();
                Element gameElement = (Element)doc.getElementsByTagName("game").item(0);
                Element informationNode = (Element)gameElement.getElementsByTagName("coreInfo").item(0);
                loadingVersion = informationNode.getAttribute("version");
                if (!informationNode.getAttribute("id").isEmpty()) {
                    Main.game.id = Long.valueOf(informationNode.getAttribute("id"));
                }
                if (!informationNode.getAttribute("lastAutoSaveTime").isEmpty()) {
                    Main.game.lastAutoSaveTime = Long.valueOf(informationNode.getAttribute("lastAutoSaveTime"));
                }
                if (!informationNode.getAttribute("minutesPassed").isEmpty()) {
                    Main.game.secondsPassed = Long.valueOf(informationNode.getAttribute("minutesPassed")) * 60L;
                    Main.game.nextStormTimeInSeconds = Long.valueOf(informationNode.getAttribute("nextStormTime")) * 60L;
                    try {
                        Main.game.gatheringStormDurationInSeconds = Integer.valueOf(informationNode.getAttribute("gatheringStormDuration")) * 60;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Main.game.weatherTimeRemainingInSeconds = Integer.valueOf(informationNode.getAttribute("weatherTimeRemaining")) * 60;
                } else {
                    Main.game.secondsPassed = Long.valueOf(informationNode.getAttribute("secondsPassed"));
                    Main.game.nextStormTimeInSeconds = Long.valueOf(informationNode.getAttribute("nextStormTimeInSeconds"));
                    try {
                        Main.game.gatheringStormDurationInSeconds = Integer.valueOf(informationNode.getAttribute("gatheringStormDurationInSeconds"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Main.game.weatherTimeRemainingInSeconds = Integer.valueOf(informationNode.getAttribute("weatherTimeRemainingInSeconds"));
                }
                Main.game.currentWeather = Weather.valueOf(informationNode.getAttribute("weather"));
                try {
                    Element slaveryNode = (Element)gameElement.getElementsByTagName("slavery").item(0);
                    OccupancyUtil occupancyUtil = OccupancyUtil.loadFromXML(slaveryNode, doc);
                    if (occupancyUtil != null) {
                        Main.game.occupancyUtil = occupancyUtil;
                    }
                }
                catch (Exception slaveryNode) {
                    // empty catch block
                }
                Element inventoryNode = (Element)gameElement.getElementsByTagName("savedInventories").item(0);
                if (inventoryNode != null) {
                    NodeList nodes = inventoryNode.getElementsByTagName("savedInventory");
                    for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
                        Element savedInventory = (Element)nodes.item(i2);
                        String id = savedInventory.getAttribute("character");
                        CharacterInventory.loadingFromFloorBackupCheck = false;
                        CharacterInventory inventory = CharacterInventory.loadFromXML((Element)savedInventory.getElementsByTagName("characterInventory").item(0), doc);
                        savedInventories.put(id, inventory);
                    }
                }
                Element savedEnforcersNode = (Element)gameElement.getElementsByTagName("savedEnforcers").item(0);
                Main.game.savedEnforcers = new HashMap<AbstractWorldType, List<List<String>>>();
                if (savedEnforcersNode != null) {
                    NodeList nodes = savedEnforcersNode.getElementsByTagName("world");
                    for (int i3 = 0; i3 < nodes.getLength(); ++i3) {
                        Element world = (Element)nodes.item(i3);
                        AbstractWorldType worldType = WorldType.getWorldTypeFromId(world.getAttribute("type"));
                        ArrayList loadedEnforcers = new ArrayList();
                        NodeList enforcerNodes = world.getElementsByTagName("enforcers");
                        for (int j = 0; j < enforcerNodes.getLength(); ++j) {
                            Element enforcerIds = (Element)enforcerNodes.item(j);
                            NodeList idNodes = enforcerIds.getElementsByTagName("id");
                            ArrayList<String> ids = new ArrayList<String>();
                            for (int k = 0; k < idNodes.getLength(); ++k) {
                                ids.add(((Element)idNodes.item(k)).getTextContent());
                            }
                            loadedEnforcers.add(ids);
                        }
                        Main.game.savedEnforcers.put(worldType, loadedEnforcers);
                    }
                }
                Element dateNode = (Element)gameElement.getElementsByTagName("date").item(0);
                Main.game.startingDate = LocalDateTime.of((int)Integer.valueOf(dateNode.getAttribute("year")), Integer.valueOf(dateNode.getAttribute("month")), (int)Integer.valueOf(dateNode.getAttribute("dayOfMonth")), (int)Integer.valueOf(dateNode.getAttribute("hour")), (int)Integer.valueOf(dateNode.getAttribute("minute")));
                Main.game.dialogueFlags = DialogueFlags.loadFromXML((Element)gameElement.getElementsByTagName("dialogueFlags").item(0), doc);
                NodeList eventLogEntryElements = ((Element)gameElement.getElementsByTagName("eventLog").item(0)).getElementsByTagName("eventLogEntry");
                for (int i4 = 0; i4 < eventLogEntryElements.getLength(); ++i4) {
                    Element e2 = (Element)eventLogEntryElements.item(i4);
                    Main.game.addEvent(EventLogEntry.loadFromXML(e2, doc), false);
                }
                NodeList nodes = gameElement.getElementsByTagName("slaveryEventLog");
                Element extraEffectNode = (Element)nodes.item(0);
                if (extraEffectNode != null) {
                    NodeList slaveryDayLogElements = extraEffectNode.getElementsByTagName("day");
                    for (int i5 = 0; i5 < slaveryDayLogElements.getLength() && i5 < 7; ++i5) {
                        Element e3 = (Element)gameElement.getElementsByTagName("day").item(i5);
                        int day = Integer.valueOf(e3.getAttribute("value"));
                        Main.game.slaveryEventLog.push(new Util.Value(day, new ArrayList()));
                        NodeList dayEventLogElements = e3.getElementsByTagName("eventLogEntry");
                        for (int j = 0; j < dayEventLogElements.getLength(); ++j) {
                            Element entry = (Element)dayEventLogElements.item(j);
                            try {
                                Main.game.addSlaveryEvent(day, SlaveryEventLogEntry.loadFromXML(entry, doc));
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (debug) {
                    System.out.println("Core info finished: " + (double)(System.nanoTime() - time) / 1.0E9);
                }
                NodeList worlds = ((Element)gameElement.getElementsByTagName("maps").item(0)).getElementsByTagName("world");
                for (int i6 = 0; i6 < worlds.getLength(); ++i6) {
                    Element e4 = (Element)worlds.item(i6);
                    String worldType = e4.getAttribute("worldType");
                    if (worldType.equals("SEWERS") && Main.isVersionOlderThan(loadingVersion, "0.2.0.5") || worldType.equals("SUBMISSION") && Main.isVersionOlderThan(loadingVersion, "0.2.10.8") || (worldType.equals("IMP_FORTRESS_ALPHA") || worldType.equals("IMP_FORTRESS_FEMALES") || worldType.equals("IMP_FORTRESS_MALES")) && Main.isVersionOlderThan(loadingVersion, "0.2.11") || worldType.equals("IMP_FORTRESS_DEMON") && Main.isVersionOlderThan(loadingVersion, "0.2.12.5") || worldType.equals("DOMINION") && Main.isVersionOlderThan(loadingVersion, "0.2.2") || worldType.equals("HARPY_NEST") && Main.isVersionOlderThan(loadingVersion, "0.2.1.5") || worldType.equals("BAT_CAVERNS") && Main.isVersionOlderThan(loadingVersion, "0.2.3.5") || worldType.equals("LYSSIETH_PALACE") && Main.isVersionOlderThan(loadingVersion, "0.3") || worldType.equals("RAT_WARRENS") && Main.isVersionOlderThan(loadingVersion, "0.3.5.6") || worldType.equals("DOMINION_EXPRESS") && Main.isVersionOlderThan(loadingVersion, "0.3.7.9") || worldType.equals("SHOPPING_ARCADE") && Main.isVersionOlderThan(loadingVersion, "0.3.14") || worldType.equals("innoxia_fields_elis_market") && Main.isVersionOlderThan(loadingVersion, "0.4.1.1") || worldType.equals("innoxia_fields_elis_tavern_alley") && Main.isVersionOlderThan(loadingVersion, "0.4.4") || worldType.equals("innoxia_fields_themiscyra") && Main.isVersionOlderThan(loadingVersion, "0.4.4.5") || worldType.equals("EMPTY") && Main.isVersionOlderThan(loadingVersion, "0.4.5.7") || worldType.equals("SLAVER_ALLEY") && Main.isVersionOlderThan(loadingVersion, "0.4.5.7") || worldType.equals("innoxia_fields_elis_market") && Main.isVersionOlderThan(loadingVersion, "0.4.8.7") || worldType.equals("innoxia_dominion_sex_shop") && Main.isVersionOlderThan(loadingVersion, "0.4.9.12") || worldType.equals("innoxia_dominion_sex_shop_factory") && Main.isVersionOlderThan(loadingVersion, "0.4.9.13") || worldType.equals("BOUNTY_HUNTER_LODGE_UPSTAIRS") && Main.isVersionOlderThan(loadingVersion, "0.4.10.2") || worldType.equals("SUPPLIER_DEN") || worldType.equals("JUNGLE")) continue;
                    World world = World.loadFromXML(e4, doc);
                    Main.game.worlds.put(world.getWorldType(), world);
                }
                Generation gen = new Generation();
                if (Main.isVersionOlderThan(loadingVersion, "0.2.1.5")) {
                    Main.game.getWorlds().put(WorldType.HARPY_NEST, gen.worldGeneration(WorldType.HARPY_NEST));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.2.10.8")) {
                    Main.game.getWorlds().put(WorldType.SUBMISSION, gen.worldGeneration(WorldType.SUBMISSION));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.2.11")) {
                    Main.game.getWorlds().put(WorldType.IMP_FORTRESS_ALPHA, gen.worldGeneration(WorldType.IMP_FORTRESS_ALPHA));
                    Main.game.getWorlds().put(WorldType.IMP_FORTRESS_FEMALES, gen.worldGeneration(WorldType.IMP_FORTRESS_FEMALES));
                    Main.game.getWorlds().put(WorldType.IMP_FORTRESS_MALES, gen.worldGeneration(WorldType.IMP_FORTRESS_MALES));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.2.12.5")) {
                    Main.game.getWorlds().put(WorldType.IMP_FORTRESS_DEMON, gen.worldGeneration(WorldType.IMP_FORTRESS_DEMON));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.2.2")) {
                    Main.game.getWorlds().put(WorldType.DOMINION, gen.worldGeneration(WorldType.DOMINION));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.2.3.5")) {
                    Main.game.getWorlds().put(WorldType.BAT_CAVERNS, gen.worldGeneration(WorldType.BAT_CAVERNS));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.2.8")) {
                    Main.game.getWorlds().put(WorldType.NIGHTLIFE_CLUB, gen.worldGeneration(WorldType.NIGHTLIFE_CLUB));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.2.8.1")) {
                    Main.game.getWorlds().put(WorldType.EMPTY, gen.worldGeneration(WorldType.EMPTY));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3")) {
                    Main.game.getWorlds().put(WorldType.LYSSIETH_PALACE, gen.worldGeneration(WorldType.LYSSIETH_PALACE));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.2.2")) {
                    Main.game.getWorlds().put(WorldType.CITY_HALL, gen.worldGeneration(WorldType.CITY_HALL));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.4.9")) {
                    Main.game.getWorlds().put(WorldType.ENFORCER_WAREHOUSE, gen.worldGeneration(WorldType.ENFORCER_WAREHOUSE));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.5.4")) {
                    Main.game.getWorlds().put(WorldType.GAMBLING_DEN, gen.worldGeneration(WorldType.GAMBLING_DEN));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.5.6")) {
                    Main.game.getWorlds().put(WorldType.RAT_WARRENS, gen.worldGeneration(WorldType.RAT_WARRENS));
                    Main.game.getWorlds().put(WorldType.SLAVER_ALLEY, gen.worldGeneration(WorldType.SLAVER_ALLEY));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.7")) {
                    Main.game.getWorlds().put(WorldType.HELENAS_APARTMENT, gen.worldGeneration(WorldType.HELENAS_APARTMENT));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.7.9")) {
                    Main.game.getWorlds().put(WorldType.DOMINION_EXPRESS, gen.worldGeneration(WorldType.DOMINION_EXPRESS));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.9.4")) {
                    Main.game.getWorlds().put(WorldType.ENFORCER_HQ, gen.worldGeneration(WorldType.ENFORCER_HQ));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.0.5")) {
                    Main.game.getWorlds().put(WorldType.getWorldTypeFromId("innoxia_fields_elis_town"), gen.worldGeneration(WorldType.getWorldTypeFromId("innoxia_fields_elis_town")));
                    Main.game.getWorlds().put(WorldType.getWorldTypeFromId("innoxia_fields_elis_tavern_f1"), gen.worldGeneration(WorldType.getWorldTypeFromId("innoxia_fields_elis_tavern_f1")));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.3.9")) {
                    Main.game.getWorlds().put(WorldType.getWorldTypeFromId("innoxia_fields_elis_tavern_alley"), gen.worldGeneration(WorldType.getWorldTypeFromId("innoxia_fields_elis_tavern_alley")));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.5.7")) {
                    Main.game.getWorlds().put(WorldType.EMPTY, gen.worldGeneration(WorldType.EMPTY));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.5.7")) {
                    Main.game.getWorlds().put(WorldType.SLAVER_ALLEY, gen.worldGeneration(WorldType.SLAVER_ALLEY));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.7.11")) {
                    Main.game.getWorlds().put(WorldType.getWorldTypeFromId("innoxia_fields_elis_tavern_taur"), gen.worldGeneration(WorldType.getWorldTypeFromId("innoxia_fields_elis_tavern_taur")));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.9.1")) {
                    Main.game.getWorlds().put(WorldType.getWorldTypeFromId("innoxia_dominion_sex_shop"), gen.worldGeneration(WorldType.getWorldTypeFromId("innoxia_dominion_sex_shop")));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.10.2")) {
                    Main.game.getWorlds().put(WorldType.BOUNTY_HUNTER_LODGE_UPSTAIRS, gen.worldGeneration(WorldType.BOUNTY_HUNTER_LODGE_UPSTAIRS));
                }
                for (AbstractWorldType wt : WorldType.getAllWorldTypes()) {
                    if (Main.game.worlds.get(wt) != null) continue;
                    Main.game.getWorlds().put(wt, gen.worldGeneration(wt));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.6.9")) {
                    vec = Main.game.getWorlds().get(WorldType.DOMINION).getCell(PlaceType.DOMINION_SLAVER_ALLEY).getLocation();
                    vec.setX(vec.getX() + 1);
                    vec.setY(vec.getY() - 5);
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell(vec).getPlace().setPlaceType(PlaceType.DOMINION_HOME_IMPROVEMENT);
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell(vec).getPlace().setName(PlaceType.DOMINION_HOME_IMPROVEMENT.getName());
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell(vec).setDiscovered(true);
                    vec = Main.game.getWorlds().get(WorldType.DOMINION).getCell(PlaceType.DOMINION_SLAVER_ALLEY).getLocation();
                    vec.setX(vec.getX() + 1);
                    vec.setY(vec.getY() + 4);
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell(vec).getPlace().setPlaceType(PlaceType.DOMINION_WAREHOUSES);
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell(vec).getPlace().setName(PlaceType.DOMINION_WAREHOUSES.getName());
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell(vec).setDiscovered(true);
                    vec = Main.game.getWorlds().get(WorldType.SHOPPING_ARCADE).getCell(PlaceType.SHOPPING_ARCADE_NYANS_SHOP).getLocation();
                    vec.setX(vec.getX() + 1);
                    vec.setY(vec.getY() - 1);
                    Main.game.getWorlds().get(WorldType.SHOPPING_ARCADE).getCell(vec).getPlace().setPlaceType(PlaceType.SHOPPING_ARCADE_ANTIQUES);
                    Main.game.getWorlds().get(WorldType.SHOPPING_ARCADE).getCell(vec).getPlace().setName(PlaceType.SHOPPING_ARCADE_ANTIQUES.getName());
                    Main.game.getWorlds().get(WorldType.SHOPPING_ARCADE).getCell(vec).setDiscovered(true);
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.2.4")) {
                    AbstractItem spellBook = Main.game.getItemGen().generateItem(ItemType.getSpellBookType(Spell.ICE_SHARD));
                    Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_FIRST_FLOOR).getCell(PlaceType.LILAYA_HOME_ROOM_PLAYER).getInventory().addItem(spellBook);
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.8.8")) {
                    ArrayList<Vector2i> vecs = Util.newArrayListOfValues(new Vector2i(2, 5), new Vector2i(5, 8), new Vector2i(8, 5));
                    for (Vector2i vec2 : vecs) {
                        Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCell(vec2).getPlace().setPlaceType(PlaceType.LILAYA_HOME_STAIR_UP_SECONDARY);
                        Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCell(vec2).getPlace().setName(PlaceType.LILAYA_HOME_STAIR_UP_SECONDARY.getName());
                        Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCell(vec2).setDiscovered(true);
                        Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_FIRST_FLOOR).getCell(vec2).getPlace().setPlaceType(PlaceType.LILAYA_HOME_STAIR_DOWN_SECONDARY);
                        Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_FIRST_FLOOR).getCell(vec2).getPlace().setName(PlaceType.LILAYA_HOME_STAIR_DOWN_SECONDARY.getName());
                        Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_FIRST_FLOOR).getCell(vec2).setDiscovered(true);
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.7.2")) {
                    vec = Main.game.getWorlds().get(WorldType.BAT_CAVERNS).getCell(PlaceType.BAT_CAVERN_SLIME_QUEEN_LAIR).getLocation();
                    vec.setY(vec.getY() - 3);
                    Main.game.getWorlds().get(WorldType.BAT_CAVERNS).getCell(vec).getPlace().setPlaceType(PlaceType.BAT_CAVERN_SHAFT);
                    Main.game.getWorlds().get(WorldType.BAT_CAVERNS).getCell(vec).getPlace().setName(PlaceType.BAT_CAVERN_SHAFT.getName());
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.7.7")) {
                    vec = Main.game.getWorlds().get(WorldType.DOMINION).getCell(PlaceType.DOMINION_SHOPPING_ARCADE).getLocation();
                    vec.setY(vec.getY() + 2);
                    vec.setX(vec.getX() - 1);
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell(vec).getPlace().setPlaceType(PlaceType.DOMINION_BANK);
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell(vec).getPlace().setName(PlaceType.DOMINION_BANK.getName());
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.10.8")) {
                    Cell towerCell = Main.game.getWorlds().get(WorldType.getWorldTypeFromId("innoxia_fields_elis_town")).getClosestCell(new Vector2i(0, 0), PlaceType.getPlaceTypeFromId("innoxia_fields_elis_town_tower"));
                    towerCell.getPlace().setPlaceType(PlaceType.getPlaceTypeFromId("innoxia_fields_elis_town_tower_yui"));
                    towerCell.getPlace().setName(PlaceType.getPlaceTypeFromId("innoxia_fields_elis_town_tower_yui").getName());
                }
                if (debug) {
                    System.out.println("Maps finished: " + (double)(System.nanoTime() - time) / 1.0E9);
                }
                Main.game.player = PlayerCharacter.loadFromXML(null, (Element)gameElement.getElementsByTagName("playerCharacter").item(0), doc, new CharacterImportSetting[0]);
                if (debug) {
                    System.out.println("Player finished: " + (double)(System.nanoTime() - time) / 1.0E9);
                }
                NodeList npcs = gameElement.getElementsByTagName("NPC");
                ConcurrentHashMap npcClasses = new ConcurrentHashMap();
                ConcurrentHashMap loadFromXMLMethods = new ConcurrentHashMap();
                ConcurrentHashMap constructors = new ConcurrentHashMap();
                int totalNpcCount = npcs.getLength();
                IntStream.range(0, totalNpcCount).parallel().mapToObj(i -> (Element)npcs.item(i)).forEach(e -> {
                    String id = ((Element)e.getElementsByTagName("id").item(0)).getAttribute("value");
                    if (!Main.game.NPCMap.containsKey(id)) {
                        int lastIndex;
                        Object className = ((Element)e.getElementsByTagName("pathName").item(0)).getAttribute("value");
                        if (Main.isVersionOlderThan(loadingVersion, "0.2.4") && ((String)className).substring((lastIndex = ((String)className).lastIndexOf(46)) - 3, lastIndex).equals("npc")) {
                            className = ((String)className).substring(0, lastIndex) + ".misc" + ((String)className).substring(lastIndex, ((String)className).length());
                        }
                        if (Main.isVersionOlderThan(loadingVersion, "0.4.1.5")) {
                            className = ((String)className).replace("SubmissionCitadelArcanist", "Takahashi");
                        }
                        if (Main.isVersionOlderThan(loadingVersion, "0.4")) {
                            className = ((String)className).replace("BatMorphCavernAttacker", "BatCavernLurkerAttacker");
                            className = ((String)className).replace("SlimeCavernAttacker", "BatCavernSlimeAttacker");
                        }
                        if (Main.isVersionOlderThan(loadingVersion, "0.3")) {
                            className = ((String)className).replace("FortressDemonLeader", "DarkSiren");
                        }
                        if (!Main.isVersionOlderThan(loadingVersion, "0.3.5.9") || !id.contains("Helena")) {
                            NPC npc;
                            if (Main.isVersionOlderThan(loadingVersion, "0.3.5.9")) {
                                className = ((String)className).replace("Alexa", "Helena");
                            }
                            if ((npc = Game.loadNPC(doc, e, (String)className, npcClasses, loadFromXMLMethods, constructors)) != null) {
                                if (!Main.isVersionOlderThan(loadingVersion, "0.2.11.5") || npc.getClass() != DarkSiren.class && npc.getClass() != FortressAlphaLeader.class && npc.getClass() != FortressMalesLeader.class && npc.getClass() != FortressFemalesLeader.class) {
                                    Main.game.safeAddNPC(npc, true);
                                }
                                if (Main.isVersionOlderThan(loadingVersion, "0.1.90.5")) {
                                    npc.getBody().getHair().setLength(null, npc.isFeminine() ? RacialBody.valueOfRace(npc.getRace()).getFemaleHairLength() : RacialBody.valueOfRace(npc.getRace()).getMaleHairLength());
                                }
                                if (Main.isVersionOlderThan(loadingVersion, "0.1.98.5") && !npc.isUnique() && npc.getFetishDesireMap().isEmpty()) {
                                    Main.game.getCharacterUtils().generateDesires(npc);
                                }
                                if (Main.isVersionOlderThan(loadingVersion, "0.2.0") && npc.getFetishDesireMap().size() > 10) {
                                    npc.clearFetishDesires();
                                    Main.game.getCharacterUtils().generateDesires(npc);
                                }
                                if (Main.isVersionOlderThan(loadingVersion, "0.3.5.4") && npc.getWorldLocation() == WorldType.GAMBLING_DEN) {
                                    if (npc instanceof Roxy) {
                                        npc.setLocation(WorldType.GAMBLING_DEN, PlaceType.GAMBLING_DEN_TRADER, true);
                                    } else if (npc instanceof Axel) {
                                        npc.setLocation(WorldType.GAMBLING_DEN, PlaceType.GAMBLING_DEN_ENTRANCE, true);
                                    } else if (npc instanceof Epona) {
                                        npc.setLocation(WorldType.GAMBLING_DEN, PlaceType.GAMBLING_DEN_PREGNANCY_ROULETTE, true);
                                    } else {
                                        npc.setLocation(WorldType.GAMBLING_DEN, PlaceType.GAMBLING_DEN_GAMBLING, true);
                                    }
                                }
                                if (npc.getParserTarget() != null) {
                                    ParserTarget.addAdditionalParserTarget(npc.getParserTarget(), npc);
                                }
                            } else {
                                System.err.println("LOADNPC returned null: " + id);
                                System.err.println("CLASS: " + (String)className);
                            }
                        }
                    } else if (!id.contains("Helena")) {
                        System.err.println("duplicate character attempted to be imported");
                    }
                });
                NodeList offspringSeedList = gameElement.getElementsByTagName("OffspringSeed");
                if (offspringSeedList.getLength() > 0) {
                    for (int i7 = 0; i7 < offspringSeedList.getLength(); ++i7) {
                        Iterator<NPC> e5 = (Element)offspringSeedList.item(i7);
                        Main.game.addOffspringSeed(OffspringSeed.loadFromXML((Element)((Object)e5), doc), true);
                    }
                }
                if (debug) {
                    System.out.println("OffspringSeed finished: " + (double)(System.nanoTime() - time) / 1.0E9);
                }
                int OSConverstions = 0;
                if (Main.isVersionOlderThan(loadingVersion, "0.4.2.4")) {
                    for (NPC npc : Main.game.getAllNPCs()) {
                        if (!(npc instanceof NPCOffspring) || npc.getLocationPlace().getPlaceType() != PlaceType.GENERIC_HOLDING_CELL || npc.getHomeLocationPlace().getPlaceType() != PlaceType.GENERIC_HOLDING_CELL) continue;
                        new OffspringSeed(npc);
                        ++OSConverstions;
                    }
                    if (debug) {
                        System.out.println("OSConversions count: " + OSConverstions);
                    }
                }
                if (debug) {
                    System.out.println("Convert NPC finished: " + (double)(System.nanoTime() - time) / 1.0E9);
                }
                Main.game.initUniqueNPCs();
                for (NPC npc : Main.game.getAllNPCs()) {
                    if (npc == null || npc.getLocationPlace().getPlaceType() != PlaceType.GENERIC_EMPTY_TILE || !npc.isReadyToBeDeleted()) continue;
                    Main.game.banishNPC(npc);
                    if (!debug) continue;
                    System.out.println("Deleted NPC: " + npc.getId());
                }
                if (debug) {
                    System.out.println("NPCs finished: " + (double)(System.nanoTime() - time) / 1.0E9);
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.2.8")) {
                    Main.game.getNpc(Jules.class).setLocation(WorldType.NIGHTLIFE_CLUB, PlaceType.WATERING_HOLE_ENTRANCE);
                    Main.game.getNpc(Kruger.class).setLocation(WorldType.NIGHTLIFE_CLUB, PlaceType.WATERING_HOLE_VIP_AREA);
                    Main.game.getNpc(Kalahari.class).setLocation(WorldType.NIGHTLIFE_CLUB, PlaceType.WATERING_HOLE_BAR);
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.1.90.5") && (Main.game.getPlayer().getWorldLocation() == WorldType.ZARANIX_HOUSE_GROUND_FLOOR || Main.game.getPlayer().getWorldLocation() == WorldType.ZARANIX_HOUSE_FIRST_FLOOR)) {
                    Main.game.getPlayer().setLocation(WorldType.DOMINION, PlaceType.DOMINION_DEMON_HOME, false);
                    ZaranixHomeGroundFloor.resetHouseAfterLeaving();
                    Main.game.getDialogueFlags().setFlag(DialogueFlagValue.zaranixDiscoveredHome, false);
                    Main.game.getDialogueFlags().setFlag(DialogueFlagValue.zaranixKickedDownDoor, false);
                    Main.game.getDialogueFlags().setFlag(DialogueFlagValue.zaranixKnockedOnDoor, false);
                    Main.game.getDialogueFlags().setFlag(DialogueFlagValue.zaranixMaidsHostile, false);
                    Main.game.getNpc(Arthur.class).setLocation(WorldType.ZARANIX_HOUSE_FIRST_FLOOR, PlaceType.ZARANIX_FF_OFFICE, true);
                    if (Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_1_H_THE_GREAT_ESCAPE)) {
                        Main.game.getPlayer().setQuestProgress(QuestLine.MAIN, Quest.MAIN_1_H_THE_GREAT_ESCAPE);
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.1.95") && Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_1_H_THE_GREAT_ESCAPE)) {
                    Main.game.getNpc(Arthur.class).setLocation(WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_LAB, true);
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.2.4.5")) {
                    for (NPC npc : Main.game.getAllNPCs()) {
                        if (npc.isUnique() || npc.getWorldLocation() != WorldType.EMPTY) continue;
                        Main.game.banishNPC(npc);
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.2.5.1")) {
                    for (NPC npc : Main.game.getAllNPCs()) {
                        if (npc.isSlave() && (npc.getOwner() == null || npc.getOwner().isPlayer())) continue;
                        npc.setSkinCovering(new Covering(npc.getTorsoCovering(), npc.getCovering(npc.getTorsoCovering()).getPrimaryColour()), true);
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.2.5")) {
                    int j;
                    Object grid = Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCellGrid();
                    for (int i8 = 0; i8 < ((Cell[][])grid).length; ++i8) {
                        for (j = 0; j < grid[0].length; ++j) {
                            if (!((Cell)grid[i8][j]).getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM)) continue;
                            Main.game.getOccupancyUtil().addMilkingRoom(new MilkingRoom(WorldType.LILAYAS_HOUSE_GROUND_FLOOR, new Vector2i(i8, j)));
                        }
                    }
                    grid = Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_FIRST_FLOOR).getCellGrid();
                    for (int i2 = 0; i2 < ((Object)grid).length; ++i2) {
                        for (j = 0; j < ((Object)grid[0]).length; ++j) {
                            if (!((Cell)grid[i2][j]).getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM)) continue;
                            Main.game.getOccupancyUtil().addMilkingRoom(new MilkingRoom(WorldType.LILAYAS_HOUSE_FIRST_FLOOR, new Vector2i(i2, j)));
                        }
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.2.12.6")) {
                    ImpFortressDialogue.resetFortress(WorldType.IMP_FORTRESS_ALPHA);
                    ImpFortressDialogue.resetFortress(WorldType.IMP_FORTRESS_FEMALES);
                    ImpFortressDialogue.resetFortress(WorldType.IMP_FORTRESS_MALES);
                    Main.game.getDialogueFlags().setFlag(DialogueFlagValue.impFortressAlphaBossEncountered, false);
                    Main.game.getDialogueFlags().setFlag(DialogueFlagValue.impFortressFemalesBossEncountered, false);
                    Main.game.getDialogueFlags().setFlag(DialogueFlagValue.impFortressMalesBossEncountered, false);
                    if (Main.game.getPlayer().getWorldLocation() == WorldType.IMP_FORTRESS_ALPHA) {
                        Main.game.getPlayer().setLocation(WorldType.SUBMISSION, PlaceType.SUBMISSION_IMP_FORTRESS_ALPHA);
                    } else if (Main.game.getPlayer().getWorldLocation() == WorldType.IMP_FORTRESS_FEMALES) {
                        Main.game.getPlayer().setLocation(WorldType.SUBMISSION, PlaceType.SUBMISSION_IMP_FORTRESS_FEMALES);
                    } else if (Main.game.getPlayer().getWorldLocation() == WorldType.IMP_FORTRESS_MALES) {
                        Main.game.getPlayer().setLocation(WorldType.SUBMISSION, PlaceType.SUBMISSION_IMP_FORTRESS_MALES);
                    }
                    Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.IMP_FORTRESS_ARCANE_KEY));
                    Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.IMP_FORTRESS_ARCANE_KEY_2));
                    Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.IMP_FORTRESS_ARCANE_KEY_3));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.2.12.6") || Main.isVersionOlderThan(loadingVersion, "0.3.0.5") && !Main.game.getNpc(DarkSiren.class).isSlave() && Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressDemonDefeated)) {
                    if (Main.game.getPlayer().getWorldLocation() == WorldType.IMP_FORTRESS_DEMON) {
                        Main.game.getPlayer().setLocation(WorldType.SUBMISSION, PlaceType.SUBMISSION_IMP_FORTRESS_DEMON);
                    }
                    ImpCitadelDialogue.resetFortress();
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.2.12.9")) {
                    for (NPC npc : Main.game.getAllNPCs()) {
                        GameCharacter mother;
                        if (Main.game.getPlayer().getFriendlyOccupants().contains(npc.getId()) && npc.getHomeWorldLocation() == WorldType.DOMINION && !npc.hasJob()) {
                            npc.assignNewJob();
                        }
                        if (npc.getSurname() != null && !npc.getSurname().isEmpty() || (mother = npc.getMother()) == null) continue;
                        while (mother.getMother() != null) {
                            mother = mother.getMother();
                        }
                        if (mother.getSurname() == null || mother.getSurname().isEmpty()) continue;
                        npc.setSurname(mother.getSurname());
                    }
                    if (Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_2_C_SIRENS_FALL)) {
                        Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.LYSSIETHS_RING));
                    }
                    if (Main.game.getPlayer().hasClothingType(ClothingType.getClothingTypeFromId("innoxia_neck_key_chain"), true)) {
                        Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.IMP_FORTRESS_ARCANE_KEY));
                        Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.IMP_FORTRESS_ARCANE_KEY_2));
                        Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.IMP_FORTRESS_ARCANE_KEY_3));
                    }
                    while (Main.game.getPlayer().getItemCount(Main.game.getItemGen().generateItem(ItemType.IMP_FORTRESS_ARCANE_KEY)) > 1) {
                        Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.IMP_FORTRESS_ARCANE_KEY));
                    }
                    while (Main.game.getPlayer().getItemCount(Main.game.getItemGen().generateItem(ItemType.IMP_FORTRESS_ARCANE_KEY_2)) > 1) {
                        Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.IMP_FORTRESS_ARCANE_KEY_2));
                    }
                    while (Main.game.getPlayer().getItemCount(Main.game.getItemGen().generateItem(ItemType.IMP_FORTRESS_ARCANE_KEY_3)) > 1) {
                        Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.IMP_FORTRESS_ARCANE_KEY_3));
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3")) {
                    if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressDemonDefeated)) {
                        Main.game.getNpc(Takahashi.class).setLocation(WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL);
                    }
                    if (Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_2_C_SIRENS_FALL)) {
                        Main.game.getPlayer().setQuestProgress(QuestLine.MAIN, Quest.MAIN_2_C_SIRENS_FALL);
                        if (Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SUBMISSION_LILIN_PALACE) || Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SUBMISSION_LILIN_PALACE_GATE)) {
                            Main.game.getPlayer().setLocation(WorldType.SUBMISSION, PlaceType.SUBMISSION_LILIN_PALACE_CAVERN);
                        }
                    }
                    Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCell(PlaceType.LILAYA_HOME_LIBRARY).getInventory().addItem(Main.game.getItemGen().generateItem(ItemType.getLoreBook(Subspecies.HALF_DEMON)));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.0.5") && Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_2_C_SIRENS_FALL)) {
                    ImpCitadelDialogue.clearFortress(true);
                    ImpFortressDialogue.resetFortress(WorldType.IMP_FORTRESS_ALPHA);
                    ImpFortressDialogue.resetFortress(WorldType.IMP_FORTRESS_FEMALES);
                    ImpFortressDialogue.resetFortress(WorldType.IMP_FORTRESS_MALES);
                    ((DarkSiren)Main.game.getNpc(DarkSiren.class)).postDefeatReset();
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.0.6")) {
                    if (Main.game.getNpc(Lilaya.class).getRaceStage() == RaceStage.GREATER) {
                        Main.game.getNpc(Lilaya.class).setAffection(Main.game.getNpc(Lyssieth.class), 75.0f);
                        Main.game.getNpc(Lilaya.class).incrementAffection(Main.game.getPlayer(), 50.0f);
                    }
                    if (Main.game.getNpc(DarkSiren.class).getRaceStage() == RaceStage.GREATER) {
                        Main.game.getNpc(DarkSiren.class).setAffection(Main.game.getNpc(Lyssieth.class), 75.0f);
                        Main.game.getNpc(DarkSiren.class).addFetish(Fetish.FETISH_INCEST);
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.1.2") && Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_1_C_WOLFS_DEN) && !Main.game.getNpc(Brax.class).getLocationPlace().getPlaceType().equals(PlaceType.ENFORCER_HQ_RECEPTION_DESK)) {
                    Main.game.getNpc(Brax.class).setLocation(WorldType.ENFORCER_HQ, PlaceType.ENFORCER_HQ_RECEPTION_DESK);
                    for (NPC npc : new HashSet<NPC>(Main.game.getNPCMap().values())) {
                        if (!(npc instanceof NPCOffspring) || npc.isRelatedTo(Main.game.getPlayer(), new Relationship[0])) continue;
                        Main.game.banishNPC(npc);
                    }
                }
                for (Cell cell : Main.game.getWorlds().get(WorldType.ANGELS_KISS_GROUND_FLOOR).getCells(PlaceType.ANGELS_KISS_BEDROOM)) {
                    if (!Main.isVersionOlderThan(loadingVersion, "0.3.1.7")) continue;
                    for (NPC npc : Main.game.getCharactersPresent(cell)) {
                        if (!(npc instanceof GenericSexualPartner)) continue;
                        Main.game.banishNPC(npc);
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.3.9")) {
                    for (NPC npc : Main.game.getAllNPCs()) {
                        if (!npc.isElemental()) continue;
                        PerkManager.initialisePerks(npc);
                    }
                    if (Main.game.getPlayer().removeTrait(Perk.JOB_ELDER_LILIN)) {
                        Main.game.getPlayer().addTrait(Main.game.getPlayer().getHistory().getAssociatedPerk());
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.3.9")) {
                    if (!Main.game.getPlayer().isQuestProgressLessThan(QuestLine.MAIN, Quest.MAIN_1_H_THE_GREAT_ESCAPE) && Main.game.getWorlds().get(WorldType.DOMINION).getCell(PlaceType.DOMINION_DEMON_HOME_ZARANIX) == null) {
                        ((Zaranix)Main.game.getNpc(Zaranix.class)).generateNewTile();
                    }
                    if (Main.game.getPlayer().isQuestProgressLessThan(QuestLine.MAIN, Quest.MAIN_1_B_DEMON_HOME) && Main.game.getWorlds().get(WorldType.DOMINION).getCell(PlaceType.DOMINION_DEMON_HOME_ARTHUR) != null) {
                        Main.game.getWorlds().get(WorldType.DOMINION).getCell(PlaceType.DOMINION_DEMON_HOME_ARTHUR).getPlace().setPlaceType(PlaceType.DOMINION_DEMON_HOME);
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.4.1") && (c = Main.game.getWorlds().get(WorldType.DOMINION).getCell(PlaceType.DOMINION_DEMON_HOME_ARTHUR)) != null) {
                    while (c != null) {
                        ((Cell)c).getPlace().setPlaceType(PlaceType.DOMINION_DEMON_HOME);
                        c = Main.game.getWorlds().get(WorldType.DOMINION).getCell(PlaceType.DOMINION_DEMON_HOME_ARTHUR);
                    }
                    ((Arthur)Main.game.getNpc(Arthur.class)).generateNewTile();
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.4.5")) {
                    for (NPC npc : Main.game.getAllNPCs()) {
                        if (npc instanceof DominionAlleywayAttacker && ((DominionAlleywayAttacker)npc).isStormAttacker()) {
                            Main.game.banishNPC(npc);
                            continue;
                        }
                        if (npc.isSlave() || npc.isUnique() || Main.game.getPlayer().getFriendlyOccupants().contains(npc.getId())) continue;
                        npc.setHomeLocation();
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.4.9")) {
                    if (!Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_1_C_WOLFS_DEN)) {
                        Main.game.getWorlds().get(WorldType.ENFORCER_HQ).getCell(PlaceType.ENFORCER_HQ_BRAXS_OFFICE).getInventory().clearNonEquippedInventory(false);
                        PlaceType.ENFORCER_HQ_BRAXS_OFFICE.applyInventoryInit(Main.game.getWorlds().get(WorldType.ENFORCER_HQ).getCell(PlaceType.ENFORCER_HQ_BRAXS_OFFICE).getInventory());
                    }
                    if (Main.game.getNpc(Brax.class).isSlave() && Main.game.getNpc(Brax.class).getOwner().isPlayer()) {
                        if (Main.game.getNpc(Brax.class).isFeminine()) {
                            Main.game.getNpc(Brax.class).addClothing(Main.game.getItemGen().generateClothing("dsg_eep_servequipset_enfskirt", PresetColour.CLOTHING_BLACK, false), false);
                            Main.game.getNpc(Brax.class).addClothing(Main.game.getItemGen().generateClothing("dsg_eep_ptrlequipset_flsldshirt", PresetColour.CLOTHING_PINK, false), false);
                            Main.game.getNpc(Brax.class).addClothing(Main.game.getItemGen().generateClothing("innoxia_neck_tie", PresetColour.CLOTHING_BLACK, false), false);
                        } else {
                            Main.game.getNpc(Brax.class).addClothing(Main.game.getItemGen().generateClothing("dsg_eep_servequipset_enfdslacks", PresetColour.CLOTHING_BLACK, false), false);
                            Main.game.getNpc(Brax.class).addClothing(Main.game.getItemGen().generateClothing("dsg_eep_ptrlequipset_ssldshirt", PresetColour.CLOTHING_BLUE, false), false);
                            Main.game.getNpc(Brax.class).addClothing(Main.game.getItemGen().generateClothing("innoxia_neck_tie", PresetColour.CLOTHING_BLACK, false), false);
                        }
                        AbstractClothing jacket = Main.game.getItemGen().generateClothing("dsg_eep_servequipset_enfdjacket", PresetColour.CLOTHING_BLACK, PresetColour.CLOTHING_BLUE, null, false);
                        jacket.setSticker("collar", "tab_ip");
                        jacket.setSticker("name", "name_brax");
                        jacket.setSticker("ribbon", "ribbon_brax");
                        Main.game.getNpc(Brax.class).addClothing(jacket, false);
                        Main.game.getNpc(Brax.class).addClothing(Main.game.getItemGen().generateClothing("dsg_eep_servequipset_enfdbelt", PresetColour.CLOTHING_DESATURATED_BROWN, false), false);
                        AbstractClothing hat = Main.game.getItemGen().generateClothing("dsg_eep_ptrlequipset_pcap", PresetColour.CLOTHING_BLACK, false);
                        hat.setSticker("badge", "badge_dominion");
                        Main.game.getNpc(Brax.class).addClothing(hat, false);
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.5.6") && Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_BUYING_BRAX) && (!Main.game.getNpc(Brax.class).isSlave() || !Main.game.getNpc(Brax.class).getOwner().isPlayer() || Main.game.getNpc(Brax.class).getLocationPlace().getPlaceType() == PlaceType.ENFORCER_HQ_RECEPTION_DESK)) {
                    EnforcerHQDialogue.obtainBraxAsSlave();
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.6.6")) {
                    for (NPC npc : Main.game.getAllNPCs()) {
                        if (!Main.game.getPlayer().getFriendlyOccupants().contains(npc.getId()) || !npc.getHistory().isLowlife()) continue;
                        npc.setHistory(Occupation.NPC_UNEMPLOYED);
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.7")) {
                    Object vec3 = Main.game.getWorlds().get(WorldType.DOMINION).getCell(PlaceType.DOMINION_SLAVER_ALLEY).getLocation();
                    ((Vector2i)vec3).setY(((Vector2i)vec3).getY() + 1);
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell((Vector2i)vec3).getPlace().setPlaceType(PlaceType.DOMINION_BACK_ALLEYS_SAFE);
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell((Vector2i)vec3).getPlace().setName(PlaceType.DOMINION_BACK_ALLEYS_SAFE.getName());
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell((Vector2i)vec3).setDiscovered(true);
                    vec3 = new Vector2i(0, 3);
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell((Vector2i)vec3).getPlace().setPlaceType(PlaceType.DOMINION_BACK_ALLEYS);
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell((Vector2i)vec3).getPlace().setName(PlaceType.DOMINION_BACK_ALLEYS.getName());
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell((Vector2i)vec3).setDiscovered(true);
                    vec3 = new Vector2i(0, 4);
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell((Vector2i)vec3).getPlace().setPlaceType(PlaceType.DOMINION_BACK_ALLEYS);
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell((Vector2i)vec3).getPlace().setName(PlaceType.DOMINION_BACK_ALLEYS.getName());
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell((Vector2i)vec3).setDiscovered(true);
                    if (!Main.game.getCharactersTreatingCellAsHome(Main.game.getWorlds().get(WorldType.DOMINION).getCell(PlaceType.DOMINION_BACK_ALLEYS_SAFE)).isEmpty()) {
                        GameCharacter character = Main.game.getCharactersTreatingCellAsHome(Main.game.getWorlds().get(WorldType.DOMINION).getCell(PlaceType.DOMINION_BACK_ALLEYS_SAFE)).get(0);
                        character.setLocation(WorldType.DOMINION, (Vector2i)vec3, true);
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.7.3")) {
                    for (NPC npc : Main.game.getAllNPCs()) {
                        if (npc.isPregnant() || npc.hasStatusEffect(StatusEffect.PREGNANT_0)) continue;
                        npc.endPregnancy(false);
                    }
                    if (!Main.game.getPlayer().isPregnant() && !Main.game.getPlayer().hasStatusEffect(StatusEffect.PREGNANT_0)) {
                        Main.game.getPlayer().endPregnancy(false);
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.8.2") && Main.game.getPlayer().isQuestCompleted(QuestLine.ROMANCE_NATALYA)) {
                    try {
                        GameCharacter thunder = Main.game.getNPCById(Main.game.getDialogueFlags().getSadistNatalyaSlave());
                        thunder.setHomeLocation(WorldType.DOMINION_EXPRESS, PlaceType.DOMINION_EXPRESS_STABLES);
                    }
                    catch (Exception e6) {
                        Main.game.getNpc(Natalya.class).getSlavesOwned().remove(Main.game.getDialogueFlags().getSadistNatalyaSlave());
                        GameCharacter thunder = DominionExpress.spawnSlave(Main.game.getPlayer().getSexualOrientation().isAttractedToFeminine(), PresetColour.CLOTHING_BRONZE);
                        DominionExpress.applySadistSlave(thunder);
                        thunder.returnToHome();
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.8.6")) {
                    if (Main.game.getPlayer().isElementalSummoned()) {
                        Main.game.getPlayer().removeCompanion(Main.game.getPlayer().getElemental());
                        Main.game.getPlayer().getElemental().returnToHome();
                    }
                    for (GameCharacter companion : new ArrayList<GameCharacter>(Main.game.getPlayer().getCompanions())) {
                        Main.game.getPlayer().removeCompanion(companion);
                        companion.returnToHome();
                    }
                    for (NPC npc : Main.game.getAllNPCs()) {
                        if (!(npc instanceof EnforcerPatrol)) continue;
                        Main.game.banishNPC(npc);
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.9")) {
                    for (NPC npc : Main.game.getAllNPCs()) {
                        if (!(npc instanceof RatWarrensCaptive)) continue;
                        npc.setAffection(Main.game.getNpc(Murk.class), 100.0f);
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.9.1") && (Main.game.getPlayer().hasQuestInLine(QuestLine.SIDE_VENGAR, Quest.VENGAR_THREE_END) || Main.game.getPlayer().hasQuestInLine(QuestLine.SIDE_VENGAR, Quest.VENGAR_THREE_COOPERATION_END))) {
                    RatWarrensDialogue.applyRatWarrensRaid();
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.9.3")) {
                    for (NPC npc : Main.game.getAllNPCs()) {
                        if (npc instanceof DominionAlleywayAttacker && ((DominionAlleywayAttacker)npc).isStormAttacker()) {
                            Main.game.banishNPC(npc);
                        }
                        if (npc.getSubspecies() != Subspecies.IMP && npc.getSubspecies() != Subspecies.IMP_ALPHA) continue;
                        npc.setSubspeciesOverride(npc.getSubspecies());
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.14")) {
                    Main.game.getPlayer().removeQuest(QuestLine.RELATIONSHIP_NYAN_HELP);
                    Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanIntroduced, false);
                    Main.game.getDialogueFlags().setFlag(DialogueFlagValue.supplierDepotDoorUnlocked, false);
                    Main.game.getDialogueFlags().setFlag(DialogueFlagValue.suppliersEncountered, false);
                    Main.game.getPlayer().getCharactersEncountered().remove(Main.game.getNpc(Nyan.class).getId());
                    Main.game.getPlayer().getCharactersEncountered().remove(Main.game.getNpc(SupplierPartner.class).getId());
                    Main.game.getPlayer().getCharactersEncountered().remove(Main.game.getNpc(SupplierLeader.class).getId());
                    Main.game.getNpc(SupplierLeader.class).setPlayerKnowsName(false);
                    Main.game.getNpc(SupplierPartner.class).setPlayerKnowsName(false);
                    Main.game.getNpc(Nyan.class).clearAffectionMap();
                    if (Main.game.getNpc(Nyan.class).isPregnant()) {
                        Main.game.getNpc(Nyan.class).endPregnancy(false);
                    }
                    Main.game.getNpc(Nyan.class).setStartingBody(true);
                    Main.game.getNpc(Nyan.class).equipClothing(EquipClothingSetting.getAllClothingSettings());
                    Main.game.getNpc(Nyan.class).getSexCountMap().clear();
                    Main.game.getPlayer().getSexCountMap().put(Main.game.getNpc(Nyan.class).getId(), new SexCount());
                    Main.game.getNpc(SupplierLeader.class).clearAffectionMap();
                    Main.game.getNpc(SupplierLeader.class).setStartingBody(true);
                    if (Main.game.getNpc(SupplierLeader.class).isPregnant()) {
                        Main.game.getNpc(SupplierLeader.class).endPregnancy(false);
                    }
                    Main.game.getNpc(SupplierLeader.class).equipClothing(EquipClothingSetting.getAllClothingSettings());
                    Main.game.getNpc(SupplierLeader.class).getSexCountMap().clear();
                    Main.game.getPlayer().getSexCountMap().put(Main.game.getNpc(SupplierLeader.class).getId(), new SexCount());
                    Main.game.getNpc(SupplierLeader.class).setLocation(WorldType.TEXTILES_WAREHOUSE, PlaceType.TEXTILE_WAREHOUSE_OVERSEER_STATION, true);
                    Main.game.getNpc(SupplierPartner.class).clearAffectionMap();
                    Main.game.getNpc(SupplierPartner.class).setStartingBody(true);
                    if (Main.game.getNpc(SupplierPartner.class).isPregnant()) {
                        Main.game.getNpc(SupplierPartner.class).endPregnancy(false);
                    }
                    Main.game.getNpc(SupplierPartner.class).equipClothing(EquipClothingSetting.getAllClothingSettings());
                    Main.game.getNpc(SupplierPartner.class).getSexCountMap().clear();
                    Main.game.getPlayer().getSexCountMap().put(Main.game.getNpc(SupplierPartner.class).getId(), new SexCount());
                    Main.game.getNpc(SupplierPartner.class).setLocation(WorldType.TEXTILES_WAREHOUSE, PlaceType.TEXTILE_WAREHOUSE_OVERSEER_STATION, true);
                    Main.game.getNpc(SupplierLeader.class).setAffection(Main.game.getNpc(SupplierPartner.class), (float)AffectionLevel.POSITIVE_ONE_FRIENDLY.getMedianValue());
                    Main.game.getNpc(SupplierPartner.class).setAffection(Main.game.getNpc(SupplierLeader.class), (float)AffectionLevel.POSITIVE_ONE_FRIENDLY.getMedianValue());
                    if (Main.game.getPlayer().getWorldLocation() == WorldType.TEXTILES_WAREHOUSE) {
                        Main.game.getPlayer().setLocation(WorldType.SHOPPING_ARCADE, PlaceType.SHOPPING_ARCADE_ENTRANCE);
                    }
                    Main.game.getPlayer().getWorldsVisited().remove(WorldType.TEXTILES_WAREHOUSE);
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.15")) {
                    Main.game.getNpc(Nyan.class).setAffection(Main.game.getNpc(Ashley.class), (float)AffectionLevel.POSITIVE_TWO_LIKE.getMedianValue());
                    Main.game.getNpc(Ashley.class).setAffection(Main.game.getNpc(Nyan.class), (float)AffectionLevel.POSITIVE_ONE_FRIENDLY.getMedianValue());
                }
                NPC lyssieth = Main.game.getNpc(Lyssieth.class);
                if (Main.isVersionOlderThan(loadingVersion, "0.3.17") && Main.game.getPlayer().getTrueRace() == Race.DEMON && lyssieth.getAffection(Main.game.getPlayer()) < 75.0f) {
                    lyssieth.setAffection(Main.game.getPlayer(), 75.0f);
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.3.17")) {
                    for (NPC npc : Main.game.getAllNPCs()) {
                        if (!(npc instanceof EnforcerPatrol)) continue;
                        npc.setHomeLocation(WorldType.ENFORCER_HQ, PlaceType.ENFORCER_HQ_CELLS_OFFICE);
                    }
                    Main.game.getNpc(Wes.class).setLocation(WorldType.ENFORCER_HQ, PlaceType.ENFORCER_HQ_REQUISITIONS, true);
                    Main.game.getNpc(Elle.class).setLocation(WorldType.ENFORCER_HQ, PlaceType.ENFORCER_HQ_REQUISITIONS, true);
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.0.5")) {
                    Main.game.getPlayer().getSexCountMap().remove(Main.game.getNpc(DarkSiren.class).getId());
                    Main.game.getNpc(Lilaya.class).getSexCountMap().remove(Main.game.getNpc(DarkSiren.class).getId());
                    Main.game.getNpc(Lyssieth.class).getSexCountMap().remove(Main.game.getNpc(DarkSiren.class).getId());
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.1.5") && Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_1_B_DEMON_HOME)) {
                    Main.game.getNpc(Felicia.class).setPlayerKnowsName(true);
                    Main.game.getPlayer().addCharacterEncountered(Main.game.getNpc(Felicia.class));
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.1.5")) {
                    for (NPC npc : Main.game.getAllNPCs()) {
                        if (!(npc instanceof FieldsBandit) || npc.isSlave() || Main.game.getPlayer().getFriendlyOccupants().contains(npc.getId())) continue;
                        Main.game.banishNPC(npc);
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.2.1")) {
                    for (NPC npc : Main.game.getAllNPCs()) {
                        if (!npc.isUnique()) continue;
                        npc.setBirthday(npc.getBirthday().plusYears(3L));
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.2.2")) {
                    Main.game.getNpc(Ashley.class).clearAffectionMap();
                    Main.game.getNpc(Ashley.class).setAffection(Main.game.getNpc(Nyan.class), (float)AffectionLevel.POSITIVE_ONE_FRIENDLY.getMedianValue());
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.3.1")) {
                    Vector2i vec4 = new Vector2i(2, 18);
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell(vec4).getPlace().setPlaceType(PlaceType.DOMINION_CALLIE_BAKERY);
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell(vec4).getPlace().setName(PlaceType.DOMINION_CALLIE_BAKERY.getName());
                }
                Main.game.pendingSlaveInStocksReset = false;
                if (Main.isVersionOlderThan(loadingVersion, "0.4.4.2")) {
                    Main.game.getPlayer().resetPerksMap(false);
                    if (!Main.game.getPlayer().hasPerkAnywhereInTree(Perk.SPECIAL_PLAYER)) {
                        Main.game.getPlayer().addSpecialPerk(Perk.SPECIAL_PLAYER);
                    }
                    for (NPC npc : Main.game.getAllNPCs()) {
                        if (!npc.isElemental()) {
                            npc.resetPerksMap(true, false);
                        }
                        PerkManager.initialiseSpecialPerksUponCreation(npc);
                    }
                    if (Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_1_I_ARTHURS_TALE)) {
                        if (!Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCells(PlaceUpgrade.LILAYA_ARTHUR_ROOM).isEmpty()) {
                            arthurRoom = Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCells(PlaceUpgrade.LILAYA_ARTHUR_ROOM).get(0);
                            arthurRoom.removePlaceUpgrade(PlaceUpgrade.LILAYA_ARTHUR_ROOM);
                            if (arthurRoom.getLocation().getX() > 2 && arthurRoom.getLocation().getX() < 8 && arthurRoom.getLocation().getY() > 2 && arthurRoom.getLocation().getY() < 8) {
                                arthurRoom.getPlace().setPlaceType(PlaceType.LILAYA_HOME_ROOM_GARDEN_GROUND_FLOOR);
                            } else {
                                arthurRoom.getPlace().setPlaceType(PlaceType.LILAYA_HOME_ROOM_WINDOW_GROUND_FLOOR);
                            }
                        } else if (!Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_FIRST_FLOOR).getCells(PlaceUpgrade.LILAYA_ARTHUR_ROOM).isEmpty()) {
                            arthurRoom = Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_FIRST_FLOOR).getCells(PlaceUpgrade.LILAYA_ARTHUR_ROOM).get(0);
                            arthurRoom.removePlaceUpgrade(PlaceUpgrade.LILAYA_ARTHUR_ROOM);
                            if (arthurRoom.getLocation().getX() > 2 && arthurRoom.getLocation().getX() < 8 && arthurRoom.getLocation().getY() > 2 && arthurRoom.getLocation().getY() < 8) {
                                arthurRoom.getPlace().setPlaceType(PlaceType.LILAYA_HOME_ROOM_GARDEN_FIRST_FLOOR);
                            } else {
                                arthurRoom.getPlace().setPlaceType(PlaceType.LILAYA_HOME_ROOM_WINDOW_FIRST_FLOOR);
                            }
                        }
                        Cell c2 = Lab.addArthurRoom();
                        Main.game.getNpc(Arthur.class).setLocation(c2, true);
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.4.3") && Main.game.getPlayer().hasPerkAnywhereInTree(Perk.POWER_OF_LYSSIETH_4) && Main.game.getPlayer().getTrueRace() == Race.DEMON) {
                    Main.game.getPlayer().removeSpecialPerk(Perk.POWER_OF_LYSSIETH_4);
                    Main.game.getPlayer().addSpecialPerk(Perk.POWER_OF_LYSSIETH_4_DEMON);
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.5.7")) {
                    if (Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_3_E_THEMISCYRA_ATTACK)) {
                        Main.game.getNpc(Ursa.class).setLocation("innoxia_fields_elis_amazon_camp", "innoxia_fields_elis_amazon_camp_queen", true);
                        Main.game.getNpc(Aurokaris.class).setLocation("innoxia_fields_elis_amazon_camp", "innoxia_fields_elis_amazon_camp_aurokaris", true);
                        Main.game.getNpc(Lunexis.class).setLocation("innoxia_fields_elis_amazon_camp", "innoxia_fields_elis_amazon_camp_lunexis", true);
                    }
                    for (NPC npc : Main.game.getAllNPCs()) {
                        if (!(npc instanceof DominionClubNPC)) continue;
                        if (!npc.getHomeLocationPlace().getPlaceType().equals(PlaceType.DOMINION_BOULEVARD)) {
                            npc.setHomeLocation(WorldType.EMPTY, PlaceType.GENERIC_CLUB_HOLDING_CELL);
                        }
                        if (npc.getWorldLocation() != WorldType.EMPTY) continue;
                        npc.returnToHome();
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.6.1") && Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_SLIME_QUEEN)) {
                    Main.game.getPlayer().addItem(Main.game.getItemGen().generateItem("dsg_quest_hazmat_rat_card"), false);
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.6.6") && Main.game.getPlayer().getTrueRace() == Race.DEMON) {
                    Main.game.getDialogueFlags().setFlag("innoxia_child_of_lyssieth", true);
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.7.2")) {
                    Main.game.getNpc(Lunexis.class).setAffection(Main.game.getPlayer(), -100.0f);
                    Main.game.getNpc(Lunexis.class).setAffection(Main.game.getNpc(DarkSiren.class), -100.0f);
                    Main.game.getNpc(Lunexis.class).setAffection(Main.game.getNpc(Aurokaris.class), -100.0f);
                    Main.game.getNpc(Lunexis.class).setAffection(Main.game.getNpc(Ursa.class), -100.0f);
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.7.9")) {
                    Main.game.getNpc(Pix.class).setLocation(WorldType.getWorldTypeFromId("innoxia_dominion_shopping_arcade_gym"), PlaceType.getPlaceTypeFromId("innoxia_dominion_shopping_arcade_gym_reception"), true);
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.7.11")) {
                    if (Main.game.getPlayer().getWorldLocation() == WorldType.getWorldTypeFromId("innoxia_fields_elis_tavern_taur")) {
                        Main.game.getPlayer().setLocation(WorldType.getWorldTypeFromId("innoxia_fields_elis_town"), PlaceType.getPlaceTypeFromId("innoxia_fields_elis_town_tavern_taur"), false);
                    }
                    Main.game.getNpc(Kheiron.class).setLocation(WorldType.getWorldTypeFromId("innoxia_fields_elis_tavern_taur"), PlaceType.getPlaceTypeFromId("innoxia_fields_elis_tavern_taur_bar"), true);
                    if (Main.game.getNpc(Fae.class).getWorldLocation() == WorldType.getWorldTypeFromId("innoxia_fields_elis_tavern_taur")) {
                        Main.game.getNpc(Fae.class).setRandomLocation(WorldType.getWorldTypeFromId("innoxia_fields_elis_tavern_taur"), PlaceType.getPlaceTypeFromId("innoxia_fields_elis_tavern_taur_seating"), false);
                        Main.game.getNpc(Silvia.class).setLocation(Main.game.getNpc(Fae.class));
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.8.10")) {
                    List<NPC> charactersInStable = Main.game.getCharactersPresent(WorldType.getWorldTypeFromId("innoxia_fields_elis_tavern_taur"), PlaceType.getPlaceTypeFromId("innoxia_fields_elis_tavern_taur_stable"));
                    boolean steropePresent = charactersInStable.contains(Main.game.getNpc(Sterope.class));
                    int charactersToBanish = charactersInStable.size() - (steropePresent ? 2 : 0);
                    for (GameCharacter gameCharacter : charactersInStable) {
                        if (charactersToBanish <= 0) break;
                        if (!(gameCharacter instanceof GenericSexualPartner)) continue;
                        Main.game.banishNPC((NPC)gameCharacter);
                        --charactersToBanish;
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.9") && Main.game.getWorlds().get(WorldType.DOMINION).getCell(PlaceType.DOMINION_DEMON_HOME_SEX_SHOP) == null) {
                    Vector2i towerLoc = new Vector2i(Main.game.getWorlds().get(WorldType.DOMINION).getCell(PlaceType.DOMINION_LILITHS_TOWER).getLocation());
                    towerLoc.setX(towerLoc.getX() + 2);
                    Main.game.getWorlds().get(WorldType.DOMINION).getCell(towerLoc).setPlace(new GenericPlace(PlaceType.DOMINION_DEMON_HOME_SEX_SHOP), false);
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.9.2")) {
                    for (NPC npc : Main.game.getAllNPCs()) {
                        if (!(npc instanceof Elemental)) continue;
                        npc.setAgeAppearanceAbsolute(((Elemental)npc).getSummoner().getAppearsAsAgeValue());
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.9.8")) {
                    for (NPC npc : Main.game.getAllNPCs()) {
                        if (!npc.isDoll()) continue;
                        npc.getBody().getBreast().setMilk(new FluidMilk(FluidType.MILK_DOLL, false));
                        npc.getBody().getBreastCrotch().setMilk(new FluidMilk(FluidType.MILK_DOLL, true));
                        npc.getBody().getPenis().getTesticle().setCum(new FluidCum(FluidType.CUM_DOLL));
                        npc.getBody().getVagina().setGirlcum(new FluidGirlCum(FluidType.GIRL_CUM_DOLL));
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.9.9")) {
                    int count = Main.game.getPlayer().getItemCount(ItemType.DOLL_CONSOLE);
                    for (int i9 = 0; i9 < count - 1; ++i9) {
                        Main.game.getPlayer().removeItemByType(ItemType.DOLL_CONSOLE);
                        Main.game.getPlayer().incrementMoney(MiscDialogue.deckCost);
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.9.10")) {
                    for (NPC npc : Main.game.getAllNPCs()) {
                        if (npc.isSlave()) continue;
                        for (int i10 = 0; i10 < 24; ++i10) {
                            if (npc.getSlaveJob(i10).hasFlag(SlaveJobFlag.GUEST_CAN_WORK)) continue;
                            npc.setSlaveJob(i10, SlaveJob.IDLE);
                        }
                    }
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.9.11") && Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_2_C_SIRENS_FALL)) {
                    ImpFortressDialogue.clearFortress(WorldType.IMP_FORTRESS_ALPHA);
                    ImpFortressDialogue.clearFortress(WorldType.IMP_FORTRESS_FEMALES);
                    ImpFortressDialogue.clearFortress(WorldType.IMP_FORTRESS_MALES);
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.10.8")) {
                    Main.game.getDialogueFlags().setFlag(DialogueFlagValue.dressingRoomAutoClean, true);
                }
                if (!(!Main.isVersionOlderThan(loadingVersion, "0.4.10.10") || Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCells(PlaceUpgrade.LILAYA_DRESSING_ROOM_LYSSIETH_WARDROBE).isEmpty() && Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_FIRST_FLOOR).getCells(PlaceUpgrade.LILAYA_DRESSING_ROOM_LYSSIETH_WARDROBE).isEmpty())) {
                    Main.game.getDialogueFlags().setFlag(DialogueFlagValue.dressingRoomLyssiethsWardrobeActivated, true);
                }
                if (Main.isVersionOlderThan(loadingVersion, "0.4.11.3")) {
                    for (NPC npc : Main.game.getAllNPCs()) {
                        if (!(npc instanceof SlaveForSale) || npc.isSlave() || Main.game.getPlayer().getFriendlyOccupants().contains(npc.getId()) || npc.getLocationPlaceType() != PlaceType.SLAVER_ALLEY_CAFE && npc.getLocationPlaceType() != PlaceType.SLAVER_ALLEY_CAFE_2 && npc.getLocationPlaceType() != PlaceType.SLAVER_ALLEY_CAFE_3 && npc.getLocationPlaceType() != PlaceType.SLAVER_ALLEY_CAFE_4) continue;
                        Main.game.getNpc(Finch.class).addSlave(npc);
                    }
                }
                if (debug) {
                    System.out.println("New NPCs finished");
                    System.out.println("All finished");
                    System.out.println((double)(System.nanoTime() - time) / 1.0E9);
                }
            }
            catch (Exception e7) {
                e7.printStackTrace();
            }
        }
        if (Main.game.getNpc(GenericAndrogynousNPC.class) == null) {
            try {
                Main.game.addNPC(new GenericAndrogynousNPC(), false);
            }
            catch (Exception e8) {
                e8.printStackTrace();
            }
        }
        Main.game.getPlayer().updateLocationListeners();
        Main.game.setRenderMap(true);
        Main.game.setRenderAttributesSection(true);
        Main.game.setRequestAutosave(false);
        DialogueNode startingDialogueNode = Main.game.getPlayerCell().getDialogue(false);
        Main.game.addEvent(new EventLogEntry("[style.colourGood(\u8bfb\u6863\u6210\u529f)]", "data/saves/" + Util.getFileName(file) + ".xml"), false);
        Main.game.setStarted(true);
        Main.game.setContent(new Response("", startingDialogueNode.getDescription(), startingDialogueNode), false);
        Main.game.occupancyUtil.updateSlavesResting(Main.game.getHourOfDay());
        Main.game.endTurn(0);
        for (NPC npc : Main.game.getAllNPCs()) {
            npc.updateInventoryListeners();
            npc.updateAttributeListeners(true);
            npc.calculateStatusEffects(0);
        }
        Main.game.getPlayer().updateInventoryListeners();
        Main.game.getPlayer().updateAttributeListeners(true);
        Main.game.getPlayer().calculateStatusEffects(0);
        Main.getProperties().addAllDiscoveredFromCurrentPlayer();
        Main.saveProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NPC loadNPC(Document doc, Element e, String className, Map<String, Class<? extends NPC>> classMap, Map<Class<? extends NPC>, Method> loadFromXMLMethodMap, Map<Class<? extends NPC>, Constructor<? extends NPC>> constructorMap) {
        try {
            Constructor<? extends NPC> declaredConstructor;
            GenericDeclaration m;
            Class<NPC> npcClass = classMap.get(className);
            if (npcClass == null) {
                Class<NPC> clazz = npcClass = Class.forName(className);
                synchronized (clazz) {
                    if (classMap.containsKey(className)) {
                        npcClass = classMap.get(className);
                    } else {
                        classMap.putIfAbsent(className, npcClass);
                        m = npcClass.getMethod("loadFromXML", Element.class, Document.class, CharacterImportSetting[].class);
                        loadFromXMLMethodMap.put((Class<? extends NPC>)npcClass, (Method)m);
                        Constructor<NPC> declaredConstructor2 = npcClass.getDeclaredConstructor(Boolean.TYPE);
                        constructorMap.put(npcClass, declaredConstructor2);
                    }
                }
            }
            if ((declaredConstructor = constructorMap.get(npcClass)) == null) {
                m = npcClass;
                synchronized (m) {
                    declaredConstructor = constructorMap.get(npcClass);
                }
            }
            NPC npc = declaredConstructor.newInstance(true);
            loadFromXMLMethodMap.get(npcClass).invoke((Object)npc, new Object[]{e, doc, new CharacterImportSetting[0]});
            return npc;
        }
        catch (NoSuchMethodException nsme) {
            System.err.println("Couldn't find required method(loadFromXML or constructor(boolean)) for class: " + className);
            nsme.printStackTrace();
            return null;
        }
        catch (Exception ex) {
            System.err.println("Failed to load NPC class: " + className);
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element element = doc.createElement("game");
        parentElement.appendChild(element);
        return element;
    }

    public static Game loadFromXML(Element parentElement, Document doc) {
        Game loadedGame = new Game();
        return loadedGame;
    }

    public void initNewGame(DialogueNode startingDialogueNode) {
        this.NPCMap.clear();
        this.OffspringSeedMap.clear();
        this.initUniqueNPCs();
        Main.game.getActiveWorld().getCell(0, 0).setDiscovered(false);
        Main.game.getActiveWorld().getCell(0, 1).setDiscovered(false);
        Main.game.getActiveWorld().getCell(1, 0).setDiscovered(false);
        this.setStarted(false);
        SlaverAlleyDialogue.dailyReset();
        UtilText.initScriptEngine();
        this.setStarted(true);
        this.setContent(new Response(startingDialogueNode.getLabel(), startingDialogueNode.getDescription(), startingDialogueNode));
    }

    private void handlePostGameInit() {
        UtilText.initScriptEngine();
        Main.game.getDialogueFlags().resetTemporaryVariables();
        for (NPC npc : this.getAllNPCs()) {
            npc.getBody().calculateRace(npc);
        }
        this.player.getBody().calculateRace(this.player);
        if (this.getCurrentDialogueNode() != null) {
            MainController.updateUI();
        }
    }

    private void initUniqueNPCs() {
        try {
            ArrayList<Class> addedNpcs = new ArrayList<Class>();
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(GenericMaleNPC.class))) {
                this.addNPC(new GenericMaleNPC(), false);
                addedNpcs.add(GenericMaleNPC.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(GenericFemaleNPC.class))) {
                this.addNPC(new GenericFemaleNPC(), false);
                addedNpcs.add(GenericFemaleNPC.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(GenericAndrogynousNPC.class))) {
                this.addNPC(new GenericAndrogynousNPC(), false);
                addedNpcs.add(GenericAndrogynousNPC.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(PrologueMale.class))) {
                this.addNPC(new PrologueMale(), false);
                addedNpcs.add(PrologueMale.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(PrologueFemale.class))) {
                this.addNPC(new PrologueFemale(), false);
                addedNpcs.add(PrologueFemale.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(GenericTrader.class))) {
                this.addNPC(new GenericTrader(), false);
                addedNpcs.add(GenericTrader.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(TestNPC.class))) {
                this.addNPC(new TestNPC(), false);
                addedNpcs.add(TestNPC.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Lumi.class))) {
                this.addNPC(new Lumi(), false);
                addedNpcs.add(Lumi.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Pazu.class))) {
                this.addNPC(new Pazu(), false);
                addedNpcs.add(Pazu.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Ashley.class))) {
                this.addNPC(new Ashley(), false);
                addedNpcs.add(Ashley.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Callie.class))) {
                this.addNPC(new Callie(), false);
                addedNpcs.add(Callie.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Rose.class))) {
                this.addNPC(new Rose(), false);
                addedNpcs.add(Rose.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Lilaya.class))) {
                this.addNPC(new Lilaya(), false);
                addedNpcs.add(Lilaya.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Arthur.class))) {
                this.addNPC(new Arthur(), false);
                addedNpcs.add(Arthur.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Lyssieth.class))) {
                this.addNPC(new Lyssieth(), false);
                addedNpcs.add(Lyssieth.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Elizabeth.class))) {
                this.addNPC(new Elizabeth(), false);
                addedNpcs.add(Elizabeth.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Takahashi.class))) {
                this.addNPC(new Takahashi(), false);
                addedNpcs.add(Takahashi.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(DarkSiren.class))) {
                this.addNPC(new DarkSiren(), false);
                addedNpcs.add(DarkSiren.class);
            }
            if (addedNpcs.contains(Lilaya.class)) {
                this.getNpc(Lilaya.class).setAffection(Main.game.getPlayer(), (float)AffectionLevel.POSITIVE_ONE_FRIENDLY.getMedianValue());
                this.getNpc(Lilaya.class).setAffection(this.getNpc(Rose.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
                this.getNpc(Lilaya.class).addSlave(this.getNpc(Rose.class));
                this.getNpc(Lilaya.class).setAffection(this.getNpc(Lyssieth.class), -60.0f);
                this.getNpc(Lilaya.class).setAffection(this.getNpc(DarkSiren.class), 15.0f);
                this.getNpc(Lilaya.class).setMother(this.getNpc(Lyssieth.class));
            }
            if (addedNpcs.contains(Rose.class)) {
                this.getNpc(Rose.class).setAffection(Main.game.getPlayer(), (float)AffectionLevel.POSITIVE_ONE_FRIENDLY.getMedianValue());
                this.getNpc(Rose.class).setAffection(this.getNpc(Lilaya.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
                this.getNpc(Rose.class).setObedience(ObedienceLevel.POSITIVE_FIVE_SUBSERVIENT.getMedianValue());
                this.getNpc(Rose.class).setAffection(this.getNpc(Lyssieth.class), -40.0f);
            }
            if (addedNpcs.contains(DarkSiren.class)) {
                this.getNpc(DarkSiren.class).setAffection(this.getNpc(Lyssieth.class), -25.0f);
                this.getNpc(DarkSiren.class).setAffection(this.getNpc(Lilaya.class), 35.0f);
                this.getNpc(DarkSiren.class).setMother(this.getNpc(Lyssieth.class));
            }
            if (addedNpcs.contains(Elizabeth.class)) {
                this.getNpc(Elizabeth.class).setMother(this.getNpc(Lyssieth.class));
                this.getNpc(Elizabeth.class).setAffection(this.getNpc(Lyssieth.class), 100.0f);
            }
            if (addedNpcs.contains(Lyssieth.class)) {
                this.getNpc(Lyssieth.class).setAffection(this.getNpc(Lilaya.class), 100.0f);
                this.getNpc(Lyssieth.class).setAffection(this.getNpc(DarkSiren.class), 50.0f);
                this.getNpc(Lyssieth.class).setAffection(this.getNpc(Elizabeth.class), 75.0f);
                this.getNpc(Lyssieth.class).setAffection(this.getNpc(Rose.class), -80.0f);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Brax.class))) {
                this.addNPC(new Brax(), false);
                addedNpcs.add(Brax.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(CandiReceptionist.class))) {
                this.addNPC(new CandiReceptionist(), false);
                addedNpcs.add(CandiReceptionist.class);
            }
            if (addedNpcs.contains(Brax.class)) {
                this.getNpc(Brax.class).setAffection(this.getNpc(CandiReceptionist.class), (float)AffectionLevel.POSITIVE_TWO_LIKE.getMedianValue());
            }
            if (addedNpcs.contains(CandiReceptionist.class)) {
                this.getNpc(CandiReceptionist.class).setAffection(this.getNpc(Brax.class), (float)AffectionLevel.POSITIVE_TWO_LIKE.getMedianValue());
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Wes.class))) {
                this.addNPC(new Wes(), false);
                addedNpcs.add(Wes.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Elle.class))) {
                this.addNPC(new Elle(), false);
                addedNpcs.add(Elle.class);
            }
            if (addedNpcs.contains(Wes.class)) {
                this.getNpc(Wes.class).setAffection(this.getNpc(Elle.class), (float)AffectionLevel.NEGATIVE_THREE_STRONG_DISLIKE.getMedianValue());
            }
            if (addedNpcs.contains(Elle.class)) {
                this.getNpc(Elle.class).setAffection(this.getNpc(Wes.class), (float)AffectionLevel.NEGATIVE_ONE_ANNOYED.getMedianValue());
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Ralph.class))) {
                this.addNPC(new Ralph(), false);
                addedNpcs.add(Ralph.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Nyan.class))) {
                this.addNPC(new Nyan(), false);
                addedNpcs.add(Nyan.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(NyanMum.class))) {
                this.addNPC(new NyanMum(), false);
                addedNpcs.add(NyanMum.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Vicky.class))) {
                this.addNPC(new Vicky(), false);
                addedNpcs.add(Vicky.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Pix.class))) {
                this.addNPC(new Pix(), false);
                addedNpcs.add(Pix.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Hannah.class))) {
                this.addNPC(new Hannah(), false);
                addedNpcs.add(Hannah.class);
            }
            if (addedNpcs.contains(Pix.class) || addedNpcs.contains(Hannah.class)) {
                Main.game.getNpc(Pix.class).setAffection(Main.game.getNpc(Hannah.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
                Main.game.getNpc(Hannah.class).setAffection(Main.game.getNpc(Pix.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Kate.class))) {
                this.addNPC(new Kate(), false);
                addedNpcs.add(Kate.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(SupplierLeader.class))) {
                this.addNPC(new SupplierLeader(), false);
                addedNpcs.add(SupplierLeader.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(SupplierPartner.class))) {
                this.addNPC(new SupplierPartner(), false);
                addedNpcs.add(SupplierPartner.class);
            }
            if (addedNpcs.contains(Nyan.class) || addedNpcs.contains(NyanMum.class)) {
                Main.game.getNpc(Nyan.class).setAffection(Main.game.getNpc(NyanMum.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
                Main.game.getNpc(NyanMum.class).setAffection(Main.game.getNpc(Nyan.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
                Main.game.getNpc(Nyan.class).setAffection(Main.game.getNpc(Ashley.class), (float)AffectionLevel.POSITIVE_TWO_LIKE.getMedianValue());
                Main.game.getNpc(Ashley.class).setAffection(Main.game.getNpc(Nyan.class), (float)AffectionLevel.POSITIVE_ONE_FRIENDLY.getMedianValue());
            }
            if (addedNpcs.contains(SupplierLeader.class)) {
                Main.game.getNpc(SupplierLeader.class).setAffection(Main.game.getNpc(SupplierPartner.class), (float)AffectionLevel.POSITIVE_TWO_LIKE.getMedianValue());
                Main.game.getNpc(SupplierPartner.class).setAffection(Main.game.getNpc(SupplierLeader.class), (float)AffectionLevel.POSITIVE_TWO_LIKE.getMedianValue());
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Kay.class))) {
                this.addNPC(new Kay(), false);
                addedNpcs.add(Kay.class);
            }
            if (addedNpcs.contains(Kay.class)) {
                Main.game.getNpc(Nyan.class).setAffection(Main.game.getNpc(Kay.class), (float)AffectionLevel.POSITIVE_ONE_FRIENDLY.getMedianValue());
                Main.game.getNpc(Kay.class).setAffection(Main.game.getNpc(Nyan.class), (float)AffectionLevel.POSITIVE_ONE_FRIENDLY.getMedianValue());
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Scarlett.class))) {
                this.addNPC(new Scarlett(), false);
                addedNpcs.add(Scarlett.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Helena.class))) {
                this.addNPC(new Helena(), false);
                addedNpcs.add(Helena.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(HarpyBimbo.class))) {
                this.addNPC(new HarpyBimbo(), false);
                addedNpcs.add(HarpyBimbo.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(HarpyBimboCompanion.class))) {
                this.addNPC(new HarpyBimboCompanion(), false);
                addedNpcs.add(HarpyBimboCompanion.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(HarpyDominant.class))) {
                this.addNPC(new HarpyDominant(), false);
                addedNpcs.add(HarpyDominant.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(HarpyDominantCompanion.class))) {
                this.addNPC(new HarpyDominantCompanion(), false);
                addedNpcs.add(HarpyDominantCompanion.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(HarpyNympho.class))) {
                this.addNPC(new HarpyNympho(), false);
                addedNpcs.add(HarpyNympho.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(HarpyNymphoCompanion.class))) {
                this.addNPC(new HarpyNymphoCompanion(), false);
                addedNpcs.add(HarpyNymphoCompanion.class);
            }
            if (addedNpcs.contains(Scarlett.class)) {
                Main.game.getNpc(Scarlett.class).setAffection(Main.game.getPlayer(), (float)AffectionLevel.NEGATIVE_TWO_DISLIKE.getMedianValue());
                Main.game.getNpc(Scarlett.class).setAffection(Main.game.getNpc(Helena.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
                if (Main.game.getPlayer().hasQuest(QuestLine.MAIN) && Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_1_F_SCARLETTS_FATE)) {
                    Main.game.getNpc(Scarlett.class).setLocation(WorldType.HARPY_NEST, PlaceType.HARPY_NESTS_HELENAS_NEST);
                }
            }
            if (addedNpcs.contains(Helena.class)) {
                Main.game.getNpc(Helena.class).setAffection(Main.game.getNpc(Scarlett.class), (float)AffectionLevel.NEGATIVE_FOUR_HATE.getMedianValue());
            }
            if (addedNpcs.contains(HarpyBimbo.class)) {
                Main.game.getNpc(HarpyBimbo.class).setAffection(Main.game.getNpc(HarpyBimboCompanion.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
            }
            if (addedNpcs.contains(HarpyBimboCompanion.class)) {
                Main.game.getNpc(HarpyBimboCompanion.class).setAffection(Main.game.getNpc(HarpyBimbo.class), (float)AffectionLevel.POSITIVE_FIVE_WORSHIP.getMedianValue());
            }
            if (addedNpcs.contains(HarpyDominant.class)) {
                Main.game.getNpc(HarpyDominant.class).setAffection(Main.game.getNpc(HarpyDominantCompanion.class), (float)AffectionLevel.POSITIVE_ONE_FRIENDLY.getMedianValue());
            }
            if (addedNpcs.contains(HarpyDominantCompanion.class)) {
                Main.game.getNpc(HarpyDominantCompanion.class).setAffection(Main.game.getNpc(HarpyDominant.class), (float)AffectionLevel.POSITIVE_FIVE_WORSHIP.getMedianValue());
            }
            if (addedNpcs.contains(HarpyNympho.class)) {
                Main.game.getNpc(HarpyNympho.class).setAffection(Main.game.getNpc(HarpyNymphoCompanion.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
            }
            if (addedNpcs.contains(HarpyNymphoCompanion.class)) {
                Main.game.getNpc(HarpyNymphoCompanion.class).setAffection(Main.game.getNpc(HarpyNympho.class), (float)AffectionLevel.POSITIVE_FIVE_WORSHIP.getMedianValue());
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Vanessa.class))) {
                this.addNPC(new Vanessa(), false);
                addedNpcs.add(Vanessa.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Natalya.class))) {
                this.addNPC(new Natalya(), false);
                addedNpcs.add(Natalya.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Finch.class))) {
                this.addNPC(new Finch(), false);
                addedNpcs.add(Finch.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Sean.class))) {
                this.addNPC(new Sean(), false);
                addedNpcs.add(Sean.class);
            }
            if (addedNpcs.contains(Sean.class)) {
                this.getNpc(Brax.class).setPetName(Main.game.getNpc(Sean.class), Main.game.getNpc(Sean.class).getName(false));
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(RentalMommy.class))) {
                this.addNPC(new RentalMommy(), false);
                addedNpcs.add(RentalMommy.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Daddy.class))) {
                this.addNPC(new Daddy(), false);
                addedNpcs.add(Daddy.class);
            }
            if (addedNpcs.contains(Daddy.class)) {
                this.getNpc(Rose.class).setAffection(this.getNpc(Daddy.class), -50.0f);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Felicia.class))) {
                this.addNPC(new Felicia(), false);
                addedNpcs.add(Felicia.class);
            }
            if (addedNpcs.contains(Felicia.class)) {
                this.getNpc(Felicia.class).setAffection(this.getNpc(Arthur.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Saellatrix.class))) {
                this.addNPC(new Saellatrix(), false);
                addedNpcs.add(Saellatrix.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Fiammetta.class))) {
                this.addNPC(new Fiammetta(), false);
                addedNpcs.add(Fiammetta.class);
            }
            if (addedNpcs.contains(Fiammetta.class)) {
                this.getNpc(Fiammetta.class).setAffection(this.getNpc(Saellatrix.class), -100.0f);
                this.getNpc(Saellatrix.class).setAffection(this.getNpc(Fiammetta.class), -50.0f);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Zaranix.class))) {
                this.addNPC(new Zaranix(), false);
                addedNpcs.add(Zaranix.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Amber.class))) {
                this.addNPC(new Amber(), false);
                addedNpcs.add(Amber.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(ZaranixMaidKatherine.class))) {
                this.addNPC(new ZaranixMaidKatherine(), false);
                addedNpcs.add(ZaranixMaidKatherine.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(ZaranixMaidKelly.class))) {
                this.addNPC(new ZaranixMaidKelly(), false);
                addedNpcs.add(ZaranixMaidKelly.class);
            }
            if (addedNpcs.contains(Zaranix.class)) {
                Main.game.getNpc(Zaranix.class).setAffection(Main.game.getNpc(ZaranixMaidKatherine.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
                Main.game.getNpc(Zaranix.class).setAffection(Main.game.getNpc(ZaranixMaidKelly.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
                Main.game.getNpc(Zaranix.class).setAffection(Main.game.getNpc(Amber.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
            }
            if (addedNpcs.contains(Amber.class)) {
                Main.game.getNpc(Amber.class).setAffection(Main.game.getNpc(Zaranix.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
                Main.game.getNpc(Amber.class).setAffection(Main.game.getNpc(ZaranixMaidKelly.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
                Main.game.getNpc(Amber.class).setAffection(Main.game.getNpc(ZaranixMaidKatherine.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
            }
            if (addedNpcs.contains(ZaranixMaidKatherine.class)) {
                Main.game.getNpc(ZaranixMaidKatherine.class).setAffection(Main.game.getNpc(Zaranix.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
                Main.game.getNpc(ZaranixMaidKatherine.class).setAffection(Main.game.getNpc(ZaranixMaidKelly.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
                Main.game.getNpc(ZaranixMaidKatherine.class).setAffection(Main.game.getNpc(Amber.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
            }
            if (addedNpcs.contains(ZaranixMaidKelly.class)) {
                Main.game.getNpc(ZaranixMaidKelly.class).setAffection(Main.game.getNpc(Zaranix.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
                Main.game.getNpc(ZaranixMaidKelly.class).setAffection(Main.game.getNpc(ZaranixMaidKatherine.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
                Main.game.getNpc(ZaranixMaidKelly.class).setAffection(Main.game.getNpc(Amber.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Angel.class))) {
                this.addNPC(new Angel(), false);
                addedNpcs.add(Angel.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Bunny.class))) {
                this.addNPC(new Bunny(), false);
                addedNpcs.add(Bunny.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Loppy.class))) {
                this.addNPC(new Loppy(), false);
                addedNpcs.add(Loppy.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(SlimeQueen.class))) {
                this.addNPC(new SlimeQueen(), false);
                addedNpcs.add(SlimeQueen.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(SlimeGuardIce.class))) {
                this.addNPC(new SlimeGuardIce(), false);
                addedNpcs.add(SlimeGuardIce.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(SlimeGuardFire.class))) {
                this.addNPC(new SlimeGuardFire(), false);
                addedNpcs.add(SlimeGuardFire.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(SlimeRoyalGuard.class))) {
                this.addNPC(new SlimeRoyalGuard(), false);
                addedNpcs.add(SlimeRoyalGuard.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Claire.class))) {
                this.addNPC(new Claire(), false);
                addedNpcs.add(Claire.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(FortressAlphaLeader.class))) {
                this.addNPC(new FortressAlphaLeader(), false);
                addedNpcs.add(FortressAlphaLeader.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(FortressFemalesLeader.class))) {
                this.addNPC(new FortressFemalesLeader(), false);
                addedNpcs.add(FortressFemalesLeader.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(FortressMalesLeader.class))) {
                this.addNPC(new FortressMalesLeader(), false);
                addedNpcs.add(FortressMalesLeader.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Jules.class))) {
                this.addNPC(new Jules(), false);
                addedNpcs.add(Jules.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Kruger.class))) {
                this.addNPC(new Kruger(), false);
                addedNpcs.add(Kruger.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Kalahari.class))) {
                this.addNPC(new Kalahari(), false);
                addedNpcs.add(Kalahari.class);
            }
            if (addedNpcs.contains(Kalahari.class)) {
                Main.game.getNpc(Kalahari.class).setFather(Main.game.getNpc(Kruger.class));
                Main.game.getNpc(Kalahari.class).setAffection(Main.game.getNpc(Kruger.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
            }
            if (addedNpcs.contains(Kruger.class)) {
                Main.game.getNpc(Kruger.class).setAffection(Main.game.getNpc(Kalahari.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Roxy.class))) {
                this.addNPC(new Roxy(), false);
                addedNpcs.add(Roxy.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Axel.class))) {
                this.addNPC(new Axel(), false);
                addedNpcs.add(Axel.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Epona.class))) {
                this.addNPC(new Epona(), false);
                addedNpcs.add(Epona.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Vengar.class))) {
                this.addNPC(new Vengar(), false);
                addedNpcs.add(Vengar.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Shadow.class))) {
                this.addNPC(new Shadow(), false);
                addedNpcs.add(Shadow.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Silence.class))) {
                this.addNPC(new Silence(), false);
                addedNpcs.add(Silence.class);
            }
            if (addedNpcs.contains(Vengar.class)) {
                this.getNpc(Vengar.class).setAffection(this.getNpc(Shadow.class), 50.0f);
                this.getNpc(Vengar.class).setAffection(this.getNpc(Silence.class), 50.0f);
                this.getNpc(Shadow.class).setAffection(this.getNpc(Vengar.class), -10.0f);
                this.getNpc(Shadow.class).setAffection(this.getNpc(Silence.class), 80.0f);
                this.getNpc(Silence.class).setAffection(this.getNpc(Vengar.class), 20.0f);
                this.getNpc(Silence.class).setAffection(this.getNpc(Shadow.class), 100.0f);
            }
            if (Main.isVersionOlderThan(loadingVersion, "0.3.5.6")) {
                this.getNpc(Roxy.class).setAffection(this.getNpc(Vengar.class), -80.0f);
                this.getNpc(Vengar.class).setAffection(this.getNpc(Roxy.class), 50.0f);
            }
            if (Main.isVersionOlderThan(loadingVersion, "0.3.5.9")) {
                this.getNpc(Silence.class).setAffection(this.getNpc(Shadow.class), 100.0f);
                this.getNpc(Silence.class).getAffectionMap().remove(this.getNpc(Silence.class).getId());
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Murk.class))) {
                this.addNPC(new Murk(), false);
                addedNpcs.add(Murk.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(HazmatRat.class))) {
                this.addNPC(new HazmatRat(), false);
                addedNpcs.add(HazmatRat.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Flash.class))) {
                this.addNPC(new Flash(), false);
                addedNpcs.add(Flash.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Jess.class))) {
                this.addNPC(new Jess(), false);
                addedNpcs.add(Jess.class);
            }
            if (addedNpcs.contains(Flash.class) || addedNpcs.contains(Jess.class)) {
                Main.game.getNpc(Jess.class).setAffection(Main.game.getNpc(Flash.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
                Main.game.getNpc(Flash.class).setAffection(Main.game.getNpc(Jess.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Astrapi.class))) {
                this.addNPC(new Astrapi(), false);
                addedNpcs.add(Astrapi.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Vronti.class))) {
                this.addNPC(new Vronti(), false);
                addedNpcs.add(Vronti.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Kheiron.class))) {
                this.addNPC(new Kheiron(), false);
                addedNpcs.add(Kheiron.class);
            }
            if (addedNpcs.contains(Astrapi.class) || addedNpcs.contains(Vronti.class) || addedNpcs.contains(Kheiron.class)) {
                Main.game.getNpc(Astrapi.class).setAffection(Main.game.getNpc(Vronti.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
                Main.game.getNpc(Astrapi.class).setAffection(Main.game.getNpc(Kheiron.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
                Main.game.getNpc(Vronti.class).setAffection(Main.game.getNpc(Astrapi.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
                Main.game.getNpc(Vronti.class).setAffection(Main.game.getNpc(Kheiron.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
                Main.game.getNpc(Kheiron.class).setAffection(Main.game.getNpc(Astrapi.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
                Main.game.getNpc(Kheiron.class).setAffection(Main.game.getNpc(Vronti.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
                this.getNpc(Astrapi.class).setFather(this.getNpc(Kheiron.class));
                this.getNpc(Vronti.class).setFather(this.getNpc(Kheiron.class));
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Arion.class))) {
                this.addNPC(new Arion(), false);
                addedNpcs.add(Arion.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Minotallys.class))) {
                this.addNPC(new Minotallys(), false);
                addedNpcs.add(Minotallys.class);
            }
            if (addedNpcs.contains(Arion.class) || addedNpcs.contains(Minotallys.class)) {
                Main.game.getNpc(Arion.class).setAffection(Main.game.getNpc(Minotallys.class), (float)AffectionLevel.POSITIVE_FIVE_WORSHIP.getMedianValue());
                Main.game.getNpc(Minotallys.class).setAffection(Main.game.getNpc(Arion.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Fae.class))) {
                this.addNPC(new Fae(), false);
                addedNpcs.add(Fae.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Silvia.class))) {
                this.addNPC(new Silvia(), false);
                addedNpcs.add(Silvia.class);
            }
            if (addedNpcs.contains(Fae.class) || addedNpcs.contains(Silvia.class)) {
                Main.game.getNpc(Silvia.class).setAffection(Main.game.getNpc(Fae.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
                Main.game.getNpc(Fae.class).setAffection(Main.game.getNpc(Silvia.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Kazik.class))) {
                this.addNPC(new Kazik(), false);
                addedNpcs.add(Kazik.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Yui.class))) {
                this.addNPC(new Yui(), false);
                addedNpcs.add(Yui.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Nizhoni.class))) {
                this.addNPC(new Nizhoni(), false);
                addedNpcs.add(Nizhoni.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Moreno.class))) {
                this.addNPC(new Moreno(), false);
                addedNpcs.add(Moreno.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Heather.class))) {
                this.addNPC(new Heather(), false);
                addedNpcs.add(Heather.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Ziva.class))) {
                this.addNPC(new Ziva(), false);
                addedNpcs.add(Ziva.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Eisek.class))) {
                this.addNPC(new Eisek(), false);
                addedNpcs.add(Eisek.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Monica.class))) {
                this.addNPC(new Monica(), false);
                addedNpcs.add(Monica.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Ceridwen.class))) {
                this.addNPC(new Ceridwen(), false);
                addedNpcs.add(Ceridwen.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Imsu.class))) {
                this.addNPC(new Imsu(), false);
                addedNpcs.add(Imsu.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Hale.class))) {
                this.addNPC(new Hale(), false);
                addedNpcs.add(Hale.class);
            }
            if (addedNpcs.contains(Imsu.class) || addedNpcs.contains(Hale.class)) {
                Main.game.getNpc(Imsu.class).setAffection(Main.game.getNpc(Hale.class), (float)AffectionLevel.POSITIVE_TWO_LIKE.getMedianValue());
                Main.game.getNpc(Hale.class).setAffection(Main.game.getNpc(Imsu.class), (float)AffectionLevel.POSITIVE_TWO_LIKE.getMedianValue());
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Penelope.class))) {
                this.addNPC(new Penelope(), false);
                addedNpcs.add(Penelope.class);
            }
            if (addedNpcs.contains(Penelope.class) || addedNpcs.contains(Pix.class) || Main.isVersionOlderThan(loadingVersion, "0.4.2.7")) {
                Main.game.getNpc(Penelope.class).setAffection(Main.game.getNpc(Pix.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
                Main.game.getNpc(Pix.class).setAffection(Main.game.getNpc(Penelope.class), (float)AffectionLevel.NEGATIVE_ONE_ANNOYED.getMedianValue());
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Belle.class))) {
                this.addNPC(new Belle(), false);
                addedNpcs.add(Belle.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Daphne.class))) {
                this.addNPC(new Daphne(), false);
                addedNpcs.add(Daphne.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Farah.class))) {
                this.addNPC(new Farah(), false);
                addedNpcs.add(Farah.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Oglix.class))) {
                this.addNPC(new Oglix(), false);
                addedNpcs.add(Oglix.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Golix.class))) {
                this.addNPC(new Golix(Gender.F_P_B_SHEMALE, Main.game.getNpc(Oglix.class), false), false);
                addedNpcs.add(Golix.class);
            }
            if (addedNpcs.contains(Oglix.class)) {
                Main.game.getNpc(Oglix.class).setAffection(Main.game.getNpc(Kheiron.class), (float)AffectionLevel.POSITIVE_TWO_LIKE.getMedianValue());
                Main.game.getNpc(Kheiron.class).setAffection(Main.game.getNpc(Oglix.class), (float)AffectionLevel.NEGATIVE_THREE_STRONG_DISLIKE.getMedianValue());
            }
            if (addedNpcs.contains(Golix.class)) {
                ((Oglix)Main.game.getNpc(Oglix.class)).createElemental();
                Main.game.getNpc(Kheiron.class).setAffection(Main.game.getNpc(Golix.class), (float)AffectionLevel.POSITIVE_FIVE_WORSHIP.getMedianValue());
                Main.game.getNpc(Golix.class).setAffection(Main.game.getNpc(Kheiron.class), (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMedianValue());
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Wynter.class))) {
                this.addNPC(new Wynter(), false);
                addedNpcs.add(Wynter.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Sterope.class))) {
                this.addNPC(new Sterope(), false);
                addedNpcs.add(Sterope.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Hammer.class))) {
                this.addNPC(new Hammer(), false);
                addedNpcs.add(Hammer.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Ghost.class))) {
                this.addNPC(new Ghost(), false);
                addedNpcs.add(Ghost.class);
            }
            if (addedNpcs.contains(Hammer.class)) {
                Main.game.getNpc(Hammer.class).setAffection(Main.game.getNpc(Ghost.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
                Main.game.getNpc(Ghost.class).setAffection(Main.game.getNpc(Hammer.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Angelixx.class))) {
                this.addNPC(new Angelixx(), false);
                addedNpcs.add(Angelixx.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Sleip.class))) {
                this.addNPC(new Sleip(), false);
                addedNpcs.add(Sleip.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Nir.class))) {
                this.addNPC(new Nir(), false);
                addedNpcs.add(Nir.class);
            }
            if (addedNpcs.contains(Angelixx.class) || addedNpcs.contains(Saellatrix.class)) {
                Main.game.getNpc(Angelixx.class).setAffection(Main.game.getNpc(Sleip.class), (float)AffectionLevel.POSITIVE_TWO_LIKE.getMedianValue());
                Main.game.getNpc(Angelixx.class).setAffection(Main.game.getNpc(Nir.class), (float)AffectionLevel.POSITIVE_TWO_LIKE.getMedianValue());
                Main.game.getNpc(Saellatrix.class).setAffection(Main.game.getNpc(Angelixx.class), (float)AffectionLevel.NEGATIVE_THREE_STRONG_DISLIKE.getMedianValue());
                Main.game.getNpc(Angelixx.class).setAffection(Main.game.getNpc(Saellatrix.class), (float)AffectionLevel.NEGATIVE_TWO_DISLIKE.getMedianValue());
            }
            if (addedNpcs.contains(Saellatrix.class) || Main.isVersionOlderThan(loadingVersion, "0.4.9.12")) {
                Main.game.getNpc(Saellatrix.class).setAffection(Main.game.getNpc(Lilaya.class), (float)AffectionLevel.POSITIVE_TWO_LIKE.getMedianValue());
                Main.game.getNpc(Lilaya.class).setAffection(Main.game.getNpc(Saellatrix.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
            }
            if (addedNpcs.contains(Sleip.class)) {
                this.getNpc(Sleip.class).setMother(this.getNpc(Angelixx.class));
                Main.game.getNpc(Sleip.class).setAffection(Main.game.getNpc(Angelixx.class), (float)AffectionLevel.POSITIVE_FIVE_WORSHIP.getMedianValue());
                Main.game.getNpc(Sleip.class).setAffection(Main.game.getNpc(Nir.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
            }
            if (addedNpcs.contains(Nir.class)) {
                this.getNpc(Nir.class).setMother(this.getNpc(Angelixx.class));
                Main.game.getNpc(Nir.class).setAffection(Main.game.getNpc(Angelixx.class), (float)AffectionLevel.POSITIVE_FIVE_WORSHIP.getMedianValue());
                Main.game.getNpc(Nir.class).setAffection(Main.game.getNpc(Sleip.class), (float)AffectionLevel.POSITIVE_THREE_CARING.getMedianValue());
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Evelyx.class))) {
                this.addNPC(new Evelyx(), false);
                addedNpcs.add(Evelyx.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Dale.class))) {
                this.addNPC(new Dale(), false);
                addedNpcs.add(Dale.class);
            }
            if (addedNpcs.contains(Evelyx.class) || addedNpcs.contains(Dale.class)) {
                Main.game.getNpc(Evelyx.class).setAffection(Main.game.getNpc(Dale.class), (float)AffectionLevel.POSITIVE_TWO_LIKE.getMedianValue());
                Main.game.getNpc(Dale.class).setAffection(Main.game.getNpc(Evelyx.class), (float)AffectionLevel.POSITIVE_ONE_FRIENDLY.getMedianValue());
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(HeadlessHorseman.class))) {
                this.addNPC(new HeadlessHorseman(), false);
                addedNpcs.add(HeadlessHorseman.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Lunexis.class))) {
                this.addNPC(new Lunexis(), false);
                addedNpcs.add(Lunexis.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Ursa.class))) {
                this.addNPC(new Ursa(), false);
                addedNpcs.add(Ursa.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Aurokaris.class))) {
                this.addNPC(new Aurokaris(), false);
                addedNpcs.add(Aurokaris.class);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Lunette.class))) {
                this.addNPC(new Lunette(), false);
                addedNpcs.add(Lunette.class);
            }
            if (addedNpcs.contains(Lunette.class)) {
                this.getNpc(Lunexis.class).setMother(this.getNpc(Lunette.class));
                this.getNpc(Lunexis.class).setAffection(this.getNpc(Lunette.class), 100.0f);
            }
            if (!Main.game.NPCMap.containsKey(Main.game.getUniqueNPCId(Lovienne.class))) {
                this.addNPC(new Lovienne(), false);
                addedNpcs.add(Lovienne.class);
            }
            if (addedNpcs.contains(Lovienne.class)) {
                this.getNpc(Angelixx.class).setMother(this.getNpc(Lovienne.class));
                this.getNpc(Angelixx.class).setAffection(this.getNpc(Lovienne.class), 100.0f);
                this.getNpc(Saellatrix.class).setMother(this.getNpc(Lovienne.class));
                this.getNpc(Saellatrix.class).setAffection(this.getNpc(Lovienne.class), 100.0f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void endTurn(int secondsPassed) {
        this.endTurn(secondsPassed, true);
    }

    public void endTurn(Response response, DialogueNode dialogue) {
        int seconds = 0;
        if (dialogue != null) {
            seconds = dialogue.getSecondsPassed();
        }
        if (response != null && response.getSecondsPassed() != Integer.MIN_VALUE) {
            seconds = response.getSecondsPassed();
        }
        Main.game.endTurn(seconds, true);
    }

    /*
     * Could not resolve type clashes
     */
    private void endTurn(int secondsPassedThisTurn, boolean advanceTime) {
        boolean newDay;
        boolean slavesUpdated;
        int hoursPassed;
        if (!advanceTime) {
            System.err.println("WARNING: Game.endTurn() does not properly account for 'advanceTime' being false!!!");
            new IllegalArgumentException().printStackTrace();
        }
        boolean loopDebug = false;
        long tStart = System.nanoTime();
        long startHour = this.getHour();
        int startHourOfDay = this.getHourOfDay();
        List<Object> flagsReset = new ArrayList();
        boolean newWeekPassed = false;
        if (advanceTime) {
            if (this.secondsPassed / 604800L != (this.secondsPassed + (long)secondsPassedThisTurn) / 604800L) {
                newWeekPassed = true;
            }
            this.secondsPassed += (long)secondsPassedThisTurn;
            this.handleAtmosphericConditions(secondsPassedThisTurn);
            this.updateResponses();
        }
        if ((hoursPassed = (int)(this.getHour() - startHour)) > 0) {
            flagsReset = Main.game.getDialogueFlags().applyTimePassingResets(startHourOfDay, hoursPassed);
        }
        if (loopDebug) {
            System.out.println();
            System.out.println("debug end turn start");
        }
        if (Main.game.getPlayer().hasQuest(QuestLine.MAIN) && Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_2_C_SIRENS_FALL) && Main.game.getNpc(FortressAlphaLeader.class).getWorldLocation() != WorldType.IMP_FORTRESS_ALPHA) {
            boolean malesReset;
            boolean alphaReset = this.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressAlphaDefeated) && this.getMinutesPassed() - this.getDialogueFlags().getSavedLong("fortress_alpha_clear") > 7200L;
            boolean femalesReset = this.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressFemalesDefeated) && this.getMinutesPassed() - this.getDialogueFlags().getSavedLong("fortress_females_clear") > 7200L;
            boolean bl = malesReset = this.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressMalesDefeated) && this.getMinutesPassed() - this.getDialogueFlags().getSavedLong("fortress_males_clear") > 7200L;
            if (alphaReset && Main.game.getPlayer().getWorldLocation() != WorldType.IMP_FORTRESS_ALPHA) {
                ImpFortressDialogue.resetFortress(WorldType.IMP_FORTRESS_ALPHA);
            }
            if (femalesReset && Main.game.getPlayer().getWorldLocation() != WorldType.IMP_FORTRESS_FEMALES) {
                ImpFortressDialogue.resetFortress(WorldType.IMP_FORTRESS_FEMALES);
            }
            if (malesReset && Main.game.getPlayer().getWorldLocation() != WorldType.IMP_FORTRESS_MALES) {
                ImpFortressDialogue.resetFortress(WorldType.IMP_FORTRESS_MALES);
            }
        }
        if (loopDebug) {
            System.out.println("imp tunnels reset");
        }
        if (Main.game.getPlayerCell().getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_DRESSING_ROOM) && Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.dressingRoomAutoClean)) {
            Main.game.getPlayerCell().getInventory().cleanAllClothing(true);
        }
        ArrayList<GameCharacter> companions = new ArrayList<GameCharacter>(Main.game.getPlayer().getCompanions());
        for (GameCharacter companion : companions) {
            if (companion.getPartyLeader() == null) {
                companion.setPartyLeader(Main.game.getPlayer().getId());
            }
            companion.companionshipCheck();
        }
        if (!Main.game.getCurrentDialogueNode().isTravelDisabled()) {
            for (GameCharacter character : Main.game.getPlayer().getCompanions()) {
                character.setLocation(Main.game.getPlayer().getWorldLocation(), Main.game.getPlayer().getLocation(), false);
            }
        }
        if (loopDebug) {
            System.out.println("companions done");
        }
        int hourStartTo24 = (int)(startHour % 24L);
        boolean bl = slavesUpdated = hoursPassed > 0;
        if (slavesUpdated) {
            for (int i = 1; i <= hoursPassed; ++i) {
                Main.game.getPlayer().performHourlyFluidsCheck();
                this.occupancyUtil.performHourlyUpdate(this.getDayNumber(startHour * 60L * 60L + (long)(i * 60 * 60)), (hourStartTo24 + i) % 24);
                for (String slaveId2 : this.occupancyUtil.getAllCharacters()) {
                    try {
                        Main.game.getNPCById(slaveId2).calculateStatusEffects(3600);
                    }
                    catch (Exception exception) {}
                }
            }
            for (Object slaveId : Main.game.getPlayer().getSlavesOwned()) {
                try {
                    Main.game.getNPCById((String)slaveId).calculateStatusEffects(secondsPassedThisTurn % 3600);
                }
                catch (Exception slaveId2) {}
            }
        }
        if (!Main.game.getPlayer().getLocationPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM)) {
            MilkingRoom.setTargetedCharacter(Main.game.getPlayer());
        }
        if (loopDebug) {
            System.out.println("occupancy done");
        }
        boolean bl2 = newDay = this.getDayNumber(this.getSecondsPassed()) != this.getDayNumber(this.getSecondsPassed() - (long)secondsPassedThisTurn);
        boolean bl3 = Main.game.getDialogueFlags().hasSavedLong("slaver_alley_slaves_freed_time") ? Main.game.getSecondsPassed() - (long)secondsPassedThisTurn - Main.game.getDialogueFlags().getSavedLong("slaver_alley_slaves_freed_time") > 21600L && !Main.game.isHourBetween(20.0f, 1.0f) : (this.pendingSlaveInStocksReset = newDay);
        if (newDay) {
            this.pendingSlaveShopsReset = true;
            Main.game.getPlayer().resetDaysOrgasmCount();
            for (String id : Main.game.getPlayer().getFriendlyOccupants()) {
                try {
                    NPC occupant = (NPC)Main.game.getNPCById(id);
                    Main.game.getOccupancyUtil().dailyOccupantUpdate(occupant);
                }
                catch (Exception e) {
                    Util.logGetNpcByIdError("endTurn()", id);
                }
            }
            if (loopDebug) {
                System.out.println("starting daily location reset");
            }
            LilayaHomeGeneric.dailyUpdate();
            VengarCaptiveDialogue.applyDailyReset();
            Game.calculateBankInterest();
        }
        if (!(!this.pendingSlaveShopsReset || Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SLAVER_ALLEY_STALL_ANAL) || Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SLAVER_ALLEY_STALL_FEMALES) || Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SLAVER_ALLEY_STALL_MALES) || Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SLAVER_ALLEY_STALL_ORAL) || Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SLAVER_ALLEY_STALL_VAGINAL))) {
            SlaverAlleyDialogue.dailyReset();
            this.pendingSlaveShopsReset = false;
        }
        if (this.pendingSlaveInStocksReset && !Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SLAVER_ALLEY_PUBLIC_STOCKS)) {
            SlaverAlleyDialogue.stocksReset();
            this.pendingSlaveInStocksReset = false;
            Main.game.getDialogueFlags().removeSavedLong("slaver_alley_slaves_freed_time");
        }
        for (int i = 1; i <= hoursPassed; ++i) {
            RedLightDistrict.prostituteUpdate();
            SlaverAlleyDialogue.stocksUpdate();
        }
        if (loopDebug) {
            System.out.println("Daily location end");
        }
        this.isInNPCUpdateLoop = true;
        long tLoopStart = System.nanoTime();
        if (loopDebug) {
            System.out.println("NPC loop start");
        }
        for (NPC npc : this.NPCMap.values()) {
            boolean inGame;
            boolean bl4 = inGame = !npc.getLocationPlace().getPlaceType().equals(PlaceType.GENERIC_EMPTY_TILE) || npc instanceof Elemental && ((Elemental)npc).getSummoner() != null && ((Elemental)npc).getSummoner().isElementalSummoned();
            if (inGame && !Main.game.getCharactersPresent().contains(npc)) {
                if (!npc.isSlave() || !npc.getOwner().isPlayer() && npc.hasSlavePermissionSetting(SlavePermissionSetting.CLEANLINESS_WASH_CLOTHES)) {
                    npc.cleanAllClothing(true, false);
                }
                if (!npc.isSlave() || !npc.getOwner().isPlayer() && npc.hasSlavePermissionSetting(SlavePermissionSetting.CLEANLINESS_WASH_BODY)) {
                    npc.cleanAllDirtySlots(true);
                }
            }
            if (secondsPassedThisTurn >= 0) {
                if (inGame && !Main.game.isInCombat() && !Main.game.isInSex() && Main.game.isPrologueFinished()) {
                    if (!Main.game.getPlayer().getCompanions().contains(npc)) {
                        if (!Main.game.getCharactersPresent().contains(npc)) {
                            npc.setHealthPercentage(1.0f);
                            npc.setManaPercentage(1.0f);
                        }
                        npc.alignLustToRestingLust(secondsPassedThisTurn * 10);
                    } else {
                        if (npc.getHealthPercentage() < 1.0f) {
                            npc.incrementHealth((float)secondsPassedThisTurn / 60.0f * npc.getRegenerationRate());
                        }
                        if (npc.getManaPercentage() < 1.0f) {
                            npc.incrementMana((float)secondsPassedThisTurn / 60.0f * npc.getRegenerationRate());
                        }
                        npc.alignLustToRestingLust(secondsPassedThisTurn);
                    }
                }
                if (!(slavesUpdated && npc.isSlave() && npc.getOwner().isPlayer())) {
                    npc.calculateStatusEffects(secondsPassedThisTurn);
                }
            }
            if (inGame) {
                if (!(Main.game.isInCombat() || Main.game.isInSex() || npc.isAllowingPlayerToManageInventory() || !Main.game.getCurrentDialogueNode().equals(Main.game.getPlayerCell().getDialogue(false)) && this.getCharactersPresent().contains(npc))) {
                    if (hoursPassed > 0 && npc.isPendingClothingDressing()) {
                        npc.equipClothing(Util.newArrayListOfValues(EquipClothingSetting.REPLACE_CLOTHING, EquipClothingSetting.ADD_WEAPONS));
                        npc.setPendingClothingDressing(false);
                    } else if (!(npc.isSlave() || npc.isUnique() || npc.hasFetish(Fetish.FETISH_EXHIBITIONIST))) {
                        if ((npc.hasStatusEffect(StatusEffect.EXPOSED) || npc.hasStatusEffect(StatusEffect.EXPOSED_BREASTS) || npc.hasStatusEffect(StatusEffect.EXPOSED_PLUS_BREASTS)) && hoursPassed > 0) {
                            npc.replaceAllClothing();
                            npc.calculateStatusEffects(0);
                            if (npc.hasStatusEffect(StatusEffect.EXPOSED) || npc.hasStatusEffect(StatusEffect.EXPOSED_BREASTS) || npc.hasStatusEffect(StatusEffect.EXPOSED_PLUS_BREASTS)) {
                                npc.equipClothing(Util.newArrayListOfValues(EquipClothingSetting.REPLACE_CLOTHING, EquipClothingSetting.ADD_WEAPONS));
                                if (loopDebug) {
                                    System.out.println(npc.getName(true) + " " + npc.getClass().getName() + " got dressed");
                                }
                            }
                            npc.setPendingClothingDressing(false);
                        }
                        if (npc.hasStatusEffect(StatusEffect.STRETCHING_ORIFICE)) {
                            for (AbstractClothing c : npc.getSexToyOrificeTooDeep().values()) {
                                npc.unequipClothingIntoInventory(c, true, npc);
                            }
                            for (AbstractClothing c : npc.getSexToyOrificeStretching().values()) {
                                npc.unequipClothingIntoInventory(c, true, npc);
                            }
                            for (AbstractClothing c : npc.getSexToyOrificePreventingStretchRecovery().values()) {
                                npc.unequipClothingIntoInventory(c, true, npc);
                            }
                        }
                    }
                }
                if (npc.isPendingTransformationToGenderIdentity() && !npc.getLocation().equals(Main.game.getPlayer().getLocation())) {
                    npc.setBodyToGenderIdentity(false);
                }
                if (!(npc.isDoll() || npc.isPregnant() || npc.isSlave() || npc.getHistory() != Occupation.NPC_PROSTITUTE || npc.hasStatusEffect(StatusEffect.PROMISCUITY_PILL) || npc.getLocation().equals(Main.game.getPlayer().getLocation()))) {
                    npc.useItem(Main.game.getItemGen().generateItem("innoxia_pills_sterility"), npc, false);
                }
            }
            if (npc.hasStatusEffect(StatusEffect.PREGNANT_3) && !Main.game.getCharactersPresent().contains(npc) && !Main.game.getPlayer().getCompanions().contains(npc) && Main.game.getSecondsPassed() - npc.getTimeProgressedToFinalPregnancyStage() > 43200L) {
                if (npc instanceof Lilaya) {
                    if (Main.game.getNpc(Lilaya.class).isCharacterReactedToPregnancy(Main.game.getPlayer()) || npc.getRaceStage() == RaceStage.GREATER) {
                        npc.endPregnancy(true);
                    }
                } else if (npc.isSlave() && npc.getOwner().isPlayer()) {
                    if (npc.getSlavePermissionSettings().get((Object)SlavePermission.PREGNANCY).contains((Object)SlavePermissionSetting.PREGNANCY_ALLOW_BIRTHING)) {
                        npc.endPregnancy(true, false);
                        ArrayList<String> events = Util.newArrayListOfValues(UtilText.parse((GameCharacter)npc, "[npc.She]\u751f\u51fa\u4e86:<br/>", new ParserTag[0]) + npc.getLastLitterBirthed().getBirthedDescription());
                        SlaveryEventLogEntry entry = new SlaveryEventLogEntry(this.getHourOfDay(), npc, null, SlaveEvent.GAVE_BIRTH, null, (List<String>)events, true);
                        Main.game.addSlaveryEvent(this.getDayNumber(), entry);
                    }
                } else {
                    npc.endPregnancy(true);
                }
            }
            if (!(npc.getIncubatingLitters().isEmpty() || Main.game.getCharactersPresent().contains(npc) || Main.game.getPlayer().getCompanions().contains(npc))) {
                for (Map.Entry entry : new HashMap<SexAreaOrifice, Litter>(npc.getIncubatingLitters()).entrySet()) {
                    long finalStageTime = npc.getTimeProgressedToFinalIncubationStage((SexAreaOrifice)entry.getKey());
                    if (finalStageTime <= 0L || Main.game.getSecondsPassed() - finalStageTime <= 43200L) continue;
                    if (npc.isSlave() && npc.getOwner().isPlayer()) {
                        if (!npc.getSlavePermissionSettings().get((Object)SlavePermission.PREGNANCY).contains((Object)SlavePermissionSetting.PREGNANCY_ALLOW_EGG_LAYING)) continue;
                        npc.endIncubationPregnancy((SexAreaOrifice)entry.getKey(), true, false);
                        String areaEgged = "";
                        switch ((SexAreaOrifice)entry.getKey()) {
                            case ANUS: 
                            case MOUTH: {
                                areaEgged = "stomach";
                                break;
                            }
                            case NIPPLE: {
                                areaEgged = "[npc.breasts]";
                                break;
                            }
                            case NIPPLE_CROTCH: {
                                areaEgged = "[npc.crotchBoobs]";
                                break;
                            }
                            case SPINNERET: {
                                areaEgged = "[npc.spinneret]";
                                break;
                            }
                            case VAGINA: {
                                areaEgged = "womb";
                                break;
                            }
                        }
                        ArrayList<String> events = Util.newArrayListOfValues(UtilText.parse((GameCharacter)npc, "[npc.She]\u5728[npc.her]\u7684" + areaEgged + "\u6210\u529f\u5b75\u5316\u5e76\u751f\u51fa\u4e86:<br/>", new ParserTag[0]) + npc.getLastLitterIncubated().getBirthedDescription());
                        SlaveryEventLogEntry incubationBirthEntry = new SlaveryEventLogEntry(this.getHourOfDay(), npc, null, SlaveEvent.GAVE_BIRTH_INCUBATION, null, events, true);
                        Main.game.addSlaveryEvent(this.getDayNumber(), incubationBirthEntry);
                        continue;
                    }
                    npc.endIncubationPregnancy((SexAreaOrifice)entry.getKey(), true);
                }
            }
            if (npc.isRaceConcealed() || npc.getWorldLocation() != Main.game.getPlayer().getWorldLocation() || !npc.getLocation().equals(Main.game.getPlayer().getLocation())) continue;
            for (CoverableArea ca : CoverableArea.values()) {
                if (!npc.isCoverableAreaVisible(ca) || ca == CoverableArea.MOUTH) continue;
                npc.setAreaKnownByCharacter(ca, Main.game.getPlayer(), true);
            }
        }
        if (hoursPassed >= 1) {
            for (AbstractDialogueFlagValue value : flagsReset) {
                this.getDialogueFlags().setFlag(value, true);
            }
            for (int i = 1; i <= hoursPassed; ++i) {
                int incrementedHourOfDay = (startHourOfDay + i) % 24;
                for (NPC npc : this.NPCMap.values()) {
                    boolean inGame = !npc.getLocationPlace().getPlaceType().equals(PlaceType.GENERIC_EMPTY_TILE) || npc instanceof Elemental && ((Elemental)npc).getSummoner() != null && ((Elemental)npc).getSummoner().isElementalSummoned();
                    npc.hourlyUpdate(incrementedHourOfDay);
                    if (inGame) {
                        npc.performHourlyFluidsCheck();
                    }
                    if (newDay && incrementedHourOfDay == 0) {
                        long tL = System.nanoTime();
                        if (loopDebug && npc.isUnique()) {
                            System.out.print(npc.getName(true) + " daily reset loop: ");
                        }
                        npc.resetDaysOrgasmCount();
                        if (!(npc.isSlave() || npc.isElemental() || npc.isUnique() || Main.game.getPlayer().getFriendlyOccupants().contains(npc.getId()) || Main.game.isInCombat() || Main.game.isInSex() || npc.isAllowingPlayerToManageInventory() || !Main.game.getCurrentDialogueNode().equals(Main.game.getPlayerCell().getDialogue(false)) && this.getCharactersPresent().contains(npc))) {
                            npc.clearNonEquippedInventory(false);
                            Main.game.getCharacterUtils().regenerateItemsInInventory(npc);
                        }
                        try {
                            npc.dailyUpdate();
                        }
                        catch (Exception ex) {
                            System.err.println("Issue in method: dailyReset(), for character ID: " + npc.getId() + "\n" + ex.getMessage());
                            ex.printStackTrace();
                        }
                        if (loopDebug && npc.isUnique()) {
                            System.out.println((float)(System.nanoTime() - tL) / 1.0E9f + "s");
                        }
                    }
                    ArrayList<GameCharacter> npcCompanions = new ArrayList<GameCharacter>(npc.getCompanions());
                    for (GameCharacter companion : npcCompanions) {
                        companion.companionshipCheck();
                    }
                    for (GameCharacter character : npc.getCompanions()) {
                        character.setLocation(npc.getWorldLocation(), npc.getLocation(), false);
                    }
                }
                for (AbstractDialogueFlagValue value : new ArrayList<AbstractDialogueFlagValue>(Main.game.getDialogueFlags().values)) {
                    if (value.getResetHour() != incrementedHourOfDay) continue;
                    this.getDialogueFlags().setFlag(value, false);
                    if (!loopDebug) continue;
                    System.out.println("Reset flag: " + value.getId() + " @" + incrementedHourOfDay + ":00");
                }
            }
        }
        for (NPC npc : this.NPCMap.values()) {
            npc.turnUpdate();
        }
        if (loopDebug) {
            System.out.println("NPC loop end. Time since start: " + (float)(System.nanoTime() - tLoopStart) / 1.0E9f + "s");
        }
        this.isInNPCUpdateLoop = false;
        for (NPC npc : this.npcsToRemove) {
            this.banishNPC(npc);
        }
        for (NPC npc : this.npcsToAdd) {
            this.NPCMap.put(npc.getId(), npc);
        }
        this.npcsToRemove.clear();
        this.npcsToAdd.clear();
        if (loopDebug) {
            System.out.println("Removal handling ended: " + (float)(System.nanoTime() - tLoopStart) / 1.0E9f + "s");
        }
        if (secondsPassedThisTurn >= 0) {
            if (!this.isInCombat() && !this.isInSex() && !this.currentDialogueNode.isRegenerationDisabled() && Main.game.isPrologueFinished()) {
                if (Main.game.getPlayer().getHealthPercentage() < 1.0f) {
                    Main.game.getPlayer().incrementHealth((float)(secondsPassedThisTurn / 60) * Main.game.getPlayer().getRegenerationRate());
                }
                if (Main.game.getPlayer().getManaPercentage() < 1.0f) {
                    Main.game.getPlayer().incrementMana((float)(secondsPassedThisTurn / 60) * Main.game.getPlayer().getRegenerationRate());
                }
                Main.game.getPlayer().alignLustToRestingLust(secondsPassedThisTurn);
            }
            if (Main.game.getCurrentDialogueNode() != MiscDialogue.STATUS_EFFECTS) {
                Main.game.getPlayer().calculateStatusEffects(secondsPassedThisTurn);
            }
        }
        MainController.updateUI();
        if (loopDebug) {
            System.out.println("Rendering done: " + (float)(System.nanoTime() - tLoopStart) / 1.0E9f + "s");
        }
        Main.mainController.getTooltip().hide();
        if (!Main.game.getPlayer().hasQuest(QuestLine.SIDE_ENCHANTMENT_DISCOVERY) && Main.game.getPlayer().hasNonArcaneEssences()) {
            Main.game.getPlayer().addStatusEffectDescription(null, Main.game.getPlayer().startQuest(QuestLine.SIDE_ENCHANTMENT_DISCOVERY));
        }
        if (!Main.game.getPlayer().hasQuest(QuestLine.SIDE_FIRST_TIME_PREGNANCY) && Main.game.getPlayer().isVisiblyPregnant()) {
            Main.game.getPlayer().addStatusEffectDescription(null, Main.game.getPlayer().startQuest(QuestLine.SIDE_FIRST_TIME_PREGNANCY));
        }
        if (!Main.game.getPlayer().hasQuest(QuestLine.SIDE_FIRST_TIME_INCUBATION) && !Main.game.getPlayer().getIncubatingLitters().isEmpty()) {
            Main.game.getPlayer().addStatusEffectDescription(null, Main.game.getPlayer().startQuest(QuestLine.SIDE_FIRST_TIME_INCUBATION));
        }
        if (Main.getProperties().getHairGrowth() == 1 && newWeekPassed || Main.getProperties().getHairGrowth() == 2 && newDay || Main.getProperties().getHairGrowth() == 3 && hoursPassed > 0) {
            HairLength oldHairLength = Main.game.getPlayer().getHairLength();
            int lengthGrowth = Main.getProperties().getHairGrowth() == 3 ? hoursPassed : 1;
            Main.game.getPlayer().incrementHairLength(lengthGrowth);
            HairLength newHairLength = Main.game.getPlayer().getHairLength();
            if (oldHairLength != newHairLength) {
                Main.game.getPlayer().addStatusEffectDescription(null, "<p style='text-align:center; margin:0; padding:0;'>\u4f60\u7684[pc.hair]\u957f\u5ea6\u5df2\u7ecf\u589e\u957f\u5230\u4e0b\u4e00\u9636\u6bb5\uff01<br/>\u4f60\u73b0\u5728\u6709\u7740<span style='color:" + newHairLength.getColour().toWebHexString() + ";'>[pc.hairLength]</span>\u7684[pc.hair]\uff01</p>");
            }
        }
        if (!(Main.game.getPlayer().getStatusEffectDescriptions().isEmpty() || !Main.game.getPlayer().getStatusEffectDescriptions().values().stream().anyMatch(m -> !m.isEmpty()) || Main.game.getCurrentDialogueNode() == MiscDialogue.STATUS_EFFECTS || Main.game.getCurrentDialogueNode().isTravelDisabled() || Main.game.isInSex() || Main.game.isInCombat())) {
            if (Main.game.getCurrentDialogueNode().getDialogueNodeType() == DialogueNodeType.NORMAL) {
                Main.game.saveDialogueNode();
            }
            Main.game.setContent(new Response("", "", MiscDialogue.STATUS_EFFECTS){

                @Override
                public void effects() {
                }
            });
        }
        if (!Main.game.getPlayer().getStatusEffectDescriptions().values().stream().anyMatch(m -> !m.isEmpty())) {
            Main.game.getPlayer().getStatusEffectDescriptions().clear();
        }
        if (Main.game.getCurrentDialogueNode().getDialogueNodeType() == DialogueNodeType.NORMAL && !Main.game.getCurrentDialogueNode().isTravelDisabled()) {
            Main.game.getDialogueFlags().setManagementCompanion(null);
        }
        if (loopDebug) {
            System.out.println((double)(System.nanoTime() - tStart) / 1.0E9 + "s");
        }
        this.endTurnTimeTaken = (float)(System.nanoTime() - tStart) + this.endTurnTimeTakenAddition;
        this.endTurnTimeTakenAddition = 0.0f;
        if (Main.game.isDebugMode() || Main.isDisplayingTurnTimer()) {
            Main.refreshTitle();
        }
    }

    private static void calculateBankInterest() {
        float APR = 0.12f;
        long savings = 0L;
        float interest = 0.0f;
        savings += Main.game.getWorlds().get(WorldType.getWorldTypeFromId("innoxia_dominion_bank")).getCell(PlaceType.getPlaceTypeFromId("innoxia_dominion_bank_deposit_box")).getInventory().getMoney();
        if ((savings += Main.game.getWorlds().get(WorldType.getWorldTypeFromId("innoxia_fields_elis_bank")).getCell(PlaceType.getPlaceTypeFromId("innoxia_fields_elis_bank_deposit_box")).getInventory().getMoney()) > 0L) {
            interest = (float)savings * APR / 365.0f;
            if (!Main.game.getDialogueFlags().hasSavedLong("bank_interest")) {
                Main.game.getDialogueFlags().setSavedLong("bank_interest", 0L);
            }
            Main.game.getDialogueFlags().incrementSavedLong("bank_interest", Math.max(1, Math.round(interest)));
        }
    }

    public Season getSeason() {
        return Season.getSeasonFromMonth(this.getDateNow().getMonth());
    }

    private void handleAtmosphericConditions(int secondsPassed) {
        this.weatherTimeRemainingInSeconds -= secondsPassed;
        if (this.weatherTimeRemainingInSeconds < 0) {
            switch (this.currentWeather) {
                case CLEAR: {
                    if (this.getSecondsPassed() >= this.nextStormTimeInSeconds) {
                        this.currentWeather = Weather.MAGIC_STORM_GATHERING;
                        this.weatherTimeRemainingInSeconds = (int)((long)this.gatheringStormDurationInSeconds - (this.getSecondsPassed() - this.nextStormTimeInSeconds));
                        break;
                    }
                    this.currentWeather = Weather.CLOUD;
                    this.weatherTimeRemainingInSeconds = (120 + Util.random.nextInt(120)) * 60;
                    break;
                }
                case CLOUD: {
                    if (this.getSecondsPassed() >= this.nextStormTimeInSeconds) {
                        this.currentWeather = Weather.MAGIC_STORM_GATHERING;
                        this.weatherTimeRemainingInSeconds = (int)((long)this.gatheringStormDurationInSeconds - (this.getSecondsPassed() - this.nextStormTimeInSeconds));
                        break;
                    }
                    if (Math.random() > 0.4) {
                        this.currentWeather = this.getSeason() == Season.WINTER ? Weather.SNOW : Weather.RAIN;
                        this.weatherTimeRemainingInSeconds = (60 + Util.random.nextInt(300)) * 60;
                        break;
                    }
                    this.currentWeather = Weather.CLEAR;
                    this.weatherTimeRemainingInSeconds = (240 + Util.random.nextInt(240)) * 60;
                    break;
                }
                case MAGIC_STORM: {
                    this.nextStormTimeInSeconds = this.getSecondsPassed() + (long)((2880 + 60 * Util.random.nextInt(24)) * 60);
                    this.gatheringStormDurationInSeconds = (240 + Util.random.nextInt(120)) * 60;
                    this.currentWeather = Weather.CLEAR;
                    this.weatherTimeRemainingInSeconds = (240 + Util.random.nextInt(240)) * 60;
                    break;
                }
                case MAGIC_STORM_GATHERING: {
                    this.currentWeather = Weather.MAGIC_STORM;
                    Main.game.getDialogueFlags().values.add(DialogueFlagValue.stormTextUpdateRequired);
                    this.weatherTimeRemainingInSeconds = (480 + Util.random.nextInt(240)) * 60;
                    break;
                }
                case RAIN: 
                case SNOW: {
                    if (this.getSecondsPassed() >= this.nextStormTimeInSeconds) {
                        this.currentWeather = Weather.MAGIC_STORM_GATHERING;
                        this.weatherTimeRemainingInSeconds = (int)((long)this.gatheringStormDurationInSeconds - (this.getSecondsPassed() - this.nextStormTimeInSeconds));
                        break;
                    }
                    this.currentWeather = Weather.CLOUD;
                    this.weatherTimeRemainingInSeconds = (120 + Util.random.nextInt(120)) * 60;
                    break;
                }
            }
        }
    }

    public long getNextStormTimeInSeconds() {
        return this.nextStormTimeInSeconds;
    }

    public String getNextStormTimeAsTimeString() {
        long minutes = (this.nextStormTimeInSeconds + (long)this.gatheringStormDurationInSeconds - this.getSecondsPassed()) / 60L;
        long hours = minutes / 60L;
        return hours / 24L + "\u5929" + hours % 24L + "\u5c0f\u65f6" + minutes % 60L + "\u5206\u949f";
    }

    public Weather getWeather() {
        return this.currentWeather;
    }

    public Weather getCurrentWeather() {
        return this.getWeather();
    }

    public String getBodyStyle() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public void setContent(int index) {
        if (OptionsDialogue.startingNewGame) {
            return;
        }
        informationTooltips = new HashMap<String, TooltipInformationEventListener>();
        Response response = this.currentDialogueNode.getResponse(this.responseTab, index);
        if (response != null) {
            Object corruptionGains = "";
            if (response.isActionCorrupting() && !response.isAvailableFromFetishes()) {
                Main.game.getPlayer().incrementAttribute(Attribute.MAJOR_CORRUPTION, response.getCorruptionNeeded().getCorruptionBypass());
                corruptionGains = "<p style='text-align:center;'><b>\u4f60\u83b7\u5f97\u4e86+" + response.getCorruptionNeeded().getCorruptionBypass() + "</b><b style='color:" + Attribute.MAJOR_CORRUPTION.getColour().toWebHexString() + ";'>\u5815\u843d</b><b>\uff01</b></p>";
            }
            if (!response.isAvailable() && !response.isAbleToBypass()) {
                return;
            }
            String chosenResponse = response.getTitle();
            DialogueNode node = response.getNextDialogue();
            if (node != null || response instanceof ResponseCombat || response instanceof ResponseSex || response instanceof ResponseEffectsOnly || response instanceof ResponseTrade) {
                response.applyEffects();
            }
            if (node != null) {
                node.specialPreParsingEffects();
                node.applyPreParsingEffects();
            }
            if (response instanceof ResponseCombat) {
                this.setContent(new Response("", "", ((ResponseCombat)response).initCombat()));
                return;
            }
            if (response instanceof ResponseSex) {
                this.setContent(new Response("", "", ((ResponseSex)response).initSex()));
                Main.sex.postSexInitSetup();
                ((ResponseSex)response).postSexInitEffects();
                Main.mainController.updateUILeftPanel();
                return;
            }
            if (response instanceof ResponseEffectsOnly) {
                if (Main.game.isStarted()) {
                    Main.game.endTurn(response, null);
                    if (response.postEndTurnEffects()) {
                        Main.game.endTurn(0);
                    }
                }
                return;
            }
            if (response instanceof ResponseTrade) {
                ((ResponseTrade)response).openTrade();
                return;
            }
            if (node != null) {
                void var7_18;
                void var7_16;
                if (this.started && !this.getCharactersPresent().isEmpty()) {
                    for (GameCharacter gameCharacter : this.getCharactersPresent()) {
                        if (Main.game.getPlayer().getCharactersEncountered().contains(gameCharacter.getId()) || !(gameCharacter instanceof NPC)) continue;
                        if (((NPC)gameCharacter).isAddedToContacts() && gameCharacter.isPlayerKnowsName()) {
                            Main.game.getPlayer().addCharacterEncountered(gameCharacter);
                        }
                        if (!gameCharacter.isRaceConcealed()) {
                            Main.getProperties().addRaceDiscovered(gameCharacter.getSubspecies());
                        }
                        ((NPC)gameCharacter).setLastTimeEncountered(this.getMinutesPassed());
                    }
                }
                String headerContent = node.getHeaderContent();
                try {
                    if (response.isStripContent()) {
                        String string = "";
                    } else {
                        String string = node.getContent();
                    }
                }
                catch (Exception ex) {
                    void var7_13;
                    String string2 = "<p style='text-align:center;'>[style.italicsBad(Error: getContent() method is throwing an exception in the node: '" + node.getLabel() + "')]</p>";
                    string2 = string2 + "<p style='font-size:0.75em;'>";
                    for (StackTraceElement ste : ex.getStackTrace()) {
                        String string3 = (String)var7_13 + "<br/>" + ste.toString();
                    }
                    String string4 = (String)var7_13 + "</p>";
                    ex.printStackTrace();
                }
                if (var7_16 == null) {
                    String string = "";
                }
                if (this.currentDialogueNode != null) {
                    if (node.isContinuesDialogue() || response.isForceContinue()) {
                        if (Main.game.isInSex()) {
                            this.dialogueTitle = UtilText.parse(node.getLabel(), new ParserTag[0]);
                        }
                        if (node.isDisplaysActionTitleOnContinuesDialogue()) {
                            if (this.currentDialogueNode.getDialogueNodeType() == DialogueNodeType.NORMAL) {
                                ++this.positionAnchor;
                            }
                            this.pastDialogueSB.append("<hr id='position" + this.positionAnchor + "'/><p class='option-disabled' style='padding-bottom:0; margin-bottom:0;'>&gt " + chosenResponse + "</p>");
                        }
                        if (this.getMapDisplay() == DialogueNodeType.NORMAL) {
                            this.initialPositionAnchor = this.positionAnchor;
                        }
                    } else {
                        this.dialogueTitle = UtilText.parse(node.getLabel(), new ParserTag[0]);
                        if (this.getMapDisplay() == DialogueNodeType.NORMAL) {
                            this.initialPositionAnchor = this.positionAnchor;
                        }
                        if (this.currentDialogueNode.getDialogueNodeType() == DialogueNodeType.NORMAL) {
                            this.positionAnchor = 0;
                        }
                        this.pastDialogueSB.setLength(0);
                    }
                    Object dialogueParsed = UtilText.parse((String)corruptionGains + this.textStartStringBuilder.toString(), new ParserTag[0]) + (String)(node.isContentParsed() ? UtilText.parse((String)var7_18, new ParserTag[0]) : var7_18) + UtilText.parse(this.textEndStringBuilder.toString(), new ParserTag[0]);
                    if (Main.game.isStarted() && Main.game.getPlayer().getHistory() == Occupation.TOURIST) {
                        dialogueParsed = UtilText.convertToAmericanEnglish((String)dialogueParsed);
                    }
                    this.pastDialogueSB.append((String)dialogueParsed);
                    if (this.isAutomaticDialogueCopy() && Main.game.isStarted()) {
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        StringSelection data = new StringSelection(this.formatContentForAutomaticClipboard((String)dialogueParsed));
                        clipboard.setContents(data, data);
                    }
                } else {
                    this.dialogueTitle = UtilText.parse(node.getLabel(), new ParserTag[0]);
                }
                boolean resetPointer = true;
                if (node != this.currentDialogueNode) {
                    this.responsePage = 0;
                    this.currentDialogueNode = node;
                } else {
                    this.currentDialogueNode = node;
                    this.checkForResponsePage();
                    resetPointer = false;
                }
                this.checkForResponseTab();
                if (Main.game != null && Main.game.isStarted() && Main.game.isRequestAutosave() && Main.game.getCurrentDialogueNode() != null && !Main.game.getCurrentDialogueNode().isTravelDisabled()) {
                    this.lastAutoSaveTime = Main.game.getSecondsPassed();
                    Main.saveGame("AutoSave_" + Main.game.getPlayer().getName(false), true, true);
                    Main.game.setRequestAutosave(false);
                }
                this.currentDialogue = node.isContinuesDialogue() || response.isForceContinue() ? "<div id='main-content'>" + this.getTitleDiv(this.getDialogueTitle()) + "<div class='div-center' id='content-block'>" + this.getMapDiv() + (String)(headerContent != null ? "<div id='header-content' style='font-size:" + Main.getProperties().fontSize + "px; line-height:" + (Main.getProperties().fontSize + 6) + "px; -webkit-user-select: none;'>" + (this.currentDialogueNode.disableHeaderParsing() ? headerContent : UtilText.parse(headerContent, new ParserTag[0])) + "</div>" : "") + (String)(var7_18 != null ? "<div " + (Main.getProperties().hasValue(PropertyValue.fadeInText) ? "id='text-content'" : "") + " style='font-size:" + Main.getProperties().fontSize + "px; line-height:" + (Main.getProperties().fontSize + 6) + "px;" + (this.requiresYScroll(node) ? " overflow-y:scroll; overflow-x:hidden;" : "") + "'>" + this.pastDialogueSB.toString() + "</div>" : "") + "</div><div id='bottom-text'>\u6e38\u620f\u5df2\u4fdd\u5b58\uff01</div>" + this.getResponsesDiv(this.currentDialogueNode, resetPointer) + "</div></body>" : "<div id='main-content'>" + this.getTitleDiv(this.getDialogueTitle()) + "<span id='position" + this.positionAnchor + "'></span><div class='div-center' id='content-block'>" + this.getMapDiv() + (String)(headerContent != null ? "<div id='header-content' style='font-size:" + Main.getProperties().fontSize + "px; line-height:" + (Main.getProperties().fontSize + 6) + "px;-webkit-user-select: none;'>" + (this.currentDialogueNode.disableHeaderParsing() ? headerContent : UtilText.parse(headerContent, new ParserTag[0])) + "</div>" : "") + (String)(var7_18 != null ? "<div " + (Main.getProperties().hasValue(PropertyValue.fadeInText) ? "id='text-content'" : "") + " style='font-size:" + Main.getProperties().fontSize + "px; line-height:" + (Main.getProperties().fontSize + 6) + "px;" + (this.requiresYScroll(node) ? " overflow-y:scroll; overflow-x:hidden;" : "") + "'>" + this.pastDialogueSB.toString() + "</div>" : "") + "</div><div id='bottom-text'>\u6e38\u620f\u5df2\u4fdd\u5b58\uff01</div>" + this.getResponsesDiv(this.currentDialogueNode, resetPointer) + "</div></body>";
                this.setMainContentRegex((node.isContinuesDialogue() || response.isForceContinue()) && Game.isContentScroll(response, node) ? "<body onLoad='scrollToElement()' style='" + this.getBodyStyle() + "'><script>function scrollToElement() {document.getElementById('content-block').scrollTop = document.getElementById('position" + this.positionAnchor + "').offsetTop -64;}</script>" : "<body style='" + this.getBodyStyle() + "'>", this.currentDialogue);
                this.textEndStringBuilder.setLength(0);
                this.textStartStringBuilder.setLength(0);
                if (this.started) {
                    Main.game.endTurn(response, node);
                    if (response.postEndTurnEffects()) {
                        Main.game.endTurn(0);
                    }
                }
                TooltipUpdateThread.cancelThreads = true;
            }
        }
    }

    public void setContent(Response response, boolean allowTimeProgress, Colour flashMessageColour, String flashMessageText) {
        Object dialogueParsed;
        Object content;
        informationTooltips = new HashMap<String, TooltipInformationEventListener>();
        DialogueNode node = response.getNextDialogue();
        if (node != null || response instanceof ResponseCombat || response instanceof ResponseSex || response instanceof ResponseEffectsOnly || response instanceof ResponseTrade) {
            response.applyEffects();
        }
        if (node != null) {
            node.specialPreParsingEffects();
            node.applyPreParsingEffects();
        }
        if (response instanceof ResponseCombat) {
            this.setContent(new Response("", "", ((ResponseCombat)response).initCombat()));
            return;
        }
        if (response instanceof ResponseSex) {
            this.setContent(new Response("", "", ((ResponseSex)response).initSex()));
            Main.sex.postSexInitSetup();
            ((ResponseSex)response).postSexInitEffects();
            Main.mainController.updateUILeftPanel();
            return;
        }
        if (response instanceof ResponseEffectsOnly) {
            if (Main.game.isStarted()) {
                Main.game.endTurn(response, null);
                if (response.postEndTurnEffects()) {
                    Main.game.endTurn(0);
                }
            }
            return;
        }
        if (response instanceof ResponseTrade) {
            ((ResponseTrade)response).openTrade();
            return;
        }
        if (node == null) {
            return;
        }
        int currentPosition = 0;
        if (!(this.getCurrentDialogueNode() == null || node != this.getCurrentDialogueNode() || Main.game.isInSex() && Main.sex.getTurn() <= 1 && Main.game.currentDialogueNode == Main.sex.SEX_DIALOGUE)) {
            currentPosition = (Integer)Main.mainController.getWebEngine().executeScript("document.getElementById('content-block').scrollTop");
        }
        String headerContent = node.getHeaderContent();
        try {
            content = response.isStripContent() ? "" : node.getContent();
        }
        catch (Exception ex) {
            content = "<p style='text-align:center;'>[style.italicsBad(Error: getContent() method is throwing an exception in the node: '" + node.getLabel() + "')]</p>";
            content = (String)content + "<p style='font-size:0.75em;'>";
            for (StackTraceElement ste : ex.getStackTrace()) {
                content = (String)content + "<br/>" + ste.toString();
            }
            content = (String)content + "</p>";
            ex.printStackTrace();
        }
        if (content == null) {
            content = "";
        }
        boolean resetPointer = false;
        if (this.getMapDisplay() == DialogueNodeType.NORMAL) {
            this.initialPositionAnchor = this.positionAnchor;
        }
        if (this.started && !this.getCharactersPresent().isEmpty()) {
            for (GameCharacter gameCharacter : this.getCharactersPresent()) {
                if (!(gameCharacter instanceof NPC)) continue;
                if (((NPC)gameCharacter).isAddedToContacts() && gameCharacter.isPlayerKnowsName()) {
                    Main.game.getPlayer().addCharacterEncountered(gameCharacter);
                }
                if (!gameCharacter.isRaceConcealed()) {
                    Main.getProperties().addRaceDiscovered(gameCharacter.getSubspecies());
                }
                ((NPC)gameCharacter).setLastTimeEncountered(this.getMinutesPassed());
            }
        }
        if (this.currentDialogueNode != null) {
            if (node.isContinuesDialogue() || response.isForceContinue()) {
                if (Main.game.isInSex()) {
                    this.dialogueTitle = UtilText.parse(node.getLabel(), new ParserTag[0]);
                }
                if (node.isDisplaysActionTitleOnContinuesDialogue()) {
                    if (this.currentDialogueNode.getDialogueNodeType() == DialogueNodeType.NORMAL) {
                        ++this.positionAnchor;
                    }
                    String string = response.getTitle();
                    this.pastDialogueSB.append(UtilText.parse("<hr id='position" + this.positionAnchor + "'><p class='option-disabled'>&gt " + string + "</p>", new ParserTag[0]));
                }
                dialogueParsed = UtilText.parse(this.textStartStringBuilder.toString(), new ParserTag[0]) + (String)(node.isContentParsed() ? UtilText.parse((String)content, new ParserTag[0]) : content) + UtilText.parse(this.textEndStringBuilder.toString(), new ParserTag[0]);
            } else {
                this.dialogueTitle = UtilText.parse(node.getLabel(), new ParserTag[0]);
                if (this.currentDialogueNode.getDialogueNodeType() == DialogueNodeType.NORMAL) {
                    this.positionAnchor = 0;
                }
                this.pastDialogueSB.setLength(0);
                dialogueParsed = UtilText.parse("<b id='position" + this.positionAnchor + "'></b>" + this.textStartStringBuilder.toString(), new ParserTag[0]) + (String)(node.isContentParsed() ? UtilText.parse((String)content, new ParserTag[0]) : content) + UtilText.parse(this.textEndStringBuilder.toString(), new ParserTag[0]);
            }
        } else {
            this.dialogueTitle = UtilText.parse(node.getLabel(), new ParserTag[0]);
            this.pastDialogueSB.setLength(0);
            dialogueParsed = UtilText.parse(this.textStartStringBuilder.toString(), new ParserTag[0]) + (String)(node.isContentParsed() ? UtilText.parse((String)content, new ParserTag[0]) : content) + UtilText.parse(this.textEndStringBuilder.toString(), new ParserTag[0]);
        }
        if (Main.game.isStarted() && Main.game.getPlayer().getHistory() == Occupation.TOURIST) {
            dialogueParsed = UtilText.convertToAmericanEnglish((String)dialogueParsed);
        }
        this.pastDialogueSB.append((String)dialogueParsed);
        if (this.isAutomaticDialogueCopy() && Main.game.isStarted()) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection data = new StringSelection(this.formatContentForAutomaticClipboard((String)dialogueParsed));
            clipboard.setContents(data, data);
        }
        if (node != this.currentDialogueNode) {
            this.responsePage = 0;
            this.currentDialogueNode = node;
            resetPointer = true;
        } else {
            this.currentDialogueNode = node;
            this.checkForResponsePage();
            resetPointer = false;
        }
        this.checkForResponseTab();
        if (Main.game != null && Main.game.isStarted() && Main.game.isRequestAutosave() && Main.game.getCurrentDialogueNode() != null && !Main.game.getCurrentDialogueNode().isTravelDisabled()) {
            this.lastAutoSaveTime = Main.game.getSecondsPassed();
            Main.saveGame("AutoSave_" + Main.game.getPlayer().getName(false), true, true);
            Main.game.setRequestAutosave(false);
        }
        this.currentDialogue = node.isContinuesDialogue() || response.isForceContinue() ? "<div id='main-content'>" + this.getTitleDiv(this.getDialogueTitle()) + "<div class='div-center' id='content-block'>" + this.getMapDiv() + (String)(headerContent != null ? "<div id='header-content' style='font-size:" + Main.getProperties().fontSize + "px; line-height:" + (Main.getProperties().fontSize + 6) + "px;-webkit-user-select: none;'>" + (this.currentDialogueNode.disableHeaderParsing() ? headerContent : UtilText.parse(headerContent, new ParserTag[0])) + "</div>" : "") + (String)(content != null ? "<div " + (Main.getProperties().hasValue(PropertyValue.fadeInText) ? "id='text-content'" : "") + " style='font-size:" + Main.getProperties().fontSize + "px; line-height:" + (Main.getProperties().fontSize + 6) + "px;" + (this.requiresYScroll(node) ? " overflow-y:scroll; overflow-x:hidden;" : "") + "'>" + this.pastDialogueSB.toString() + "</div>" : "") + "</div><div id='bottom-text'>\u6e38\u620f\u5df2\u4fdd\u5b58\uff01</div>" + this.getResponsesDiv(this.currentDialogueNode, resetPointer) + "</div></body>" : "<div id='main-content'>" + this.getTitleDiv(this.getDialogueTitle()) + "<span id='position" + this.positionAnchor + "'></span><div class='div-center' id='content-block'>" + this.getMapDiv() + (String)(headerContent != null ? "<div id='header-content' style='font-size:" + Main.getProperties().fontSize + "px; line-height:" + (Main.getProperties().fontSize + 6) + "px;-webkit-user-select: none;'>" + (this.currentDialogueNode.disableHeaderParsing() ? headerContent : UtilText.parse(headerContent, new ParserTag[0])) + "</div>" : "") + (String)(content != null ? "<div " + (Main.getProperties().hasValue(PropertyValue.fadeInText) ? "id='text-content'" : "") + " style='font-size:" + Main.getProperties().fontSize + "px; line-height:" + (Main.getProperties().fontSize + 6) + "px;" + (this.requiresYScroll(node) ? " overflow-y:scroll; overflow-x:hidden;" : "") + "'>" + this.pastDialogueSB.toString() + "</div>" : "") + "</div><div id='bottom-text'>\u6e38\u620f\u5df2\u4fdd\u5b58\uff01</div>" + this.getResponsesDiv(this.currentDialogueNode, resetPointer) + "</div></body>";
        Main.mainController.setFlashMessageColour(flashMessageColour);
        Main.mainController.setFlashMessageText(flashMessageText);
        this.setMainContentRegex(node.isContinuesDialogue() || response.isForceContinue() ? (Game.isContentScroll(response, node) ? "<body onLoad='scrollToElement()' style='" + this.getBodyStyle() + "'><script>function scrollToElement() {document.getElementById('content-block').scrollTop = document.getElementById('position" + this.positionAnchor + "').offsetTop -64;}</script>" : "<body style='" + this.getBodyStyle() + "'>") : (Game.isContentScroll(response, node) ? "<body onLoad='scrollToElement()' style='" + this.getBodyStyle() + "'><script>function scrollToElement() {document.getElementById('content-block').scrollTop = " + currentPosition + ";}</script>" : "<body style='" + this.getBodyStyle() + "'>"), this.currentDialogue);
        this.textEndStringBuilder.setLength(0);
        this.textStartStringBuilder.setLength(0);
        if (this.started) {
            if (allowTimeProgress) {
                Main.game.endTurn(response, node);
                if (response.postEndTurnEffects()) {
                    Main.game.endTurn(0);
                }
            } else {
                Main.game.endTurn(0);
                if (response.postEndTurnEffects()) {
                    Main.game.endTurn(0);
                }
            }
        }
    }

    private boolean requiresYScroll(DialogueNode node) {
        return this.currentDialogueNode.getDialogueNodeType() == DialogueNodeType.INVENTORY && !node.equals(InventoryDialogue.DYE_CLOTHING) && !node.equals(InventoryDialogue.DYE_CLOTHING_CHARACTER_CREATION) && !node.equals(InventoryDialogue.DYE_EQUIPPED_CLOTHING) && !node.equals(InventoryDialogue.DYE_EQUIPPED_CLOTHING_CHARACTER_CREATION) && !node.equals(InventoryDialogue.DYE_EQUIPPED_WEAPON) && !node.equals(InventoryDialogue.DYE_WEAPON);
    }

    private static boolean isContentScroll(Response response, DialogueNode node) {
        if (response != null && response.isIgnoreContentScroll() || node.isIgnoreContentScroll()) {
            return false;
        }
        if (node == Main.sex.SEX_DIALOGUE && Main.sex.getTurn() == 1) {
            return false;
        }
        return node.getDialogueNodeType() != DialogueNodeType.CHARACTERS_PRESENT && !node.equals(PhoneDialogue.CHARACTER_APPEARANCE) && !node.equals(PhoneDialogue.CONTACTS_CHARACTER) || node.equals(CharactersPresentDialogue.PERKS) || node.equals(BodyChanging.BODY_CHANGING_ASS) || node.equals(BodyChanging.BODY_CHANGING_BREASTS) || node.equals(BodyChanging.BODY_CHANGING_CORE) || node.equals(BodyChanging.BODY_CHANGING_EYES) || node.equals(BodyChanging.BODY_CHANGING_HAIR) || node.equals(BodyChanging.BODY_CHANGING_HEAD) || node.equals(BodyChanging.BODY_CHANGING_PENIS) || node.equals(BodyChanging.BODY_CHANGING_VAGINA) || node.equals(InventoryDialogue.DYE_CLOTHING) || node.equals(InventoryDialogue.DYE_CLOTHING_CHARACTER_CREATION) || node.equals(InventoryDialogue.DYE_EQUIPPED_CLOTHING) || node.equals(InventoryDialogue.DYE_EQUIPPED_CLOTHING_CHARACTER_CREATION) || node.equals(InventoryDialogue.DYE_EQUIPPED_WEAPON) || node.equals(InventoryDialogue.DYE_WEAPON);
    }

    private String getDialogueTitle() {
        if (this.isBadEnd()) {
            return "<b style='color:" + PresetColour.GENERIC_BAD_END.toWebHexString() + ";'>\u574f\u7ed3\u5c40:" + Main.getProperties().badEndTitle + "</b>";
        }
        return this.dialogueTitle;
    }

    private String getTitleDiv(String title) {
        if (title.isEmpty()) {
            return "";
        }
        return "<div class='content-title'><h4 style='text-align:center;'>" + title + "</h4></div>";
    }

    private String getMapDiv() {
        return "";
    }

    public void setContent(Response response) {
        this.setContent(response, true, null, null);
    }

    public void setContent(Response response, boolean allowTimeProgress) {
        this.setContent(response, allowTimeProgress, null, null);
    }

    public void setContent(Response response, Colour colour, String messageText) {
        this.setContent(response, true, colour, messageText);
    }

    private void resetResponsePointer() {
        this.responsePointer = this.responsePage * 15;
        for (int i = this.responsePage * 15; i < this.responsePage * 15 + 14; ++i) {
            if (this.currentDialogueNode.getResponse(this.responseTab, i) == null) continue;
            this.responsePointer = i;
            break;
        }
    }

    private void checkForResponsePage() {
        for (int i = this.responsePage * 15; i < this.responsePage * 15 + 14; ++i) {
            if (this.currentDialogueNode.getResponse(this.responseTab, i) == null) continue;
            return;
        }
        this.responsePage = 0;
    }

    public boolean decrementResponseTab() {
        for (int i = -1; i > -6; --i) {
            if (this.currentDialogueNode.getResponseTabTitle(this.responseTab + i) == null) continue;
            this.responseTab += i;
            this.checkForResponsePage();
            return true;
        }
        return false;
    }

    public boolean incrementResponseTab() {
        for (int i = 1; i < 6; ++i) {
            if (this.currentDialogueNode.getResponseTabTitle(this.responseTab + i) == null) continue;
            this.responseTab += i;
            this.checkForResponsePage();
            return true;
        }
        return false;
    }

    private void checkForResponseTab() {
        if (this.currentDialogueNode.getResponseTabTitle(this.responseTab) == null) {
            this.responseTab = 0;
        }
    }

    public void updateResponses() {
        String content = this.getResponsesDiv(Main.game.getCurrentDialogueNode(), false);
        content = content.replaceAll("\r", "");
        content = content.replaceAll("\n", "");
        content = content.replaceAll("\"", "'");
        Main.mainController.getWebEngine().executeScript("document.getElementById('RESPONSE_BOX').innerHTML = \"" + content + "\"");
        MainController.setResponseEventListeners();
    }

    private String getResponsesDiv(DialogueNode node) {
        return this.getResponsesDiv(node, true);
    }

    private String getResponsesDiv(DialogueNode node, boolean withPointerReset) {
        if (withPointerReset) {
            this.resetResponsePointer();
        }
        this.choicesDialogueSB = new StringBuilder();
        this.choicesDialogueSB.append("<div id='RESPONSE_BOX'>");
        if (node.getResponseTabTitle(0) != null && !node.getResponseTabTitle(0).isEmpty()) {
            this.choicesDialogueSB.append("<div class='response-container tabs'>");
            int responsePageCounter = 0;
            while (node.getResponseTabTitle(responsePageCounter) != null) {
                this.choicesDialogueSB.append("<div class='response-tab" + (this.responseTab == responsePageCounter ? " selected'" : "'") + (String)(this.isResponseTabEmpty(node, responsePageCounter) ? "style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'" : (this.responseTab == responsePageCounter ? "" : "style='color:" + PresetColour.TEXT_HALF_GREY.toWebHexString() + ";'")) + " id='tab_" + responsePageCounter + "'>" + (String)(responsePageCounter == this.responseTab - 1 ? "<b class='hotkey-icon'>" + (Main.getProperties().hotkeyMapPrimary.get((Object)KeyboardAction.RESPOND_PREVIOUS_TAB) == null ? "" : Main.getProperties().hotkeyMapPrimary.get((Object)KeyboardAction.RESPOND_PREVIOUS_TAB).getFullName()) + "</b>" : (responsePageCounter == this.responseTab + 1 ? "<b class='hotkey-icon'>" + (Main.getProperties().hotkeyMapPrimary.get((Object)KeyboardAction.RESPOND_NEXT_TAB) == null ? "" : Main.getProperties().hotkeyMapPrimary.get((Object)KeyboardAction.RESPOND_NEXT_TAB).getFullName()) + "</b>" : "")) + UtilText.parse(node.getResponseTabTitle(responsePageCounter), new ParserTag[0]) + "</div>");
                ++responsePageCounter;
            }
            this.choicesDialogueSB.append("</div>");
        } else {
            this.responseTab = 0;
        }
        this.choicesDialogueSB.append("<div class='response-full-container'>");
        if (this.responsePage > 0) {
            this.choicesDialogueSB.append("<div class='response-switcher left' id='switch_left'><b class='hotkey-icon'>" + (Main.getProperties().hotkeyMapPrimary.get((Object)KeyboardAction.RESPOND_PREVIOUS_PAGE) == null ? "" : Main.getProperties().hotkeyMapPrimary.get((Object)KeyboardAction.RESPOND_PREVIOUS_PAGE).getFullName()) + "</b>&#60</div>");
        } else {
            this.choicesDialogueSB.append("<div class='response-switcher left disabled' id='switch_left'><b class='hotkey-icon disabled'>" + (Main.getProperties().hotkeyMapPrimary.get((Object)KeyboardAction.RESPOND_PREVIOUS_PAGE) == null ? "" : Main.getProperties().hotkeyMapPrimary.get((Object)KeyboardAction.RESPOND_PREVIOUS_PAGE).getFullName()) + "</b><span class='option-disabled'>&#60</span></div>");
        }
        this.choicesDialogueSB.append("<div class='response-container'>");
        if (this.responsePage == 0) {
            for (int i = 1; i < 15; ++i) {
                Response response = node.getResponse(this.responseTab, i);
                if (response != null) {
                    this.choicesDialogueSB.append(this.getResponseBoxDiv(response, i));
                    continue;
                }
                this.choicesDialogueSB.append("<div class='response-box disabled" + (this.responsePointer == i ? " selected" : "") + "' id='option_" + i + "'><b class='hotkey-icon disabled'>" + this.getResponseHotkey(i) + "</b></div>");
            }
            Response response = node.getResponse(this.responseTab, 0);
            if (response != null) {
                this.choicesDialogueSB.append(this.getResponseBoxDiv(response, 0));
            } else {
                this.choicesDialogueSB.append("<div class='response-box disabled" + (this.responsePointer == 0 ? " selected" : "") + "' id='option_0'><b class='hotkey-icon disabled'>" + this.getResponseHotkey(0) + "</b></div>");
            }
        } else {
            for (int i = 0; i < 14; ++i) {
                Response response = node.getResponse(this.responseTab, i + this.responsePage * 15);
                if (response != null) {
                    this.choicesDialogueSB.append(this.getResponseBoxDiv(response, i + 1));
                    continue;
                }
                this.choicesDialogueSB.append("<div class='response-box disabled" + (this.responsePointer - this.responsePage * 15 == i ? " selected" : "") + "' id='option_" + (i + 1) + "'><b class='hotkey-icon disabled'>" + this.getResponseHotkey(i + 1) + "</b></div>");
            }
            Response response = node.getResponse(this.responseTab, 14 + this.responsePage * 15);
            if (response != null) {
                this.choicesDialogueSB.append(this.getResponseBoxDiv(response, 0));
            } else {
                this.choicesDialogueSB.append("<div class='response-box disabled" + (this.responsePointer - (this.responsePage + 1) * 15 + 1 == 0 ? " selected" : "") + "' id='option_0'><b class='hotkey-icon disabled'>" + this.getResponseHotkey(0) + "</b></div>");
            }
        }
        this.choicesDialogueSB.append("</div>");
        if (node.getResponse(this.responseTab, (this.responsePage + 1) * 15) != null) {
            this.choicesDialogueSB.append("<div class='response-switcher right' id='switch_right'><b class='hotkey-icon'>" + (Main.getProperties().hotkeyMapPrimary.get((Object)KeyboardAction.RESPOND_NEXT_PAGE) == null ? "" : Main.getProperties().hotkeyMapPrimary.get((Object)KeyboardAction.RESPOND_NEXT_PAGE).getFullName()) + "</b>&#62</div>");
        } else {
            this.choicesDialogueSB.append("<div class='response-switcher right disabled' id='switch_right'><b class='hotkey-icon disabled'>" + (Main.getProperties().hotkeyMapPrimary.get((Object)KeyboardAction.RESPOND_NEXT_PAGE) == null ? "" : Main.getProperties().hotkeyMapPrimary.get((Object)KeyboardAction.RESPOND_NEXT_PAGE).getFullName()) + "</b><span class='option-disabled'>&#62</span></div>");
        }
        this.choicesDialogueSB.append("</div>");
        this.choicesDialogueSB.append("</div>");
        return this.choicesDialogueSB.toString();
    }

    private boolean isResponseTabEmpty(DialogueNode node, int responseTab) {
        for (int i = 1; i < 15; ++i) {
            if (node.getResponse(responseTab, i) == null) continue;
            return false;
        }
        return true;
    }

    public String formatContentForAutomaticClipboard(String input) {
        input = input.replaceAll("\t", "");
        input = input.replaceAll("\n", "");
        input = input.replaceAll("</p><p>", "\n\n");
        input = input.replaceAll("<(.*?)>", "");
        return input;
    }

    public String getContentForClipboard() {
        Object content;
        try {
            content = this.currentDialogueNode.getContent();
        }
        catch (Exception ex) {
            content = "<p style='text-align:center;'>[style.italicsBad(Error: getContent() method is throwing an exception in the node: '" + this.currentDialogueNode.getLabel() + "')]</p>";
            content = (String)content + "<p style='font-size:0.75em;'>";
            for (StackTraceElement ste : ex.getStackTrace()) {
                content = (String)content + "<br/>" + ste.toString();
            }
            content = (String)content + "</p>";
            ex.printStackTrace();
        }
        return "<body style='background:#1e1e20; color:#DDD; font-family:Calibri;'><style>.speech:before { content: '\"'; }.speech:after { content: '\"'; }</style><h4 style='text-align:center; font-size:1.4em;'>" + this.getDialogueTitle() + "</h4><div style='max-width:800px; margin:0 auto;'>" + (String)(this.currentDialogueNode.getHeaderContent() != null ? "<div id='header-content'>" + this.currentDialogueNode.getHeaderContent() + "</div>" : "") + (String)(content != null ? "<div id='text-content' style='font-size:" + Main.getProperties().fontSize + "px; line-height:" + (Main.getProperties().fontSize + 6) + "px;" + (this.requiresYScroll(this.currentDialogueNode) ? " overflow-y:scroll; overflow-x:hidden;" : "") + "'>" + this.textStartStringBuilder.toString() + this.pastDialogueSB.toString() + this.textEndStringBuilder.toString() + "</div>" : "") + "</div></div><p style='text-align:center;font-size:0.6em;color:#777;'>\u5f53\u524d\u5bf9\u8bdd\u7684\u4f5c\u8005\u4e3a:" + this.currentDialogueNode.getAuthor() + " for<i>Lilith's Throne v0.4.11.3</i></p></body>";
    }

    private String getResponseBoxDiv(Response response, int option) {
        Object style = "";
        Object iconLeftBottom = "";
        Object iconLeftTop = "";
        Object iconRightBottom = "";
        Object iconRightTop = "";
        boolean responseDisabled = false;
        if (response.disabledOnNullDialogue() && response.getNextDialogue() == null) {
            responseDisabled = true;
        } else if (response.isActionCorrupting()) {
            iconLeftBottom = response.isAvailableFromFetishes() ? "<div class='response-icon-leftBottom' style='filter:grayscale(100%);opacity:0.5;'>" + SVGImages.SVG_IMAGE_PROVIDER.getResponseCorruptionBypass() + "</div>" : "<div class='response-icon-leftBottom'>" + SVGImages.SVG_IMAGE_PROVIDER.getResponseCorruptionBypass() + "</div>";
        } else if (response.hasRequirements()) {
            responseDisabled = !response.isAvailable();
        }
        if (response.getSexPace() != null) {
            switch (response.getSexPace()) {
                case DOM_GENTLE: {
                    iconLeftTop = "<div class='response-icon-leftTop'>" + SVGImages.SVG_IMAGE_PROVIDER.getResponseDomGentle() + "</div>";
                    break;
                }
                case DOM_NORMAL: {
                    iconLeftTop = "<div class='response-icon-leftTop'>" + SVGImages.SVG_IMAGE_PROVIDER.getResponseDomNormal() + "</div>";
                    break;
                }
                case DOM_ROUGH: {
                    iconLeftTop = "<div class='response-icon-leftTop'>" + SVGImages.SVG_IMAGE_PROVIDER.getResponseDomRough() + "</div>";
                    break;
                }
                case SUB_EAGER: {
                    iconLeftTop = "<div class='response-icon-leftTop'>" + SVGImages.SVG_IMAGE_PROVIDER.getResponseSubEager() + "</div>";
                    break;
                }
                case SUB_NORMAL: {
                    iconLeftTop = "<div class='response-icon-leftTop'>" + SVGImages.SVG_IMAGE_PROVIDER.getResponseSubNormal() + "</div>";
                    break;
                }
                case SUB_RESISTING: {
                    iconLeftTop = "<div class='response-icon-leftTop'>" + SVGImages.SVG_IMAGE_PROVIDER.getResponseSubResist() + "</div>";
                }
            }
        }
        if (response instanceof ResponseSex && ((ResponseSex)response).isNonConWarning()) {
            iconRightTop = "<div class='response-icon-rightTop'>" + SVGImages.SVG_IMAGE_PROVIDER.getResponseSubResist() + "</div>";
        }
        if (response.isSexActionSwitch()) {
            iconRightBottom = "<div class='response-icon-rightBottom'>" + SVGImages.SVG_IMAGE_PROVIDER.getResponseSexSwitch() + "</div>";
        } else if (response.getSexActionType() == SexActionType.START_ADDITIONAL_ONGOING) {
            iconRightBottom = "<div class='response-icon-rightBottom'>" + SVGImages.SVG_IMAGE_PROVIDER.getResponseSexAdditional() + "</div>";
        }
        float fontSize = 1.0f;
        String strippedTitle = UtilText.parse(response.getTitle(), new ParserTag[0]).replaceAll("<.*?>", "").replaceAll(UtilText.getCurrencySymbol(), "1");
        if (strippedTitle.length() > 14) {
            int overflow = strippedTitle.length() - 14;
            fontSize = overflow <= 10 ? (fontSize -= (float)overflow * 0.03f) : (fontSize -= (float)overflow * 0.025f);
        }
        style = "style='font-size:" + fontSize + "em;'";
        if (response.getHighlightColour() != PresetColour.TEXT) {
            style = "style='color:" + response.getHighlightColour().toWebHexString() + "; font-size:" + fontSize + "em;'";
        }
        String titleText = UtilText.parse(response.getTitle(), new ParserTag[0]);
        if (this.responsePage == 0) {
            return "<div class='response-box" + (this.responsePointer == option ? " selected" : "") + "' id='option_" + option + "'><b class='hotkey-icon'>" + this.getResponseHotkey(option) + "</b><p class='response-text" + (this.responsePointer == option ? " selected" : "") + "' " + (String)style + ">" + (!responseDisabled ? titleText : UtilText.getDisabledResponse(titleText)) + "</p>" + (String)iconLeftTop + (String)iconLeftBottom + (String)iconRightTop + (String)iconRightBottom + "</div>";
        }
        if (option == 0) {
            return "<div class='response-box" + (this.responsePointer - (this.responsePage + 1) * 15 + 1 == option ? " selected" : "") + "' id='option_" + option + "'><b class='hotkey-icon'>" + this.getResponseHotkey(option) + "</b><p class='response-text" + (this.responsePointer - (this.responsePage + 1) * 15 + 1 == option ? " selected" : "") + "' " + (String)style + ">" + (!responseDisabled ? titleText : UtilText.getDisabledResponse(titleText)) + "</p>" + (String)iconLeftTop + (String)iconLeftBottom + (String)iconRightTop + (String)iconRightBottom + "</div>";
        }
        return "<div class='response-box" + (this.responsePointer - this.responsePage * 15 + 1 == option ? " selected" : "") + "' id='option_" + option + "'><b class='hotkey-icon'>" + this.getResponseHotkey(option) + "</b><p class='response-text" + (this.responsePointer - this.responsePage * 15 + 1 == option ? " selected" : "") + "' " + (String)style + ">" + (!responseDisabled ? titleText : UtilText.getDisabledResponse(titleText)) + "</p>" + (String)iconLeftTop + (String)iconLeftBottom + (String)iconRightTop + (String)iconRightBottom + "</div>";
    }

    private String getResponseHotkey(int i) {
        if (0 > i || i > 14) {
            return "";
        }
        KeyboardAction[] keyboardActions = new KeyboardAction[]{KeyboardAction.RESPOND_0, KeyboardAction.RESPOND_1, KeyboardAction.RESPOND_2, KeyboardAction.RESPOND_3, KeyboardAction.RESPOND_4, KeyboardAction.RESPOND_5, KeyboardAction.RESPOND_6, KeyboardAction.RESPOND_7, KeyboardAction.RESPOND_8, KeyboardAction.RESPOND_9, KeyboardAction.RESPOND_10, KeyboardAction.RESPOND_11, KeyboardAction.RESPOND_12, KeyboardAction.RESPOND_13, KeyboardAction.RESPOND_14};
        KeyboardAction currentAction = keyboardActions[i];
        KeyCodeWithModifiers hotkeyForCurrentAction = Main.getProperties().hotkeyMapPrimary.get((Object)currentAction);
        if (hotkeyForCurrentAction == null) {
            return "";
        }
        return hotkeyForCurrentAction.asHotkey();
    }

    public void responseNavigationUp() {
        int minIndex = this.responsePage * 15;
        if (this.responsePointer == 0) {
            this.responsePointer = 10;
        } else if (this.responsePointer > minIndex + 5) {
            this.responsePointer -= 5;
        }
        Main.game.updateResponses();
    }

    public void responseNavigationDown() {
        int maxIndex = this.responsePage * 15 + 15 - 1;
        if (this.responsePointer == 10) {
            this.responsePointer = 0;
        } else if (this.responsePointer <= maxIndex - 5 && this.responsePointer != 0) {
            this.responsePointer += 5;
        }
        Main.game.updateResponses();
    }

    public void responseNavigationLeft() {
        if (this.responsePage == 0) {
            int minIndex = this.responsePointer - (this.responsePointer - 1) % 5;
            if (this.responsePointer == 0) {
                this.responsePointer = 14;
            } else if (this.responsePointer > minIndex) {
                --this.responsePointer;
            }
        } else {
            int minIndex = this.responsePointer / 5 * 5;
            if (this.responsePointer > minIndex) {
                --this.responsePointer;
            }
        }
        Main.game.updateResponses();
    }

    public void responseNavigationRight() {
        if (this.responsePage == 0) {
            int maxIndex = this.responsePointer + (4 - (this.responsePointer - 1) % 5);
            if (this.responsePointer == 14) {
                this.responsePointer = 0;
            } else if (this.responsePointer < maxIndex && this.responsePointer != 0) {
                ++this.responsePointer;
            }
        } else {
            int maxIndex = (this.responsePointer / 5 + 1) * 5;
            if (this.responsePointer < maxIndex - 1) {
                ++this.responsePointer;
            }
        }
        Main.game.updateResponses();
    }

    public void saveDialogueNode() {
        this.savedDialogue = this.currentDialogue;
        this.savedDialogueNode = this.currentDialogueNode;
        this.previousPastDialogueSBContents = this.pastDialogueSB.toString();
        this.savedResponseTab = this.responseTab;
    }

    public void flashMessage(Colour colour, String text) {
        try {
            Main.mainController.getWebEngine().executeScript("\"use strict\";document.getElementById('bottom-text').innerHTML=\"<span style='color:" + colour.toWebHexString() + ";'>" + text + "</span>\";try{timer;} catch(e){var timer=false;}if(!timer) {document.getElementById('bottom-text').classList.add('demo');timer = true;timer = setTimeout(function(){document.getElementById('bottom-text').classList.remove('demo');timer = false;}, 2000);}");
        }
        catch (Exception ex) {
            System.err.println("var timer not found...");
        }
    }

    public void restoreSavedContent(boolean regenerateSceneDialogue) {
        this.positionAnchor = this.initialPositionAnchor;
        this.dialogueTitle = UtilText.parse(this.savedDialogueNode.getLabel(), new ParserTag[0]);
        this.responseTab = this.savedResponseTab;
        this.currentDialogueNode = this.savedDialogueNode;
        if (Main.game.isInSex()) {
            Main.sex.recalculateSexActions();
        }
        if (this.currentDialogueNode.reloadOnRestore() || regenerateSceneDialogue) {
            Object content;
            String headerContent = this.currentDialogueNode.getHeaderContent();
            try {
                content = this.currentDialogueNode.getContent();
            }
            catch (Exception ex) {
                content = "<p style='text-align:center;'>[style.italicsBad(Error: getContent() method is throwing an exception in the node: '" + this.currentDialogueNode.getLabel() + "')]</p>";
                content = (String)content + "<p style='font-size:0.75em;'>";
                for (StackTraceElement ste : ex.getStackTrace()) {
                    content = (String)content + "<br/>" + ste.toString();
                }
                content = (String)content + "</p>";
                ex.printStackTrace();
            }
            this.currentDialogue = "<div id='main-content'>" + this.getTitleDiv(this.getDialogueTitle()) + "<div class='div-center' id='content-block'>" + this.getMapDiv() + (String)(headerContent != null ? "<div id='header-content' style='font-size:" + Main.getProperties().fontSize + "px; line-height:" + (Main.getProperties().fontSize + 6) + "px;-webkit-user-select: none;'>" + (this.currentDialogueNode.disableHeaderParsing() ? headerContent : UtilText.parse(headerContent, new ParserTag[0])) + "</div>" : "") + (String)(content != null ? "<div " + (Main.getProperties().hasValue(PropertyValue.fadeInText) ? "id='text-content'" : "") + " style='font-size:" + Main.getProperties().fontSize + "px; line-height:" + (Main.getProperties().fontSize + 6) + "px;'>" + (String)content + "</div>" : "") + "</div><div id='bottom-text'>\u6e38\u620f\u5df2\u4fdd\u5b58\uff01</div>" + this.getResponsesDiv(this.currentDialogueNode) + "</div></body>";
        } else {
            this.currentDialogue = this.savedDialogue;
        }
        this.pastDialogueSB.setLength(0);
        this.pastDialogueSB.append(this.previousPastDialogueSBContents);
        if (Main.getProperties().fontSize == 15) {
            this.currentDialogue = this.currentDialogue.replaceFirst("<div class='div-center' style='font-size:24px'; line-height:30px;'>", "<div class='div-center' style='font-size:15px'; line-height:21px;'>");
            this.currentDialogue = this.currentDialogue.replaceFirst("<div class='div-center' style='font-size:36px'; line-height:42px;'>", "<div class='div-center' style='font-size:15px'; line-height:21px;'>");
        } else if (Main.getProperties().fontSize == 24) {
            this.currentDialogue = this.currentDialogue.replaceFirst("<div class='div-center' style='font-size:15px; line-height:21px;'>", "<div class='div-center' style='font-size:24px; line-height:30px;'>");
            this.currentDialogue = this.currentDialogue.replaceFirst("<div class='div-center' style='font-size:36px; line-height:42px;'>", "<div class='div-center' style='font-size:24px; line-height:30px;'>");
        } else if (Main.getProperties().fontSize == 36) {
            this.currentDialogue = this.currentDialogue.replaceFirst("<div class='div-center' style='font-size:15px; line-height:21px;'>", "<div class='div-center' style='font-size:36px; line-height:42px;'>");
            this.currentDialogue = this.currentDialogue.replaceFirst("<div class='div-center' style='font-size:24px; line-height:30px;'>", "<div class='div-center' style='font-size:36px; line-height:42px;'>");
        }
        this.setMainContentRegex(this.savedDialogueNode.getDialogueNodeType() != DialogueNodeType.PHONE && this.savedDialogueNode.getDialogueNodeType() != DialogueNodeType.CHARACTERS_PRESENT ? "<body onLoad='scrollToElement()' style='" + this.getBodyStyle() + "'><script>function scrollToElement() {document.getElementById('content-block').scrollTop = document.getElementById('position" + this.positionAnchor + "').offsetTop -64;}</script>" : "<body style='" + this.getBodyStyle() + "'>", this.currentDialogue);
        this.textEndStringBuilder.setLength(0);
        this.textStartStringBuilder.setLength(0);
        Main.game.endTurn(0);
    }

    private void setMainContentRegex(String prefix, String currentDialogue) {
        String sanitizedDialogue = currentDialogue.replaceAll("\\.\\.\\.", "&hellip;");
        if (this.currentDialogueNode != DebugDialogue.PARSER) {
            sanitizedDialogue = sanitizedDialogue.replaceAll("\\.([\\D])", ".\u200b$1").replaceAll("\\[", "\u200b[\u200b");
        }
        Main.mainController.setMainContent(prefix + sanitizedDialogue);
    }

    public List<NPC> getCharactersPresent() {
        if (this.player == null) {
            return new ArrayList<NPC>();
        }
        return this.getCharactersPresent(this.player.getWorldLocation(), this.player.getLocation());
    }

    public List<NPC> getNonCompanionCharactersPresent(boolean includeUniqueNPCs) {
        ArrayList<NPC> nonCompanionCharactersPresent = new ArrayList<NPC>();
        nonCompanionCharactersPresent.addAll(this.getCharactersPresent());
        nonCompanionCharactersPresent.removeIf(npc -> (Main.game.getPlayer().hasCompanion((GameCharacter)npc) || npc.getPartyLeader() != null && Main.game.getPlayer().hasCompanion(npc.getPartyLeader())) && (includeUniqueNPCs || !npc.isUnique()));
        return nonCompanionCharactersPresent;
    }

    public List<NPC> getNonCompanionCharactersPresent() {
        return this.getNonCompanionCharactersPresent(true);
    }

    public List<NPC> getNonCompanionCharactersPresent(Cell cell, boolean includeUniqueNPCs) {
        ArrayList<NPC> nonCompanionCharactersPresent = new ArrayList<NPC>();
        nonCompanionCharactersPresent.addAll(this.getCharactersPresent(cell));
        nonCompanionCharactersPresent.removeIf(npc -> (Main.game.getPlayer().hasCompanion((GameCharacter)npc) || npc.getPartyLeader() != null && Main.game.getPlayer().hasCompanion(npc.getPartyLeader())) && (includeUniqueNPCs || !npc.isUnique()));
        return nonCompanionCharactersPresent;
    }

    public List<NPC> getNonCompanionCharactersPresent(Cell cell) {
        return this.getNonCompanionCharactersPresent(cell, true);
    }

    public List<NPC> getCharactersTreatingCellAsHome() {
        return this.getCharactersTreatingCellAsHome(Main.game.getPlayerCell());
    }

    public List<NPC> getCharactersTreatingCellAsHome(Cell cell) {
        ArrayList<NPC> charactersHome = new ArrayList<NPC>();
        if (cell.getCharactersHomeIds() != null) {
            HashSet<String> ids = new HashSet<String>(cell.getCharactersHomeIds());
            for (String id : ids) {
                try {
                    GameCharacter character = this.getNPCById(id);
                    if (!(character instanceof NPC)) continue;
                    charactersHome.add((NPC)character);
                }
                catch (Exception e) {
                    if (!Main.game.isStarted()) continue;
                    System.err.println("Failed to load character present home: " + id);
                    cell.removeCharacterHomeId(id);
                }
            }
        }
        charactersHome.sort((c1, c2) -> c2.getLevel() - c1.getLevel() == 0 ? c2.getName(true).compareTo(c1.getName(true)) : c2.getLevel() - c1.getLevel());
        return charactersHome;
    }

    public List<NPC> getCharactersPresent(AbstractWorldType worldType, AbstractPlaceType placeType) {
        Cell cell = this.worlds.get(worldType).getCell(placeType);
        return this.getCharactersPresent(cell);
    }

    public List<NPC> getCharactersPresent(Cell cell) {
        return this.getCharactersPresent(cell.getType(), cell.getLocation());
    }

    public List<NPC> getCharactersPresent(AbstractWorldType worldType, Vector2i location) {
        ArrayList<NPC> charactersPresent = new ArrayList<NPC>();
        if (this.getWorlds().get(worldType).getCell(location).getCharactersPresentIds() != null) {
            HashSet<String> ids = new HashSet<String>(this.getWorlds().get(worldType).getCell(location).getCharactersPresentIds());
            for (String id : ids) {
                try {
                    GameCharacter character = this.getNPCById(id);
                    if (!(character instanceof NPC)) continue;
                    charactersPresent.add((NPC)character);
                }
                catch (Exception e) {
                    if (!Main.game.isStarted()) continue;
                    System.err.println("Failed to load character present: " + id);
                    this.getWorlds().get(worldType).getCell(location).removeCharacterPresentId(id);
                }
            }
        }
        try {
            charactersPresent.sort((c1, c2) -> c2.getLevel() - c1.getLevel() == 0 ? c2.getNameIgnoresPlayerKnowledge().compareTo(c1.getNameIgnoresPlayerKnowledge()) : c2.getLevel() - c1.getLevel());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return charactersPresent;
    }

    public int getModifierTravelTime(boolean onLand, int time) {
        int maxTime = 0;
        for (GameCharacter character : Main.game.getPlayer().getParty()) {
            int speed = onLand ? character.getLandSpeedModifier() : character.getWaterSpeedModifier();
            int travelTime = time;
            travelTime = (int)((float)travelTime * ((float)(100 + speed) / 100.0f));
            if (time > 0) {
                travelTime = Math.max(1, travelTime);
            }
            if (Math.abs(travelTime) <= maxTime) continue;
            maxTime = travelTime;
        }
        return maxTime;
    }

    public String getWeatherImage() {
        if (this.isDayTime()) {
            switch (this.currentWeather) {
                case CLEAR: {
                    return SVGImages.SVG_IMAGE_PROVIDER.getWeatherDayClear();
                }
                case CLOUD: {
                    return SVGImages.SVG_IMAGE_PROVIDER.getWeatherDayCloud();
                }
                case RAIN: {
                    return SVGImages.SVG_IMAGE_PROVIDER.getWeatherDayRain();
                }
                case SNOW: {
                    return SVGImages.SVG_IMAGE_PROVIDER.getWeatherDaySnow();
                }
                case MAGIC_STORM_GATHERING: {
                    return SVGImages.SVG_IMAGE_PROVIDER.getWeatherDayStormIncoming();
                }
                case MAGIC_STORM: {
                    return SVGImages.SVG_IMAGE_PROVIDER.getWeatherDayStorm();
                }
            }
        } else {
            switch (this.currentWeather) {
                case CLEAR: {
                    return SVGImages.SVG_IMAGE_PROVIDER.getWeatherNightClear();
                }
                case CLOUD: {
                    return SVGImages.SVG_IMAGE_PROVIDER.getWeatherNightCloud();
                }
                case RAIN: {
                    return SVGImages.SVG_IMAGE_PROVIDER.getWeatherNightRain();
                }
                case SNOW: {
                    return SVGImages.SVG_IMAGE_PROVIDER.getWeatherNightSnow();
                }
                case MAGIC_STORM_GATHERING: {
                    return SVGImages.SVG_IMAGE_PROVIDER.getWeatherNightStormIncoming();
                }
                case MAGIC_STORM: {
                    return SVGImages.SVG_IMAGE_PROVIDER.getWeatherNightStorm();
                }
            }
        }
        return "";
    }

    public int getWeatherTimeRemainingInSeconds() {
        return this.weatherTimeRemainingInSeconds;
    }

    public String getWeatherTimeRemainingAsTimeString() {
        long minutes = this.weatherTimeRemainingInSeconds / 60;
        long hours = minutes / 60L;
        return hours / 24L + "\u5929" + hours % 24L + "\u5c0f\u65f6" + minutes % 60L + "\u5206\u949f";
    }

    public void setWeatherInSeconds(Weather weather, int secondsRemaining) {
        this.currentWeather = weather;
        this.weatherTimeRemainingInSeconds = secondsRemaining;
    }

    public long getId() {
        return this.id;
    }

    public World getActiveWorld() {
        this.worlds.size();
        this.player.isFeminine();
        return this.worlds.get(this.player.getWorldLocation());
    }

    public Map<AbstractWorldType, World> getWorlds() {
        return this.worlds;
    }

    public void setPlayer(PlayerCharacter player) {
        this.player = player;
    }

    public PlayerCharacter getPlayer() {
        return this.player;
    }

    public ItemGeneration getItemGen() {
        return this.itemGeneration;
    }

    public CharacterUtils getCharacterUtils() {
        return this.characterUtils;
    }

    public long getSecondsPassed() {
        return this.secondsPassed;
    }

    public long getMinutesPassed() {
        return this.secondsPassed / 60L;
    }

    public int getMinutesUntilNextSunrise() {
        LocalDateTime[] sunriseSunset;
        int minutesPassed = Main.game.getDayMinutes();
        return (minutesPassed < (sunriseSunset = DateAndTime.getTimeOfSolarElevationChange(Main.game.getDateNow(), SolarElevationAngle.SUN_ALTITUDE_SUNRISE_SUNSET, 51.4934, 0.0))[0].get(ChronoField.MINUTE_OF_DAY) ? sunriseSunset[0].get(ChronoField.MINUTE_OF_DAY) : 1440 + sunriseSunset[0].get(ChronoField.MINUTE_OF_DAY)) - minutesPassed + 1;
    }

    public int getMinutesUntilNextSunset() {
        LocalDateTime[] sunriseSunset;
        int minutesPassed = Main.game.getDayMinutes();
        return (minutesPassed < (sunriseSunset = DateAndTime.getTimeOfSolarElevationChange(Main.game.getDateNow(), SolarElevationAngle.SUN_ALTITUDE_SUNRISE_SUNSET, 51.4934, 0.0))[1].get(ChronoField.MINUTE_OF_DAY) ? sunriseSunset[1].get(ChronoField.MINUTE_OF_DAY) : 1440 + sunriseSunset[1].get(ChronoField.MINUTE_OF_DAY)) - minutesPassed + 1;
    }

    public int getMinutesUntilNextMorningOrEvening() {
        if (Main.game.isDayTime()) {
            return this.getMinutesUntilNextSunset();
        }
        return this.getMinutesUntilNextSunrise();
    }

    public int getSunriseTimeInMinutes() {
        LocalDateTime[] sunriseSunset = DateAndTime.getTimeOfSolarElevationChange(Main.game.getDateNow(), SolarElevationAngle.SUN_ALTITUDE_SUNRISE_SUNSET, 51.4934, 0.0);
        return sunriseSunset[0].get(ChronoField.MINUTE_OF_DAY);
    }

    public int getSunsetTimeInMinutes() {
        LocalDateTime[] sunriseSunset = DateAndTime.getTimeOfSolarElevationChange(Main.game.getDateNow(), SolarElevationAngle.SUN_ALTITUDE_SUNRISE_SUNSET, 51.4934, 0.0);
        return sunriseSunset[1].get(ChronoField.MINUTE_OF_DAY);
    }

    public LocalDateTime getStartingDate() {
        return this.startingDate;
    }

    public void applyStartingDateChange() {
        this.startingDate = this.startingDate.plusYears(3L);
        for (NPC npc : Main.game.getAllNPCs()) {
            int offset = 0;
            if (this.startingDate.getDayOfYear() < npc.getBirthday().getDayOfYear()) {
                offset = -1;
            }
            npc.setBirthday(npc.getBirthday().plusYears(3 + offset));
        }
    }

    public void incrementStartingDateDays(int days) {
        this.startingDate = this.startingDate.plusDays(days);
    }

    public void setStartingDateMonth(Month month) {
        this.startingDate = this.startingDate.getMonthValue() > month.getValue() ? this.startingDate.minusMonths(this.startingDate.getMonthValue() - month.getValue()) : this.startingDate.plusMonths(month.getValue() - this.startingDate.getMonthValue());
    }

    public LocalDateTime getDateNow() {
        return this.getStartingDate().plusSeconds(Main.game.getSecondsPassed());
    }

    public LocalDateTime getCustomDateTime(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        return LocalDateTime.of(year, month, dayOfMonth, hour, minute, second);
    }

    public LocalDate getCustomDate(int year, int month, int dayOfMonth) {
        return LocalDate.of(year, month, dayOfMonth);
    }

    public LocalTime getCustomTime(int hour, int minute, int second) {
        return LocalTime.of(hour, minute, second);
    }

    public String getDisplayDate(TemporalAccessor dateNow, boolean withYear) {
        if (this.isBadEnd()) {
            return UtilText.parse("[style.colourBad(\u672a\u77e5\u65e5\u671f)]", new ParserTag[0]);
        }
        if (this.isInNewWorld() && !this.getDialogueFlags().hasFlag(DialogueFlagValue.knowsDate)) {
            return UtilText.parse("[style.colourMinorBad(\u672a\u77e5\u65e5\u671f)]", new ParserTag[0]);
        }
        String date = Units.date(dateNow, Units.DateType.LONG);
        if (withYear) {
            return date;
        }
        return date.substring(5, date.length());
    }

    public String getDisplayDate(boolean withYear) {
        return this.getDisplayDate(this.getDateNow(), withYear);
    }

    public String getDisplayDate(TemporalAccessor dateNow) {
        return this.getDisplayDate(dateNow, false);
    }

    public String getDisplayDate() {
        return this.getDisplayDate(this.getDateNow(), false);
    }

    public String getDisplayTime(TemporalAccessor timeNow) {
        return Units.time(timeNow);
    }

    public String getDisplayTime() {
        return this.getDisplayTime(this.getDateNow());
    }

    public int getYear() {
        return Main.game.getDateNow().getYear();
    }

    public long getHour() {
        return Main.game.getMinutesPassed() / 60L;
    }

    public int getHourOfDay() {
        return (int)(this.getHour() % 24L);
    }

    public int getDayMinutes() {
        return (int)(this.getMinutesPassed() % 1440L);
    }

    public int getDaySeconds() {
        return (int)(this.getSecondsPassed() % 86400L);
    }

    public int getMinutesUntilTimeInMinutes(int desiredTime) {
        int timeDifference = desiredTime - this.getDayMinutes();
        if (timeDifference < 0) {
            timeDifference = 1440 - this.getDayMinutes() + desiredTime;
        }
        return timeDifference;
    }

    public boolean isWorkTime() {
        return this.getHourOfDay() >= 9 && this.getHourOfDay() < 17;
    }

    public boolean isExtendedWorkTime() {
        return this.getHourOfDay() >= 6 && this.getHourOfDay() < 22;
    }

    public boolean isSmallHours() {
        return this.getHourOfDay() >= 1 && this.getHourOfDay() < 4;
    }

    public boolean isHourBetween(float startHour, float endHour) {
        int dayMinutes = this.getDayMinutes();
        if (endHour < startHour) {
            endHour += 24.0f;
            if ((float)dayMinutes < startHour * 60.0f) {
                dayMinutes += 1440;
            }
        }
        return (float)dayMinutes >= startHour * 60.0f && (float)dayMinutes < endHour * 60.0f;
    }

    public boolean isDayTime() {
        return this.getCurrentDayPeriod() == DayPeriod.DAY;
    }

    public boolean isWeekend() {
        return this.getDateNow().getDayOfWeek() == DayOfWeek.SATURDAY || this.getDateNow().getDayOfWeek() == DayOfWeek.SUNDAY;
    }

    public DayPeriod getCurrentDayPeriod() {
        return DateAndTime.getDayPeriod(this.getDateNow(), 51.4934, 0.0);
    }

    public DayPeriod getDayPeriodAtHour(int hourOfDay) {
        LocalDateTime ldt = this.getDateNow().withHour(hourOfDay);
        return DateAndTime.getDayPeriod(ldt, 51.4934, 0.0);
    }

    public boolean isMorning() {
        return this.getMinutesPassed() % 1440L >= 0L && this.getMinutesPassed() % 1440L < 720L;
    }

    public boolean isAfternoon() {
        return !this.isMorning();
    }

    public int getDayNumber() {
        return this.getDayNumber(this.getSecondsPassed());
    }

    private int getDayNumber(long seconds) {
        return (int)(1L + seconds / 86400L);
    }

    public DayOfWeek getDayOfWeek() {
        return this.getDateNow().getDayOfWeek();
    }

    public Month getMonth() {
        return this.getDateNow().getMonth();
    }

    public boolean isInCombat() {
        return this.inCombat;
    }

    public void setInCombat(boolean inCombat) {
        this.inCombat = inCombat;
    }

    public boolean isInSex() {
        return this.inSex;
    }

    public void setInSex(boolean inSex) {
        this.inSex = inSex;
    }

    public Encounter getCurrentEncounter() {
        return this.currentEncounter;
    }

    public void setCurrentEncounter(Encounter currentEncounter) {
        this.currentEncounter = currentEncounter;
    }

    public NPC getNpc(Class<? extends NPC> npcClass) {
        try {
            return (NPC)this.getNPCById(this.getUniqueNPCId(npcClass));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("getNpc(" + npcClass.getName() + ") returning null!");
            return null;
        }
    }

    public List<NPC> getOffspring() {
        ArrayList<NPC> offspring = new ArrayList<NPC>();
        for (NPC npc : this.NPCMap.values()) {
            if (!(npc.getMother() != null && npc.getMother().isPlayer() || npc.getFather() != null && npc.getFather().isPlayer()) && (npc.getIncubator() == null || !npc.getIncubator().isPlayer())) continue;
            offspring.add(npc);
        }
        return offspring;
    }

    public List<OffspringSeed> getOffspringNotSpawned(Predicate<OffspringSeed> matcher) {
        return this.getOffspringNotSpawned(matcher, false);
    }

    public List<OffspringSeed> getOffspringNotSpawned(Predicate<OffspringSeed> matcher, boolean includeUnborn) {
        ArrayList<OffspringSeed> offspringAvailable = new ArrayList<OffspringSeed>();
        for (OffspringSeed os : this.OffspringSeedMap.values()) {
            if (!os.isFromPlayer().booleanValue() || !includeUnborn && !os.isBorn().booleanValue()) continue;
            offspringAvailable.add(os);
        }
        return offspringAvailable.stream().filter(matcher).collect(Collectors.toList());
    }

    public List<NPC> getReindeerOverseers() {
        ArrayList<NPC> reindeerOverseers = new ArrayList<NPC>(this.getAllNPCs());
        reindeerOverseers.removeIf(npc -> !npc.getClass().equals(ReindeerOverseer.class));
        return reindeerOverseers;
    }

    public List<NPC> getAllNPCs() {
        return new ArrayList<NPC>(this.NPCMap.values());
    }

    public boolean isCharacterExisting(String id) {
        return this.NPCMap.containsKey(id);
    }

    public GameCharacter getNPCById(String id) throws Exception {
        if (id == null || id.isEmpty()) {
            throw new NullPointerException();
        }
        if (id.equals(Main.game.getPlayer().getId())) {
            return Main.game.getPlayer();
        }
        if (!this.NPCMap.containsKey(id)) {
            throw new NullPointerException();
        }
        return this.NPCMap.get(id);
    }

    public Map<String, NPC> getNPCMap() {
        return this.NPCMap;
    }

    public String getUniqueNPCId(Class<? extends NPC> c) {
        if (c.equals(DarkSiren.class)) {
            return "-1,FortressDemonLeader";
        }
        return "-1," + c.getSimpleName();
    }

    public String getNPCId(Class<? extends NPC> c) {
        return this.npcTally.get() + "," + c.getSimpleName();
    }

    public String getNextNPCId(Class<? extends NPC> c) {
        return this.npcTally.incrementAndGet() + "," + c.getSimpleName();
    }

    public String addNPC(String npcGenerationId, String parserTarget) throws Exception {
        boolean forceImmediateAddition = true;
        NPC npc = null;
        if (npcGenerationId.equalsIgnoreCase("GenericSexualPartner")) {
            npc = new GenericSexualPartner();
        } else if (npcGenerationId.equalsIgnoreCase("EvelyxSexualPartner")) {
            npc = new EvelyxSexualPartner();
        } else if (npcGenerationId.equalsIgnoreCase("LunetteMelee")) {
            npc = new LunetteMelee();
        } else if (npcGenerationId.equalsIgnoreCase("LunetteRanged")) {
            npc = new LunetteRanged();
        } else if (npcGenerationId.equalsIgnoreCase("FieldsBandit")) {
            npc = new FieldsBandit();
        } else if (npcGenerationId.equalsIgnoreCase("EvelyxMilker")) {
            npc = new EvelyxMilker();
        }
        if (npc == null) {
            try {
                npc = (NPC)Class.forName("com.lilithsthrone.game.character.npc." + npcGenerationId).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                System.err.println("Failed to add NPC: " + npcGenerationId);
                ex.printStackTrace();
                return "";
            }
        }
        String idGenerated = this.addNPC(npc, false, forceImmediateAddition);
        if (parserTarget != null && !parserTarget.isEmpty()) {
            ParserTarget.addAdditionalParserTarget(parserTarget, npc);
        }
        return idGenerated;
    }

    public String safeAddNPC(NPC npc, boolean isImported) {
        String id = "";
        try {
            id = this.addNPC(npc, isImported);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return id;
    }

    public String addNPC(NPC npc, boolean isImported) throws Exception {
        return this.addNPC(npc, isImported, false);
    }

    public String addNPC(NPC npc, boolean isImported, boolean forceImmediateAddition) throws Exception {
        if (isImported) {
            int tallyCount;
            String rawId = npc.getId();
            if (rawId.contains("-") && !rawId.contains(",")) {
                String[] split = rawId.split("-");
                tallyCount = Integer.parseInt(split[split.length - 1]);
            } else {
                tallyCount = Integer.parseInt(rawId.split(",")[0]);
            }
            this.npcTally.updateAndGet(x -> Math.max(x, tallyCount));
        } else if (npc.isUnique()) {
            npc.setId(this.getUniqueNPCId(npc.getClass()));
        } else {
            int id = this.npcTally.incrementAndGet();
            npc.setId(id + "," + (npc.getClass().isAnonymousClass() ? npc.getClass().getSuperclass().getSimpleName() : npc.getClass().getSimpleName()));
        }
        if (this.NPCMap.keySet().contains(npc.getId())) {
            throw new Exception("NPC map already contained an NPC with this Id (" + npc.getId() + "). SOMETHING HAS GONE HORRIBLY WRONG! PANIC!");
        }
        if (this.isInNPCUpdateLoop && !forceImmediateAddition) {
            this.npcsToAdd.add(npc);
        } else {
            this.NPCMap.put(npc.getId(), npc);
        }
        npc.setLocation(npc.getWorldLocation(), npc.getLocation(), false);
        npc.setHomeLocation(npc.getHomeWorldLocation(), npc.getHomeLocation());
        return npc.getId();
    }

    public boolean banishNPC(NPC npc) {
        Main.game.getPlayer().removeCompanion(npc);
        for (AbstractClothing clothing : npc.getClothingCurrentlyEquipped()) {
            if (clothing.getRarity() != Rarity.QUEST) continue;
            Main.game.getPlayer().addClothing(clothing, false);
        }
        if (npc.isSlave()) {
            npc.getOwner().removeSlave(npc);
        }
        if (npc.hasSlaves()) {
            for (GameCharacter c : new ArrayList<GameCharacter>(npc.getSlavesOwnedAsCharacters())) {
                npc.removeSlave(c);
            }
        }
        for (NPC loopNpc : Main.game.getAllNPCs()) {
            loopNpc.setAllAreasKnownByCharacter(npc, false);
            loopNpc.setAffection(npc, 0.0f);
        }
        if (npc.isUnique()) {
            for (NPC loopNpc : Main.game.getAllNPCs()) {
                loopNpc.setAllAreasKnownByCharacter(npc, false);
            }
        } else {
            for (NPC loopNpc : Main.game.getAllNPCs()) {
                loopNpc.setAllAreasKnownByCharacter(npc, false);
                if (loopNpc.isUnique()) continue;
                loopNpc.setAffection(npc, 0.0f);
            }
        }
        if (npc.isReadyToBeDeleted()) {
            this.removeNPC(npc);
            return true;
        }
        ParserTarget.removeAdditionalParserTarget(npc);
        npc.setLocation(WorldType.EMPTY, PlaceType.GENERIC_EMPTY_TILE, true);
        npc.resetInventory(true);
        npc.resetAllPregnancyReactions();
        npc.resetPerksMap(false);
        npc.clearFetishes();
        npc.clearFetishDesires();
        npc.clearEquippedMoves();
        npc.clearAddictions();
        npc.clearAllLipstickMarkings();
        for (Iterator<XMLSaving> iterator : CoverableArea.values()) {
            npc.resetAreaKnownByCharacters((CoverableArea)((Object)iterator));
        }
        npc.resetFluidsStored();
        return false;
    }

    public boolean banishNPC(String id) {
        try {
            NPC npc = (NPC)this.getNPCById(id);
            if (npc.equals(Main.game.getNpc(GenericAndrogynousNPC.class))) {
                return false;
            }
            return this.banishNPC(npc);
        }
        catch (Exception e) {
            Util.logGetNpcByIdError("banishNPC()", id);
            return false;
        }
    }

    private void removeNPC(NPC npc) {
        if (npc.isPregnant()) {
            npc.endPregnancy(npc.getPregnantLitter().getFather() != null && npc.getPregnantLitter().getFather().isPlayer());
        } else if (npc.hasStatusEffect(StatusEffect.PREGNANT_0)) {
            npc.removeStatusEffect(StatusEffect.PREGNANT_0);
        }
        if (npc.hasDiscoveredElemental() && npc.getElemental() != null) {
            this.removeNPC(npc.getElemental());
        }
        if (!npc.getIncubatingLitters().isEmpty()) {
            for (SexAreaOrifice orifice : new ArrayList<SexAreaOrifice>(npc.getIncubatingLitters().keySet())) {
                npc.endIncubationPregnancy(orifice, npc.getPregnantLitter().getFather() != null && npc.getIncubationLitter(orifice).getFather().isPlayer() || npc.getPregnantLitter().getMother() != null && npc.getIncubationLitter(orifice).getMother().isPlayer());
            }
        }
        if (this.isInNPCUpdateLoop) {
            this.npcsToRemove.add(npc);
        } else {
            ArrayList<GameCharacter> allCharactersWithPlayer = new ArrayList<GameCharacter>();
            allCharactersWithPlayer.add(Main.game.getPlayer());
            allCharactersWithPlayer.addAll(Main.game.getAllNPCs());
            for (GameCharacter gameCharacter : allCharactersWithPlayer) {
                for (Map.Entry<SexType, Map.Entry<String, String>> entry : gameCharacter.getVirginityLossMap().entrySet()) {
                    if (entry.getValue() == null || !entry.getValue().getKey().equals(npc.getId())) continue;
                    gameCharacter.setBackupVirginityLoss(entry.getKey());
                }
            }
            for (Util.Value value : this.slaveryEventLog) {
                for (SlaveryEventLogEntry slaveryEventLogEntry : (List)value.getValue()) {
                    if (!slaveryEventLogEntry.getSlaveID().equals(npc.getId())) continue;
                    slaveryEventLogEntry.applySlaveDeleted();
                }
            }
            npc.getCell().removeCharacterPresentId(npc.getId());
            npc.getHomeCell().removeCharacterHomeId(npc.getId());
            ParserTarget.removeAdditionalParserTarget(npc);
            this.NPCMap.remove(npc.getId());
        }
    }

    public Map<String, OffspringSeed> getOffspringSeedMap() {
        return this.OffspringSeedMap;
    }

    public OffspringSeed getOffspringSeedById(String id) {
        if (id == null || id.isEmpty()) {
            throw new NullPointerException();
        }
        if (!this.OffspringSeedMap.containsKey(id)) {
            throw new NullPointerException();
        }
        return this.OffspringSeedMap.get(id);
    }

    public String addOffspringSeed(OffspringSeed os, boolean isImported) throws Exception {
        if (isImported) {
            String rawId = os.getId();
            int tallyCount = Integer.parseInt(rawId.split(",")[0]);
            this.offspringSeedTally.updateAndGet(x -> Math.max(x, tallyCount));
        } else {
            int id = this.offspringSeedTally.incrementAndGet();
            os.setId(id + "," + os.getClass().getSimpleName());
        }
        if (this.OffspringSeedMap.keySet().contains(os.getId())) {
            throw new Exception("OffspringSeed map already contained an OffspringSeed with this Id (" + os.getId() + "). SOMETHING HAS GONE HORRIBLY WRONG! PANIC!");
        }
        this.OffspringSeedMap.put(os.getId(), os);
        return os.getId();
    }

    public void removeOffspringSeed(String id) {
        try {
            this.removeOffspringSeed(Main.game.getOffspringSeedById(id));
        }
        catch (Exception e) {
            System.err.println("Trying to remove an OffspringSeed that doesn't exist?");
            e.printStackTrace();
        }
    }

    public void removeOffspringSeed(OffspringSeed os) {
        this.OffspringSeedMap.remove(os.getId());
    }

    public int getNumberOfWitches() {
        int i = 0;
        for (NPC npc : this.NPCMap.values()) {
            if (!(npc instanceof Cultist) || npc.getLocationPlace().getPlaceType().equals(PlaceType.GENERIC_EMPTY_TILE)) continue;
            ++i;
        }
        return i;
    }

    public List<List<String>> getSavedEnforcers(AbstractWorldType worldType) {
        this.savedEnforcers.putIfAbsent(worldType, new ArrayList());
        return this.savedEnforcers.get(worldType);
    }

    public void addSavedEnforcers(AbstractWorldType worldType, List<String> enforcerIds) {
        this.savedEnforcers.putIfAbsent(worldType, new ArrayList());
        this.savedEnforcers.get(worldType).add(enforcerIds);
    }

    public void removeSavedEnforcers(AbstractWorldType worldType, List<String> enforcerIds) {
        this.savedEnforcers.putIfAbsent(worldType, new ArrayList());
        this.savedEnforcers.get(worldType).removeIf(innerList -> !Collections.disjoint(innerList, enforcerIds));
    }

    public NPC getActiveNPC() {
        return this.activeNPC;
    }

    public void setActiveNPC(NPC activeNPC) {
        this.activeNPC = activeNPC;
    }

    public void clearActiveNPC() {
        this.activeNPC = null;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
        if (started) {
            Main.game.handlePostGameInit();
        }
    }

    public boolean isPrologueFinished() {
        return this.getPlayer() != null && this.getPlayer().hasQuest(QuestLine.MAIN) && this.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_PROLOGUE);
    }

    public boolean isInNewWorld() {
        if (Main.game.getPlayer() == null) {
            return true;
        }
        return Main.game.getPlayer().getWorldLocation() != WorldType.EMPTY && Main.game.getPlayer().getWorldLocation() != WorldType.MUSEUM && Main.game.getPlayer().getWorldLocation() != WorldType.MUSEUM_LOST;
    }

    public StringBuilder getTextStartStringBuilder() {
        return this.textStartStringBuilder;
    }

    public void appendToTextStartStringBuilder(String text) {
        this.textStartStringBuilder.append(UtilText.parse(text, new ParserTag[0]));
    }

    public void appendToTextStartStringBuilder(GameCharacter npc, String text) {
        this.textStartStringBuilder.append(UtilText.parse(npc, text, new ParserTag[0]));
    }

    public void appendToTextStartStringBuilder(List<GameCharacter> npcs, String text) {
        this.textStartStringBuilder.append(UtilText.parse(npcs, text, new ParserTag[0]));
    }

    public void clearTextStartStringBuilder() {
        this.textStartStringBuilder.setLength(0);
    }

    public StringBuilder getTextEndStringBuilder() {
        return this.textEndStringBuilder;
    }

    public void appendToTextEndStringBuilder(String text) {
        this.textEndStringBuilder.append(UtilText.parse(text, new ParserTag[0]));
    }

    public void appendToTextEndStringBuilder(GameCharacter npc, String text) {
        this.textEndStringBuilder.append(UtilText.parse(npc, text, new ParserTag[0]));
    }

    public void appendToTextEndStringBuilder(List<GameCharacter> npcs, String text) {
        this.textEndStringBuilder.append(UtilText.parse(npcs, text, new ParserTag[0]));
    }

    public void clearTextEndStringBuilder() {
        this.textEndStringBuilder.setLength(0);
    }

    public boolean isInNeutralDialogue() {
        return !Main.game.getCurrentDialogueNode().isTravelDisabled() && MapTravelType.WALK_SAFE.isAvailable(Main.game.getPlayerCell(), Main.game.getPlayer()) || Main.game.getCurrentDialogueNode().equals(Main.game.getDefaultDialogue(false));
    }

    public DialogueNode getCurrentDialogueNode() {
        return this.currentDialogueNode;
    }

    public String getCurrentDialogue() {
        return this.currentDialogue;
    }

    public DialogueNodeType getMapDisplay() {
        if (this.currentDialogueNode != null) {
            return this.currentDialogueNode.getDialogueNodeType();
        }
        return null;
    }

    public boolean isRenderAttributesSection() {
        return this.renderAttributesSection;
    }

    public void setRenderAttributesSection(boolean renderAttributesSection) {
        this.renderAttributesSection = renderAttributesSection;
    }

    public int getResponsePage() {
        return this.responsePage;
    }

    public void setResponsePage(int responsePage) {
        this.responsePage = responsePage;
    }

    public boolean isHasNextResponsePage() {
        return this.currentDialogueNode.getResponse(this.responseTab, (this.responsePage + 1) * 15) != null;
    }

    public int getResponseTab() {
        return this.responseTab;
    }

    public void setResponseTab(int responseTab) {
        this.responseTab = responseTab;
        this.checkForResponsePage();
    }

    public DialogueNode getSavedDialogueNode() {
        return this.savedDialogueNode;
    }

    public boolean isSavedDialogueNeutral() {
        return !Main.game.getSavedDialogueNode().isTravelDisabled() && MapTravelType.WALK_SAFE.isAvailable(Main.game.getPlayerCell(), Main.game.getPlayer()) || Main.game.getSavedDialogueNode().equals(Main.game.getDefaultDialogue(false));
    }

    public Cell getPlayerCell() {
        return Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation());
    }

    public DialogueManager getDialogueManager() {
        return this.dialogueManager;
    }

    public DialogueFlags getDialogueFlags() {
        return this.dialogueFlags;
    }

    public int getResponsePointer() {
        return this.responsePointer;
    }

    public void setResponsePointer(int responsePointer) {
        this.responsePointer = responsePointer;
    }

    public boolean isPlayerTileFull() {
        return this.getActiveWorld().getCell(this.getPlayer().getLocation()).getInventory().isInventoryFull();
    }

    public String runXmlTest(String pathName) {
        return UtilText.runXmlTest(pathName);
    }

    public boolean isDebugMode() {
        return Main.getProperties().hasValue(PropertyValue.debugMode);
    }

    public boolean isLightTheme() {
        return Main.getProperties().hasValue(PropertyValue.lightTheme);
    }

    public boolean isAllStickersUnlocked() {
        return Main.getProperties().hasValue(PropertyValue.allStickersUnlocked);
    }

    public boolean isMetricSizes() {
        return Main.getProperties().hasValue(PropertyValue.metricSizes);
    }

    public boolean isMetricWeights() {
        return Main.getProperties().hasValue(PropertyValue.metricWeights);
    }

    public boolean isMetricFluids() {
        return Main.getProperties().hasValue(PropertyValue.metricFluids);
    }

    public boolean isMapReveal() {
        return Main.getProperties().hasValue(PropertyValue.mapReveal);
    }

    public boolean isConcealedSlotsReveal() {
        return Main.getProperties().hasValue(PropertyValue.concealedSlotsReveal);
    }

    public boolean isEnchantmentCapacityEnabled() {
        return Main.getProperties().hasValue(PropertyValue.enchantmentLimits);
    }

    public boolean isLevelDrainContentEnabled() {
        return Main.getProperties().hasValue(PropertyValue.levelDrain);
    }

    public boolean isSillyMode() {
        return this.isSillyModeEnabled();
    }

    public boolean isSillyModeEnabled() {
        return Main.getProperties().hasValue(PropertyValue.sillyMode);
    }

    public boolean isNonConEnabled() {
        if (Main.game.isBadEnd()) {
            return true;
        }
        return Main.getProperties().hasValue(PropertyValue.nonConContent);
    }

    public boolean isInflationContentEnabled() {
        return Main.getProperties().hasValue(PropertyValue.inflationContent);
    }

    public boolean isNipplePenEnabled() {
        return Main.getProperties().hasValue(PropertyValue.nipplePenContent);
    }

    public boolean isUrethraEnabled() {
        return Main.getProperties().hasValue(PropertyValue.urethralContent);
    }

    public boolean isIncestEnabled() {
        return Main.getProperties().hasValue(PropertyValue.incestContent);
    }

    public boolean isSadisticSexContent() {
        return Main.getProperties().hasValue(PropertyValue.sadisticSexContent);
    }

    public boolean isLipstickMarkingEnabled() {
        return Main.getProperties().hasValue(PropertyValue.lipstickMarkingContent);
    }

    public boolean isWeatherInterruptionsEnabled() {
        return Main.getProperties().hasValue(PropertyValue.weatherInterruptions);
    }

    public boolean isAutomaticDialogueCopy() {
        return Main.getProperties().hasValue(PropertyValue.automaticDialogueCopy);
    }

    public boolean isFacialHairEnabled() {
        return Main.getProperties().hasValue(PropertyValue.facialHairContent);
    }

    public boolean isFemaleFacialHairEnabled() {
        return Main.getProperties().hasValue(PropertyValue.feminineBeardsContent);
    }

    public boolean isFurryHairEnabled() {
        return Main.getProperties().hasValue(PropertyValue.furryHairContent);
    }

    public boolean isScalyHairEnabled() {
        return Main.getProperties().hasValue(PropertyValue.scalyHairContent);
    }

    public boolean isLipLispEnabled() {
        return Main.getProperties().hasValue(PropertyValue.lipLispContent);
    }

    public boolean isPubicHairEnabled() {
        return Main.getProperties().hasValue(PropertyValue.pubicHairContent);
    }

    public boolean isBodyHairEnabled() {
        return Main.getProperties().hasValue(PropertyValue.bodyHairContent);
    }

    public boolean isAssHairEnabled() {
        return Main.getProperties().hasValue(PropertyValue.assHairContent);
    }

    public boolean isVoluntaryNTREnabled() {
        return Main.getProperties().hasValue(PropertyValue.voluntaryNTR);
    }

    public boolean isInvoluntaryNTREnabled() {
        return Main.getProperties().hasValue(PropertyValue.involuntaryNTR);
    }

    public boolean isFutanariTesticlesEnabled() {
        return Main.getProperties().hasValue(PropertyValue.futanariTesticles);
    }

    public boolean isFurryTailPenetrationContentEnabled() {
        return Main.getProperties().hasValue(PropertyValue.furryTailPenetrationContent);
    }

    public boolean isVestigialMultiBreastsEnabled() {
        return Main.getProperties().hasValue(PropertyValue.vestigialMultiBreasts);
    }

    public boolean isAnalContentEnabled() {
        return Main.getProperties().hasValue(PropertyValue.analContent);
    }

    public boolean isGapeContentEnabled() {
        return Main.getProperties().hasValue(PropertyValue.gapeContent);
    }

    public boolean isPenetrationLimitationsEnabled() {
        return Main.getProperties().hasValue(PropertyValue.penetrationLimitations);
    }

    public boolean isElasticityAffectDepthEnabled() {
        return Main.getProperties().hasValue(PropertyValue.elasticityAffectDepth);
    }

    public boolean isFootContentEnabled() {
        return Main.getProperties().hasValue(PropertyValue.footContent);
    }

    public boolean isArmpitContentEnabled() {
        return Main.getProperties().hasValue(PropertyValue.armpitContent);
    }

    public boolean isLactationContentEnabled() {
        return Main.getProperties().hasValue(PropertyValue.lactationContent);
    }

    public boolean isUdderContentEnabled() {
        return Main.getProperties().hasValue(PropertyValue.udderContent);
    }

    public boolean isCumRegenerationEnabled() {
        return Main.getProperties().hasValue(PropertyValue.cumRegenerationContent);
    }

    public boolean isBadEndsEnabled() {
        return Main.getProperties().hasValue(PropertyValue.badEndContent);
    }

    public void setBadEnd(String badEndTitle) {
        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.badEnd, true);
        Main.getProperties().badEndTitle = badEndTitle;
    }

    public boolean isBadEnd() {
        return Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.badEnd);
    }

    public boolean isCompanionContentEnabled() {
        return Main.getProperties().hasValue(PropertyValue.companionContent);
    }

    public boolean isMuskContentEnabled() {
        return Main.getProperties().hasValue(PropertyValue.muskContent);
    }

    public boolean isFeralContentEnabled() {
        return Main.getProperties().hasValue(PropertyValue.feralContent);
    }

    public boolean isPlotDiscovered() {
        return Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_2_D_MEETING_A_LILIN);
    }

    public boolean isLunetteDefeated() {
        return false;
    }

    public boolean isRenderMap() {
        return this.renderMap;
    }

    public void setRenderMap(boolean renderMap) {
        this.renderMap = renderMap;
    }

    public boolean isInGlobalMap() {
        return this.getPlayer().getLocationPlace().getPlaceType().isGlobalMapTile();
    }

    public SizedStack<EventLogEntry> getEventLog() {
        return this.eventLog;
    }

    public void addEvent(EventLogEntry event, boolean appendAdditionTextToMainDialogue) {
        this.eventLog.push(event);
        if (appendAdditionTextToMainDialogue) {
            Main.game.getTextEndStringBuilder().append(event.getMainDialogueDescription());
        }
    }

    public void setEventLog(SizedStack<EventLogEntry> eventLog) {
        this.eventLog = eventLog;
    }

    public SizedStack<Util.Value<Integer, List<SlaveryEventLogEntry>>> getSlaveryEventLog() {
        return this.slaveryEventLog;
    }

    public List<SlaveryEventLogEntry> getSlaveryEvents(int day) {
        for (Util.Value value : this.slaveryEventLog) {
            if ((Integer)value.getKey() != day) continue;
            return (List)value.getValue();
        }
        return null;
    }

    public void addSlaveryEvent(int day, SlaveryEventLogEntry event) {
        for (Util.Value value : this.slaveryEventLog) {
            if ((Integer)value.getKey() != day) continue;
            ((List)value.getValue()).add(event);
            return;
        }
        this.slaveryEventLog.push(new Util.Value<Integer, ArrayList<SlaveryEventLogEntry>>(day, Util.newArrayListOfValues(event)));
    }

    public int getNpcTally() {
        return this.npcTally.get();
    }

    public OccupancyUtil getOccupancyUtil() {
        return this.occupancyUtil;
    }

    public DialogueNode getDefaultDialogue() {
        return Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getDialogue(true);
    }

    public DialogueNode getDefaultDialogue(boolean withRandomEncounter) {
        return Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getDialogue(withRandomEncounter);
    }

    public DialogueNode getDefaultDialogue(boolean withRandomEncounter, boolean forceEncounter) {
        return Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getDialogue(withRandomEncounter, forceEncounter);
    }

    public boolean isRequestAutosave() {
        if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.badEnd)) {
            return false;
        }
        if (Main.getProperties().autoSaveFrequency == 2 && this.lastAutoSaveTime + 604800L > Main.game.getSecondsPassed()) {
            return false;
        }
        if (Main.getProperties().autoSaveFrequency == 1 && this.lastAutoSaveTime + 86400L > Main.game.getSecondsPassed()) {
            return false;
        }
        return this.requestAutosave;
    }

    public void setRequestAutosave(boolean requestAutosave) {
        this.requestAutosave = requestAutosave;
    }

    public boolean isSpittingDisabled() {
        return !Main.getProperties().hasValue(PropertyValue.spittingEnabled);
    }

    public boolean isOpportunisticAttackersEnabled() {
        return Main.getProperties().hasValue(PropertyValue.opportunisticAttackers);
    }

    public boolean isOffspringEncountersEnabled() {
        return Main.getProperties().hasValue(PropertyValue.offspringEncounters);
    }

    public boolean isBypassSexActionsEnabled() {
        return Main.getProperties().bypassSexActions != 0;
    }

    public boolean isBraxMainQuestComplete() {
        return Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_1_C_WOLFS_DEN);
    }

    public Map<String, CharacterInventory> getSavedInventories() {
        return savedInventories;
    }

    public void addSavedInventory(GameCharacter character) {
        savedInventories.put(character.getId(), CharacterInventory.getCopyOfInventory(character.getInventory()));
    }

    public String parseFromFile(String pathName, String tag, GameCharacter ... specialNPCs) {
        return this.getDialogueManager().getDialogueFromFile(pathName, tag, specialNPCs);
    }

    public String forceParse(String content) {
        return UtilText.parse(content, new ParserTag[0]);
    }

    public void addSpecialParsingString(String content, boolean clearListBeforeAdding) {
        UtilText.addSpecialParsingString(content, clearListBeforeAdding);
    }

    public void clearSpecialParsingStrings() {
        UtilText.clearSpecialParsingStrings();
    }

    public void openInventoryDialogue(NPC target, InventoryInteraction interactionType) {
        Main.mainController.openInventory(target, interactionType);
    }

    public void initCosmeticsDialogue(NPC beautician, GameCharacter target, DialogueNode returnToNode) {
        CosmeticsDialogue.initDialogue(beautician, target, returnToNode);
    }

    public void initTransformationMenu(GameCharacter target) {
        Main.game.saveDialogueNode();
        BodyChanging.setTarget(target);
    }

    public void initQuickTransformationMenu(GameCharacter target, DialogueNode endingNode) {
        QuickTransformations.initQuickTransformations("misc/quickTransformations", target, endingNode);
    }

    public void setParserTarget(String parserTarget, NPC npc) {
        ParserTarget.addAdditionalParserTarget(parserTarget, npc);
    }

    public boolean isFreeRoomAvailableForOccupant() {
        return OccupancyUtil.isFreeRoomAvailableForOccupant();
    }

    public Cell getFreeRoomForOccupant() {
        return OccupancyUtil.getFreeRoomForOccupant();
    }

    public boolean isSpaceForMoreProstitutes() {
        return RedLightDistrict.isSpaceForMoreProstitutes();
    }

    public AbstractItem getAlleywayItem() {
        return (AbstractItem)this.randomItem;
    }

    public AbstractClothing getAlleywayClothing() {
        return (AbstractClothing)this.randomItem;
    }

    public AbstractWeapon getAlleywayWeapon() {
        return (AbstractWeapon)this.randomItem;
    }

    public void generateAlleywayItem() {
        if (!Main.game.isSillyModeEnabled() || Math.random() < (double)0.99f) {
            List<AbstractItemType> itemsToDrawFrom = ItemType.getDominionAlleywayItems();
            if (Main.game.getPlayer().getWorldLocation() == WorldType.BAT_CAVERNS) {
                itemsToDrawFrom = ItemType.getBatCavernItems();
            } else if (Main.game.getPlayer().getWorldLocation().getWorldRegion() == WorldRegion.SUBMISSION) {
                itemsToDrawFrom = ItemType.getSubmissionTunnelItems();
            } else if (Main.game.getPlayer().getWorldLocation().getWorldRegion() == WorldRegion.FIELD_CITY || Main.game.getPlayer().getWorldLocation().getWorldRegion() == WorldRegion.FIELDS || Main.game.getPlayer().getWorldLocation().getWorldRegion() == WorldRegion.WOODLAND || Main.game.getPlayer().getWorldLocation().getWorldRegion() == WorldRegion.RIVER) {
                itemsToDrawFrom = ItemType.getElisAlleywayItems();
            }
            this.randomItem = Main.game.getItemGen().generateItem(itemsToDrawFrom.get(Util.random.nextInt(itemsToDrawFrom.size())));
        } else {
            this.randomItem = Math.random() < 0.5 ? Main.game.getItemGen().generateItem(ItemType.EGGPLANT) : Main.game.getItemGen().generateItem("innoxia_cheat_unlikely_whammer");
        }
    }

    public void generateAlleywayClothing() {
        if (Math.random() < (double)0.01f) {
            this.randomItem = Main.game.getItemGen().generateClothing("innoxia_torso_tshirt_megamilk", false);
            Main.game.getPlayerCell().getInventory().addClothing((AbstractClothing)this.randomItem);
        } else {
            ArrayList<AbstractClothingType> randomClothingList = new ArrayList<AbstractClothingType>(ClothingType.getAllClothing());
            randomClothingList.removeIf(clothing -> !clothing.getDefaultItemTags().contains((Object)ItemTag.SOLD_BY_KATE) && !clothing.getDefaultItemTags().contains((Object)ItemTag.SOLD_BY_NYAN) && !clothing.getDefaultItemTags().contains((Object)ItemTag.DOMINION_ALLEYWAY_SPAWN) || clothing.getDefaultItemTags().contains((Object)ItemTag.NO_RANDOM_SPAWN) || clothing.getRarity() == Rarity.LEGENDARY);
            boolean commonClothing = Math.random() < 0.8;
            Collections.shuffle(randomClothingList);
            AbstractClothingType typeSelected = randomClothingList.stream().filter(ct -> commonClothing ? ct.getRarity() == Rarity.COMMON : ct.getRarity() != Rarity.COMMON).findFirst().get();
            if (typeSelected == null) {
                typeSelected = (AbstractClothingType)randomClothingList.get(Util.random.nextInt(randomClothingList.size()));
            }
            this.randomItem = Main.game.getItemGen().generateClothing(typeSelected, true);
        }
    }

    public void generateAlleywayWeapon() {
        ArrayList<AbstractWeaponType> weapons = new ArrayList<AbstractWeaponType>(WeaponType.getAllWeapons());
        weapons.removeIf(w -> !w.getItemTags().contains((Object)ItemTag.DOMINION_ALLEYWAY_SPAWN));
        this.randomItem = Main.game.getItemGen().generateWeapon((AbstractWeaponType)weapons.get(Util.random.nextInt(weapons.size())));
    }

    public boolean isOffspringEncounterAvailable(AbstractWorldType worldType, AbstractPlaceType placeType) {
        List<OffspringSeed> offspringAvailable = Main.game.getOffspringNotSpawned(os -> os.getSubspecies() == Subspecies.HALF_DEMON ? os.getHalfDemonSubspecies().isAbleToNaturallySpawnInLocation(worldType, placeType) : os.getSubspecies().isAbleToNaturallySpawnInLocation(worldType, placeType));
        return !offspringAvailable.isEmpty();
    }

    public void initOffspringEncounter(AbstractWorldType worldType, AbstractPlaceType placeType) {
        List<OffspringSeed> offspringAvailable = Main.game.getOffspringNotSpawned(os -> os.getSubspecies() == Subspecies.HALF_DEMON ? os.getHalfDemonSubspecies().isAbleToNaturallySpawnInLocation(worldType, placeType) : os.getSubspecies().isAbleToNaturallySpawnInLocation(worldType, placeType));
        if (!offspringAvailable.isEmpty()) {
            AbstractEncounter.SpawnAndStartChildHere(offspringAvailable);
        }
    }

    public void spawnDomGloryHoleNPC(String genericName) {
        this.spawnDomGloryHoleNPC(genericName, null);
    }

    public void spawnDomGloryHoleNPC(String genericName, String parserTarget) {
        GenericSexualPartner npc = new GenericSexualPartner(Gender.getGenderFromUserPreferences(false, true), Main.game.getPlayer().getWorldLocation(), Main.game.getPlayer().getLocation(), false, s -> s.isNonBiped()){

            @Override
            public void turnUpdate() {
                if (this.getGenitalArrangement() == GenitalArrangement.NORMAL) {
                    this.setAreaKnownByCharacter(CoverableArea.ASS, Main.game.getPlayer(), false);
                    this.setAreaKnownByCharacter(CoverableArea.ANUS, Main.game.getPlayer(), false);
                }
            }
        };
        npc.setRaceConcealed(true);
        ArrayList<String> excludedAdjectives = Util.newArrayListOfValues(new String[0]);
        for (NPC npcPresent : Main.game.getCharactersPresent()) {
            if (!(npcPresent instanceof GenericSexualPartner) || !npcPresent.getGenericName().contains(" ")) continue;
            excludedAdjectives.add(npcPresent.getGenericName().split(" ")[0]);
        }
        Main.game.getCharacterUtils().setGenericName(npc, genericName, excludedAdjectives);
        npc.setDescription("[npc.Name]\u5bf9\u4f60\u6765\u8bf4\u5b8c\u5168\u662f\u4e2a\u964c\u751f\u4eba\uff0c[npc.her]\u5728\u95f2\u901b\u4e4b\u4f59\u6765\u4e0a\u5395\u6240\uff0c\u53d1\u73b0\u4f60\u6b63\u5728\u5bfb\u6b22\u6d1e\uff0c\u53ef\u4ee5\u7ed9[npc.her]\u7684#IF(npc.hasPenis())\u9e21\u5df4#ELSE\u5c0f\u7a74#ENDIF\u63d0\u4f9b\u670d\u52a1\u2026\u2026");
        if (Math.random() < (double)0.4f) {
            npc.setSexualOrientation(SexualOrientation.AMBIPHILIC);
        } else if (Main.game.getPlayer().isFeminine()) {
            npc.setSexualOrientation(SexualOrientation.GYNEPHILIC);
        } else {
            npc.setSexualOrientation(SexualOrientation.ANDROPHILIC);
        }
        npc.setFetishDesire(Fetish.FETISH_DOMINANT, FetishDesire.THREE_LIKE);
        npc.setFetishDesire(Fetish.FETISH_SUBMISSIVE, FetishDesire.TWO_NEUTRAL);
        npc.setFetishDesire(Fetish.FETISH_ORAL_RECEIVING, FetishDesire.THREE_LIKE);
        npc.setFetishDesire(Fetish.FETISH_VAGINAL_GIVING, FetishDesire.THREE_LIKE);
        npc.setFetishDesire(Fetish.FETISH_ANAL_GIVING, FetishDesire.THREE_LIKE);
        npc.removeFetish(Fetish.FETISH_NON_CON_SUB);
        if (npc.hasVagina()) {
            npc.setFetishDesire(Fetish.FETISH_VAGINAL_RECEIVING, FetishDesire.THREE_LIKE);
        }
        if (npc.hasPenis()) {
            npc.setFetishDesire(Fetish.FETISH_PENIS_GIVING, FetishDesire.THREE_LIKE);
        }
        npc.unequipAllClothingIntoVoid(true, true);
        npc.setPenisVirgin(false);
        npc.setVaginaVirgin(false);
        npc.setAreaKnownByCharacter(CoverableArea.ANUS, Main.game.getPlayer(), false);
        try {
            Main.game.addNPC(npc, false);
            Main.game.setActiveNPC(npc);
            if (parserTarget != null && !parserTarget.isEmpty()) {
                ParserTarget.addAdditionalParserTarget(parserTarget, npc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void spawnSubGloryHoleNPC(String genericName) {
        this.spawnSubGloryHoleNPC(genericName, null);
    }

    public void spawnSubGloryHoleNPC(String genericName, String parserTarget) {
        GenericSexualPartner npc = new GenericSexualPartner(Gender.getGenderFromUserPreferences(false, false), Main.game.getPlayer().getWorldLocation(), Main.game.getPlayer().getLocation(), false, s -> s.isNonBiped());
        npc.setRaceConcealed(true);
        Main.game.getCharacterUtils().setGenericName(npc, genericName, Util.newArrayListOfValues(new String[0]));
        npc.setDescription("[npc.Name]\u5bf9\u4f60\u6765\u8bf4\u5b8c\u5168\u662f\u4e2a\u964c\u751f\u4eba\uff0c[npc.her]\u5728\u95f2\u901b\u4e4b\u4f59\u6765\u4e0a\u5395\u6240\uff0c\u51b3\u5b9a\u8981\u5728\u4e00\u4e2a\u5bfb\u6b22\u6d1e\u63d0\u4f9b\u670d\u52a1\u2026\u2026");
        if (Math.random() < (double)0.4f) {
            npc.setSexualOrientation(SexualOrientation.AMBIPHILIC);
        } else if (Main.game.getPlayer().isFeminine()) {
            npc.setSexualOrientation(SexualOrientation.GYNEPHILIC);
        } else {
            npc.setSexualOrientation(SexualOrientation.ANDROPHILIC);
        }
        npc.setFetishDesire(Fetish.FETISH_DOMINANT, FetishDesire.TWO_NEUTRAL);
        npc.setFetishDesire(Fetish.FETISH_SUBMISSIVE, FetishDesire.THREE_LIKE);
        npc.setFetishDesire(Fetish.FETISH_ORAL_GIVING, FetishDesire.THREE_LIKE);
        npc.setFetishDesire(Fetish.FETISH_PENIS_RECEIVING, FetishDesire.THREE_LIKE);
        npc.setFetishDesire(Fetish.FETISH_ANAL_RECEIVING, FetishDesire.THREE_LIKE);
        npc.removeFetish(Fetish.FETISH_NON_CON_SUB);
        if (npc.hasVagina()) {
            npc.setFetishDesire(Fetish.FETISH_VAGINAL_RECEIVING, FetishDesire.THREE_LIKE);
        }
        if (Math.random() > 0.75) {
            npc.addFetish(Fetish.FETISH_ORAL_GIVING);
        }
        npc.unequipAllClothingIntoVoid(true, true);
        npc.setPenisVirgin(false);
        npc.setVaginaVirgin(false);
        npc.setAssVirgin(false);
        npc.setFaceVirgin(false);
        npc.setAllAreasKnownByCharacter(Main.game.getPlayer(), false);
        try {
            Main.game.addNPC(npc, false);
            Main.game.setActiveNPC(npc);
            if (parserTarget != null && !parserTarget.isEmpty()) {
                ParserTarget.addAdditionalParserTarget(parserTarget, npc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initGamblersInElisTavern() {
        AbstractWorldType wt = WorldType.getWorldTypeFromId("innoxia_fields_elis_tavern_alley");
        AbstractPlaceType pt = PlaceType.getPlaceTypeFromId("innoxia_fields_elis_tavern_alley_dice_poker");
        List<NPC> gamblersPresent = Main.game.getCharactersPresent(Main.game.getWorlds().get(wt).getCell(pt));
        for (NPC npc : gamblersPresent) {
            if (!(npc instanceof GamblingDenPatron)) continue;
            Main.game.banishNPC(npc);
        }
        try {
            Main.game.addNPC(new GamblingDenPatron(Gender.getGenderFromUserPreferences(false, false), DicePokerTable.COPPER, wt, pt, false), false);
            Main.game.addNPC(new GamblingDenPatron(Gender.getGenderFromUserPreferences(false, false), DicePokerTable.COPPER, wt, pt, false), false);
            Main.game.addNPC(new GamblingDenPatron(Gender.getGenderFromUserPreferences(false, false), DicePokerTable.SILVER, wt, pt, false), false);
            Main.game.addNPC(new GamblingDenPatron(Gender.getGenderFromUserPreferences(false, false), DicePokerTable.SILVER, wt, pt, false), false);
            Main.game.addNPC(new GamblingDenPatron(Gender.getGenderFromUserPreferences(false, false), DicePokerTable.GOLD, wt, pt, false), false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void moveBankInventory() {
        HashMap<AbstractWorldType, AbstractPlaceType> bankPlaces = new HashMap<AbstractWorldType, AbstractPlaceType>();
        bankPlaces.put(WorldType.getWorldTypeFromId("innoxia_dominion_bank"), PlaceType.getPlaceTypeFromId("innoxia_dominion_bank_deposit_box"));
        bankPlaces.put(WorldType.getWorldTypeFromId("innoxia_fields_elis_bank"), PlaceType.getPlaceTypeFromId("innoxia_fields_elis_bank_deposit_box"));
        CharacterInventory inventory = null;
        for (Map.Entry entry : bankPlaces.entrySet()) {
            CharacterInventory bankInventory = Main.game.getWorlds().get(entry.getKey()).getCell((AbstractPlaceType)entry.getValue()).getInventory();
            if (bankInventory.isEmpty()) continue;
            inventory = CharacterInventory.getCopyOfInventory(bankInventory);
            Main.game.getWorlds().get(entry.getKey()).getCell((AbstractPlaceType)entry.getValue()).setInventory(new CharacterInventory(true, 0));
            break;
        }
        if (inventory != null) {
            for (Map.Entry entry : bankPlaces.entrySet()) {
                if (Main.game.getPlayer().getWorldLocation() != entry.getKey()) continue;
                Main.game.getWorlds().get(entry.getKey()).getCell((AbstractPlaceType)entry.getValue()).setInventory(inventory);
            }
        }
    }

    public String getBookEffect(AbstractSubspecies mainSubspecies, boolean withDescription) {
        return AbstractItemEffectType.getBookEffect(Main.game.getPlayer(), mainSubspecies, null, withDescription);
    }

    public boolean isVowel(char c) {
        return UtilText.isVowel(c);
    }

    public void startGenericSex(GameCharacter character) {
        Main.game.setContent(new ResponseSex(UtilText.parse(character, "\u8ddf[npc.name]\u505a\u7231", new ParserTag[0]), UtilText.parse(character, "\u4e0e[npc.name]\u5f00\u59cb\u4e00\u573a\u5e38\u89c4\u7684\u6027\u4ea4", new ParserTag[0]), true, true, new SMGeneric(Util.newArrayListOfValues(Main.game.getPlayer()), Util.newArrayListOfValues(character), null, null, new ResponseTag[0]), Main.game.getDefaultDialogue(false), "<p>" + UtilText.parse(character, "\u4f60\u5f00\u59cb\u8ddf[npc.name]\u505a\u7231\u4e86", new ParserTag[0]) + "</p>"));
    }

    public void impregnate(GameCharacter character) {
        character.guaranteePregnancyOnNextRoll();
        character.rollForPregnancy(Main.game.getPlayer(), Main.game.getPlayer().getBody(), 100.0f, true, FertilisationType.NORMAL, Attribute.VIRILITY);
        ItemEffectType.MOTHERS_MILK.applyEffect(null, null, null, 0, character, character, null);
        ItemEffectType.MOTHERS_MILK.applyEffect(null, null, null, 0, character, character, null);
        ItemEffectType.MOTHERS_MILK.applyEffect(null, null, null, 0, character, character, null);
    }

    static {
        informationTooltips = new HashMap<String, TooltipInformationEventListener>();
        timeLog = false;
        timeStart = 0L;
        debug = false;
    }
}

