/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.Game;
import com.lilithsthrone.game.character.CharacterChangeEventListener;
import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.body.types.ArmType;
import com.lilithsthrone.game.character.body.types.AssType;
import com.lilithsthrone.game.character.body.types.BreastType;
import com.lilithsthrone.game.character.body.types.EarType;
import com.lilithsthrone.game.character.body.types.EyeType;
import com.lilithsthrone.game.character.body.types.FaceType;
import com.lilithsthrone.game.character.body.types.HairType;
import com.lilithsthrone.game.character.body.types.HornType;
import com.lilithsthrone.game.character.body.types.LegType;
import com.lilithsthrone.game.character.body.types.PenisType;
import com.lilithsthrone.game.character.body.types.TailType;
import com.lilithsthrone.game.character.body.types.TorsoType;
import com.lilithsthrone.game.character.body.types.VaginaType;
import com.lilithsthrone.game.character.body.types.WingType;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.character.fetishes.AbstractFetish;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.dominion.Lilaya;
import com.lilithsthrone.game.character.npc.dominion.Scarlett;
import com.lilithsthrone.game.character.npc.misc.NPCOffspring;
import com.lilithsthrone.game.character.npc.submission.DarkSiren;
import com.lilithsthrone.game.character.npc.submission.Elizabeth;
import com.lilithsthrone.game.character.npc.submission.Lyssieth;
import com.lilithsthrone.game.character.persona.NameTriplet;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.persona.Relationship;
import com.lilithsthrone.game.character.persona.SexualOrientation;
import com.lilithsthrone.game.character.quests.Quest;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.character.quests.QuestType;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueFlags;
import com.lilithsthrone.game.dialogue.eventLog.EventLogEntry;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.game.inventory.Rarity;
import com.lilithsthrone.game.inventory.ShopTransaction;
import com.lilithsthrone.game.inventory.clothing.AbstractClothingType;
import com.lilithsthrone.game.inventory.clothing.ClothingType;
import com.lilithsthrone.game.inventory.item.AbstractItemType;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.inventory.weapon.AbstractWeaponType;
import com.lilithsthrone.game.inventory.weapon.WeaponType;
import com.lilithsthrone.game.sex.CondomFailure;
import com.lilithsthrone.game.sex.ImmobilisationType;
import com.lilithsthrone.game.sex.OrgasmCumTarget;
import com.lilithsthrone.game.sex.SexAreaOrifice;
import com.lilithsthrone.game.sex.SexAreaPenetration;
import com.lilithsthrone.game.sex.SexPace;
import com.lilithsthrone.game.sex.managers.submission.SMLyssiethDemonTF;
import com.lilithsthrone.game.sex.positions.slots.SexSlotLyingDown;
import com.lilithsthrone.game.sex.sexActions.SexActionInterface;
import com.lilithsthrone.game.sex.sexActions.SexActionOrgasmOverride;
import com.lilithsthrone.game.sex.sexActions.SexActionType;
import com.lilithsthrone.game.sex.sexActions.baseActionsMisc.GenericOrgasms;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.SizedStack;
import com.lilithsthrone.utils.TreeNode;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.Vector2i;
import com.lilithsthrone.utils.XMLSaving;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PlayerCharacter
extends GameCharacter
implements XMLSaving {
    private String title;
    private int karma;
    private Map<QuestLine, List<Quest>> quests;
    private Map<QuestLine, Quest> questsFailed;
    private boolean mainQuestUpdated;
    private boolean sideQuestUpdated;
    private boolean relationshipQuestUpdated;
    private boolean isActive;
    protected List<String> friendlyOccupants;
    private List<String> charactersEncountered;
    private Set<AbstractWorldType> worldsVisited;
    private Set<AbstractSubspecies> racesDiscoveredFromBook;
    private Set<AbstractItemType> itemsDiscovered;
    private Set<AbstractWeaponType> weaponsDiscovered;
    private Set<AbstractClothingType> clothingDiscovered;
    private Set<AbstractSubspecies> subspeciesDiscovered;
    private Set<AbstractSubspecies> subspeciesAdvancedKnowledge;
    private SizedStack<ShopTransaction> buybackStack;
    private static boolean debug = false;

    public PlayerCharacter(NameTriplet nameTriplet, int level, LocalDateTime birthday, Gender gender, AbstractSubspecies startingSubspecies, RaceStage stage, AbstractWorldType startingWorld, AbstractPlaceType startingPlace) {
        super(nameTriplet, "", "", level, Main.game.getDateNow().minusYears(22L), gender, startingSubspecies, stage, new CharacterInventory(false, 0), startingWorld, startingPlace);
        this.setSexualOrientation(SexualOrientation.AMBIPHILIC);
        this.title = "\u4eba\u7c7b";
        this.karma = 0;
        this.setMaxCompanions(1);
        this.quests = new HashMap<QuestLine, List<Quest>>();
        this.questsFailed = new HashMap<QuestLine, Quest>();
        this.mainQuestUpdated = false;
        this.sideQuestUpdated = false;
        this.relationshipQuestUpdated = false;
        this.isActive = true;
        this.racesDiscoveredFromBook = new HashSet<AbstractSubspecies>();
        this.itemsDiscovered = new HashSet<AbstractItemType>();
        this.weaponsDiscovered = new HashSet<AbstractWeaponType>();
        this.clothingDiscovered = new HashSet<AbstractClothingType>();
        this.subspeciesDiscovered = new HashSet<AbstractSubspecies>();
        this.subspeciesAdvancedKnowledge = new HashSet<AbstractSubspecies>();
        this.buybackStack = new SizedStack(24);
        this.charactersEncountered = new ArrayList<String>();
        this.friendlyOccupants = new ArrayList<String>();
        this.worldsVisited = new HashSet<AbstractWorldType>();
        this.setAttribute(Attribute.MAJOR_PHYSIQUE, 0.0f, false);
        this.setAttribute(Attribute.MAJOR_ARCANE, 0.0f, false);
        this.setAttribute(Attribute.MAJOR_CORRUPTION, 0.0f, false);
        this.equipBasicCombatMoves();
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element playerElement = super.saveAsXML(parentElement, doc);
        Element playerSpecific = doc.createElement("playerSpecific");
        playerElement.appendChild(playerSpecific);
        XMLUtil.createXMLElementWithValue(doc, playerSpecific, "title", this.getTitle());
        XMLUtil.createXMLElementWithValue(doc, playerSpecific, "karma", String.valueOf(this.getKarma()));
        Element questUpdatesElement = doc.createElement("questUpdates");
        playerSpecific.appendChild(questUpdatesElement);
        XMLUtil.createXMLElementWithValue(doc, playerSpecific, "mainQuestUpdated", String.valueOf(this.mainQuestUpdated));
        XMLUtil.createXMLElementWithValue(doc, playerSpecific, "sideQuestUpdated", String.valueOf(this.sideQuestUpdated));
        XMLUtil.createXMLElementWithValue(doc, playerSpecific, "relationshipQuestUpdated", String.valueOf(this.relationshipQuestUpdated));
        Element innerElement = doc.createElement("raceBooksDiscovered");
        playerSpecific.appendChild(innerElement);
        for (AbstractSubspecies abstractSubspecies : this.racesDiscoveredFromBook) {
            if (abstractSubspecies == null) continue;
            Element element = doc.createElement("race");
            innerElement.appendChild(element);
            element.setTextContent(Subspecies.getIdFromSubspecies(abstractSubspecies));
        }
        Element charactersEncounteredElement = doc.createElement("charactersEncountered");
        playerSpecific.appendChild(charactersEncounteredElement);
        for (String string : this.charactersEncountered) {
            XMLUtil.createXMLElementWithValue(doc, charactersEncounteredElement, "id", string);
        }
        innerElement = doc.createElement("questMap");
        playerSpecific.appendChild(innerElement);
        for (Map.Entry<QuestLine, List<Quest>> entry : this.quests.entrySet()) {
            Element element = doc.createElement("entry");
            innerElement.appendChild(element);
            XMLUtil.addAttribute(doc, element, "questLine", entry.getKey().toString());
            for (int i = 0; i < entry.getValue().size(); ++i) {
                XMLUtil.addAttribute(doc, element, "q" + i, String.valueOf((Object)entry.getValue().get(i)));
            }
        }
        innerElement = doc.createElement("questFailedMap");
        playerSpecific.appendChild(innerElement);
        for (Map.Entry<QuestLine, Quest> entry : this.questsFailed.entrySet()) {
            Element element = doc.createElement("entry");
            innerElement.appendChild(element);
            XMLUtil.addAttribute(doc, element, "questLine", entry.getKey().toString());
            XMLUtil.addAttribute(doc, element, "q", String.valueOf((Object)entry.getValue()));
        }
        Element element = doc.createElement("friendlyOccupants");
        playerSpecific.appendChild(element);
        for (String string : this.getFriendlyOccupants()) {
            Element element2 = doc.createElement("occupant");
            element.appendChild(element2);
            XMLUtil.addAttribute(doc, element2, "id", string);
        }
        Element element3 = doc.createElement("worldsVisited");
        playerSpecific.appendChild(element3);
        for (AbstractWorldType world : this.getWorldsVisited()) {
            Element element4 = doc.createElement("world");
            element3.appendChild(element4);
            XMLUtil.addAttribute(doc, element4, "id", WorldType.getIdFromWorldType(world));
        }
        Element element5 = doc.createElement("itemsDiscovered");
        playerSpecific.appendChild(element5);
        for (AbstractItemType abstractItemType : this.itemsDiscovered) {
            try {
                if (abstractItemType == null) continue;
                Element element6 = doc.createElement("type");
                element5.appendChild(element6);
                element6.setTextContent(abstractItemType.getId());
            }
            catch (Exception exception) {}
        }
        Element weaponsDiscovered = doc.createElement("weaponsDiscovered");
        playerSpecific.appendChild(weaponsDiscovered);
        for (AbstractWeaponType abstractWeaponType : this.weaponsDiscovered) {
            try {
                if (abstractWeaponType == null) continue;
                Element element7 = doc.createElement("type");
                weaponsDiscovered.appendChild(element7);
                element7.setTextContent(abstractWeaponType.getId());
            }
            catch (Exception exception) {}
        }
        Element element8 = doc.createElement("clothingDiscovered");
        playerSpecific.appendChild(element8);
        for (AbstractClothingType abstractClothingType : this.clothingDiscovered) {
            try {
                if (abstractClothingType == null) continue;
                Element element9 = doc.createElement("type");
                element8.appendChild(element9);
                element9.setTextContent(abstractClothingType.getId());
            }
            catch (Exception element9) {}
        }
        Element element10 = doc.createElement("racesDiscovered");
        playerSpecific.appendChild(element10);
        for (AbstractSubspecies subspecies : this.subspeciesDiscovered) {
            if (this.subspeciesAdvancedKnowledge.contains(subspecies)) continue;
            Element element11 = doc.createElement("race");
            element10.appendChild(element11);
            element11.setTextContent(Subspecies.getIdFromSubspecies(subspecies));
        }
        Element element12 = doc.createElement("racesDiscoveredAdvanced");
        playerSpecific.appendChild(element12);
        for (AbstractSubspecies subspecies : this.subspeciesAdvancedKnowledge) {
            Element element13 = doc.createElement("race");
            element12.appendChild(element13);
            element13.setTextContent(Subspecies.getIdFromSubspecies(subspecies));
        }
        return playerElement;
    }

    public static PlayerCharacter loadFromXML(StringBuilder log, Element parentElement, Document doc, CharacterImportSetting ... settings) {
        Element e;
        long time = System.nanoTime();
        if (debug) {
            System.out.println("Player loading start");
        }
        PlayerCharacter character = new PlayerCharacter(new NameTriplet(""), 0, null, Gender.F_V_B_FEMALE, Subspecies.HUMAN, RaceStage.HUMAN, WorldType.DOMINION, PlaceType.DOMINION_AUNTS_HOME);
        if (debug) {
            System.out.println("character created: " + (double)(System.nanoTime() - time) / 1.0E9);
        }
        GameCharacter.loadGameCharacterVariablesFromXML(character, log, parentElement, doc, settings);
        if (debug) {
            System.out.println("Variables loaded: " + (double)(System.nanoTime() - time) / 1.0E9);
        }
        if (Main.isVersionOlderThan(Game.loadingVersion, "0.3.5.6")) {
            character.setGenderIdentity(character.getGender());
        }
        character.sortInventory();
        boolean newGameImport = Arrays.asList(settings).contains((Object)CharacterImportSetting.NEW_GAME_IMPORT);
        NodeList nodes = parentElement.getElementsByTagName("core");
        Element element = (Element)nodes.item(0);
        String version = "";
        if (element.getElementsByTagName("version").item(0) != null) {
            version = ((Element)element.getElementsByTagName("version").item(0)).getAttribute("value");
        }
        Element playerSpecificElement = (Element)parentElement.getElementsByTagName("playerSpecific").item(0);
        if (newGameImport) {
            character.setLocation(WorldType.MUSEUM_LOST, PlaceType.MUSEUM_MIRROR);
        }
        if (!newGameImport) {
            if (playerSpecificElement != null) {
                String questString;
                Quest quest;
                QuestLine questLine;
                Element e2;
                Element questMapElement;
                Element charactersEncounteredElement;
                Element e3;
                int i;
                if (playerSpecificElement.getElementsByTagName("title").getLength() != 0) {
                    character.setTitle(((Element)playerSpecificElement.getElementsByTagName("title").item(0)).getAttribute("value"));
                }
                if (playerSpecificElement.getElementsByTagName("karma").getLength() != 0) {
                    character.setKarma(Integer.valueOf(((Element)playerSpecificElement.getElementsByTagName("karma").item(0)).getAttribute("value")));
                }
                if (playerSpecificElement.getElementsByTagName("mainQuestUpdated").getLength() != 0) {
                    character.setMainQuestUpdated(Boolean.valueOf(((Element)playerSpecificElement.getElementsByTagName("mainQuestUpdated").item(0)).getAttribute("value")));
                }
                if (playerSpecificElement.getElementsByTagName("sideQuestUpdated").getLength() != 0) {
                    character.setSideQuestUpdated(Boolean.valueOf(((Element)playerSpecificElement.getElementsByTagName("sideQuestUpdated").item(0)).getAttribute("value")));
                }
                if (playerSpecificElement.getElementsByTagName("relationshipQuestUpdated").getLength() != 0) {
                    character.setRelationshipQuestUpdated(Boolean.valueOf(((Element)playerSpecificElement.getElementsByTagName("relationshipQuestUpdated").item(0)).getAttribute("value")));
                }
                try {
                    if (Main.isVersionOlderThan(version, "0.3.7.7")) {
                        racesDiscoveredElement = (Element)playerSpecificElement.getElementsByTagName("racesDiscovered").item(0);
                        if (racesDiscoveredElement != null) {
                            races = racesDiscoveredElement.getElementsByTagName("race");
                            for (i = 0; i < races.getLength(); ++i) {
                                e3 = (Element)races.item(i);
                                try {
                                    character.addRaceDiscoveredFromBook(Subspecies.getSubspeciesFromId(e3.getAttribute("value")));
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    } else {
                        racesDiscoveredElement = (Element)playerSpecificElement.getElementsByTagName("raceBooksDiscovered").item(0);
                        if (racesDiscoveredElement != null) {
                            races = racesDiscoveredElement.getElementsByTagName("race");
                            for (i = 0; i < races.getLength(); ++i) {
                                e3 = (Element)races.item(i);
                                try {
                                    character.addRaceDiscoveredFromBook(Subspecies.getSubspeciesFromId(e3.getTextContent()));
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                catch (Exception racesDiscoveredElement) {
                    // empty catch block
                }
                if ((charactersEncounteredElement = (Element)playerSpecificElement.getElementsByTagName("charactersEncountered").item(0)) != null) {
                    NodeList charactersEncounteredIds = charactersEncounteredElement.getElementsByTagName("id");
                    for (i = 0; i < charactersEncounteredIds.getLength(); ++i) {
                        e3 = (Element)charactersEncounteredIds.item(i);
                        String id = e3.getAttribute("value");
                        if (Main.isVersionOlderThan(Game.loadingVersion, "0.3.5.9")) {
                            id = id.replaceAll("Alexa", "Helena");
                        }
                        character.addCharacterEncountered(id);
                    }
                }
                if ((questMapElement = (Element)playerSpecificElement.getElementsByTagName("questMap").item(0)) != null) {
                    NodeList questMapEntries = questMapElement.getElementsByTagName("entry");
                    if (Main.isVersionOlderThan(version, "0.1.99.5")) {
                        for (int i2 = 0; i2 < questMapEntries.getLength(); ++i2) {
                            e2 = (Element)questMapEntries.item(i2);
                            try {
                                int progress = Integer.valueOf(e2.getAttribute("progress"));
                                questLine = QuestLine.valueOf(e2.getAttribute("questLine"));
                                TreeNode<Quest> q = questLine.getQuestTree();
                                for (int it = 0; it < progress; ++it) {
                                    if (q.getChildren().isEmpty()) continue;
                                    q = q.getChildren().get(0);
                                }
                                quest = q.getData();
                                questList = new ArrayList<Quest>();
                                for (TreeNode<Quest> node = questLine.getQuestTree().getFirstNodeWithData(quest); node != null; node = node.getParent()) {
                                    questList.add(node.getData());
                                }
                                Collections.reverse(questList);
                                character.quests.put(questLine, questList);
                                continue;
                            }
                            catch (Exception ex) {
                                System.err.println("ERR Quest!");
                            }
                        }
                    } else if (Main.isVersionOlderThan(version, "0.3.5.3")) {
                        for (int i3 = 0; i3 < questMapEntries.getLength(); ++i3) {
                            e2 = (Element)questMapEntries.item(i3);
                            try {
                                String questString2;
                                String questLineString = e2.getAttribute("questLine");
                                if (questLineString.contains("SIDE_NYAN")) {
                                    questLineString = questLineString.replace("SIDE_NYAN", "RELATIONSHIP_NYAN");
                                }
                                if ((questString2 = e2.getAttribute("quest")).contains("SIDE_NYAN")) {
                                    questString2 = questString2.replace("SIDE_NYAN", "RELATIONSHIP_NYAN");
                                }
                                if (questString2.equals("MAIN_1_E_REPORT_TO_ALEXA")) {
                                    questString2 = "MAIN_1_E_REPORT_TO_HELENA";
                                }
                                QuestLine questLine2 = QuestLine.valueOf(questLineString);
                                quest = Quest.getQuestFromId(questString2);
                                questList = new ArrayList();
                                for (TreeNode<Quest> node = questLine2.getQuestTree().getFirstNodeWithData(quest); node != null; node = node.getParent()) {
                                    questList.add(node.getData());
                                }
                                Collections.reverse(questList);
                                character.quests.put(questLine2, questList);
                                continue;
                            }
                            catch (Exception questLineString) {
                                // empty catch block
                            }
                        }
                    } else {
                        for (int i4 = 0; i4 < questMapEntries.getLength(); ++i4) {
                            e2 = (Element)questMapEntries.item(i4);
                            String questLineString = e2.getAttribute("questLine");
                            questLine = QuestLine.valueOf(questLineString);
                            questString = e2.getAttribute("q0");
                            if (questString.equals("MAIN_1_E_REPORT_TO_ALEXA")) {
                                questString = "MAIN_1_E_REPORT_TO_HELENA";
                            }
                            if (!version.isEmpty() && Main.isVersionOlderThan(version, "0.3.14") && questString.startsWith("RELATIONSHIP_NYAN")) continue;
                            try {
                                quest = Quest.getQuestFromId(questString);
                                questList = new ArrayList();
                                int questIncrement = 0;
                                while (!questString.isEmpty()) {
                                    quest = Quest.getQuestFromId(questString);
                                    if (quest != Quest.MAIN_1_J_ARTHURS_ROOM) {
                                        questList.add(quest);
                                    }
                                    if (!(questString = e2.getAttribute("q" + ++questIncrement)).equals("MAIN_1_E_REPORT_TO_ALEXA")) continue;
                                    questString = "MAIN_1_E_REPORT_TO_HELENA";
                                }
                                character.quests.put(questLine, questList);
                                continue;
                            }
                            catch (Exception ex) {
                                System.out.println("Error in PlayerCharacter loading: QuestLine failed to load: " + questString);
                                ex.printStackTrace();
                            }
                        }
                    }
                }
                if ((questMapElement = (Element)playerSpecificElement.getElementsByTagName("questFailedMap").item(0)) != null) {
                    NodeList questMapEntries = questMapElement.getElementsByTagName("entry");
                    for (int i5 = 0; i5 < questMapEntries.getLength(); ++i5) {
                        e2 = (Element)questMapEntries.item(i5);
                        String questLineString = e2.getAttribute("questLine");
                        questLine = QuestLine.valueOf(questLineString);
                        questString = e2.getAttribute("q");
                        quest = Quest.getQuestFromId(questString);
                        character.questsFailed.put(questLine, quest);
                    }
                }
            }
            try {
                for (int i = 0; i < ((Element)playerSpecificElement.getElementsByTagName("friendlyOccupants").item(0)).getElementsByTagName("occupant").getLength(); ++i) {
                    e = (Element)playerSpecificElement.getElementsByTagName("occupant").item(i);
                    if (e.getAttribute("id").equals("NOT_SET")) continue;
                    character.getFriendlyOccupants().add(e.getAttribute("id"));
                    Main.game.getCharacterUtils().appendToImportLog(log, "<br/>Added occupant: " + e.getAttribute("id"));
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            try {
                for (int i = 0; i < ((Element)playerSpecificElement.getElementsByTagName("worldsVisited").item(0)).getElementsByTagName("world").getLength(); ++i) {
                    e = (Element)playerSpecificElement.getElementsByTagName("world").item(i);
                    character.getWorldsVisited().add(WorldType.getWorldTypeFromId(e.getAttribute("id")));
                    Main.game.getCharacterUtils().appendToImportLog(log, "<br/>Added world visited: " + e.getAttribute("id"));
                }
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        if (debug) {
            System.out.println("Initial loading: " + (double)(System.nanoTime() - time) / 1.0E9);
        }
        if (playerSpecificElement != null && !Main.isVersionOlderThan(version, "0.3.7.7")) {
            nodes = playerSpecificElement.getElementsByTagName("itemsDiscovered");
            element = (Element)nodes.item(0);
            nodes = element.getElementsByTagName("type");
            if (element != null && nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    e = (Element)nodes.item(i);
                    character.itemsDiscovered.add(ItemType.getItemTypeFromId(e.getTextContent()));
                }
            }
            nodes = playerSpecificElement.getElementsByTagName("weaponsDiscovered");
            element = (Element)nodes.item(0);
            nodes = element.getElementsByTagName("type");
            if (element != null && nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    e = (Element)nodes.item(i);
                    character.weaponsDiscovered.add(WeaponType.getWeaponTypeFromId(e.getTextContent()));
                }
            }
            nodes = playerSpecificElement.getElementsByTagName("clothingDiscovered");
            element = (Element)nodes.item(0);
            nodes = element.getElementsByTagName("type");
            if (element != null && nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    e = (Element)nodes.item(i);
                    character.clothingDiscovered.add(ClothingType.getClothingTypeFromId(e.getTextContent()));
                }
            }
            nodes = playerSpecificElement.getElementsByTagName("racesDiscovered");
            element = (Element)nodes.item(0);
            NodeList races = element.getElementsByTagName("race");
            if (element != null && races != null) {
                for (int i = 0; i < races.getLength(); ++i) {
                    Element e4 = (Element)races.item(i);
                    try {
                        character.subspeciesDiscovered.add(Subspecies.getSubspeciesFromId(e4.getTextContent()));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            nodes = playerSpecificElement.getElementsByTagName("racesDiscoveredAdvanced");
            element = (Element)nodes.item(0);
            races = element.getElementsByTagName("race");
            if (element != null && races != null) {
                for (int i = 0; i < races.getLength(); ++i) {
                    Element e5 = (Element)races.item(i);
                    try {
                        character.subspeciesDiscovered.add(Subspecies.getSubspeciesFromId(e5.getTextContent()));
                        character.subspeciesAdvancedKnowledge.add(Subspecies.getSubspeciesFromId(e5.getTextContent()));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (debug) {
            System.out.println("encyclopedia loading: " + (double)(System.nanoTime() - time) / 1.0E9);
        }
        if (Main.isVersionOlderThan(version, "0.3.0.5")) {
            if (character.getArmType().getRace() == Race.DEMON) {
                character.setArmType(ArmType.HUMAN);
            }
            if (character.getAssType().getRace() == Race.DEMON) {
                character.setAssType(AssType.HUMAN);
            }
            if (character.getBreastType().getRace() == Race.DEMON) {
                character.setBreastType(BreastType.HUMAN);
            }
            if (character.getEarType().getRace() == Race.DEMON) {
                character.setEarType(EarType.HUMAN);
            }
            if (character.getEyeType().getRace() == Race.DEMON) {
                character.setEyeType(EyeType.HUMAN);
            }
            if (character.getFaceType().getRace() == Race.DEMON) {
                character.setFaceType(FaceType.HUMAN);
            }
            if (character.getHairType().getRace() == Race.DEMON) {
                character.setHairType(HairType.HUMAN);
            }
            if (character.getHornType().getRace() == Race.DEMON) {
                character.setHornType(HornType.NONE);
            }
            if (character.getLegType().getRace() == Race.DEMON) {
                character.setLegType(LegType.HUMAN);
            }
            if (character.getPenisType().getRace() == Race.DEMON) {
                character.setPenisType(PenisType.HUMAN);
            }
            if (character.getTorsoType().getRace() == Race.DEMON) {
                character.setTorsoType(TorsoType.HUMAN);
            }
            if (character.getTailType().getRace() == Race.DEMON) {
                character.setTailType(TailType.NONE);
            }
            if (character.getVaginaType().getRace() == Race.DEMON) {
                character.setVaginaType(VaginaType.HUMAN);
            }
            if (character.getWingType().getRace() == Race.DEMON) {
                character.setWingType(WingType.NONE);
            }
            character.setSubspeciesOverride(null);
            character.getBody().calculateRace(character);
        }
        if (Main.isVersionOlderThan(version, "0.3.3.5")) {
            character.equipBasicCombatMoves();
        }
        if (Main.isVersionOlderThan(version, "0.3.4")) {
            character.ageAppearanceDifference = -3;
        }
        if (Main.isVersionOlderThan(version, "0.3.7.9") && character.hasQuest(QuestLine.ROMANCE_NATALYA)) {
            character.removeQuest(QuestLine.ROMANCE_NATALYA);
            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.natalyaVisited, false);
            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.natalyaInterviewOffered, false);
            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.natalyaBusy, false);
        }
        if (Main.isVersionOlderThan(version, "0.3.8") && character.isHasSlaverLicense()) {
            character.addItem(Main.game.getItemGen().generateItem(ItemType.SLAVER_LICENSE), false);
        }
        if (Main.isVersionOlderThan(version, "0.3.8.1")) {
            if (character.hasItemType(ItemType.NATALYA_BUSINESS_CARD_STAMPED)) {
                character.removeItemByType(ItemType.NATALYA_BUSINESS_CARD);
            } else if (character.isQuestProgressGreaterThan(QuestLine.ROMANCE_HELENA, Quest.ROMANCE_HELENA_3_B_EXTERIOR_DECORATOR) && !character.hasItemType(ItemType.NATALYA_BUSINESS_CARD) && !character.hasItemType(ItemType.NATALYA_BUSINESS_CARD_STAMPED)) {
                character.addItem(Main.game.getItemGen().generateItem(ItemType.NATALYA_BUSINESS_CARD), false);
            }
        }
        if (Main.isVersionOlderThan(version, "0.4.1.8") && !character.hasItemType("innoxia_quest_clothing_keys")) {
            character.addItem(Main.game.getItemGen().generateItem("innoxia_quest_clothing_keys"), false);
        }
        if (Main.isVersionOlderThan(version, "0.4.4.2") && character.getQuest(QuestLine.MAIN) == Quest.MAIN_1_J_ARTHURS_ROOM) {
            character.setQuestProgress(QuestLine.MAIN, Quest.MAIN_1_I_ARTHURS_TALE);
        }
        if (Main.isVersionOlderThan(version, "0.4.8.10") && character.isQuestCompleted(QuestLine.SIDE_EISEK_STALL)) {
            character.removeItem(Main.game.getItemGen().generateItem("dsg_quest_fabricbolt"), 1);
            character.removeItem(Main.game.getItemGen().generateItem("dsg_quest_embsign"), 1);
            character.removeItem(Main.game.getItemGen().generateItem("dsg_quest_awningpoles"), 4);
        }
        if (debug) {
            System.out.println("Player loading finished: " + (double)(System.nanoTime() - time) / 1.0E9);
        }
        return character;
    }

    @Override
    public void updateAttributeListeners(boolean requiresStatusEffectUpdate) {
        if (playerAttributeChangeEventListeners != null) {
            for (CharacterChangeEventListener eventListener : playerAttributeChangeEventListeners) {
                eventListener.onChange();
            }
        }
        if (requiresStatusEffectUpdate) {
            this.requiresAttributeStatusEffectCheck = true;
        }
    }

    @Override
    public void updateLocationListeners() {
        if (playerLocationChangeEventListeners != null) {
            for (CharacterChangeEventListener eventListener : playerLocationChangeEventListeners) {
                eventListener.onChange();
            }
        }
    }

    @Override
    public void updateInventoryListeners() {
        if (playerInventoryChangeEventListeners != null) {
            for (CharacterChangeEventListener eventListener : playerInventoryChangeEventListeners) {
                eventListener.onChange();
            }
        }
        this.requiresInventoryStatusEffectCheck = true;
    }

    @Override
    public String getId() {
        return "PlayerCharacter";
    }

    @Override
    public boolean isPlayer() {
        return true;
    }

    @Override
    public String getBodyDescription() {
        return this.body.getDescription(this);
    }

    @Override
    public String getDescription() {
        if (!Main.game.isInNewWorld()) {
            return "";
        }
        if (this.description == null || this.description.isEmpty()) {
            return "\u4f60\u88ab\u62c9\u8fdb\u4e86\u8389\u8389\u963f\u59e8\u535a\u7269\u9986\u91cc\u7684\u4e00\u9762\u9b54\u955c\uff0c\u9192\u6765\u540e\u53d1\u73b0\u81ea\u5df1\u8eab\u5904\u53e6\u4e00\u4e2a\u4e16\u754c\u3002\u5e78\u8fd0\u7684\u662f\uff0c\u4f60\u9047\u5230\u7684\u7b2c\u4e00\u4e2a\u4eba\u662f\u8389\u83b1\u96c5\u2014\u2014\u4f60\u5f02\u4e16\u754c\u7248\u672c\u7684\u59e8\u5988\u3002\u4f60\u8ba9\u5979\u76f8\u4fe1\u4e86\u4f60\u7684\u6545\u4e8b\u3002\u73b0\u5728\u4f60\u6b63\u60f3\u65b9\u8bbe\u6cd5\u56de\u5230\u539f\u6765\u7684\u4e16\u754c\u3002";
        }
        return UtilText.parse((GameCharacter)this, this.description, new ParserTag[0]);
    }

    @Override
    public void setLocation(AbstractWorldType worldLocation, Vector2i location, boolean setAsHomeLocation) {
        if (this.getWorldsVisited() != null && !this.getWorldsVisited().contains(worldLocation)) {
            this.getWorldsVisited().add(worldLocation);
            if (Main.game.isStarted()) {
                Main.game.addEvent(new EventLogEntry("[style.colourExcellent(\u5df2\u53d1\u73b0)]", Util.capitaliseSentence(worldLocation.getName())), false);
            }
        }
        if (Main.game.isStarted() && worldLocation != this.getWorldLocation()) {
            Main.game.addEvent(new EventLogEntry("[style.colourMinorGood(\u8fdb\u5165)]", Util.capitaliseSentence(worldLocation.getName())), false);
        }
        if (Main.game.isStarted() && Main.game.getActiveWorld().getCell(this.getLocation()).getPlace().isItemsDisappear()) {
            Main.game.getActiveWorld().getCell(this.getLocation()).resetInventory(Util.newArrayListOfValues(Rarity.LEGENDARY, Rarity.QUEST));
        }
        if (this.getWorldLocation() == WorldType.NIGHTLIFE_CLUB) {
            ArrayList<NPC> clubbers = new ArrayList<NPC>(Main.game.getNonCompanionCharactersPresent());
            clubbers.removeIf(npc -> npc.isUnique());
            AbstractWorldType worldLocationInitial = this.getWorldLocation();
            Vector2i locationInitial = this.getLocation();
            super.setLocation(worldLocation, location, setAsHomeLocation);
            for (GameCharacter gameCharacter : clubbers) {
                gameCharacter.setLocation(this, false);
                if (worldLocation == worldLocationInitial && location.equals(locationInitial)) continue;
                Main.game.getWorlds().get(worldLocationInitial).getCell(locationInitial).removeCharacterPresentId(gameCharacter.getId());
            }
        } else {
            super.setLocation(worldLocation, location, setAsHomeLocation);
        }
    }

    public void discoverSurroundingCells() {
        Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).setDiscovered(true);
        Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).setTravelledTo(true);
        if (Main.game.getPlayer().getLocation().getY() < Main.game.getActiveWorld().WORLD_HEIGHT - 1) {
            Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation().getX(), Main.game.getPlayer().getLocation().getY() + 1).setDiscovered(true);
        }
        if (Main.game.getPlayer().getLocation().getY() != 0) {
            Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation().getX(), Main.game.getPlayer().getLocation().getY() - 1).setDiscovered(true);
        }
        if (Main.game.getPlayer().getLocation().getX() < Main.game.getActiveWorld().WORLD_WIDTH - 1) {
            Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation().getX() + 1, Main.game.getPlayer().getLocation().getY()).setDiscovered(true);
        }
        if (Main.game.getPlayer().getLocation().getX() != 0) {
            Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation().getX() - 1, Main.game.getPlayer().getLocation().getY()).setDiscovered(true);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getPetName(GameCharacter target) {
        if (target instanceof Lyssieth && this.getRace() == Race.DEMON) {
            if (this.hasFetish(Fetish.FETISH_INCEST)) {
                return "\u5988\u54aa";
            }
            return "\u5988\u5988";
        }
        return super.getPetName(target);
    }

    public int getKarma() {
        return this.karma;
    }

    public void setKarma(int karma) {
        this.karma = karma;
    }

    public void incrementKarma(int increment) {
        this.karma += increment;
    }

    @Override
    public Set<Relationship> getRelationshipsTo(GameCharacter character, Relationship ... excludedRelationships) {
        if (character instanceof Lilaya) {
            LinkedHashSet<Relationship> rSet = new LinkedHashSet<Relationship>();
            rSet.add(Relationship.Nibling);
            if (Main.game.getDialogueFlags().hasFlag("innoxia_child_of_lyssieth")) {
                rSet.add(Relationship.HalfSibling);
            }
            return rSet;
        }
        if (Main.game.getDialogueFlags().hasFlag("innoxia_child_of_lyssieth")) {
            if (character instanceof Lyssieth) {
                return Util.newHashSetOfValues(Relationship.Child);
            }
            if (character instanceof DarkSiren || character instanceof Elizabeth) {
                return Util.newHashSetOfValues(Relationship.HalfSibling);
            }
        }
        return super.getRelationshipsTo(character, excludedRelationships);
    }

    public GameCharacter getLilinMother() {
        DialogueFlags dialogueFlags = Main.game.getDialogueFlags();
        if (dialogueFlags.hasFlag("innoxia_child_of_lyssieth")) {
            return Main.game.getNpc(Lyssieth.class);
        }
        if (dialogueFlags.hasFlag("innoxia_child_of_lunette") || dialogueFlags.hasFlag("innoxia_child_of_lirecea") || dialogueFlags.hasFlag("innoxia_child_of_lovienne") || dialogueFlags.hasFlag("innoxia_child_of_lasielle") || dialogueFlags.hasFlag("innoxia_child_of_lyxias") || dialogueFlags.hasFlag("innoxia_child_of_lisophia") || dialogueFlags.hasFlag("innoxia_child_of_lilith")) {
            // empty if block
        }
        System.err.println("Warning: Did not find a suitable lilin in getLilinMother()!");
        new Exception().printStackTrace();
        return Main.game.getNpc(Lyssieth.class);
    }

    public void resetAllQuests() {
        this.quests = new EnumMap<QuestLine, List<Quest>>(QuestLine.class);
    }

    public boolean isMainQuestUpdated() {
        return this.mainQuestUpdated;
    }

    public void setMainQuestUpdated(boolean mainQuestUpdated) {
        this.mainQuestUpdated = mainQuestUpdated;
    }

    public boolean isSideQuestUpdated() {
        return this.sideQuestUpdated;
    }

    public void setSideQuestUpdated(boolean sideQuestUpdated) {
        this.sideQuestUpdated = sideQuestUpdated;
    }

    public boolean isRelationshipQuestUpdated() {
        return this.relationshipQuestUpdated;
    }

    public void setRelationshipQuestUpdated(boolean relationshipQuestUpdated) {
        this.relationshipQuestUpdated = relationshipQuestUpdated;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public Map<QuestLine, Quest> getQuestsFailed() {
        return this.questsFailed;
    }

    public boolean isQuestFailed(QuestLine questLine) {
        return this.questsFailed.containsKey((Object)questLine);
    }

    public String setQuestFailed(QuestLine questLine, Quest questFail) {
        this.questsFailed.put(questLine, questFail);
        return "<p style='text-align:center;'>[style.boldBad(\u4efb\u52a1\u5931\u8d25\uff1a" + questLine.getName() + ")]</p>";
    }

    public String startQuest(QuestLine questLine) {
        return this.setQuestProgress(questLine, questLine.getQuestTree().getData());
    }

    public String addOptionalQuestProgress(QuestLine questLine, Quest quest) {
        if (!this.quests.containsKey((Object)questLine)) {
            System.err.println("Player does not have quest line " + String.valueOf((Object)questLine) + ", so cannot add optional quest: " + String.valueOf((Object)quest));
            return "";
        }
        if (questLine.getType() == QuestType.MAIN) {
            this.setMainQuestUpdated(true);
        } else if (questLine.getType() == QuestType.SIDE) {
            this.setSideQuestUpdated(true);
        } else {
            this.setRelationshipQuestUpdated(true);
        }
        String experienceUpdate = this.incrementExperience(quest.getExperienceReward(), true);
        this.quests.get((Object)questLine).add(0, quest);
        Main.game.addEvent(new EventLogEntry("[style.colourGood(\u5df2\u5b8c\u6210\u53ef\u9009\u4efb\u52a1)]", quest.getName()), false);
        return "<p style='text-align:center;'><b style='color:" + questLine.getType().getColour().toWebHexString() + ";'>\u4efb\u52a1\uff1a" + questLine.getName() + "</b><br/><b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u5df2\u5b8c\u6210\u53ef\u9009\u4efb\u52a1\uff1a" + quest.getName() + "</b><br/>" + experienceUpdate;
    }

    public String setQuestProgress(QuestLine questLine, Quest quest) {
        if (!questLine.getQuestTree().childrenContainsData(quest)) {
            System.err.println("QuestTree in quest line " + String.valueOf((Object)questLine) + " does not contain quest: " + String.valueOf((Object)quest));
            return "";
        }
        if (questLine.getType() == QuestType.MAIN) {
            this.setMainQuestUpdated(true);
        } else if (questLine.getType() == QuestType.SIDE) {
            this.setSideQuestUpdated(true);
        } else {
            this.setRelationshipQuestUpdated(true);
        }
        if (this.quests.containsKey((Object)questLine)) {
            Quest currentQuest = questLine.getQuestTree().getFirstNodeWithData(this.getQuest(questLine)).getData();
            String experienceUpdate = this.incrementExperience(currentQuest.getExperienceReward(), true);
            this.quests.get((Object)questLine).add(quest);
            if (questLine.getQuestTree().getFirstNodeWithData(quest).getChildren().isEmpty()) {
                Main.game.addEvent(new EventLogEntry("[style.colourExcellent(\u4efb\u52a1\u5b8c\u6210)]", questLine.getName()), false);
                return "<p style='text-align:center;'><b style='color:" + questLine.getType().getColour().toWebHexString() + ";'>\u4efb\u52a1\uff1a" + questLine.getName() + "</b><br/><b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u4efb\u52a1\u5b8c\u6210</b><b>\uff1a" + currentQuest.getName() + "</b><br/><b>\u6240\u6709\u4efb\u52a1\u5df2\u5b8c\u6210\uff01</b></p>" + experienceUpdate;
            }
            Main.game.addEvent(new EventLogEntry("[style.colourMinorGood(\u65b0\u4efb\u52a1)]", quest.getName()), false);
            return "<p style='text-align:center;'><b style='color:" + questLine.getType().getColour().toWebHexString() + ";'>\u4efb\u52a1\uff1a" + questLine.getName() + "</b><br/><b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u4efb\u52a1\u5b8c\u6210 - " + currentQuest.getName() + "</b><br/><b>\u65b0\u4efb\u52a1 - " + quest.getName() + "</b></p>" + experienceUpdate;
        }
        this.quests.put(questLine, new ArrayList());
        this.quests.get((Object)questLine).add(quest);
        Main.game.addEvent(new EventLogEntry("[style.colourGood(\u4efb\u52a1\u5f00\u59cb)]", questLine.getName()), false);
        return "<p style='text-align:center;'><b style='color:" + questLine.getType().getColour().toWebHexString() + ";'>\u65b0\u4efb\u52a1\uff1a" + questLine.getName() + "</b><br/><b>\u65b0\u4efb\u52a1 - " + quest.getName() + "</b></p>";
    }

    public void removeQuest(QuestLine questLine) {
        this.quests.remove((Object)questLine);
    }

    public Map<QuestLine, List<Quest>> getQuests() {
        return this.quests;
    }

    public Quest getQuest(QuestLine questLine) {
        List<Quest> quests = this.quests.get((Object)questLine);
        if (quests == null) {
            return null;
        }
        return quests.get(quests.size() - 1);
    }

    public boolean hasQuest(QuestLine questLine) {
        return this.quests.containsKey((Object)questLine);
    }

    public boolean hasQuestInLine(QuestLine questLine, Quest quest) {
        if (!this.hasQuest(questLine)) {
            return false;
        }
        return this.quests.get((Object)questLine).contains((Object)quest);
    }

    public boolean isSubQuestCompleted(Quest subQuest, QuestLine questLine) {
        return this.quests.containsKey((Object)questLine) && this.quests.get((Object)questLine).contains((Object)subQuest) && this.getQuest(questLine) != subQuest;
    }

    public boolean isQuestCompleted(QuestLine questLine) {
        if (!this.hasQuest(questLine)) {
            return false;
        }
        return questLine.getQuestTree().getFirstNodeWithData(this.getQuest(questLine)).getChildren().isEmpty();
    }

    public boolean isHasSlaverLicense() {
        return this.isQuestCompleted(QuestLine.SIDE_SLAVERY) || Main.game.isDebugMode();
    }

    public boolean isAbleToAccessRoomManagement() {
        return this.isHasSlaverLicense() || this.isQuestCompleted(QuestLine.SIDE_ACCOMMODATION) || this.isQuestCompleted(QuestLine.SIDE_DOLL_STORAGE);
    }

    public boolean isQuestProgressGreaterThan(QuestLine questLine, Quest quest) {
        if (!this.hasQuest(questLine)) {
            return false;
        }
        if (questLine.getQuestTree().getFirstNodeWithData(quest) == null) {
            System.err.println("Quest " + quest.toString() + " was not in QuestLine!");
            return false;
        }
        return questLine.getQuestTree().getFirstNodeWithData(this.getQuest(questLine)).getFirstNodeWithData(quest) == null;
    }

    public boolean isQuestProgressLessThan(QuestLine questLine, Quest quest) {
        if (!this.hasQuest(questLine)) {
            return true;
        }
        if (this.getQuest(questLine) == quest) {
            return false;
        }
        if (questLine.getQuestTree().getFirstNodeWithData(quest) == null) {
            System.err.println("Quest " + quest.toString() + " was not in QuestLine!");
            return false;
        }
        return questLine.getQuestTree().getFirstNodeWithData(this.getQuest(questLine)).getFirstNodeWithData(quest) != null;
    }

    public List<String> getCharactersEncountered() {
        return this.charactersEncountered;
    }

    public void addCharacterEncountered(String character) {
        if (!this.charactersEncountered.contains(character)) {
            this.charactersEncountered.add(character);
            if (Main.game.isStarted()) {
                this.sortCharactersEncountered();
            }
        }
    }

    public void addCharacterEncountered(GameCharacter character) {
        if (!this.charactersEncountered.contains(character.getId())) {
            this.charactersEncountered.add(character.getId());
            if (Main.game.isStarted()) {
                this.sortCharactersEncountered();
            }
        }
    }

    public List<GameCharacter> getCharactersEncounteredAsGameCharacters(boolean expansiveSearch) {
        GameCharacter npc;
        ArrayList<GameCharacter> npcsEncountered = new ArrayList<GameCharacter>();
        this.charactersEncountered.removeIf(id -> !Main.game.isCharacterExisting((String)id));
        for (String characterId : this.charactersEncountered) {
            try {
                npc = Main.game.getNPCById(characterId);
                npcsEncountered.add(npc);
            }
            catch (Exception e) {
                Util.logGetNpcByIdError("getCharactersEncounteredAsGameCharacters()", characterId);
            }
        }
        if (expansiveSearch) {
            for (String id2 : this.sexCount.keySet()) {
                try {
                    npc = Main.game.getNPCById(id2);
                    npcsEncountered.add(npc);
                }
                catch (Exception exception) {}
            }
        }
        return npcsEncountered;
    }

    public void sortCharactersEncountered() {
        ArrayList<GameCharacter> npcsEncountered = new ArrayList<GameCharacter>();
        this.charactersEncountered.removeIf(id -> !Main.game.isCharacterExisting((String)id));
        for (String characterId : this.charactersEncountered) {
            try {
                GameCharacter npc = Main.game.getNPCById(characterId);
                npcsEncountered.add(npc);
            }
            catch (Exception e) {
                Util.logGetNpcByIdError("sortCharactersEncountered()", characterId);
            }
        }
        npcsEncountered.sort((npc1, npc2) -> npc1 instanceof NPCOffspring ? (npc2 instanceof NPCOffspring ? npc1.getName(true).compareTo(npc2.getName(true)) : 1) : (npc2 instanceof NPCOffspring ? -1 : npc1.getName(true).compareTo(npc2.getName(true))));
        ArrayList<String> sortedIDs = new ArrayList<String>();
        for (GameCharacter character : npcsEncountered) {
            sortedIDs.add(character.getId());
        }
        this.charactersEncountered = sortedIDs;
    }

    public SizedStack<ShopTransaction> getBuybackStack() {
        return this.buybackStack;
    }

    public void applyDiscoveriesToProperties() {
        for (AbstractItemType itemType : this.itemsDiscovered) {
            Main.getProperties().addItemDiscovered(itemType);
        }
        for (AbstractWeaponType weaponType : this.weaponsDiscovered) {
            Main.getProperties().addWeaponDiscovered(weaponType);
        }
        for (AbstractClothingType clothingType : this.clothingDiscovered) {
            Main.getProperties().addClothingDiscovered(clothingType);
        }
        for (AbstractSubspecies subspecies : this.subspeciesDiscovered) {
            Main.getProperties().addRaceDiscovered(subspecies, false);
        }
        for (AbstractSubspecies subspecies : this.subspeciesAdvancedKnowledge) {
            Main.getProperties().addAdvancedRaceKnowledge(subspecies, false);
        }
    }

    public boolean addRaceDiscoveredFromBook(AbstractSubspecies subspecies) {
        return this.racesDiscoveredFromBook.add(subspecies);
    }

    public Set<AbstractSubspecies> getRacesDiscoveredFromBook() {
        return this.racesDiscoveredFromBook;
    }

    public int getItemsDiscoveredCount() {
        return this.itemsDiscovered.size();
    }

    public boolean addItemDiscovered(AbstractItemType itemType) {
        return this.itemsDiscovered.add(itemType);
    }

    public boolean isItemDiscovered(AbstractItemType itemType) {
        return this.itemsDiscovered.contains(itemType);
    }

    public int getClothingDiscoveredCount() {
        return this.clothingDiscovered.size();
    }

    public boolean addClothingDiscovered(AbstractClothingType clothingType) {
        return this.clothingDiscovered.add(clothingType);
    }

    public boolean isClothingDiscovered(AbstractClothingType clothingType) {
        return this.clothingDiscovered.contains(clothingType);
    }

    public int getWeaponsDiscoveredCount() {
        return this.weaponsDiscovered.size();
    }

    public boolean addWeaponDiscovered(AbstractWeaponType weaponType) {
        return this.weaponsDiscovered.add(weaponType);
    }

    public boolean isWeaponDiscovered(AbstractWeaponType weaponType) {
        return this.weaponsDiscovered.contains(weaponType);
    }

    public Set<AbstractSubspecies> getSubspeciesDiscovered() {
        return new HashSet<AbstractSubspecies>(this.subspeciesDiscovered);
    }

    public int getSubspeciesDiscoveredCount() {
        return this.subspeciesDiscovered.size();
    }

    public boolean addRaceDiscovered(AbstractSubspecies subspecies) {
        return this.subspeciesDiscovered.add(subspecies);
    }

    public boolean isRaceDiscovered(AbstractSubspecies subspecies) {
        return this.subspeciesDiscovered.contains(subspecies);
    }

    public Set<AbstractSubspecies> getSubspeciesAdvancedDiscovered() {
        return new HashSet<AbstractSubspecies>(this.subspeciesAdvancedKnowledge);
    }

    public int getSubspeciesAdvancedDiscoveredCount() {
        return this.subspeciesAdvancedKnowledge.size();
    }

    public boolean addAdvancedRaceKnowledge(AbstractSubspecies subspecies) {
        return this.subspeciesAdvancedKnowledge.add(subspecies);
    }

    public boolean isAdvancedRaceKnowledgeDiscovered(AbstractSubspecies subspecies) {
        if (this.subspeciesAdvancedKnowledge.contains(subspecies)) {
            return true;
        }
        AbstractSubspecies coreSubspecies = AbstractSubspecies.getMainSubspeciesOfRace(subspecies.getRace());
        if (ItemType.getLoreBook(subspecies).equals(ItemType.getLoreBook(coreSubspecies))) {
            return this.subspeciesAdvancedKnowledge.contains(coreSubspecies);
        }
        return false;
    }

    @Override
    public String getSpellDescription() {
        return "<p>" + UtilText.parse((GameCharacter)this, UtilText.returnStringAtRandom("\u96c6\u4e2d\u7cbe\u529b\u5229\u7528\u4f60\u7684\u5965\u672f\u7075\u6c14\u7684\u529b\u91cf\uff0c\u4f60\u5c06[pc.arm]\u4e3e\u5230\u534a\u7a7a\u4e2d\uff0c\u5e76\u65bd\u653e\u4e86\u4e00\u4e2a\u6cd5\u672f\uff01"), new ParserTag[0]) + "</p>";
    }

    @Override
    public String getSeductionDescription(GameCharacter target) {
        String description = "";
        if (this.hasStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION) || this.hasStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION_POWER_OF_SUGGESTION) || this.hasStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION_PROJECTED_TOUCH)) {
            if (this.isFeminine()) {
                return UtilText.parse(target, UtilText.returnStringAtRandom("\u4f60\u9732\u51fa\u4e00\u526f\u79ef\u6b32\u5df2\u4e45\u7684\u8868\u60c5\uff0c\u5f53\u4e0e[npc.namePos]\u56db\u76ee\u76f8\u5bf9\u65f6\uff0c\u4f60\u53d1\u51fa\u4e00\u6bb5\u683c\u5916\u6deb\u8361\u7684\u547b\u541f\uff0c\u6295\u5165\u4e86[npc.her]\u7684\u8111\u5185\uff0c[pc.thought(~\u554a\u554a\u554a\uff01~" + (this.hasVagina() ? "\u4f60\u8ba9\u6211\u6e7f\u900f\u4e86\uff01" : (this.hasPenis() ? "\u4f60\u8ba9\u6211\u53d8\u5f97\u771f\u7684\u5f88\u786c\uff01" : "\u4f60\u8ba9\u6211\u597d\u5174\u594b\u554a\uff01")) + ")]", "\u4f60\u4e0e[npc.namePos]\u7d27\u7d27\u5bf9\u89c6\u7740\uff0c\u4f60\u6485\u8d77\u5634\uff0c\u9732\u51fa\u4e00\u526f\u6781\u5176\u7eaf\u6d01\u7684\u8868\u60c5\uff0c\u63a5\u7740\u4fbf\u53d1\u51fa\u4e86\u4e00\u58f0\u56de\u8361\u7684\u547b\u541f\uff0c\u6295\u5165\u4e86[npc.her]\u7684\u8111\u5185\uff0c[pc.thought(" + (this.hasVagina() ? "~\u55ef\u55ef\u55ef\uff01~\u64cd\u6211\u554a\uff01~\u554a\u554a\uff01~\u6211\u7684\u5c0f\u7a74\u65e9\u5c31\u4e3a\u4f60\u6e7f\u597d\u4e86\uff01" : (this.hasPenis() ? "~\u5514\u59c6\uff01~ \u6211\u7b49\u4e0d\u53ca\u8981\u64cd\u4f60\u4e86\uff01\u4f60\u80af\u5b9a\u4f1a\u559c\u6b22\u6211\u7684\u8089\u68d2\u7684\uff01" : "~\u55ef\u55ef\u55ef\uff01~\u64cd\u6211\u554a\uff01~\u554a\u554a\uff01~\u6211\u771f\u7684\u5f88\u60f3\u8981\u4f60\uff01")) + ")]", this.hasStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION_POWER_OF_SUGGESTION) || this.hasStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION_PROJECTED_TOUCH) ? "\u4f60\u7eaf\u6d01\u5730\u5bf9\u7740[npc.name]\u6485\u8d77\u5634\u5df4\uff0c\u63a5\u7740\u9001\u4e0a\u4e86\u4e00\u8bb0\u6e7f\u543b\u3002\u5f53\u4f60\u9000\u56de\u8eab\u5b50\u540e\uff0c\u7565\u65bd\u5c0f\u8ba1\uff0c\u4e00\u5bf9\u6e7f\u6da6\u7684\u5634\u5507\u7684\u611f\u89c9\u9b3c\u4f7f\u795e\u5dee\u5730\u8d34\u5728\u4e86[npc.her]\u7684\u8138\u988a\u4e0a\u3002" : ""), new ParserTag[0]);
            }
            return UtilText.parse(target, UtilText.returnStringAtRandom("\u4f60\u9732\u51fa\u4e00\u526f\u81ea\u4fe1\u7684\u8868\u60c5\uff0c\u5f53\u4e0e[npc.namePos]\u56db\u76ee\u76f8\u5bf9\u65f6\uff0c\u4f60\u53d1\u51fa\u4e00\u6bb5\u683c\u5916\u6deb\u8361\u7684\u547b\u541f\uff0c\u6295\u5165\u4e86[npc.her]\u7684\u8111\u5185\uff0c[pc.thought(~\u55ef\u55ef\u55ef\uff01~" + (this.hasVagina() ? "\u4f60\u8ba9\u6211\u6e7f\u900f\u4e86\uff01" : (this.hasPenis() ? "\u4f60\u8ba9\u6211\u53d8\u5f97\u771f\u7684\u5f88\u786c\uff01" : "\u4f60\u8ba9\u6211\u597d\u5174\u594b\u554a\uff01")) + ")]", "\u4f60\u4e0e[npc.namePos]\u7d27\u7d27\u5bf9\u89c6\u7740\uff0c\u4f60\u5411[npc.herHim]\u9001\u53bb\u4e00\u4e2a\u8ff7\u4eba\u7684\u5fae\u7b11\uff0c\u63a5\u7740\u4fbf\u53d1\u51fa\u4e86\u4e00\u58f0\u56de\u8361\u7684\u547b\u541f\uff0c\u6295\u5165\u4e86[npc.her]\u7684\u8111\u5185\uff0c[pc.thought(" + (this.hasVagina() ? "~\u55ef\u55ef\u55ef\uff01~\u64cd\u6211\u554a\uff01~\u554a\u554a\uff01~\u6211\u7684\u5c0f\u7a74\u65e9\u5c31\u4e3a\u4f60\u6e7f\u597d\u4e86\uff01" : (this.hasPenis() ? "~\u5514\u59c6\uff01~ \u6211\u7b49\u4e0d\u53ca\u8981\u64cd\u4f60\u4e86\uff01\u4f60\u80af\u5b9a\u4f1a\u559c\u6b22\u6211\u7684\u8089\u68d2\u7684\uff01" : "~\u55ef\u55ef\u55ef\uff01~ \u6211\u7b49\u4e0d\u53ca\u8981\u548c\u4f60\u723d\u4e00\u723d\u4e86\uff01")) + ")]", this.hasStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION_POWER_OF_SUGGESTION) || this.hasStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION_PROJECTED_TOUCH) ? "\u4f60\u5411[npc.name]\u629b\u51fa\u8ff7\u4eba\u7684\u5fae\u7b11\uff0c\u53c8\u6446\u51fa\u4e2a\u82f1\u96c4\u7684\u59ff\u52bf\uff0c\u5411[npc.herHim]\u7728\u4e86\u7728\u773c\u3002\u4f60\u6446\u6b63\u8eab\u59ff\u540e\uff0c\u5411[npc.herHim]\u6295\u5c04\u4e00\u5bf9\u865a\u5e7b\u7684\u81c2\u5f2f\uff0c\u5c06\u5176\u63fd\u5165\u4e86\u81ea\u4fe1\u7684\u6df1\u62e5\u3002" : ""), new ParserTag[0]);
        }
        description = this.isFeminine() ? UtilText.parse(target, UtilText.returnStringAtRandom("\u4f60\u5411[npc.name]\u9001\u53bb\u4e00\u4e2a\u98de\u543b\uff0c\u968f\u540e\u6697\u793a\u5730\u671d[npc.herHim]\u7728\u4e86\u7728\u773c\u3002", "\u4f60\u8f7b\u54ac\u4e0b\u5507\uff0c\u663e\u9732\u51fa\u79ef\u6b32\u5df2\u4e45\u7684\u8868\u60c5\uff0c\u624b\u6e10\u6e10\u5730\u5411\u81ea\u5df1\u7684\u5927\u817f\u5185\u4fa7\u6478\u53bb\u3002", "\u4f60\u5bf9\u7740[npc.name]\u6446\u51fa\u4e86\u6700\u7eaf\u6d01\u7684\u8868\u60c5\uff0c\u5411[npc.herHim]\u9001\u53bb\u4e00\u62b9\u6d45\u543b\u3002", "\u4f60\u8f6c\u8fc7\u8eab\uff0c\u53d1\u51fa\u4e00\u9635\u73a9\u5473\u7684\u7b11\u58f0\uff0c\u5bf9\u7740\u81ea\u5df1[pc.ass+]\u62cd\u4e86\u4e00\u4e0b\u3002", "\u63a5\u7740\u6cbf\u7740\u8eab\u4f53\u66f2\u7ebf\u4e00\u76f4\u5411\u4e0a\u629a\u6478\uff0c\u6700\u540e\u5411[npc.Name]\u561f\u8d77\u4e86\u5634\u5df4\u3002"), new ParserTag[0]) : UtilText.parse(target, UtilText.returnStringAtRandom("\u4f60\u5411[npc.name]\u9001\u53bb\u4e00\u4e2a\u98de\u543b\uff0c\u968f\u540e\u6697\u793a\u5730\u671d[npc.herHim]\u7728\u4e86\u7728\u773c\u3002", "\u4f60\u5411[npc.name]\u81ea\u4fe1\u4e00\u7b11\uff0c\u6162\u6162\u5c06\u624b\u6478\u5411\u81ea\u5df1\u7684\u5927\u817f\u5185\u4fa7\u3002", "\u4f60\u8bf1\u4eba\u7684\u76ee\u5149\u843d\u5728\u4e86[npc.Name]\u7684\u8eab\u4e0a\uff0c\u98de\u543b\u7d27\u63a5\u800c\u81f3\u3002", "\u4f60\u8f6c\u8fc7\u8eab\uff0c\u8c03\u76ae\u7684\u5b09\u7b11\u58f0\u4e0e\u62cd\u81ea\u5df1[pc.ass+]\u7684\u58f0\u97f3\u4e00\u540c\u54cd\u8d77\u3002", "\u4f60\u7528\u5c3d\u6d51\u8eab\u89e3\u6570\uff0c\u67b6\u8d77\u4e00\u526f\u5c45\u9ad8\u4e34\u4e0b\u7684\u6a21\u6837\uff0c\u5bf9[npc.Name]\u9732\u51fa\u597d\u73a9\u7684\u5f97\u610f\u5fae\u7b11\u3002"), new ParserTag[0]);
        return description;
    }

    @Override
    public boolean isAbleToBeImpregnated() {
        return true;
    }

    @Override
    public boolean isAbleToBeEgged() {
        return !this.hasPerkAnywhereInTree(Perk.DOLL_PHYSICAL_2);
    }

    @Override
    public SexActionOrgasmOverride getSexActionOrgasmOverride(SexActionInterface sexAction, OrgasmCumTarget target, final boolean applyExtraEffects, String description) {
        if (Main.sex.getAllParticipants().contains(Main.game.getNpc(Scarlett.class)) && Main.sex.getOngoingSexAreas(this, SexAreaOrifice.ANUS, Main.game.getNpc(Scarlett.class)).contains(SexAreaPenetration.PENIS) && Main.sex.getSexPace(Main.game.getNpc(Scarlett.class)) == SexPace.DOM_ROUGH) {
            final StringBuilder sb = new StringBuilder();
            if (description != null) {
                sb.append(description);
            } else {
                sb.append(GenericOrgasms.getGenericOrgasmDescription(sexAction, this, target));
            }
            sb.append(UtilText.parseFromXMLFile("characters/dominion/scarlett", "ROUGH_ANAL_ORGASM"));
            return new SexActionOrgasmOverride(false){

                @Override
                public String getDescription() {
                    return sb.toString();
                }

                @Override
                public void applyEffects() {
                }
            };
        }
        if (Main.sex.getAllParticipants().contains(Main.game.getNpc(Lilaya.class)) && Main.game.getNpc(Lilaya.class).getFetishDesire(Fetish.FETISH_PREGNANCY).isNegative() && !Main.game.getNpc(Lilaya.class).isVisiblyPregnant()) {
            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.lilayaAmazonsSecretImpregnation, false);
            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.lilayaCondomBroke, false);
            boolean triggerEndScene = false;
            final StringBuilder sb = new StringBuilder();
            if (description != null) {
                sb.append(description);
            } else {
                sb.append(GenericOrgasms.getGenericOrgasmDescription(sexAction, this, target));
            }
            if (target == OrgasmCumTarget.INSIDE && this.getCurrentPenisRawCumStorageValue() > 0 && Main.sex.getOngoingSexAreas(this, SexAreaPenetration.PENIS, Main.game.getNpc(Lilaya.class)).contains(SexAreaOrifice.VAGINA)) {
                if (this.isWearingCondom()) {
                    if (sexAction.getCondomFailure(this, Main.game.getNpc(Lilaya.class)) != CondomFailure.NONE) {
                        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.lilayaCondomBroke, true);
                        sb.append(UtilText.parseFromXMLFile("characters/dominion/lilaya", "ORGASM_REACTION_CREAMPIE_CONDOM_BROKE"));
                    } else {
                        sb.append(UtilText.parseFromXMLFile("characters/dominion/lilaya", "ORGASM_REACTION_CREAMPIE_CONDOM"));
                    }
                } else {
                    sb.append(UtilText.parseFromXMLFile("characters/dominion/lilaya", "ORGASM_REACTION_CREAMPIE"));
                }
                triggerEndScene = true;
            } else if (this.hasStatusEffect("innoxia_amazons_secret")) {
                HashSet<GameCharacter> charactersContactingVagina = new HashSet<GameCharacter>(Main.sex.getOngoingCharactersUsingAreas(this, SexAreaOrifice.VAGINA, SexAreaPenetration.CLIT));
                charactersContactingVagina.addAll(Main.sex.getOngoingCharactersUsingAreas(this, SexAreaPenetration.CLIT, SexAreaOrifice.VAGINA));
                charactersContactingVagina.addAll(Main.sex.getOngoingCharactersUsingAreas(this, SexAreaOrifice.VAGINA, SexAreaOrifice.VAGINA));
                charactersContactingVagina.addAll(Main.sex.getOngoingCharactersUsingAreas(this, SexAreaPenetration.CLIT, SexAreaPenetration.CLIT));
                if (charactersContactingVagina.contains(Main.game.getNpc(Lilaya.class))) {
                    Main.game.getDialogueFlags().setFlag(DialogueFlagValue.lilayaAmazonsSecretImpregnation, true);
                    triggerEndScene = true;
                    sb.append(UtilText.parseFromXMLFile("characters/dominion/lilaya", "ORGASM_REACTION_AMAZONS_SECRET"));
                }
            }
            if (triggerEndScene) {
                return new SexActionOrgasmOverride(false){

                    @Override
                    public String getDescription() {
                        return sb.toString();
                    }

                    @Override
                    public void applyEffects() {
                    }

                    @Override
                    public boolean isEndsSex() {
                        return Main.game.getNpc(Lilaya.class).hasStatusEffect(StatusEffect.PREGNANT_0) && Main.game.getNpc(Lilaya.class).getFetishDesire(Fetish.FETISH_PREGNANCY).isNegative();
                    }
                };
            }
        }
        if (Main.sex.getSexManager() instanceof SMLyssiethDemonTF) {
            final StringBuilder sb = new StringBuilder();
            if (description != null) {
                sb.append(description);
            } else {
                sb.append(GenericOrgasms.getGenericOrgasmDescription(sexAction, this, target));
            }
            if (Main.sex.getLastUsedSexAction(Main.game.getNpc(Lyssieth.class)).getActionType() == SexActionType.ORGASM) {
                if (Main.sex.getNumberOfOrgasms(Main.game.getNpc(Lyssieth.class)) == 1) {
                    if (Main.sex.getOngoingSexAreas(this, SexAreaOrifice.MOUTH, Main.game.getNpc(Lyssieth.class)).contains(SexAreaPenetration.PENIS)) {
                        sb.append(UtilText.parseFromXMLFile("characters/submission/lyssieth", "DEMON_TF_STAGE_1_PC_GIVING_LYSSIETH_BLOWJOB_END"));
                        return new SexActionOrgasmOverride(false){

                            @Override
                            public String getDescription() {
                                return sb.toString();
                            }

                            @Override
                            public void applyEffects() {
                            }
                        };
                    }
                    if (Main.sex.getOngoingSexAreas(this, SexAreaPenetration.TONGUE, Main.game.getNpc(Lyssieth.class)).contains(SexAreaOrifice.VAGINA)) {
                        sb.append(UtilText.parseFromXMLFile("characters/submission/lyssieth", "DEMON_TF_STAGE_1_PC_GIVING_LYSSIETH_CUNNILINGUS_END"));
                        return new SexActionOrgasmOverride(false){

                            @Override
                            public String getDescription() {
                                return sb.toString();
                            }

                            @Override
                            public void applyEffects() {
                            }
                        };
                    }
                    if (Main.sex.getOngoingSexAreas(this, SexAreaPenetration.PENIS, Main.game.getNpc(Lyssieth.class)).contains(SexAreaOrifice.MOUTH)) {
                        sb.append(UtilText.parseFromXMLFile("characters/submission/lyssieth", "DEMON_TF_STAGE_1_PC_GETTING_BLOWJOB_FROM_LYSSIETH_END"));
                        return new SexActionOrgasmOverride(false){

                            @Override
                            public String getDescription() {
                                return sb.toString();
                            }

                            @Override
                            public void applyEffects() {
                            }
                        };
                    }
                    if (Main.sex.getOngoingSexAreas(this, SexAreaOrifice.VAGINA, Main.game.getNpc(Lyssieth.class)).contains(SexAreaPenetration.TONGUE)) {
                        sb.append(UtilText.parseFromXMLFile("characters/submission/lyssieth", "DEMON_TF_STAGE_1_PC_GETTING_CUNNILINGUS_FROM_LYSSIETH_END"));
                        return new SexActionOrgasmOverride(false){

                            @Override
                            public String getDescription() {
                                return sb.toString();
                            }

                            @Override
                            public void applyEffects() {
                            }
                        };
                    }
                } else if (Main.sex.getNumberOfOrgasms(Main.game.getNpc(Lyssieth.class)) == 2) {
                    if (Main.sex.getOngoingSexAreas(this, SexAreaOrifice.VAGINA, Main.game.getNpc(Lyssieth.class)).contains(SexAreaPenetration.PENIS)) {
                        sb.append(UtilText.parseFromXMLFile("characters/submission/lyssieth", "DEMON_TF_STAGE_2_PC_PUSSY_FUCKED_BY_LYSSIETH_END"));
                        return new SexActionOrgasmOverride(false){

                            @Override
                            public String getDescription() {
                                return sb.toString();
                            }

                            @Override
                            public void applyEffects() {
                            }

                            @Override
                            public void applyEndEffects() {
                                if (applyExtraEffects) {
                                    Main.sex.stopAllOngoingActions((GameCharacter)Main.game.getPlayer(), Main.game.getNpc(Lyssieth.class));
                                }
                            }
                        };
                    }
                    if (Main.sex.getOngoingSexAreas(this, SexAreaOrifice.ANUS, Main.game.getNpc(Lyssieth.class)).contains(SexAreaPenetration.PENIS)) {
                        if (Main.game.getPlayer().hasPenis() && Main.game.getPlayer().getPenisType().getRace() == Race.DEMON && Main.game.getPlayer().getPenisRawSizeValue() <= 4) {
                            sb.append(UtilText.parseFromXMLFile("characters/submission/lyssieth", "DEMON_TF_STAGE_2_PC_ASS_FUCKED_BY_LYSSIETH_END_SISSY"));
                        } else {
                            sb.append(UtilText.parseFromXMLFile("characters/submission/lyssieth", "DEMON_TF_STAGE_2_PC_ASS_FUCKED_BY_LYSSIETH_END"));
                        }
                        return new SexActionOrgasmOverride(false){

                            @Override
                            public String getDescription() {
                                return sb.toString();
                            }

                            @Override
                            public void applyEffects() {
                            }

                            @Override
                            public void applyEndEffects() {
                                if (applyExtraEffects) {
                                    Main.sex.stopAllOngoingActions((GameCharacter)Main.game.getPlayer(), Main.game.getNpc(Lyssieth.class));
                                }
                            }
                        };
                    }
                    if (Main.sex.getOngoingSexAreas(this, SexAreaPenetration.PENIS, Main.game.getNpc(Lyssieth.class)).contains(SexAreaOrifice.VAGINA)) {
                        sb.append(UtilText.parseFromXMLFile("characters/submission/lyssieth", "DEMON_TF_STAGE_2_PC_FUCKING_LYSSIETH_END"));
                        return new SexActionOrgasmOverride(false){

                            @Override
                            public String getDescription() {
                                return sb.toString();
                            }

                            @Override
                            public void applyEffects() {
                            }

                            @Override
                            public void applyEndEffects() {
                                if (applyExtraEffects) {
                                    Main.sex.stopAllOngoingActions((GameCharacter)Main.game.getPlayer(), Main.game.getNpc(Lyssieth.class));
                                }
                            }
                        };
                    }
                    if (Main.sex.getOngoingSexAreas(this, SexAreaPenetration.CLIT, Main.game.getNpc(Lyssieth.class)).contains(SexAreaPenetration.CLIT)) {
                        if (Main.sex.getSexPositionSlot(this) == SexSlotLyingDown.SCISSORING) {
                            sb.append(UtilText.parseFromXMLFile("characters/submission/lyssieth", "DEMON_TF_STAGE_2_SCISSOR_PC_TOP_END"));
                        } else {
                            sb.append(UtilText.parseFromXMLFile("characters/submission/lyssieth", "DEMON_TF_STAGE_2_SCISSOR_PC_BOTTOM_END"));
                        }
                        return new SexActionOrgasmOverride(false){

                            @Override
                            public String getDescription() {
                                return sb.toString();
                            }

                            @Override
                            public void applyEffects() {
                            }

                            @Override
                            public void applyEndEffects() {
                                if (applyExtraEffects) {
                                    Main.sex.stopAllOngoingActions((GameCharacter)Main.game.getPlayer(), Main.game.getNpc(Lyssieth.class));
                                }
                            }
                        };
                    }
                } else if (Main.sex.getNumberOfOrgasms(Main.game.getNpc(Lyssieth.class)) == 3) {
                    if (Main.sex.getOngoingSexAreas(this, SexAreaPenetration.PENIS, Main.game.getNpc(Lyssieth.class)).contains(SexAreaOrifice.VAGINA)) {
                        if (Main.sex.getSexPositionSlot(Main.game.getPlayer()) == SexSlotLyingDown.MATING_PRESS) {
                            sb.append(UtilText.parseFromXMLFile("characters/submission/lyssieth", "DEMON_TF_FINAL_PC_BREEDING_LYSSIETH_END"));
                        } else {
                            sb.append(UtilText.parseFromXMLFile("characters/submission/lyssieth", "DEMON_TF_FINAL_PC_FUCKING_LYSSIETH_END"));
                        }
                        return new SexActionOrgasmOverride(true){

                            @Override
                            public String getDescription() {
                                return sb.toString();
                            }

                            @Override
                            public void applyEffects() {
                            }
                        };
                    }
                    if (Main.sex.getOngoingSexAreas(this, SexAreaOrifice.VAGINA, Main.game.getNpc(Lyssieth.class)).contains(SexAreaPenetration.PENIS)) {
                        sb.append(UtilText.parseFromXMLFile("characters/submission/lyssieth", "DEMON_TF_FINAL_PC_PUSSY_FUCKED_BY_LYSSIETH_END"));
                        return new SexActionOrgasmOverride(true){

                            @Override
                            public String getDescription() {
                                return sb.toString();
                            }

                            @Override
                            public void applyEffects() {
                            }
                        };
                    }
                    if (Main.sex.getOngoingSexAreas(this, SexAreaOrifice.ANUS, Main.game.getNpc(Lyssieth.class)).contains(SexAreaPenetration.PENIS)) {
                        sb.append(UtilText.parseFromXMLFile("characters/submission/lyssieth", "DEMON_TF_FINAL_PC_ASS_FUCKED_BY_LYSSIETH_END"));
                        return new SexActionOrgasmOverride(true){

                            @Override
                            public String getDescription() {
                                return sb.toString();
                            }

                            @Override
                            public void applyEffects() {
                            }
                        };
                    }
                    if (Main.sex.getOngoingSexAreas(this, SexAreaPenetration.PENIS, Main.game.getNpc(Lyssieth.class)).contains(SexAreaOrifice.MOUTH)) {
                        sb.append(UtilText.parseFromXMLFile("characters/submission/lyssieth", "DEMON_TF_FINAL_PC_GETTING_BLOWJOB_FROM_LYSSIETH_END"));
                        return new SexActionOrgasmOverride(true){

                            @Override
                            public String getDescription() {
                                return sb.toString();
                            }

                            @Override
                            public void applyEffects() {
                            }
                        };
                    }
                    if (Main.sex.getOngoingSexAreas(this, SexAreaPenetration.TONGUE, Main.game.getNpc(Lyssieth.class)).contains(SexAreaOrifice.VAGINA)) {
                        sb.append(UtilText.parseFromXMLFile("characters/submission/lyssieth", "DEMON_TF_FINAL_PC_GETTING_CUNNILINGUS_FROM_LYSSIETH_END"));
                        return new SexActionOrgasmOverride(true){

                            @Override
                            public String getDescription() {
                                return sb.toString();
                            }

                            @Override
                            public void applyEffects() {
                            }
                        };
                    }
                }
            }
        }
        return super.getSexActionOrgasmOverride(sexAction, target, applyExtraEffects, description);
    }

    public List<String> getFriendlyOccupants() {
        return this.friendlyOccupants;
    }

    public boolean addFriendlyOccupant(NPC npc) {
        npc.setHistory(Occupation.NPC_UNEMPLOYED);
        for (Occupation occ : Occupation.values()) {
            if (occ.isAvailableToPlayer() || !occ.isAvailable(this) || occ == Occupation.UNEMPLOYED || occ == Occupation.NPC_UNEMPLOYED || occ.isLowlife()) continue;
            npc.addDesiredJob(occ);
        }
        return this.friendlyOccupants.add(npc.getId());
    }

    public boolean removeFriendlyOccupant(GameCharacter occupant) {
        return this.friendlyOccupants.remove(occupant.getId());
    }

    public Set<AbstractWorldType> getWorldsVisited() {
        return this.worldsVisited;
    }

    public boolean isDiscoveredWorldMap() {
        return this.isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_2_D_MEETING_A_LILIN);
    }

    public void handleDemonicTransformationPerkEffects() {
        if (Main.game.getPlayer().hasPerkAnywhereInTree(Perk.POWER_OF_LIRECEA_1)) {
            Main.game.getPlayer().removeSpecialPerk(Perk.POWER_OF_LIRECEA_1);
            Main.game.getPlayer().addSpecialPerk(Perk.POWER_OF_LIRECEA_1_DEMON);
        }
        if (Main.game.getPlayer().hasPerkAnywhereInTree(Perk.POWER_OF_LOVIENNE_2)) {
            Main.game.getPlayer().removeSpecialPerk(Perk.POWER_OF_LOVIENNE_2);
            Main.game.getPlayer().addSpecialPerk(Perk.POWER_OF_LOVIENNE_2_DEMON);
        }
        if (Main.game.getPlayer().hasPerkAnywhereInTree(Perk.POWER_OF_LASIELLE_3)) {
            Main.game.getPlayer().removeSpecialPerk(Perk.POWER_OF_LASIELLE_3);
            Main.game.getPlayer().addSpecialPerk(Perk.POWER_OF_LASIELLE_3_DEMON);
        }
        if (Main.game.getPlayer().hasPerkAnywhereInTree(Perk.POWER_OF_LYSSIETH_4)) {
            Main.game.getPlayer().removeSpecialPerk(Perk.POWER_OF_LYSSIETH_4);
            Main.game.getPlayer().addSpecialPerk(Perk.POWER_OF_LYSSIETH_4_DEMON);
        }
        if (Main.game.getPlayer().hasPerkAnywhereInTree(Perk.POWER_OF_LUNETTE_5)) {
            Main.game.getPlayer().removeSpecialPerk(Perk.POWER_OF_LUNETTE_5);
            Main.game.getPlayer().addSpecialPerk(Perk.POWER_OF_LUNETTE_5_DEMON);
        }
        if (Main.game.getPlayer().hasPerkAnywhereInTree(Perk.POWER_OF_LYXIAS_6)) {
            Main.game.getPlayer().removeSpecialPerk(Perk.POWER_OF_LYXIAS_6);
            Main.game.getPlayer().addSpecialPerk(Perk.POWER_OF_LYXIAS_6_DEMON);
        }
        if (Main.game.getPlayer().hasPerkAnywhereInTree(Perk.POWER_OF_LISOPHIA_7)) {
            Main.game.getPlayer().removeSpecialPerk(Perk.POWER_OF_LISOPHIA_7);
            Main.game.getPlayer().addSpecialPerk(Perk.POWER_OF_LISOPHIA_7_DEMON);
        }
    }

    protected String losingPureVirginity(GameCharacter characterPenetrating, SexAreaPenetration penetrationType) {
        boolean immobile;
        UtilText.addSpecialParsingString(penetrationType.getName(characterPenetrating), true);
        if (characterPenetrating.isPlayer()) {
            return UtilText.parseFromXMLFile("characters/player/virginity", "VIRGINITY_LOSS_PURE_SELF", characterPenetrating);
        }
        boolean bl = immobile = Main.sex.getAllParticipants().contains(this) && Main.sex.isCharacterImmobilised(this) && (Main.sex.getImmobilisationTypes(this).containsKey((Object)ImmobilisationType.COMMAND) || Main.sex.getImmobilisationTypes(this).containsKey((Object)ImmobilisationType.SLEEP));
        if (immobile) {
            if (this.isAsleep()) {
                return UtilText.parseFromXMLFile("characters/player/virginity", "VIRGINITY_LOSS_PURE_SLEEPING", characterPenetrating);
            }
            return UtilText.parseFromXMLFile("characters/player/virginity", "VIRGINITY_LOSS_PURE_DOLL", characterPenetrating);
        }
        return UtilText.parseFromXMLFile("characters/player/virginity", "VIRGINITY_LOSS_PURE", characterPenetrating);
    }

    @Override
    protected String getAnalVirginityLossDescription(GameCharacter characterPenetrating, SexAreaPenetration penetration) {
        StringBuilder sb = new StringBuilder();
        UtilText.addSpecialParsingString(penetration.getName(characterPenetrating), true);
        if (characterPenetrating.isPlayer()) {
            sb.append(UtilText.parseFromXMLFile("characters/player/virginity", "VIRGINITY_LOSS_ANAL_SELF", characterPenetrating));
        } else {
            boolean immobile;
            boolean bl = immobile = Main.sex.getAllParticipants().contains(this) && Main.sex.isCharacterImmobilised(this) && (Main.sex.getImmobilisationTypes(this).containsKey((Object)ImmobilisationType.COMMAND) || Main.sex.getImmobilisationTypes(this).containsKey((Object)ImmobilisationType.SLEEP));
            if (characterPenetrating instanceof NPC && ((NPC)characterPenetrating).getSpecialPlayerVirginityLoss(characterPenetrating, penetration, this, SexAreaOrifice.ANUS) != null) {
                return ((NPC)characterPenetrating).getSpecialPlayerVirginityLoss(characterPenetrating, penetration, this, SexAreaOrifice.ANUS);
            }
            if (immobile) {
                if (this.isAsleep()) {
                    sb.append(UtilText.parseFromXMLFile("characters/player/virginity", "VIRGINITY_LOSS_ANAL_SLEEPING", characterPenetrating));
                } else {
                    sb.append(UtilText.parseFromXMLFile("characters/player/virginity", "VIRGINITY_LOSS_ANAL_DOLL", characterPenetrating));
                }
            } else {
                sb.append(UtilText.parseFromXMLFile("characters/player/virginity", "VIRGINITY_LOSS_ANAL", characterPenetrating));
            }
        }
        UtilText.addSpecialParsingString(String.valueOf(AbstractFetish.getExperienceGainFromTakingOtherVirginity(characterPenetrating)), true);
        sb.append(UtilText.parseFromXMLFile("characters/player/virginity", "VIRGINITY_LOSS_ANAL_ENDING", characterPenetrating));
        sb.append(this.getVirginityExperienceDescription(characterPenetrating));
        return UtilText.parse(characterPenetrating, sb.toString(), new ParserTag[0]);
    }

    @Override
    protected String getVaginaVirginityLossDescription(GameCharacter characterPenetrating, SexAreaPenetration penetration) {
        StringBuilder sb = new StringBuilder();
        String penetrationName = "";
        switch (penetration) {
            case CLIT: {
                penetrationName = "\u9634\u8482";
                break;
            }
            case PENIS: {
                penetrationName = "\u8089\u68d2";
                break;
            }
            case TAIL: {
                penetrationName = "\u5c3e\u5df4";
                break;
            }
            case TENTACLE: {
                penetrationName = "\u89e6\u624b";
                break;
            }
        }
        UtilText.addSpecialParsingString(penetrationName, true);
        if (characterPenetrating.isPlayer()) {
            sb.append(UtilText.parseFromXMLFile("characters/player/virginity", "VIRGINITY_LOSS_VAGINAL_SELF", characterPenetrating));
        } else {
            boolean immobile;
            boolean bl = immobile = Main.sex.getAllParticipants().contains(this) && Main.sex.isCharacterImmobilised(this) && Main.sex.isCharacterInanimateFromImmobilisation(this);
            if (characterPenetrating instanceof NPC && ((NPC)characterPenetrating).getSpecialPlayerVirginityLoss(characterPenetrating, penetration, this, SexAreaOrifice.VAGINA) != null) {
                sb.append(((NPC)characterPenetrating).getSpecialPlayerVirginityLoss(characterPenetrating, penetration, this, SexAreaOrifice.VAGINA));
            } else if (immobile) {
                if (this.isAsleep()) {
                    sb.append(UtilText.parseFromXMLFile("characters/player/virginity", "VIRGINITY_LOSS_VAGINAL_SLEEPING", characterPenetrating));
                } else {
                    sb.append(UtilText.parseFromXMLFile("characters/player/virginity", "VIRGINITY_LOSS_VAGINAL_DOLL", characterPenetrating));
                }
            } else {
                sb.append(UtilText.parseFromXMLFile("characters/player/virginity", "VIRGINITY_LOSS_VAGINAL", characterPenetrating));
            }
        }
        if (Main.game.getPlayer().hasFetish(Fetish.FETISH_PURE_VIRGIN)) {
            if (characterPenetrating instanceof NPC && ((NPC)characterPenetrating).getSpecialPlayerPureVirginityLoss(characterPenetrating, penetration) != null) {
                sb.append(((NPC)characterPenetrating).getSpecialPlayerPureVirginityLoss(characterPenetrating, penetration));
            } else {
                sb.append(this.losingPureVirginity(characterPenetrating, penetration));
            }
        }
        UtilText.addSpecialParsingString(String.valueOf(AbstractFetish.getExperienceGainFromTakingOtherVirginity(characterPenetrating)), true);
        sb.append(UtilText.parseFromXMLFile("characters/player/virginity", "VIRGINITY_LOSS_VAGINAL_ENDING", characterPenetrating));
        sb.append(this.getVirginityExperienceDescription(characterPenetrating));
        return UtilText.parse(characterPenetrating, sb.toString(), new ParserTag[0]);
    }

    @Override
    protected String getPenileVirginityLossDescription(GameCharacter characterPenetrated, SexAreaOrifice orifice) {
        if (characterPenetrated instanceof NPC && ((NPC)characterPenetrated).getSpecialPlayerVirginityLoss(this, SexAreaPenetration.PENIS, characterPenetrated, orifice) != null) {
            return ((NPC)characterPenetrated).getSpecialPlayerVirginityLoss(this, SexAreaPenetration.PENIS, characterPenetrated, orifice);
        }
        return UtilText.parse(characterPenetrated, this, (characterPenetrated.equals(this) ? UtilText.formatVirginityLoss("[npc2.Name]\u5df2\u7ecf\u593a\u8d70\u4e86[npc2.her]\u81ea\u5df1\u7684\u7ae5\u8d1e\uff01") : UtilText.formatVirginityLoss("[npc.Name]\u5df2\u7ecf\u593a\u8d70\u4e86[npc2.namePos]\u7684\u7ae5\u8d1e\uff01")) + this.getVirginityExperienceDescription(characterPenetrated), new ParserTag[0]);
    }

    @Override
    protected String getNippleVirginityLossDescription(GameCharacter characterPenetrating, SexAreaPenetration penetration) {
        if (characterPenetrating instanceof NPC && ((NPC)characterPenetrating).getSpecialPlayerVirginityLoss(characterPenetrating, penetration, this, SexAreaOrifice.NIPPLE) != null) {
            return ((NPC)characterPenetrating).getSpecialPlayerVirginityLoss(characterPenetrating, penetration, this, SexAreaOrifice.NIPPLE);
        }
        return UtilText.parse((GameCharacter)this, characterPenetrating, (this.equals(characterPenetrating) ? UtilText.formatVirginityLoss("[npc2.Name]\u5df2\u7ecf\u593a\u8d70\u4e86[npc2.her]\u81ea\u5df1\u7684\u4e73\u5934\u8d1e\u64cd\uff01") : UtilText.formatVirginityLoss("[npc2.Name]\u5df2\u7ecf\u593a\u8d70\u4e86[npc.namePos]\u7684\u4e73\u5934\u8d1e\u64cd\uff01")) + this.getVirginityExperienceDescription(characterPenetrating), new ParserTag[0]);
    }

    @Override
    protected String getNippleCrotchVirginityLossDescription(GameCharacter characterPenetrating, SexAreaPenetration penetration) {
        if (characterPenetrating instanceof NPC && ((NPC)characterPenetrating).getSpecialPlayerVirginityLoss(characterPenetrating, penetration, this, SexAreaOrifice.NIPPLE_CROTCH) != null) {
            return ((NPC)characterPenetrating).getSpecialPlayerVirginityLoss(characterPenetrating, penetration, this, SexAreaOrifice.NIPPLE_CROTCH);
        }
        return UtilText.parse((GameCharacter)this, characterPenetrating, (this.equals(characterPenetrating) ? UtilText.formatVirginityLoss("[npc2.Name]\u5df2\u7ecf\u593a\u8d70\u4e86[npc2.her]\u81ea\u5df1\u7684[npc2.crotchNipple]\u8d1e\u64cd\uff01") : UtilText.formatVirginityLoss("[npc2.Name]\u5df2\u7ecf\u593a\u8d70\u4e86[npc.namePos]\u7684[npc.crotchNipple]\u8d1e\u64cd\uff01")) + this.getVirginityExperienceDescription(characterPenetrating), new ParserTag[0]);
    }

    @Override
    protected String getUrethraVirginityLossDescription(GameCharacter characterPenetrating, SexAreaPenetration penetration) {
        if (characterPenetrating instanceof NPC && ((NPC)characterPenetrating).getSpecialPlayerVirginityLoss(characterPenetrating, penetration, this, SexAreaOrifice.URETHRA_PENIS) != null) {
            return ((NPC)characterPenetrating).getSpecialPlayerVirginityLoss(characterPenetrating, penetration, this, SexAreaOrifice.URETHRA_PENIS);
        }
        return UtilText.parse((GameCharacter)this, characterPenetrating, (this.equals(characterPenetrating) ? UtilText.formatVirginityLoss("[npc2.Name]\u5df2\u7ecf\u593a\u8d70\u4e86[npc2.her]\u81ea\u5df1\u7684\u5c3f\u9053\u8d1e\u6d01\uff01") : UtilText.formatVirginityLoss("[npc2.Name]\u5df2\u7ecf\u593a\u8d70\u4e86[npc.namePos]\u7684\u5c3f\u9053\u8d1e\u64cd\uff01")) + this.getVirginityExperienceDescription(characterPenetrating), new ParserTag[0]);
    }

    @Override
    protected String getVaginalUrethraVirginityLossDescription(GameCharacter characterPenetrating, SexAreaPenetration penetration) {
        if (characterPenetrating instanceof NPC && ((NPC)characterPenetrating).getSpecialPlayerVirginityLoss(characterPenetrating, penetration, this, SexAreaOrifice.URETHRA_VAGINA) != null) {
            return ((NPC)characterPenetrating).getSpecialPlayerVirginityLoss(characterPenetrating, penetration, this, SexAreaOrifice.URETHRA_VAGINA);
        }
        return UtilText.parse((GameCharacter)this, characterPenetrating, (this.equals(characterPenetrating) ? UtilText.formatVirginityLoss("[npc2.Name]\u5df2\u7ecf\u593a\u8d70\u4e86[npc2.her]\u81ea\u5df1\u7684\u5c3f\u9053\u8d1e\u6d01\uff01") : UtilText.formatVirginityLoss("[npc2.Name]\u5df2\u7ecf\u593a\u8d70\u4e86[npc.namePos]\u7684\u5c3f\u9053\u8d1e\u64cd\uff01")) + this.getVirginityExperienceDescription(characterPenetrating), new ParserTag[0]);
    }

    @Override
    protected String getMouthVirginityLossDescription(GameCharacter characterPenetrating, SexAreaPenetration penetration) {
        if (characterPenetrating instanceof NPC && ((NPC)characterPenetrating).getSpecialPlayerVirginityLoss(characterPenetrating, penetration, this, SexAreaOrifice.MOUTH) != null) {
            return ((NPC)characterPenetrating).getSpecialPlayerVirginityLoss(characterPenetrating, penetration, this, SexAreaOrifice.MOUTH);
        }
        return UtilText.parse((GameCharacter)this, characterPenetrating, (this.equals(characterPenetrating) ? UtilText.formatVirginityLoss("[npc2.Name]\u628a\u53e3\u90e8\u8d1e\u64cd\u732e\u7ed9\u4e86[npc.her]\u81ea\u5df1\uff01") : UtilText.formatVirginityLoss("[npc2.Name]\u8ba9[npc.name]\u4f53\u9a8c\u5230\u7b2c\u4e00\u6b21\u7528\u5634\u4e86\uff01")) + this.getVirginityExperienceDescription(characterPenetrating), new ParserTag[0]);
    }
}

