/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.attributes;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public abstract class AbstractAttribute
implements Comparable<AbstractAttribute> {
    private boolean percentage;
    private int baseValue;
    private int lowerLimit;
    private int upperLimit;
    private String name;
    private String nameAbbreviation;
    private String positiveEnchantment;
    private String negativeEnchantment;
    private Colour colour;
    private List<String> extraEffects;
    private String SVGString;

    public AbstractAttribute(boolean percentage, int baseValue, int lowerLimit, int upperLimit, String name, String nameAbbreviation, String pathName, Colour colour, String positiveEnchantment, String negativeEnchantment, List<String> extraEffects) {
        this.percentage = percentage;
        this.baseValue = baseValue;
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.name = name;
        this.nameAbbreviation = nameAbbreviation;
        this.colour = colour;
        this.positiveEnchantment = positiveEnchantment;
        this.negativeEnchantment = negativeEnchantment;
        this.extraEffects = extraEffects;
        try {
            InputStream is = this.getClass().getResourceAsStream("/com/lilithsthrone/res/UIElements/" + pathName + ".svg");
            if (is == null) {
                System.err.println("Error! Attribute icon file does not exist (Trying to read from '" + pathName + "')!");
            }
            this.SVGString = Util.inputStreamToString(is);
            this.SVGString = SvgUtil.colourReplacement("att_" + name.replaceAll("\\s", ""), colour, this.SVGString);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        System.err.println("Warning: AbstractAttribute's toString() method is being called!");
        return Attribute.getIdFromAttribute(this);
    }

    @Override
    public int compareTo(AbstractAttribute other) {
        return this.getOrderPriority() - other.getOrderPriority();
    }

    public abstract int getOrderPriority();

    public boolean hasStatusEffect() {
        return false;
    }

    public boolean isPercentage() {
        return this.percentage;
    }

    public int getBaseValue() {
        return this.baseValue;
    }

    public int getLowerLimit() {
        return this.lowerLimit;
    }

    public int getUpperLimit() {
        return this.upperLimit;
    }

    public boolean isInfiniteAtUpperLimit() {
        return false;
    }

    public String getInfiniteDescription() {
        return "";
    }

    public String getName() {
        return this.nameAbbreviation;
    }

    public String getColouredName(String tag) {
        return "<" + tag + " style='color:" + this.getColour().toWebHexString() + ";'>" + this.nameAbbreviation + "</" + tag + ">";
    }

    public String getFormattedValue(float value) {
        return this.getFormattedValue(value, null);
    }

    public String getFormattedValue(float value, String htmlTag) {
        Object valueForDisplay = (float)((int)value) == value ? String.valueOf((int)value) : String.valueOf(value);
        Object returnValue = "";
        if (this.isInfiniteAtUpperLimit() && value >= (float)this.getUpperLimit()) {
            returnValue = !this.getInfiniteDescription().isEmpty() ? this.getInfiniteDescription() : "[style.colourExcellent(\u65e0\u9650)]<span style='color: " + this.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(this.getAbbreviatedName()) + "</span>";
        } else {
            String minorColour = "";
            if (this.isPercentage()) {
                minorColour = "Minor";
                valueForDisplay = (String)valueForDisplay + "%";
            }
            returnValue = (value > 0.0f ? "[style.colour" + minorColour + "Good(+" : "[style.colour" + minorColour + "Bad(") + (String)valueForDisplay + ")]<span style='color:" + this.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(this.getAbbreviatedName()) + "</span>";
        }
        if (htmlTag != null) {
            return "<" + htmlTag + ">" + (String)returnValue + "</" + htmlTag + ">";
        }
        return returnValue;
    }

    public String getAbbreviatedName() {
        return this.nameAbbreviation;
    }

    public abstract String getDescription(GameCharacter var1);

    public Colour getColour() {
        return this.colour;
    }

    public String getEffectsAsStringList() {
        StringBuilder descriptionSB = new StringBuilder();
        if (this.extraEffects != null) {
            for (String s : this.extraEffects) {
                descriptionSB.append("<br/>" + s);
            }
        }
        return descriptionSB.toString();
    }

    public String getPositiveEnchantment() {
        return this.positiveEnchantment;
    }

    public String getNegativeEnchantment() {
        return this.negativeEnchantment;
    }

    public boolean isAffectedByEnchantmentCost() {
        return true;
    }

    public String getSVGString() {
        return this.SVGString;
    }
}

