/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.attributes;

import com.lilithsthrone.game.PropertyValue;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AffectionLevel;
import com.lilithsthrone.game.character.effects.AbstractStatusEffect;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.fetishes.FetishDesire;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCFlagValue;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.sex.SexPace;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.ArrayList;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum LustLevel {
    ZERO_COLD("\u6de1\u7136", 0, 10, 0.5f, PresetColour.LUST_STAGE_ZERO, SexPace.SUB_RESISTING, SexPace.DOM_GENTLE){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.LUST_PERK_0;
        }
    }
    ,
    ONE_HORNY("\u71e5\u52a8", 10, 25, 0.75f, PresetColour.LUST_STAGE_ONE, SexPace.SUB_NORMAL, SexPace.DOM_NORMAL){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.LUST_PERK_1;
        }
    }
    ,
    TWO_AMOROUS("\u6109\u60a6", 25, 50, 1.0f, PresetColour.LUST_STAGE_TWO, SexPace.SUB_NORMAL, SexPace.DOM_NORMAL){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.LUST_PERK_2;
        }
    }
    ,
    THREE_LUSTFUL("\u70ed\u5207", 50, 75, 1.25f, PresetColour.LUST_STAGE_THREE, SexPace.SUB_NORMAL, SexPace.DOM_NORMAL){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.LUST_PERK_3;
        }
    }
    ,
    FOUR_IMPASSIONED("\u9965\u6e34", 75, 90, 1.5f, PresetColour.LUST_STAGE_FOUR, SexPace.SUB_EAGER, SexPace.DOM_ROUGH){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.LUST_PERK_4;
        }
    }
    ,
    FIVE_BURNING("\u4ea2\u594b", 90, 100, 1.5f, PresetColour.LUST_STAGE_FIVE, SexPace.SUB_EAGER, SexPace.DOM_ROUGH){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.LUST_PERK_5;
        }
    };

    private String name;
    private int minimumValue;
    private int maximumValue;
    private float arousalModifier;
    private Colour colour;
    private SexPace sexPaceSubmissive;
    private SexPace sexPaceDominant;

    private LustLevel(String name, int minimumValue, int maximumValue, float arousalModifier, Colour colour, SexPace sexPaceSubmissive, SexPace sexPaceDominant) {
        this.name = name;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.arousalModifier = arousalModifier;
        this.colour = colour;
        this.sexPaceSubmissive = sexPaceSubmissive;
        this.sexPaceDominant = sexPaceDominant;
    }

    public abstract AbstractStatusEffect getRelatedStatusEffect();

    public String getName() {
        return this.name;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getMedianValue() {
        return (this.minimumValue + this.maximumValue) / 2;
    }

    public float getArousalModifier() {
        return this.arousalModifier;
    }

    public Colour getColour() {
        return this.colour;
    }

    public static LustLevel getLustLevelFromValue(float value) {
        if (value < 0.0f) {
            return ZERO_COLD;
        }
        for (LustLevel al : LustLevel.values()) {
            if (!(value >= (float)al.getMinimumValue()) || !(value < (float)al.getMaximumValue())) continue;
            return al;
        }
        return FIVE_BURNING;
    }

    public SexPace getSexPaceSubmissive() {
        return this.sexPaceSubmissive;
    }

    public SexPace getSexPaceDominant() {
        return this.sexPaceDominant;
    }

    public boolean isResistingFromRapePlay(GameCharacter character) {
        return !Main.sex.isDom(character) && character.hasFetish(Fetish.FETISH_NON_CON_SUB) && !Main.sex.isCharacterBannedFromRapePlay(character) && (!(character instanceof NPC) || !((NPC)character).hasFlag(NPCFlagValue.genericNPCBetrayedByPlayer) || character.isSlave() || Main.game.getPlayer().getFriendlyOccupants().contains(character.getId())) && this.getSexPaceSubmissive() != SexPace.SUB_RESISTING;
    }

    public SexPace getSexPace(boolean consensual, GameCharacter character) {
        SexPace pace;
        if (Main.sex.isDom(character)) {
            pace = this.getSexPaceDominant();
            if (character.hasFetish(Fetish.FETISH_SUBMISSIVE) && !character.hasFetish(Fetish.FETISH_SADIST) && !character.hasFetish(Fetish.FETISH_DOMINANT) || character.getFetishDesire(Fetish.FETISH_SADIST) == FetishDesire.ZERO_HATE) {
                pace = SexPace.DOM_GENTLE;
            } else if (character.getFetishDesire(Fetish.FETISH_SADIST).isNegative()) {
                pace = SexPace.DOM_NORMAL;
            } else {
                if (character.hasFetish(Fetish.FETISH_SADIST)) {
                    return SexPace.DOM_ROUGH;
                }
                for (GameCharacter target : Main.sex.getAllParticipants()) {
                    if (Main.sex.isDom(target) || !(character.getAffection(target) < (float)AffectionLevel.NEGATIVE_TWO_DISLIKE.getMaximumValue())) continue;
                    return SexPace.DOM_ROUGH;
                }
            }
        } else {
            pace = this.getSexPaceSubmissive();
            if (character.hasFetish(Fetish.FETISH_NON_CON_SUB) && !Main.sex.isCharacterBannedFromRapePlay(character) || character instanceof NPC && ((NPC)character).hasFlag(NPCFlagValue.genericNPCBetrayedByPlayer) && !character.isSlave() && !Main.game.getPlayer().getFriendlyOccupants().contains(character.getId())) {
                pace = SexPace.SUB_RESISTING;
            }
        }
        if (pace == SexPace.SUB_RESISTING && !Main.getProperties().hasValue(PropertyValue.nonConContent)) {
            pace = SexPace.SUB_NORMAL;
        }
        if (pace == SexPace.DOM_ROUGH && (!character.hasFetish(Fetish.FETISH_DOMINANT) && !character.hasFetish(Fetish.FETISH_SADIST) && !character.hasFetish(Fetish.FETISH_NON_CON_DOM) || character.getFetishDesire(Fetish.FETISH_SADIST).isNegative())) {
            pace = SexPace.DOM_NORMAL;
        }
        return pace;
    }

    public List<String> getStatusEffectModifierDescription(boolean consensual, GameCharacter character) {
        ArrayList<String> modifiersList = new ArrayList<String>();
        Colour levelColour = LustLevel.getLustLevelFromValue(character.getRestingLust()).getColour();
        modifiersList.add("\u65e5\u5e38\u6027\u6b32:<b style='color:" + levelColour.toWebHexString() + ";'>" + character.getRestingLust() + "</b>");
        if (Main.game.isInSex()) {
            switch (this.getSexPace(consensual, character)) {
                case DOM_GENTLE: {
                    if (character.isPlayer()) break;
                    modifiersList.add("\u504f\u7231<b style='color: " + SexPace.DOM_GENTLE.getColour().toWebHexString() + "'>\u7f13\u548c</b>\u7684\u72b6\u6001");
                    break;
                }
                case DOM_NORMAL: {
                    if (character.isPlayer()) break;
                    modifiersList.add("\u504f\u7231<b style='color: " + SexPace.DOM_NORMAL.getColour().toWebHexString() + "'>\u6b63\u5e38</b>\u7684\u72b6\u6001");
                    break;
                }
                case DOM_ROUGH: {
                    if (character.isPlayer()) break;
                    if (!character.hasFetish(Fetish.FETISH_DOMINANT) && !character.hasFetish(Fetish.FETISH_SADIST)) {
                        modifiersList.add("\u504f\u7231<b style='color: " + SexPace.DOM_NORMAL.getColour().toWebHexString() + "'>\u6b63\u5e38</b>\u7684\u72b6\u6001");
                        modifiersList.add("(<b style='color: " + SexPace.DOM_ROUGH.getColour().toWebHexString() + "'>\u7c97\u66b4</b>\u7684\u72b6\u6001\u9700\u8981" + Fetish.FETISH_DOMINANT.getName(character) + "\u3001" + Fetish.FETISH_NON_CON_DOM.getName(character) + "\u6216" + Fetish.FETISH_SADIST.getName(character) + "\u6027\u7656)");
                        break;
                    }
                    modifiersList.add("\u504f\u7231<b style='color: " + SexPace.DOM_ROUGH.getColour().toWebHexString() + "'>\u7c97\u66b4</b>\u7684\u72b6\u6001");
                    break;
                }
                case SUB_EAGER: {
                    if (character.isPlayer()) break;
                    modifiersList.add("\u504f\u7231<b style='color: " + SexPace.SUB_EAGER.getColour().toWebHexString() + "'>\u6025\u5207</b>\u7684\u72b6\u6001");
                    break;
                }
                case SUB_NORMAL: {
                    if (character.isPlayer()) break;
                    modifiersList.add("\u504f\u7231<b style='color: " + SexPace.SUB_NORMAL.getColour().toWebHexString() + "'>\u6b63\u5e38</b>\u7684\u72b6\u6001");
                    break;
                }
                case SUB_RESISTING: {
                    if (character.isPlayer()) break;
                    if (character.hasFetish(Fetish.FETISH_NON_CON_SUB)) {
                        modifiersList.add("\u603b\u662f\u504f\u7231<b style='color: " + SexPace.SUB_RESISTING.getColour().toWebHexString() + "'>\u62b5\u6297</b>\u7684\u72b6\u6001\uff0c\u539f\u56e0\u662f\u62e5\u6709" + Fetish.FETISH_NON_CON_SUB.getName(character) + "\u6027\u7656");
                        break;
                    }
                    modifiersList.add("\u504f\u7231<b style='color: " + SexPace.SUB_RESISTING.getColour().toWebHexString() + "'>\u62b5\u6297</b>\u7684\u72b6\u6001");
                }
            }
            int gains = (int)(this.getArousalModifier() * 100.0f);
            modifiersList.add((gains >= 100 ? "[style.boldArousal(" + gains + "%)]" : "[style.boldBad(" + gains + "%)]") + "\u5feb\u611f\u83b7\u53d6");
        }
        return modifiersList;
    }

    public String getStatusEffectDescription(boolean consensual, GameCharacter character) {
        StringBuilder sb = new StringBuilder();
        if (Main.game.isInSex()) {
            block0 : switch (this.getSexPace(consensual, character)) {
                case DOM_GENTLE: {
                    switch (this) {
                        case ZERO_COLD: {
                            sb.append("[npc.NameIsFull]\u73b0\u5728\u771f\u7684\u6ca1\u4ec0\u4e48\u6027\u8da3\uff0c\u4f5c\u4e3a\u56de\u5e94\uff0c[npc.she]\u671f\u671b\u53ef\u4ee5\u6162\u6162\u6765\u3002");
                            break block0;
                        }
                        case ONE_HORNY: {
                            sb.append("[npc.NameIsFull]\u5df2\u7ecf\u71e5\u52a8\u4e86\u8d77\u6765\uff0c\u4f46\u4f9d\u65e7\u80fd\u63a7\u5236\u4f4f\u6b32\u671b\uff0c\u4fdd\u6709\u6e05\u9192\u7684\u5934\u8111\uff0c\u8ba9\u6027\u4e8b\u4ee5\u8212\u7f13\u6e29\u67d4\u7684\u8282\u594f\u7ee7\u7eed\u4e0b\u53bb\u3002");
                            break block0;
                        }
                        case TWO_AMOROUS: {
                            sb.append("[npc.NameIsFull]\u73b0\u5728\u611f\u53d7\u5230\u7684\u53ef\u4e0d\u6b62\u662f\u8e81\u52a8\uff0c\u4f46\u4f9d\u65e7\u80fd\u63a7\u5236\u4f4f\u6b32\u671b\uff0c\u8ba9\u6027\u4e8b\u4ee5\u8212\u7f13\u6e29\u67d4\u7684\u8282\u594f\u7ee7\u7eed\u4e0b\u53bb\u3002");
                            break block0;
                        }
                        case THREE_LUSTFUL: {
                            sb.append("[npc.NameIsFull]\u906d\u53d7\u7740\u6b32\u706b\u7684\u7099\u70e4\uff0c\u4f46\u4f9d\u65e7\u80fd\u8ba9\u6027\u4e8b\u4ee5\u8212\u7f13\u6e29\u67d4\u7684\u8282\u594f\u7ee7\u7eed\u4e0b\u53bb\u3002");
                            break block0;
                        }
                        case FOUR_IMPASSIONED: {
                            sb.append("[npc.NameIsFull]\u73b0\u4eca\u5df2\u7ecf\u6b32\u706b\u4e2d\u70e7\uff0c\u4f46\u4f9d\u65e7\u80fd\u8ba9\u6027\u4e8b\u4ee5\u8212\u7f13\u6e29\u67d4\u7684\u8282\u594f\u7ee7\u7eed\u4e0b\u53bb\u3002");
                            break block0;
                        }
                        case FIVE_BURNING: {
                            sb.append("[npc.NameIsFull]\u5168\u8eab\u5fc3\u6df9\u6ca1\u5728\u6b32\u671b\u5f53\u4e2d\uff0c\u4f46\u4e0d\u77e5\u4e3a\u4f55\uff0c\u4f9d\u65e7\u80fd\u8ba9\u6027\u4e8b\u4ee5\u8212\u7f13\u6e29\u67d4\u7684\u8282\u594f\u7ee7\u7eed\u4e0b\u53bb\u3002");
                        }
                    }
                    break;
                }
                case DOM_NORMAL: 
                case SUB_NORMAL: {
                    switch (this) {
                        case ZERO_COLD: {
                            sb.append("\u867d\u7136[npc.nameIsFull]\u73b0\u5728\u6beb\u65e0\u6027\u8da3\uff0c\u4f46\u4ecd\u80fd\u5f3a\u8feb\u81ea\u5df1\u8868\u73b0\u5f97\u5f88\u9965\u6e34\u3002");
                            break block0;
                        }
                        case ONE_HORNY: {
                            sb.append("[npc.NameIsFull]\u5df2\u7ecf\u71e5\u52a8\u4e86\u8d77\u6765\uff0c\u4e14\u5f88\u4e50\u610f\u4eab\u53d7\u6027\u8da3\u3002");
                            break block0;
                        }
                        case TWO_AMOROUS: {
                            sb.append("[npc.NameIsFull]\u73b0\u5728\u611f\u53d7\u5230\u7684\u53ef\u4e0d\u6b62\u8e81\u52a8\uff0c\u4e14\u5f88\u4e50\u610f\u4eab\u53d7\u6027\u8da3\u3002");
                            break block0;
                        }
                        case THREE_LUSTFUL: {
                            sb.append("[npc.NameIsFull]\u906d\u53d7\u7740\u6b32\u706b\u7684\u7099\u70e4\uff0c\u7b49\u4e0d\u53ca\u8981\u4eab\u53d7\u6027\u4e8b\u4e86\u3002");
                            break block0;
                        }
                        case FOUR_IMPASSIONED: {
                            sb.append("[npc.NameIsFull]\u73b0\u4eca\u5df2\u7ecf\u6b32\u706b\u4e2d\u70e7\uff0c\u4f46\u8fd8\u80fd\u62c9\u5f97\u4f4f\u6b32\u671b\u7684\u7f30\u7ef3\uff0c\u9632\u6b62\u81ea\u5df1\u592a\u8fc7\u6c89\u6d78\u3002");
                            break block0;
                        }
                        case FIVE_BURNING: {
                            sb.append("[npc.NameIsFull]\u5168\u8eab\u5fc3\u6df9\u6ca1\u5728\u6b32\u671b\u5f53\u4e2d\uff0c\u4f46\u4e0d\u77e5\u4e3a\u4f55\uff0c\u8fd8\u80fd\u62c9\u5f97\u4f4f\u6b32\u671b\u7684\u7f30\u7ef3\uff0c\u9632\u6b62\u81ea\u5df1\u592a\u8fc7\u6c89\u6d78\u3002");
                        }
                    }
                    break;
                }
                case DOM_ROUGH: 
                case SUB_EAGER: {
                    switch (this) {
                        case ZERO_COLD: {
                            sb.append("\u867d\u7136[npc.nameIsFull]\u73b0\u5728\u6ca1\u4ec0\u4e48\u6027\u8da3\uff0c\u4f46\u4f9d\u65e7\u5f3a\u8feb\u81ea\u5df1\u8868\u73b0\u5f97\u50cf\u662f\u6b32\u706b\u4e2d\u70e7\u3002");
                            break block0;
                        }
                        case ONE_HORNY: {
                            sb.append("[npc.NameIsFull]\u5df2\u7ecf\u71e5\u52a8\u4e86\u8d77\u6765\uff0c\u4e14\u5f88\u4e50\u610f\u4eab\u53d7\u6027\u8da3\u3002");
                            break block0;
                        }
                        case TWO_AMOROUS: {
                            sb.append("[npc.NameIsFull]\u73b0\u5728\u611f\u53d7\u5230\u7684\u53ef\u4e0d\u6b62\u8e81\u52a8\uff0c\u4e14\u5f88\u4e50\u610f\u4eab\u53d7\u6027\u8da3\u3002");
                            break block0;
                        }
                        case THREE_LUSTFUL: {
                            sb.append("[npc.NameIsFull]\u906d\u53d7\u7740\u6b32\u706b\u7684\u7099\u70e4\uff0c\u7b49\u4e0d\u53ca\u8981\u4eab\u53d7\u6027\u4e8b\u4e86\u3002");
                            break block0;
                        }
                        case FOUR_IMPASSIONED: {
                            sb.append("[npc.NameIsFull]\u73b0\u4eca\u5df2\u7ecf\u6b32\u706b\u4e2d\u70e7\uff0c\u8d8a\u53d1\u6c89\u6d78\u4e8e\u6027\u4e8b\u5f53\u4e2d\u3002");
                            break block0;
                        }
                        case FIVE_BURNING: {
                            sb.append("[npc.NameIsFull]\u5168\u8eab\u5fc3\u6df9\u6ca1\u5728\u6b32\u671b\u5f53\u4e2d\uff0c\u5f7b\u5e95\u8ff7\u5931\u5728\u6027\u4e8b\u5e26\u6765\u7684\u5feb\u4e50\u91cc\u3002");
                        }
                    }
                    break;
                }
                case SUB_RESISTING: {
                    switch (this) {
                        case ZERO_COLD: {
                            sb.append("[npc.NameIsFull]\u73b0\u5728\u6ca1\u4ec0\u4e48\u6027\u8da3\uff0c\u4e14\u62fc\u547d\u6297\u62d2\u7740\u6b63\u53d1\u751f\u5728[npc.herHim]\u8eab\u4e0a\u7684\u4e8b\u60c5\u3002");
                            break block0;
                        }
                        case ONE_HORNY: {
                            sb.append("[npc.NameIsFull]\u5df2\u7ecf\u71e5\u52a8\u4e86\u8d77\u6765\uff0c\u4f46\u9664\u6b64\u5916\uff0c[npc.sheIs]\u5bf9\u73b0\u72b6\u5e76\u4e0d\u600e\u4e48\u9ad8\u5174\uff0c\u62fc\u547d\u5730\u6297\u62d2\u7740\u6027\u4e8b\u3002");
                            break block0;
                        }
                        case TWO_AMOROUS: {
                            sb.append("[npc.NameIsFull]\u73b0\u5728\u611f\u53d7\u5230\u7684\u53ef\u4e0d\u6b62\u8e81\u52a8\uff0c\u4f46\u9664\u6b64\u5916\uff0c[npc.sheIs]\u5bf9\u73b0\u72b6\u5e76\u4e0d\u600e\u4e48\u9ad8\u5174\uff0c\u62fc\u547d\u5730\u6297\u62d2\u7740\u6027\u4e8b\u3002");
                            break block0;
                        }
                        case THREE_LUSTFUL: {
                            sb.append("[npc.NameIsFull]\u906d\u53d7\u7740\u6b32\u706b\u7684\u7099\u70e4\uff0c\u4f46\u9664\u6b64\u5916\uff0c[npc.sheIs]\u5bf9\u73b0\u72b6\u5e76\u4e0d\u600e\u4e48\u9ad8\u5174\uff0c\u62fc\u547d\u5730\u6297\u62d2\u7740\u6027\u4e8b\u3002");
                            break block0;
                        }
                        case FOUR_IMPASSIONED: {
                            sb.append("[npc.NameIsFull]\u73b0\u4eca\u5df2\u7ecf\u6b32\u706b\u4e2d\u70e7\uff0c\u4f46\u9664\u6b64\u5916\uff0c[npc.sheIs]\u5bf9\u73b0\u72b6\u5e76\u4e0d\u600e\u4e48\u9ad8\u5174\uff0c\u62fc\u547d\u5730\u6297\u62d2\u7740\u6027\u4e8b\u3002");
                            break block0;
                        }
                        case FIVE_BURNING: {
                            sb.append("[npc.NameIsFull]\u5168\u8eab\u5fc3\u6df9\u6ca1\u5728\u6b32\u671b\u5f53\u4e2d\uff0c\u4f46\u9664\u6b64\u5916\uff0c[npc.sheIs]\u5bf9\u73b0\u72b6\u5e76\u4e0d\u600e\u4e48\u9ad8\u5174\uff0c\u62fc\u547d\u5730\u6297\u62d2\u7740\u6027\u4e8b\u3002");
                        }
                    }
                }
            }
        } else {
            switch (this) {
                case ZERO_COLD: {
                    sb.append("[npc.NameIsFull]\u73b0\u5728\u771f\u7684\u6ca1\u4ec0\u4e48\u6027\u8da3\u3002");
                    break;
                }
                case ONE_HORNY: {
                    sb.append("[npc.NameIsFull]\u5df2\u7ecf\u71e5\u52a8\u4e86\u8d77\u6765\uff0c\u4f46\u8fd8\u80fd\u63a7\u5236\u5f97\u4f4f\u6b32\u671b\u3002");
                    if (!Main.game.isOpportunisticAttackersEnabled() || !character.isPlayer()) break;
                    sb.append("<br><b style='color:" + PresetColour.BASE_GREY.toWebHexString() + ";'>\u6295\u673a\u88ad\u51fb\u8005</b><br>\u4f60\u4f3c\u4e4e\u6b63\u5728\u5438\u5f15\u7740\u9ebb\u70e6\u7684\u5230\u6765\u3002");
                    break;
                }
                case TWO_AMOROUS: {
                    sb.append("[npc.NameIsFull]\u73b0\u5728\u611f\u53d7\u5230\u7684\u53ef\u4e0d\u6b62\u8e81\u52a8\uff0c\u5f00\u59cb\u66f4\u9891\u7e41\u5730\u53bb\u60f3\u60c5\u4e8b\u3002");
                    if (!Main.game.isOpportunisticAttackersEnabled() || !character.isPlayer()) break;
                    sb.append("<br><b style='color:" + PresetColour.BASE_GREY.toWebHexString() + ";'>\u6295\u673a\u88ad\u51fb\u8005</b><br>\u4f60\u80fd\u611f\u53d7\u5230\u5f15\u6765\u9ebb\u70e6\u7684\u76ee\u5149\u6b63\u53d8\u5f97\u8d8a\u6765\u8d8a\u591a\u3002");
                    break;
                }
                case THREE_LUSTFUL: {
                    sb.append("[npc.NameIsFull]\u906d\u53d7\u7740\u6b32\u706b\u7684\u7099\u70e4\uff0c\u5f88\u96be\u518d\u53bb\u60f3\u6027\u4ee5\u5916\u7684\u4e8b\u60c5\u3002");
                    if (!Main.game.isOpportunisticAttackersEnabled() || !character.isPlayer()) break;
                    sb.append("<br><b style='color:" + PresetColour.BASE_GREY.toWebHexString() + ";'>\u6295\u673a\u88ad\u51fb\u8005</b><br>\u4f60\u6ca1\u6cd5\u4e3a\u4f60\u90a3\u5145\u65a5\u7740\u6b32\u671b\u7684\u7075\u5149\u627e\u4efb\u4f55\u501f\u53e3\u3002");
                    break;
                }
                case FOUR_IMPASSIONED: {
                    sb.append("[npc.NameIsFull]\u73b0\u4eca\u5df2\u7ecf\u6b32\u706b\u4e2d\u70e7\uff0c\u518d\u96be\u53bb\u60f3\u6027\u4ee5\u5916\u7684\u4e8b\u60c5\u3002");
                    if (!Main.game.isOpportunisticAttackersEnabled() || !character.isPlayer()) break;
                    sb.append("<br><b style='color:" + PresetColour.BASE_GREY.toWebHexString() + ";'>\u6295\u673a\u88ad\u51fb\u8005</b><br>\u51e0\u4e4e\u6240\u6709\u8def\u8fc7\u4f60\u7684\u4eba\u90fd\u4f1a\u6295\u4ee5\u597d\u8272\u7684\u76ee\u5149\u3002");
                    break;
                }
                case FIVE_BURNING: {
                    sb.append("[npc.NameIsFull]\u5168\u8eab\u5fc3\u6df9\u6ca1\u5728\u6b32\u671b\u5f53\u4e2d\uff0c\u53ea\u80fd\u60f3\u7740\u6027\u4e8b\u3002");
                    if (!Main.game.isOpportunisticAttackersEnabled() || !character.isPlayer()) break;
                    sb.append("<br><b style='color:" + PresetColour.BASE_GREY.toWebHexString() + ";'>\u6295\u673a\u88ad\u51fb\u8005</b><br>\u8c01\u90fd\u80fd\u770b\u51fa\u4f60\u6b63\u8eab\u5904\u6b32\u706b\u4e4b\u4e2d\uff0c\u6216\u8bb8\u4f1a\u6709\u4eba\u8d81\u673a\u5360\u4f60\u4fbf\u5b9c\u3002");
                }
            }
        }
        return UtilText.parse(character, sb.toString(), new ParserTag[0]);
    }
}

