/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.attributes;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum ObedienceLevel {
    NEGATIVE_FIVE_REBELLIOUS("\u53cd\u53db", -100, -90, PresetColour.AFFECTION_NEGATIVE_FIVE),
    NEGATIVE_FOUR_DEFIANT("\u5fe4\u9006", -90, -70, PresetColour.AFFECTION_NEGATIVE_FOUR),
    NEGATIVE_THREE_STRONG_INSUBORDINATE("\u8fdd\u6297", -70, -50, PresetColour.AFFECTION_NEGATIVE_THREE),
    NEGATIVE_TWO_UNRULY("\u4e0d\u670d\u7ba1\u6559", -50, -30, PresetColour.AFFECTION_NEGATIVE_TWO),
    NEGATIVE_ONE_DISOBEDIENT("\u53db\u9006", -30, -10, PresetColour.AFFECTION_NEGATIVE_ONE),
    ZERO_FREE_WILLED("\u968f\u5fc3\u6240\u6b32", -10, 10, PresetColour.AFFECTION_NEUTRAL),
    POSITIVE_ONE_AGREEABLE("\u987a\u4ece", 10, 30, PresetColour.AFFECTION_POSITIVE_ONE),
    POSITIVE_TWO_OBEDIENT("\u670d\u4ece", 30, 50, PresetColour.AFFECTION_POSITIVE_TWO),
    POSITIVE_THREE_DISCIPLINED("\u5b88\u7eaa", 50, 70, PresetColour.AFFECTION_POSITIVE_THREE),
    POSITIVE_FOUR_DUTIFUL("\u606d\u987a", 70, 90, PresetColour.AFFECTION_POSITIVE_FOUR),
    POSITIVE_FIVE_SUBSERVIENT("\u5351\u8eac\u5c48\u819d", 90, 100, PresetColour.AFFECTION_POSITIVE_FIVE);

    private String name;
    private int minimumValue;
    private int maximumValue;
    private Colour colour;

    private ObedienceLevel(String name, int minimumValue, int maximumValue, Colour colour) {
        this.name = name;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.colour = colour;
    }

    private static String getObedienceName(ObedienceLevel affectionLevel, boolean withColour) {
        if (withColour) {
            return "<span style='color:" + affectionLevel.getColour().toWebHexString() + ";'>" + affectionLevel.getName() + "</span>";
        }
        return affectionLevel.getName();
    }

    public String getDescription(GameCharacter character, boolean withColour, boolean longDescription) {
        return ObedienceLevel.getDescription(character, this, withColour, longDescription);
    }

    public static String getDescription(GameCharacter character, ObedienceLevel affectionLevel, boolean withColour, boolean longDescription) {
        StringBuilder sb = new StringBuilder();
        String obedienceName = ObedienceLevel.getObedienceName(affectionLevel, withColour);
        switch (affectionLevel) {
            case NEGATIVE_FIVE_REBELLIOUS: {
                sb.append(UtilText.parse(character, "[npc.Name]\u8868\u73b0\u5f97" + obedienceName + (longDescription ? "\uff0c\u65ad\u7136\u62d2\u7edd\u9075\u4ece\u4efb\u4f55\u547d\u4ee4\u3002" : "\u3002"), new ParserTag[0]));
                break;
            }
            case NEGATIVE_FOUR_DEFIANT: {
                sb.append(UtilText.parse(character, "[npc.Name]\u8868\u73b0\u5f97" + obedienceName + (longDescription ? "\uff0c\u53ea\u6709\u5728\u88ab\u5f3a\u8feb\u65f6\u624d\u4f1a\u9075\u4ece\u547d\u4ee4\u3002" : "\u3002"), new ParserTag[0]));
                break;
            }
            case NEGATIVE_THREE_STRONG_INSUBORDINATE: {
                sb.append(UtilText.parse(character, "[npc.Name]\u8868\u73b0\u5f97" + obedienceName + (longDescription ? "\uff0c\u6709\u65f6\u4f1a\u62d2\u7edd\u9075\u4ece\u547d\u4ee4\u3002" : "\u3002"), new ParserTag[0]));
                break;
            }
            case NEGATIVE_TWO_UNRULY: {
                sb.append(UtilText.parse(character, "[npc.Name]\u8868\u73b0\u5f97" + obedienceName + (longDescription ? "\uff0c\u53ea\u6709\u5728\u89c9\u5f97\u81ea\u5df1\u80fd\u591f\u9003\u8131\u60e9\u7f5a\u65f6\u624d\u4f1a\u62d2\u7edd\u9075\u4ece\u547d\u4ee4\u3002" : "\u3002"), new ParserTag[0]));
                break;
            }
            case NEGATIVE_ONE_DISOBEDIENT: {
                sb.append(UtilText.parse(character, "[npc.Name]\u8868\u73b0\u5f97" + obedienceName + (longDescription ? "\uff0c\u603b\u4f1a\u57cb\u6028\u81ea\u5df1\u5fc5\u987b\u8981\u542c\u4ece\u547d\u4ee4\u3002" : "\u3002"), new ParserTag[0]));
                break;
            }
            case ZERO_FREE_WILLED: {
                sb.append(UtilText.parse(character, "[npc.Name]\u8868\u73b0\u5f97" + obedienceName + (longDescription ? "\uff0c\u800c\u4e14\u60f3\u505a\u4ec0\u4e48\u5c31\u505a\u4ec0\u4e48\u3002" : "\u3002"), new ParserTag[0]));
                break;
            }
            case POSITIVE_ONE_AGREEABLE: {
                sb.append(UtilText.parse(character, "[npc.Name]\u8868\u73b0\u5f97" + obedienceName + (longDescription ? "\uff0c\u5e76\u4e14\u4f1a\u6beb\u65e0\u6028\u8a00\u5730\u6267\u884c\u5927\u591a\u6570\u547d\u4ee4\u3002" : "\u3002"), new ParserTag[0]));
                break;
            }
            case POSITIVE_TWO_OBEDIENT: {
                sb.append(UtilText.parse(character, "[npc.Name]\u8868\u73b0\u5f97" + obedienceName + (longDescription ? "\uff0c\u5e76\u4e14\u51e0\u4e4e\u4f1a\u505a\u6240\u6709\u88ab\u5429\u5490\u7684\u4e8b\u60c5\u3002" : "\u3002"), new ParserTag[0]));
                break;
            }
            case POSITIVE_THREE_DISCIPLINED: {
                sb.append(UtilText.parse(character, "[npc.Name]\u8868\u73b0\u5f97" + obedienceName + (longDescription ? "\uff0c\u5e76\u4e14\u4f1a\u6beb\u65e0\u6028\u8a00\u5730\u6267\u884c\u547d\u4ee4\u3002" : "\u3002"), new ParserTag[0]));
                break;
            }
            case POSITIVE_FOUR_DUTIFUL: {
                sb.append(UtilText.parse(character, "[npc.Name]\u8868\u73b0\u5f97" + obedienceName + (longDescription ? "\uff0c\u5e76\u4e14\u603b\u80fd\u8d85\u51fa\u547d\u4ee4\u7684\u8981\u6c42\u3002" : "\u3002"), new ParserTag[0]));
                break;
            }
            case POSITIVE_FIVE_SUBSERVIENT: {
                sb.append(UtilText.parse(character, "[npc.Name]\u8868\u73b0\u5f97" + obedienceName + (longDescription ? "\uff0c\u5e76\u4e14\u65e0\u8bba\u88ab\u5429\u5490\u4ec0\u4e48\u4e8b\u60c5\u90fd\u4f1a\u53bb\u5b8c\u6210\u3002" : "\u3002"), new ParserTag[0]));
            }
        }
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getMedianValue() {
        return (this.minimumValue + this.maximumValue) / 2;
    }

    public Colour getColour() {
        return this.colour;
    }

    public static ObedienceLevel getObedienceLevelFromValue(float value) {
        for (ObedienceLevel al : ObedienceLevel.values()) {
            if (!(value >= (float)al.getMinimumValue()) || !(value < (float)al.getMaximumValue())) continue;
            return al;
        }
        return POSITIVE_FIVE_SUBSERVIENT;
    }

    public boolean isGreaterThan(ObedienceLevel levelComparison) {
        return this.getMaximumValue() > levelComparison.getMaximumValue();
    }

    public boolean isLessThan(ObedienceLevel levelComparison) {
        return this.getMaximumValue() < levelComparison.getMaximumValue();
    }
}

