/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.attributes;

import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum ObedienceLevelBasic {
    DISOBEDIENT("\u53db\u9006", -100, -30, PresetColour.AFFECTION_NEGATIVE_FIVE),
    NEUTRAL("\u4e2d\u7acb", -30, 30, PresetColour.AFFECTION_NEUTRAL),
    OBEDIENT("\u670d\u4ece", 30, 100, PresetColour.AFFECTION_POSITIVE_FIVE);

    private String name;
    private int minimumValue;
    private int maximumValue;
    private Colour colour;

    private ObedienceLevelBasic(String name, int minimumValue, int maximumValue, Colour colour) {
        this.name = name;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.colour = colour;
    }

    public String getName() {
        return this.name;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getMedianValue() {
        return (this.minimumValue + this.maximumValue) / 2;
    }

    public Colour getColour() {
        return this.colour;
    }

    public static ObedienceLevelBasic getObedienceLevelFromValue(float value) {
        for (ObedienceLevelBasic al : ObedienceLevelBasic.values()) {
            if (!(value >= (float)al.getMinimumValue()) || !(value < (float)al.getMaximumValue())) continue;
            return al;
        }
        return OBEDIENT;
    }
}

