/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.attributes;

import com.lilithsthrone.game.character.effects.AbstractStatusEffect;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PhysiqueLevel {
    ZERO_WEAK("\u5b71\u5f31", 0, 10, PresetColour.PHYSIQUE_STAGE_ZERO){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.PHYSIQUE_PERK_0;
        }
    }
    ,
    ONE_AVERAGE("\u5982\u5e38", 10, 30, PresetColour.PHYSIQUE_STAGE_ONE){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.PHYSIQUE_PERK_1;
        }
    }
    ,
    TWO_STRONG("\u5065\u58ee", 30, 50, PresetColour.PHYSIQUE_STAGE_TWO){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.PHYSIQUE_PERK_2;
        }
    }
    ,
    THREE_POWERFUL("\u5f3a\u5065", 50, 70, PresetColour.PHYSIQUE_STAGE_THREE){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.PHYSIQUE_PERK_3;
        }
    }
    ,
    FOUR_MIGHTY("\u5a01\u731b", 70, 90, PresetColour.PHYSIQUE_STAGE_FOUR){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.PHYSIQUE_PERK_4;
        }
    }
    ,
    FIVE_HERCULEAN("\u795e\u529b", 90, 100, PresetColour.PHYSIQUE_STAGE_FIVE){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.PHYSIQUE_PERK_5;
        }
    };

    private String name;
    private int minimumValue;
    private int maximumValue;
    private Colour colour;

    private PhysiqueLevel(String name, int minimumValue, int maximumValue, Colour colour) {
        this.name = name;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.colour = colour;
    }

    public abstract AbstractStatusEffect getRelatedStatusEffect();

    public String getName() {
        return this.name;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public Colour getColour() {
        return this.colour;
    }

    public static PhysiqueLevel getPhysiqueLevelFromValue(float value) {
        for (PhysiqueLevel al : PhysiqueLevel.values()) {
            if (!(value >= (float)al.getMinimumValue()) || !(value < (float)al.getMaximumValue())) continue;
            return al;
        }
        return FIVE_HERCULEAN;
    }
}

