/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.BodyPartInterface;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractAntennaType;
import com.lilithsthrone.game.character.body.types.AntennaType;
import com.lilithsthrone.game.character.body.valueEnums.HornLength;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;

public class Antenna
implements BodyPartInterface {
    public static final int MAXIMUM_ROWS = 3;
    public static final int MAXIMUM_ANTENNAE_PER_ROW = 4;
    protected AbstractAntennaType type;
    protected int rows;
    protected int antennaePerRow;
    protected int length;

    public Antenna(AbstractAntennaType type, int length) {
        this.type = type;
        this.length = length;
        this.rows = 1;
        this.antennaePerRow = type.getDefaultAntennaePerRow();
    }

    public Antenna(Antenna antennaToCopy) {
        this.type = antennaToCopy.type;
        this.length = antennaToCopy.length;
        this.rows = antennaToCopy.rows;
        this.antennaePerRow = antennaToCopy.antennaePerRow;
    }

    @Override
    public AbstractAntennaType getType() {
        return this.type;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return this.type.getDeterminer(gc);
    }

    @Override
    public String getName(GameCharacter gc) {
        return this.type.getName(gc);
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.type.getNameSingular(gc);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.type.getNamePlural(gc);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        return this.type.getDescriptor(gc);
    }

    public String setType(GameCharacter owner, AbstractAntennaType type) {
        if (!Main.game.isStarted() || owner == null) {
            this.type = type;
            if (owner != null) {
                owner.postTransformationCalculation();
            }
            return "";
        }
        if (type == this.getType()) {
            if (type.equals(AntennaType.NONE)) {
                return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6ca1\u6709)]\u89e6\u987b\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026</p>", new ParserTag[0]);
            }
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6709[npc.a_antennaRace]\u7684[npc.antenna]\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        StringBuilder sb = new StringBuilder();
        if (this.type.equals(AntennaType.NONE)) {
            sb.append(UtilText.parse(owner, "<p>[npc.Name]\u5012\u5438\u4e00\u53e3\u51c9\u6c14\uff0c\u611f\u5230\u524d\u989d\u53d8\u5f97\u6eda\u70eb\u53c8\u654f\u611f\uff0c\u8fde\u5fd9\u6478\u4e86\u6478\u3002\u8fc7\u4e86\u4e00\u4f1a\u513f\uff0c[npc.her]\u9707\u60ca\u5730\u7741\u5927\u4e86[npc.eyes]\uff0c\u6709\u4ec0\u4e48\u4e1c\u897f\u4ece[npc.her]\u524d\u989d\u7684[npc.faceSkin]\u4e4b\u4e0b\u51b2\u4e86\u51fa\u6765\u3002", new ParserTag[0]));
        } else {
            sb.append(UtilText.parse(owner, "<p>[npc.Name]\u5012\u5438\u4e00\u53e3\u51c9\u6c14\uff0c\u611f\u5230[npc.antennae]\u7684\u6839\u90e8\u6709\u4e00\u79cd\u5947\u602a\u7684\u523a\u75db\u611f\u3002\u8fd8\u6ca1\u7b49[npc.she]\u53cd\u5e94\u8fc7\u6765\uff0c[npc.antennae]\u4fbf\u5206\u5d29\u79bb\u6790\uff0c\u8f6c\u77ac\u6d88\u5931\u4e86\u3002", new ParserTag[0]));
        }
        if (type != AntennaType.NONE) {
            sb.append(UtilText.parse(owner, "[npc.she]\u60ca\u5598\u51fa\u58f0\uff0c\u575a\u786c\u7684\u5c0f\u51f8\u8d77\u4ece[npc.her]\u8111\u888b\u4e0a\u5ffd\u7136\u5192\u51fa\u6765\uff0c\u5e76\u4e14\u8fc5\u901f\u6210\u957f\u4e3a\u4e86", new ParserTag[0]));
        }
        this.type = type;
        sb.append(type.getTransformationDescription(owner));
        return UtilText.parse(owner, sb.toString(), new ParserTag[0]) + "<p>" + owner.postTransformationCalculation() + "</p>";
    }

    public int getAntennaRows() {
        return this.rows;
    }

    public String setAntennaRows(GameCharacter owner, int rows) {
        rows = Math.max(1, Math.min(rows, 3));
        if (owner == null) {
            this.rows = rows;
            return "";
        }
        if (owner.getAntennaRows() == rows) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        boolean removingAntennae = owner.getAntennaRows() > rows;
        this.rows = rows;
        owner.postTransformationCalculation();
        if (owner.getAntennaType().equals(AntennaType.NONE)) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        if (removingAntennae) {
            return UtilText.parse(owner, "<p>\u4e00\u80a1\u523a\u75db\u611f\u4f20\u904d\u4e86[npc.namePos]\u7684[npc.antennae]\uff0c\u63a5\u7740\u8fd9\u79cd\u611f\u89c9\u7ee7\u7eed\u5411\u4e0b\uff0c\u96c6\u4e2d\u5728\u4e86[npc.her]\u7684\u524d\u989d\u4e0a\u3002[npc.She]\u4e0d\u7981\u5927\u53eb\u4e00\u58f0\uff0c\u53ea\u611f\u5230\u6709\u4e9b[npc.antennae]\u987f\u65f6\u5206\u5d29\u79bb\u6790\uff0c\u6d88\u5931\u5728[npc.her]\u7684[npc.faceSkin]\u4e4b\u4e0b\u3002<br/>\u8fc7\u4e86\u4e00\u4f1a\u513f\uff0c[npc.sheIs]\u4fbf\u5f97\u5230\u4e86[style.boldTfGeneric([npc.a_antennae])]\u3002</p>", new ParserTag[0]);
        }
        return UtilText.parse(owner, "<p>\u4e00\u80a1\u523a\u75db\u611f\u4f20\u904d\u4e86[npc.namePos]\u7684[npc.antennae]\uff0c\u63a5\u7740\u8fd9\u79cd\u611f\u89c9\u7ee7\u7eed\u5411\u4e0b\uff0c\u96c6\u4e2d\u5728\u4e86[npc.her]\u7684\u524d\u989d\u4e0a\u3002[npc.She]\u4e0d\u7981\u5927\u53eb\u4e00\u58f0\uff0c\u53ea\u611f\u5230\u5168\u65b0\u7684[npc.antennae][style.boldGrow(\u5411\u4e0a\u63a8\u6324)]\u7740\uff0c\u4ece[npc.her]\u7684[npc.faceSkin]\u4e0a\u957f\u4e86\u51fa\u6765\u3002<br/>\u8fc7\u4e86\u4e00\u4f1a\u513f\uff0c[npc.sheIs]\u4fbf\u5f97\u5230\u4e86[style.boldTfGeneric([npc.a_antennae])]\u3002</p>", new ParserTag[0]);
    }

    public int getAntennaePerRow() {
        return this.antennaePerRow;
    }

    public String setAntennaePerRow(GameCharacter owner, int antennaePerRow) {
        antennaePerRow = Math.max(1, Math.min(antennaePerRow, 4));
        if (owner == null) {
            this.antennaePerRow = antennaePerRow;
            return "";
        }
        if (owner.getAntennaePerRow() == antennaePerRow) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        boolean removingAntennae = owner.getAntennaePerRow() > antennaePerRow;
        this.antennaePerRow = antennaePerRow;
        owner.postTransformationCalculation();
        if (owner.getAntennaType().equals(AntennaType.NONE)) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        if (removingAntennae) {
            return UtilText.parse(owner, "<p>\u4e00\u80a1\u5947\u602a\u7684\u8e81\u52a8\u611f\u5728[npc.namePos]\u7684[npc.antennae]\u57fa\u90e8\u6108\u53d1\u5f3a\u70c8\u3002\u8fd8\u6ca1\u7b49[npc.she]\u53cd\u5e94\u8fc7\u6765\uff0c[npc.antennae]\u4fbf\u5f00\u59cb[style.boldShrink(\u89e3\u79bb\u91cd\u7ec4)]\u3002<br/>\u8fc7\u4e86\u4e00\u4f1a\u513f\uff0c[npc.sheIs]\u5c31\u53d8\u6210\u4e86" + (this.rows == 1 ? "" : "\u6bcf\u4e00\u7ec4") + "[style.boldTfGeneric(" + Util.intToString(antennaePerRow) + "\u6839" + (antennaePerRow == 1 ? "[npc.antenna]" : "[npc.antennae]") + ")]\uff01</p>", new ParserTag[0]);
        }
        return UtilText.parse(owner, "<p>\u4e00\u80a1\u5947\u602a\u7684\u8e81\u52a8\u611f\u5728[npc.namePos]\u7684\u524d\u989d\u6108\u53d1\u5f3a\u70c8\u3002\u8fd8\u6ca1\u7b49[npc.she]\u53cd\u5e94\u8fc7\u6765\uff0c\u5168\u65b0\u7684[npc.antennae]\u4fbf\u7a81\u7136\u51b2\u51fa\uff0c\u4ece[npc.her]\u7684[npc.faceSkin]\u4e0a\u957f\u4e86\u51fa\u6765\u3002<br/>\u8fc7\u4e86\u4e00\u4f1a\u513f\uff0c[npc.sheIs]\u5c31\u53d8\u6210\u4e86" + (this.rows == 1 ? "" : "\u6bcf\u4e00\u7ec4") + "[style.boldTfGeneric(" + Util.intToString(antennaePerRow) + "\u6839" + (antennaePerRow == 1 ? "[npc.antenna]" : "[npc.antennae]") + ")]\uff01</p>", new ParserTag[0]);
    }

    public int getTotalAntennae() {
        return this.getAntennaRows() * this.getAntennaePerRow();
    }

    public HornLength getAntennaLength() {
        return HornLength.getLengthFromInt(this.length);
    }

    public int getAntennaLengthValue() {
        return this.length;
    }

    public String setAntennaLength(GameCharacter owner, int length) {
        int oldLength = this.length;
        this.length = Math.max(0, Math.min(length, HornLength.FOUR_MASSIVE.getMaximumValue()));
        int sizeChange = this.length - oldLength;
        if (owner == null) {
            return "";
        }
        if (owner.getAntennaType().equals(AntennaType.NONE)) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u6ca1\u6709\u89e6\u987b\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        if (sizeChange == 0) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.namePos][npc.antennae]\u7684\u957f\u5ea6\u6ca1\u6709\u53d8\u5316\u2026\u2026)]</p>", new ParserTag[0]);
        }
        if (sizeChange < 0) {
            return UtilText.parse(owner, "<p>[npc.Name]\u60ca\u53eb\u4e86\u4e00\u58f0\uff0c[npc.she]\u611f\u5230\u4e00\u80a1\u5947\u602a\u7684\u523a\u75db\u611f\u4f20\u904d[npc.face]\uff0c\u5f88\u5feb\u4fbf\u4f20\u5230\u4e86[npc.antennae]\u4e0a\uff0c\u968f\u540e[npc.antennae]\u4fbf\u7f29\u56de\u53bb\u4e00\u622a\uff0c[style.boldShrink(\u663e\u7136\u66f4\u77ed\u4e86)]\u3002<br/>[npc.Name]\u76ee\u524d\u62e5\u6709[style.boldTfGeneric([npc.antennaSize]\u7684[npc.antennae])]\uff01</p>", new ParserTag[0]);
        }
        return UtilText.parse(owner, "<p>[npc.Name]\u53d1\u51fa\u4e00\u5c0f\u58f0\u5c16\u53eb\uff0c[npc.she]\u611f\u5230\u4e00\u80a1\u6e29\u70ed\u7684\u8109\u52a8\u611f\u4ece[npc.face]\u4f20\u9012\u5230\u4e86[npc.antennae]\uff0c\u968f\u540e[npc.antennae]\u4fbf\u957f\u51fa\u6765\u4e00\u622a\uff0c[style.boldGrow(\u663e\u7136\u66f4\u957f\u4e86)]\u3002<br/>[npc.Name]\u76ee\u524d\u62e5\u6709[style.boldTfGeneric([npc.antennaSize]\u7684[npc.antennae])]\uff01</p>", new ParserTag[0]);
    }

    @Override
    public boolean isFeral(GameCharacter owner) {
        if (owner == null) {
            return false;
        }
        return owner.isFeral() || owner.getLegConfiguration().getFeralParts().contains(Antenna.class) && this.getType().getRace().isFeralPartsAvailable();
    }
}

