/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.BodyPartInterface;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.types.BodyPartTypeInterface;
import com.lilithsthrone.game.character.body.valueEnums.ClitorisSize;
import com.lilithsthrone.game.character.body.valueEnums.PenetrationGirth;
import com.lilithsthrone.game.character.body.valueEnums.PenetrationModifier;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.utils.Units;
import com.lilithsthrone.utils.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class Clitoris
implements BodyPartInterface {
    protected int clitSize;
    protected int girth;
    protected Set<PenetrationModifier> clitModifiers;

    public Clitoris(int clitSize, int girth) {
        this.clitSize = clitSize;
        this.girth = girth;
        this.clitModifiers = new HashSet<PenetrationModifier>();
    }

    public Clitoris(Clitoris clitorisToCopy) {
        this.clitSize = clitorisToCopy.clitSize;
        this.girth = clitorisToCopy.girth;
        this.clitModifiers = new HashSet<PenetrationModifier>(clitorisToCopy.clitModifiers);
    }

    @Override
    public BodyPartTypeInterface getType() {
        return null;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return "";
    }

    @Override
    public String getName(GameCharacter gc) {
        return this.getNameSingular(gc);
    }

    @Override
    public String getName(GameCharacter gc, boolean withDescriptor) {
        String name = this.getName(gc);
        String descriptor = this.getDescriptor(gc);
        return (String)(withDescriptor && descriptor != null && !descriptor.isEmpty() ? descriptor + "\u7684" : "") + name;
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        if (this.getClitorisSize() == ClitorisSize.ZERO_AVERAGE) {
            return UtilText.returnStringAtRandom("\u9634\u8482", "\u9634\u8482", "\u8c46\u8c46", "\u8c46\u8c46", "\u9634\u6838");
        }
        return UtilText.returnStringAtRandom("\u9634\u8482", "\u9634\u8482", "\u9634\u8482", "\u9634\u8482\u5c4c");
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        if (this.getClitorisSize() == ClitorisSize.ZERO_AVERAGE) {
            return UtilText.returnStringAtRandom("\u9634\u8482", "\u9634\u8482", "\u8c46\u8c46", "\u8c46\u8c46", "\u9634\u6838");
        }
        return UtilText.returnStringAtRandom("\u9634\u8482", "\u9634\u8482", "\u9634\u8482", "\u9634\u8482\u5c4c");
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(GameCharacter gc) {
        return gc.getVaginaType().getBodyCoveringType(gc);
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(Body body) {
        return body.getVagina().getBodyCoveringType(body);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        PenetrationModifier mod;
        ArrayList<String> descriptors = new ArrayList<String>();
        descriptors.add("\u654f\u611f");
        if (this.getGirth() != PenetrationGirth.THREE_AVERAGE) {
            descriptors.add(this.getGirth().getName());
        }
        if (this.getClitorisSize() != ClitorisSize.ZERO_AVERAGE) {
            descriptors.add(this.getClitorisSize().getDescriptor());
        } else {
            descriptors.add("\u5c0f\u5de7");
        }
        if (!this.getClitorisModifiers().isEmpty() && (mod = Util.randomItemFrom(this.getClitorisModifiers())) != PenetrationModifier.OVIPOSITOR) {
            descriptors.add(mod.getName());
        }
        if (gc.getBodyMaterial().getPartDescriptors() != null && !gc.getBodyMaterial().getPartDescriptors().isEmpty()) {
            descriptors.add(Util.randomItemFrom(gc.getBodyMaterial().getPartDescriptors()));
        }
        return (String)Util.randomItemFrom(descriptors);
    }

    public String getClitTipNameSingular(GameCharacter gc) {
        return UtilText.returnStringAtRandom("\u5c16\u7aef", "\u9876\u7aef", "\u672b\u7aef");
    }

    public String getClitTipNamePlural(GameCharacter gc) {
        return UtilText.returnStringAtRandom("\u5c16\u7aef", "\u9876\u7aef", "\u672b\u7aef");
    }

    public String getClitTipDescriptor(GameCharacter gc) {
        ArrayList<String> descriptors = new ArrayList<String>();
        for (PenetrationModifier mod : this.getClitorisModifiers()) {
            switch (mod) {
                case BARBED: 
                case KNOTTED: 
                case OVIPOSITOR: 
                case PREHENSILE: 
                case RIBBED: 
                case SHEATHED: 
                case TENTACLED: 
                case VEINY: {
                    break;
                }
                case BLUNT: {
                    descriptors.add("\u5706\u5934");
                    break;
                }
                case FLARED: {
                    descriptors.add("\u5e73\u5934");
                    break;
                }
                case TAPERED: {
                    descriptors.add("\u5c16\u5934");
                }
            }
        }
        if (descriptors.isEmpty()) {
            return "";
        }
        return (String)Util.randomItemFrom(descriptors);
    }

    public ClitorisSize getClitorisSize() {
        return ClitorisSize.getClitorisSizeFromInt(this.clitSize);
    }

    public int getRawClitorisSizeValue() {
        return this.clitSize;
    }

    public String setClitorisSize(GameCharacter owner, int clitSize) {
        if (owner == null) {
            this.clitSize = Math.max(0, Math.min(clitSize, ClitorisSize.SEVEN_STALLION.getMaximumValue()));
            return "";
        }
        if (!owner.hasVagina()) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        int oldSize = this.clitSize;
        this.clitSize = Math.max(0, Math.min(clitSize, ClitorisSize.SEVEN_STALLION.getMaximumValue()));
        int sizeChange = this.clitSize - oldSize;
        if (sizeChange == 0) {
            if (owner.isPlayer()) {
                return "<p style='text-align:center;'>[style.colourDisabled(\u4f60\u9634\u8482\u7684\u5c3a\u5bf8\u6ca1\u6709\u53d8\u5316\u2026\u2026)]</p>";
            }
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.namePos]\u9634\u8482\u7684\u5c3a\u5bf8\u6ca1\u6709\u53d8\u5316\u2026\u2026)]</p>", new ParserTag[0]);
        }
        if (sizeChange > 0) {
            if (owner.isPlayer()) {
                return "<p>\u4f60\u611f\u5230[pc.pussy]\u6df1\u5904\u51fa\u73b0\u4e00\u80a1\u640f\u52a8\u611f\uff0c\u4e0d\u7981\u5192\u51fa\u4e00\u58f0[pc.a_moan]\u3002\u5f53\u8fd9\u80a1\u611f\u89c9\u9010\u6e10\u96c6\u4e2d\u5230\u9634\u8482\u4e0a\u65f6\uff0c\u4f60\u7684\u8138\u988a\u987f\u65f6\u67d3\u4e0a\u4e86\u7eef\u7ea2\uff0c\u8f7b\u58f0\u5598\u606f\u8fc7\u540e\uff0c\u4f60\u89c9\u5f97\u90a3\u91cc[style.boldGrow(\u53d8\u5f97\u66f4\u5927\u4e86)]\u3002<br/>\u4f60\u73b0\u5728\u62e5\u6709[style.boldSex([pc.a_clitSize]\u7684[pc.clit])]\uff01</p>";
            }
            return UtilText.parse(owner, "<p>[npc.Name]\u611f\u5230[npc.pussy]\u6df1\u5904\u51fa\u73b0\u4e00\u80a1\u640f\u52a8\u611f\uff0c\u4e0d\u7981\u5192\u51fa\u4e00\u58f0[npc.a_moan]\u3002\u5f53\u8fd9\u80a1\u611f\u89c9\u9010\u6e10\u96c6\u4e2d\u5230\u9634\u8482\u4e0a\u65f6\uff0c[npc.her]\u7684\u8138\u988a\u987f\u65f6\u67d3\u4e0a\u4e86\u7eef\u7ea2\uff0c\u8f7b\u58f0\u5598\u606f\u8fc7\u540e\uff0c[npc.she]\u89c9\u5f97\u90a3\u91cc[style.boldGrow(\u53d8\u5f97\u66f4\u5927\u4e86)]\u3002<br/>[npc.she]\u73b0\u5728\u62e5\u6709[style.boldSex([npc.a_clitSize]\u7684[npc.clit])]\uff01</p>", new ParserTag[0]);
        }
        if (owner.isPlayer()) {
            return "<p>\u4f60\u611f\u5230[pc.pussy]\u6df1\u5904\u51fa\u73b0\u4e00\u80a1\u640f\u52a8\u611f\uff0c\u4e0d\u7981\u5192\u51fa\u4e00\u58f0[pc.a_moan]\u3002\u5f53\u8fd9\u80a1\u611f\u89c9\u9010\u6e10\u96c6\u4e2d\u5230\u9634\u8482\u4e0a\u65f6\uff0c\u4f60\u7684\u8138\u988a\u987f\u65f6\u67d3\u4e0a\u4e86\u7eef\u7ea2\uff0c\u8f7b\u58f0\u5598\u606f\u8fc7\u540e\uff0c\u4f60\u89c9\u5f97\u90a3\u91cc[style.boldShrink(\u7f29\u5c0f\u4e86)]\u3002<br/>\u4f60\u73b0\u5728\u62e5\u6709[style.boldSex([pc.a_clitSize]\u7684[pc.clit])]\uff01</p>";
        }
        return UtilText.parse(owner, "<p>[npc.Name]\u611f\u5230[npc.pussy]\u6df1\u5904\u51fa\u73b0\u4e00\u80a1\u640f\u52a8\u611f\uff0c\u4e0d\u7981\u5192\u51fa\u4e00\u58f0[npc.a_moan]\u3002\u5f53\u8fd9\u80a1\u611f\u89c9\u9010\u6e10\u96c6\u4e2d\u5230\u9634\u8482\u4e0a\u65f6\uff0c[npc.her]\u7684\u8138\u988a\u987f\u65f6\u67d3\u4e0a\u4e86\u7eef\u7ea2\uff0c\u8f7b\u58f0\u5598\u606f\u8fc7\u540e\uff0c[npc.she]\u89c9\u5f97\u90a3\u91cc[style.boldShrink(\u7f29\u5c0f\u4e86)]\u3002<br/>[npc.she]\u73b0\u5728\u62e5\u6709[style.boldSex([npc.a_clitSize]\u7684[npc.clit])]\uff01</p>", new ParserTag[0]);
    }

    public PenetrationGirth getGirth() {
        return PenetrationGirth.getGirthFromInt(this.girth);
    }

    public int getRawGirthValue() {
        return this.girth;
    }

    public String setGirth(GameCharacter owner, int girth) {
        if (owner == null) {
            this.girth = Math.max(0, Math.min(girth, PenetrationGirth.getMaximum()));
            return "";
        }
        if (!owner.hasVagina()) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        int girthChange = 0;
        if (girth <= 0) {
            if (this.girth != 0) {
                girthChange = 0 - this.girth;
                this.girth = 0;
            }
        } else if (girth >= PenetrationGirth.getMaximum()) {
            if (this.girth != PenetrationGirth.getMaximum()) {
                girthChange = PenetrationGirth.getMaximum() - this.girth;
                this.girth = PenetrationGirth.getMaximum();
            }
        } else if (this.girth != girth) {
            girthChange = girth - this.girth;
            this.girth = girth;
        }
        if (girthChange == 0) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.namePos]\u7684[npc.clit]\u7684\u5468\u957f\u6ca1\u6709\u53d8\u5316\u2026\u2026)]</p>", new ParserTag[0]);
        }
        if (girthChange > 0) {
            return UtilText.parse(owner, "</p>[npc.Name]\u611f\u5230\u9634\u8482\u51fa\u73b0\u4e00\u80a1\u5f3a\u70c8\u7684\u640f\u52a8\u611f\uff0c\u4e0d\u7981\u5192\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5f53\u8fd9\u80a1\u611f\u89c9\u9010\u6e10\u4f20\u904d\u4e86\u6574\u4e2a[npc.pussy+]\u65f6\uff0c[npc.her]\u7684\u8138\u988a\u987f\u65f6\u67d3\u4e0a\u4e86\u7eef\u7ea2\uff0c\u53c8\u4e00\u58f0[npc.moan+]\u8131\u53e3\u800c\u51fa\uff0c[npc.her]\u7684\u9634\u8482\u7a81\u7136[style.boldGrow(\u53d8\u5f97\u66f4\u7c97\u4e86)]\u3002<br/>[npc.she]\u73b0\u5728\u62e5\u6709[style.boldSex([npc.a_clitGirth]\u7684[npc.clit])]\uff01</p>", new ParserTag[0]);
        }
        return UtilText.parse(owner, "</p>[npc.Name]\u611f\u5230\u9634\u8482\u51fa\u73b0\u4e00\u80a1\u5f3a\u70c8\u7684\u640f\u52a8\u611f\uff0c\u4e0d\u7981\u5192\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5f53\u8fd9\u80a1\u611f\u89c9\u9010\u6e10\u4f20\u904d\u4e86\u6574\u4e2a[npc.pussy+]\u65f6\uff0c[npc.her]\u7684\u8138\u988a\u987f\u65f6\u67d3\u4e0a\u4e86\u7eef\u7ea2\uff0c\u53c8\u4e00\u58f0[npc.moan+]\u8131\u53e3\u800c\u51fa\uff0c[npc.her]\u7684\u9634\u8482\u7a81\u7136[style.boldShrink(\u53d8\u5f97\u66f4\u7ec6\u4e86)]\u3002<br/>[npc.she]\u73b0\u5728\u62e5\u6709[style.boldSex([npc.a_clitGirth]\u7684[npc.cock])]\uff01</p>", new ParserTag[0]);
    }

    public static float getGenericDiameter(int length, PenetrationGirth girth) {
        return Clitoris.getGenericDiameter(length, girth, new HashSet<PenetrationModifier>());
    }

    public static float getGenericDiameter(int length, PenetrationGirth girth, Set<PenetrationModifier> mods) {
        float baseDiameterModifier = 0.2f;
        baseDiameterModifier = Math.max(0.15f, baseDiameterModifier - (float)Math.max(length - 15, 0) * 0.0025f);
        return Units.round((float)length * baseDiameterModifier * (1.0f + girth.getDiameterPercentageModifier() + (mods.contains((Object)PenetrationModifier.FLARED) ? 0.05f : 0.0f) + (mods.contains((Object)PenetrationModifier.TAPERED) ? -0.05f : 0.0f)), 2);
    }

    public float getDiameter() {
        return Clitoris.getGenericDiameter(this.clitSize, this.getGirth(), this.clitModifiers);
    }

    public Set<PenetrationModifier> getClitorisModifiers() {
        return this.clitModifiers;
    }

    public boolean hasClitorisModifier(PenetrationModifier modifier) {
        return this.clitModifiers.contains((Object)modifier);
    }

    public String addClitorisModifier(GameCharacter owner, PenetrationModifier modifier) {
        if (this.hasClitorisModifier(modifier)) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        this.clitModifiers.add(modifier);
        ArrayList<String> pmsRemoved = new ArrayList<String>();
        for (PenetrationModifier pm : modifier.getMutuallyExclusivePenetrationModifiers()) {
            if (!this.hasClitorisModifier(pm)) continue;
            pmsRemoved.add(pm.getName());
            this.clitModifiers.remove((Object)pm);
        }
        if (owner == null) {
            return "";
        }
        if (!owner.hasVagina()) {
            if (owner.isPlayer()) {
                return "<p style='text-align:center;'>[style.colourDisabled(\u4f60\u6ca1\u6709\u9634\u8482\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
            }
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u6ca1\u6709\u9634\u8482\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        Object removedText = "";
        if (!pmsRemoved.isEmpty()) {
            removedText = "<br/>[style.italicsMinorBad(\u7531\u4e8e\u8ddf\u201c" + modifier.getName() + "\u201d\u4fee\u9970\u8bcd\u51b2\u7a81\uff0c[npc.namePos]\u7684\u9634\u8482\u4e0d\u518d" + Util.stringsToStringList(pmsRemoved, false) + "\u4e86\u3002)]";
        }
        String returnText = "";
        switch (modifier) {
            case RIBBED: {
                returnText = "\u4e00\u80a1\u5f3a\u70c8\u7684\u538b\u8feb\u611f\u5728[npc.namePos]\u7684[npc.clit]\u4e0a\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49[npc.she]\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u6574\u6839\u4e0a\u5c31\u51fa\u73b0\u4e86\u4e00\u8fde\u4e32[style.boldGrow(\u8089\u8d28\u7684\u786c\u8d28\u51f8\u8d77)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u73b0\u5728\u957f\u6709\u87ba\u7eb9\uff01)]";
                break;
            }
            case TENTACLED: {
                returnText = "\u4e00\u80a1\u60b8\u52a8\u7684\u6696\u6d41\u5728[npc.namePos]\u7684[npc.clit]\u4e0a\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49[npc.she]\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u6574\u6839\u4e0a\u5c31\u51fa\u73b0\u4e86\u4e00\u8fde\u4e32[style.boldGrow(\u626d\u52a8\u7684\u7ec6\u5c0f\u89e6\u624b)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u4e0a\u73b0\u5728\u8986\u76d6\u7740\u7ec6\u5c0f\u7684\u89e6\u624b\uff0c\u81ea\u884c\u873f\u8712\u626d\u52a8\u7740\uff01)]";
                break;
            }
            case BARBED: {
                returnText = "\u4e00\u80a1\u5f3a\u70c8\u7684\u6696\u6d41\u5728[npc.namePos]\u7684[npc.clit]\u4e0a\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49[npc.she]\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u6574\u6839\u4e0a\u5c31\u51fa\u73b0\u4e86\u4e00\u8fde\u4e32[style.boldGrow(\u8089\u8d28\u7684\u5012\u523a)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u4e0a\u73b0\u5728\u6392\u5217\u7740\u8089\u8d28\u7684\u5012\u523a\uff01)]";
                break;
            }
            case FLARED: {
                returnText = "\u4e00\u80a1\u5f3a\u70c8\u7684\u538b\u8feb\u611f\u5728[npc.namePos][npc.clit]\u7684\u5c16\u7aef\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49[npc.she]\u6709\u4efb\u4f55\u53cd\u5e94\uff0c[style.boldGrow(\u5934\u90e8\u5c31\u5e73\u5766\u4e0b\u6765)]\uff0c\u50cf\u662f\u9a6c\u9634\u830e\u4e00\u822c\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u73b0\u5728\u6709\u7740\u5bbd\u5927\u7684\u5e73\u5934\uff01)]";
                break;
            }
            case BLUNT: {
                returnText = "\u4e00\u80a1\u5f3a\u70c8\u7684\u538b\u8feb\u611f\u5728[npc.namePos][npc.clit]\u7684\u5c16\u7aef\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49[npc.she]\u6709\u4efb\u4f55\u53cd\u5e94\uff0c[style.boldGrow(\u5934\u90e8\u53d8\u5f97\u5706\u949d)]\uff0c\u50cf\u662f\u722c\u884c\u7c7b\u7684\u9634\u830e\u4e00\u822c\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u73b0\u5728\u6709\u7740\u5149\u6ed1\u7684\u5706\u5934\uff01)]";
                break;
            }
            case KNOTTED: {
                returnText = "\u4e00\u80a1\u5f3a\u70c8\u7684\u538b\u8feb\u611f\u5728[npc.namePos][npc.clit]\u7684\u6839\u90e8\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49[npc.she]\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u4e00\u4e2a[style.boldGrow(\u7c97\u5927\u7684\u7ed3)]\u5c31\u751f\u957f\u4e86\u51fa\u6765\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u73b0\u5728\u5728\u6839\u90e8\u957f\u7740\u4e00\u4e2a\u7c97\u5927\u7684\u7ed3\uff01)]";
                break;
            }
            case PREHENSILE: {
                returnText = "\u4e00\u79cd\u5947\u602a\u7684\u523a\u75db\u611f\u5728[npc.namePos]\u7684\u6574\u6839[npc.clit]\u4e0a\u6563\u64ad\uff0c[npc.she]\u5ffd\u7136\u610f\u8bc6\u5230\u9634\u8482\u6b63\u5728\u53d8\u5f97[style.boldGrow(\u7075\u6d3b\u53ef\u63a7)]\uff0c\u8fd9\u4f7f\u5f97[npc.herHim]\u80fd\u591f\u50cf\u7075\u957f\u76ee\u7684\u5c3e\u5df4\u4e00\u6837\u5f2f\u66f2\u79fb\u52a8\u5b83\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u73b0\u5728\u7075\u6d3b\u53ef\u63a7\u4e86\uff01)]";
                break;
            }
            case SHEATHED: {
                returnText = "\u4e00\u80a1\u5f3a\u70c8\u7684\u538b\u8feb\u611f\u5728[npc.namePos][npc.clit]\u7684\u6839\u90e8\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49[npc.she]\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u9634\u8482\u4fbf\u7f29\u5165\u4e00\u4e2a\u5168\u65b0\u7684[style.boldGrow(\u9798)]\u4e2d\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u73b0\u5728\u62e5\u6709\u9634\u8482\u9798\u4e86\uff01)]";
                break;
            }
            case TAPERED: {
                returnText = "\u4e00\u80a1\u5f3a\u70c8\u7684\u6696\u6d41\u5728[npc.namePos]\u7684[npc.clit]\u4e0a\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49[npc.she]\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u6574\u6839\u5c31\u7a81\u7136[style.boldGrow(\u53d8\u6210\u4e86\u9525\u5f62)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u73b0\u5728\u662f\u9525\u5f62\u7684\uff01)]";
                break;
            }
            case VEINY: {
                returnText = "\u4e00\u80a1\u5f3a\u70c8\u7684\u6696\u6d41\u5728[npc.namePos]\u7684[npc.clit]\u4e0a\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49[npc.she]\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u6574\u6839\u4e0a\u5c31\u51fa\u73b0\u4e86\u4e00\u5927\u7247[style.boldGrow(\u660e\u663e\u7684\u9752\u7b4b)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u73b0\u5728\u5e03\u6ee1\u9752\u7b4b\uff01)]";
                break;
            }
            case OVIPOSITOR: {
                returnText = "\u4e00\u79cd\u5947\u602a\u7684\u523a\u75db\u611f\u5728[npc.namePos]\u7684\u6574\u6839[npc.clit]\u4e0a\u6563\u64ad\uff0c[npc.she]\u611f\u53d7\u5230\u9634\u8482\u6b63\u5728\u53d8\u6210[style.boldGrow(\u4ea7\u5375\u5668)]\uff0c\u4e00\u58f0[npc.a_moan+]\u8131\u53e3\u800c\u51fa\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u73b0\u5728\u80fd\u4ea7\u5375\u4e86\uff01)]<br/><i>(\u82e5\u8981\u5177\u5907\u5b8c\u6574\u529f\u80fd\uff0c[npc.name]\u9700\u8981\u5728\u4ea7\u5375\u524d\u4f7f\u5375\u53d7\u7cbe\u3002\u5375\u65e0\u6cd5\u4ea7\u5728\u5df2\u7ecf\u6000\u5b55\u7684\u5bf9\u8c61\u7684\u9634\u9053\u4e2d\u3002)</i>";
            }
        }
        if (returnText.isEmpty()) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        return UtilText.parse(owner, "<p>" + returnText + (String)removedText + "</p>", new ParserTag[0]);
    }

    public String removeClitorisModifier(GameCharacter owner, PenetrationModifier modifier) {
        if (!this.hasClitorisModifier(modifier)) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        this.clitModifiers.remove((Object)modifier);
        switch (modifier) {
            case RIBBED: {
                if (owner.isPlayer()) {
                    return "<p>\u4f60\u611f\u5230\u4e00\u9635\u8212\u7f13\u7684\u51c9\u723d\u611f\u4f20\u904d\u4e86[pc.clit]\uff0c\u6ca1\u7b49\u4f60\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u8089\u8d28\u7684\u786c\u8d28\u7a81\u8d77\u7a81\u7136[style.boldShrink(\u6d88\u5931\u4e86)]\u3002<br/>[style.boldSex(\u4f60\u7684[pc.clit]\u4e0d\u518d\u6709\u87ba\u7eb9\u4e86\uff01)]</p>";
                }
                return "<p>\u4e00\u80a1\u8212\u7f13\u7684\u51c9\u723d\u611f\u5728[npc.namePos]\u7684[npc.clit]\u4e0a\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49[npc.she]\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u8089\u8d28\u7684\u786c\u8d28\u7a81\u8d77\u7a81\u7136[style.boldShrink(\u6d88\u5931\u4e86)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u4e0d\u518d\u6709\u87ba\u7eb9\u4e86\uff01)]</p>";
            }
            case TENTACLED: {
                if (owner.isPlayer()) {
                    return "<p>\u4f60\u611f\u5230\u4e00\u9635\u8212\u7f13\u7684\u51c9\u723d\u611f\u5728[pc.clit]\u4e0a\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49\u4f60\u6709\u6240\u53cd\u5e94\uff0c\u626d\u52a8\u7684\u7ec6\u5c0f\u89e6\u624b[style.boldShrink(\u6d88\u5931\u4e86)]\u3002<br/>[style.boldSex(\u4f60\u7684[pc.clit]\u4e0d\u518d\u8986\u76d6\u7ec6\u5c0f\u7684\u89e6\u624b\u4e86\uff01)]</p>";
                }
                return "<p>\u4e00\u80a1\u8212\u7f13\u7684\u51c9\u723d\u611f\u5728[npc.namePos]\u7684[npc.clit]\u4e0a\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49[npc.she]\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u626d\u52a8\u7684\u7ec6\u5c0f\u89e6\u624b\u4fbf[style.boldShrink(\u6d88\u5931\u4e86)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u4e0d\u518d\u8986\u76d6\u7ec6\u5c0f\u7684\u89e6\u624b\u4e86\uff01)]</p>";
            }
            case BARBED: {
                if (owner.isPlayer()) {
                    return "<p>\u4f60\u611f\u5230\u4e00\u9635\u8212\u7f13\u7684\u51c9\u723d\u611f\u5728[pc.clit]\u4e0a\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49\u4f60\u6709\u6240\u53cd\u5e94\uff0c\u5c0f\u5c0f\u7684\u8089\u8d28\u5012\u523a\u4fbf[style.boldShrink(\u6d88\u5931\u4e86)]\u3002<br/>[style.boldSex(\u4f60\u7684[pc.clit]\u4e0d\u518d\u6709\u5012\u523a\u4e86\uff01)]</p>";
                }
                return "<p>\u4e00\u80a1\u8212\u7f13\u7684\u51c9\u723d\u611f\u5728[npc.namePos]\u7684[npc.clit]\u4e0a\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49[npc.she]\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u5c0f\u5c0f\u7684\u8089\u8d28\u5012\u523a\u4fbf[style.boldShrink(\u6d88\u5931\u4e86)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u4e0d\u518d\u6709\u5012\u523a\u4e86\uff01)]</p>";
            }
            case FLARED: {
                if (owner.isPlayer()) {
                    return "<p>\u4f60\u611f\u5230\u4e00\u9635\u8212\u7f13\u7684\u51c9\u723d\u611f\u5728[pc.clit]\u7684\u5c16\u7aef\u4e0a\u6d6e\u73b0\uff0c\u6ca1\u7b49\u4f60\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u5e73\u5934\u7684\u9634\u8482\u4fbf[style.boldShrink(\u7f29\u4e86\u4e0b\u53bb)]\uff0c\u8ba9\u4f60\u7684\u9634\u8482\u770b\u8d77\u6765\u50cf\u4e00\u4e2a\u4eba\u7c7b\u7684\u9634\u8482\u3002<br/>[style.boldSex(\u4f60\u7684[pc.clit]\u4e0d\u518d\u6709\u7740\u5bbd\u5927\u7684\u5e73\u5934\uff01)]</p>";
                }
                return "<p>\u4e00\u80a1\u8212\u7f13\u7684\u51c9\u723d\u611f\u5728[npc.namePos]\u7684[npc.clit]\u5c16\u7aef\u4e0a\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49[npc.she]\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u5e73\u5934\u7684\u9634\u8482\u4fbf[style.boldShrink(\u7f29\u5c0f\u4e86)]\uff0c\u8ba9[npc.her]\u7684\u9634\u8482\u770b\u8d77\u6765\u50cf\u666e\u901a\u7684\u4eba\u7c7b\u9634\u8482\u3002<br/>[style.boldSex([npc.NamePos]\u7684[pc.clit]\u4e0d\u518d\u6709\u7740\u5bbd\u5927\u7684\u5e73\u5934\uff01)]</p>";
            }
            case BLUNT: {
                if (owner.isPlayer()) {
                    return "<p>\u4f60\u611f\u5230\u4e00\u9635\u8212\u7f13\u7684\u51c9\u723d\u611f\u5728[pc.clit]\u7684\u5c16\u7aef\u4e0a\u6d6e\u73b0\uff0c\u6ca1\u7b49\u4f60\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u5706\u5934\u7684\u9634\u8482[style.boldShrink(\u7f29\u5c0f\u4e86)]\uff0c\u8ba9\u4f60\u7684\u9634\u8482\u770b\u8d77\u6765\u50cf\u666e\u901a\u7684\u4eba\u7c7b\u9634\u8482\u3002<br/>[style.boldSex(\u4f60\u7684[pc.clit]\u4e0d\u518d\u6709\u7740\u5706\u5934\uff01)]</p>";
                }
                return "<p>\u4e00\u80a1\u8212\u7f13\u7684\u51c9\u723d\u611f\u5728[npc.namePos]\u7684[npc.clit]\u5c16\u7aef\u4e0a\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49[npc.she]\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u5706\u5934\u7684\u9634\u8482\u4fbf[style.boldShrink(\u7f29\u5c0f\u4e86)]\u3002\u8ba9[npc.her]\u7684\u9634\u8482\u770b\u8d77\u6765\u50cf\u666e\u901a\u7684\u4eba\u7c7b\u9634\u8482\u3002<br/>[style.boldSex([npc.NamePos]\u7684[pc.clit]\u4e0d\u518d\u6709\u7740\u5706\u5934\uff01)]</p>";
            }
            case KNOTTED: {
                if (owner.isPlayer()) {
                    return "<p>\u4f60\u611f\u5230\u4e00\u9635\u8212\u7f13\u7684\u51c9\u723d\u611f\u5728[pc.clit]\u7684\u5e95\u7aef\u4e0a\u6d6e\u73b0\uff0c\u6ca1\u7b49\u4f60\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u80a5\u539a\u7684\u7ed3[style.boldShrink(\u7f29\u5c0f\u4e86)]\u5e76\u6d88\u5931\u4e86\u3002<br/>[style.boldSex(\u4f60\u7684[pc.clit]\u4e0d\u518d\u6709\u8089\u7ed3\u4e86\uff01)]</p>";
                }
                return "<p>\u4e00\u9635\u8212\u7f13\u7684\u51c9\u723d\u611f\u5728[npc.namePos]\u7684[pc.clit]\u5e95\u7aef\u4e0a\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49[npc.she]\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u80a5\u539a\u7684\u7ed3\u4fbf[style.boldShrink(\u7f29\u5c0f\u4e86)]\u5e76\u6d88\u5931\u4e86\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u4e0d\u518d\u6709\u8089\u7ed3\u4e86\uff01)]</p>";
            }
            case PREHENSILE: {
                if (owner.isPlayer()) {
                    return "<p>\u4f60\u611f\u5230\u4e00\u9635\u5947\u602a\u7684\u523a\u75db\u611f\u5728\u6574\u6839[pc.clit]\u4e0a\u6563\u64ad\uff0c\u4f60\u5ffd\u7136\u610f\u8bc6\u5230\u9634\u8482\u6b63\u5728\u53d8\u5f97[style.boldShrink(\u4e0d\u518d\u7075\u6d3b\u53ef\u63a7)]\u3002<br/>[style.boldSex(\u4f60\u7684[pc.clit]\u4e0d\u518d\u7075\u6d3b\u53ef\u63a7\uff01)]</p>";
                }
                return "<p>\u4e00\u79cd\u5947\u602a\u7684\u523a\u75db\u611f\u5728[npc.namePos]\u7684\u6574\u6839[npc.clit]\u4e0a\u6563\u64ad\uff0c[npc.she]\u5ffd\u7136\u610f\u8bc6\u5230\u9634\u8482\u6b63\u5728\u53d8\u5f97[style.boldShrink(\u4e0d\u518d\u7075\u6d3b\u53ef\u63a7)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u4e0d\u518d\u7075\u6d3b\u53ef\u63a7\uff01)]</p>";
            }
            case SHEATHED: {
                if (owner.isPlayer()) {
                    return "<p>\u4f60\u611f\u5230\u4e00\u9635\u8212\u7f13\u7684\u51c9\u723d\u611f\u5728[pc.clit]\u7684\u5e95\u7aef\u4e0a\u6d6e\u73b0\uff0c\u6ca1\u7b49\u4f60\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u9634\u8482\u9798\u4fbf[style.boldShrink(\u6d88\u5931\u4e86)]\u3002<br/>[style.boldSex(\u4f60\u7684[pc.clit]\u4e0d\u518d\u6709\u9634\u8482\u9798\u4e86\uff01)]</p>";
                }
                return "<p>\u4e00\u9635\u8212\u7f13\u7684\u51c9\u723d\u611f\u5728[npc.namePos]\u7684[pc.clit]\u5e95\u7aef\u4e0a\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49[npc.she]\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u9634\u8482\u9798\u4fbf[style.boldShrink(\u6d88\u5931\u4e86)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u4e0d\u518d\u6709\u9634\u8482\u9798\u4e86\uff01)]</p>";
            }
            case TAPERED: {
                if (owner.isPlayer()) {
                    return "<p>\u4f60\u611f\u5230\u4e00\u80a1\u5f3a\u70c8\u7684\u6696\u6d41\u5728[pc.clit]\u4e0a\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49\u4f60\u6709\u6240\u53cd\u5e94\uff0c\u8089\u67f1\u7a81\u7136[style.boldShrink(\u53d8\u5927\u4e86)]\u3002<br/>[style.boldSex(\u4f60\u7684[pc.clit]\u4e0d\u518d\u662f\u9525\u5f62\u7684\u4e86\uff01)]</p>";
                }
                return "<p>\u4e00\u80a1\u5f3a\u70c8\u7684\u6696\u6d41\u5728[npc.namePos]\u7684[npc.clit]\u4e0a\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49[npc.she]\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u8089\u67f1\u7a81\u7136[style.boldShrink(\u53d8\u5927\u4e86)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u4e0d\u518d\u662f\u9525\u5f62\u7684\uff01)]</p>";
            }
            case VEINY: {
                if (owner.isPlayer()) {
                    return "<p>\u4f60\u611f\u5230\u4e00\u80a1\u5f3a\u70c8\u7684\u6696\u6d41\u5728[pc.clit]\u4e0a\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49\u4f60\u6709\u6240\u53cd\u5e94\uff0c\u660e\u663e\u7684\u9752\u7b4b\u4fbf[style.boldShrink(\u6d88\u5931\u4e86)]\u3002<br/>[style.boldSex(\u4f60\u7684[pc.clit]\u4e0d\u518d\u5e03\u6ee1\u9752\u7b4b\u4e86\uff01)]</p>";
                }
                return "<p>\u4e00\u80a1\u5f3a\u70c8\u7684\u6696\u6d41\u5728[npc.namePos]\u7684[npc.clit]\u4e0a\u6d6e\u73b0\uff0c\u4f46\u6ca1\u7b49[npc.she]\u6709\u4efb\u4f55\u53cd\u5e94\uff0c\u660e\u663e\u7684\u9752\u7b4b\u4fbf[style.boldShrink(\u6d88\u5931\u4e86)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u4e0d\u518d\u5e03\u6ee1\u9752\u7b4b\u4e86\uff01)]</p>";
            }
            case OVIPOSITOR: {
                return "<p>\u4e00\u79cd\u5947\u602a\u7684\u523a\u75db\u611f\u5728[npc.namePos]\u7684\u6574\u6839[npc.clit]\u4e0a\u6563\u64ad\uff0c[npc.she]\u611f\u53d7\u5230\u9634\u8482\u6b63\u5728\u53d8\u6210\uff0c\u4e00\u58f0[npc.a_moan+]\u8131\u53e3\u800c\u51fa[style.boldShrink(\u4e0d\u518d\u62e5\u6709\u4ea7\u5375\u5668\u7684\u529f\u80fd)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.clit]\u4e0d\u518d\u662f\u4ea7\u5375\u5668\u4e86\uff01)]</p>";
            }
        }
        return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
    }

    public void resetClitorisModifiers() {
        this.clitModifiers = new HashSet<PenetrationModifier>();
    }

    @Override
    public boolean isFeral(GameCharacter owner) {
        if (owner == null) {
            return false;
        }
        return owner.isFeral() || owner.getLegConfiguration().getFeralParts().contains(Clitoris.class) && this.getType().getRace().isFeralPartsAvailable();
    }
}

