/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.BodyPartInterface;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractEarType;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.main.Main;

public class Ear
implements BodyPartInterface {
    protected AbstractEarType type;
    protected boolean pierced;

    public Ear(AbstractEarType type) {
        this.type = type;
        this.pierced = false;
    }

    public Ear(Ear earToCopy) {
        this.type = earToCopy.type;
        this.pierced = earToCopy.pierced;
    }

    @Override
    public AbstractEarType getType() {
        return this.type;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return this.type.getDeterminer(gc);
    }

    @Override
    public String getName(GameCharacter gc) {
        return this.type.getName(gc);
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.type.getNameSingular(gc);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.type.getNamePlural(gc);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        return this.type.getDescriptor(gc);
    }

    public String setType(GameCharacter owner, AbstractEarType type) {
        if (!Main.game.isStarted() || owner == null) {
            this.type = type;
            if (owner != null) {
                owner.postTransformationCalculation();
            }
            return "";
        }
        if (type.equals(this.getType())) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6709[npc.a_earRace]\u7684[npc.ears]\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<p>");
        if (owner.isArmMovementHindered()) {
            sb.append("[npc.namePos]\u7684[npc.ears]\u4e0d\u7531\u81ea\u4e3b\u5730\u62bd\u52a8\u4e0e\u7619\u75d2\u7740\uff0c\u5728\u611f\u89c9\u5230\u8f6c\u5316\u6b63\u5728\u53d1\u751f\u65f6\uff0c[npc.she]\u60ca\u8bb6\u5730\u5598\u4e86\u53e3\u6c14\u3002");
        } else {
            sb.append("[npc.namePos]\u7684[npc.ears]\u4e0d\u7531\u81ea\u4e3b\u5730\u62bd\u52a8\u4e0e\u7619\u75d2\u7740\uff0c\u5728\u611f\u89c9\u5230\u8f6c\u5316\u6b63\u5728\u53d1\u751f\u65f6\uff0c[npc.she]\u60ca\u8bb6\u5730\u5598\u4e86\u53e3\u6c14\uff0c\u4f38\u624b\u53bb\u63c9\u3002");
        }
        String s = UtilText.parse(owner, sb.toString(), new ParserTag[0]);
        sb.setLength(0);
        sb.append(s);
        this.type = type;
        sb.append(type.getTransformationDescription(owner));
        sb.append("</p>");
        return UtilText.parse(owner, sb.toString(), new ParserTag[0]) + "<p>" + owner.postTransformationCalculation() + "</p>";
    }

    public boolean isPierced() {
        return this.pierced;
    }

    public String setPierced(GameCharacter owner, boolean pierced) {
        if (this.pierced == pierced) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        this.pierced = pierced;
        if (pierced) {
            if (owner.isPlayer()) {
                return "<p>\u4f60\u7684[pc.ears]\u73b0\u5728\u5df2[style.boldGrow(\u7a7f\u5b54)]\uff01</p>";
            }
            return UtilText.parse(owner, "<p>[npc.namePos]\u7684[pc.ears]\u73b0\u5728\u5df2[style.boldGrow(\u7a7f\u5b54)]\uff01</p>", new ParserTag[0]);
        }
        AbstractClothing c = owner.getClothingInSlot(InventorySlot.PIERCING_EAR);
        String piercingUnequip = "";
        if (c != null) {
            owner.forceUnequipClothingIntoVoid(owner, c);
            piercingUnequip = owner.addClothing(c, false);
        }
        if (owner.isPlayer()) {
            return "<p>\u4f60\u7684[pc.ears][style.boldShrink(\u4e0d\u518d\u6709\u7a7f\u5b54\u4e86)]\uff01</p>" + piercingUnequip;
        }
        return UtilText.parse(owner, "<p>[npc.namePos]\u7684[pc.ears][style.boldShrink(\u4e0d\u518d\u6709\u7a7f\u5b54\u4e86)]\uff01</p>" + piercingUnequip, new ParserTag[0]);
    }

    @Override
    public boolean isFeral(GameCharacter owner) {
        if (owner == null) {
            return false;
        }
        return owner.isFeral() || owner.getLegConfiguration().getFeralParts().contains(Ear.class) && this.getType().getRace().isFeralPartsAvailable();
    }
}

