/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.FluidInterface;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractFluidType;
import com.lilithsthrone.game.character.body.types.FluidType;
import com.lilithsthrone.game.character.body.valueEnums.FluidFlavour;
import com.lilithsthrone.game.character.body.valueEnums.FluidModifier;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.utils.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FluidCum
implements FluidInterface {
    protected AbstractFluidType type;
    protected FluidFlavour flavour;
    protected Set<FluidModifier> fluidModifiers;
    protected List<ItemEffect> transformativeEffects;

    public FluidCum(AbstractFluidType type) {
        this.type = type;
        this.flavour = type.getFlavour();
        this.transformativeEffects = new ArrayList<ItemEffect>();
        this.fluidModifiers = new HashSet<FluidModifier>();
        this.fluidModifiers.addAll(type.getDefaultFluidModifiers());
    }

    public FluidCum(FluidCum cumToCopy) {
        this.type = cumToCopy.type;
        this.flavour = cumToCopy.flavour;
        this.fluidModifiers = new HashSet<FluidModifier>(cumToCopy.fluidModifiers);
        this.transformativeEffects = new ArrayList<ItemEffect>(cumToCopy.transformativeEffects);
    }

    public Element saveAsXML(String rootElementName, Element parentElement, Document doc) {
        Element element = doc.createElement(rootElementName);
        parentElement.appendChild(element);
        XMLUtil.addAttribute(doc, element, "type", FluidType.getIdFromFluidType(this.type));
        XMLUtil.addAttribute(doc, element, "flavour", this.flavour.toString());
        for (FluidModifier fm : this.getFluidModifiers()) {
            Element mod = doc.createElement("mod");
            mod.setTextContent(fm.toString());
            element.appendChild(mod);
        }
        return element;
    }

    public static FluidCum loadFromXML(String rootElementName, Element parentElement, Document doc) {
        return FluidCum.loadFromXML(rootElementName, parentElement, doc, null);
    }

    public static FluidCum loadFromXML(String rootElementName, Element parentElement, Document doc, AbstractFluidType baseType) {
        Element cum = (Element)parentElement.getElementsByTagName(rootElementName).item(0);
        AbstractFluidType fluidType = FluidType.CUM_HUMAN;
        if (baseType != null) {
            fluidType = baseType;
        } else {
            try {
                fluidType = FluidType.getFluidTypeFromId(cum.getAttribute("type"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FluidCum fluidCum = new FluidCum(fluidType);
        String flavourId = cum.getAttribute("flavour");
        fluidCum.flavour = flavourId.equalsIgnoreCase("SLIME") ? FluidFlavour.BUBBLEGUM : FluidFlavour.valueOf(flavourId);
        Element cumModifiers = (Element)cum.getElementsByTagName("cumModifiers").item(0);
        fluidCum.fluidModifiers.clear();
        if (cumModifiers != null) {
            if (cumModifiers != null) {
                Set<FluidModifier> fluidModifiers = fluidCum.fluidModifiers;
                Body.handleLoadingOfModifiers((Enum[])FluidModifier.values(), null, (Element)cumModifiers, fluidModifiers);
            }
        } else {
            NodeList mods = cum.getElementsByTagName("mod");
            for (int i = 0; i < mods.getLength(); ++i) {
                Element e = (Element)mods.item(i);
                fluidCum.fluidModifiers.add(FluidModifier.valueOf(e.getTextContent()));
            }
        }
        return fluidCum;
    }

    public boolean equals(Object o) {
        return o instanceof FluidCum && ((FluidCum)o).getType().equals(this.getType()) && ((FluidCum)o).getFlavour() == this.getFlavour() && ((FluidCum)o).getFluidModifiers().equals(this.getFluidModifiers()) && ((FluidCum)o).getTransformativeEffects().equals(this.getTransformativeEffects());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getType().hashCode();
        result = 31 * result + this.getFlavour().hashCode();
        result = 31 * result + this.getFluidModifiers().hashCode();
        result = 31 * result + this.getTransformativeEffects().hashCode();
        return result;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return this.type.getDeterminer(gc);
    }

    @Override
    public String getName(GameCharacter gc) {
        return this.getType().getName(false, gc);
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.getType().getNameSingular(gc);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.getType().getNamePlural(gc);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        String modifierDescriptor = "";
        if (!this.fluidModifiers.isEmpty()) {
            modifierDescriptor = new ArrayList<FluidModifier>(this.fluidModifiers).get(Util.random.nextInt(this.fluidModifiers.size())).getName();
        }
        return UtilText.returnStringAtRandom(gc.getAttributeValue(Attribute.VIRILITY) >= 20.0f ? "\u6709\u529b" : "", "\u6eda\u70eb", modifierDescriptor, this.flavour.getRandomFlavourDescriptor(), this.type.getDescriptor(gc));
    }

    @Override
    public AbstractFluidType getType() {
        return this.type;
    }

    public void setType(AbstractFluidType type) {
        this.type = type;
    }

    @Override
    public FluidFlavour getFlavour() {
        return this.flavour;
    }

    @Override
    public String setFlavour(GameCharacter owner, FluidFlavour flavour) {
        if (owner == null) {
            this.flavour = flavour;
            return "";
        }
        if (this.flavour == flavour || !owner.hasPenis()) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        this.flavour = flavour;
        return UtilText.parse(owner, "<p>\u4e00\u80a1\u8212\u7f13\u7684\u6696\u6d41\u5411\u4e0b\u8513\u5ef6\u5230[npc.namePos][npc.balls+]\u4e2d\uff0c\u4ee4[npc.herHim]\u4e0d\u7531\u81ea\u4e3b\u5730\u53d1\u51fa[npc.moan]\u58f0\u3002<br/>[npc.NamePos]\u7684[npc.cum]" + (flavour == FluidFlavour.FLAVOURLESS ? "\u73b0\u5728\u662f<b style='color:" + flavour.getColour().toWebHexString() + ";'>" + flavour.getName() + "</b>" : "\u73b0\u5728\u5c1d\u8d77\u6765\u50cf<b style='color:" + flavour.getColour().toWebHexString() + ";'>" + flavour.getName() + "</b>\u3002") + "</p>", new ParserTag[0]);
    }

    @Override
    public boolean hasFluidModifier(FluidModifier fluidModifier) {
        return this.fluidModifiers.contains((Object)fluidModifier);
    }

    @Override
    public String addFluidModifier(GameCharacter owner, FluidModifier fluidModifier) {
        if (owner == null && !this.fluidModifiers.contains((Object)fluidModifier)) {
            this.fluidModifiers.add(fluidModifier);
            return "";
        }
        if (this.fluidModifiers.contains((Object)fluidModifier) || !owner.hasPenis()) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        this.fluidModifiers.add(fluidModifier);
        switch (fluidModifier) {
            case ADDICTIVE: {
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5947\u5999\u800c\u8e81\u52a8\u7684\u70ed\u6d41\u6df1\u5165\u4e86[npc.namePos]\u7684[npc.balls]\uff0c\u8ba9[npc.herHim]\u4e0b\u610f\u8bc6\u5730\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.cum]\u73b0\u5728\u662f[style.boldGrow(\u6210\u763e\u7684)]\uff01</p>", new ParserTag[0]);
            }
            case ALCOHOLIC: {
                this.fluidModifiers.remove((Object)FluidModifier.ALCOHOLIC_WEAK);
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5947\u5999\u800c\u8212\u7f13\u7684\u6696\u6d41\u6df1\u5165\u5230[npc.namePos]\u7684[npc.balls]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.cum]\u73b0\u5728\u662f[style.boldGrow(\u542b\u9ad8\u5ea6\u9152\u7cbe\u7684)]\uff01</p>", new ParserTag[0]);
            }
            case ALCOHOLIC_WEAK: {
                this.fluidModifiers.remove((Object)FluidModifier.ALCOHOLIC);
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5947\u5999\u800c\u8212\u7f13\u7684\u6696\u6d41\u6df1\u5165\u5230[npc.namePos]\u7684[npc.balls]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.cum]\u73b0\u5728\u662f[style.boldGrow(\u542b\u9152\u7cbe\u7684)]\uff01</p>", new ParserTag[0]);
            }
            case BUBBLING: {
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u8f7b\u5fae\u7684\u6c14\u6ce1\u611f\u5728[npc.namePos]\u7684[npc.balls]\u4e2d\u51fa\u73b0\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.cum]\u73b0\u5728\u4f1a[style.boldGrow(\u8d77\u6ce1)]\uff01</p>", new ParserTag[0]);
            }
            case HALLUCINOGENIC: {
                return UtilText.parse(owner, "<p>\u4e00\u8fde\u4e32\u5947\u5999\u7684\u640f\u52a8\u611f\u76f4\u51b2[npc.namePos]\u7684[npc.balls]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.cum]\u73b0\u5728\u662f[style.boldGrow(\u81f4\u5e7b\u7684)]\uff01</p>", new ParserTag[0]);
            }
            case MINERAL_OIL: {
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u8212\u7f13\u7684\u6696\u6d41\u6c81\u5165[npc.namePos]\u7684[npc.balls]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.cum]\u73b0\u5728\u5145\u6ee1\u4e86[style.boldGrow(\u77ff\u7269\u6cb9)]\uff0c\u53ef\u4ee5\u878d\u5316\u907f\u5b55\u5957\u4e86\uff01</p>", new ParserTag[0]);
            }
            case MUSKY: {
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u7f13\u6162\u8815\u52a8\u7684\u6696\u610f\u4ece[npc.namePos]\u7684[npc.balls]\u4e2d\u5347\u817e\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.cum]\u73b0\u5728[style.boldGrow(\u5145\u6ee1\u4e86\u6deb\u5473)]\uff01</p>", new ParserTag[0]);
            }
            case SLIMY: {
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5947\u5999\u800c\u8212\u7f13\u7684\u6696\u6d41\u6c81\u5165[npc.namePos]\u7684[npc.balls]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.cum]\u73b0\u5728\u662f[style.boldGrow(\u7c98\u6ed1\u7684)]\uff01</p>", new ParserTag[0]);
            }
            case STICKY: {
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u539a\u91cd\u7684\u6696\u6d41\u6d41\u5165[npc.namePos]\u7684[npc.balls]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.cum]\u73b0\u5728\u662f[style.boldGrow(\u9ecf\u7cca\u7cca\u7684)]\uff01</p>", new ParserTag[0]);
            }
            case VISCOUS: {
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5f3a\u70c8\u7684\u70ed\u6d41\u7f13\u7f13\u5728[npc.namePos]\u7684[npc.balls]\u4e2d\u5347\u817e\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.cum]\u73b0\u5728\u662f[style.boldGrow(\u7c98\u7a20\u7684)]\uff01</p>", new ParserTag[0]);
            }
        }
        return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
    }

    @Override
    public String removeFluidModifier(GameCharacter owner, FluidModifier fluidModifier) {
        if (owner == null) {
            this.fluidModifiers.remove((Object)fluidModifier);
            return "";
        }
        if (!this.fluidModifiers.contains((Object)fluidModifier) || !owner.hasPenis()) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        this.fluidModifiers.remove((Object)fluidModifier);
        switch (fluidModifier) {
            case ADDICTIVE: {
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5fae\u51c9\u611f\u5728[npc.namePos]\u7684[npc.balls]\u4e2d\u8513\u5ef6\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.cum]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u6709\u6210\u763e\u6027)]\uff01</p>", new ParserTag[0]);
            }
            case ALCOHOLIC: 
            case ALCOHOLIC_WEAK: {
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5fae\u51c9\u611f\u5728[npc.namePos]\u7684[npc.balls]\u4e2d\u8513\u5ef6\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.cum]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u542b\u9152\u7cbe)]\uff01</p>", new ParserTag[0]);
            }
            case BUBBLING: {
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5e73\u9759\u611f\u5728[npc.namePos]\u7684[npc.balls]\u4e2d\u51fa\u73b0\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.cum]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u8d77\u6ce1)]\uff01</p>", new ParserTag[0]);
            }
            case HALLUCINOGENIC: {
                return UtilText.parse(owner, "<p>\u4e00\u8fde\u4e32\u8212\u7f13\u7684\u6d6a\u6f6e\u6d8c\u4e0a[npc.namePos]\u7684[npc.balls]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.cum]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u6709\u81f4\u5e7b\u6027)]\uff01</p>", new ParserTag[0]);
            }
            case MUSKY: {
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5fae\u51c9\u611f\u5728[npc.namePos]\u7684[npc.balls]\u4e2d\u5347\u817e\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.cum]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u5145\u6ee1\u6deb\u5473)]\uff01</p>", new ParserTag[0]);
            }
            case SLIMY: {
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u8212\u7f13\u7684\u51c9\u723d\u611f\u6d41\u5165[npc.namePos]\u7684[npc.balls]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.cum]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u7c98\u6ed1)]\uff01</p>", new ParserTag[0]);
            }
            case STICKY: {
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5fae\u6696\u6c81\u5165\u4e86[npc.namePos]\u7684[npc.balls]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.cum]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u9ecf\u7cca\u7cca)]\uff01</p>", new ParserTag[0]);
            }
            case VISCOUS: {
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5fae\u51c9\u611f\u5728[npc.namePos]\u7684[npc.balls]\u4e2d\u5347\u817e\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.cum]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u7c98\u7a20)]\uff01</p>", new ParserTag[0]);
            }
            case MINERAL_OIL: {
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u77ed\u6682\u7684\u91ca\u653e\u611f\u6d41\u5165[npc.namePos]\u7684[npc.balls]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.cum]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u5982\u77ff\u7269\u6cb9\u4e00\u822c)]\uff01</p>", new ParserTag[0]);
            }
        }
        return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
    }

    @Override
    public List<ItemEffect> getTransformativeEffects() {
        return this.transformativeEffects;
    }

    @Override
    public void addTransformativeEffect(ItemEffect ie) {
        this.transformativeEffects.add(ie);
    }

    @Override
    public Set<FluidModifier> getFluidModifiers() {
        return this.fluidModifiers;
    }

    public void clearFluidModifiers() {
        this.fluidModifiers.clear();
    }

    @Override
    public float getValuePerMl() {
        return 0.1f * this.type.getValueModifier();
    }

    @Override
    public boolean isFeral(GameCharacter owner) {
        if (owner == null) {
            return false;
        }
        return owner.isFeral() || owner.getLegConfiguration().getFeralParts().contains(FluidCum.class) && this.getType().getRace().isFeralPartsAvailable();
    }
}

