/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.BodyPartInterface;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractHairType;
import com.lilithsthrone.game.character.body.valueEnums.HairLength;
import com.lilithsthrone.game.character.body.valueEnums.HairStyle;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Units;

public class Hair
implements BodyPartInterface {
    protected AbstractHairType type;
    protected int length;
    protected HairStyle style;
    protected boolean neckFluff;

    public Hair(AbstractHairType type, int length, HairStyle style, RaceStage ownerRaceStage) {
        this.type = type;
        this.length = length;
        this.style = style;
        this.neckFluff = false;
        if ((!type.isNeckFluffRequiresGreater() || ownerRaceStage != RaceStage.GREATER) && Math.random() < type.getNeckFluffChance()) {
            this.neckFluff = true;
        }
    }

    public Hair(Hair hairToCopy) {
        this.type = hairToCopy.type;
        this.length = hairToCopy.length;
        this.style = hairToCopy.style;
        this.neckFluff = hairToCopy.neckFluff;
    }

    @Override
    public AbstractHairType getType() {
        return this.type;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return this.type.getDeterminer(gc);
    }

    @Override
    public String getName(GameCharacter gc) {
        return this.type.getName(gc);
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.type.getNameSingular(gc);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.type.getNamePlural(gc);
    }

    @Override
    public String getDescriptor(GameCharacter owner) {
        return this.type.getDescriptor(owner);
    }

    public String setType(GameCharacter owner, AbstractHairType type) {
        if (!Main.game.isStarted() || owner == null) {
            this.type = type;
            if (owner != null) {
                owner.postTransformationCalculation();
            }
            return "";
        }
        if (type == this.getType()) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6709[npc.a_hairRace]\u7684[npc.hair(true)]\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<p>[npc.NamePos]\u5934\u76ae\u523a\u75db\u53d1\u75d2\uff0c[npc.she]\u6478\u4e86\u6478\u5934\u9876\uff0c\u611f\u89c9\u5230[npc.hair(true)]\u6b63\u5f00\u59cb\u8f6c\u53d8\u3002");
        String s = UtilText.parse(owner, sb.toString(), new ParserTag[0]);
        sb.setLength(0);
        sb.append(s);
        this.type = type;
        sb.append(type.getTransformationDescription(owner));
        sb.append("</p>");
        return UtilText.parse(owner, sb.toString(), new ParserTag[0]) + "<p>" + owner.postTransformationCalculation() + "</p>";
    }

    public HairLength getLength() {
        return HairLength.getHairLengthFromInt(this.length);
    }

    public int getRawLengthValue() {
        return this.length;
    }

    public String setLength(GameCharacter owner, int length) {
        int oldLength = this.length;
        this.length = Math.max(0, Math.min(length, HairLength.SEVEN_TO_FLOOR.getMaximumValue()));
        int sizeChange = this.length - oldLength;
        if (owner == null) {
            return "";
        }
        Object styleChange = "";
        if (this.length < owner.getHairStyle().getMinimumLengthRequired()) {
            styleChange = "<p>[npc.Her] [npc.hair(true)] " + (owner.getHairType().isDefaultPlural(owner) ? "are" : "is") + " too short for [npc.her] current hair style!</p>" + owner.setHairStyle(HairStyle.NONE);
        }
        if (sizeChange == 0) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.namePos][npc.hair(true)]\u7684\u957f\u5ea6\u6ca1\u6709\u6539\u53d8\u2026\u2026)]</p>", new ParserTag[0]);
        }
        if (sizeChange < 0) {
            Object hairChangedText = this.length == 0 && owner.isFaceBaldnessNatural() ? "\u6ca1\u6709[npc.hair(true)]" : "[npc.hairLength]\uff0c" + Units.size(this.length, Units.UnitType.LONG_SINGULAR) + "[npc.hair(true)]";
            return UtilText.parse(owner, "<p>[npc.Name]\u4e0b\u610f\u8bc6\u5730\u53eb\u51fa\u58f0\uff0c\u4f38\u624b\u53bb\u6478\u5934\u9876\uff0c\u611f\u89c9\u5230[npc.her]\u7684[npc.hair(true)][style.boldShrink(\u53d8\u5f97\u66f4\u77ed)]\u4e86\u3002<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric(" + (String)hairChangedText + ")]\uff01</p>" + (String)styleChange, new ParserTag[0]);
        }
        return UtilText.parse(owner, "<p>[npc.Name]\u4e0b\u610f\u8bc6\u5730\u53eb\u51fa\u58f0\uff0c\u4f38\u624b\u53bb\u6478\u5934\u9876\uff0c\u611f\u89c9\u5230[npc.her]\u7684[npc.hair(true)][style.boldShrink(\u53d8\u5f97\u66f4\u957f)]\u4e86\u3002<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric([npc.hairLength]\uff0c" + Units.size(this.length, Units.UnitType.LONG_SINGULAR) + "[npc.hair(true)])]\uff01</p>" + (String)styleChange, new ParserTag[0]);
    }

    public HairStyle getStyle() {
        return this.style;
    }

    public String setStyle(GameCharacter owner, HairStyle style) {
        this.style = style;
        if (owner == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<p>");
        sb.append("[npc.NamePos][npc.hair(true)] \u73b0\u5728\u662f");
        switch (style) {
            case BRAIDED: {
                sb.append("\u7f16\u6210\u4e86\u8fab\u5b50\u3002");
                break;
            }
            case CURLY: {
                sb.append("\u5377\u66f2\u7684\u3002");
                break;
            }
            case LOOSE: {
                sb.append("\u677e\u6563\u5f00\u7684\u3002");
                break;
            }
            case NONE: {
                sb.append("\u6ca1\u7406\u7279\u5b9a\u53d1\u578b\u7684\uff0c\u4e14\u4f1a\u7ee7\u7eed\u4fdd\u6301\u7740\u81ea\u7136\u5f62\u6001\u3002");
                break;
            }
            case PONYTAIL: {
                sb.append("\u624e\u6210\u4e86\u9a6c\u5c3e\u3002");
                break;
            }
            case STRAIGHT: {
                sb.append("\u62c9\u76f4\u4e86\u7684\u3002");
                break;
            }
            case TWIN_TAILS: {
                sb.append("\u624e\u6210\u4e86\u53cc\u9a6c\u5c3e\u3002");
                break;
            }
            case WAVY: {
                sb.append("\u5448\u73b0\u6ce2\u6d6a\u5f62\u7684\u3002");
                break;
            }
            case MOHAWK: {
                sb.append("\u7406\u6210\u4e86\u83ab\u970d\u514b\u53d1\u578b\u3002");
                break;
            }
            case AFRO: {
                sb.append("\u7406\u6210\u4e86\u7206\u70b8\u5934\u3002");
                break;
            }
            case SIDECUT: {
                sb.append("\u7406\u6210\u4e86\u4fa7\u5243\u3002");
                break;
            }
            case BOB_CUT: {
                sb.append("\u7406\u6210\u4e86\u6ce2\u6ce2\u5934\u3002");
                break;
            }
            case PIXIE: {
                sb.append("\u7406\u6210\u4e86\u7cbe\u7075\u77ed\u53d1\u3002");
                break;
            }
            case SLICKED_BACK: {
                sb.append("\u68b3\u6210\u4e86\u80cc\u5934\u3002");
                break;
            }
            case MESSY: {
                sb.append("\u5341\u5206\u51cc\u4e71\uff0c\u6ca1\u4ec0\u4e48\u9020\u578b\u3002");
                break;
            }
            case HIME_CUT: {
                sb.append("\u62c9\u76f4\u540e\uff0c\u7406\u6210\u4e86\u59ec\u53d1\u5f0f\u3002");
                break;
            }
            case CHONMAGE: {
                sb.append("\u62c9\u76f4\u540e\u6d82\u6cb9\u4fdd\u517b\uff0c\u624e\u6210\u4e86\u6708\u4ee3\u5934\u3002");
                break;
            }
            case DREADLOCKS: {
                sb.append("\u7f16\u6210\u4e86\u810f\u8fab\u3002");
                break;
            }
            case TOPKNOT: {
                sb.append("\u675f\u8d77\uff0c\u62e2\u6210\u9876\u9afb\u3002");
                break;
            }
            case BIRD_CAGE: {
                sb.append("\u7f16\u6210\u4e86\u4f18\u7f8e\u7684\u9e1f\u7b3c\u5f62\u3002");
                break;
            }
            case TWIN_BRAIDS: {
                sb.append("\u7f16\u6210\u4e86\u53cc\u9ebb\u82b1\u8fab\u3002");
                break;
            }
            case DRILLS: {
                sb.append("\u7406\u6210\u4e86\u516c\u4e3b\u5377\u53d1\u3002");
                break;
            }
            case LOW_PONYTAIL: {
                sb.append("\u624e\u6210\u4e86\u4f4e\u9a6c\u5c3e\u3002");
                break;
            }
            case CROWN_BRAID: {
                sb.append("\u7f16\u6210\u4e86\u6cd5\u5f0f\u51a0\u7f16\u53d1\u3002");
                break;
            }
            case BUN: {
                sb.append("\u7f16\u6210\u4e86\u4e38\u5b50\u5934\u3002");
                break;
            }
            case CHIGNON: {
                sb.append("\u7ed1\u8d77\uff0c\u76d8\u6210\u4e86\u53d1\u9afb\u3002");
                break;
            }
            case SIDE_BRAIDS: {
                sb.append("\u7f16\u6210\u9ebb\u82b1\u8fab\u540e\u4fa7\u642d\u5728\u8138\u65c1\u3002");
                break;
            }
            case SIDE_PARTED: {
                sb.append("\u7406\u6210\u4e86\u4fa7\u5206\u53d1\u578b\u3002");
            }
        }
        sb.append("</p>");
        return UtilText.parse(owner, sb.toString(), new ParserTag[0]);
    }

    public boolean isNeckFluff() {
        return this.neckFluff;
    }

    public String setNeckFluff(GameCharacter owner, boolean neckFluff) {
        if (owner != null && this.neckFluff == neckFluff) {
            if (this.neckFluff) {
                return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6709\u9888\u90e8[npc.hair(true)]\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
            }
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6ca1\u6709\u9888\u90e8[npc.hair(true)]\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        this.neckFluff = neckFluff;
        if (owner == null) {
            return "";
        }
        if (neckFluff) {
            return UtilText.parse(owner, "<p>[npc.Name]\u53d1\u51fa\u4e00\u58f0\u60ca\u547c\uff0c\u611f\u89c9\u5230\u60ca\u4eba\u8302\u5bc6\u7684[npc.hair(true)][style.boldGrow(\u4ece\u8116\u5b50\u4e0e\u4e0a\u80f8\u56f4\u5904\u957f\u4e86\u51fa\u6765)]\uff01</p>", new ParserTag[0]);
        }
        return UtilText.parse(owner, "<p>[npc.Name]\u53d1\u51fa\u4e00\u58f0\u60ca\u547c\uff0c\u611f\u89c9\u5230\u8116\u9888\u5468\u56f4\u7684[npc.hair(true)][style.boldGrow(\u840e\u7f29\u6d88\u5931\u4e86)]\uff01</p>", new ParserTag[0]);
    }

    @Override
    public boolean isFeral(GameCharacter owner) {
        if (owner == null) {
            return false;
        }
        return owner.isFeral() || owner.getLegConfiguration().getFeralParts().contains(Hair.class) && this.getType().getRace().isFeralPartsAvailable();
    }
}

