/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.BodyPartInterface;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractLegType;
import com.lilithsthrone.game.character.body.valueEnums.FootStructure;
import com.lilithsthrone.game.character.body.valueEnums.LegConfiguration;
import com.lilithsthrone.game.character.body.valueEnums.PenetrationGirth;
import com.lilithsthrone.game.character.race.RacialBody;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.util.ArrayList;

public class Leg
implements BodyPartInterface {
    public static final float LENGTH_PERCENTAGE_MIN_FERAL = 0.05f;
    public static final float LENGTH_PERCENTAGE_MIN = 2.0f;
    public static final float LENGTH_PERCENTAGE_MAX = 10.0f;
    protected AbstractLegType type;
    protected FootStructure footStructure;
    protected LegConfiguration legConfiguration;
    protected int girth;
    protected float lengthAsPercentageOfHeight;

    public Leg(AbstractLegType type, LegConfiguration legConfiguration) {
        this.type = type;
        this.legConfiguration = legConfiguration;
        this.footStructure = type.getDefaultFootStructure(legConfiguration);
        this.girth = PenetrationGirth.THREE_AVERAGE.getValue();
        this.lengthAsPercentageOfHeight = LegConfiguration.getDefaultSerpentTailLengthMultiplier();
    }

    public Leg(Leg legToCopy) {
        this.type = legToCopy.type;
        this.legConfiguration = legToCopy.legConfiguration;
        this.footStructure = legToCopy.footStructure;
        this.girth = legToCopy.girth;
        this.lengthAsPercentageOfHeight = legToCopy.lengthAsPercentageOfHeight;
    }

    @Override
    public AbstractLegType getType() {
        return this.type;
    }

    public FootStructure getFootStructure() {
        return this.footStructure;
    }

    public String setFootStructure(GameCharacter owner, FootStructure footStructure) {
        if (owner == null || footStructure == FootStructure.TENTACLED) {
            this.footStructure = footStructure;
            return "";
        }
        if (this.getFootStructure() == footStructure) {
            return UtilText.parse(owner, "<p>[style.colourDisabled(\u7531\u4e8e[npc.namePos]\u7684[npc.feet]\u5df2\u7ecf\u662f[npc.footStructure]\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        if (!this.type.getFootType().getPermittedFootStructures(owner.getLegConfiguration()).contains((Object)footStructure)) {
            return UtilText.parse(owner, "<p>[style.colourDisabled(\u7531\u4e8e[npc.namePos]\u7684[npc.feet]\u65e0\u6cd5\u88ab\u8f6c\u5316\u4e3a" + footStructure.getName() + "\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        this.footStructure = footStructure;
        StringBuilder sb = new StringBuilder();
        sb.append("<p>[npc.Name]\u5ffd\u7136\u611f\u5230[npc.legs]\u548c[npc.feet]\u5904\u8ff8\u53d1\u51fa\u4e00\u9635\u5f3a\u70c8\u7684\u70ed\u91cf\uff0c\u4e0d\u7981\u9707\u60ca\u5730\u5012\u5438\u4e00\u53e3\u51c9\u6c14\u3002\u968f\u7740\u811a\u90e8\u7ed3\u6784\u7684\u53d8\u5316\uff0c[npc.she]\u4e00\u4e2a\u8e09\u8dc4\uff0c\u5dee\u70b9\u5931\u53bb\u4e86\u5e73\u8861\u3002</br>");
        switch (footStructure) {
            case NONE: {
                sb.append("\u7247\u523b\u8fc7\u540e\uff0c[npc.sheIs]\u4fbf[style.boldTfGeneric(\u6ca1\u6709[npc.feet])]\u4e86\uff01");
                break;
            }
            case DIGITIGRADE: {
                sb.append("\u7247\u523b\u8fc7\u540e\uff0c[npc.sheIs]\u5f97\u5230\u4e86[style.boldTfGeneric(\u8dbe\u884c\u7684[npc.feet])]\uff0c\u8fd9\u610f\u5473\u7740[npc.she]\u73b0\u5728\u7528\u811a\u8dbe\u884c\u8d70\uff0c\u811a\u8ddf\u603b\u662f\u9ad8\u9ad8\u62ac\u8d77\u3002");
                break;
            }
            case PLANTIGRADE: {
                sb.append("\u7247\u523b\u8fc7\u540e\uff0c[npc.sheIs]\u5f97\u5230\u4e86[style.boldTfGeneric(\u8dd6\u884c\u7684[npc.feet])]\uff0c\u8fd9\u610f\u5473\u7740[npc.she]\u73b0\u5728\u7528\u811a\u638c\u5728\u5730\u9762\u4e0a\u884c\u8d70\u3002");
                break;
            }
            case UNGULIGRADE: {
                sb.append("\u7247\u523b\u8fc7\u540e\uff0c[npc.sheIs]\u5f97\u5230\u4e86[style.boldTfGeneric(\u8e44\u884c\u7684[npc.feet])]\uff0c\u8fd9\u610f\u5473\u7740[npc.she]\u73b0\u5728\u7528[npc.toes]\u884c\u8d70\uff0c\u800c\u811a\u7684\u5176\u4ed6\u90e8\u5206\u5219\u603b\u662f\u9ad8\u9ad8\u62ac\u8d77\u3002");
                break;
            }
            case ARACHNOID: {
                sb.append("\u7247\u523b\u8fc7\u540e\uff0c[npc.sheIs]\u5f97\u5230\u4e86[style.boldTfGeneric(\u86db\u5f62\u7684[npc.feet])]\uff0c\u8fd9\u610f\u5473\u7740[npc.she]\u73b0\u5728\u7528\u86db\u5f62\u7684\u8282\u80a2\u672b\u7aef\u884c\u8d70\u3002");
                break;
            }
        }
        return UtilText.parse(owner, sb.toString(), new ParserTag[0]) + "</p><p>" + owner.postTransformationCalculation() + "</p>";
    }

    public LegConfiguration getLegConfiguration() {
        return this.legConfiguration;
    }

    public void setLegConfigurationForced(AbstractLegType type, LegConfiguration legConfiguration) {
        this.type = type;
        this.footStructure = type.getDefaultFootStructure(legConfiguration);
        this.legConfiguration = legConfiguration;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return this.type.getDeterminer(gc);
    }

    @Override
    public String getName(GameCharacter gc) {
        return this.type.getName(gc);
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.type.getNameSingular(gc);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.type.getNamePlural(gc);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        ArrayList<String> descriptorList = new ArrayList<String>();
        descriptorList.add(this.type.getDescriptor(gc));
        descriptorList.add(this.type.getDescriptor(gc));
        descriptorList.add(Util.randomItemFrom(gc.getBodyShape().getLimbDescriptors()));
        return (String)Util.randomItemFrom(descriptorList);
    }

    public String setType(GameCharacter owner, AbstractLegType type) {
        if (!Main.game.isStarted() || owner == null) {
            this.type = type;
            this.footStructure = type.getDefaultFootStructure(this.getLegConfiguration());
            if (owner != null) {
                if (Main.game.isStarted() && !type.isLegConfigurationAvailable(this.getLegConfiguration())) {
                    this.getType().applyLegConfigurationTransformation(owner, RacialBody.valueOfRace(type.getRace()).getLegConfiguration(), true, true);
                }
                owner.postTransformationCalculation();
            } else if (Main.game.isStarted() && !type.isLegConfigurationAvailable(this.getLegConfiguration())) {
                System.err.println("Leg.setType() was passed a null owner, and the type '" + type.getTransformName() + "' requires conversion of LegConfiguration from '" + this.getLegConfiguration().getName() + "' to '" + RacialBody.valueOfRace(type.getRace()).getLegConfiguration().getName() + "'.");
                this.setLegConfigurationForced(type, RacialBody.valueOfRace(type.getRace()).getLegConfiguration());
            }
            return "";
        }
        if (type == this.getType()) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6709[npc.a_legRace]\u7684[npc.legs]\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<p>\u8f6c\u5316\u5f00\u59cb\u540e\uff0c[npc.NamePos]\u7684[npc.legs]\u6643\u52a8\u8d77\u6765\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u865a\u5f31\uff0c[npc.she]\u5dee\u70b9\u6ca1\u4fdd\u6301\u4f4f\u5e73\u8861\u3002");
        String s = UtilText.parse(owner, sb.toString(), new ParserTag[0]);
        sb.setLength(0);
        sb.append(s);
        this.type = type;
        this.footStructure = type.getDefaultFootStructure(this.getLegConfiguration());
        sb.append(type.getTransformationDescription(owner) + "</p>");
        owner.setTentacleType(type.getTentacleType());
        owner.setTentacleCount(type.getTentacleCount());
        if (!type.isLegsReplacedByTentacles() && type.getDefaultFootStructure(this.getLegConfiguration()) != FootStructure.NONE) {
            sb.append("<p>\u8f6c\u5316\u8ba9[npc.her][npc.feet]\u7684\u7ed3\u6784\u53d8\u4e3a\u4e86[style.boldTFGeneric(" + this.footStructure.getName() + ")]\uff01" + this.footStructure.getDescription() + "</p>");
        }
        if (!type.isLegConfigurationAvailable(this.getLegConfiguration())) {
            sb.append(this.getType().applyLegConfigurationTransformation(owner, type.getAllowedLegConfigurations().get(0), true, true));
        }
        return UtilText.parse(owner, sb.toString(), new ParserTag[0]) + "<p>" + owner.postTransformationCalculation() + "</p>";
    }

    @Override
    public boolean isFeral(GameCharacter owner) {
        if (owner == null) {
            return false;
        }
        return owner.isFeral() || owner.getLegConfiguration().getFeralParts().contains(Leg.class) && this.getType().getRace().isFeralPartsAvailable();
    }

    public float getLengthAsPercentageOfHeight() {
        return this.lengthAsPercentageOfHeight;
    }

    public String setLengthAsPercentageOfHeight(GameCharacter owner, float lengthAsPercentageOfHeight) {
        float percentageMinimum;
        if (owner == null) {
            this.lengthAsPercentageOfHeight = Math.max(0.05f, Math.min(lengthAsPercentageOfHeight, 10.0f));
            return "";
        }
        float lengthChange = 0.0f;
        float f = percentageMinimum = owner.isFeral() ? 0.05f : 2.0f;
        if (lengthAsPercentageOfHeight <= percentageMinimum) {
            if (this.lengthAsPercentageOfHeight != percentageMinimum) {
                lengthChange = percentageMinimum - this.lengthAsPercentageOfHeight;
                this.lengthAsPercentageOfHeight = percentageMinimum;
            }
        } else if (lengthAsPercentageOfHeight >= 10.0f) {
            if (this.lengthAsPercentageOfHeight != 10.0f) {
                lengthChange = 10.0f - this.lengthAsPercentageOfHeight;
                this.lengthAsPercentageOfHeight = 10.0f;
            }
        } else if (this.lengthAsPercentageOfHeight != lengthAsPercentageOfHeight) {
            lengthChange = lengthAsPercentageOfHeight - this.lengthAsPercentageOfHeight;
            this.lengthAsPercentageOfHeight = lengthAsPercentageOfHeight;
        }
        if (owner.getLegConfiguration() != LegConfiguration.TAIL_LONG) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled(\u7531\u4e8e[npc.name]\u6ca1\u6709" + String.valueOf((Object)LegConfiguration.TAIL_LONG) + "\u4e0b\u80a2\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        if (lengthChange == 0.0f) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.namePos][npc.tail]\u7684\u957f\u5ea6\u6ca1\u6709\u53d8\u5316\u2026\u2026)]</p>", new ParserTag[0]);
        }
        String heightPercentageDescription = "(\u957f\u5ea6\u4e3a\u8eab\u9ad8\u7684" + (int)(owner.getLegTailLengthAsPercentageOfHeight() * 100.0f) + "%)";
        if (lengthChange > 0.0f) {
            return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her][npc.tail+]\u91cc\u9010\u6e10\u5347\u8d77\u4e00\u80a1\u5f3a\u70c8\u7684\u640f\u52a8\u611f\uff0c\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684[npc.tail]\u7a81\u7136[style.boldGrow(\u4f38\u957f\u4e86)]\u3002<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric([npc.a_tailLength][npc.tail])]" + heightPercentageDescription + "\uff01</p>", new ParserTag[0]);
        }
        return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her][npc.tail+]\u91cc\u9010\u6e10\u5347\u8d77\u4e00\u80a1\u5f3a\u70c8\u7684\u640f\u52a8\u611f\uff0c\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684[npc.tail]\u7a81\u7136[style.boldShrink(\u7f29\u77ed\u4e86)]\u3002<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric([npc.a_tailLength][npc.tail])]" + heightPercentageDescription + "\uff01</p>", new ParserTag[0]);
    }

    public int getLength(GameCharacter owner) {
        return (int)((float)owner.getHeightValue() * this.getLengthAsPercentageOfHeight());
    }

    public int getLength(Body body) {
        return (int)((float)body.getHeightValue() * this.getLengthAsPercentageOfHeight());
    }

    public float getBaseDiameter(GameCharacter owner) {
        return this.getDiameter(owner, 0.0f);
    }

    public float getDiameter(GameCharacter owner, float atLength) {
        float waistToHeightRatio = owner.isFeral() ? 0.25f : 0.5f;
        float waistCircumference = (float)owner.getHeightValue() * waistToHeightRatio;
        float waistDiameter = (float)((double)waistCircumference / Math.PI);
        float baseDiameter = waistDiameter * (1.0f + owner.getLegTailGirth().getDiameterPercentageModifier());
        float lengthPercentage = Math.min(1.0f, atLength / (float)this.getLength(owner));
        float diameter = (1.0f - 0.95f * lengthPercentage) * baseDiameter;
        return diameter;
    }
}

