/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.BodyPartInterface;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractTentacleType;
import com.lilithsthrone.game.character.body.tags.BodyPartTag;
import com.lilithsthrone.game.character.body.types.TentacleType;
import com.lilithsthrone.game.character.body.valueEnums.PenetrationGirth;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Units;
import com.lilithsthrone.utils.Util;
import java.util.ArrayList;

public class Tentacle
implements BodyPartInterface {
    public static final int MAXIMUM_COUNT = 100;
    public static final float LENGTH_PERCENTAGE_MIN = 1.0f;
    public static final float LENGTH_PERCENTAGE_MAX = 5.0f;
    protected AbstractTentacleType type;
    protected int tentacleCount;
    protected int girth;
    protected float lengthAsPercentageOfHeight;

    public Tentacle(AbstractTentacleType type) {
        this.type = type;
        this.tentacleCount = 1;
        this.girth = type.getDefaultGirth();
        this.lengthAsPercentageOfHeight = type.getDefaultLengthAsPercentageOfHeight();
    }

    public Tentacle(Tentacle tentacleToCopy) {
        this.type = tentacleToCopy.type;
        this.tentacleCount = tentacleToCopy.tentacleCount;
        this.girth = tentacleToCopy.girth;
        this.lengthAsPercentageOfHeight = tentacleToCopy.lengthAsPercentageOfHeight;
    }

    @Override
    public AbstractTentacleType getType() {
        return this.type;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return this.type.getDeterminer(gc);
    }

    @Override
    public String getName(GameCharacter gc) {
        return this.type.getName(gc);
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.type.getNameSingular(gc);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.type.getNamePlural(gc);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        ArrayList<String> descriptors = new ArrayList<String>();
        descriptors.add(this.type.getDescriptor(gc));
        if (gc.getTentacleGirth() != PenetrationGirth.THREE_AVERAGE) {
            descriptors.add(gc.getTentacleGirth().getName());
        }
        return (String)Util.randomItemFrom(descriptors);
    }

    public String setType(GameCharacter owner, AbstractTentacleType type) {
        if (!Main.game.isStarted() || owner == null) {
            if (this.getLengthAsPercentageOfHeight() == this.getType().getDefaultLengthAsPercentageOfHeight()) {
                this.setLengthAsPercentageOfHeight(owner, type.getDefaultLengthAsPercentageOfHeight());
            }
            this.type = type;
            if (owner != null) {
                owner.postTransformationCalculation();
            }
            return "";
        }
        if (type == this.getType()) {
            if (type == TentacleType.NONE) {
                return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6ca1\u6709\u89e6\u624b\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
            }
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6709[npc.a_tentacleRace]\u7684[npc.tentacle]\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        StringBuilder sb = new StringBuilder();
        if (this.type == TentacleType.NONE) {
            sb.append("<p>[npc.Name]\u611f\u5230\u8170\u80cc\u95f4\u53d8\u5f97\u6eda\u70eb\u53c8\u654f\u611f\uff0c\u8fde\u5fd9\u6478\u4e86\u6478\uff0c\u8fd9\u624d\u53d1\u73b0\u6709\u4ec0\u4e48\u4e1c\u897f\u6b63\u4ece[npc.skin]\u4e4b\u4e0b\u751f\u957f\u51fa\u6765\u3002");
        } else {
            sb.append("<p>" + (owner.getTentacleCount() == 1 ? "[npc.Name]\u611f\u89c9[npc.tentacle]\u6e10\u6e10\u71e5\u70ed\u53d1\u75d2\u8d77\u6765\uff0c\u8fc7\u4e86\u4e00\u4f1a\u513f\u5c31\u5f00\u59cb\u4e86\u8f6c\u5316\u3002" : "[npc.Name]\u611f\u89c9[npc.tentacles]\u6e10\u6e10\u71e5\u70ed\u53d1\u75d2\u8d77\u6765\uff0c\u8fc7\u4e86\u4e00\u4f1a\u513f\u5c31\u5f00\u59cb\u4e86\u8f6c\u5316\u3002"));
        }
        if (this.getLengthAsPercentageOfHeight() == this.getType().getDefaultLengthAsPercentageOfHeight()) {
            this.setLengthAsPercentageOfHeight(owner, type.getDefaultLengthAsPercentageOfHeight());
        }
        if (this.getRawGirthValue() == this.getType().getDefaultGirth()) {
            this.setTentacleGirth(owner, type.getDefaultGirth());
        }
        if (type == TentacleType.NONE) {
            sb.append(type.getTransformationDescription(owner));
            this.type = type;
        } else {
            this.type = type;
            sb.append(type.getTransformationDescription(owner));
        }
        sb.append("</p>");
        return UtilText.parse(owner, sb.toString(), new ParserTag[0]) + "<p>" + owner.postTransformationCalculation() + "</p>";
    }

    public int getTentacleCount() {
        return this.tentacleCount;
    }

    public String setTentacleCount(GameCharacter owner, int tentacleCount) {
        tentacleCount = Math.max(1, Math.min(tentacleCount, 100));
        if (!Main.game.isStarted() || owner == null) {
            this.tentacleCount = tentacleCount;
            return "";
        }
        if (owner.getTentacleCount() == tentacleCount) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        owner.removeStatusEffect(StatusEffect.SUBSPECIES_BONUS);
        boolean removingTentacles = owner.getTentacleCount() > tentacleCount;
        this.tentacleCount = tentacleCount;
        owner.addStatusEffect(StatusEffect.SUBSPECIES_BONUS, -1);
        if (owner.getTentacleType() == TentacleType.NONE) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        if (removingTentacles) {
            return UtilText.parse(owner, "<p>\u4e00\u80a1\u523a\u75db\u611f\u4f20\u904d\u4e86[npc.namePos]\u7684[npc.tentacles]\uff0c\u63a5\u7740\u8fd9\u79cd\u611f\u89c9\u7ee7\u7eed\u5411\u4e0a\uff0c\u96c6\u4e2d\u5728\u4e86[npc.her]\u7684\u8170\u80cc\u95f4\u3002[npc.She]\u4e0d\u7981\u5927\u53eb\u4e00\u58f0\uff0c\u53ea\u89c9\u5f97\u597d\u50cf\u6709\u4e00\u6761[style.boldShrink(\u7f29\u4e86\u4e0b\u53bb)]\uff0c\u6d88\u5931\u5728[npc.her]\u7684[npc.skin]\u4e4b\u4e0b\u3002<br/>\u7247\u523b\u8fc7\u540e\uff0c[npc.sheIs]\u4fbf\u6709\u4e86[style.boldTfGeneric(" + (String)(tentacleCount == 1 ? "\u4e00\u6761[npc.tentacle]" : Util.intToString(tentacleCount) + "\u6761[npc.tentacles]") + ")]\u3002</p>", new ParserTag[0]);
        }
        return UtilText.parse(owner, "<p>\u4e00\u80a1\u523a\u75db\u611f\u4f20\u904d\u4e86[npc.namePos]\u7684[npc.tentacles]\uff0c\u63a5\u7740\u8fd9\u79cd\u611f\u89c9\u7ee7\u7eed\u5411\u4e0a\uff0c\u96c6\u4e2d\u5728\u4e86[npc.her]\u7684\u8170\u80cc\u95f4\u3002[npc.She]\u4e0d\u7981\u8f7b\u547c\u4e00\u58f0\uff0c\u53ea\u89c9\u5f97\u597d\u50cf\u6709\u65b0\u7684[npc.tentacles][style.boldShrink(\u6b63\u5728\u751f\u957f)]\uff0c\u7a81\u7834[npc.skin]\u800c\u51fa\u3002<br/>\u7247\u523b\u8fc7\u540e\uff0c[npc.sheIs]\u4fbf\u6709\u4e86[style.boldTfGeneric(" + (String)(tentacleCount == 1 ? "\u4e00\u6761[npc.tentacle]" : Util.intToString(tentacleCount) + "\u6761[npc.tentacles]") + ")]\u3002</p>", new ParserTag[0]);
    }

    public PenetrationGirth getGirth() {
        return PenetrationGirth.getGirthFromInt(this.girth);
    }

    public int getRawGirthValue() {
        return this.girth;
    }

    public String setTentacleGirth(GameCharacter owner, int girth) {
        if (owner == null) {
            this.girth = Math.max(0, Math.min(girth, PenetrationGirth.getMaximum()));
            return "";
        }
        if (!owner.hasTentacle()) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        int girthChange = 0;
        if (girth <= 0) {
            if (this.girth != 0) {
                girthChange = 0 - this.girth;
                this.girth = 0;
            }
        } else if (girth >= PenetrationGirth.getMaximum()) {
            if (this.girth != PenetrationGirth.getMaximum()) {
                girthChange = PenetrationGirth.getMaximum() - this.girth;
                this.girth = PenetrationGirth.getMaximum();
            }
        } else if (this.girth != girth) {
            girthChange = girth - this.girth;
            this.girth = girth;
        }
        if (girthChange == 0) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.namePos][npc.tentacle]\u7684\u5468\u957f\u6ca1\u6709\u53d8\u5316\u2026\u2026)]</p>", new ParserTag[0]);
        }
        return owner.getTentacleType().getGirthTransformationDescription(owner, girthChange > 0);
    }

    public float getLengthAsPercentageOfHeight() {
        return this.lengthAsPercentageOfHeight;
    }

    public String setLengthAsPercentageOfHeight(GameCharacter owner, float lengthAsPercentageOfHeight) {
        if (owner == null) {
            this.lengthAsPercentageOfHeight = Math.max(1.0f, Math.min(lengthAsPercentageOfHeight, 5.0f));
            return "";
        }
        float lengthChange = 0.0f;
        if (lengthAsPercentageOfHeight <= 1.0f) {
            if (this.lengthAsPercentageOfHeight != 1.0f) {
                lengthChange = 1.0f - this.lengthAsPercentageOfHeight;
                this.lengthAsPercentageOfHeight = 1.0f;
            }
        } else if (lengthAsPercentageOfHeight >= 5.0f) {
            if (this.lengthAsPercentageOfHeight != 5.0f) {
                lengthChange = 5.0f - this.lengthAsPercentageOfHeight;
                this.lengthAsPercentageOfHeight = 5.0f;
            }
        } else if (this.lengthAsPercentageOfHeight != lengthAsPercentageOfHeight) {
            lengthChange = lengthAsPercentageOfHeight - this.lengthAsPercentageOfHeight;
            this.lengthAsPercentageOfHeight = lengthAsPercentageOfHeight;
        }
        if (!owner.hasTentacle()) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled(\u7531\u4e8e[npc.name]\u6ca1\u6709\u89e6\u624b\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        if (lengthChange == 0.0f) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.namePos][npc.tentacles]\u7684\u957f\u5ea6\u6ca1\u6709\u53d8\u5316\u2026\u2026)]</p>", new ParserTag[0]);
        }
        return owner.getTentacleType().getLengthTransformationDescription(owner, lengthChange > 0.0f);
    }

    public int getLength(GameCharacter owner) {
        return (int)((float)owner.getHeightValue() * this.getLengthAsPercentageOfHeight());
    }

    public static float getGenericDiameter(int height, PenetrationGirth girth) {
        return Units.round((float)height * 0.08f * (1.0f + girth.getDiameterPercentageModifier()), 2);
    }

    public float getBaseDiameter(GameCharacter owner) {
        return this.getDiameter(owner, 0.0f);
    }

    public float getDiameter(GameCharacter owner, float atLength) {
        float baseDiameter = (float)owner.getHeightValue() * 0.08f * (1.0f + this.getGirth().getDiameterPercentageModifier());
        float lengthPercentage = Math.min(1.0f, atLength / (float)this.getLength(owner));
        if (this.getType().getTags().contains((Object)BodyPartTag.TAIL_TAPERING_EXPONENTIAL)) {
            return 1.0f / (4.0f * lengthPercentage + 1.0f) * baseDiameter;
        }
        if (this.getType().getTags().contains((Object)BodyPartTag.TAIL_TAPERING_LINEAR)) {
            return (1.0f - 0.8f * lengthPercentage) * baseDiameter;
        }
        return Units.round(baseDiameter, 2);
    }

    @Override
    public boolean isFeral(GameCharacter owner) {
        if (owner == null) {
            return false;
        }
        return owner.isFeral() || owner.getLegConfiguration().getFeralParts().contains(Tentacle.class) && this.getType().getRace().isFeralPartsAvailable();
    }
}

