/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.BodyPartInterface;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractTorsoType;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;

public class Torso
implements BodyPartInterface {
    protected AbstractTorsoType type;

    public Torso(AbstractTorsoType type) {
        this.type = type;
    }

    public Torso(Torso torsoToCopy) {
        this.type = torsoToCopy.type;
    }

    @Override
    public AbstractTorsoType getType() {
        return this.type;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return this.type.getDeterminer(gc);
    }

    @Override
    public String getName(GameCharacter gc) {
        return this.type.getName(gc);
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.type.getNameSingular(gc);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.type.getNamePlural(gc);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        return this.type.getDescriptor(gc);
    }

    public String setType(GameCharacter owner, AbstractTorsoType type) {
        if (!Main.game.isStarted() || owner == null) {
            this.type = type;
            if (owner != null) {
                owner.postTransformationCalculation();
            }
            return "";
        }
        if (type == this.getType()) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6709[npc.a_skinRace]\u7684[npc.skin]\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<p>[npc.NamePos]\u6574\u4e2a\u8eab\u5b50\u90fd\u5f00\u59cb\u53d1\u75d2\u71e5\u70ed\u8d77\u6765\uff0c[npc.she]\u53d1\u4e86\u75af\u4f3c\u7684\u6320\u6765\u6320\u53bb\uff0c[npc.skin]\u7684\u8f6c\u5316\u5f00\u59cb\u4e86\u3002");
        String s = UtilText.parse(owner, sb.toString(), new ParserTag[0]);
        sb.setLength(0);
        sb.append(s);
        this.type = type;
        sb.append(this.type.getTransformationDescription(owner));
        sb.append("</p>");
        return UtilText.parse(owner, sb.toString(), new ParserTag[0]) + "<p>" + owner.postTransformationCalculation() + "</p>";
    }

    @Override
    public boolean isFeral(GameCharacter owner) {
        if (owner == null) {
            return false;
        }
        return owner.isFeral() || owner.getLegConfiguration().getFeralParts().contains(Torso.class) && this.getType().getRace().isFeralPartsAvailable();
    }
}

