/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.abstractTypes;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.types.BodyPartTypeInterface;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractAntennaType
implements BodyPartTypeInterface {
    private boolean mod;
    private boolean fromExternalFile;
    private int defaultAntennaePerRow;
    private String name;
    private String namePlural;
    private String transformationName;
    private AbstractBodyCoveringType coveringType;
    private AbstractRace race;
    private List<String> descriptorsMasculine;
    private List<String> descriptorsFeminine;
    private String antennaTransformationDescription;
    private String antennaBodyDescription;

    public AbstractAntennaType(AbstractBodyCoveringType coveringType, AbstractRace race, String transformationName, String name, String namePlural, List<String> descriptorsMasculine, List<String> descriptorsFeminine, String antennaTransformationDescription, String antennaBodyDescription) {
        this.mod = false;
        this.fromExternalFile = false;
        this.coveringType = coveringType;
        this.race = race;
        this.transformationName = transformationName;
        this.name = name;
        this.namePlural = namePlural;
        this.defaultAntennaePerRow = 2;
        this.descriptorsMasculine = descriptorsMasculine;
        this.descriptorsFeminine = descriptorsFeminine;
        this.antennaTransformationDescription = antennaTransformationDescription;
        this.antennaBodyDescription = antennaBodyDescription;
    }

    public AbstractAntennaType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.race = Race.getRaceFromId(coreElement.getMandatoryFirstOf("race").getTextContent());
                this.coveringType = BodyCoveringType.getBodyCoveringTypeFromId(coreElement.getMandatoryFirstOf("coveringType").getTextContent());
                this.defaultAntennaePerRow = Integer.valueOf(coreElement.getMandatoryFirstOf("defaultAntennaePerRow").getTextContent());
                this.transformationName = coreElement.getMandatoryFirstOf("transformationName").getTextContent();
                this.name = coreElement.getMandatoryFirstOf("name").getTextContent();
                this.namePlural = coreElement.getMandatoryFirstOf("namePlural").getTextContent();
                this.descriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsMasculine").getAllOf("descriptor")) {
                        this.descriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.descriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsFeminine").getAllOf("descriptor")) {
                        this.descriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.antennaTransformationDescription = coreElement.getMandatoryFirstOf("transformationDescription").getTextContent();
                this.antennaBodyDescription = coreElement.getMandatoryFirstOf("bodyDescription").getTextContent();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractAntennaType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    @Override
    public String getTransformationNameOverride() {
        return this.transformationName;
    }

    public int getDefaultAntennaePerRow() {
        return this.defaultAntennaePerRow;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        if (gc.getAntennaRows() == 1) {
            if (gc.getAntennaePerRow() == 1) {
                return "\u5355\u6839";
            }
            if (gc.getAntennaePerRow() == 2) {
                return "\u4e00\u5bf9";
            }
            if (gc.getAntennaePerRow() == 3) {
                return "\u4e09\u6839";
            }
            return "\u56db\u6839";
        }
        if (gc.getAntennaePerRow() == 1) {
            return Util.intToString(gc.getAntennaRows()) + "\u6839\u7ad6\u76f4\u6392\u5217\u7684";
        }
        if (gc.getAntennaePerRow() == 2) {
            return Util.intToString(gc.getAntennaRows()) + "\u5bf9";
        }
        if (gc.getAntennaePerRow() == 3) {
            return Util.intToString(gc.getAntennaRows()) + "\u7ec4";
        }
        return Util.intToString(gc.getAntennaRows()) + "\u7ec4";
    }

    @Override
    public boolean isDefaultPlural(GameCharacter gc) {
        return true;
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.name;
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.namePlural;
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        if (gc.isFeminine()) {
            return Util.randomItemFrom(this.descriptorsFeminine);
        }
        return Util.randomItemFrom(this.descriptorsMasculine);
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(Body body) {
        return this.coveringType;
    }

    @Override
    public AbstractRace getRace() {
        return this.race;
    }

    public String getBodyDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.antennaBodyDescription, new ParserTag[0]);
    }

    public String getTransformationDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.antennaTransformationDescription, new ParserTag[0]);
    }
}

