/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.abstractTypes;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.types.BodyPartTypeInterface;
import com.lilithsthrone.game.character.body.valueEnums.OrificeModifier;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractAnusType
implements BodyPartTypeInterface {
    private boolean mod;
    private boolean fromExternalFile;
    private AbstractBodyCoveringType coveringType;
    private AbstractRace race;
    private boolean assHairAllowed;
    private List<String> names;
    private List<String> namesPlural;
    private List<String> descriptorsMasculine;
    private List<String> descriptorsFeminine;
    private List<OrificeModifier> defaultRacialOrificeModifiers;

    public AbstractAnusType(AbstractBodyCoveringType coveringType, AbstractRace race, List<String> names, List<String> namesPlural, List<String> descriptorsMasculine, List<String> descriptorsFeminine, List<OrificeModifier> defaultRacialOrificeModifiers) {
        this.assHairAllowed = race.getRacialClass().isAnthroHair();
        this.coveringType = coveringType;
        this.race = race;
        this.names = names;
        this.namesPlural = namesPlural;
        this.descriptorsMasculine = descriptorsMasculine;
        this.descriptorsFeminine = descriptorsFeminine;
        this.defaultRacialOrificeModifiers = defaultRacialOrificeModifiers == null ? new ArrayList<OrificeModifier>() : defaultRacialOrificeModifiers;
    }

    public AbstractAnusType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.race = Race.getRaceFromId(coreElement.getMandatoryFirstOf("race").getTextContent());
                this.coveringType = BodyCoveringType.getBodyCoveringTypeFromId(coreElement.getMandatoryFirstOf("coveringType").getTextContent());
                this.assHairAllowed = this.race.getRacialClass().isAnthroHair();
                if (coreElement.getOptionalFirstOf("assHairAllowed").isPresent()) {
                    this.assHairAllowed = Boolean.valueOf(coreElement.getMandatoryFirstOf("assHairAllowed").getTextContent());
                }
                this.names = new ArrayList<String>();
                for (Element e : coreElement.getMandatoryFirstOf("names").getAllOf("name")) {
                    this.names.add(e.getTextContent());
                }
                this.namesPlural = new ArrayList<String>();
                for (Element e : coreElement.getMandatoryFirstOf("namesPlural").getAllOf("name")) {
                    this.namesPlural.add(e.getTextContent());
                }
                this.descriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsMasculine").getAllOf("descriptor")) {
                        this.descriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.descriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsFeminine").getAllOf("descriptor")) {
                        this.descriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.defaultRacialOrificeModifiers = new ArrayList<OrificeModifier>();
                if (coreElement.getOptionalFirstOf("defaultOrificeModifiers").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("defaultOrificeModifiers").getAllOf("modifier")) {
                        this.defaultRacialOrificeModifiers.add(OrificeModifier.valueOf(e.getTextContent()));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractAnusType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public boolean isAssHairAllowed() {
        return this.assHairAllowed;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return "";
    }

    @Override
    public boolean isDefaultPlural(GameCharacter gc) {
        return false;
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        if (this.names == null || this.names.isEmpty()) {
            return UtilText.returnStringAtRandom("\u5c41\u773c", "\u540e\u5ead", "\u83ca\u7a74");
        }
        return Util.randomItemFrom(this.names);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        if (this.namesPlural == null || this.namesPlural.isEmpty()) {
            return UtilText.returnStringAtRandom("\u5c41\u773c", "\u540e\u5ead", "\u83ca\u7a74");
        }
        return Util.randomItemFrom(this.namesPlural);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        if (gc.isFeminine()) {
            return Util.randomItemFrom(this.descriptorsFeminine);
        }
        return Util.randomItemFrom(this.descriptorsMasculine);
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(Body body) {
        return this.coveringType;
    }

    @Override
    public AbstractRace getRace() {
        return this.race;
    }

    public List<OrificeModifier> getDefaultRacialOrificeModifiers() {
        return this.defaultRacialOrificeModifiers;
    }
}

