/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.abstractTypes;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.tags.BodyPartTag;
import com.lilithsthrone.game.character.body.types.BodyPartTypeInterface;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.clothing.BodyPartClothingBlock;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractArmType
implements BodyPartTypeInterface {
    private boolean mod;
    private boolean fromExternalFile;
    private String transformationName;
    private AbstractBodyCoveringType coveringType;
    private AbstractRace race;
    private boolean allowsFlight;
    private boolean underarmHairAllowed;
    private String name;
    private String namePlural;
    private List<String> descriptorsMasculine;
    private List<String> descriptorsFeminine;
    private String handName;
    private String handNamePlural;
    private List<String> handDescriptorsMasculine;
    private List<String> handDescriptorsFeminine;
    private String fingerName;
    private String fingerNamePlural;
    private List<String> fingerDescriptorsMasculine;
    private List<String> fingerDescriptorsFeminine;
    private String armTransformationDescription;
    private String armBodyDescription;
    private List<BodyPartTag> armTags;

    public AbstractArmType(AbstractBodyCoveringType coveringType, AbstractRace race, String name, String namePlural, List<String> descriptorsMasculine, List<String> descriptorsFeminine, String handName, String handNamePlural, List<String> handDescriptorsMasculine, List<String> handDescriptorsFeminine, String fingerName, String fingerNamePlural, List<String> fingerDescriptorsMasculine, List<String> fingerDescriptorsFeminine, String armTransformationDescription, String armBodyDescription) {
        this.underarmHairAllowed = race.getRacialClass().isAnthroHair();
        this.coveringType = coveringType;
        this.race = race;
        this.transformationName = null;
        this.allowsFlight = false;
        this.name = name;
        this.namePlural = namePlural;
        this.descriptorsMasculine = descriptorsMasculine;
        this.descriptorsFeminine = descriptorsFeminine;
        this.handName = handName;
        this.handNamePlural = handNamePlural;
        this.handDescriptorsMasculine = handDescriptorsMasculine;
        this.handDescriptorsFeminine = handDescriptorsFeminine;
        this.fingerName = fingerName;
        this.fingerNamePlural = fingerNamePlural;
        this.fingerDescriptorsMasculine = fingerDescriptorsMasculine;
        this.fingerDescriptorsFeminine = fingerDescriptorsFeminine;
        this.armTransformationDescription = armTransformationDescription;
        this.armBodyDescription = armBodyDescription;
        this.armTags = Util.newArrayListOfValues(BodyPartTag.ARM_STANDARD);
    }

    public AbstractArmType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.race = Race.getRaceFromId(coreElement.getMandatoryFirstOf("race").getTextContent());
                this.coveringType = BodyCoveringType.getBodyCoveringTypeFromId(coreElement.getMandatoryFirstOf("coveringType").getTextContent());
                this.transformationName = coreElement.getMandatoryFirstOf("transformationName").getTextContent();
                this.underarmHairAllowed = this.race.getRacialClass().isAnthroHair();
                if (coreElement.getOptionalFirstOf("underarmHairAllowed").isPresent()) {
                    this.underarmHairAllowed = Boolean.valueOf(coreElement.getMandatoryFirstOf("underarmHairAllowed").getTextContent());
                }
                this.allowsFlight = Boolean.valueOf(coreElement.getMandatoryFirstOf("allowsFlight").getTextContent());
                this.armTags = new ArrayList<BodyPartTag>();
                if (coreElement.getOptionalFirstOf("tags").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("tags").getAllOf("tag")) {
                        this.armTags.add(BodyPartTag.getBodyPartTagFromId(e.getTextContent()));
                    }
                }
                if (this.armTags.isEmpty()) {
                    this.armTags.add(BodyPartTag.ARM_STANDARD);
                }
                this.name = coreElement.getMandatoryFirstOf("name").getTextContent();
                this.namePlural = coreElement.getMandatoryFirstOf("namePlural").getTextContent();
                this.descriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsMasculine").getAllOf("descriptor")) {
                        this.descriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.descriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsFeminine").getAllOf("descriptor")) {
                        this.descriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.handName = coreElement.getMandatoryFirstOf("handName").getTextContent();
                this.handNamePlural = coreElement.getMandatoryFirstOf("handNamePlural").getTextContent();
                this.handDescriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("handDescriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("handDescriptorsMasculine").getAllOf("descriptor")) {
                        this.handDescriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.handDescriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("handDescriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("handDescriptorsFeminine").getAllOf("descriptor")) {
                        this.handDescriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.fingerName = coreElement.getMandatoryFirstOf("fingerName").getTextContent();
                this.fingerNamePlural = coreElement.getMandatoryFirstOf("fingerNamePlural").getTextContent();
                this.fingerDescriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("fingerDescriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("fingerDescriptorsMasculine").getAllOf("descriptor")) {
                        this.fingerDescriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.fingerDescriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("fingerDescriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("fingerDescriptorsFeminine").getAllOf("descriptor")) {
                        this.fingerDescriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.armTransformationDescription = coreElement.getMandatoryFirstOf("transformationDescription").getTextContent();
                this.armBodyDescription = coreElement.getMandatoryFirstOf("bodyDescription").getTextContent();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractArmType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public boolean isUnderarmHairAllowed() {
        return this.underarmHairAllowed;
    }

    public boolean allowsFlight() {
        return this.allowsFlight;
    }

    @Override
    public String getTransformationNameOverride() {
        return this.transformationName;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        if (gc.getArmRows() == 1) {
            return "\u4e00\u5bf9";
        }
        return Util.intToString(gc.getArmRows()) + "\u5bf9";
    }

    @Override
    public boolean isDefaultPlural(GameCharacter gc) {
        return true;
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.name;
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.namePlural;
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        if (gc.isFeminine()) {
            return Util.randomItemFrom(this.descriptorsFeminine);
        }
        return Util.randomItemFrom(this.descriptorsMasculine);
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(Body body) {
        return this.coveringType;
    }

    @Override
    public AbstractRace getRace() {
        return this.race;
    }

    public String getHandsNameSingular(GameCharacter gc) {
        return this.handName;
    }

    public String getHandsNamePlural(GameCharacter gc) {
        return this.handNamePlural;
    }

    public String getHandsDescriptor(GameCharacter gc) {
        if (gc.isFeminine()) {
            return Util.randomItemFrom(this.handDescriptorsFeminine);
        }
        return Util.randomItemFrom(this.handDescriptorsMasculine);
    }

    public String getFingersNameSingular(GameCharacter gc) {
        return this.fingerName;
    }

    public String getFingersNamePlural(GameCharacter gc) {
        return this.fingerNamePlural;
    }

    public String getFingersDescriptor(GameCharacter gc) {
        if (gc.isFeminine()) {
            return Util.randomItemFrom(this.fingerDescriptorsFeminine);
        }
        return Util.randomItemFrom(this.fingerDescriptorsMasculine);
    }

    @Override
    public BodyPartClothingBlock getBodyPartClothingBlock() {
        if (this.getTags().contains((Object)BodyPartTag.ARM_WINGS_FEATHERED)) {
            return new BodyPartClothingBlock(Util.newArrayListOfValues(InventorySlot.HAND, InventorySlot.WRIST, InventorySlot.TORSO_OVER, InventorySlot.TORSO_UNDER), Race.HARPY, "\u7531\u4e8e[npc.nameHasFull]\u7528\u7c7b\u4f3c\u9e1f\u7684\u7fc5\u8180\u4ee3\u66ff\u4e86\u624b\u81c2\uff0c\u53ea\u6709\u7279\u5b9a\u670d\u88c5\u80fd\u591f\u88c5\u5907\u81f3\u8be5\u680f\u4f4d\u3002", Util.newArrayListOfValues(ItemTag.FITS_FEATHERED_ARM_WINGS, ItemTag.FITS_FEATHERED_ARM_WINGS_EXCLUSIVE, ItemTag.FITS_ARM_WINGS, ItemTag.FITS_ARM_WINGS_EXCLUSIVE));
        }
        if (this.getTags().contains((Object)BodyPartTag.ARM_WINGS_LEATHERY)) {
            return new BodyPartClothingBlock(Util.newArrayListOfValues(InventorySlot.HAND, InventorySlot.WRIST, InventorySlot.TORSO_OVER, InventorySlot.TORSO_UNDER), Race.BAT_MORPH, "\u7531\u4e8e[npc.nameHasFull]\u4ee5\u76ae\u819c\u8986\u76d6\u7684\u7fc5\u8180\u4ee3\u66ff\u4e86\u624b\u81c2\uff0c\u53ea\u6709\u7279\u5b9a\u670d\u88c5\u80fd\u591f\u88c5\u5907\u81f3\u8be5\u680f\u4f4d\u3002", Util.newArrayListOfValues(ItemTag.FITS_LEATHERY_ARM_WINGS, ItemTag.FITS_LEATHERY_ARM_WINGS_EXCLUSIVE, ItemTag.FITS_ARM_WINGS, ItemTag.FITS_ARM_WINGS_EXCLUSIVE));
        }
        return null;
    }

    public String getBodyDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.armBodyDescription, new ParserTag[0]);
    }

    public String getTransformationDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.armTransformationDescription, new ParserTag[0]);
    }

    @Override
    public List<BodyPartTag> getTags() {
        return this.armTags;
    }
}

