/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.abstractTypes;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractAnusType;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.types.AnusType;
import com.lilithsthrone.game.character.body.types.BodyPartTypeInterface;
import com.lilithsthrone.game.character.body.valueEnums.LegConfiguration;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractAssType
implements BodyPartTypeInterface {
    private boolean mod;
    private boolean fromExternalFile;
    private String transformationName;
    private AbstractBodyCoveringType coveringType;
    private AbstractRace race;
    private AbstractAnusType anusType;
    private List<String> names;
    private List<String> namesPlural;
    private List<String> descriptorsMasculine;
    private List<String> descriptorsFeminine;
    private String assTransformationDescription;
    private String assBodyDescription;

    public AbstractAssType(AbstractBodyCoveringType coveringType, AbstractRace race, AbstractAnusType anusType, List<String> names, List<String> namesPlural, List<String> descriptorsMasculine, List<String> descriptorsFeminine, String assTransformationDescription, String assBodyDescription) {
        this.coveringType = coveringType;
        this.race = race;
        this.anusType = anusType;
        this.transformationName = null;
        this.names = names;
        this.namesPlural = namesPlural;
        this.descriptorsMasculine = descriptorsMasculine;
        this.descriptorsFeminine = descriptorsFeminine;
        this.assTransformationDescription = assTransformationDescription;
        this.assBodyDescription = assBodyDescription;
    }

    public AbstractAssType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.race = Race.getRaceFromId(coreElement.getMandatoryFirstOf("race").getTextContent());
                this.coveringType = BodyCoveringType.getBodyCoveringTypeFromId(coreElement.getMandatoryFirstOf("coveringType").getTextContent());
                this.transformationName = coreElement.getMandatoryFirstOf("transformationName").getTextContent();
                this.anusType = AnusType.getAnusTypeFromId(coreElement.getMandatoryFirstOf("anusType").getTextContent());
                this.names = new ArrayList<String>();
                for (Element e : coreElement.getMandatoryFirstOf("names").getAllOf("name")) {
                    this.names.add(e.getTextContent());
                }
                this.namesPlural = new ArrayList<String>();
                for (Element e : coreElement.getMandatoryFirstOf("namesPlural").getAllOf("name")) {
                    this.namesPlural.add(e.getTextContent());
                }
                this.descriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsMasculine").getAllOf("descriptor")) {
                        this.descriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.descriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsFeminine").getAllOf("descriptor")) {
                        this.descriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.assTransformationDescription = coreElement.getMandatoryFirstOf("transformationDescription").getTextContent();
                this.assBodyDescription = coreElement.getMandatoryFirstOf("bodyDescription").getTextContent();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractAssType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public AbstractAnusType getAnusType() {
        return this.anusType;
    }

    @Override
    public String getTransformationNameOverride() {
        return this.transformationName;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return "";
    }

    @Override
    public boolean isDefaultPlural(GameCharacter gc) {
        return false;
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        if (this.names == null || this.names.isEmpty()) {
            return UtilText.returnStringAtRandom("\u5c41\u80a1");
        }
        return Util.randomItemFrom(this.names);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        if (this.namesPlural == null || this.namesPlural.isEmpty()) {
            return UtilText.returnStringAtRandom("\u5c41\u80a1");
        }
        return Util.randomItemFrom(this.namesPlural);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        if (gc.isFeminine()) {
            return Util.randomItemFrom(this.descriptorsFeminine);
        }
        return Util.randomItemFrom(this.descriptorsMasculine);
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(Body body) {
        if (body != null) {
            if (body.getLegConfiguration() != LegConfiguration.BIPEDAL) {
                return body.getLeg().getBodyCoveringType(body);
            }
            return body.getTorso().getBodyCoveringType(body);
        }
        return this.coveringType;
    }

    @Override
    public AbstractRace getRace() {
        return this.race;
    }

    public String getBodyDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.assBodyDescription, new ParserTag[0]);
    }

    public String getTransformationDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.assTransformationDescription, new ParserTag[0]);
    }
}

