/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.abstractTypes;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractFluidType;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractNippleType;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.types.BodyPartTypeInterface;
import com.lilithsthrone.game.character.body.types.FluidType;
import com.lilithsthrone.game.character.body.types.NippleType;
import com.lilithsthrone.game.character.body.valueEnums.BreastShape;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractBreastType
implements BodyPartTypeInterface {
    private boolean mod;
    private boolean fromExternalFile;
    private String transformationName;
    private AbstractBodyCoveringType coveringType;
    private AbstractRace race;
    private AbstractNippleType nippleType;
    private AbstractFluidType fluidType;
    private List<String> namesFlat;
    private List<String> namesFlatPlural;
    private List<String> descriptorsFlat;
    private List<String> namesBreasts;
    private List<String> namesBreastsPlural;
    private List<String> descriptorsBreasts;
    private String breastsTransformationDescription;
    private String breastsBodyDescription;
    private String breastsCrotchTransformationDescription;
    private String breastsCrotchBodyDescription;

    public AbstractBreastType(AbstractBodyCoveringType coveringType, AbstractRace race, AbstractNippleType nippleType, AbstractFluidType fluidType, List<String> namesFlat, List<String> namesFlatPlural, List<String> descriptorsFlat, List<String> namesBreasts, List<String> namesBreastsPlural, List<String> descriptorsBreasts, String breastsTransformationDescription, String breastsBodyDescription, String breastsCrotchTransformationDescription, String breastsCrotchBodyDescription) {
        this.coveringType = coveringType;
        this.race = race;
        this.nippleType = nippleType;
        this.fluidType = fluidType;
        this.transformationName = null;
        this.namesFlat = namesFlat;
        this.namesFlatPlural = namesFlatPlural;
        this.descriptorsFlat = descriptorsFlat;
        this.namesBreasts = namesBreasts;
        this.namesBreastsPlural = namesBreastsPlural;
        this.descriptorsBreasts = descriptorsBreasts;
        this.breastsTransformationDescription = breastsTransformationDescription;
        this.breastsBodyDescription = breastsBodyDescription;
        this.breastsCrotchTransformationDescription = breastsCrotchTransformationDescription;
        this.breastsCrotchBodyDescription = breastsCrotchBodyDescription;
    }

    public AbstractBreastType(AbstractBodyCoveringType skinType, AbstractRace race, AbstractNippleType nippleType, AbstractFluidType fluidType, String breastsTransformationDescription, String breastsBodyDescription, String breastsCrotchTransformationDescription, String breastsCrotchBodyDescription) {
        this(skinType, race, nippleType, fluidType, null, null, null, null, null, null, breastsTransformationDescription, breastsBodyDescription, breastsCrotchTransformationDescription, breastsCrotchBodyDescription);
    }

    public AbstractBreastType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.race = Race.getRaceFromId(coreElement.getMandatoryFirstOf("race").getTextContent());
                this.coveringType = BodyCoveringType.getBodyCoveringTypeFromId(coreElement.getMandatoryFirstOf("coveringType").getTextContent());
                this.transformationName = coreElement.getMandatoryFirstOf("transformationName").getTextContent();
                this.nippleType = NippleType.getNippleTypeFromId(coreElement.getMandatoryFirstOf("nippleType").getTextContent());
                this.fluidType = FluidType.getFluidTypeFromId(coreElement.getMandatoryFirstOf("fluidType").getTextContent());
                this.namesBreasts = new ArrayList<String>();
                for (Element e : coreElement.getMandatoryFirstOf("names").getAllOf("name")) {
                    this.namesBreasts.add(e.getTextContent());
                }
                this.namesBreastsPlural = new ArrayList<String>();
                for (Element e : coreElement.getMandatoryFirstOf("namesPlural").getAllOf("name")) {
                    this.namesBreastsPlural.add(e.getTextContent());
                }
                this.descriptorsBreasts = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptors").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptors").getAllOf("descriptor")) {
                        this.descriptorsBreasts.add(e.getTextContent());
                    }
                }
                this.namesFlat = new ArrayList<String>();
                for (Element e : coreElement.getMandatoryFirstOf("namesFlat").getAllOf("name")) {
                    this.namesFlat.add(e.getTextContent());
                }
                this.namesFlatPlural = new ArrayList<String>();
                for (Element e : coreElement.getMandatoryFirstOf("namesPluralFlat").getAllOf("name")) {
                    this.namesFlatPlural.add(e.getTextContent());
                }
                this.descriptorsFlat = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsFlat").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsFlat").getAllOf("descriptor")) {
                        this.descriptorsFlat.add(e.getTextContent());
                    }
                }
                this.breastsTransformationDescription = coreElement.getMandatoryFirstOf("transformationDescription").getTextContent();
                this.breastsBodyDescription = coreElement.getMandatoryFirstOf("bodyDescription").getTextContent();
                this.breastsCrotchTransformationDescription = coreElement.getMandatoryFirstOf("crotchBoobsTransformationDescription").getTextContent();
                this.breastsCrotchBodyDescription = coreElement.getMandatoryFirstOf("crotchBoobsBodyDescription").getTextContent();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractBreastType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public AbstractNippleType getNippleType() {
        return this.nippleType;
    }

    public AbstractFluidType getFluidType() {
        return this.fluidType;
    }

    @Override
    public String getTransformationNameOverride() {
        return this.transformationName;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        if (gc.getBreastCrotchShape() == BreastShape.UDDERS) {
            return "\u4e00\u5957";
        }
        if (gc.getBreastRows() == 1) {
            return "\u4e00\u5bf9";
        }
        return Util.intToString(gc.getBreastRows()) + "\u5bf9";
    }

    @Override
    public boolean isDefaultPlural(GameCharacter gc) {
        return true;
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        if (gc.hasBreasts()) {
            if (this.namesBreasts == null || this.namesBreasts.isEmpty()) {
                return UtilText.returnStringAtRandom("\u4e73\u623f", "\u80f8\u90e8", "\u5976\u5b50");
            }
            return Util.randomItemFrom(this.namesBreasts);
        }
        if (this.namesFlat == null || this.namesFlat.isEmpty()) {
            return UtilText.returnStringAtRandom("\u5e73\u677f\u80f8\u90e8");
        }
        return Util.randomItemFrom(this.namesFlat);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        if (gc.hasBreasts()) {
            if (this.namesBreastsPlural == null || this.namesBreastsPlural.isEmpty()) {
                return UtilText.returnStringAtRandom("\u4e73\u623f", "\u80f8\u90e8", "\u5976\u5b50");
            }
            return Util.randomItemFrom(this.namesBreastsPlural);
        }
        if (this.namesFlatPlural == null || this.namesFlatPlural.isEmpty()) {
            return UtilText.returnStringAtRandom("\u5e73\u677f\u80f8\u90e8");
        }
        return Util.randomItemFrom(this.namesFlatPlural);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        if (gc.hasBreasts()) {
            if (this.descriptorsBreasts == null || this.descriptorsBreasts.isEmpty()) {
                return "";
            }
            return Util.randomItemFrom(this.descriptorsBreasts);
        }
        if (this.descriptorsFlat == null || this.descriptorsFlat.isEmpty()) {
            return "";
        }
        return Util.randomItemFrom(this.descriptorsFlat);
    }

    public String getCrotchNameSingular(GameCharacter gc) {
        return UtilText.returnStringAtRandom("\u80ef\u4e73", "\u80ef\u4e73", "\u80ef\u4e73", "\u80ef\u5976");
    }

    public String getCrotchNamePlural(GameCharacter gc) {
        return UtilText.returnStringAtRandom("\u80ef\u4e73", "\u80ef\u4e73", "\u80ef\u4e73", "\u80ef\u5976", "\u80ef\u80f8");
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(Body body) {
        if (body != null) {
            return body.getTorso().getBodyCoveringType(body);
        }
        return this.coveringType;
    }

    @Override
    public AbstractRace getRace() {
        return this.race;
    }

    public String getBodyDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.breastsBodyDescription, new ParserTag[0]);
    }

    public String getTransformationDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.breastsTransformationDescription, new ParserTag[0]);
    }

    public String getTransformationCrotchDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.breastsCrotchTransformationDescription, new ParserTag[0]);
    }

    public String getBodyCrotchDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.breastsCrotchBodyDescription, new ParserTag[0]);
    }
}

