/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.abstractTypes;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractMouthType;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.tags.BodyPartTag;
import com.lilithsthrone.game.character.body.types.BodyPartTypeInterface;
import com.lilithsthrone.game.character.body.types.FaceType;
import com.lilithsthrone.game.character.body.types.MouthType;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractFaceType
implements BodyPartTypeInterface {
    private boolean mod;
    private boolean fromExternalFile;
    private String transformationName;
    private AbstractBodyCoveringType coveringType;
    private AbstractRace race;
    private boolean facialHairAllowed;
    private AbstractMouthType mouthType;
    private List<String> names;
    private List<String> namesPlural;
    private List<String> descriptorsMasculine;
    private List<String> descriptorsFeminine;
    private String noseName;
    private String noseNamePlural;
    private List<String> noseDescriptorsMasculine;
    private List<String> noseDescriptorsFeminine;
    private String faceTransformationDescription;
    private String faceBodyDescription;
    private String faceBodyDescriptionFeral = "[npc.SheHasFull]\u7684\u9762\u90e8\u662f\u517d\u6001\u7684[npc.legRace]\uff0c[npc.feminineDescriptor(true)]\uff0c[npc.materialDescriptor][npc.faceFullDescription(true)]\u3002";
    private List<BodyPartTag> tags;

    public AbstractFaceType(AbstractBodyCoveringType coveringType, AbstractRace race, AbstractMouthType mouthType, List<String> names, List<String> namesPlural, List<String> descriptorsMasculine, List<String> descriptorsFeminine, String noseName, String noseNamePlural, List<String> noseDescriptorsMasculine, List<String> noseDescriptorsFeminine, String faceTransformationDescription, String faceBodyDescription, List<BodyPartTag> tags) {
        this(coveringType, race, mouthType, names, namesPlural, descriptorsMasculine, descriptorsFeminine, noseName, noseNamePlural, noseDescriptorsMasculine, noseDescriptorsFeminine, faceTransformationDescription, faceBodyDescription, "", tags);
    }

    public AbstractFaceType(AbstractBodyCoveringType coveringType, AbstractRace race, AbstractMouthType mouthType, List<String> names, List<String> namesPlural, List<String> descriptorsMasculine, List<String> descriptorsFeminine, String noseName, String noseNamePlural, List<String> noseDescriptorsMasculine, List<String> noseDescriptorsFeminine, String faceTransformationDescription, String faceBodyDescription, String faceBodyDescriptionFeral, List<BodyPartTag> tags) {
        this.facialHairAllowed = race.getRacialClass().isAnthroHair();
        this.coveringType = coveringType;
        this.race = race;
        this.mouthType = mouthType;
        this.transformationName = null;
        this.names = names;
        this.namesPlural = namesPlural;
        this.descriptorsMasculine = descriptorsMasculine;
        this.descriptorsFeminine = descriptorsFeminine;
        this.noseName = noseName;
        this.noseNamePlural = noseNamePlural;
        this.noseDescriptorsMasculine = noseDescriptorsMasculine;
        this.noseDescriptorsFeminine = noseDescriptorsFeminine;
        this.faceTransformationDescription = faceTransformationDescription;
        this.faceBodyDescription = faceBodyDescription;
        if (!faceBodyDescriptionFeral.isEmpty()) {
            this.faceBodyDescriptionFeral = faceBodyDescriptionFeral;
        }
        this.tags = tags;
    }

    public AbstractFaceType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.race = Race.getRaceFromId(coreElement.getMandatoryFirstOf("race").getTextContent());
                this.coveringType = BodyCoveringType.getBodyCoveringTypeFromId(coreElement.getMandatoryFirstOf("coveringType").getTextContent());
                this.facialHairAllowed = this.race.getRacialClass().isAnthroHair();
                if (coreElement.getOptionalFirstOf("facialHairAllowed").isPresent()) {
                    this.facialHairAllowed = Boolean.valueOf(coreElement.getMandatoryFirstOf("facialHairAllowed").getTextContent());
                }
                this.transformationName = coreElement.getMandatoryFirstOf("transformationName").getTextContent();
                this.mouthType = MouthType.getMouthTypeFromId(coreElement.getMandatoryFirstOf("mouthType").getTextContent());
                this.tags = new ArrayList<BodyPartTag>();
                if (coreElement.getOptionalFirstOf("tags").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("tags").getAllOf("tag")) {
                        this.tags.add(BodyPartTag.getBodyPartTagFromId(e.getTextContent()));
                    }
                }
                this.names = new ArrayList<String>();
                for (Element e : coreElement.getMandatoryFirstOf("names").getAllOf("name")) {
                    this.names.add(e.getTextContent());
                }
                this.namesPlural = new ArrayList<String>();
                for (Element e : coreElement.getMandatoryFirstOf("namesPlural").getAllOf("name")) {
                    this.namesPlural.add(e.getTextContent());
                }
                this.descriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsMasculine").getAllOf("descriptor")) {
                        this.descriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.descriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsFeminine").getAllOf("descriptor")) {
                        this.descriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.noseName = coreElement.getMandatoryFirstOf("noseName").getTextContent();
                this.noseNamePlural = coreElement.getMandatoryFirstOf("noseNamePlural").getTextContent();
                this.noseDescriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("noseDescriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("noseDescriptorsMasculine").getAllOf("descriptor")) {
                        this.noseDescriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.noseDescriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("noseDescriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("noseDescriptorsFeminine").getAllOf("descriptor")) {
                        this.noseDescriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.faceTransformationDescription = coreElement.getMandatoryFirstOf("transformationDescription").getTextContent();
                this.faceBodyDescription = coreElement.getMandatoryFirstOf("bodyDescription").getTextContent();
                if (coreElement.getOptionalFirstOf("bodyDescriptionFeral").isPresent()) {
                    this.faceBodyDescriptionFeral = coreElement.getMandatoryFirstOf("bodyDescriptionFeral").getTextContent();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractFaceType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public boolean isFacialHairAllowed() {
        return this.facialHairAllowed;
    }

    public AbstractMouthType getMouthType() {
        return this.mouthType;
    }

    @Override
    public String getTransformationNameOverride() {
        return this.transformationName;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return "";
    }

    @Override
    public boolean isDefaultPlural(GameCharacter gc) {
        return false;
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        if (this.names == null || this.names.isEmpty()) {
            if (this.getTags().contains((Object)BodyPartTag.FACE_MUZZLE)) {
                return UtilText.returnStringAtRandom("\u543b\u90e8", "\u8138");
            }
            return "\u8138";
        }
        return Util.randomItemFrom(this.names);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        if (this.namesPlural == null || this.namesPlural.isEmpty()) {
            if (this.getTags().contains((Object)BodyPartTag.FACE_MUZZLE)) {
                return UtilText.returnStringAtRandom("\u543b\u90e8", "\u8138");
            }
            return "\u8138";
        }
        return Util.randomItemFrom(this.namesPlural);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        if (gc.isFeminine()) {
            return Util.randomItemFrom(this.descriptorsFeminine);
        }
        return Util.randomItemFrom(this.descriptorsMasculine);
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(Body body) {
        return this.coveringType;
    }

    @Override
    public AbstractRace getRace() {
        return this.race;
    }

    public String getNoseNameSingular(GameCharacter gc) {
        return this.noseName;
    }

    public String getNoseNamePlural(GameCharacter gc) {
        return this.noseNamePlural;
    }

    public String getNoseDescriptor(GameCharacter gc) {
        if (gc.isFeminine()) {
            return Util.randomItemFrom(this.noseDescriptorsFeminine);
        }
        return Util.randomItemFrom(this.noseDescriptorsMasculine);
    }

    public String getBodyDescription(GameCharacter owner) {
        return UtilText.parse(owner, owner.isFeral() ? this.faceBodyDescriptionFeral : this.faceBodyDescription, new ParserTag[0]);
    }

    public String getTransformationDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.faceTransformationDescription, new ParserTag[0]);
    }

    @Override
    public TFModifier getTFModifier() {
        return this.getTFTypeModifier(FaceType.getFaceTypes(this.race));
    }

    @Override
    public List<BodyPartTag> getTags() {
        return this.tags;
    }
}

