/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.abstractTypes;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.tags.BodyPartTag;
import com.lilithsthrone.game.character.body.types.BodyPartTypeInterface;
import com.lilithsthrone.game.character.body.types.HairType;
import com.lilithsthrone.game.character.body.valueEnums.BodyMaterial;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractHairType
implements BodyPartTypeInterface {
    private boolean mod;
    private boolean fromExternalFile;
    private AbstractBodyCoveringType coveringType;
    private AbstractRace race;
    private String transformationName;
    private double neckFluffChance;
    private boolean neckFluffRequiresGreater;
    private boolean defaultPlural;
    private String determiner;
    private String name;
    private String namePlural;
    private List<String> descriptorsMasculine;
    private List<String> descriptorsFeminine;
    private String hairTransformationDescription;
    private String hairBodyDescription;
    private List<BodyPartTag> tags;

    public AbstractHairType(AbstractBodyCoveringType skinType, AbstractRace race, String transformationName, String name, String namePlural, List<String> descriptorsMasculine, List<String> descriptorsFeminine, String hairTransformationDescription, String hairBodyDescription, List<BodyPartTag> tags) {
        this.coveringType = skinType;
        this.race = race;
        this.neckFluffRequiresGreater = true;
        this.neckFluffChance = 0.0;
        this.transformationName = transformationName;
        this.defaultPlural = false;
        this.determiner = "\u4e00\u5934";
        this.name = name;
        this.namePlural = namePlural;
        this.descriptorsMasculine = descriptorsMasculine;
        this.descriptorsFeminine = descriptorsFeminine;
        this.hairTransformationDescription = hairTransformationDescription;
        this.hairBodyDescription = hairBodyDescription;
        this.tags = tags == null ? new ArrayList<BodyPartTag>() : tags;
    }

    public AbstractHairType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.race = Race.getRaceFromId(coreElement.getMandatoryFirstOf("race").getTextContent());
                this.coveringType = BodyCoveringType.getBodyCoveringTypeFromId(coreElement.getMandatoryFirstOf("coveringType").getTextContent());
                this.transformationName = coreElement.getMandatoryFirstOf("transformationName").getTextContent();
                this.neckFluffRequiresGreater = true;
                if (coreElement.getOptionalFirstOf("neckFluffChance").isPresent()) {
                    this.neckFluffRequiresGreater = Boolean.valueOf(coreElement.getMandatoryFirstOf("neckFluffChance").getAttribute("requiresGreaterMorph"));
                }
                this.neckFluffChance = 0.0;
                if (coreElement.getOptionalFirstOf("neckFluffChance").isPresent()) {
                    this.neckFluffChance = (double)Float.valueOf(coreElement.getMandatoryFirstOf("neckFluffChance").getTextContent()).floatValue() / 100.0;
                }
                this.tags = new ArrayList<BodyPartTag>();
                if (coreElement.getOptionalFirstOf("tags").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("tags").getAllOf("tag")) {
                        this.tags.add(BodyPartTag.getBodyPartTagFromId(e.getTextContent()));
                    }
                }
                this.determiner = coreElement.getMandatoryFirstOf("determiner").getTextContent();
                this.name = coreElement.getMandatoryFirstOf("name").getTextContent();
                this.namePlural = coreElement.getMandatoryFirstOf("namePlural").getTextContent();
                this.defaultPlural = Boolean.valueOf(coreElement.getMandatoryFirstOf("namePlural").getAttribute("pluralByDefault"));
                this.descriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsMasculine").getAllOf("descriptor")) {
                        this.descriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.descriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsFeminine").getAllOf("descriptor")) {
                        this.descriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.hairTransformationDescription = coreElement.getMandatoryFirstOf("transformationDescription").getTextContent();
                this.hairBodyDescription = coreElement.getMandatoryFirstOf("bodyDescription").getTextContent();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractHairType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public boolean isAbleToBeGrabbedInSex() {
        return this.getTags().contains((Object)BodyPartTag.HAIR_HANDLES_IN_SEX);
    }

    public double getNeckFluffChance() {
        return this.neckFluffChance;
    }

    public boolean isNeckFluffRequiresGreater() {
        return this.neckFluffRequiresGreater;
    }

    @Override
    public String getTransformationNameOverride() {
        return this.transformationName;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return this.determiner;
    }

    @Override
    public boolean isDefaultPlural(GameCharacter gc) {
        return this.defaultPlural;
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        if (gc.getBodyMaterial() == BodyMaterial.SLIME) {
            return "\u7c98\u6db2" + this.name;
        }
        if (gc.getBodyMaterial() == BodyMaterial.SILICONE) {
            return "\u7845\u80f6" + this.name;
        }
        return this.name;
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        if (gc.getBodyMaterial() == BodyMaterial.SLIME) {
            return "\u7c98\u6db2" + this.namePlural;
        }
        if (gc.getBodyMaterial() == BodyMaterial.SILICONE) {
            return "\u7845\u80f6" + this.namePlural;
        }
        return this.namePlural;
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        if (gc.isFeminine()) {
            return Util.randomItemFrom(this.descriptorsFeminine);
        }
        return Util.randomItemFrom(this.descriptorsMasculine);
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(Body body) {
        return this.coveringType;
    }

    @Override
    public AbstractRace getRace() {
        return this.race;
    }

    @Override
    public TFModifier getTFModifier() {
        return this.getTFTypeModifier(HairType.getHairTypes(this.race));
    }

    public String getBodyDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.hairBodyDescription, new ParserTag[0]);
    }

    public String getTransformationDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.hairTransformationDescription, new ParserTag[0]);
    }

    @Override
    public List<BodyPartTag> getTags() {
        return this.tags;
    }
}

