/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.abstractTypes;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.types.BodyPartTypeInterface;
import com.lilithsthrone.game.character.body.types.HornType;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractHornType
implements BodyPartTypeInterface {
    private boolean mod;
    private boolean fromExternalFile;
    private AbstractBodyCoveringType coveringType;
    private AbstractRace race;
    private String transformationName;
    private boolean generic;
    private int defaultHornsPerRow;
    private String name;
    private String namePlural;
    private List<String> descriptorsMasculine;
    private List<String> descriptorsFeminine;
    private String hornTransformationDescription;
    private String hornBodyDescription;

    public AbstractHornType(AbstractBodyCoveringType coveringType, AbstractRace race, int defaultHornsPerRow, String transformationName, String name, String namePlural, List<String> descriptorsMasculine, List<String> descriptorsFeminine, String hornTransformationDescription, String hornBodyDescription) {
        this.coveringType = coveringType;
        this.race = race;
        this.transformationName = transformationName;
        this.name = name;
        this.namePlural = namePlural;
        this.generic = false;
        this.defaultHornsPerRow = defaultHornsPerRow;
        this.descriptorsMasculine = descriptorsMasculine;
        this.descriptorsFeminine = descriptorsFeminine;
        this.hornTransformationDescription = hornTransformationDescription;
        this.hornBodyDescription = hornBodyDescription;
    }

    public AbstractHornType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.race = Race.getRaceFromId(coreElement.getMandatoryFirstOf("race").getTextContent());
                this.coveringType = BodyCoveringType.getBodyCoveringTypeFromId(coreElement.getMandatoryFirstOf("coveringType").getTextContent());
                this.generic = coreElement.getOptionalFirstOf("genericType").isPresent() ? Boolean.valueOf(coreElement.getMandatoryFirstOf("genericType").getTextContent()) : false;
                this.defaultHornsPerRow = Integer.valueOf(coreElement.getMandatoryFirstOf("defaultHornsPerRow").getTextContent());
                this.transformationName = coreElement.getMandatoryFirstOf("transformationName").getTextContent();
                this.name = coreElement.getMandatoryFirstOf("name").getTextContent();
                this.namePlural = coreElement.getMandatoryFirstOf("namePlural").getTextContent();
                this.descriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsMasculine").getAllOf("descriptor")) {
                        this.descriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.descriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsFeminine").getAllOf("descriptor")) {
                        this.descriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.hornTransformationDescription = coreElement.getMandatoryFirstOf("transformationDescription").getTextContent();
                this.hornBodyDescription = coreElement.getMandatoryFirstOf("bodyDescription").getTextContent();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractAntennaType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        if (gc.getHornRows() == 1) {
            if (gc.getHornsPerRow() == 1) {
                return "\u5355\u6839";
            }
            if (gc.getHornsPerRow() == 2) {
                return "\u4e00\u5bf9";
            }
            if (gc.getHornsPerRow() == 3) {
                return "\u4e09\u6839";
            }
            return "\u56db\u6839";
        }
        if (gc.getHornsPerRow() == 1) {
            return Util.intToString(gc.getHornRows()) + "\u6839\u7ad6\u76f4\u6392\u5217\u7684";
        }
        if (gc.getHornsPerRow() == 2) {
            return Util.intToString(gc.getHornRows()) + "\u5bf9";
        }
        if (gc.getHornsPerRow() == 3) {
            return Util.intToString(gc.getHornRows()) + "\u7ec4";
        }
        return Util.intToString(gc.getHornRows()) + "\u7ec4";
    }

    public int getDefaultHornsPerRow() {
        return this.defaultHornsPerRow;
    }

    @Override
    public String getTransformationNameOverride() {
        return this.transformationName;
    }

    @Override
    public boolean isDefaultPlural(GameCharacter gc) {
        return true;
    }

    @Override
    public String getName(GameCharacter gc) {
        if (this.isDefaultPlural(gc) && (gc.getHornsPerRow() > 1 || gc.getHornRows() > 1)) {
            return this.getNamePlural(gc);
        }
        return this.getNameSingular(gc);
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.name;
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.namePlural;
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        if (gc.isFeminine()) {
            return Util.randomItemFrom(this.descriptorsFeminine);
        }
        return Util.randomItemFrom(this.descriptorsMasculine);
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(Body body) {
        return this.coveringType;
    }

    @Override
    public AbstractRace getRace() {
        return this.race;
    }

    public boolean isGeneric() {
        return this.generic;
    }

    @Override
    public TFModifier getTFModifier() {
        return this == HornType.NONE ? TFModifier.REMOVAL : this.getTFTypeModifier(HornType.getHornTypes(this.race, false));
    }

    public String getBodyDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.hornBodyDescription, new ParserTag[0]);
    }

    public String getTransformationDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.hornTransformationDescription, new ParserTag[0]);
    }
}

