/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.abstractTypes;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractTongueType;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.types.BodyPartTypeInterface;
import com.lilithsthrone.game.character.body.types.TongueType;
import com.lilithsthrone.game.character.body.valueEnums.OrificeModifier;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractMouthType
implements BodyPartTypeInterface {
    private boolean mod;
    private boolean fromExternalFile;
    private AbstractBodyCoveringType coveringType;
    private AbstractRace race;
    private AbstractTongueType tongueType;
    private List<String> names;
    private List<String> namesPlural;
    private List<String> descriptorsMasculine;
    private List<String> descriptorsFeminine;
    private List<String> lipNames;
    private List<String> lipNamesPlural;
    private boolean lipDescriptorsMasculineSizeAllowed;
    private boolean lipDescriptorsFeminineSizeAllowed;
    private List<String> lipDescriptorsMasculine;
    private List<String> lipDescriptorsFeminine;
    private String mouthBodyDescription;
    List<OrificeModifier> defaultRacialOrificeModifiers;

    public AbstractMouthType(AbstractRace race, AbstractTongueType tongueType) {
        this(BodyCoveringType.MOUTH, race, tongueType, null, null, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues("\u5634\u5507"), Util.newArrayListOfValues("\u5634\u5507"), Util.newArrayListOfValues(""), Util.newArrayListOfValues("\u67d4\u8f6f", "\u7cbe\u81f4"), null, Util.newArrayListOfValues(new OrificeModifier[0]));
    }

    public AbstractMouthType(AbstractBodyCoveringType coveringType, AbstractRace race, AbstractTongueType tongueType, List<String> names, List<String> namesPlural, List<String> descriptorsMasculine, List<String> descriptorsFeminine, List<String> lipNames, List<String> lipNamesPlural, List<String> lipDescriptorsMasculine, List<String> lipDescriptorsFeminine, String mouthBodyDescription, List<OrificeModifier> defaultRacialOrificeModifiers) {
        this.coveringType = coveringType;
        this.race = race;
        this.tongueType = tongueType;
        this.names = names;
        this.namesPlural = namesPlural;
        this.descriptorsMasculine = descriptorsMasculine;
        this.descriptorsFeminine = descriptorsFeminine;
        this.lipNames = lipNames;
        this.lipNamesPlural = lipNamesPlural;
        this.lipDescriptorsMasculineSizeAllowed = true;
        this.lipDescriptorsFeminineSizeAllowed = true;
        this.lipDescriptorsMasculine = lipDescriptorsMasculine;
        this.lipDescriptorsFeminine = lipDescriptorsFeminine;
        this.mouthBodyDescription = mouthBodyDescription == null || mouthBodyDescription.isEmpty() ? "[npc.SheHasFull]\u6709\u7740[npc.lipSize]\u3001[npc.mouthColourPrimary(true)][npc.lips]#IF(npc.isWearingLipstick())#IF(npc.isPiercedLip())\uff0c\u5df2\u7ecf\u6253\u4e0a\u7a7f\u5b54\uff0c\u5e76\u4e14#ELSE\uff0c#ENDIF\u73b0\u5728[npc.materialCompositionDescriptor]#IF(npc.isHeavyMakeup(BODY_COVERING_TYPE_MAKEUP_LIPSTICK) && game.isLipstickMarkingEnabled())[style.colourPinkDeep(\u4e00\u5c42\u6d53\u91cd\u7684)]#ENDIF[#npc.getLipstick().getFullDescription(npc, true)]\u3002#ELSE#IF(npc.isPiercedLip())\uff0c\u5df2\u7ecf\u6253\u4e0a\u7a7f\u5b54#ENDIF\u3002#ENDIF[npc.Her]\u7684\u5589\u5499\u989c\u8272\u4e3a[npc.mouthColourSecondary(true)]\u3002" : mouthBodyDescription;
        this.defaultRacialOrificeModifiers = defaultRacialOrificeModifiers == null ? new ArrayList<OrificeModifier>() : defaultRacialOrificeModifiers;
    }

    public AbstractMouthType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.race = Race.getRaceFromId(coreElement.getMandatoryFirstOf("race").getTextContent());
                this.coveringType = BodyCoveringType.getBodyCoveringTypeFromId(coreElement.getMandatoryFirstOf("coveringType").getTextContent());
                this.tongueType = TongueType.getTongueTypeFromId(coreElement.getMandatoryFirstOf("tongueType").getTextContent());
                this.names = new ArrayList<String>();
                for (Element e : coreElement.getMandatoryFirstOf("names").getAllOf("name")) {
                    this.names.add(e.getTextContent());
                }
                this.namesPlural = new ArrayList<String>();
                for (Element e : coreElement.getMandatoryFirstOf("namesPlural").getAllOf("name")) {
                    this.namesPlural.add(e.getTextContent());
                }
                this.descriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsMasculine").getAllOf("descriptor")) {
                        this.descriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.descriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsFeminine").getAllOf("descriptor")) {
                        this.descriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.lipNames = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("lipNames").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("lipNames").getAllOf("name")) {
                        this.lipNames.add(e.getTextContent());
                    }
                } else {
                    this.lipNames.add("\u5634\u5507");
                }
                this.lipNamesPlural = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("lipNamesPlural").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("lipNamesPlural").getAllOf("name")) {
                        this.lipNamesPlural.add(e.getTextContent());
                    }
                } else {
                    this.lipNamesPlural.add("\u5634\u5507");
                }
                this.lipDescriptorsMasculine = new ArrayList<String>();
                this.lipDescriptorsMasculineSizeAllowed = true;
                if (coreElement.getOptionalFirstOf("lipDescriptorsMasculine").isPresent()) {
                    this.lipDescriptorsMasculineSizeAllowed = Boolean.valueOf(coreElement.getMandatoryFirstOf("lipDescriptorsMasculine").getAttribute("allowSizeDescriptors"));
                    for (Element e : coreElement.getMandatoryFirstOf("lipDescriptorsMasculine").getAllOf("descriptor")) {
                        this.lipDescriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.lipDescriptorsFeminine = new ArrayList<String>();
                this.lipDescriptorsFeminineSizeAllowed = true;
                if (coreElement.getOptionalFirstOf("lipDescriptorsFeminine").isPresent()) {
                    this.lipDescriptorsFeminineSizeAllowed = Boolean.valueOf(coreElement.getMandatoryFirstOf("lipDescriptorsFeminine").getAttribute("allowSizeDescriptors"));
                    for (Element e : coreElement.getMandatoryFirstOf("lipDescriptorsFeminine").getAllOf("descriptor")) {
                        this.lipDescriptorsFeminine.add(e.getTextContent());
                    }
                } else {
                    this.lipDescriptorsFeminine = Util.newArrayListOfValues("soft", "delicate");
                }
                this.mouthBodyDescription = coreElement.getMandatoryFirstOf("bodyDescription").getTextContent();
                this.defaultRacialOrificeModifiers = new ArrayList<OrificeModifier>();
                if (coreElement.getOptionalFirstOf("defaultOrificeModifiers").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("defaultOrificeModifiers").getAllOf("modifier")) {
                        this.defaultRacialOrificeModifiers.add(OrificeModifier.valueOf(e.getTextContent()));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractAnusType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public AbstractTongueType getTongueType() {
        return this.tongueType;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return "";
    }

    @Override
    public boolean isDefaultPlural(GameCharacter gc) {
        return false;
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        if (this.names == null || this.names.isEmpty()) {
            return UtilText.returnStringAtRandom("\u5634\u5df4");
        }
        return Util.randomItemFrom(this.names);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        if (this.namesPlural == null || this.names.isEmpty()) {
            return UtilText.returnStringAtRandom("\u5634\u5df4");
        }
        return Util.randomItemFrom(this.namesPlural);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        if (gc.isFeminine()) {
            return Util.randomItemFrom(this.descriptorsFeminine);
        }
        return Util.randomItemFrom(this.descriptorsMasculine);
    }

    public String getLipsNameSingular(GameCharacter gc) {
        return Util.randomItemFrom(this.lipNames);
    }

    public String getLipsNamePlural(GameCharacter gc) {
        return Util.randomItemFrom(this.lipNamesPlural);
    }

    public boolean isLipsDescriptorSizeAllowed(GameCharacter gc) {
        if (gc.isFeminine()) {
            return this.lipDescriptorsFeminineSizeAllowed;
        }
        return this.lipDescriptorsMasculineSizeAllowed;
    }

    public List<String> getLipsDescriptors(GameCharacter gc) {
        if (gc.isFeminine()) {
            return this.lipDescriptorsFeminine;
        }
        return this.lipDescriptorsMasculine;
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(Body body) {
        return this.coveringType;
    }

    @Override
    public AbstractRace getRace() {
        return this.race;
    }

    public String getBodyDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.mouthBodyDescription, new ParserTag[0]);
    }

    public List<OrificeModifier> getDefaultRacialOrificeModifiers() {
        return this.defaultRacialOrificeModifiers;
    }
}

