/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.abstractTypes;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.tags.BodyPartTag;
import com.lilithsthrone.game.character.body.types.BodyPartTypeInterface;
import com.lilithsthrone.game.character.body.types.TailType;
import com.lilithsthrone.game.character.body.valueEnums.PenetrationGirth;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractTailType
implements BodyPartTypeInterface {
    private boolean mod;
    private boolean fromExternalFile;
    private AbstractBodyCoveringType coveringType;
    private AbstractRace race;
    private String transformationName;
    private int defaultGirth;
    private float defaultLengthAsPercentageOfHeight;
    private String determiner;
    private String determinerPlural;
    private String name;
    private String namePlural;
    private List<String> descriptorsMasculine;
    private List<String> descriptorsFeminine;
    private String tipName;
    private String tipNamePlural;
    private List<String> tipDescriptorsMasculine;
    private List<String> tipDescriptorsFeminine;
    private String tailTransformationDescription;
    private String tailBodyDescription;
    private List<BodyPartTag> tags;
    private boolean spinneret;

    public AbstractTailType(AbstractBodyCoveringType coveringType, AbstractRace race, PenetrationGirth defaultGirth, float defaultLengthAsPercentageOfHeight, String transformationName, String determiner, String determinerPlural, String name, String namePlural, List<String> descriptorsMasculine, List<String> descriptorsFeminine, String tipName, String tipNamePlural, List<String> tipDescriptorsMasculine, List<String> tipDescriptorsFeminine, String tailTransformationDescription, String tailBodyDescription, List<BodyPartTag> tags, boolean spinneret) {
        this.coveringType = coveringType;
        this.race = race;
        this.defaultGirth = defaultGirth.getValue();
        this.defaultLengthAsPercentageOfHeight = defaultLengthAsPercentageOfHeight;
        this.transformationName = transformationName;
        this.determiner = determiner;
        this.determinerPlural = determinerPlural;
        this.name = name;
        this.namePlural = namePlural;
        this.descriptorsMasculine = descriptorsMasculine;
        this.descriptorsFeminine = descriptorsFeminine;
        this.tipName = tipName;
        this.tipNamePlural = tipNamePlural;
        this.tipDescriptorsMasculine = tipDescriptorsMasculine;
        this.tipDescriptorsFeminine = tipDescriptorsFeminine;
        this.tailTransformationDescription = tailTransformationDescription;
        this.tailBodyDescription = tailBodyDescription;
        this.tags = tags;
        this.spinneret = spinneret;
    }

    public AbstractTailType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.race = Race.getRaceFromId(coreElement.getMandatoryFirstOf("race").getTextContent());
                this.coveringType = BodyCoveringType.getBodyCoveringTypeFromId(coreElement.getMandatoryFirstOf("coveringType").getTextContent());
                this.transformationName = coreElement.getMandatoryFirstOf("transformationName").getTextContent();
                this.spinneret = Boolean.valueOf(coreElement.getMandatoryFirstOf("spinneret").getTextContent());
                this.defaultGirth = Integer.valueOf(coreElement.getMandatoryFirstOf("defaultGirth").getTextContent());
                this.defaultLengthAsPercentageOfHeight = Float.valueOf(coreElement.getMandatoryFirstOf("defaultLengthAsPercentageOfHeight").getTextContent()).floatValue();
                this.tags = new ArrayList<BodyPartTag>();
                if (coreElement.getOptionalFirstOf("tags").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("tags").getAllOf("tag")) {
                        this.tags.add(BodyPartTag.getBodyPartTagFromId(e.getTextContent()));
                    }
                }
                if (this.tags.isEmpty()) {
                    this.tags.add(BodyPartTag.TAIL_TYPE_GENERIC);
                    this.tags.add(BodyPartTag.TAIL_TAPERING_NONE);
                }
                this.determiner = coreElement.getMandatoryFirstOf("determiner").getTextContent();
                this.determinerPlural = coreElement.getMandatoryFirstOf("determinerPlural").getTextContent();
                this.name = coreElement.getMandatoryFirstOf("name").getTextContent();
                this.namePlural = coreElement.getMandatoryFirstOf("namePlural").getTextContent();
                this.descriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsMasculine").getAllOf("descriptor")) {
                        this.descriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.descriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsFeminine").getAllOf("descriptor")) {
                        this.descriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.tipName = coreElement.getMandatoryFirstOf("tipName").getTextContent();
                this.tipNamePlural = coreElement.getMandatoryFirstOf("tipNamePlural").getTextContent();
                this.tipDescriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("tipDescriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("tipDescriptorsMasculine").getAllOf("descriptor")) {
                        this.tipDescriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.tipDescriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("tipDescriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("tipDescriptorsFeminine").getAllOf("descriptor")) {
                        this.tipDescriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.tailTransformationDescription = coreElement.getMandatoryFirstOf("transformationDescription").getTextContent();
                this.tailBodyDescription = coreElement.getMandatoryFirstOf("bodyDescription").getTextContent();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractTailType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public int getDefaultGirth() {
        return this.defaultGirth;
    }

    public float getDefaultLengthAsPercentageOfHeight() {
        return this.defaultLengthAsPercentageOfHeight;
    }

    @Override
    public List<BodyPartTag> getTags() {
        return this.tags;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        if (gc == null) {
            return "";
        }
        if (gc.getTailCount() == 1) {
            return Util.intToString(gc.getTailCount()) + "\u6839";
        }
        return Util.intToString(gc.getTailCount()) + "\u6839";
    }

    @Override
    public String getTransformationNameOverride() {
        return this.transformationName;
    }

    @Override
    public boolean isDefaultPlural(GameCharacter gc) {
        return false;
    }

    @Override
    public String getName(GameCharacter gc) {
        if (this.isDefaultPlural(gc) || gc != null && gc.getTailCount() != 1) {
            return this.getNamePlural(gc);
        }
        return this.getNameSingular(gc);
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.name;
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.namePlural;
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        if (gc.isFeminine()) {
            return Util.randomItemFrom(this.descriptorsFeminine);
        }
        return Util.randomItemFrom(this.descriptorsMasculine);
    }

    public String getTailTipNameSingular(GameCharacter gc) {
        return this.tipName;
    }

    public String getTailTipNamePlural(GameCharacter gc) {
        return this.tipNamePlural;
    }

    public String getTailTipDescriptor(GameCharacter gc) {
        if (gc.isFeminine()) {
            return Util.randomItemFrom(this.tipDescriptorsFeminine);
        }
        return Util.randomItemFrom(this.tipDescriptorsMasculine);
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(Body body) {
        return this.coveringType;
    }

    @Override
    public AbstractRace getRace() {
        return this.race;
    }

    public String getBodyDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.tailBodyDescription, new ParserTag[0]);
    }

    public String getTransformationDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.tailTransformationDescription, new ParserTag[0]);
    }

    public String getGirthDescription(GameCharacter owner) {
        StringBuilder sb = new StringBuilder();
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_SKIN) || this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_SCALES)) {
            if (owner.getTailCount() > 1) {
                sb.append(UtilText.parse(owner, "[npc.Her]\u7684\u5c3e\u5df4", new ParserTag[0]));
            } else {
                sb.append(UtilText.parse(owner, "[npc.Her]\u7684\u5c3e\u5df4", new ParserTag[0]));
            }
            switch (owner.getTailGirth()) {
                case ZERO_THIN: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u975e\u5e38\u7ea4\u7ec6<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case ONE_SLENDER: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u5341\u5206\u4fee\u957f<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case TWO_NARROW: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u6bd4\u8f83\u7ec6<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case THREE_AVERAGE: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u7c97\u7ec6\u9002\u4e2d<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case FOUR_GIRTHY: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u6bd4\u8f83\u7c97\u5927<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case FIVE_THICK: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u5341\u5206\u7c97\u58ee<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case SIX_CHUBBY: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u683c\u5916\u7c97\u58ee<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case SEVEN_FAT: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u6781\u5176\u7c97\u58ee<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                }
            }
        }
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_FUR)) {
            if (owner.getTailCount() > 1) {
                sb.append(UtilText.parse(owner, "[npc.Her]\u7684\u5c3e\u5df4", new ParserTag[0]));
            } else {
                sb.append(UtilText.parse(owner, "[npc.Her]\u7684\u5c3e\u5df4", new ParserTag[0]));
            }
            switch (owner.getTailGirth()) {
                case ZERO_THIN: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u975e\u5e38\u7ea4\u7ec6\u4e5f\u6ca1\u4ec0\u4e48\u7ed2\u6bdb<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case ONE_SLENDER: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u6bd4\u8f83\u4fee\u957f\uff0c\u7ed2\u6bdb\u4e5f\u4e0d\u591a<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case TWO_NARROW: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u6bd4\u8f83\u7ec6\uff0c\u76f8\u6bd4\u4e8e\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u7ed2\u6bdb\u7a0d\u5c11\u3002<colourEnd>", new ParserTag[0]));
                    break;
                }
                case THREE_AVERAGE: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u7c97\u7ec6\u5408\u9002\uff0c\u548c\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u7ed2\u6bdb\u5dee\u4e0d\u591a\u6d53\u5bc6\u3002<colourEnd>", new ParserTag[0]));
                    break;
                }
                case FOUR_GIRTHY: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u76f8\u5f53\u84ec\u677e\uff0c\u76f8\u6bd4\u4e8e\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u5f88\u591a\u6bdb\u3002<colourEnd>", new ParserTag[0]));
                    break;
                }
                case FIVE_THICK: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u5341\u5206\u7c97\u58ee\uff0c\u76f8\u6bd4\u4e8e\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u66f4\u677e\u8f6f\u3002<colourEnd>", new ParserTag[0]));
                    break;
                }
                case SIX_CHUBBY: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u96be\u4ee5\u7f6e\u4fe1\u7684\u84ec\u677e\uff0c\u76f8\u6bd4\u4e8e\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u66f4\u677e\u8f6f\u3002<colourEnd>", new ParserTag[0]));
                    break;
                }
                case SEVEN_FAT: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u6781\u5176\u84ec\u677e\uff0c\u76f8\u6bd4\u4e8e\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u66f4\u677e\u8f6f\u3002<colourEnd>", new ParserTag[0]));
                }
            }
        }
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_TUFT)) {
            if (owner.getTailCount() > 1) {
                sb.append(UtilText.parse(owner, "[npc.Her]\u7c07\u6bdb\u7684\u5c3e\u5df4", new ParserTag[0]));
            } else {
                sb.append(UtilText.parse(owner, "[npc.Her]\u7c07\u6bdb\u7684\u5c3e\u5df4", new ParserTag[0]));
            }
            switch (owner.getTailGirth()) {
                case ZERO_THIN: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u975e\u5e38\u7ec6\u5c0f\uff0c\u76f8\u6bd4\u4e8e\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u7ed2\u6bdb\u4e0d\u591a\u3002<colourEnd>", new ParserTag[0]));
                    break;
                }
                case ONE_SLENDER: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u76f8\u5f53\u5c0f\uff0c\u76f8\u6bd4\u4e8e\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u7ed2\u6bdb\u4e0d\u591a\u3002<colourEnd>", new ParserTag[0]));
                    break;
                }
                case TWO_NARROW: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u6709\u70b9\u5c0f\uff0c\u76f8\u6bd4\u4e8e\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u7ed2\u6bdb\u4e0d\u591a\u3002<colourEnd>", new ParserTag[0]));
                    break;
                }
                case THREE_AVERAGE: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u5927\u5c0f\u9002\u4e2d\uff0c\u548c\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u5dee\u4e0d\u591a\u84ec\u677e\u3002<colourEnd>", new ParserTag[0]));
                    break;
                }
                case FOUR_GIRTHY: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u76f8\u5f53\u84ec\u677e\uff0c\u76f8\u6bd4\u4e8e\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u5f88\u591a\u6bdb\u3002<colourEnd>", new ParserTag[0]));
                    break;
                }
                case FIVE_THICK: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u5341\u5206\u84ec\u677e\uff0c\u76f8\u6bd4\u4e8e\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u975e\u5e38\u84ec\u677e\u3002<colourEnd>", new ParserTag[0]));
                    break;
                }
                case SIX_CHUBBY: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u96be\u4ee5\u7f6e\u4fe1\u7684\u84ec\u677e\uff0c\u76f8\u6bd4\u4e8e\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u66f4\u677e\u8f6f\u3002<colourEnd>", new ParserTag[0]));
                    break;
                }
                case SEVEN_FAT: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u6781\u5176\u84ec\u677e\uff0c\u76f8\u6bd4\u4e8e\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u66f4\u677e\u8f6f\u3002<colourEnd>", new ParserTag[0]));
                }
            }
        }
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_HAIR)) {
            if (owner.getTailCount() > 1) {
                sb.append(UtilText.parse(owner, "[npc.Her]\u7684\u9a6c\u5c3e\u5df4", new ParserTag[0]));
            } else {
                sb.append(UtilText.parse(owner, "[npc.Her]\u7684\u9a6c\u5c3e\u5df4", new ParserTag[0]));
            }
            switch (owner.getTailGirth()) {
                case ZERO_THIN: {
                    sb.append(UtilText.parse(owner, "\u4e0e[npc.her]\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u76f8\u6bd4\uff0c<colourStart>\u663e\u5f97\u592a\u5c0f\u4e86\u3002<colourEnd>", new ParserTag[0]));
                    break;
                }
                case ONE_SLENDER: {
                    sb.append(UtilText.parse(owner, "\u4e0e[npc.her]\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u76f8\u6bd4\uff0c<colourStart>\u663e\u5f97\u5f88\u5c0f\u3002<colourEnd>", new ParserTag[0]));
                    break;
                }
                case TWO_NARROW: {
                    sb.append(UtilText.parse(owner, "\u4e0e[npc.her]\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u76f8\u6bd4\uff0c<colourStart>\u5c31\u663e\u5f97\u6709\u70b9\u5c0f\u4e86\u3002<colourEnd>", new ParserTag[0]));
                    break;
                }
                case THREE_AVERAGE: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u5927\u5c0f\u9002\u4e2d<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case FOUR_GIRTHY: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u76f8\u5f53\u4e30\u6ee1<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case FIVE_THICK: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u975e\u5e38\u4e30\u6ee1<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case SIX_CHUBBY: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u96be\u4ee5\u7f6e\u4fe1\u7684\u4e30\u6ee1<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case SEVEN_FAT: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u8d85\u7ea7\u4e30\u6ee1<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                }
            }
        }
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_FEATHER)) {
            if (owner.getTailCount() > 1) {
                sb.append(UtilText.parse(owner, "[npc.Her]\u7684\u7fce\u6bdb", new ParserTag[0]));
            } else {
                sb.append(UtilText.parse(owner, "[npc.Her]\u7684\u7fce\u6bdb", new ParserTag[0]));
            }
            switch (owner.getTailGirth()) {
                case ZERO_THIN: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u975e\u5e38\u5c0f\u800c\u4e14\u7f3a\u5c11\u4f53\u79ef\u611f<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case ONE_SLENDER: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u5f88\u5c0f\u800c\u4e14\u6709\u4e9b\u7f3a\u5c11\u4f53\u79ef\u611f<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case TWO_NARROW: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u6709\u4e9b\u7ec6\u800c\u4e14\u7f3a\u5c11\u4f53\u79ef\u611f<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case THREE_AVERAGE: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u5c3a\u5bf8\u548c\u5927\u5c0f\u90fd\u9002\u4e2d<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case FOUR_GIRTHY: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u76f8\u5f53\u5927\u800c\u4e14\u5f88\u677e<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case FIVE_THICK: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u975e\u5e38\u5927\u800c\u4e14\u5f88\u677e<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case SIX_CHUBBY: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u96be\u4ee5\u7f6e\u4fe1\u7684\u4e30\u6ee1<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case SEVEN_FAT: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u8d85\u7ea7\u4e30\u6ee1<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                }
            }
        }
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_GENERIC)) {
            if (owner.getTailCount() > 1) {
                sb.append(UtilText.parse(owner, "[npc.Her]\u7684\u5c3e\u5df4", new ParserTag[0]));
            } else {
                sb.append(UtilText.parse(owner, "[npc.Her]\u7684\u5c3e\u5df4", new ParserTag[0]));
            }
            switch (owner.getTailGirth()) {
                case ZERO_THIN: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u975e\u5e38\u7ea4\u7ec6<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case ONE_SLENDER: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u6709\u70b9\u7ea4\u7ec6<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case TWO_NARROW: {
                    sb.append(UtilText.parse(owner, " <colourStart>\u6709\u70b9\u7ec6<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case THREE_AVERAGE: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u7c97\u7ec6\u9002\u4e2d<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case FOUR_GIRTHY: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u6bd4\u8f83\u5927<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case FIVE_THICK: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u975e\u5e38\u5927<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case SIX_CHUBBY: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u683c\u5916\u7c97\u5927<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case SEVEN_FAT: {
                    sb.append(UtilText.parse(owner, "<colourStart>\u8d85\u7ea7\u7c97\u5927<colourEnd>\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                }
            }
        }
        String returnString = sb.toString();
        String colourStartTag = "<span style='color:" + owner.getTailGirth().getColour().toWebHexString() + ";'>";
        String colourEndTag = "</span>";
        returnString = returnString.replaceAll("<colourStart>", colourStartTag);
        returnString = returnString.replaceAll("<colourEnd>", colourEndTag);
        return returnString;
    }

    public String getGirthDescriptor(GameCharacter owner) {
        return this.getGirthDescriptor(owner.getTailGirth());
    }

    public String getGirthDescriptor(Body body) {
        return this.getGirthDescriptor(body.getTail().getGirth());
    }

    public String getGirthDescriptor(PenetrationGirth girth) {
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_SKIN) || this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_SCALES)) {
            switch (girth) {
                case ZERO_THIN: {
                    return "\u7ea4\u7ec6";
                }
                case ONE_SLENDER: {
                    return "\u4fee\u957f";
                }
                case TWO_NARROW: {
                    return "\u7ec6\u7a84";
                }
                case THREE_AVERAGE: {
                    return "\u9002\u4e2d";
                }
                case FOUR_GIRTHY: {
                    return "\u8f83\u7c97";
                }
                case FIVE_THICK: {
                    return "\u7c97\u58ee";
                }
                case SIX_CHUBBY: {
                    return "\u6781\u7c97";
                }
                case SEVEN_FAT: {
                    return "\u7c97\u5230\u79bb\u8c31";
                }
            }
        }
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_FUR)) {
            switch (girth) {
                case ZERO_THIN: {
                    return "\u7ea4\u7ec6";
                }
                case ONE_SLENDER: {
                    return "\u4fee\u957f";
                }
                case TWO_NARROW: {
                    return "\u7ec6\u7a84";
                }
                case THREE_AVERAGE: {
                    return "\u6bdb\u8338\u8338";
                }
                case FOUR_GIRTHY: {
                    return "\u677e\u8f6f";
                }
                case FIVE_THICK: {
                    return "\u5f88\u677e\u8f6f";
                }
                case SIX_CHUBBY: {
                    return "\u6781\u5176\u677e\u8f6f";
                }
                case SEVEN_FAT: {
                    return "\u677e\u8f6f\u5230\u79bb\u8c31";
                }
            }
        }
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_TUFT)) {
            switch (girth) {
                case ZERO_THIN: {
                    return "\u5a07\u5c0f";
                }
                case ONE_SLENDER: {
                    return "\u8f83\u5c0f";
                }
                case TWO_NARROW: {
                    return "\u7ec6\u7a84";
                }
                case THREE_AVERAGE: {
                    return "\u6bdb\u8338\u8338";
                }
                case FOUR_GIRTHY: {
                    return "\u677e\u8f6f";
                }
                case FIVE_THICK: {
                    return "\u5f88\u677e\u8f6f";
                }
                case SIX_CHUBBY: {
                    return "\u6781\u5176\u677e\u8f6f";
                }
                case SEVEN_FAT: {
                    return "\u677e\u8f6f\u5230\u79bb\u8c31";
                }
            }
        }
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_HAIR)) {
            switch (girth) {
                case ZERO_THIN: {
                    return "\u7ea4\u7ec6";
                }
                case ONE_SLENDER: {
                    return "\u8f83\u5c0f";
                }
                case TWO_NARROW: {
                    return "\u7ec6\u7a84";
                }
                case THREE_AVERAGE: {
                    return "\u9002\u4e2d";
                }
                case FOUR_GIRTHY: {
                    return "\u84ec\u677e";
                }
                case FIVE_THICK: {
                    return "\u683c\u5916\u84ec\u677e";
                }
                case SIX_CHUBBY: {
                    return "\u5f02\u5e38\u84ec\u677e";
                }
                case SEVEN_FAT: {
                    return "\u84ec\u5230\u79bb\u8c31";
                }
            }
        }
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_FEATHER)) {
            switch (girth) {
                case ZERO_THIN: {
                    return "\u7ea4\u7ec6";
                }
                case ONE_SLENDER: {
                    return "\u8f83\u5c0f";
                }
                case TWO_NARROW: {
                    return "\u7ec6\u7a84";
                }
                case THREE_AVERAGE: {
                    return "\u9002\u4e2d";
                }
                case FOUR_GIRTHY: {
                    return "\u5e9e\u5927";
                }
                case FIVE_THICK: {
                    return "\u683c\u5916\u5e9e\u5927";
                }
                case SIX_CHUBBY: {
                    return "\u5f02\u5e38\u5e9e\u5927";
                }
                case SEVEN_FAT: {
                    return "\u5927\u5230\u79bb\u8c31";
                }
            }
        }
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_GENERIC)) {
            switch (girth) {
                case ZERO_THIN: {
                    return "\u5a07\u5c0f";
                }
                case ONE_SLENDER: {
                    return "\u8f83\u5c0f";
                }
                case TWO_NARROW: {
                    return "\u7ec6\u7a84";
                }
                case THREE_AVERAGE: {
                    return "\u9002\u4e2d";
                }
                case FOUR_GIRTHY: {
                    return "\u5927";
                }
                case FIVE_THICK: {
                    return "\u5e9e\u5927";
                }
                case SIX_CHUBBY: {
                    return "\u5de8\u5927";
                }
                case SEVEN_FAT: {
                    return "\u5927\u5f97\u79bb\u8c31";
                }
            }
        }
        return girth.getName();
    }

    public String getGirthTransformationDescription(GameCharacter owner, boolean positive) {
        String tailText = "[npc.a_tailGirth][npc.tail]";
        if (owner.getTailCount() > 1) {
            tailText = "[npc.tailGirth][npc.tails]";
        }
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_SKIN) || this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_SCALES) || this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_FUR)) {
            if (positive) {
                return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tails]\u7a81\u7136[style.boldGrow(\u53d8\u7c97\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u53d8\u7c97\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric(" + tailText + ")]\u4e86\uff01</p>", new ParserTag[0]);
            }
            return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tails]\u7a81\u7136[style.boldGrow(\u53d8\u7ec6\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u53d8\u7ec6\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric(" + tailText + ")]\u4e86\uff01</p>", new ParserTag[0]);
        }
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_TUFT)) {
            if (positive) {
                return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tails]\u7a81\u7136[style.boldGrow(\u53d8\u5f97\u66f4\u52a0\u84ec\u677e\u548c\u7c97\u5927\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u53d8\u5f97\u66f4\u52a0\u84ec\u677e\u548c\u7c97\u5927\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric(" + tailText + ")]\u4e86\uff01</p>", new ParserTag[0]);
            }
            return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tails]\u7a81\u7136[style.boldGrow(\u53d8\u7ec6\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u53d8\u7ec6\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric(" + tailText + ")]\u4e86\uff01</p>", new ParserTag[0]);
        }
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_HAIR)) {
            if (positive) {
                return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tails]\u7a81\u7136[style.boldGrow(\u81a8\u80c0\uff0c\u53d8\u5f97\u66f4\u7c97\u5927\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u81a8\u80c0\uff0c\u53d8\u5f97\u66f4\u7c97\u5927\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric(" + tailText + ")]\u4e86\uff01</p>", new ParserTag[0]);
            }
            return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tails]\u7a81\u7136[style.boldGrow(\u53d8\u7ec6\uff0c\u4f53\u79ef\u4e5f\u7f29\u5c0f\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u53d8\u7ec6\uff0c\u4f53\u79ef\u4e5f\u7f29\u5c0f\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric(" + tailText + ")]\u4e86\uff01</p>", new ParserTag[0]);
        }
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_FEATHER)) {
            if (positive) {
                return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tails]\u7a81\u7136[style.boldGrow(\u81a8\u80c0\uff0c\u53d8\u5f97\u66f4\u7c97\u5927\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u81a8\u80c0\uff0c\u53d8\u5f97\u66f4\u7c97\u5927\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric(" + tailText + ")]\u4e86\uff01</p>", new ParserTag[0]);
            }
            return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tails]\u7a81\u7136[style.boldGrow(\u53d8\u7ec6\uff0c\u4f53\u79ef\u4e5f\u7f29\u5c0f\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u53d8\u7ec6\uff0c\u4f53\u79ef\u4e5f\u7f29\u5c0f\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric(" + tailText + ")]\u4e86\uff01</p>", new ParserTag[0]);
        }
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_GENERIC)) {
            if (positive) {
                return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tails]\u7a81\u7136[style.boldGrow(\u53d8\u5927\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u53d8\u5927\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric(" + tailText + ")]\u4e86\uff01</p>", new ParserTag[0]);
            }
            return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tail]\u7a81\u7136[style.boldShrink(\u53d8\u7ec6\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u53d8\u7ec6\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric(" + tailText + ")]\u4e86\uff01</p>", new ParserTag[0]);
        }
        return "";
    }

    public String getLengthTransformationDescription(GameCharacter owner, boolean positive) {
        String heightPercentageDescription = " (\u957f\u5ea6\u4e3a[npc.namePos]\u8eab\u9ad8\u7684" + (int)(owner.getTailLengthAsPercentageOfHeight() * 100.0f) + "%)";
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_SKIN) || this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_SCALES) || this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_FUR)) {
            if (positive) {
                return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tails]\u7a81\u7136[style.boldGrow(\u53d8\u957f\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u53d8\u957f\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric([npc.a_tailLength][npc.tail])]" + heightPercentageDescription + "\uff01</p>", new ParserTag[0]);
            }
            return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tails]\u7a81\u7136[style.boldGrow(\u53d8\u77ed\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u53d8\u77ed\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric([npc.a_tailLength][npc.tail])]" + heightPercentageDescription + "\uff01</p>", new ParserTag[0]);
        }
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_TUFT)) {
            if (positive) {
                return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tails]\u7a81\u7136[style.boldGrow(\u53d8\u5f97\u66f4\u52a0\u84ec\u677e\uff0c\u4e14\u66f4\u957f\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u53d8\u5f97\u66f4\u52a0\u84ec\u677e\uff0c\u4e14\u66f4\u957f\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric([npc.a_tailLength][npc.tail])]" + heightPercentageDescription + "\uff01</p>", new ParserTag[0]);
            }
            return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tails]\u7a81\u7136[style.boldGrow(\u53d8\u77ed\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u53d8\u77ed\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric([npc.a_tailLength][npc.tail])]" + heightPercentageDescription + "\uff01</p>", new ParserTag[0]);
        }
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_HAIR)) {
            if (positive) {
                return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tails]\u7a81\u7136[style.boldGrow(\u53d8\u957f\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u53d8\u957f\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric([npc.a_tailLength][npc.tail])]" + heightPercentageDescription + "\uff01</p>", new ParserTag[0]);
            }
            return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tails]\u7a81\u7136[style.boldGrow(\u53d8\u77ed\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u53d8\u77ed\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric([npc.a_tailLength][npc.tail])]" + heightPercentageDescription + "\uff01</p>", new ParserTag[0]);
        }
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_FEATHER)) {
            if (positive) {
                return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tails]\u7a81\u7136[style.boldGrow(\u53d8\u957f\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u53d8\u957f\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric([npc.a_tailLength][npc.tail])]" + heightPercentageDescription + "\uff01</p>", new ParserTag[0]);
            }
            return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tails]\u7a81\u7136[style.boldGrow(\u53d8\u77ed\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u53d8\u77ed\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric([npc.a_tailLength][npc.tail])]" + heightPercentageDescription + "\uff01</p>", new ParserTag[0]);
        }
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_GENERIC)) {
            if (positive) {
                return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tails]\u7a81\u7136[style.boldGrow(\u53d8\u957f\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u53d8\u957f\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric([npc.a_tailLength][npc.tail])]" + heightPercentageDescription + "\uff01</p>", new ParserTag[0]);
            }
            return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684\u810a\u67f1\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTailCount() > 1 ? "[npc.tails]\u7a81\u7136[style.boldGrow(\u53d8\u77ed\u4e86)]\u3002" : "[npc.tail]\u7a81\u7136[style.boldGrow(\u53d8\u77ed\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric([npc.a_tailLength][npc.tail])]" + heightPercentageDescription + "\uff01</p>", new ParserTag[0]);
        }
        return "";
    }

    public boolean isPrehensile() {
        return this.tags.contains((Object)BodyPartTag.TAIL_PREHENSILE);
    }

    public boolean isSuitableForSleepHugging() {
        return this.tags.contains((Object)BodyPartTag.TAIL_SLEEP_HUGGING);
    }

    public boolean isSuitableForAttack() {
        return this.tags.contains((Object)BodyPartTag.TAIL_ATTACK);
    }

    public boolean isOvipositor() {
        return this.tags.contains((Object)BodyPartTag.TAIL_OVIPOSITOR);
    }

    @Override
    public TFModifier getTFModifier() {
        return this == TailType.NONE ? TFModifier.REMOVAL : this.getTFTypeModifier(TailType.getTailTypes(this.race));
    }

    public boolean hasSpinneret() {
        return this.spinneret;
    }
}

