/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.abstractTypes;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.tags.BodyPartTag;
import com.lilithsthrone.game.character.body.types.BodyPartTypeInterface;
import com.lilithsthrone.game.character.body.types.TentacleType;
import com.lilithsthrone.game.character.body.valueEnums.PenetrationGirth;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractTentacleType
implements BodyPartTypeInterface {
    private boolean mod;
    private boolean fromExternalFile;
    private AbstractBodyCoveringType coveringType;
    private AbstractRace race;
    private String transformationName;
    private int defaultGirth;
    private float defaultLengthAsPercentageOfHeight;
    private String determiner;
    private String determinerPlural;
    private String name;
    private String namePlural;
    private List<String> descriptorsMasculine;
    private List<String> descriptorsFeminine;
    private String tipName;
    private String tipNamePlural;
    private List<String> tipDescriptorsMasculine;
    private List<String> tipDescriptorsFeminine;
    private String tentacleTransformationDescription;
    private String tentacleBodyDescription;
    private List<BodyPartTag> tags;

    public AbstractTentacleType(AbstractBodyCoveringType coveringType, AbstractRace race, PenetrationGirth defaultGirth, float defaultLengthAsPercentageOfHeight, String transformationName, String determiner, String determinerPlural, String name, String namePlural, List<String> descriptorsMasculine, List<String> descriptorsFeminine, String tipName, String tipNamePlural, List<String> tipDescriptorsMasculine, List<String> tipDescriptorsFeminine, String tentacleTransformationDescription, String tentacleBodyDescription, List<BodyPartTag> tags) {
        this.coveringType = coveringType;
        this.race = race;
        this.defaultGirth = defaultGirth.getValue();
        this.defaultLengthAsPercentageOfHeight = defaultLengthAsPercentageOfHeight;
        this.transformationName = transformationName;
        this.determiner = determiner;
        this.determinerPlural = determinerPlural;
        this.name = name;
        this.namePlural = namePlural;
        this.descriptorsMasculine = descriptorsMasculine;
        this.descriptorsFeminine = descriptorsFeminine;
        this.tipName = tipName;
        this.tipNamePlural = tipNamePlural;
        this.tipDescriptorsMasculine = tipDescriptorsMasculine;
        this.tipDescriptorsFeminine = tipDescriptorsFeminine;
        this.tentacleTransformationDescription = tentacleTransformationDescription;
        this.tentacleBodyDescription = tentacleBodyDescription;
        this.tags = tags;
    }

    public AbstractTentacleType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.race = Race.getRaceFromId(coreElement.getMandatoryFirstOf("race").getTextContent());
                this.coveringType = BodyCoveringType.getBodyCoveringTypeFromId(coreElement.getMandatoryFirstOf("coveringType").getTextContent());
                this.transformationName = coreElement.getMandatoryFirstOf("transformationName").getTextContent();
                this.defaultGirth = Integer.valueOf(coreElement.getMandatoryFirstOf("defaultGirth").getTextContent());
                this.defaultLengthAsPercentageOfHeight = Float.valueOf(coreElement.getMandatoryFirstOf("defaultLengthAsPercentageOfHeight").getTextContent()).floatValue();
                this.tags = new ArrayList<BodyPartTag>();
                if (coreElement.getOptionalFirstOf("tags").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("tags").getAllOf("tag")) {
                        this.tags.add(BodyPartTag.getBodyPartTagFromId(e.getTextContent()));
                    }
                }
                if (this.tags.isEmpty()) {
                    this.tags.add(BodyPartTag.TAIL_TYPE_GENERIC);
                    this.tags.add(BodyPartTag.TAIL_TAPERING_NONE);
                }
                this.determiner = coreElement.getMandatoryFirstOf("determiner").getTextContent();
                this.determinerPlural = coreElement.getMandatoryFirstOf("determinerPlural").getTextContent();
                this.name = coreElement.getMandatoryFirstOf("name").getTextContent();
                this.namePlural = coreElement.getMandatoryFirstOf("namePlural").getTextContent();
                this.descriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsMasculine").getAllOf("descriptor")) {
                        this.descriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.descriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsFeminine").getAllOf("descriptor")) {
                        this.descriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.tipName = coreElement.getMandatoryFirstOf("tipName").getTextContent();
                this.tipNamePlural = coreElement.getMandatoryFirstOf("tipNamePlural").getTextContent();
                this.tipDescriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("tipDescriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("tipDescriptorsMasculine").getAllOf("descriptor")) {
                        this.tipDescriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.tipDescriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("tipDescriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("tipDescriptorsFeminine").getAllOf("descriptor")) {
                        this.tipDescriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.tentacleTransformationDescription = coreElement.getMandatoryFirstOf("transformationDescription").getTextContent();
                this.tentacleBodyDescription = coreElement.getMandatoryFirstOf("bodyDescription").getTextContent();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractTentacleType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public int getDefaultGirth() {
        return this.defaultGirth;
    }

    public float getDefaultLengthAsPercentageOfHeight() {
        return this.defaultLengthAsPercentageOfHeight;
    }

    @Override
    public List<BodyPartTag> getTags() {
        return this.tags;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        if (gc == null) {
            return "";
        }
        if (gc.getTentacleCount() == 1) {
            return Util.intToString(gc.getTentacleCount()) + "\u6839";
        }
        return Util.intToString(gc.getTentacleCount()) + "\u6839";
    }

    @Override
    public String getTransformationNameOverride() {
        return this.transformationName;
    }

    @Override
    public boolean isDefaultPlural(GameCharacter gc) {
        return false;
    }

    @Override
    public String getName(GameCharacter gc) {
        if (this.isDefaultPlural(gc) || gc != null && gc.getTentacleCount() != 1) {
            return this.getNamePlural(gc);
        }
        return this.getNameSingular(gc);
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.name;
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.namePlural;
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        if (gc.isFeminine()) {
            return Util.randomItemFrom(this.descriptorsFeminine);
        }
        return Util.randomItemFrom(this.descriptorsMasculine);
    }

    public String getTentacleTipNameSingular(GameCharacter gc) {
        return this.tipName;
    }

    public String getTentacleTipNamePlural(GameCharacter gc) {
        return this.tipNamePlural;
    }

    public String getTentacleTipDescriptor(GameCharacter gc) {
        if (gc.isFeminine()) {
            return Util.randomItemFrom(this.tipDescriptorsFeminine);
        }
        return Util.randomItemFrom(this.tipDescriptorsMasculine);
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(Body body) {
        return this.coveringType;
    }

    @Override
    public AbstractRace getRace() {
        return this.race;
    }

    public String getBodyDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.tentacleBodyDescription, new ParserTag[0]);
    }

    public String getTransformationDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.tentacleTransformationDescription, new ParserTag[0]);
    }

    public String getGirthDescription(GameCharacter owner) {
        StringBuilder sb = new StringBuilder();
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_FUR)) {
            if (owner.getTentacleCount() > 1) {
                sb.append(UtilText.parse(owner, "[npc.Her]\u7684[npc.tentacles]", new ParserTag[0]));
            } else {
                sb.append(UtilText.parse(owner, "[npc.Her]\u7684[npc.tentacle]", new ParserTag[0]));
            }
            switch (owner.getTentacleGirth()) {
                case ZERO_THIN: {
                    sb.append(UtilText.parse(owner, "\u975e\u5e38\u7ea4\u7ec6\uff0c\u76f8\u6bd4\u4e8e\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u663e\u5f97\u6ca1\u4ec0\u4e48\u7ed2\u6bdb\u3002", new ParserTag[0]));
                    break;
                }
                case ONE_SLENDER: {
                    sb.append(UtilText.parse(owner, "\u6bd4\u8f83\u4fee\u957f\uff0c\u76f8\u6bd4\u4e8e\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u7ed2\u6bdb\u4e0d\u591a\u3002", new ParserTag[0]));
                    break;
                }
                case TWO_NARROW: {
                    sb.append(UtilText.parse(owner, "\u6bd4\u8f83\u7ec6\uff0c\u76f8\u6bd4\u4e8e\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u7ed2\u6bdb\u7a0d\u5c11\u3002", new ParserTag[0]));
                    break;
                }
                case THREE_AVERAGE: {
                    sb.append(UtilText.parse(owner, "\u5bbd\u5ea6\u5408\u9002\uff0c\u548c\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u5dee\u4e0d\u591a\u84ec\u677e\u3002", new ParserTag[0]));
                    break;
                }
                case FOUR_GIRTHY: {
                    sb.append(UtilText.parse(owner, "\u6bd4\u8f83\u7c97\u5927\uff0c\u76f8\u6bd4\u4e8e\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u66f4\u52a0\u677e\u8f6f\u3002", new ParserTag[0]));
                    break;
                }
                case FIVE_THICK: {
                    sb.append(UtilText.parse(owner, "\u5341\u5206\u7c97\u58ee\uff0c\u76f8\u6bd4\u4e8e\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u66f4\u52a0\u677e\u8f6f\u3002", new ParserTag[0]));
                    break;
                }
                case SIX_CHUBBY: {
                    sb.append(UtilText.parse(owner, "\u683c\u5916\u7c97\u58ee\uff0c\u76f8\u6bd4\u4e8e\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u66f4\u52a0\u677e\u8f6f\u3002", new ParserTag[0]));
                    break;
                }
                case SEVEN_FAT: {
                    sb.append(UtilText.parse(owner, "\u6781\u5176\u7c97\u58ee\uff0c\u76f8\u6bd4\u4e8e\u8eab\u4f53\u5176\u4ed6\u90e8\u5206\u66f4\u52a0\u677e\u8f6f\u3002", new ParserTag[0]));
                }
            }
        } else {
            if (owner.getTentacleCount() > 1) {
                sb.append(UtilText.parse(owner, "[npc.Her]\u7684[npc.tentacles]", new ParserTag[0]));
            } else {
                sb.append(UtilText.parse(owner, "[npc.Her]\u7684[npc.tentacle]", new ParserTag[0]));
            }
            switch (owner.getTentacleGirth()) {
                case ZERO_THIN: {
                    sb.append(UtilText.parse(owner, "\u975e\u5e38\u7ea4\u7ec6\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case ONE_SLENDER: {
                    sb.append(UtilText.parse(owner, "\u6bd4\u8f83\u4fee\u957f\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case TWO_NARROW: {
                    sb.append(UtilText.parse(owner, "\u6bd4\u8f83\u7ec6\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case THREE_AVERAGE: {
                    sb.append(UtilText.parse(owner, "\u7c97\u7ec6\u9002\u4e2d\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case FOUR_GIRTHY: {
                    sb.append(UtilText.parse(owner, "\u6bd4\u8f83\u7c97\u5927\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case FIVE_THICK: {
                    sb.append(UtilText.parse(owner, "\u5341\u5206\u7c97\u58ee\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case SIX_CHUBBY: {
                    sb.append(UtilText.parse(owner, "\u683c\u5916\u7c97\u58ee\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                    break;
                }
                case SEVEN_FAT: {
                    sb.append(UtilText.parse(owner, "\u6781\u5176\u7c97\u58ee\uff0c\u8003\u8651\u5230\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u5206\u7684\u8bdd\u3002", new ParserTag[0]));
                }
            }
        }
        return sb.toString();
    }

    public String getGirthDescriptor(GameCharacter owner) {
        return this.getGirthDescriptor(owner.getTentacleGirth());
    }

    public String getGirthDescriptor(PenetrationGirth girth) {
        if (this.getTags().contains((Object)BodyPartTag.TAIL_TYPE_FUR)) {
            switch (girth) {
                case ZERO_THIN: {
                    return "\u7ea4\u7ec6";
                }
                case ONE_SLENDER: {
                    return "\u4fee\u957f";
                }
                case TWO_NARROW: {
                    return "\u7ec6\u7a84";
                }
                case THREE_AVERAGE: {
                    return "\u6bdb\u8338\u8338";
                }
                case FOUR_GIRTHY: {
                    return "\u677e\u8f6f";
                }
                case FIVE_THICK: {
                    return "\u5f88\u677e\u8f6f";
                }
                case SIX_CHUBBY: {
                    return "\u6781\u5176\u677e\u8f6f";
                }
                case SEVEN_FAT: {
                    return "\u677e\u8f6f\u5230\u79bb\u8c31";
                }
            }
        } else {
            switch (girth) {
                case ZERO_THIN: {
                    return "\u7ea4\u7ec6";
                }
                case ONE_SLENDER: {
                    return "\u4fee\u957f";
                }
                case TWO_NARROW: {
                    return "\u7ec6\u7a84";
                }
                case THREE_AVERAGE: {
                    return "\u9002\u4e2d";
                }
                case FOUR_GIRTHY: {
                    return "\u8f83\u7c97";
                }
                case FIVE_THICK: {
                    return "\u7c97\u58ee";
                }
                case SIX_CHUBBY: {
                    return "\u6781\u7c97";
                }
                case SEVEN_FAT: {
                    return "\u7c97\u5230\u79bb\u8c31";
                }
            }
        }
        return girth.getName();
    }

    public String getGirthTransformationDescription(GameCharacter owner, boolean positive) {
        String tentacleText = "[npc.a_tentacleGirth]\u7684[npc.tentacle]";
        if (owner.getTentacleCount() > 1) {
            tentacleText = "[npc.tentacleGirth]\u7684[npc.tentacles]";
        }
        if (positive) {
            return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684[npc.tentacles]\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTentacleCount() > 1 ? "[npc.tentacles]\u7a81\u7136[style.boldGrow(\u53d8\u7c97\u4e86)]\u3002" : "[npc.tentacle]\u7a81\u7136[style.boldGrow(\u53d8\u7c97\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709\u4e86[style.boldSex(" + tentacleText + ")]\uff01</p>", new ParserTag[0]);
        }
        return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684[npc.tentacles]\u6839\u90e8\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684" + (owner.getTentacleCount() > 1 ? "[npc.tentacles]\u7a81\u7136[style.boldGrow(\u53d8\u7ec6\u4e86)]\u3002" : "[npc.tentacle]\u7a81\u7136[style.boldGrow(\u53d8\u7ec6\u4e86)]\u3002") + "<br/>[npc.She]\u73b0\u5728\u62e5\u6709\u4e86[style.boldSex(" + tentacleText + ")]\uff01</p>", new ParserTag[0]);
    }

    public String getLengthTransformationDescription(GameCharacter owner, boolean positive) {
        String heightPercentageDescription = "(\u957f\u5ea6\u4e3a[npc.namePos]\u8eab\u9ad8\u7684" + (int)(owner.getTentacleLengthAsPercentageOfHeight() * 100.0f) + "%)";
        if (positive) {
            return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684[npc.tentacles][npc.tentacleTip]\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684[npc.tentacles]\u7a81\u7136[style.boldGrow(\u4f38\u957f\u4e86)]\u3002<br/>[npc.She]\u73b0\u5728\u62e5\u6709\u4e86[style.boldTfGeneric([npc.tentacleLength]\u7684[npc.tentacles])]" + heightPercentageDescription + "\uff01</p>", new ParserTag[0]);
        }
        return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.her]\u7684[npc.tentacles][npc.tentacleTip]\u7a81\u7136\u51fa\u73b0\u4e00\u80a1\u9707\u98a4\u611f\uff0c\u53d8\u5f97\u8d8a\u6765\u8d8a\u5f3a\u70c8\uff0c\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002\u5728\u5bf9\u5373\u5c06\u53d1\u751f\u7684\u4e8b\u60c5\u6ca1\u6709\u4efb\u4f55\u9884\u5146\u7684\u60c5\u51b5\u4e0b\uff0c[npc.her]\u7684[npc.tentacles]\u7a81\u7136[style.boldShrink(\u7f29\u77ed\u4e86)]\u3002<br/>[npc.She]\u73b0\u5728\u62e5\u6709\u4e86[style.boldTfGeneric([npc.tentacleLength]\u7684[npc.tentacles])]" + heightPercentageDescription + "\uff01</p>", new ParserTag[0]);
    }

    public boolean isPrehensile() {
        return this.tags.contains((Object)BodyPartTag.TAIL_PREHENSILE);
    }

    public boolean isSuitableForPenetration() {
        return this.isPrehensile() && this.tags.contains((Object)BodyPartTag.TAIL_SUITABLE_FOR_PENETRATION);
    }

    public boolean isSuitableForSleepHugging() {
        return this.tags.contains((Object)BodyPartTag.TAIL_SLEEP_HUGGING);
    }

    @Override
    public TFModifier getTFModifier() {
        return this == TentacleType.NONE ? TFModifier.REMOVAL : this.getTFTypeModifier(TentacleType.getTentacleTypes(this.race));
    }
}

