/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.abstractTypes;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.types.BodyPartTypeInterface;
import com.lilithsthrone.game.character.body.valueEnums.TongueModifier;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractTongueType
implements BodyPartTypeInterface {
    private boolean mod;
    private boolean fromExternalFile;
    private AbstractBodyCoveringType coveringType;
    private AbstractRace race;
    private int defaultLength;
    private String name;
    private String namePlural;
    private List<String> descriptorsMasculine;
    private List<String> descriptorsFeminine;
    private String tongueBodyDescription;
    private List<TongueModifier> defaultRacialTongueModifiers;

    public AbstractTongueType(AbstractBodyCoveringType coveringType, AbstractRace race, int defaultLength, String name, String namePlural, List<String> descriptorsMasculine, List<String> descriptorsFeminine, String tongueBodyDescription, List<TongueModifier> defaultRacialTongueModifiers) {
        this.coveringType = coveringType;
        this.race = race;
        this.defaultLength = defaultLength;
        this.name = name;
        this.namePlural = namePlural;
        this.descriptorsMasculine = descriptorsMasculine;
        this.descriptorsFeminine = descriptorsFeminine;
        this.tongueBodyDescription = tongueBodyDescription;
        this.defaultRacialTongueModifiers = defaultRacialTongueModifiers;
    }

    public AbstractTongueType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.race = Race.getRaceFromId(coreElement.getMandatoryFirstOf("race").getTextContent());
                this.coveringType = BodyCoveringType.getBodyCoveringTypeFromId(coreElement.getMandatoryFirstOf("coveringType").getTextContent());
                this.defaultLength = Integer.valueOf(coreElement.getMandatoryFirstOf("defaultLength").getTextContent());
                this.name = coreElement.getMandatoryFirstOf("name").getTextContent();
                this.namePlural = coreElement.getMandatoryFirstOf("namePlural").getTextContent();
                this.descriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsMasculine").getAllOf("descriptor")) {
                        this.descriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.descriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsFeminine").getAllOf("descriptor")) {
                        this.descriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.tongueBodyDescription = coreElement.getMandatoryFirstOf("bodyDescription").getTextContent();
                this.defaultRacialTongueModifiers = new ArrayList<TongueModifier>();
                if (coreElement.getOptionalFirstOf("defaultTongueModifiers").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("defaultTongueModifiers").getAllOf("modifier")) {
                        this.defaultRacialTongueModifiers.add(TongueModifier.valueOf(e.getTextContent()));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractAnusType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public int getDefaultLength() {
        return this.defaultLength;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return "";
    }

    @Override
    public boolean isDefaultPlural(GameCharacter gc) {
        return false;
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.name;
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.namePlural;
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        if (gc.isFeminine()) {
            return Util.randomItemFrom(this.descriptorsFeminine);
        }
        return Util.randomItemFrom(this.descriptorsMasculine);
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(Body body) {
        return this.coveringType;
    }

    @Override
    public AbstractRace getRace() {
        return this.race;
    }

    public String getBodyDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.tongueBodyDescription, new ParserTag[0]);
    }

    public List<TongueModifier> getDefaultRacialTongueModifiers() {
        return this.defaultRacialTongueModifiers;
    }
}

