/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.abstractTypes;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.types.BodyPartTypeInterface;
import com.lilithsthrone.game.character.body.types.WingType;
import com.lilithsthrone.game.character.body.valueEnums.WingSize;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractWingType
implements BodyPartTypeInterface {
    private boolean mod;
    private boolean fromExternalFile;
    private AbstractBodyCoveringType coveringType;
    private AbstractRace race;
    private String transformationName;
    private boolean allowsFlight;
    private boolean generic;
    private WingSize minimumSize;
    private WingSize maximumSize;
    private String name;
    private String namePlural;
    private List<String> descriptorsMasculine;
    private List<String> descriptorsFeminine;
    private String wingTransformationDescription;
    private String wingBodyDescription;

    public AbstractWingType(AbstractBodyCoveringType coveringType, AbstractRace race, boolean allowsFlight, String transformationName, String name, String namePlural, List<String> descriptorsMasculine, List<String> descriptorsFeminine, String wingTransformationDescription, String wingBodyDescription) {
        this.coveringType = coveringType;
        this.race = race;
        this.generic = false;
        this.allowsFlight = allowsFlight;
        this.minimumSize = WingSize.ZERO_TINY;
        this.maximumSize = WingSize.FOUR_HUGE;
        this.transformationName = transformationName;
        this.name = name;
        this.namePlural = namePlural;
        this.descriptorsMasculine = descriptorsMasculine;
        this.descriptorsFeminine = descriptorsFeminine;
        this.wingTransformationDescription = wingTransformationDescription;
        this.wingBodyDescription = wingBodyDescription;
    }

    public AbstractWingType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.race = Race.getRaceFromId(coreElement.getMandatoryFirstOf("race").getTextContent());
                this.coveringType = BodyCoveringType.getBodyCoveringTypeFromId(coreElement.getMandatoryFirstOf("coveringType").getTextContent());
                this.transformationName = coreElement.getMandatoryFirstOf("transformationName").getTextContent();
                this.allowsFlight = Boolean.valueOf(coreElement.getMandatoryFirstOf("allowsFlight").getTextContent());
                this.generic = coreElement.getOptionalFirstOf("genericType").isPresent() ? Boolean.valueOf(coreElement.getMandatoryFirstOf("genericType").getTextContent()) : false;
                this.minimumSize = WingSize.ZERO_TINY;
                if (coreElement.getOptionalFirstOf("minimumSize").isPresent()) {
                    this.minimumSize = WingSize.valueOf(coreElement.getMandatoryFirstOf("minimumSize").getTextContent());
                }
                this.maximumSize = WingSize.FOUR_HUGE;
                if (coreElement.getOptionalFirstOf("maximumSize").isPresent()) {
                    this.maximumSize = WingSize.valueOf(coreElement.getMandatoryFirstOf("maximumSize").getTextContent());
                }
                this.name = coreElement.getMandatoryFirstOf("name").getTextContent();
                this.namePlural = coreElement.getMandatoryFirstOf("namePlural").getTextContent();
                this.descriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsMasculine").getAllOf("descriptor")) {
                        this.descriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.descriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsFeminine").getAllOf("descriptor")) {
                        this.descriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.wingTransformationDescription = coreElement.getMandatoryFirstOf("transformationDescription").getTextContent();
                this.wingBodyDescription = coreElement.getMandatoryFirstOf("bodyDescription").getTextContent();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractArmType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return "\u4e00\u5bf9";
    }

    public boolean allowsFlight() {
        return this.allowsFlight;
    }

    public boolean isGeneric() {
        return this.generic;
    }

    public WingSize getMinimumSize() {
        return this.minimumSize;
    }

    public WingSize getMaximumSize() {
        return this.maximumSize;
    }

    @Override
    public String getTransformationNameOverride() {
        return this.transformationName;
    }

    @Override
    public boolean isDefaultPlural(GameCharacter gc) {
        return true;
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.name;
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.namePlural;
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        if (gc.isFeminine()) {
            return Util.randomItemFrom(this.descriptorsFeminine);
        }
        return Util.randomItemFrom(this.descriptorsMasculine);
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(Body body) {
        return this.coveringType;
    }

    @Override
    public AbstractRace getRace() {
        return this.race;
    }

    @Override
    public TFModifier getTFModifier() {
        return this == WingType.NONE ? TFModifier.REMOVAL : this.getTFTypeModifier(WingType.getWingTypes(this.race));
    }

    public String getBodyDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.wingBodyDescription, new ParserTag[0]);
    }

    public String getTransformationDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.wingTransformationDescription, new ParserTag[0]);
    }
}

