/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.coverings;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringCategory;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringTemplate;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.valueEnums.CoveringModifier;
import com.lilithsthrone.game.character.body.valueEnums.CoveringPattern;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.ColourListPresets;
import com.lilithsthrone.utils.colours.PresetColour;
import java.io.File;
import java.rmi.AccessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.w3c.dom.Document;

public abstract class AbstractBodyCoveringType {
    private boolean mod;
    private boolean fromExternalFile;
    private BodyCoveringCategory category;
    private String nameTransformation;
    private String determiner;
    private String namePlural;
    private String nameSingular;
    private List<CoveringModifier> naturalModifiers;
    private List<CoveringModifier> extraModifiers;
    private List<CoveringModifier> allModifiers;
    private List<Colour> naturalColoursPrimary;
    private List<Colour> dyeColoursPrimary;
    private List<Colour> naturalColoursSecondary;
    private List<Colour> dyeColoursSecondary;
    private List<Colour> allColours;
    private List<Colour> allPrimaryColours;
    private List<Colour> allSecondaryColours;
    private Map<CoveringPattern, Integer> naturalPatterns;
    private Map<CoveringPattern, Integer> dyePatterns;
    private Map<CoveringPattern, Integer> allPatterns;
    private boolean isDefaultPlural;

    public AbstractBodyCoveringType(BodyCoveringCategory category, BodyCoveringTemplate template) {
        this.mod = false;
        this.fromExternalFile = false;
        this.category = category;
        this.nameTransformation = null;
        this.determiner = template.determiner;
        this.namePlural = template.namePlural;
        this.nameSingular = template.nameSingular;
        this.naturalModifiers = template.naturalModifiers;
        this.extraModifiers = template.extraModifiers;
        this.naturalColoursPrimary = template.naturalColoursPrimary;
        this.dyeColoursPrimary = template.dyeColoursPrimary;
        this.naturalColoursSecondary = template.naturalColoursSecondary;
        this.dyeColoursSecondary = template.dyeColoursSecondary;
        this.naturalPatterns = template.naturalPatterns;
        this.dyePatterns = template.dyePatterns;
        this.isDefaultPlural = template.isDefaultPlural;
        this.allPatterns = new HashMap<CoveringPattern, Integer>();
        for (Map.Entry<CoveringPattern, Integer> entry : this.naturalPatterns.entrySet()) {
            this.allPatterns.put(entry.getKey(), entry.getValue());
        }
        if (this.dyePatterns != null) {
            for (Map.Entry<CoveringPattern, Integer> entry : this.dyePatterns.entrySet()) {
                this.allPatterns.put(entry.getKey(), entry.getValue());
            }
        }
        this.allModifiers = new ArrayList<CoveringModifier>();
        HashSet<CoveringModifier> modSet = new HashSet<CoveringModifier>();
        modSet.addAll(this.naturalModifiers);
        modSet.addAll(this.extraModifiers);
        this.allModifiers.addAll(modSet);
        this.allColours = new ArrayList<Colour>();
        this.allPrimaryColours = new ArrayList<Colour>();
        this.allSecondaryColours = new ArrayList<Colour>();
        for (Colour c : this.naturalColoursPrimary) {
            this.allColours.add(c);
            this.allPrimaryColours.add(c);
        }
        for (Colour c : this.dyeColoursPrimary) {
            if (!this.allColours.contains(c)) {
                this.allColours.add(c);
            }
            if (this.allPrimaryColours.contains(c)) continue;
            this.allPrimaryColours.add(c);
        }
        for (Colour c : this.naturalColoursSecondary) {
            this.allColours.add(c);
            this.allSecondaryColours.add(c);
        }
        for (Colour c : this.dyeColoursSecondary) {
            if (!this.allColours.contains(c)) {
                this.allColours.add(c);
            }
            if (this.allSecondaryColours.contains(c)) continue;
            this.allSecondaryColours.add(c);
        }
    }

    public AbstractBodyCoveringType(BodyCoveringCategory category, String determiner, boolean isDefaultPlural, String namePlural, String nameSingular, List<CoveringModifier> naturalModifiers, List<CoveringModifier> extraModifiers, Map<CoveringPattern, Integer> naturalPatterns, Map<CoveringPattern, Integer> dyePatterns, List<Colour> naturalColoursPrimary, List<Colour> dyeColoursPrimary, List<Colour> naturalColoursSecondary, List<Colour> dyeColoursSecondary) {
        this.mod = false;
        this.fromExternalFile = false;
        this.category = category;
        this.nameTransformation = null;
        this.determiner = determiner;
        this.namePlural = namePlural;
        this.nameSingular = nameSingular;
        this.isDefaultPlural = isDefaultPlural;
        this.naturalModifiers = naturalModifiers == null ? new ArrayList<CoveringModifier>() : naturalModifiers;
        this.extraModifiers = extraModifiers == null ? new ArrayList<CoveringModifier>() : extraModifiers;
        if (naturalPatterns == null) {
            this.naturalPatterns = new HashMap<CoveringPattern, Integer>();
            this.naturalPatterns.put(CoveringPattern.NONE, 1);
        } else {
            this.naturalPatterns = naturalPatterns;
        }
        this.dyePatterns = new HashMap<CoveringPattern, Integer>();
        if (dyePatterns != null) {
            this.dyePatterns = new HashMap<CoveringPattern, Integer>();
            for (Map.Entry<CoveringPattern, Integer> entry : dyePatterns.entrySet()) {
                if (this.naturalPatterns.containsKey((Object)entry.getKey())) continue;
                this.dyePatterns.put(entry.getKey(), entry.getValue());
            }
        }
        this.allPatterns = new HashMap<CoveringPattern, Integer>();
        if (naturalPatterns == null) {
            this.allPatterns.put(CoveringPattern.NONE, 1);
        } else {
            for (Map.Entry<CoveringPattern, Integer> entry : this.naturalPatterns.entrySet()) {
                this.allPatterns.put(entry.getKey(), entry.getValue());
            }
        }
        this.allModifiers = new ArrayList<CoveringModifier>();
        HashSet<CoveringModifier> modSet = new HashSet<CoveringModifier>();
        modSet.addAll(this.naturalModifiers);
        modSet.addAll(this.extraModifiers);
        this.allModifiers.addAll(modSet);
        if (dyePatterns != null) {
            for (Map.Entry<CoveringPattern, Integer> entry : this.dyePatterns.entrySet()) {
                if (this.allPatterns.containsKey((Object)entry.getKey())) continue;
                this.allPatterns.put(entry.getKey(), entry.getValue());
            }
        }
        this.naturalColoursPrimary = naturalColoursPrimary == null ? new ArrayList<Colour>() : naturalColoursPrimary;
        this.dyeColoursPrimary = dyeColoursPrimary == null ? new ArrayList<Colour>() : dyeColoursPrimary;
        this.naturalColoursSecondary = naturalColoursSecondary == null ? new ArrayList<Colour>() : naturalColoursSecondary;
        this.dyeColoursSecondary = dyeColoursSecondary == null ? new ArrayList<Colour>() : dyeColoursSecondary;
        this.setupColourLists();
    }

    public AbstractBodyCoveringType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.category = BodyCoveringCategory.valueOf(coreElement.getMandatoryFirstOf("category").getTextContent());
                this.nameTransformation = coreElement.getOptionalFirstOf("nameTransformation").isPresent() ? coreElement.getMandatoryFirstOf("nameTransformation").getTextContent() : null;
                this.determiner = coreElement.getMandatoryFirstOf("determiner").getTextContent();
                this.nameSingular = coreElement.getMandatoryFirstOf("name").getTextContent();
                this.namePlural = coreElement.getMandatoryFirstOf("namePlural").getTextContent();
                this.isDefaultPlural = Boolean.valueOf(coreElement.getMandatoryFirstOf("namePlural").getAttribute("pluralByDefault"));
                this.naturalModifiers = new ArrayList<CoveringModifier>();
                if (coreElement.getOptionalFirstOf("naturalCoveringModifiers").isPresent()) {
                    for (Element element : coreElement.getMandatoryFirstOf("naturalCoveringModifiers").getAllOf("modifier")) {
                        this.naturalModifiers.add(CoveringModifier.valueOf(element.getTextContent()));
                    }
                }
                if (this.naturalModifiers.isEmpty()) {
                    System.err.println("WARNING: AbstractBodyCoveringType mod did not have any naturalModifiers defined! SMOOTH added for error-prevention.");
                    this.naturalModifiers.add(CoveringModifier.SMOOTH);
                }
                this.extraModifiers = new ArrayList<CoveringModifier>();
                if (coreElement.getOptionalFirstOf("extraCoveringModifiers").isPresent()) {
                    for (Element element : coreElement.getMandatoryFirstOf("extraCoveringModifiers").getAllOf("modifier")) {
                        this.extraModifiers.add(CoveringModifier.valueOf(element.getTextContent()));
                    }
                }
                this.naturalPatterns = new HashMap<CoveringPattern, Integer>();
                if (coreElement.getOptionalFirstOf("naturalPatterns").isPresent()) {
                    for (Element element : coreElement.getMandatoryFirstOf("naturalPatterns").getAllOf("pattern")) {
                        this.naturalPatterns.put(CoveringPattern.valueOf(element.getTextContent()), Integer.valueOf(element.getAttribute("weighting")));
                    }
                }
                if (this.naturalPatterns.isEmpty()) {
                    this.naturalPatterns.put(CoveringPattern.NONE, 1);
                }
                this.dyePatterns = new HashMap<CoveringPattern, Integer>();
                if (coreElement.getOptionalFirstOf("extraPatterns").isPresent()) {
                    for (Element element : coreElement.getMandatoryFirstOf("extraPatterns").getAllOf("pattern")) {
                        CoveringPattern pattern = CoveringPattern.valueOf(element.getTextContent());
                        if (this.naturalPatterns.containsKey((Object)pattern)) continue;
                        this.dyePatterns.put(pattern, Integer.valueOf(element.getAttribute("weighting")));
                    }
                }
                Function<Element, List> getColoursFromElement = colorsElement -> {
                    String values = colorsElement.getAttribute("values");
                    try {
                        if (values.isEmpty()) {
                            ArrayList<Colour> colours = new ArrayList<Colour>();
                            for (Element element : colorsElement.getAllOf("colour")) {
                                colours.add(PresetColour.getColourFromId(element.getTextContent()));
                            }
                            return colours;
                        }
                        return ColourListPresets.getColourListFromId(values);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("AbstractBodyCoveringType: Colour tag reading failure: " + colorsElement.getTagName() + " " + e.getMessage(), e);
                    }
                };
                this.naturalColoursPrimary = coreElement.getOptionalFirstOf("naturalColoursPrimary").map(getColoursFromElement::apply).orElseGet(ArrayList::new);
                this.dyeColoursPrimary = coreElement.getOptionalFirstOf("extraColoursPrimary").map(getColoursFromElement::apply).orElseGet(ArrayList::new);
                this.naturalColoursSecondary = coreElement.getOptionalFirstOf("naturalColoursSecondary").map(getColoursFromElement::apply).orElseGet(ArrayList::new);
                this.dyeColoursSecondary = coreElement.getOptionalFirstOf("extraColoursSecondary").map(getColoursFromElement::apply).orElseGet(ArrayList::new);
                this.allPatterns = new HashMap<CoveringPattern, Integer>();
                for (Map.Entry<CoveringPattern, Integer> entry : this.naturalPatterns.entrySet()) {
                    this.allPatterns.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<CoveringPattern, Integer> entry : this.dyePatterns.entrySet()) {
                    if (this.allPatterns.containsKey((Object)entry.getKey())) continue;
                    this.allPatterns.put(entry.getKey(), entry.getValue());
                }
                this.allModifiers = new ArrayList<CoveringModifier>();
                HashSet<CoveringModifier> hashSet = new HashSet<CoveringModifier>();
                hashSet.addAll(this.naturalModifiers);
                hashSet.addAll(this.extraModifiers);
                this.allModifiers.addAll(hashSet);
                this.setupColourLists();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractBodyCoveringType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    private void setupColourLists() {
        this.allColours = new ArrayList<Colour>();
        this.allPrimaryColours = new ArrayList<Colour>();
        this.allSecondaryColours = new ArrayList<Colour>();
        for (Colour c : this.naturalColoursPrimary) {
            this.allColours.add(c);
            this.allPrimaryColours.add(c);
        }
        for (Colour c : this.dyeColoursPrimary) {
            if (!this.allColours.contains(c)) {
                this.allColours.add(c);
            }
            if (this.allPrimaryColours.contains(c)) continue;
            this.allPrimaryColours.add(c);
        }
        for (Colour c : this.naturalColoursSecondary) {
            this.allColours.add(c);
            this.allSecondaryColours.add(c);
        }
        for (Colour c : this.dyeColoursSecondary) {
            if (!this.allColours.contains(c)) {
                this.allColours.add(c);
            }
            if (this.allSecondaryColours.contains(c)) continue;
            this.allSecondaryColours.add(c);
        }
    }

    public String toString() {
        new AccessException("WARNING: AbstractBodyCoveringType is calling toString()!").printStackTrace(System.err);
        return BodyCoveringType.getIdFromBodyCoveringType(this);
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public BodyCoveringCategory getCategory() {
        return this.category;
    }

    public String getDeterminer(GameCharacter gc) {
        return this.determiner;
    }

    public boolean isDefaultPlural() {
        return this.isDefaultPlural;
    }

    public String getNameSingular(GameCharacter gc) {
        return this.nameSingular;
    }

    public String getNamePlural(GameCharacter gc) {
        return this.namePlural;
    }

    public String getNameTransformation(GameCharacter gc) {
        if (this.nameTransformation == null) {
            return this.getName(gc);
        }
        return this.nameTransformation;
    }

    public String getName(GameCharacter gc) {
        if (this.isDefaultPlural()) {
            return this.getNamePlural(gc);
        }
        return this.getNameSingular(gc);
    }

    public Map<CoveringPattern, Integer> getNaturalPatterns() {
        return this.naturalPatterns;
    }

    public Map<CoveringPattern, Integer> getDyePatterns() {
        return this.dyePatterns;
    }

    public Map<CoveringPattern, Integer> getAllPatterns() {
        return this.allPatterns;
    }

    public List<Colour> getNaturalColoursPrimary() {
        return this.naturalColoursPrimary;
    }

    public List<Colour> getDyeColoursPrimary() {
        return this.dyeColoursPrimary;
    }

    public List<Colour> getNaturalColoursSecondary() {
        return this.naturalColoursSecondary;
    }

    public List<Colour> getDyeColoursSecondary() {
        return this.dyeColoursSecondary;
    }

    public List<Colour> getAllColours() {
        return this.allColours;
    }

    public List<Colour> getAllPrimaryColours() {
        return this.allPrimaryColours;
    }

    public List<Colour> getAllSecondaryColours() {
        return this.allSecondaryColours;
    }

    public List<CoveringModifier> getNaturalModifiers() {
        return this.naturalModifiers;
    }

    public List<CoveringModifier> getExtraModifiers() {
        return this.extraModifiers;
    }

    public List<CoveringModifier> getAllModifiers() {
        return this.allModifiers;
    }
}

