/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.coverings;

import com.lilithsthrone.game.character.body.coverings.BodyCoveringTemplate;
import com.lilithsthrone.game.character.body.valueEnums.CoveringModifier;
import com.lilithsthrone.game.character.body.valueEnums.CoveringPattern;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BodyCoveringTemplateFactory {
    public static BodyCoveringTemplate createSkin(Map<CoveringPattern, Integer> coverPatterns, List<Colour> naturalPrimaryColors, List<Colour> naturalSecondaryColours, List<Colour> dyeColours) {
        return new BodyCoveringTemplate("\u4e00\u5c42", false, "\u76ae\u80a4", "\u76ae\u80a4", Util.newArrayListOfValues(CoveringModifier.SMOOTH), null, coverPatterns, CoveringPattern.allStandardCoveringPatterns, naturalPrimaryColors, dyeColours, naturalSecondaryColours, dyeColours);
    }

    public static BodyCoveringTemplate createTopSkin(Map<CoveringPattern, Integer> coverPatterns, List<Colour> skinColors) {
        return BodyCoveringTemplateFactory.createSkin(coverPatterns, skinColors, skinColors, null);
    }

    public static BodyCoveringTemplate createBottomSkin(List<Colour> skinColors) {
        return BodyCoveringTemplateFactory.createSkin(Util.newHashMapOfValues(new Util.Value<CoveringPattern, Integer>(CoveringPattern.NONE, 1)), skinColors, null, PresetColour.allSkinColours);
    }

    public static BodyCoveringTemplate createSlime(CoveringPattern basePattern, Map<CoveringPattern, Integer> coverPatterns) {
        return new BodyCoveringTemplate("\u4e00\u5c42", false, "\u7c98\u6db2", "\u7c98\u6db2", Util.newArrayListOfValues(CoveringModifier.GOOEY), null, Util.newHashMapOfValues(new Util.Value<CoveringPattern, Integer>(basePattern, 1)), coverPatterns, PresetColour.naturalSlimeColours, PresetColour.dyeSlimeColours, PresetColour.naturalSlimeColours, PresetColour.dyeSlimeColours);
    }

    public static BodyCoveringTemplate createSilicone(CoveringPattern basePattern, Map<CoveringPattern, Integer> coverPatterns, boolean orificeCovering) {
        return BodyCoveringTemplateFactory.createSilicone("\u4e00\u5c42", "\u7845\u80f6", basePattern, coverPatterns, orificeCovering);
    }

    public static BodyCoveringTemplate createSilicone(String determiner, String name, CoveringPattern basePattern, Map<CoveringPattern, Integer> coverPatterns, boolean orificeCovering) {
        ArrayList<Colour> secondaryDyeColours = new ArrayList<Colour>();
        if (orificeCovering) {
            secondaryDyeColours.add(PresetColour.ORIFICE_INTERIOR);
        }
        secondaryDyeColours.addAll(PresetColour.dyeSiliconeColours);
        return new BodyCoveringTemplate(determiner, false, name, name, Util.newArrayListOfValues(CoveringModifier.SMOOTH), Util.newArrayListOfValues(CoveringModifier.GLOSSY, CoveringModifier.GLITTERING, CoveringModifier.MATTE, CoveringModifier.SPARKLY, CoveringModifier.METALLIC), Util.newHashMapOfValues(new Util.Value<CoveringPattern, Integer>(basePattern, 1)), coverPatterns, PresetColour.naturalSiliconeColours, PresetColour.dyeSiliconeColours, PresetColour.naturalSiliconeColours, secondaryDyeColours);
    }

    public static BodyCoveringTemplate createFurSkin(List<CoveringModifier> modifiers, Map<CoveringPattern, Integer> patterns) {
        return BodyCoveringTemplateFactory.createFur("\u4e00\u5c42", "\u76ae\u6bdb", modifiers, null, patterns);
    }

    public static BodyCoveringTemplate createFurSkin(List<CoveringModifier> modifiers, List<CoveringModifier> extraModifiers, Map<CoveringPattern, Integer> patterns) {
        return BodyCoveringTemplateFactory.createFur("\u4e00\u5c42", "\u76ae\u6bdb", modifiers, extraModifiers, patterns);
    }

    private static BodyCoveringTemplate createFur(String determiner, String name, List<CoveringModifier> modifiers, List<CoveringModifier> extraModifiers, Map<CoveringPattern, Integer> patterns) {
        return new BodyCoveringTemplate(determiner, false, name, name, modifiers, extraModifiers, patterns, CoveringPattern.allStandardCoveringPatterns, PresetColour.naturalFurColours, PresetColour.allCoveringColours, PresetColour.naturalFurColours, PresetColour.allCoveringColours);
    }

    private static BodyCoveringTemplate createHair(String determiner, String name, List<CoveringModifier> modifiers, Map<CoveringPattern, Integer> patterns) {
        return new BodyCoveringTemplate(determiner, false, name, name, modifiers, null, patterns, CoveringPattern.allHairCoveringPatterns, PresetColour.naturalHairColours, PresetColour.allCoveringColours, PresetColour.naturalHairColours, PresetColour.allCoveringColours);
    }

    private static BodyCoveringTemplate createHairWithoutPatterns(String determiner, String name, CoveringModifier modifier) {
        return BodyCoveringTemplateFactory.createHair(determiner, name, Util.newArrayListOfValues(modifier), Util.newHashMapOfValues(new Util.Value<CoveringPattern, Integer>(CoveringPattern.NONE, 1)));
    }

    public static BodyCoveringTemplate createHeadHair(CoveringModifier modifier) {
        return BodyCoveringTemplateFactory.createHairWithoutPatterns("\u4e00\u5934", "\u5934\u53d1", modifier);
    }

    public static BodyCoveringTemplate createFurHeadHair(CoveringModifier modifier) {
        return BodyCoveringTemplateFactory.createHairWithoutPatterns("\u4e00\u7247", "\u5934\u53d1", modifier);
    }

    public static BodyCoveringTemplate createBodyHair(CoveringModifier modifier) {
        return BodyCoveringTemplateFactory.createHairWithoutPatterns("\u4e00\u5c42", "\u6bdb\u53d1", modifier);
    }

    public static BodyCoveringTemplate createElemental(String name, CoveringModifier modifier, CoveringPattern pattern, List<Colour> naturalColours) {
        return new BodyCoveringTemplate("", false, name, name, Util.newArrayListOfValues(modifier), null, Util.newHashMapOfValues(new Util.Value<CoveringPattern, Integer>(pattern, 1)), null, naturalColours, PresetColour.allCoveringColours, naturalColours, PresetColour.allCoveringColours);
    }

    public static BodyCoveringTemplate createOrificeSkin(CoveringPattern pattern) {
        return new BodyCoveringTemplate("\u4e00\u5c42", false, "\u76ae\u80a4", "\u76ae\u80a4", Util.newArrayListOfValues(CoveringModifier.SMOOTH), null, pattern == null ? null : Util.newHashMapOfValues(new Util.Value<CoveringPattern, Integer>(pattern, 1)), null, PresetColour.allSkinColours, null, Util.newArrayListOfValues(PresetColour.ORIFICE_INTERIOR), PresetColour.allSkinColours);
    }

    public static BodyCoveringTemplate createPenisSkin() {
        return new BodyCoveringTemplate("\u4e00\u5c42", false, "\u76ae\u80a4", "\u76ae\u80a4", Util.newArrayListOfValues(CoveringModifier.SMOOTH), null, Util.newHashMapOfValues(new Util.Value<CoveringPattern, Integer>(CoveringPattern.NONE, 10)), Util.newHashMapOfValues(new Util.Value<CoveringPattern, Integer>(CoveringPattern.MARKED, 1), new Util.Value<CoveringPattern, Integer>(CoveringPattern.MOTTLED, 1), new Util.Value<CoveringPattern, Integer>(CoveringPattern.SPOTTED, 1), new Util.Value<CoveringPattern, Integer>(CoveringPattern.STRIPED, 1)), PresetColour.allSkinColours, null, Util.newArrayListOfValues(PresetColour.ORIFICE_INTERIOR), PresetColour.allSkinColours);
    }

    public static BodyCoveringTemplate createEyeIrisesWithCustomColors(List<Colour> naturalIrisColors, List<Colour> dyeIrisColours, boolean heteroIsExtra) {
        LinkedHashMap<CoveringPattern, Integer> natural = Util.newHashMapOfValues(new Util.Value<CoveringPattern, Integer>(CoveringPattern.EYE_IRISES, 5), new Util.Value<CoveringPattern, Integer>(CoveringPattern.EYE_IRISES_HETEROCHROMATIC, 1));
        LinkedHashMap extra = null;
        if (heteroIsExtra) {
            natural = Util.newHashMapOfValues(new Util.Value<CoveringPattern, Integer>(CoveringPattern.EYE_IRISES, 1));
            extra = Util.newHashMapOfValues(new Util.Value<CoveringPattern, Integer>(CoveringPattern.EYE_IRISES_HETEROCHROMATIC, 1));
        }
        return new BodyCoveringTemplate("\u4e00\u5bf9", true, "\u773c\u775b", "\u773c\u775b", Util.newArrayListOfValues(CoveringModifier.EYE), null, natural, extra, naturalIrisColors, dyeIrisColours, naturalIrisColors, dyeIrisColours);
    }

    public static BodyCoveringTemplate createEyeIrisesWithCustomColors(List<Colour> naturalIrisColours, List<Colour> dyeIrisColours) {
        return BodyCoveringTemplateFactory.createEyeIrisesWithCustomColors(naturalIrisColours, dyeIrisColours, true);
    }

    public static BodyCoveringTemplate createEyeIrises() {
        return BodyCoveringTemplateFactory.createEyeIrisesWithCustomColors(PresetColour.naturalIrisColours, PresetColour.dyeIrisColours, true);
    }

    public static BodyCoveringTemplate createEyeIrisesHeterochromiaNaturallyOccurring() {
        return BodyCoveringTemplateFactory.createEyeIrisesWithCustomColors(PresetColour.naturalIrisColours, PresetColour.dyeIrisColours, false);
    }
}

