/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.types;

import com.lilithsthrone.game.character.body.abstractTypes.AbstractArmType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.tags.BodyPartTag;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArmType {
    public static AbstractArmType HUMAN;
    public static AbstractArmType ANGEL;
    public static AbstractArmType DEMON_COMMON;
    public static AbstractArmType COW_MORPH;
    public static AbstractArmType DOG_MORPH;
    public static AbstractArmType WOLF_MORPH;
    public static AbstractArmType FOX_MORPH;
    public static AbstractArmType CAT_MORPH;
    public static AbstractArmType HORSE_MORPH;
    public static AbstractArmType REINDEER_MORPH;
    public static AbstractArmType ALLIGATOR_MORPH;
    public static AbstractArmType SQUIRREL_MORPH;
    public static AbstractArmType RAT_MORPH;
    public static AbstractArmType RABBIT_MORPH;
    public static AbstractArmType BAT_MORPH;
    public static AbstractArmType HARPY;
    private static List<AbstractArmType> allArmTypes;
    private static Map<AbstractArmType, String> armToIdMap;
    private static Map<String, AbstractArmType> idToArmMap;
    private static Map<AbstractRace, List<AbstractArmType>> typesMap;

    public static AbstractArmType getArmTypeFromId(String id) {
        if (id.equals("IMP")) {
            return DEMON_COMMON;
        }
        if (id.equals("LYCAN")) {
            return WOLF_MORPH;
        }
        id = Util.getClosestStringMatch(id, idToArmMap.keySet());
        return idToArmMap.get(id);
    }

    public static String getIdFromArmType(AbstractArmType armType) {
        return armToIdMap.get(armType);
    }

    public static List<AbstractArmType> getAllArmTypes() {
        return allArmTypes;
    }

    public static List<AbstractArmType> getArmTypes(AbstractRace r) {
        if (typesMap.containsKey(r)) {
            return typesMap.get(r);
        }
        ArrayList<AbstractArmType> types = new ArrayList<AbstractArmType>();
        for (AbstractArmType type : ArmType.getAllArmTypes()) {
            if (type.getRace() != r) continue;
            types.add(type);
        }
        typesMap.put(r, types);
        return types;
    }

    static {
        Field[] fieldArray;
        HUMAN = new AbstractArmType(BodyCoveringType.HUMAN, Race.HUMAN, "\u624b\u81c2", "\u624b\u81c2", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u624b", "\u624b", Util.newArrayListOfValues(""), Util.newArrayListOfValues("\u67d4\u5ae9", "\u9634\u67d4"), "\u624b\u6307", "\u624b\u6307", Util.newArrayListOfValues(""), Util.newArrayListOfValues("\u67d4\u5ae9", "\u9634\u67d4"), "\u4e07\u5e78\u7684\u662f\uff0c\u8fd9\u79cd\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u63a5\u7740\u53c8\u8fd8\u7ed9\u4e86[npc.herHim]\u4e00\u526f\u6b63\u5e38\u4eba\u7c7b\u7684\u624b\u81c2\uff0c\u8fde\u5e26\u7740\u5b8c\u597d\u7684\u624b\u638c\u3002<br/>[npc.Name]\u73b0\u5728\u6709\u7740[style.boldHuman(\u4eba\u7c7b\u7684\u624b\u81c2\u548c\u624b)]\uff0c[npc.materialDescriptor][npc.armFullDescription]\u3002", "[npc.She]\u6709\u7740[npc.armRows]\u4eba\u7c7b\u7684\u624b\u81c2\u548c\u624b\uff0c[npc.materialCompositionDescriptor][npc.armFullDescription(true)]\u3002"){};
        ANGEL = new AbstractArmType(BodyCoveringType.HUMAN, Race.ANGEL, "\u624b\u81c2", "\u624b\u81c2", Util.newArrayListOfValues("\u7cbe\u81f4"), Util.newArrayListOfValues("\u7cbe\u81f4"), "\u624b", "\u624b", Util.newArrayListOfValues("\u7cbe\u81f4", "\u67d4\u8f6f"), Util.newArrayListOfValues("\u7cbe\u81f4", "\u67d4\u8f6f", "\u9634\u67d4"), "\u624b\u6307", "\u624b\u6307", Util.newArrayListOfValues("\u7cbe\u81f4", "\u67d4\u8f6f"), Util.newArrayListOfValues("\u7cbe\u81f4", "\u67d4\u8f6f", "\u9634\u67d4"), "\u4e0d\u4e00\u4f1a\u513f\uff0c\u5b83\u4eec\u53d8\u6210\u4e86\u7ec6\u957f\u7684\u3001\u50cf\u4eba\u4e00\u6837\u7684\u624b\u81c2\uff0c\u8fd8\u6709\u50cf\u4eba\u4e00\u6837\u7684\u624b\u3002\u5c3d\u7ba1\u5916\u8868\u6709\u4e9b\u5e73\u5eb8\uff0c\u4f46\u5374\u6709\u4e00\u79cd\u5fae\u5999\u800c\u8bf1\u4eba\u7684\u8d28\u5730\uff0c\u63ed\u793a\u4e86\u5176\u771f\u6b63\u7684\u5929\u4f7f\u672c\u8d28\u3002<br/>[npc.Name]\u6709\u7740[style.boldAngel(\u5929\u4f7f\u7684\u624b\u81c2\u548c\u624b)]\uff0c[npc.materialDescriptor][npc.armFullDescription]", "[npc.She]\u6709\u7740[npc.armRows]\u4eba\u7c7b\u7684\u624b\u81c2\u548c\u624b\uff0c[npc.materialCompositionDescriptor][npc.armFullDescription(true)]\u3002"){};
        DEMON_COMMON = new AbstractArmType(BodyCoveringType.DEMON_COMMON, Race.DEMON, "\u624b\u81c2", "\u624b\u81c2", Util.newArrayListOfValues("\u65e0\u6687"), Util.newArrayListOfValues("\u65e0\u6687"), "\u624b", "\u624b", Util.newArrayListOfValues(""), Util.newArrayListOfValues("\u7cbe\u81f4", "\u67d4\u8f6f", "\u9634\u67d4"), "\u624b\u6307", "\u624b\u6307", Util.newArrayListOfValues(""), Util.newArrayListOfValues("\u7cbe\u81f4", "\u67d4\u8f6f", "\u9634\u67d4"), "\u4e0d\u4e00\u4f1a\u513f\uff0c\u5b83\u4eec\u53d8\u6210\u4e86\u7ec6\u957f\u7684\u3001\u50cf\u4eba\u4e00\u6837\u7684\u624b\u81c2\uff0c\u8fd8\u6709\u50cf\u4eba\u4e00\u6837\u7684\u624b\u3002\u5c3d\u7ba1\u5916\u8868\u6709\u4e9b\u5e73\u5eb8\uff0c\u4f46\u5374\u6709\u4e00\u79cd\u5fae\u5999\u800c\u8bf1\u4eba\u7684\u8d28\u5730\uff0c\u63ed\u793a\u4e86\u5176\u771f\u6b63\u7684\u6076\u9b54\u672c\u8d28\u3002<br/>[npc.Name]\u6709\u7740[style.boldDemon(\u6076\u9b54\u7684\u624b\u81c2\u548c\u624b)]\uff0c[npc.materialDescriptor][npc.armFullDescription]", "[npc.She]\u6709\u7740[npc.armRows]\u7ea4\u7ec6\u7684\u4eba\u7c7b\u624b\u81c2\u548c\u624b\uff0c[npc.materialCompositionDescriptor][npc.armFullDescription(true)]\u3002"){};
        COW_MORPH = new AbstractArmType(BodyCoveringType.BOVINE_FUR, Race.COW_MORPH, "\u624b\u81c2", "\u624b\u81c2", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb"), "\u624b", "\u624b", Util.newArrayListOfValues("\u725b\u7c7b"), Util.newArrayListOfValues("\u9634\u67d4", "\u725b\u7c7b"), "\u624b\u6307", "\u624b\u6307", Util.newArrayListOfValues("\u725b\u7c7b"), Util.newArrayListOfValues("\u9634\u67d4", "\u725b\u7c7b"), "\u5f88\u5feb\uff0c\u4e00\u5c42[npc.armFullDescription]\u5feb\u901f\u5730\u5728\u4e0a\u9762\u8513\u5ef6\u5f00\u6765\uff0c[npc.she]\u5411\u4e0b\u770b\u53bb\uff0c[npc.she]\u770b\u89c1\u4e00\u7247\u65b0\u7684\u6bdb\u53d1\u957f\u5728\u4e86\u624b\u80cc\u4e0a\uff0c\u575a\u786c\u3001\u8e44\u72b6\u7684\u6307\u7532\u5219\u53d6\u4ee3\u4e86\u539f\u5148\u4eba\u7c7b\u7684\u6307\u7532\u3002\u5c3d\u7ba1\u5916\u8868\u5982\u6b64\uff0c\u4f46[npc.her]\u5374\u6ca1\u6709\u611f\u89c9\u624b\u90e8\u5931\u53bb\u4e1d\u6beb\u66fe\u7ecf\u7684\u7075\u6d3b\uff0c\u4e8e\u662f\u653e\u4e0b\u5fc3\u6765\u3002\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.she]\u770b\u5230\u5927\u81c2\u5904\u7684\u6bdb\u53d1\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.NameIsFull]\u83b7\u5f97\u4e86\u4f3c\u4eba\u4e14[style.boldCowMorph(\u725b\u4e00\u822c\u7684\u624b\u81c2\u548c\u624b)]\uff0c[npc.materialDescriptor][npc.armFullDescription]\u3002", "[npc.She]\u62e5\u6709[npc.armRows]\u624b\u81c2\uff0c[npc.materialCompositionDescriptor][npc.armFullDescription(true)]\u3002[npc.Her]\u7684\u624b\u867d\u7136\u8fd8\u662f\u4eba\u7c7b\u7684\u5f62\u72b6\uff0c\u4f46\u6307\u7532\u5df2\u7ecf\u53d8\u5f97\u5f88\u575a\u786c\uff0c\u6709\u79cd\u8e44\u5b50\u7684\u8d28\u611f\u3002"){};
        DOG_MORPH = new AbstractArmType(BodyCoveringType.CANINE_FUR, Race.DOG_MORPH, "\u624b\u81c2", "\u624b\u81c2", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb"), "\u624b", "\u624b", Util.newArrayListOfValues("\u72ac\u7c7b", "\u722a\u822c", "\u6bdb\u8338\u8338"), Util.newArrayListOfValues("\u67d4\u8f6f", "\u9634\u67d4", "\u72ac\u7c7b", "\u722a\u822c", "\u6bdb\u8338\u8338"), "\u624b\u6307", "\u624b\u6307", Util.newArrayListOfValues("\u5e26\u8089\u57ab", "\u72ac\u7c7b"), Util.newArrayListOfValues("\u67d4\u8f6f", "\u9634\u67d4", "\u5e26\u8089\u57ab", "\u72ac\u7c7b"), "\u5f88\u5feb\uff0c\u4e00\u5c42[npc.armFullDescription]\u5feb\u901f\u5730\u5728\u4e0a\u9762\u8513\u5ef6\u5f00\u6765\uff0c[npc.she]\u5411\u4e0b\u770b\u53bb\uff0c[npc.she]\u770b\u89c1\u4e00\u7247\u65b0\u7684\u76ae\u6bdb\u957f\u5728\u4e86\u624b\u80cc\u4e0a\uff0c\u72d7\u4e00\u822c\u5706\u949d\u7684\u722a\u5b50\u4ece\u539f\u672c\u6307\u7532\u7684\u4f4d\u7f6e\u4f38\u4e86\u51fa\u6765\u3002[npc.Her]\u7684\u624b\u638c\u8fc5\u901f\u8f6c\u5316\u4e3a[npc.materialDescriptor]\u3001\u7a0d\u6709\u9769\u8d28\u611f\u7684\u8089\u57ab\uff0c\u800c\u5728\u5927\u81c2\u5904\uff0c\u76ae\u6bdb\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.nameIsFull]\u83b7\u5f97\u4e86\u4f3c\u4eba\u4e14[style.boldDogMorph(\u72ac\u4e00\u822c\u7684\u624b\u81c2\u548c\u624b)]\uff0c[npc.materialDescriptor][npc.armFullDescription]\u3002", "[npc.She]\u62e5\u6709[npc.armRows]\u624b\u81c2\uff0c[npc.materialCompositionDescriptor][npc.armFullDescription(true)]\u3002[npc.Her]\u7684\u624b\u8f6c\u53d8\u6210\u4e86\u4f3c\u4eba\u4e14\u72ac\u4e00\u822c\u7684\u624b\uff0c\u957f\u7740\u5706\u949d\u7684\u722a\u5b50\u548c\u76ae\u8d28\u611f\u7684\u8089\u57ab\u3002"){};
        WOLF_MORPH = new AbstractArmType(BodyCoveringType.LYCAN_FUR, Race.WOLF_MORPH, "\u624b\u81c2", "\u624b\u81c2", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb"), "\u624b", "\u624b", Util.newArrayListOfValues("\u72fc\u4e00\u822c", "\u6bdb\u8338\u8338", "\u722a\u822c"), Util.newArrayListOfValues("\u67d4\u8f6f", "\u9634\u67d4", "\u72fc\u4e00\u822c", "\u6bdb\u8338\u8338", "\u722a\u822c"), "\u624b\u6307", "\u624b\u6307", Util.newArrayListOfValues("\u5e26\u8089\u57ab", "\u72fc\u4e00\u822c"), Util.newArrayListOfValues("\u67d4\u8f6f", "\u9634\u67d4", "\u5e26\u8089\u57ab", "\u72fc\u4e00\u822c"), "\u5f88\u5feb\uff0c\u4e00\u5c42[npc.armFullDescription]\u5feb\u901f\u5730\u5728\u4e0a\u9762\u8513\u5ef6\u5f00\u6765\uff0c[npc.she]\u5411\u4e0b\u770b\u53bb\uff0c[npc.she]\u770b\u89c1\u4e00\u7247\u65b0\u7684\u76ae\u6bdb\u957f\u5728\u4e86\u624b\u80cc\u4e0a\uff0c\u72fc\u4e00\u822c\u950b\u5229\u7684\u722a\u5b50\u4ece\u539f\u672c\u6307\u7532\u7684\u4f4d\u7f6e\u4f38\u4e86\u51fa\u6765\u3002[npc.Her]\u7684\u624b\u638c\u8fc5\u901f\u8f6c\u5316\u4e3a[npc.materialDescriptor]\u3001\u786c\u76ae\u8d28\u611f\u7684\u8089\u57ab\uff0c\u800c\u5728\u5927\u81c2\u5904\uff0c\u76ae\u6bdb\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.nameIsFull]\u83b7\u5f97\u4e86\u4f3c\u4eba\u4e14[style.boldWolfMorph(\u72fc\u4e00\u822c\u7684\u624b\u81c2\u548c\u624b)]\uff0c[npc.materialDescriptor][npc.armFullDescription]\u3002", "[npc.She]\u62e5\u6709[npc.armRows]\u624b\u81c2\uff0c[npc.materialCompositionDescriptor][npc.armFullDescription(true)]\u3002[npc.Her]\u7684\u624b\u8f6c\u53d8\u6210\u4e86\u4f3c\u4eba\u4e14\u72fc\u4e00\u822c\u7684\u624b\uff0c\u957f\u7740\u5c16\u9510\u7684\u722a\u5b50\u548c\u786c\u76ae\u8d28\u611f\u7684\u8089\u57ab\u3002"){};
        FOX_MORPH = new AbstractArmType(BodyCoveringType.FOX_FUR, Race.FOX_MORPH, "\u624b\u81c2", "\u624b\u81c2", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb"), "\u624b", "\u624b", Util.newArrayListOfValues("\u72d0\u72f8\u822c", "\u6bdb\u8338\u8338", "\u722a\u822c"), Util.newArrayListOfValues("\u67d4\u8f6f", "\u9634\u67d4", "\u72d0\u72f8\u822c", "\u6bdb\u8338\u8338", "\u722a\u822c"), "\u624b\u6307", "\u624b\u6307", Util.newArrayListOfValues("\u5e26\u8089\u57ab", "\u72d0\u72f8\u822c"), Util.newArrayListOfValues("\u67d4\u8f6f", "\u9634\u67d4", "\u5e26\u8089\u57ab", "\u72d0\u72f8\u822c"), "\u5f88\u5feb\uff0c\u4e00\u5c42[npc.armFullDescription]\u5feb\u901f\u5730\u5728\u4e0a\u9762\u8513\u5ef6\u5f00\u6765\uff0c[npc.she]\u5411\u4e0b\u770b\u53bb\uff0c[npc.she]\u770b\u89c1\u4e00\u7247\u65b0\u7684\u76ae\u6bdb\u957f\u5728\u4e86\u624b\u80cc\u4e0a\uff0c\u72d0\u72f8\u4e00\u822c\u950b\u5229\u7684\u722a\u5b50\u4ece\u539f\u672c\u6307\u7532\u7684\u4f4d\u7f6e\u4f38\u4e86\u51fa\u6765\u3002[npc.Her]\u7684\u624b\u638c\u8fc5\u901f\u8f6c\u5316\u4e3a[npc.materialDescriptor]\u7684\u5c0f\u8089\u57ab\uff0c\u800c\u5728\u5927\u81c2\u5904\uff0c\u76ae\u6bdb\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002</br>\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.nameIsFull]\u83b7\u5f97\u4e86\u4f3c\u4eba\u4e14[style.boldFoxMorph(\u72d0\u72f8\u822c\u7684\u624b\u81c2\u548c\u624b)]\uff0c[npc.materialDescriptor][npc.armFullDescription]\u3002", "[npc.She]\u62e5\u6709[npc.armRows]\u624b\u81c2\uff0c[npc.materialCompositionDescriptor][npc.armFullDescription(true)]\u3002[npc.Her]\u7684\u624b\u8f6c\u53d8\u6210\u4e86\u4f3c\u4eba\u4e14\u72d0\u72f8\u822c\u7684\u624b\uff0c\u957f\u7740\u5c16\u9510\u7684\u722a\u5b50\u548c\u786c\u76ae\u8d28\u611f\u7684\u8089\u57ab\u3002"){};
        CAT_MORPH = new AbstractArmType(BodyCoveringType.FELINE_FUR, Race.CAT_MORPH, "\u624b\u81c2", "\u624b\u81c2", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb"), "\u624b", "\u624b", Util.newArrayListOfValues("\u67d4\u8f6f", "\u7cbe\u81f4", "\u732b\u4e00\u822c", "\u6bdb\u8338\u8338", "\u722a\u822c"), Util.newArrayListOfValues("\u67d4\u8f6f", "\u9634\u67d4", "\u732b\u4e00\u822c", "\u6bdb\u8338\u8338", "\u722a\u822c"), "\u624b\u6307", "\u624b\u6307", Util.newArrayListOfValues("\u67d4\u8f6f", "\u7cbe\u81f4", "\u5e26\u8089\u57ab", "\u732b\u4e00\u822c"), Util.newArrayListOfValues("\u67d4\u8f6f", "\u9634\u67d4", "\u5e26\u8089\u57ab", "\u732b\u4e00\u822c"), "\u5f88\u5feb\uff0c\u4e00\u5c42[npc.armFullDescription]\u5feb\u901f\u5730\u5728\u4e0a\u9762\u8513\u5ef6\u5f00\u6765\uff0c[npc.she]\u5411\u4e0b\u770b\u53bb\uff0c[npc.she]\u770b\u89c1\u4e00\u7247\u65b0\u7684\u76ae\u6bdb\u957f\u5728\u4e86\u624b\u80cc\u4e0a\uff0c\u950b\u5229\u4e14\u53ef\u4f38\u7f29\u7684\u722a\u5b50\u4ece\u539f\u672c\u6307\u7532\u7684\u4f4d\u7f6e\u4f38\u4e86\u51fa\u6765\u3002[npc.Her]\u7684\u624b\u638c\u8fc5\u901f\u8f6c\u5316\u4e3a[npc.materialDescriptor]\u7684\u7c89\u8272\u5c0f\u8089\u57ab\uff0c\u800c\u5728\u5927\u81c2\u5904\uff0c\u76ae\u6bdb\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.nameIsFull]\u83b7\u5f97\u4e86\u4f3c\u4eba\u4e14[style.boldCatMorph(\u732b\u4e00\u822c\u7684\u624b\u81c2\u548c\u624b)]\uff0c[npc.materialDescriptor][npc.armFullDescription]\u3002", "[npc.She]\u62e5\u6709[npc.armRows]\u624b\u81c2\uff0c[npc.materialCompositionDescriptor][npc.armFullDescription(true)]\u3002[npc.Her]\u7684\u624b\u8f6c\u53d8\u6210\u4e86\u4f3c\u4eba\u4e14\u732b\u4e00\u822c\u7684\u624b\uff0c\u957f\u7740\u53ef\u4f38\u7f29\u7684\u722a\u5b50\u548c\u7c89\u8272\u7684\u8089\u57ab\u3002"){};
        HORSE_MORPH = new AbstractArmType(BodyCoveringType.HORSE_HAIR, Race.HORSE_MORPH, "\u624b\u81c2", "\u624b\u81c2", Util.newArrayListOfValues("\u8986\u76d6\u6bdb\u53d1"), Util.newArrayListOfValues("\u8986\u76d6\u6bdb\u53d1"), "\u624b", "\u624b", Util.newArrayListOfValues("\u9a6c\u4e00\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u9a6c\u4e00\u822c"), "\u624b\u6307", "\u624b\u6307", Util.newArrayListOfValues("\u9a6c\u4e00\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u9a6c\u4e00\u822c"), "\u5f88\u5feb\uff0c\u4e00\u5c42[npc.armFullDescription]\u5feb\u901f\u5730\u5728\u4e0a\u9762\u8513\u5ef6\u5f00\u6765\uff0c[npc.she]\u5411\u4e0b\u770b\u53bb\uff0c[npc.she]\u770b\u89c1\u4e00\u7247\u65b0\u7684\u6bdb\u53d1\u957f\u5728\u4e86\u624b\u80cc\u4e0a\uff0c\u575a\u786c\u3001\u8e44\u72b6\u7684\u6307\u7532\u5219\u53d6\u4ee3\u4e86\u539f\u5148\u4eba\u7c7b\u7684\u6307\u7532\u3002\u5c3d\u7ba1\u5916\u8868\u5982\u6b64\uff0c\u4f46[npc.her]\u5374\u6ca1\u6709\u611f\u89c9\u624b\u90e8\u5931\u53bb\u4e1d\u6beb\u66fe\u7ecf\u7684\u7075\u6d3b\uff0c\u4e8e\u662f\u653e\u4e0b\u5fc3\u6765\u3002\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.she]\u770b\u5230\u5927\u81c2\u5904\u7684\u6bdb\u53d1\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.NameIsFull]\u83b7\u5f97\u4e86\u4f3c\u4eba\u4e14[style.boldHorseMorph(\u9a6c\u4e00\u822c\u7684\u624b\u81c2\u548c\u624b)]\uff0c[npc.materialDescriptor][npc.armFullDescription]\u3002", "[npc.She]\u62e5\u6709[npc.armRows]\u624b\u81c2\uff0c[npc.materialCompositionDescriptor][npc.armFullDescription(true)]\u3002[npc.Her]\u7684\u624b\u867d\u7136\u8fd8\u662f\u4eba\u7c7b\u7684\u5f62\u72b6\uff0c\u4f46\u6307\u7532\u5df2\u7ecf\u53d8\u5f97\u5f88\u575a\u786c\uff0c\u6709\u79cd\u8e44\u5b50\u7684\u8d28\u611f\u3002"){};
        REINDEER_MORPH = new AbstractArmType(BodyCoveringType.REINDEER_FUR, Race.REINDEER_MORPH, "\u624b\u81c2", "\u624b\u81c2", Util.newArrayListOfValues("\u8986\u76d6\u6bdb\u53d1"), Util.newArrayListOfValues("\u8986\u76d6\u6bdb\u53d1"), "\u624b", "\u624b", Util.newArrayListOfValues("\u9a6f\u9e7f\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u9a6f\u9e7f\u822c"), "\u624b\u6307", "\u624b\u6307", Util.newArrayListOfValues("\u9a6f\u9e7f\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u9a6f\u9e7f\u822c"), "\u5f88\u5feb\uff0c\u4e00\u5c42[npc.armFullDescription]\u5feb\u901f\u5730\u5728\u4e0a\u9762\u8513\u5ef6\u5f00\u6765\uff0c[npc.she]\u5411\u4e0b\u770b\u53bb\uff0c[npc.she]\u770b\u89c1\u4e00\u7247\u65b0\u7684\u76ae\u6bdb\u957f\u5728\u4e86[npc.her]\u7684\u624b\u80cc\u4e0a\uff0c\u575a\u786c\u3001\u8e44\u72b6\u7684\u6307\u7532\u5219\u53d6\u4ee3\u4e86\u539f\u5148\u4eba\u7c7b\u7684\u6307\u7532\u3002\u5c3d\u7ba1\u5916\u8868\u5982\u6b64\uff0c\u4f46[npc.her]\u5374\u6ca1\u6709\u611f\u89c9\u624b\u90e8\u5931\u53bb\u4e1d\u6beb\u66fe\u7ecf\u7684\u7075\u6d3b\uff0c\u4e8e\u662f\u653e\u4e0b\u5fc3\u6765\u3002\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.she]\u770b\u5230\u5927\u81c2\u5904\u7684\u76ae\u6bdb\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.NameIsFull]\u83b7\u5f97\u4e86\u4f3c\u4eba\u4e14[style.boldReindeerMorph(\u9a6f\u9e7f\u822c\u7684\u624b\u81c2\u548c\u624b)]\uff0c[npc.materialDescriptor][npc.armFullDescription]\u3002", "[npc.She]\u62e5\u6709[npc.armRows]\u624b\u81c2\uff0c[npc.materialCompositionDescriptor][npc.armFullDescription(true)]\u3002[npc.Her]\u7684\u624b\u867d\u7136\u8fd8\u662f\u4eba\u7c7b\u7684\u5f62\u72b6\uff0c\u4f46\u6307\u7532\u5df2\u7ecf\u53d8\u5f97\u5f88\u575a\u786c\uff0c\u6709\u79cd\u8e44\u5b50\u7684\u8d28\u611f\u3002"){};
        ALLIGATOR_MORPH = new AbstractArmType(BodyCoveringType.ALLIGATOR_SCALES, Race.ALLIGATOR_MORPH, "\u624b\u81c2", "\u624b\u81c2", Util.newArrayListOfValues("\u957f\u6709\u9cde\u7247", "\u722c\u884c\u52a8\u7269\u822c"), Util.newArrayListOfValues("\u957f\u6709\u9cde\u7247", "\u722c\u884c\u52a8\u7269\u822c"), "\u624b", "\u624b", Util.newArrayListOfValues("\u957f\u6709\u9cde\u7247"), Util.newArrayListOfValues("\u9634\u67d4", "\u957f\u6709\u9cde\u7247"), "\u624b\u6307", "\u624b\u6307", Util.newArrayListOfValues("\u957f\u6709\u9cde\u7247"), Util.newArrayListOfValues("\u9634\u67d4", "\u957f\u6709\u9cde\u7247"), "\u5f88\u5feb\uff0c\u4e00\u5c42[npc.armFullDescription]\u5feb\u901f\u5730\u5728\u4e0a\u9762\u8513\u5ef6\u5f00\u6765\uff0c[npc.she]\u5411\u4e0b\u770b\u53bb\uff0c[npc.she]\u770b\u89c1\u4e00\u7247\u65b0\u7684\u9cde\u7247\u957f\u5728\u4e86\u624b\u80cc\u4e0a\uff0c\u950b\u5229\u7684\u722a\u5b50\u4ece\u539f\u672c\u6307\u7532\u7684\u4f4d\u7f6e\u4f38\u4e86\u51fa\u6765\u3002[npc.Her]\u7684\u624b\u638c\u8fc5\u901f\u8f6c\u5316\u4e3a[npc.materialDescriptor]\u7684\u7ec6\u5bc6\u9cde\u7247\uff0c\u800c\u5728\u5927\u81c2\u5904\uff0c\u9cde\u7247\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.nameIsFull]\u83b7\u5f97\u4e86\u4f3c\u4eba\u4e14[style.boldGatorMorph(\u7c7b\u9cc4\u7684\u624b\u81c2\u548c\u624b)]\uff0c[npc.materialDescriptor][npc.armFullDescription]\u3002", "[npc.She]\u62e5\u6709[npc.armRows]\u624b\u81c2\uff0c[npc.materialCompositionDescriptor][npc.armFullDescription(true)]\u3002[npc.Her]\u7684\u624b\u8f6c\u53d8\u6210\u4e86\u4f3c\u4eba\u4e14\u9cc4\u9c7c\u822c\u7684\u624b\uff0c\u957f\u7740\u5e76\u4e0d\u7b97\u5927\u7684\u722a\u5b50\u3002"){};
        SQUIRREL_MORPH = new AbstractArmType(BodyCoveringType.SQUIRREL_FUR, Race.SQUIRREL_MORPH, "\u624b\u81c2", "\u624b\u81c2", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb"), "\u624b", "\u624b", Util.newArrayListOfValues("\u67d4\u8f6f", "\u677e\u9f20\u822c", "\u556e\u9f7f\u52a8\u7269\u822c", "\u6bdb\u8338\u8338", "\u722a\u822c"), Util.newArrayListOfValues("\u67d4\u8f6f", "\u9634\u67d4", "\u677e\u9f20\u822c", "\u556e\u9f7f\u52a8\u7269\u822c", "\u6bdb\u8338\u8338", "\u722a\u822c"), "\u624b\u6307", "\u624b\u6307", Util.newArrayListOfValues("\u67d4\u8f6f", "\u957f\u722a\u5b50", "\u556e\u9f7f\u52a8\u7269\u822c"), Util.newArrayListOfValues("\u67d4\u8f6f", "\u9634\u67d4", "\u957f\u722a\u5b50", "\u556e\u9f7f\u52a8\u7269\u822c"), "\u5f88\u5feb\uff0c\u4e00\u5c42[npc.armFullDescription]\u5feb\u901f\u5730\u5728\u4e0a\u9762\u8513\u5ef6\u5f00\u6765\uff0c[npc.she]\u5411\u4e0b\u770b\u53bb\uff0c[npc.she]\u770b\u89c1\u4e00\u7247\u65b0\u7684\u76ae\u6bdb\u957f\u5728\u4e86\u624b\u80cc\u4e0a\uff0c\u950b\u5229\u7684\u5c0f\u722a\u5b50\u4ece\u539f\u672c\u6307\u7532\u7684\u4f4d\u7f6e\u4f38\u4e86\u51fa\u6765\u3002[npc.Her]\u7684\u624b\u638c\u8fc5\u901f\u8f6c\u5316\u4e3a[npc.materialDescriptor]\u7684\u7c89\u8272\u5c0f\u8089\u57ab\uff0c\u800c\u5728\u5927\u81c2\u5904\uff0c\u76ae\u6bdb\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.nameIsFull]\u83b7\u5f97\u4e86\u4f3c\u4eba\u4e14[style.boldSquirrelMorph(\u677e\u9f20\u822c\u7684\u624b\u81c2\u548c\u624b)]\uff0c[npc.materialDescriptor][npc.armFullDescription]\u3002", "[npc.She]\u62e5\u6709[npc.armRows]\u624b\u81c2\uff0c[npc.materialCompositionDescriptor][npc.armFullDescription(true)]\u3002[npc.Her]\u7684\u624b\u8f6c\u53d8\u6210\u4e86\u4f3c\u4eba\u4e14\u677e\u9f20\u822c\u7684\u624b\uff0c\u957f\u7740\u722a\u5b50\u3002"){};
        RAT_MORPH = new AbstractArmType(BodyCoveringType.RAT_FUR, Race.RAT_MORPH, "\u624b\u81c2", "\u624b\u81c2", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb"), "\u624b", "\u624b", Util.newArrayListOfValues("\u67d4\u8f6f", "\u8001\u9f20\u822c", "\u556e\u9f7f\u52a8\u7269\u822c", "\u6bdb\u8338\u8338", "\u722a\u822c"), Util.newArrayListOfValues("\u67d4\u8f6f", "\u9634\u67d4", "\u8001\u9f20\u822c", "\u556e\u9f7f\u52a8\u7269\u822c", "\u6bdb\u8338\u8338", "\u722a\u822c"), "\u624b\u6307", "\u624b\u6307", Util.newArrayListOfValues("\u67d4\u8f6f", "\u8001\u9f20\u822c", "\u556e\u9f7f\u52a8\u7269\u822c", "\u6bdb\u8338\u8338", "\u722a\u822c"), Util.newArrayListOfValues("\u67d4\u8f6f", "\u9634\u67d4", "\u8001\u9f20\u822c", "\u556e\u9f7f\u52a8\u7269\u822c", "\u6bdb\u8338\u8338", "\u722a\u822c"), "\u5f88\u5feb\uff0c\u4e00\u5c42[npc.armFullDescription]\u5feb\u901f\u5730\u5728\u4e0a\u9762\u8513\u5ef6\u5f00\u6765\uff0c[npc.she]\u5411\u4e0b\u770b\u53bb\uff0c[npc.she]\u770b\u89c1\u4e00\u7247\u65b0\u7684\u76ae\u6bdb\u957f\u5728\u4e86\u624b\u80cc\u4e0a\uff0c\u950b\u5229\u7684\u5c0f\u722a\u5b50\u4ece\u539f\u672c\u6307\u7532\u7684\u4f4d\u7f6e\u4f38\u4e86\u51fa\u6765\u3002[npc.Her]\u7684\u624b\u638c\u8fc5\u901f\u8f6c\u5316\u4e3a[npc.materialDescriptor]\u7684\u7c89\u8272\u5c0f\u8089\u57ab\uff0c\u800c\u5728\u5927\u81c2\u5904\uff0c\u76ae\u6bdb\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.nameIsFull]\u83b7\u5f97\u4e86\u4f3c\u4eba\u4e14[style.boldRatMorph(\u8001\u9f20\u822c\u7684\u624b\u81c2\u548c\u624b)]\uff0c[npc.materialDescriptor][npc.armFullDescription]\u3002", "[npc.She]\u62e5\u6709[npc.armRows]\u624b\u81c2\uff0c[npc.materialCompositionDescriptor][npc.armFullDescription(true)]\u3002[npc.Her]\u7684\u624b\u8f6c\u53d8\u6210\u4e86\u4f3c\u4eba\u4e14\u8001\u9f20\u822c\u7684\u624b\uff0c\u957f\u7740\u722a\u5b50\u3002"){};
        RABBIT_MORPH = new AbstractArmType(BodyCoveringType.RABBIT_FUR, Race.RABBIT_MORPH, "\u624b\u81c2", "\u624b\u81c2", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb"), Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb"), "\u624b", "\u624b", Util.newArrayListOfValues("\u5154\u5b50\u822c", "\u6bdb\u8338\u8338", "\u722a\u822c"), Util.newArrayListOfValues("\u67d4\u8f6f", "\u9634\u67d4", "\u5154\u5b50\u822c", "\u6bdb\u8338\u8338", "\u722a\u822c"), "\u624b\u6307", "\u624b\u6307", Util.newArrayListOfValues("\u5154\u5b50\u822c", "\u6bdb\u8338\u8338", "\u722a\u822c"), Util.newArrayListOfValues("\u67d4\u8f6f", "\u9634\u67d4", "\u5154\u5b50\u822c", "\u6bdb\u8338\u8338", "\u722a\u822c"), "\u5f88\u5feb\uff0c\u4e00\u5c42[npc.armFullDescription]\u5feb\u901f\u5730\u5728\u4e0a\u9762\u8513\u5ef6\u5f00\u6765\uff0c[npc.she]\u5411\u4e0b\u770b\u53bb\uff0c[npc.she]\u770b\u89c1\u4e00\u7247\u65b0\u7684\u76ae\u6bdb\u957f\u5728\u4e86\u624b\u80cc\u4e0a\uff0c\u5154\u5b50\u4e00\u822c\u5706\u949d\u7684\u722a\u5b50\u4ece\u539f\u672c\u6307\u7532\u7684\u4f4d\u7f6e\u4f38\u4e86\u51fa\u6765\u3002[npc.Her]\u7684\u624b\u638c\u8fc5\u901f\u8f6c\u5316\u4e3a[npc.materialDescriptor]\u3001\u67d4\u8f6f\u7684\u5c0f\u8089\u57ab\uff0c\u800c\u5728\u5927\u81c2\u5904\uff0c\u76ae\u6bdb\u81ea\u7136\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>\u8f6c\u5316\u7ed3\u675f\u540e\uff0c[npc.nameIsFull]\u83b7\u5f97\u4e86\u4f3c\u4eba\u4e14[style.boldRabbitMorph(\u5154\u5b50\u822c\u7684\u624b\u81c2\u548c\u624b)]\uff0c[npc.materialDescriptor][npc.armFullDescription]\u3002", "[npc.She]\u62e5\u6709[npc.armRows]\u624b\u81c2\uff0c[npc.materialCompositionDescriptor][npc.armFullDescription(true)]\u3002[npc.Her]\u7684\u624b\u8f6c\u53d8\u6210\u4e86\u4f3c\u4eba\u4e14\u5154\u5b50\u822c\u7684\u624b\uff0c\u957f\u7740\u5706\u949d\u7684\u5c0f\u722a\u5b50\u3002"){};
        BAT_MORPH = new AbstractArmType(BodyCoveringType.BAT_SKIN, Race.BAT_MORPH, "\u7fc5\u8180", "\u7fc5\u8180", Util.newArrayListOfValues("\u8759\u8760\u822c"), Util.newArrayListOfValues("\u8759\u8760\u822c"), "\u624b", "\u624b", Util.newArrayListOfValues("\u8759\u8760\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u8759\u8760\u822c"), "\u624b\u6307", "\u624b\u6307", Util.newArrayListOfValues("\u8759\u8760\u822c"), Util.newArrayListOfValues("\u67d4\u8f6f", "\u9634\u67d4", "\u8759\u8760\u822c"), "\u5f88\u5feb\uff0c\u4e00\u5c42[npc.armFullDescription]\u5feb\u901f\u5730\u5728\u4e0a\u9762\u8513\u5ef6\u5f00\u6765\uff0c[npc.she]\u60ca\u8bb6\u5730\u5411\u4e0b\u770b\u53bb\uff0c[npc.name]\u773c\u7741\u7741\u770b\u7740[npc.her]\u7684\u624b\u6307\u53d8\u5f97\u53c8\u7ec6\u53c8\u957f\uff0c\u63a5\u7740\u5728\u624b\u6307\u4e4b\u95f4\u957f\u51fa\u4e86\u4e00\u5c42\u575a\u97e7\u7684\u8584\u819c\u3002[npc.She]\u611f\u89c9\u5230\u9aa8\u5934\u6b63\u5728\u65ad\u88c2\u91cd\u7ec4\u6210\u65b0\u7684\u5f62\u6001\uff0c\u4e8e\u662f\u60ca\u53eb\u8d77\u6765\uff0c\u6ca1\u8fc7\u591a\u4e45\uff0c[npc.her]\u7684\u624b\u548c\u624b\u81c2\u5c31\u5df2\u7ecf\u5b8c\u5168\u8f6c\u5316\u4e3a\u4e86\u8759\u8760\u822c\u7684\u5de8\u5927\u7fc5\u8180\u3002[npc.her]\u7684\u624b\u66fe\u7ecf\u7684\u4f4d\u7f6e\u4e0a\uff0c\u4e24\u6839\u624b\u6307\u5df2\u7ecf\u6536\u7f29\u5230\u65b0\u9644\u80a2\u7684\u4e2d\u95f4\u5173\u8282\u5904\uff0c\u53ea\u7559\u4e0b\u4e24\u6839\u524d\u6307\u548c\u4e0e\u4e4b\u76f8\u5bf9\u7684\u62c7\u6307\uff0c\u6bcf\u6839\u624b\u6307\u7684\u672b\u7aef\u90fd\u5e26\u7740\u5c0f\u722a\u5b50\u3002\u800c\u5728[npc.her]\u7684\u65b0\u7fc5\u8180\u4e0e\u8eab\u4f53\u5728\u80a9\u8180\u7684\u4ea4\u754c\u5904\uff0c[npc.her][npc.armFullDescription]\u81ea\u7136\u5730\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u5728\u624b\u81c2\u7684\u4f4d\u7f6e\u6709\u7740[style.boldBatMorph(\u8759\u8760\u822c\u7684\u5de8\u5927\u7fc5\u8180)]\uff0c[npc.materialDescriptor][npc.armFullDescription]\u3002", "\u5728\u539f\u672c\u624b\u81c2\u548c\u624b\u7684\u4f4d\u7f6e\u4e0a\uff0c[npc.She]\u62e5\u6709[npc.armRows]\u8759\u8760\u822c\u7684\u7fc5\u8180\uff0c[npc.materialCompositionDescriptor][npc.armFullDescription(true)]\u3002#IF(!npc.isFeral())\u800c\u5728\u624b\u539f\u672c\u7684\u4f4d\u7f6e\u4e0a\uff0c[npc.she]\u62e5\u6709\u4e24\u6839\u524d\u6307\u548c\u4e00\u6839\u62c7\u6307\uff0c\u6bcf\u4e00\u6839\u672b\u7aef\u90fd\u5e26\u7740\u5706\u949d\u7684\u5c0f\u722a\u5b50\u3002\u5c3d\u7ba1\u4e0d\u5982\u4eba\u7c7b\u7684\u624b\u7075\u6d3b\uff0c\u4f46[npc.sheIs]\u4ecd\u65e7\u80fd\u591f\u4f7f\u7528\u624b\u6307\u505a\u5230\u63e1\u6301\u7684\u52a8\u4f5c\u3002#ENDIF"){

            @Override
            public boolean allowsFlight() {
                return true;
            }

            @Override
            public List<BodyPartTag> getTags() {
                return Util.newArrayListOfValues(BodyPartTag.ARM_WINGS, BodyPartTag.ARM_WINGS_LEATHERY);
            }
        };
        HARPY = new AbstractArmType(BodyCoveringType.FEATHERS, Race.HARPY, "\u7fc5\u8180", "\u7fc5\u8180", Util.newArrayListOfValues("\u957f\u6709\u7fbd\u6bdb", "\u9e1f\u4e00\u822c"), Util.newArrayListOfValues("\u957f\u6709\u7fbd\u6bdb", "\u9e1f\u4e00\u822c"), "\u624b", "\u624b", Util.newArrayListOfValues("\u8986\u7fbd"), Util.newArrayListOfValues("\u9634\u67d4", "\u957f\u6709\u7fbd\u6bdb"), "\u624b\u6307", "\u624b\u6307", Util.newArrayListOfValues("\u8986\u7fbd"), Util.newArrayListOfValues("\u9634\u67d4", "\u957f\u6709\u7fbd\u6bdb"), "\u5f88\u5feb\uff0c\u4e00\u5c42\u5c42[npc.armFullDescription]\u5feb\u901f\u5730\u5728\u4e0a\u9762\u8513\u5ef6\u5f00\u6765\uff0c[npc.she]\u5411\u4e0b\u770b\u53bb\uff0c\u53ea\u89c1\u624b\u80cc\u4e0a\u4e5f\u957f\u51fa\u4e86\u5168\u65b0\u7684\u7fbd\u6bdb\u3002\u6b63\u5f53[npc.she]\u4ee5\u4e3a\u8f6c\u5316\u5df2\u7ecf\u7ed3\u675f\u7684\u65f6\u5019\uff0c[npc.she]\u611f\u89c9\u5230\u9aa8\u5934\u6b63\u5728\u65ad\u88c2\u91cd\u7ec4\u6210\u65b0\u7684\u5f62\u6001\uff0c\u4e8e\u662f\u60ca\u53eb\u8d77\u6765\u3002\u4e07\u5e78\u7684\u662f\uff0c\u8fd9\u79cd\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c\u624b\u81c2\u7684\u4f4d\u7f6e\u53d8\u6210\u4e86\u4e00\u5bf9\u957f\u6ee1\u7fbd\u6bdb\u7684\u5de8\u5927\u7fc5\u8180\u3002[npc.her]\u7684\u624b\u66fe\u7ecf\u7684\u4f4d\u7f6e\u4e0a\uff0c\u4e24\u6839\u624b\u6307\u5df2\u7ecf\u6536\u7f29\u5230\u65b0\u9644\u80a2\u7684\u4e2d\u95f4\u5173\u8282\u5904\uff0c\u53ea\u7559\u4e0b\u7fbd\u6bdb\u8986\u76d6\u7684\u4e24\u6839\u524d\u6307\u548c\u4e0e\u4e4b\u76f8\u5bf9\u7684\u62c7\u6307\uff0c\u6bcf\u4e00\u6839\u672b\u7aef\u90fd\u5e26\u7740\u5706\u949d\u7684\u722a\u5b50\u3002\u800c\u5728[npc.her]\u7684\u65b0\u7fc5\u8180\u4e0e\u8eab\u4f53\u5728\u80a9\u8180\u7684\u4ea4\u754c\u5904\uff0c[npc.her]\u7684\u7fbd\u6bdb\u81ea\u7136\u5730\u8fc7\u6e21\u6210\u4e86\u8986\u76d6\u8eab\u4f53\u5176\u4ed6\u90e8\u4f4d\u7684[npc.skin]\u3002<br/>[npc.Name]\u5728\u624b\u81c2\u7684\u4f4d\u7f6e\u6709\u7740\u5de8\u5927\u7684[style.boldBatMorph(\u54c8\u6bd4\u7fc5\u8180)]\uff0c[npc.materialDescriptor][npc.armFullDescription]\u3002", "\u5728\u539f\u672c\u624b\u81c2\u548c\u624b\u7684\u4f4d\u7f6e\u4e0a\uff0c[npc.She]\u62e5\u6709[npc.armRows]\u5de8\u5927\u7684\u7fc5\u8180\uff0c[npc.materialCompositionDescriptor][npc.armFullDescription(true)]\u3002#IF(!npc.isFeral())\u800c\u5728\u624b\u539f\u672c\u7684\u4f4d\u7f6e\u4e0a\uff0c[npc.she]\u62e5\u6709\u7fbd\u6bdb\u8986\u76d6\u7684\u4e24\u6839\u524d\u6307\u548c\u4e00\u6839\u62c7\u6307\uff0c\u6bcf\u4e00\u6839\u672b\u7aef\u90fd\u5e26\u7740\u5706\u949d\u7684\u5c0f\u722a\u5b50\u3002\u5c3d\u7ba1\u4e0d\u5982\u4eba\u7c7b\u7684\u624b\u7075\u6d3b\uff0c\u4f46[npc.sheIs]\u4ecd\u65e7\u80fd\u591f\u4f7f\u7528\u624b\u6307\u505a\u5230\u63e1\u6301\u7684\u52a8\u4f5c\u3002#ENDIF"){

            @Override
            public boolean allowsFlight() {
                return true;
            }

            @Override
            public List<BodyPartTag> getTags() {
                return Util.newArrayListOfValues(BodyPartTag.ARM_WINGS, BodyPartTag.ARM_WINGS_FEATHERED);
            }
        };
        armToIdMap = new HashMap<AbstractArmType, String>();
        idToArmMap = new HashMap<String, AbstractArmType>();
        allArmTypes = new ArrayList<AbstractArmType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("arm")) continue;
                try {
                    AbstractArmType type = new AbstractArmType(innerEntry.getValue(), entry.getKey(), true){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allArmTypes.add(type);
                    armToIdMap.put(type, id);
                    idToArmMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("arm")) continue;
                try {
                    AbstractArmType type = new AbstractArmType(innerEntry.getValue(), entry.getKey(), false){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allArmTypes.add(type);
                    armToIdMap.put(type, id);
                    idToArmMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        for (Field f : fieldArray = ArmType.class.getFields()) {
            if (!AbstractArmType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractArmType ct = (AbstractArmType)f.get(null);
                armToIdMap.put(ct, f.getName());
                idToArmMap.put(f.getName(), ct);
                allArmTypes.add(ct);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(allArmTypes, (t1, t2) -> t1.getRace() == Race.NONE ? -1 : (t2.getRace() == Race.NONE ? 1 : t1.getRace().getName(false).compareTo(t2.getRace().getName(false))));
        typesMap = new HashMap<AbstractRace, List<AbstractArmType>>();
    }
}

