/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.types;

import com.lilithsthrone.game.character.body.abstractTypes.AbstractAssType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.types.AnusType;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AssType {
    public static AbstractAssType HUMAN;
    public static AbstractAssType ANGEL;
    public static AbstractAssType DEMON_COMMON;
    public static AbstractAssType DOG_MORPH;
    public static AbstractAssType COW_MORPH;
    public static AbstractAssType SQUIRREL_MORPH;
    public static AbstractAssType RAT_MORPH;
    public static AbstractAssType RABBIT_MORPH;
    public static AbstractAssType BAT_MORPH;
    public static AbstractAssType ALLIGATOR_MORPH;
    public static AbstractAssType WOLF_MORPH;
    public static AbstractAssType FOX_MORPH;
    public static AbstractAssType CAT_MORPH;
    public static AbstractAssType HORSE_MORPH;
    public static AbstractAssType REINDEER_MORPH;
    public static AbstractAssType HARPY;
    private static List<AbstractAssType> allAssTypes;
    private static Map<AbstractAssType, String> assToIdMap;
    private static Map<String, AbstractAssType> idToAssMap;
    private static Map<AbstractRace, List<AbstractAssType>> typesMap;

    public static AbstractAssType getAssTypeFromId(String id) {
        if (id.equals("IMP")) {
            return DEMON_COMMON;
        }
        id = Util.getClosestStringMatch(id, idToAssMap.keySet());
        return idToAssMap.get(id);
    }

    public static String getIdFromAssType(AbstractAssType assType) {
        return assToIdMap.get(assType);
    }

    public static List<AbstractAssType> getAllAssTypes() {
        return allAssTypes;
    }

    public static List<AbstractAssType> getAssTypes(AbstractRace r) {
        if (typesMap.containsKey(r)) {
            return typesMap.get(r);
        }
        ArrayList<AbstractAssType> types = new ArrayList<AbstractAssType>();
        for (AbstractAssType type : AssType.getAllAssTypes()) {
            if (type.getRace() != r) continue;
            types.add(type);
        }
        typesMap.put(r, types);
        return types;
    }

    static {
        Field[] fieldArray;
        HUMAN = new AbstractAssType(BodyCoveringType.HUMAN, Race.HUMAN, AnusType.HUMAN, null, null, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.She]\u73b0\u5728\u62e5\u6709[style.boldHuman(\u4eba\u7c7b)][npc.assholeFullDescription]\u3002", "[npc.SheHasFull]\u62e5\u6709\u4eba\u7c7b[npc.anusFullDescription(true)]"){};
        ANGEL = new AbstractAssType(BodyCoveringType.ANGEL, Race.ANGEL, AnusType.ANGEL, null, null, Util.newArrayListOfValues("\u5929\u4f7f"), Util.newArrayListOfValues("\u5929\u4f7f", "\u5b8c\u7f8e"), "[npc.She]\u73b0\u5728\u62e5\u6709[style.boldAngel(\u5929\u4f7f)][npc.assholeFullDescription]\u3002", "[npc.SheHasFull]\u62e5\u6709\u5929\u4f7f[npc.anusFullDescription(true)]"){};
        DEMON_COMMON = new AbstractAssType(BodyCoveringType.DEMON_COMMON, Race.DEMON, AnusType.DEMON_COMMON, null, null, Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54", "\u5b8c\u7f8e"), "[npc.She]\u73b0\u5728\u62e5\u6709[style.boldDemon(\u6076\u9b54)][npc.assholeFullDescription]\u3002", "[npc.SheHasFull]\u62e5\u6709\u6076\u9b54[npc.anusFullDescription(true)]"){};
        DOG_MORPH = new AbstractAssType(BodyCoveringType.CANINE_FUR, Race.DOG_MORPH, AnusType.DOG_MORPH, null, null, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.She]\u73b0\u5728\u62e5\u6709[style.boldDogMorph(\u72ac\u4e00\u822c)][npc.assholeFullDescription]\u3002", "[npc.SheHasFull]\u62e5\u6709\u72ac\u4e00\u822c[npc.anusFullDescription(true)]"){};
        COW_MORPH = new AbstractAssType(BodyCoveringType.BOVINE_FUR, Race.COW_MORPH, AnusType.COW_MORPH, null, null, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.She]\u73b0\u5728\u62e5\u6709[style.boldCowMorph(\u725b\u4e00\u822c)][npc.assholeFullDescription]\u3002", "[npc.SheHasFull]\u62e5\u6709\u725b\u4e00\u822c[npc.anusFullDescription(true)]"){};
        SQUIRREL_MORPH = new AbstractAssType(BodyCoveringType.SQUIRREL_FUR, Race.SQUIRREL_MORPH, AnusType.SQUIRREL_MORPH, null, null, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.She]\u73b0\u5728\u62e5\u6709[style.boldSquirrelMorph(\u677e\u9f20\u822c)][npc.assholeFullDescription]\u3002", "[npc.SheHasFull]\u62e5\u6709\u677e\u9f20\u822c[npc.anusFullDescription(true)]"){};
        RAT_MORPH = new AbstractAssType(BodyCoveringType.RAT_FUR, Race.RAT_MORPH, AnusType.RAT_MORPH, null, null, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.She]\u73b0\u5728\u62e5\u6709[style.boldRatMorph(\u8001\u9f20\u822c)][npc.assholeFullDescription]\u3002", "[npc.SheHasFull]\u62e5\u6709\u8001\u9f20\u822c[npc.anusFullDescription(true)]"){};
        RABBIT_MORPH = new AbstractAssType(BodyCoveringType.RABBIT_FUR, Race.RABBIT_MORPH, AnusType.RABBIT_MORPH, null, null, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.She]\u73b0\u5728\u62e5\u6709[style.boldRabbitMorph(\u5154\u5b50\u822c)][npc.assholeFullDescription]\u3002", "[npc.SheHasFull]\u62e5\u6709\u5154\u5b50\u822c[npc.anusFullDescription(true)]"){};
        BAT_MORPH = new AbstractAssType(BodyCoveringType.BAT_FUR, Race.BAT_MORPH, AnusType.BAT_MORPH, null, null, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.She]\u73b0\u5728\u62e5\u6709[style.boldBatMorph(\u8759\u8760\u822c)][npc.assholeFullDescription]\u3002", "[npc.SheHasFull]\u62e5\u6709\u8759\u8760\u822c[npc.anusFullDescription(true)]"){};
        ALLIGATOR_MORPH = new AbstractAssType(BodyCoveringType.ALLIGATOR_SCALES, Race.ALLIGATOR_MORPH, AnusType.ALLIGATOR_MORPH, null, null, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.She]\u73b0\u5728\u62e5\u6709[style.boldGatorMorph(\u9cc4\u9c7c\u822c)][npc.assholeFullDescription]\u3002", "[npc.SheHasFull]\u62e5\u6709\u9cc4\u9c7c\u822c[npc.anusFullDescription(true)]"){};
        WOLF_MORPH = new AbstractAssType(BodyCoveringType.LYCAN_FUR, Race.WOLF_MORPH, AnusType.WOLF_MORPH, null, null, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.She]\u73b0\u5728\u62e5\u6709[style.boldWolfMorph(\u72fc\u4e00\u822c)][npc.assholeFullDescription]\u3002", "[npc.SheHasFull]\u62e5\u72fc\u4e00\u822c[npc.anusFullDescription(true)]"){};
        FOX_MORPH = new AbstractAssType(BodyCoveringType.FOX_FUR, Race.FOX_MORPH, AnusType.FOX_MORPH, null, null, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.She]\u73b0\u5728\u62e5\u6709[style.boldFoxMorph(\u72d0\u72f8\u822c)][npc.assholeFullDescription]\u3002", "[npc.SheHasFull]\u62e5\u6709\u72d0\u72f8\u822c[npc.anusFullDescription(true)]"){};
        CAT_MORPH = new AbstractAssType(BodyCoveringType.FELINE_FUR, Race.CAT_MORPH, AnusType.CAT_MORPH, null, null, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.She]\u73b0\u5728\u62e5\u6709[style.boldCatMorph(\u732b\u4e00\u822c)][npc.assholeFullDescription]\u3002", "[npc.SheHasFull]\u62e5\u6709\u732b\u4e00\u822c[npc.anusFullDescription(true)]"){};
        HORSE_MORPH = new AbstractAssType(BodyCoveringType.HORSE_HAIR, Race.HORSE_MORPH, AnusType.HORSE_MORPH, null, null, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.She]\u73b0\u5728\u62e5\u6709[style.boldHorseMorph(\u9a6c\u4e00\u822c)][npc.assholeFullDescription]\u3002", "[npc.SheHasFull]\u62e5\u6709\u9a6c\u4e00\u822c[npc.anusFullDescription(true)]"){};
        REINDEER_MORPH = new AbstractAssType(BodyCoveringType.REINDEER_FUR, Race.REINDEER_MORPH, AnusType.REINDEER_MORPH, null, null, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.She]\u73b0\u5728\u62e5\u6709[style.boldReindeerMorph(\u9a6f\u9e7f\u822c)][npc.assholeFullDescription]\u3002", "[npc.SheHasFull]\u62e5\u6709\u9a6f\u9e7f\u822c[npc.anusFullDescription(true)]"){};
        HARPY = new AbstractAssType(BodyCoveringType.FEATHERS, Race.HARPY, AnusType.HARPY, null, null, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.She]\u73b0\u5728\u62e5\u6709[style.boldHarpy(\u9e1f\u4e00\u822c)][npc.assholeFullDescription]\u3002", "[npc.SheHasFull]\u62e5\u6709\u9e1f\u4e00\u822c[npc.anusFullDescription(true)]"){};
        assToIdMap = new HashMap<AbstractAssType, String>();
        idToAssMap = new HashMap<String, AbstractAssType>();
        allAssTypes = new ArrayList<AbstractAssType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("ass")) continue;
                try {
                    AbstractAssType type = new AbstractAssType(innerEntry.getValue(), entry.getKey(), true){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allAssTypes.add(type);
                    assToIdMap.put(type, id);
                    idToAssMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("ass")) continue;
                try {
                    AbstractAssType type = new AbstractAssType(innerEntry.getValue(), entry.getKey(), false){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allAssTypes.add(type);
                    assToIdMap.put(type, id);
                    idToAssMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        for (Field f : fieldArray = AssType.class.getFields()) {
            if (!AbstractAssType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractAssType ct = (AbstractAssType)f.get(null);
                assToIdMap.put(ct, f.getName());
                idToAssMap.put(f.getName(), ct);
                allAssTypes.add(ct);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(allAssTypes, (t1, t2) -> t1.getRace() == Race.NONE ? -1 : (t2.getRace() == Race.NONE ? 1 : t1.getRace().getName(false).compareTo(t2.getRace().getName(false))));
        typesMap = new HashMap<AbstractRace, List<AbstractAssType>>();
    }
}

