/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.types;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.tags.BodyPartTag;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.inventory.clothing.BodyPartClothingBlock;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface BodyPartTypeInterface {
    default public boolean isAvailableForSelfTransformMenu(GameCharacter gc) {
        return true;
    }

    public boolean isDefaultPlural(GameCharacter var1);

    default public String getPronoun(GameCharacter gc) {
        if (this.isDefaultPlural(gc)) {
            return "\u5176";
        }
        return "\u5176";
    }

    public String getDeterminer(GameCharacter var1);

    default public String getName(GameCharacter gc) {
        if (this.isDefaultPlural(gc)) {
            return this.getNamePlural(gc);
        }
        return this.getNameSingular(gc);
    }

    public String getNameSingular(GameCharacter var1);

    public String getNamePlural(GameCharacter var1);

    default public String getName(boolean withDescriptor, GameCharacter gc) {
        return (this.getDescriptor(gc).length() > 0 ? this.getDescriptor(gc) : "") + this.getName(gc);
    }

    public String getDescriptor(GameCharacter var1);

    public AbstractBodyCoveringType getBodyCoveringType(Body var1);

    default public AbstractBodyCoveringType getBodyCoveringType(GameCharacter gc) {
        return this.getBodyCoveringType(gc.getBody());
    }

    public AbstractRace getRace();

    default public TFModifier getTFModifier() {
        return TFModifier.NONE;
    }

    default public List<BodyPartTag> getTags() {
        return new ArrayList<BodyPartTag>();
    }

    default public TFModifier getTFTypeModifier(List<? extends BodyPartTypeInterface> types) {
        switch (types.indexOf(this)) {
            case 0: {
                return TFModifier.TF_TYPE_1;
            }
            case 1: {
                return TFModifier.TF_TYPE_2;
            }
            case 2: {
                return TFModifier.TF_TYPE_3;
            }
            case 3: {
                return TFModifier.TF_TYPE_4;
            }
            case 4: {
                return TFModifier.TF_TYPE_5;
            }
            case 5: {
                return TFModifier.TF_TYPE_6;
            }
            case 6: {
                return TFModifier.TF_TYPE_7;
            }
            case 7: {
                return TFModifier.TF_TYPE_8;
            }
            case 8: {
                return TFModifier.TF_TYPE_9;
            }
            case 9: {
                return TFModifier.TF_TYPE_10;
            }
        }
        return TFModifier.NONE;
    }

    default public String getTransformationNameOverride() {
        return null;
    }

    default public String getTransformName() {
        if (this.getTransformationNameOverride() != null) {
            return this.getTransformationNameOverride();
        }
        if (this.getRace() == null) {
            return "";
        }
        return this.getRace().getDefaultTransformName();
    }

    default public BodyPartClothingBlock getBodyPartClothingBlock() {
        return null;
    }

    default public boolean isOneOf(BodyPartTypeInterface ... values) {
        return Arrays.asList(values).contains(this);
    }
}

