/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.types;

import com.lilithsthrone.game.character.body.abstractTypes.AbstractEarType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.tags.BodyPartTag;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EarType {
    public static AbstractEarType HUMAN;
    public static AbstractEarType ANGEL;
    public static AbstractEarType DEMON_COMMON;
    public static AbstractEarType DOG_MORPH;
    public static AbstractEarType DOG_MORPH_POINTED;
    public static AbstractEarType DOG_MORPH_FOLDED;
    public static AbstractEarType WOLF_MORPH;
    public static AbstractEarType FOX_MORPH;
    public static AbstractEarType FOX_MORPH_BIG;
    public static AbstractEarType COW_MORPH;
    public static AbstractEarType CAT_MORPH;
    public static AbstractEarType CAT_MORPH_TUFTED;
    public static AbstractEarType SQUIRREL_MORPH;
    public static AbstractEarType RAT_MORPH;
    public static AbstractEarType RABBIT_MORPH;
    public static AbstractEarType RABBIT_MORPH_FLOPPY;
    public static AbstractEarType BAT_MORPH;
    public static AbstractEarType HORSE_MORPH;
    public static AbstractEarType HORSE_MORPH_UPRIGHT;
    public static AbstractEarType REINDEER_MORPH;
    public static AbstractEarType ALLIGATOR_MORPH;
    public static AbstractEarType HARPY;
    private static List<AbstractEarType> allEarTypes;
    private static Map<AbstractEarType, String> earToIdMap;
    private static Map<String, AbstractEarType> idToEarMap;
    private static Map<AbstractRace, List<AbstractEarType>> typesMap;

    public static AbstractEarType getEarTypeFromId(String id) {
        if (id.equals("IMP")) {
            return DEMON_COMMON;
        }
        if (id.equals("LYCAN")) {
            return WOLF_MORPH;
        }
        id = Util.getClosestStringMatch(id, idToEarMap.keySet());
        return idToEarMap.get(id);
    }

    public static String getIdFromEarType(AbstractEarType earType) {
        return earToIdMap.get(earType);
    }

    public static List<AbstractEarType> getAllEarTypes() {
        return allEarTypes;
    }

    public static List<AbstractEarType> getEarTypes(AbstractRace r) {
        if (typesMap.containsKey(r)) {
            return typesMap.get(r);
        }
        ArrayList<AbstractEarType> types = new ArrayList<AbstractEarType>();
        for (AbstractEarType type : EarType.getAllEarTypes()) {
            if (type.getRace() != r) continue;
            types.add(type);
        }
        typesMap.put(r, types);
        return types;
    }

    static {
        Field[] fieldArray;
        HUMAN = new AbstractEarType(BodyCoveringType.HUMAN, Race.HUMAN, "\u4eba\u7c7b", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues(""), Util.newArrayListOfValues("\u67d4\u8f6f", "\u9634\u67d4"), "\u53d1\u70ed\u7684\u7619\u75d2\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u4e00\u6bb5\u65f6\u95f4\uff0c\u63a5\u7740\u7ed9[npc.herHim]\u7559\u4e0b\u4e86\u4e00\u5bf9\u6b63\u5e38\u4eba\u7c7b\u7684\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldHuman(\u4eba\u7c7b\u7684\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9\u666e\u901a\u7684\u4eba\u7c7b\u8033\u6735\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]#IF(npc.isPiercedEar())\uff0c\u4e14\u5df2\u7ecf\u6253\u8fc7\u8033\u6d1e#ENDIF\u3002"){};
        ANGEL = new AbstractEarType(BodyCoveringType.ANGEL, Race.ANGEL, "\u5929\u4f7f", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u5c16\u5c16", "\u7cbe\u81f4", "\u5929\u4f7f"), Util.newArrayListOfValues("\u67d4\u8f6f", "\u9634\u67d4", "\u5c16\u5c16", "\u7cbe\u81f4", "\u5929\u4f7f"), "\u53d1\u70ed\u7684\u7619\u75d2\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u4e00\u6bb5\u65f6\u95f4\uff0c\u63a5\u7740\u7ed9[npc.herHim]\u7559\u4e0b\u4e86\u4e00\u5bf9\u4eba\u7c7b\u6837\u5b50\u7684\u8033\u6735\uff0c\u4f46\u9876\u7aef\u5374\u5c16\u5c16\u7684\uff0c\u957f\u957f\u63a2\u51fa\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldAngel(\u5c16\u5c16\u7684\u5929\u4f7f\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9\u5c16\u5c16\u7684\u5929\u4f7f\u8033\u6735\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]#IF(npc.isPiercedEar())\uff0c\u4e14\u5df2\u7ecf\u6253\u8fc7\u8033\u6d1e#ENDIF\u3002"){};
        DEMON_COMMON = new AbstractEarType(BodyCoveringType.DEMON_COMMON, Race.DEMON, "\u6076\u9b54", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u5c16\u5c16", "\u6076\u9b54"), Util.newArrayListOfValues("\u67d4\u8f6f", "\u9634\u67d4", "\u5c16\u5c16", "\u6076\u9b54"), "\u53d1\u70ed\u7684\u7619\u75d2\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u4e00\u6bb5\u65f6\u95f4\uff0c\u63a5\u7740\u7ed9[npc.herHim]\u7559\u4e0b\u4e86\u4e00\u5bf9\u4eba\u7c7b\u6837\u5b50\u7684\u8033\u6735\uff0c\u4f46\u9876\u7aef\u5374\u5c16\u5c16\u7684\uff0c\u957f\u957f\u63a2\u51fa\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldDemon(\u5c16\u5c16\u7684\u6076\u9b54\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9\u5c16\u5c16\u7684\u6076\u9b54\u8033\u6735\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]#IF(npc.isPiercedEar())\uff0c\u4e14\u5df2\u7ecf\u6253\u8fc7\u8033\u6d1e#ENDIF\u3002"){};
        DOG_MORPH = new AbstractEarType(BodyCoveringType.CANINE_FUR, Race.DOG_MORPH, "\u72ac(\u4e0b\u5782)", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u4e0b\u5782", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u72ac\u4e00\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u4e0b\u5782", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u72ac\u4e00\u822c"), "[npc.ears]\u5ffd\u7136\u5c31\u53d8\u5f97\u5f88\u5927\uff0c\u5e76\u4e14\u8f6c\u79fb\u5230\u8111\u888b\u66f4\u9ad8\u7684\u90e8\u5206\uff0c\u800c\u975e\u539f\u6765\u4eba\u7c7b\u8033\u6735\u7684\u4f4d\u7f6e\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.earFullDescriptionColour]\u8fc5\u901f\u8986\u76d6\u5728\u4e0a\u9762\uff0c#ELSE\u5c31\u4e0e\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u4f4d\u4e00\u6837\uff0c\u5b8c\u5168\u662f\u7531[npc.earFullDescription]\u6784\u6210\uff0c#ENDIF\u8f6c\u5316\u6b65\u5165\u5c3e\u58f0\u540e\uff0c[npc.she]\u8bd5\u7740\u524d\u540e\u6296\u4e86\u6296\u521a\u521a\u83b7\u5f97\u7684\u72ac\u4e00\u822c\u7684\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldDog(\u72ac\u4e00\u822c\u4e0b\u5782\u7684\u5927\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9\u72ac\u4e00\u822c\u4e0b\u5782\u7684\u5927\u8033\u6735\uff0c\u4f4d\u4e8e\u8111\u888b\u7684\u9876\u7aef\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]#IF(npc.isPiercedEar())\uff0c\u4e14\u5df2\u7ecf\u6253\u8fc7\u8033\u6d1e#ENDIF\u3002"){

            @Override
            public List<BodyPartTag> getTags() {
                return Util.newArrayListOfValues(BodyPartTag.EAR_HANDLES_IN_SEX);
            }
        };
        DOG_MORPH_POINTED = new AbstractEarType(BodyCoveringType.CANINE_FUR, Race.DOG_MORPH, "\u5c16\u72ac", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u5c16\u5c16", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u72ac\u4e00\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u5c16\u5c16", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u72ac\u4e00\u822c"), "[npc.ears]\u5ffd\u7136\u5c31\u53d8\u5f97\u7ad6\u76f4\u4e0a\u6307\uff0c\u5e76\u4e14\u8f6c\u79fb\u5230\u8111\u888b\u66f4\u9ad8\u7684\u90e8\u5206\uff0c\u800c\u975e\u539f\u6765\u4eba\u7c7b\u8033\u6735\u7684\u4f4d\u7f6e\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.earFullDescriptionColour]\u8fc5\u901f\u8986\u76d6\u5728\u4e0a\u9762\uff0c#ELSE\u5c31\u4e0e\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u4f4d\u4e00\u6837\uff0c\u5b8c\u5168\u662f\u7531[npc.earFullDescription]\u6784\u6210\uff0c#ENDIF\u8f6c\u5316\u6b65\u5165\u5c3e\u58f0\u540e\uff0c[npc.she]\u8bd5\u7740\u524d\u540e\u6296\u4e86\u6296\u521a\u521a\u83b7\u5f97\u7684\u72ac\u4e00\u822c\u7684\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldDog(\u72ac\u4e00\u822c\u5c16\u5c16\u7684\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9\u72ac\u4e00\u822c\u5c16\u5c16\u7684\u8033\u6735\uff0c\u4f4d\u4e8e\u8111\u888b\u7684\u9876\u7aef\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]#IF(npc.isPiercedEar())\uff0c\u4e14\u5df2\u7ecf\u6253\u8fc7\u8033\u6d1e#ENDIF\u3002"){};
        DOG_MORPH_FOLDED = new AbstractEarType(BodyCoveringType.CANINE_FUR, Race.DOG_MORPH, "\u6298\u72ac", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u5f2f\u6298", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u72ac\u4e00\u822c"), Util.newArrayListOfValues("\u5f2f\u6298", "\u4e0b\u5782", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u72ac\u4e00\u822c"), "[npc.ears]\u5ffd\u7136\u5c31\u53d8\u5f97\u5c16\u5c16\u7684\uff0c\u7ad6\u76f4\u4e0a\u6307\uff0c\u968f\u540e\u518d\u4e2d\u95f4\u53c8\u5f2f\u6298\u4e0b\u6765\uff0c\u5e76\u4e14\u8f6c\u79fb\u5230\u8111\u888b\u66f4\u9ad8\u7684\u90e8\u5206\uff0c\u800c\u975e\u539f\u6765\u4eba\u7c7b\u8033\u6735\u7684\u4f4d\u7f6e\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.earFullDescriptionColour]\u8fc5\u901f\u8986\u76d6\u5728\u4e0a\u9762\uff0c#ELSE\u5c31\u4e0e\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u4f4d\u4e00\u6837\uff0c\u5b8c\u5168\u662f\u7531[npc.earFullDescription]\u6784\u6210\uff0c#ENDIF\u8f6c\u5316\u6b65\u5165\u5c3e\u58f0\u540e\uff0c[npc.she]\u8bd5\u7740\u524d\u540e\u6296\u4e86\u6296\u521a\u521a\u83b7\u5f97\u7684\u72ac\u4e00\u822c\u7684\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldDog(\u72ac\u4e00\u822c\u5f2f\u6298\u7684\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9\u72ac\u4e00\u822c\u5f2f\u6298\u7684\u8033\u6735\uff0c\u4f4d\u4e8e\u8111\u888b\u7684\u9876\u7aef\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]#IF(npc.isPiercedEar())\uff0c\u4e14\u5df2\u7ecf\u6253\u8fc7\u8033\u6d1e#ENDIF\u3002"){};
        WOLF_MORPH = new AbstractEarType(BodyCoveringType.LYCAN_FUR, Race.WOLF_MORPH, "\u72fc", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u72fc\u4e00\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u72fc\u4e00\u822c"), "[npc.ears]\u5ffd\u7136\u5c31\u53d8\u5f97\u5f88\u5927\uff0c\u9ad8\u9ad8\u7ad6\u8d77\uff0c\u5e76\u4e14\u8f6c\u79fb\u5230\u8111\u888b\u66f4\u9ad8\u7684\u90e8\u5206\uff0c\u800c\u975e\u539f\u6765\u4eba\u7c7b\u8033\u6735\u7684\u4f4d\u7f6e\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.earFullDescriptionColour]\u8fc5\u901f\u8986\u76d6\u5728\u4e0a\u9762\uff0c#ELSE\u5c31\u4e0e\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u4f4d\u4e00\u6837\uff0c\u5b8c\u5168\u662f\u7531[npc.earFullDescription]\u6784\u6210\uff0c#ENDIF\u8f6c\u5316\u6b65\u5165\u5c3e\u58f0\u540e\uff0c[npc.she]\u8bd5\u7740\u524d\u540e\u6296\u4e86\u6296\u521a\u521a\u83b7\u5f97\u7684\u72fc\u4e00\u822c\u7684\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldWolf(\u72fc\u4e00\u822c\u7684\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9\u72fc\u4e00\u822c\u7684\u8033\u6735\uff0c\u4f4d\u4e8e\u8111\u888b\u7684\u9876\u7aef\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]#IF(npc.isPiercedEar())\uff0c\u4e14\u5df2\u7ecf\u6253\u8fc7\u8033\u6d1e#ENDIF\u3002"){};
        FOX_MORPH = new AbstractEarType(BodyCoveringType.FOX_FUR, Race.FOX_MORPH, "\u72d0\u72f8", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u5c16\u5c16", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u72d0\u72f8\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u5c16\u5c16", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u72d0\u72f8\u822c"), "[npc.ears]\u5ffd\u7136\u5c31\u53d8\u5f97\u5f88\u5927\uff0c\u9ad8\u9ad8\u7ad6\u8d77\uff0c\u5e76\u4e14\u8f6c\u79fb\u5230\u8111\u888b\u66f4\u9ad8\u7684\u90e8\u5206\uff0c\u800c\u975e\u539f\u6765\u4eba\u7c7b\u8033\u6735\u7684\u4f4d\u7f6e\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.earFullDescriptionColour]\u8fc5\u901f\u8986\u76d6\u5728\u4e0a\u9762\uff0c#ELSE\u5c31\u4e0e\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u4f4d\u4e00\u6837\uff0c\u5b8c\u5168\u662f\u7531[npc.earFullDescription]\u6784\u6210\uff0c#ENDIF\u8f6c\u5316\u6b65\u5165\u5c3e\u58f0\u540e\uff0c[npc.she]\u8bd5\u7740\u524d\u540e\u6296\u4e86\u6296\u521a\u521a\u83b7\u5f97\u7684\u72d0\u72f8\u822c\u7684\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldFox(\u72d0\u72f8\u822c\u5c16\u5c16\u7684\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9\u72d0\u72f8\u822c\u5c16\u5c16\u7684\u8033\u6735\uff0c\u4f4d\u4e8e\u8111\u888b\u7684\u9876\u7aef\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]#IF(npc.isPiercedEar())\uff0c\u4e14\u5df2\u7ecf\u6253\u8fc7\u8033\u6d1e#ENDIF\u3002"){};
        FOX_MORPH_BIG = new AbstractEarType(BodyCoveringType.FOX_FUR, Race.FOX_MORPH, "\u8033\u5ed3\u72d0", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u5c16\u5c16", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u683c\u5916\u5927", "\u8033\u5ed3\u72d0\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u5c16\u5c16", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u683c\u5916\u5927", "\u8033\u5ed3\u72d0\u822c"), "[npc.ears]\u5ffd\u7136\u5c31\u53d8\u5f97\u5de8\u5927\uff0c\u7ad6\u76f4\u4e0a\u6307\uff0c\u5e76\u4e14\u8f6c\u79fb\u5230\u8111\u888b\u66f4\u9ad8\u7684\u90e8\u5206\uff0c\u800c\u975e\u539f\u6765\u4eba\u7c7b\u8033\u6735\u7684\u4f4d\u7f6e\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.earFullDescriptionColour]\u8fc5\u901f\u8986\u76d6\u5728\u4e0a\u9762\uff0c#ELSE\u5c31\u4e0e\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u4f4d\u4e00\u6837\uff0c\u5b8c\u5168\u662f\u7531[npc.earFullDescription]\u6784\u6210\uff0c#ENDIF\u8f6c\u5316\u6b65\u5165\u5c3e\u58f0\u540e\uff0c[npc.she]\u8bd5\u7740\u524d\u540e\u6296\u4e86\u6296\u521a\u521a\u83b7\u5f97\u7684\u72d0\u72f8\u822c\u7684\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldFox(\u8033\u5ed3\u72d0\u822c\u5de8\u5927\u7684\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9\u8033\u5ed3\u72d0\u822c\u5de8\u5927\u7684\u8033\u6735\uff0c\u4f4d\u4e8e\u8111\u888b\u7684\u9876\u7aef\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]#IF(npc.isPiercedEar())\uff0c\u4e14\u5df2\u7ecf\u6253\u8fc7\u8033\u6d1e#ENDIF\u3002"){

            @Override
            public List<BodyPartTag> getTags() {
                return Util.newArrayListOfValues(BodyPartTag.EAR_HANDLES_IN_SEX);
            }
        };
        COW_MORPH = new AbstractEarType(BodyCoveringType.BOVINE_FUR, Race.COW_MORPH, "\u725b", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u725b\u4e00\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u725b\u4e00\u822c"), "[npc.ears]\u5ffd\u7136\u53d8\u6210\u7279\u522b\u50cf\u725b\u7684\u6837\u5b50\uff0c\u5411\u5916\u63a2\u51fa\uff0c\u8d8a\u9760\u8fd1\u9876\u7aef\u8d8a\u7ea4\u7ec6\uff0c\u5f62\u6210\u4e86\u7a0d\u6709\u4e9b\u5185\u5f2f\u7684\u692d\u5706\u5f62\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.earFullDescriptionColour]\u8fc5\u901f\u8986\u76d6\u5728\u4e0a\u9762\uff0c#ELSE\u5c31\u4e0e\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u4f4d\u4e00\u6837\uff0c\u5b8c\u5168\u662f\u7531[npc.earFullDescription]\u6784\u6210\uff0c#ENDIF\u8f6c\u5316\u6b65\u5165\u5c3e\u58f0\u540e\uff0c[npc.she]\u8bd5\u7740\u524d\u540e\u6296\u4e86\u6296\u521a\u521a\u83b7\u5f97\u7684\u725b\u4e00\u822c\u7684\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldCow(\u725b\u4e00\u822c\u7684\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9#IF(npc.isPiercedEar())\u6253\u8fc7\u8033\u6d1e\u7684#ENDIF\u725b\u4e00\u6837\u7684\u8033\u6735\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]\u3002"){};
        CAT_MORPH = new AbstractEarType(BodyCoveringType.FELINE_FUR, Race.CAT_MORPH, "\u732b", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u732b\u4e00\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u732b\u4e00\u822c"), "[npc.ears]\u5ffd\u7136\u5c31\u53d8\u5f97\u7ad6\u76f4\u4e0a\u6307\uff0c\u5e76\u4e14\u8f6c\u79fb\u5230\u8111\u888b\u66f4\u9ad8\u7684\u90e8\u5206\uff0c\u800c\u975e\u539f\u6765\u4eba\u7c7b\u8033\u6735\u7684\u4f4d\u7f6e\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.earFullDescriptionColour]\u8fc5\u901f\u8986\u76d6\u5728\u4e0a\u9762\uff0c#ELSE\u5c31\u4e0e\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u4f4d\u4e00\u6837\uff0c\u5b8c\u5168\u662f\u7531[npc.earFullDescription]\u6784\u6210\uff0c#ENDIF\u8f6c\u5316\u6b65\u5165\u5c3e\u58f0\u540e\uff0c[npc.she]\u8bd5\u7740\u524d\u540e\u6296\u4e86\u6296\u521a\u521a\u83b7\u5f97\u7684\u732b\u4e00\u822c\u7684\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldCat(\u732b\u4e00\u822c\u7684\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9\u732b\u4e00\u822c\u7684\u8033\u6735\uff0c\u4f4d\u4e8e\u8111\u888b\u7684\u9876\u7aef\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]#IF(npc.isPiercedEar())\uff0c\u4e14\u5df2\u7ecf\u6253\u8fc7\u8033\u6d1e#ENDIF\u3002"){};
        CAT_MORPH_TUFTED = new AbstractEarType(BodyCoveringType.FELINE_FUR, Race.CAT_MORPH, "\u732b(\u7c07\u6bdb)", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u9876\u7aef\u7c07\u72b6", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u732b\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u9876\u7aef\u7c07\u72b6", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u732b\u822c"), "[npc.ears]\u5ffd\u7136\u5c31\u53d8\u5f97\u5c16\u5c16\u7684\uff0c\u7ad6\u76f4\u4e0a\u6307\uff0c\u9876\u7aef\u8fd8\u957f\u4e86\u4e00\u7c07\u654f\u611f\u7684\u76ae\u6bdb\uff0c\u5e76\u4e14\u8f6c\u79fb\u5230\u8111\u888b\u66f4\u9ad8\u7684\u90e8\u5206\uff0c\u800c\u975e\u539f\u6765\u4eba\u7c7b\u8033\u6735\u7684\u4f4d\u7f6e\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.earFullDescriptionColour]\u8fc5\u901f\u8986\u76d6\u5728\u4e0a\u9762\uff0c#ELSE\u5c31\u4e0e\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u4f4d\u4e00\u6837\uff0c\u5b8c\u5168\u662f\u7531[npc.earFullDescription]\u6784\u6210\uff0c#ENDIF\u8f6c\u5316\u6b65\u5165\u5c3e\u58f0\u540e\uff0c[npc.she]\u8bd5\u7740\u524d\u540e\u6296\u4e86\u6296\u521a\u521a\u83b7\u5f97\u7684\u732b\u4e00\u822c\u7684\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldCat(\u732b\u4e00\u822c\u7684\u8033\u6735)]\uff0c\u9876\u7aef\u957f\u4e86\u4e00\u5c0f\u64ae\u6bdb\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9\u732b\u4e00\u822c\u7684\u8033\u6735\uff0c\u4f4d\u4e8e\u8111\u888b\u7684\u9876\u7aef\uff0c\u5c16\u7aef\u957f\u4e86\u4e00\u5c0f\u64ae\u6bdb\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]#IF(npc.isPiercedEar())\uff0c\u4e14\u5df2\u7ecf\u6253\u8fc7\u8033\u6d1e#ENDIF\u3002"){};
        SQUIRREL_MORPH = new AbstractEarType(BodyCoveringType.SQUIRREL_FUR, Race.SQUIRREL_MORPH, "\u677e\u9f20", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u677e\u9f20\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u677e\u9f20\u822c"), "[npc.ears]\u5ffd\u7136\u5c31\u53d8\u5f97\u5f88\u5c0f\u5de7\uff0c\u7ad6\u76f4\u4e0a\u6307\uff0c\u5448\u692d\u5706\u5f62\uff0c\u5e76\u4e14\u8f6c\u79fb\u5230\u8111\u888b\u66f4\u9ad8\u7684\u90e8\u5206\uff0c\u800c\u975e\u539f\u6765\u4eba\u7c7b\u8033\u6735\u7684\u4f4d\u7f6e\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.earFullDescriptionColour]\u8fc5\u901f\u8986\u76d6\u5728\u4e0a\u9762\uff0c#ELSE\u5c31\u4e0e\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u4f4d\u4e00\u6837\uff0c\u5b8c\u5168\u662f\u7531[npc.earFullDescription]\u6784\u6210\uff0c#ENDIF\u8f6c\u5316\u6b65\u5165\u5c3e\u58f0\u540e\uff0c[npc.she]\u8bd5\u7740\u524d\u540e\u6296\u4e86\u6296\u521a\u521a\u83b7\u5f97\u7684\u677e\u9f20\u822c\u7684\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldSquirrel(\u677e\u9f20\u822c\u7684\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9\u677e\u9f20\u822c\u7684\u8033\u6735\uff0c\u4f4d\u4e8e\u8111\u888b\u7684\u9876\u7aef\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]#IF(npc.isPiercedEar())\uff0c\u4e14\u5df2\u7ecf\u6253\u8fc7\u8033\u6d1e#ENDIF\u3002"){};
        RAT_MORPH = new AbstractEarType(BodyCoveringType.RAT_FUR, Race.RAT_MORPH, "\u8001\u9f20", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u8001\u9f20\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u8001\u9f20\u822c"), "[npc.ears]\u5ffd\u7136\u5c31\u53d8\u5f97\u5f88\u5c0f\u5de7\uff0c\u7ad6\u76f4\u4e0a\u6307\uff0c\u5448\u692d\u5706\u5f62\uff0c\u5e76\u4e14\u8f6c\u79fb\u5230\u8111\u888b\u66f4\u9ad8\u7684\u90e8\u5206\uff0c\u800c\u975e\u539f\u6765\u4eba\u7c7b\u8033\u6735\u7684\u4f4d\u7f6e\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.earFullDescriptionColour]\u8fc5\u901f\u8986\u76d6\u5728\u4e0a\u9762\uff0c#ELSE\u5c31\u4e0e\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u4f4d\u4e00\u6837\uff0c\u5b8c\u5168\u662f\u7531[npc.earFullDescription]\u6784\u6210\uff0c#ENDIF\u8f6c\u5316\u6b65\u5165\u5c3e\u58f0\u540e\uff0c[npc.she]\u8bd5\u7740\u524d\u540e\u6296\u4e86\u6296\u521a\u521a\u83b7\u5f97\u7684\u8001\u9f20\u822c\u7684\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldRat(\u8001\u9f20\u822c\u7684\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9\u8001\u9f20\u822c\u7684\u8033\u6735\uff0c\u4f4d\u4e8e\u8111\u888b\u7684\u9876\u7aef\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]#IF(npc.isPiercedEar())\uff0c\u4e14\u5df2\u7ecf\u6253\u8fc7\u8033\u6d1e#ENDIF\u3002"){};
        RABBIT_MORPH = new AbstractEarType(BodyCoveringType.RABBIT_FUR, Race.RABBIT_MORPH, "\u5154(\u76f4\u7acb)", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u7ad6\u76f4", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u5154\u5b50\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u7ad6\u76f4", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u5154\u5b50\u822c"), "[npc.ears]\u5ffd\u7136\u5c31\u53d8\u5f97\u5f88\u5927\uff0c\u9ad8\u9ad8\u7ad6\u8d77\uff0c\u5e76\u4e14\u8f6c\u79fb\u5230\u8111\u888b\u66f4\u9ad8\u7684\u90e8\u5206\uff0c\u800c\u975e\u539f\u6765\u4eba\u7c7b\u8033\u6735\u7684\u4f4d\u7f6e\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.earFullDescriptionColour]\u8fc5\u901f\u8986\u76d6\u5728\u4e0a\u9762\uff0c#ELSE\u5c31\u4e0e\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u4f4d\u4e00\u6837\uff0c\u5b8c\u5168\u662f\u7531[npc.earFullDescription]\u6784\u6210\uff0c#ENDIF\u8f6c\u5316\u6b65\u5165\u5c3e\u58f0\u540e\uff0c[npc.she]\u8bd5\u7740\u524d\u540e\u6296\u4e86\u6296\u521a\u521a\u83b7\u5f97\u7684\u5154\u5b50\u822c\u7684\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldRabbit(\u5154\u5b50\u822c\u4e0a\u7ad6\u7684\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9\u5154\u5b50\u822c\u4e0a\u7ad6\u7684\u8033\u6735\uff0c\u4f4d\u4e8e\u8111\u888b\u7684\u9876\u7aef\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]#IF(npc.isPiercedEar())\uff0c\u4e14\u5df2\u7ecf\u6253\u8fc7\u8033\u6d1e#ENDIF\u3002"){

            @Override
            public List<BodyPartTag> getTags() {
                return Util.newArrayListOfValues(BodyPartTag.EAR_HANDLES_IN_SEX);
            }
        };
        RABBIT_MORPH_FLOPPY = new AbstractEarType(BodyCoveringType.RABBIT_FUR, Race.RABBIT_MORPH, "\u5154(\u4e0b\u5782)", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u4e0b\u5782", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u5154\u5b50\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u4e0b\u5782", "\u6bdb\u8338\u8338", "\u8986\u76d6\u76ae\u6bdb", "\u5154\u5b50\u822c"), "[npc.ears]\u5ffd\u7136\u5c31\u53d8\u5f97\u5f88\u5927\uff0c\u9ad8\u9ad8\u7ad6\u8d77\uff0c\u5e76\u4e14\u8f6c\u79fb\u5230\u8111\u888b\u66f4\u9ad8\u7684\u90e8\u5206\uff0c\u800c\u975e\u539f\u6765\u4eba\u7c7b\u8033\u6735\u7684\u4f4d\u7f6e\uff0c\u4f46\u6700\u540e\u53c8\u7a81\u7136\u5782\u843d\u4e0b\u53bb\uff0c\u642d\u5728\u4e86\u4e24\u8fb9\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.earFullDescriptionColour]\u8fc5\u901f\u8986\u76d6\u5728\u4e0a\u9762\uff0c#ELSE\u5c31\u4e0e\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u4f4d\u4e00\u6837\uff0c\u5b8c\u5168\u662f\u7531[npc.earFullDescription]\u6784\u6210\uff0c#ENDIF\u8f6c\u5316\u6b65\u5165\u5c3e\u58f0\u540e\uff0c[npc.she]\u8bd5\u7740\u524d\u540e\u6296\u4e86\u6296\u521a\u521a\u83b7\u5f97\u7684\u5154\u5b50\u822c\u7684\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldRabbit(\u5154\u5b50\u822c\u4e0b\u5782\u7684\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9\u5154\u5b50\u822c\u4e0b\u5782\u7684\u8033\u6735\uff0c\u4f4d\u4e8e\u8111\u888b\u7684\u9876\u7aef\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]#IF(npc.isPiercedEar())\uff0c\u4e14\u5df2\u7ecf\u6253\u8fc7\u8033\u6d1e#ENDIF\u3002"){

            @Override
            public List<BodyPartTag> getTags() {
                return Util.newArrayListOfValues(BodyPartTag.EAR_HANDLES_IN_SEX);
            }
        };
        BAT_MORPH = new AbstractEarType(BodyCoveringType.BAT_FUR, Race.BAT_MORPH, "\u8759\u8760", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u683c\u5916\u5927", "\u8759\u8760\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u683c\u5916\u5927", "\u8759\u8760\u822c"), "[npc.ears]\u5ffd\u7136\u5c31\u53d8\u5f97\u5f88\u5927\uff0c\u9ad8\u9ad8\u7ad6\u8d77\uff0c\u5e76\u4e14\u8f6c\u79fb\u5230\u8111\u888b\u66f4\u9ad8\u7684\u90e8\u5206\uff0c\u800c\u975e\u539f\u6765\u4eba\u7c7b\u8033\u6735\u7684\u4f4d\u7f6e\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.earFullDescriptionColour]\u8fc5\u901f\u8986\u76d6\u5728\u4e0a\u9762\uff0c#ELSE\u5c31\u4e0e\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u4f4d\u4e00\u6837\uff0c\u5b8c\u5168\u662f\u7531[npc.earFullDescription]\u6784\u6210\uff0c#ENDIF\u8f6c\u5316\u6b65\u5165\u5c3e\u58f0\u540e\uff0c[npc.she]\u8bd5\u7740\u524d\u540e\u6296\u4e86\u6296\u521a\u521a\u83b7\u5f97\u7684\u8759\u8760\u822c\u7684\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldBat(\u8759\u8760\u822c\u7684\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9\u8759\u8760\u822c\u7684\u8033\u6735\uff0c\u4f4d\u4e8e\u8111\u888b\u7684\u9876\u7aef\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]#IF(npc.isPiercedEar())\uff0c\u4e14\u5df2\u7ecf\u6253\u8fc7\u8033\u6d1e#ENDIF\u3002"){

            @Override
            public List<BodyPartTag> getTags() {
                return Util.newArrayListOfValues(BodyPartTag.ECHO_LOCATION);
            }
        };
        HORSE_MORPH = new AbstractEarType(BodyCoveringType.HORSE_HAIR, Race.HORSE_MORPH, "\u9a6c", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u7ad6\u76f4", "\u9a6c\u4e00\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u6bdb\u8338\u8338", "\u7ad6\u76f4", "\u9a6c\u4e00\u822c"), "[npc.ears]\u5ffd\u7136\u5c31\u53d8\u5f97\u6709\u4e9b\u7c97\u77ed\uff0c\u7565\u5fae\u4e0a\u6307\uff0c\u5e76\u4e14\u8f6c\u79fb\u5230\u8111\u888b\u66f4\u9ad8\u7684\u90e8\u5206\uff0c\u800c\u975e\u539f\u6765\u4eba\u7c7b\u8033\u6735\u7684\u4f4d\u7f6e\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.earFullDescriptionColour]\u8fc5\u901f\u8986\u76d6\u5728\u4e0a\u9762\uff0c#ELSE\u5c31\u4e0e\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u4f4d\u4e00\u6837\uff0c\u5b8c\u5168\u662f\u7531[npc.earFullDescription]\u6784\u6210\uff0c#ENDIF\u8f6c\u5316\u6b65\u5165\u5c3e\u58f0\u540e\uff0c[npc.she]\u8bd5\u7740\u524d\u540e\u6296\u4e86\u6296\u521a\u521a\u83b7\u5f97\u7684\u9a6c\u4e00\u822c\u7684\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldHorse(\u9a6c\u4e00\u822c\u7684\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9\u9a6c\u4e00\u822c\u7684\u8033\u6735\uff0c\u4f4d\u4e8e\u8111\u888b\u7684\u9876\u7aef\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]#IF(npc.isPiercedEar())\uff0c\u4e14\u5df2\u7ecf\u6253\u8fc7\u8033\u6d1e#ENDIF\u3002"){};
        HORSE_MORPH_UPRIGHT = new AbstractEarType(BodyCoveringType.HORSE_HAIR, Race.HORSE_MORPH, "\u9a6c(\u957f\u76f4)", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u8f83\u9ad8", "\u7ad6\u76f4", "\u9a6c\u4e00\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u8f83\u9ad8", "\u6bdb\u8338\u8338", "\u7ad6\u76f4", "\u9a6c\u822c"), "[npc.ears]\u5ffd\u7136\u5c31\u53d8\u5f97\u7ad6\u76f4\u4e0a\u6307\uff0c\u66f4\u52a0\u957f\u4e00\u4e9b\uff0c\u5e76\u4e14\u8f6c\u79fb\u5230\u8111\u888b\u66f4\u9ad8\u7684\u90e8\u5206\uff0c\u800c\u975e\u539f\u6765\u4eba\u7c7b\u8033\u6735\u7684\u4f4d\u7f6e\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.earFullDescriptionColour]\u8fc5\u901f\u8986\u76d6\u5728\u4e0a\u9762\uff0c#ELSE\u5c31\u4e0e\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u4f4d\u4e00\u6837\uff0c\u5b8c\u5168\u662f\u7531[npc.earFullDescription]\u6784\u6210\uff0c#ENDIF\u8f6c\u5316\u6b65\u5165\u5c3e\u58f0\u540e\uff0c[npc.she]\u8bd5\u7740\u524d\u540e\u6296\u4e86\u6296\u521a\u521a\u83b7\u5f97\u7684\u9a6c\u4e00\u822c\u7684\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldHorse(\u9a6c\u4e00\u822c\u9ad8\u9ad8\u7684\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9\u9a6c\u4e00\u822c\u9ad8\u800c\u4e0a\u7ad6\u7684\u8033\u6735\uff0c\u4f4d\u4e8e\u8111\u888b\u7684\u9876\u7aef\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]#IF(npc.isPiercedEar())\uff0c\u4e14\u5df2\u7ecf\u6253\u8fc7\u8033\u6d1e#ENDIF\u3002"){};
        REINDEER_MORPH = new AbstractEarType(BodyCoveringType.REINDEER_FUR, Race.REINDEER_MORPH, "\u9a6f\u9e7f", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u6bdb\u8338\u8338", "\u9a6f\u9e7f\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u6bdb\u8338\u8338", "\u9a6f\u9e7f\u822c"), "[npc.ears]\u5ffd\u7136\u53d8\u6210\u7279\u522b\u50cf\u9a6f\u9e7f\u7684\u6837\u5b50\uff0c\u5411\u5916\u63a2\u51fa\uff0c\u8d8a\u9760\u8fd1\u9876\u7aef\u8d8a\u7ea4\u7ec6\uff0c\u5f62\u6210\u4e86\u7a0d\u6709\u4e9b\u5185\u5f2f\u7684\u692d\u5706\u5f62\uff0c\u5e76\u4e14\u8f6c\u79fb\u5230\u8111\u888b\u66f4\u9ad8\u7684\u90e8\u5206\uff0c\u800c\u975e\u539f\u6765\u4eba\u7c7b\u8033\u6735\u7684\u4f4d\u7f6e\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.earFullDescriptionColour]\u8fc5\u901f\u8986\u76d6\u5728\u4e0a\u9762\uff0c#ELSE\u5c31\u4e0e\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u4f4d\u4e00\u6837\uff0c\u5b8c\u5168\u662f\u7531[npc.earFullDescription]\u6784\u6210\uff0c#ENDIF\u8f6c\u5316\u6b65\u5165\u5c3e\u58f0\u540e\uff0c[npc.she]\u8bd5\u7740\u524d\u540e\u6296\u4e86\u6296\u521a\u521a\u83b7\u5f97\u7684\u9a6f\u9e7f\u822c\u7684\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldReindeer(\u9a6f\u9e7f\u822c\u7684\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.She]\u6709\u4e00\u5bf9\u9a6f\u9e7f\u822c\u7684\u8033\u6735\uff0c\u4f4d\u4e8e\u8111\u888b\u7684\u9876\u7aef\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription(true)]#IF(npc.isPiercedEar())\uff0c\u4e14\u5df2\u7ecf\u6253\u8fc7\u8033\u6d1e#ENDIF\u3002"){};
        ALLIGATOR_MORPH = new AbstractEarType(BodyCoveringType.ALLIGATOR_SCALES, Race.ALLIGATOR_MORPH, "\u9cc4\u9c7c", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u5e26\u9cde", "\u8986\u76d6\u9cde\u7247", "\u9cc4\u9c7c\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u5e26\u9cde", "\u8986\u76d6\u9cde\u7247", "\u9cc4\u9c7c\u822c"), "[npc.ears]\u8fc5\u901f\u6536\u7f29\uff0c\u53ea\u5269\u4e0b\u4e86\u4e00\u5c0f\u7247\uff0c\u800c\u5927\u90e8\u5206\u8f6f\u9aa8\u7ec4\u7ec7\u5219\u6ca1\u5165\u4e86\u8111\u888b\u91cc\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.earFullDescriptionColour]\u8fc5\u901f\u8986\u76d6\u5728\u51e0\u4e4e\u5b8c\u5168\u6ca1\u5165\u4f53\u5185\u7684\u8033\u6735\u4e0a\uff0c#ELSE\u5c31\u4e0e\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u4f4d\u4e00\u6837\uff0c\u8fd9\u51e0\u4e4e\u5b8c\u5168\u6ca1\u5165\u4f53\u5185\u7684\u8033\u6735\u5b8c\u5168\u662f\u7531[npc.earFullDescription]\u6784\u6210\uff0c#ENDIF\u8f6c\u5316\u6b65\u5165\u5c3e\u58f0\u540e\uff0c[npc.she]\u5f97\u5230\u4e86\u9cc4\u9c7c\u5316\u5f62\u7684\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldAlligator(\u9cde\u7247\u8986\u76d6\u3001\u4f4d\u4e8e\u4f53\u5185\u7684\u9cc4\u9c7c\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.her]\u7684\u8033\u6735\u73b0\u5728\u4f4d\u4e8e\u8111\u888b\u5185\u90e8\uff0c\u8986\u76d6\u7740\u4e00\u7247[npc.earFullDescription(true)]\u3002#IF(npc.isPiercedEar())\u5e76\u4e14\u5f88\u5de7\u5999\u5730\u7a7f\u4e86\u5b54\uff0c\u4ece\u800c\u80fd\u591f\u6234\u4e0a\u4e3a\u8033\u90e8\u8bbe\u8ba1\u7684\u9996\u9970\u3002#ENDIF"){};
        HARPY = new AbstractEarType(BodyCoveringType.FEATHERS, Race.HARPY, "\u54c8\u6bd4", "\u8033\u6735", "\u8033\u6735", Util.newArrayListOfValues("\u957f\u6709\u7fbd\u6bdb", "\u7fbd\u6bdb\u8986\u76d6", "\u9e1f\u4e00\u822c"), Util.newArrayListOfValues("\u9634\u67d4", "\u957f\u6709\u7fbd\u6bdb", "\u7fbd\u6bdb\u8986\u76d6", "\u9e1f\u4e00\u822c"), "[npc.ears]\u8fc5\u901f\u6536\u7f29\uff0c\u53ea\u5269\u4e0b\u4e86\u4e00\u5c0f\u7247\uff0c\u800c\u5927\u90e8\u5206\u8f6f\u9aa8\u7ec4\u7ec7\u5219\u6ca1\u5165\u4e86\u8111\u888b\u91cc\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.earFullDescriptionColour]\u8fc5\u901f\u8986\u76d6\u5728\u51e0\u4e4e\u5b8c\u5168\u6ca1\u5165\u4f53\u5185\u7684\u8033\u6735\u4e0a\uff0c#ELSE\u5c31\u4e0e\u8eab\u4f53\u7684\u5176\u4ed6\u90e8\u4f4d\u4e00\u6837\uff0c\u8fd9\u51e0\u4e4e\u5b8c\u5168\u6ca1\u5165\u4f53\u5185\u7684\u8033\u6735\u5b8c\u5168\u662f\u7531[npc.earFullDescription]\u6784\u6210\uff0c#ENDIF\u8f6c\u5316\u6b65\u5165\u5c3e\u58f0\u540e\uff0c[npc.she]\u5f97\u5230\u4e86\u6709\u7f8e\u4e3d\u7fbd\u6bdb\u88c5\u9970\u7684\u54c8\u6bd4\u8033\u6735\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldHarpy(\u7fbd\u6bdb\u8986\u76d6\u3001\u4f4d\u4e8e\u4f53\u5185\u7684\u54c8\u6bd4\u8033\u6735)]\uff0c[npc.materialCompositionDescriptor][npc.earFullDescription]\u3002", "[npc.her]\u7684\u8033\u6735\u73b0\u5728\u4f4d\u4e8e\u8111\u888b\u5185\u90e8\uff0c\u8986\u76d6\u7740\u4e00\u7247[npc.earFullDescription(true)]\u3002#IF(npc.isPiercedEar())\u5e76\u4e14\u5f88\u5de7\u5999\u5730\u7a7f\u4e86\u5b54\uff0c\u4ece\u800c\u80fd\u591f\u6234\u4e0a\u4e3a\u8033\u90e8\u8bbe\u8ba1\u7684\u9996\u9970\u3002#ENDIF"){};
        earToIdMap = new HashMap<AbstractEarType, String>();
        idToEarMap = new HashMap<String, AbstractEarType>();
        allEarTypes = new ArrayList<AbstractEarType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("ear")) continue;
                try {
                    AbstractEarType type = new AbstractEarType(innerEntry.getValue(), entry.getKey(), true){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allEarTypes.add(type);
                    earToIdMap.put(type, id);
                    idToEarMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("ear")) continue;
                try {
                    AbstractEarType type = new AbstractEarType(innerEntry.getValue(), entry.getKey(), false){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allEarTypes.add(type);
                    earToIdMap.put(type, id);
                    idToEarMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        for (Field f : fieldArray = EarType.class.getFields()) {
            if (!AbstractEarType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractEarType ct = (AbstractEarType)f.get(null);
                earToIdMap.put(ct, f.getName());
                idToEarMap.put(f.getName(), ct);
                allEarTypes.add(ct);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(allEarTypes, (t1, t2) -> t1.getRace() == Race.NONE ? -1 : (t2.getRace() == Race.NONE ? 1 : t1.getRace().getName(false).compareTo(t2.getRace().getName(false))));
        typesMap = new HashMap<AbstractRace, List<AbstractEarType>>();
    }
}

