/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.types;

import com.lilithsthrone.game.character.body.abstractTypes.AbstractFaceType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.tags.BodyPartTag;
import com.lilithsthrone.game.character.body.types.MouthType;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FaceType {
    public static AbstractFaceType HUMAN;
    public static AbstractFaceType ANGEL;
    public static AbstractFaceType DEMON_COMMON;
    public static AbstractFaceType ALLIGATOR_MORPH;
    public static AbstractFaceType BAT_MORPH;
    public static AbstractFaceType CAT_MORPH;
    public static AbstractFaceType COW_MORPH;
    public static AbstractFaceType DOG_MORPH;
    public static AbstractFaceType FOX_MORPH;
    public static AbstractFaceType HARPY;
    public static AbstractFaceType HORSE_MORPH;
    public static AbstractFaceType RABBIT_MORPH;
    public static AbstractFaceType RAT_MORPH;
    public static AbstractFaceType REINDEER_MORPH;
    public static AbstractFaceType SQUIRREL_MORPH;
    public static AbstractFaceType WOLF_MORPH;
    private static List<AbstractFaceType> allFaceTypes;
    private static Map<AbstractFaceType, String> faceToIdMap;
    private static Map<String, AbstractFaceType> idToFaceMap;
    private static Map<AbstractRace, List<AbstractFaceType>> typesMap;

    public static AbstractFaceType getFaceTypeFromId(String id) {
        if (id.equals("IMP")) {
            return DEMON_COMMON;
        }
        if (id.equals("LYCAN")) {
            return WOLF_MORPH;
        }
        if (id.equals("TENGU")) {
            return HARPY;
        }
        if (id.equals("CAT_MORPH_PANTHER")) {
            id = "innoxia_panther_face";
        }
        id = Util.getClosestStringMatch(id, idToFaceMap.keySet());
        return idToFaceMap.get(id);
    }

    public static String getIdFromFaceType(AbstractFaceType faceType) {
        return faceToIdMap.get(faceType);
    }

    public static List<AbstractFaceType> getAllFaceTypes() {
        return allFaceTypes;
    }

    public static List<AbstractFaceType> getFaceTypes(AbstractRace r) {
        if (typesMap.containsKey(r)) {
            return typesMap.get(r);
        }
        ArrayList<AbstractFaceType> types = new ArrayList<AbstractFaceType>();
        for (AbstractFaceType type : FaceType.getAllFaceTypes()) {
            if (type.getRace() != r) continue;
            types.add(type);
        }
        typesMap.put(r, types);
        return types;
    }

    static {
        Field[] fieldArray;
        HUMAN = new AbstractFaceType(BodyCoveringType.HUMAN, Race.HUMAN, MouthType.HUMAN, null, null, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u9f3b\u5b50", "\u9f3b\u5b50", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u4e07\u5e78\u7684\u662f\uff0c\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c[npc.herHim]\u53d8\u6210\u4e86\u666e\u901a\u7684\u4eba\u7c7b\u9762\u5bb9\uff0c[npc.materialDescriptor][npc.faceSkin+]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldHuman(\u4eba\u7c7b\u7684\u9762\u5bb9)]\uff0c[npc.materialDescriptor][npc.faceFullDescription]\u3002\u5728[npc.her]\u7684[npc.mouth]\u91cc\uff0c\u6709\u7740\u4e00\u6839[style.boldHuman(\u4eba\u7c7b\u820c\u5934)]\u3002", "[npc.SheHasFull]\u957f\u7740\u4e00\u526f[npc.a_feminineDescriptor(true)]\u7684\u4eba\u7c7b\u9762\u5b54\uff0c[npc.materialDescriptor][npc.faceFullDescription(true)]\u3002", Util.newArrayListOfValues(new BodyPartTag[0])){};
        ANGEL = new AbstractFaceType(BodyCoveringType.ANGEL, Race.ANGEL, MouthType.ANGEL, null, null, Util.newArrayListOfValues("\u5b8c\u7f8e", "\u65e0\u6687", "\u5929\u4f7f\u822c"), Util.newArrayListOfValues("\u5b8c\u7f8e", "\u65e0\u6687", "\u5929\u4f7f\u822c"), "\u9f3b\u5b50", "\u9f3b\u5b50", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u4e07\u5e78\u7684\u662f\uff0c\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c[npc.herHim]\u53d8\u6210\u4e86\u4e0e\u4eba\u7c7b\u76f8\u4f3c\u7684\u5929\u4f7f\u9762\u5bb9\uff0c[npc.materialDescriptor][npc.faceSkin+]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldAngel(\u5929\u4f7f\u7684\u9762\u5bb9)]\uff0c[npc.materialDescriptor][npc.faceFullDescription]\u3002\u5728[npc.her]\u7684[npc.mouth]\u91cc\uff0c\u6709\u7740\u4e00\u6839[style.boldAngel(\u5929\u4f7f\u820c\u5934)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.a_feminineDescriptor(true)]\u7684\u5929\u4f7f\u9762\u5e9e\uff0c[npc.materialDescriptor][npc.faceFullDescription(true)]\u3002", Util.newArrayListOfValues(new BodyPartTag[0])){};
        DEMON_COMMON = new AbstractFaceType(BodyCoveringType.DEMON_COMMON, Race.DEMON, MouthType.DEMON_COMMON, null, null, Util.newArrayListOfValues("\u5b8c\u7f8e", "\u65e0\u6687", "\u6076\u9b54\u822c"), Util.newArrayListOfValues("\u5b8c\u7f8e", "\u65e0\u6687", "\u6076\u9b54\u822c"), "\u9f3b\u5b50", "\u9f3b\u5b50", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "#IF(npc.isShortStature())\u4e07\u5e78\u7684\u662f\uff0c\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c[npc.herHim]\u53d8\u6210\u4e86\u4e0e\u4eba\u7c7b\u76f8\u4f3c\u7684\u5c0f\u6076\u9b54\u9762\u5bb9\uff0c[npc.materialDescriptor][npc.faceSkin+]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldImp(\u5c0f\u6076\u9b54\u7684\u9762\u5bb9)]\uff0c[npc.materialDescriptor][npc.faceFullDescription]\u3002\u5728[npc.her]\u7684[npc.mouth]\u91cc\uff0c\u6709\u7740\u4e00\u6839[style.boldImp(\u5c0f\u6076\u9b54\u820c\u5934)]\u3002#ELSE\u4e07\u5e78\u7684\u662f\uff0c\u8f6c\u5316\u53ea\u6301\u7eed\u4e86\u5f88\u77ed\u7684\u65f6\u95f4\uff0c[npc.herHim]\u53d8\u6210\u4e86\u4e0e\u4eba\u7c7b\u76f8\u4f3c\u7684\u6076\u9b54\u9762\u5bb9\uff0c[npc.materialDescriptor][npc.faceSkin+]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldDemon(\u6076\u9b54\u7684\u9762\u5bb9)]\uff0c[npc.materialDescriptor][npc.faceFullDescription]\u3002\u5728[npc.her]\u7684[npc.mouth]\u91cc\uff0c\u6709\u7740\u4e00\u6839[style.boldDemon(\u6076\u9b54\u820c\u5934)]\u3002#ENDIF", "[npc.SheHasFull]\u62e5\u6709[npc.a_feminineDescriptor(true)]\u7684#IF(npc.isShortStature())\u5c0f\u6076\u9b54#ELSE\u6076\u9b54#ENDIF\u9762\u5e9e\uff0c[npc.materialDescriptor][npc.faceFullDescription(true)]\u3002", Util.newArrayListOfValues(new BodyPartTag[0])){};
        ALLIGATOR_MORPH = new AbstractFaceType(BodyCoveringType.ALLIGATOR_SCALES, Race.ALLIGATOR_MORPH, MouthType.ALLIGATOR_MORPH, null, null, Util.newArrayListOfValues("\u9cc4\u9c7c\u822c\u62df\u4eba", "\u9cc4\u9c7c\u822c", "\u722c\u884c\u52a8\u7269\u822c"), Util.newArrayListOfValues("\u9cc4\u9c7c\u822c\u62df\u4eba", "\u9cc4\u9c7c\u822c", "\u722c\u884c\u52a8\u7269\u822c"), "\u9f3b\u5b50", "\u9f3b\u5b50", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.Her]\u7684\u9f3b\u5b50\u548c\u5634\u5df4\u5fae\u5fae\u62bd\u6410\uff0c\u968f\u540e\u4fbf\u8f6c\u5316\u4e3a\u4f3c\u4eba\u7684\u722c\u884c\u52a8\u7269\u7684\u543b\u90e8\uff0c\u820c\u5934\u4e5f\u53d8\u5f97\u5341\u5206\u6709\u529b\uff0c\u4e0e\u9cc4\u9c7c\u7c7b\u4f3c\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.faceSkin+]\u8fc5\u901f\u8986\u76d6\u4e86[npc.her]\u7684\u9762\u90e8#ELSE\u4e0e\u8eab\u4f53\u7684\u5176\u4f59\u90e8\u5206\u4e00\u6837\uff0c[npc.her]\u7684\u9762\u90e8[npc.materialDescriptor][npc.faceSkin+]#ENDIF\uff0c\u8f6c\u5316\u7ec8\u4e8e\u6b65\u5165\u5c3e\u58f0\uff0c[npc.sheIs]\u6c14\u5598\u5401\u5401\u5730\u652b\u53d6\u7740\u6c27\u6c14\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldAlligatorMorph(\u9cc4\u9c7c\u822c\u7684\u62df\u4eba\u9762\u5bb9)]\uff0c[npc.materialDescriptor][npc.faceFullDescription]\u3002\u5728[npc.her]\u7684[npc.mouth]\u91cc\uff0c\u6709\u7740\u4e00\u6839[style.boldAlligatorMorph(\u6709\u529b\u7684\u9cc4\u9c7c\u820c\u5934)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.a_feminineDescriptor(true)]\u7684\u9cc4\u9c7c\u9762\u5e9e\uff0c\u6709\u4eba\u7c7b\u7279\u5f81\uff0c[npc.materialCompositionDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u957f\u800c\u5e73\u7684\u543b\u90e8\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.feminineDescriptor(true)]\u7684\u517d\u6001[npc.legRace]\u9762\u5e9e\uff0c[npc.materialDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u957f\u800c\u5e73\u7684\u543b\u90e8\u3002", Util.newArrayListOfValues(BodyPartTag.FACE_MUZZLE, BodyPartTag.FACE_FANGS, BodyPartTag.FACE_NATURAL_BALDNESS_SCALY)){};
        BAT_MORPH = new AbstractFaceType(BodyCoveringType.BAT_FUR, Race.BAT_MORPH, MouthType.BAT_MORPH, null, null, Util.newArrayListOfValues("\u8759\u8760\u822c\u62df\u4eba", "\u8759\u8760\u822c"), Util.newArrayListOfValues("\u8759\u8760\u822c\u62df\u4eba", "\u8759\u8760\u822c"), "\u9f3b\u5b50", "\u9f3b\u5b50", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.Her]\u7684\u9f3b\u5b50\u548c\u5634\u5df4\u5fae\u5fae\u62bd\u6410\uff0c\u968f\u540e\u4fbf\u8f6c\u5316\u4e3a\u4f3c\u4eba\u7684\u8759\u8760\u543b\u90e8\uff0c\u820c\u5934\u4e5f\u53d8\u5f97\u6bd4\u8f83\u7ec6\u7a84\uff0c\u4e0e\u8759\u8760\u7c7b\u4f3c\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.faceSkin+]\u8fc5\u901f\u8986\u76d6\u4e86[npc.her]\u7684\u9762\u90e8#ELSE\u4e0e\u8eab\u4f53\u7684\u5176\u4f59\u90e8\u5206\u4e00\u6837\uff0c[npc.her]\u7684\u9762\u90e8[npc.materialDescriptor][npc.faceSkin+]#ENDIF\uff0c\u8f6c\u5316\u7ec8\u4e8e\u6b65\u5165\u5c3e\u58f0\uff0c[npc.sheIs]\u6c14\u5598\u5401\u5401\u5730\u652b\u53d6\u7740\u6c27\u6c14\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldBatMorph(\u8759\u8760\u822c\u7684\u62df\u4eba\u9762\u5bb9)]\uff0c[npc.materialDescriptor][npc.faceFullDescription]\u3002\u5728[npc.her]\u7684[npc.mouth]\u91cc\uff0c\u6709\u7740\u4e00\u6839[style.boldBatMorph(\u7ec6\u7a84\u7684\u8759\u8760\u820c\u5934)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.a_feminineDescriptor(true)]\u7684\u8759\u8760\u9762\u5e9e\uff0c\u6709\u4eba\u7c7b\u7279\u5f81\uff0c[npc.materialCompositionDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u77ed\u5c0f\u7684\u543b\u90e8\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.feminineDescriptor(true)]\u7684\u517d\u6001[npc.legRace]\u9762\u5e9e\uff0c[npc.materialDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u77ed\u5c0f\u7684\u543b\u90e8\u3002", Util.newArrayListOfValues(BodyPartTag.FACE_MUZZLE, BodyPartTag.FACE_FANGS, BodyPartTag.FACE_NATURAL_BALDNESS_FURRY)){};
        CAT_MORPH = new AbstractFaceType(BodyCoveringType.FELINE_FUR, Race.CAT_MORPH, MouthType.CAT_MORPH, null, null, Util.newArrayListOfValues("\u732b\u4e00\u822c\u62df\u4eba", "\u732b\u4e00\u822c", "\u732b\u7c7b"), Util.newArrayListOfValues("\u732b\u4e00\u822c\u62df\u4eba", "\u732b\u4e00\u822c", "\u732b\u7c7b"), "\u9f3b\u5b50", "\u9f3b\u5b50", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.Her]\u7684\u9f3b\u5b50\u548c\u5634\u5df4\u5fae\u5fae\u62bd\u6410\uff0c\u968f\u540e\u4fbf\u8f6c\u5316\u4e3a\u4f3c\u4eba\u7684\u732b\u7c7b\u543b\u90e8\uff0c\u820c\u5934\u4e5f\u53d8\u5f97\u5e73\u76f4\uff0c\u4e0e\u732b\u7c7b\u4f3c\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.faceSkin+]\u8fc5\u901f\u8986\u76d6\u4e86[npc.her]\u7684\u9762\u90e8#ELSE\u4e0e\u8eab\u4f53\u7684\u5176\u4f59\u90e8\u5206\u4e00\u6837\uff0c[npc.her]\u7684\u9762\u90e8[npc.materialDescriptor][npc.faceSkin+]#ENDIF\uff0c\u8f6c\u5316\u7ec8\u4e8e\u6b65\u5165\u5c3e\u58f0\uff0c[npc.sheIs]\u6c14\u5598\u5401\u5401\u5730\u652b\u53d6\u7740\u6c27\u6c14\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldCatMorph(\u732b\u4e00\u822c\u62df\u4eba\u7684\u9762\u5bb9)]\uff0c[npc.materialDescriptor][npc.faceFullDescription]\u3002\u5728[npc.her]\u7684[npc.mouth]\u91cc\uff0c\u6709\u7740\u4e00\u6839[style.boldCatMorph(\u5e73\u76f4\u7684\u732b\u7c7b\u820c\u5934)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.a_feminineDescriptor(true)]\u7684\u732b\u7684\u9762\u5e9e\uff0c\u6709\u4eba\u7c7b\u7279\u5f81\uff0c[npc.materialCompositionDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u5c0f\u800c\u53ef\u7231\u7684\u543b\u90e8\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.feminineDescriptor(true)]\u7684\u517d\u6001[npc.legRace]\u9762\u5e9e\uff0c[npc.materialDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u5c0f\u800c\u53ef\u7231\u7684\u732b\u79d1\u543b\u90e8\u3002", Util.newArrayListOfValues(BodyPartTag.FACE_MUZZLE, BodyPartTag.FACE_FANGS, BodyPartTag.FACE_NATURAL_BALDNESS_FURRY)){};
        COW_MORPH = new AbstractFaceType(BodyCoveringType.BOVINE_FUR, Race.COW_MORPH, MouthType.COW_MORPH, null, null, Util.newArrayListOfValues("\u725b\u4e00\u822c\u62df\u4eba", "\u725b\u4e00\u822c", "\u725b\u7c7b"), Util.newArrayListOfValues("\u725b\u4e00\u822c\u62df\u4eba", "\u725b\u4e00\u822c", "\u725b\u7c7b"), "\u9f3b\u5b50", "\u9f3b\u5b50", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.Her]\u7684\u9f3b\u5b50\u548c\u5634\u5df4\u5fae\u5fae\u62bd\u6410\uff0c\u968f\u540e\u4fbf\u8f6c\u5316\u4e3a\u4f3c\u4eba\u7684\u722c\u884c\u52a8\u7269\u7684\u725b\u7c7b\u543b\u90e8\uff0c\u820c\u5934\u4e5f\u53d8\u5f97\u5341\u5206\u6709\u529b\uff0c\u4e0e\u725b\u7c7b\u4f3c\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.faceSkin+]\u8fc5\u901f\u8986\u76d6\u4e86[npc.her]\u7684\u9762\u90e8#ELSE\u4e0e\u8eab\u4f53\u7684\u5176\u4f59\u90e8\u5206\u4e00\u6837\uff0c[npc.her]\u7684\u9762\u90e8[npc.materialDescriptor][npc.faceSkin+]#ENDIF\uff0c\u8f6c\u5316\u7ec8\u4e8e\u6b65\u5165\u5c3e\u58f0\uff0c[npc.sheIs]\u6c14\u5598\u5401\u5401\u5730\u652b\u53d6\u7740\u6c27\u6c14\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldCowMorph(\u725b\u4e00\u822c\u7684\u62df\u4eba\u9762\u5bb9)]\uff0c[npc.materialDescriptor][npc.faceFullDescription]\u3002\u5728[npc.her]\u7684[npc.mouth]\u91cc\uff0c\u6709\u7740\u4e00\u6839[style.boldCowMorph(\u6709\u529b\u7684\u725b\u820c\u5934)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.a_feminineDescriptor(true)]\u7684\u725b\u4e00\u822c\u7684\u9762\u5e9e\uff0c\u6709\u4eba\u7c7b\u7279\u5f81\uff0c[npc.materialCompositionDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u725b\u7c7b\u7684\u543b\u90e8\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.feminineDescriptor(true)]\u7684\u517d\u6001[npc.legRace]\u9762\u5e9e\uff0c[npc.materialDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u725b\u7c7b\u7684\u543b\u90e8\u3002", Util.newArrayListOfValues(BodyPartTag.FACE_MUZZLE, BodyPartTag.FACE_NATURAL_BALDNESS_FURRY)){};
        DOG_MORPH = new AbstractFaceType(BodyCoveringType.CANINE_FUR, Race.DOG_MORPH, MouthType.DOG_MORPH, null, null, Util.newArrayListOfValues("\u72ac\u4e00\u822c\u62df\u4eba", "\u72ac\u4e00\u822c", "\u72ac\u7c7b"), Util.newArrayListOfValues("\u72ac\u4e00\u822c\u62df\u4eba", "\u72ac\u4e00\u822c", "\u72ac\u7c7b"), "\u9f3b\u5b50", "\u9f3b\u5b50", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.Her]\u7684\u9f3b\u5b50\u548c\u5634\u5df4\u5fae\u5fae\u62bd\u6410\uff0c\u968f\u540e\u4fbf\u8f6c\u5316\u4e3a\u4f3c\u4eba\u7684\u72ac\u7c7b\u543b\u90e8\uff0c\u820c\u5934\u4e5f\u53d8\u53c8\u5e73\u53c8\u5bbd\uff0c\u4e0e\u72d7\u7c7b\u4f3c\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.faceSkin+]\u8fc5\u901f\u8986\u76d6\u4e86[npc.her]\u7684\u9762\u90e8#ELSE\u4e0e\u8eab\u4f53\u7684\u5176\u4f59\u90e8\u5206\u4e00\u6837\uff0c[npc.her]\u7684\u9762\u90e8[npc.materialDescriptor][npc.faceSkin+]#ENDIF\uff0c\u8f6c\u5316\u7ec8\u4e8e\u6b65\u5165\u5c3e\u58f0\uff0c[npc.sheIs]\u6c14\u5598\u5401\u5401\u5730\u652b\u53d6\u7740\u6c27\u6c14\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldDogMorph(\u72ac\u4e00\u822c\u62df\u4eba\u7684\u9762\u5bb9)]\uff0c[npc.materialDescriptor][npc.faceFullDescription]\u3002\u5728[npc.her]\u7684[npc.mouth]\u91cc\uff0c\u6709\u7740\u4e00\u6839[style.boldDogMorph(\u5e73\u76f4\u7684\u72ac\u7c7b\u820c\u5934)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.a_feminineDescriptor(true)]\u7684\u72ac\u4e00\u822c\u7684\u9762\u5e9e\uff0c\u6709\u4eba\u7c7b\u7279\u5f81\uff0c[npc.materialCompositionDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u72ac\u7c7b\u7684\u543b\u90e8\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.feminineDescriptor(true)]\u7684\u517d\u6001[npc.legRace]\u9762\u5e9e\uff0c[npc.materialDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u72ac\u7c7b\u7684\u543b\u90e8\u3002", Util.newArrayListOfValues(BodyPartTag.FACE_MUZZLE, BodyPartTag.FACE_FANGS, BodyPartTag.FACE_NATURAL_BALDNESS_FURRY)){};
        FOX_MORPH = new AbstractFaceType(BodyCoveringType.FOX_FUR, Race.FOX_MORPH, MouthType.FOX_MORPH, null, null, Util.newArrayListOfValues("\u72d0\u72f8\u822c\u62df\u4eba", "\u72d0\u72f8\u822c"), Util.newArrayListOfValues("\u72d0\u72f8\u822c\u62df\u4eba", "\u72d0\u72f8\u822c"), "\u9f3b\u5b50", "\u9f3b\u5b50", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.Her]\u7684\u9f3b\u5b50\u548c\u5634\u5df4\u5fae\u5fae\u62bd\u6410\uff0c\u968f\u540e\u4fbf\u8f6c\u5316\u4e3a\u4f3c\u4eba\u7684\u72d0\u7c7b\u543b\u90e8\uff0c\u820c\u5934\u4e5f\u53d8\u5f97\u5e73\u76f4\uff0c\u4e0e\u72d0\u72f8\u7c7b\u4f3c\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.faceSkin+]\u8fc5\u901f\u8986\u76d6\u4e86[npc.her]\u7684\u9762\u90e8#ELSE\u4e0e\u8eab\u4f53\u7684\u5176\u4f59\u90e8\u5206\u4e00\u6837\uff0c[npc.her]\u7684\u9762\u90e8[npc.materialDescriptor][npc.faceSkin+]#ENDIF\uff0c\u8f6c\u5316\u7ec8\u4e8e\u6b65\u5165\u5c3e\u58f0\uff0c[npc.sheIs]\u6c14\u5598\u5401\u5401\u5730\u652b\u53d6\u7740\u6c27\u6c14\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldFoxMorph(\u72d0\u72f8\u822c\u62df\u4eba\u7684\u9762\u5bb9)]\uff0c[npc.materialDescriptor][npc.faceFullDescription]\u3002\u5728[npc.her]\u7684[npc.mouth]\u91cc\uff0c\u6709\u7740\u4e00\u6839[style.boldFoxMorph(\u5e73\u76f4\u7684\u72d0\u72f8\u820c\u5934)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.a_feminineDescriptor(true)]\u7684\u72d0\u72f8\u822c\u7684\u9762\u5e9e\uff0c\u6709\u4eba\u7c7b\u7279\u5f81\uff0c[npc.materialCompositionDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u7ec6\u957f\u7684\u72d0\u7c7b\u543b\u90e8\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.feminineDescriptor(true)]\u7684\u517d\u6001[npc.legRace]\u9762\u5e9e\uff0c[npc.materialDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u7ec6\u957f\u7684\u72d0\u7c7b\u543b\u90e8\u3002", Util.newArrayListOfValues(BodyPartTag.FACE_MUZZLE, BodyPartTag.FACE_FANGS, BodyPartTag.FACE_NATURAL_BALDNESS_FURRY)){};
        HARPY = new AbstractFaceType(BodyCoveringType.FEATHERS, Race.HARPY, MouthType.HARPY, null, null, Util.newArrayListOfValues("\u9e1f\u4e00\u822c\u62df\u4eba", "\u9e1f\u4e00\u822c"), Util.newArrayListOfValues("\u9e1f\u4e00\u822c\u62df\u4eba", "\u9e1f\u4e00\u822c"), "\u9f3b\u5b50", "\u9f3b\u5b50", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.Her]\u7684\u9f3b\u5b50\u548c\u5634\u5df4\u5fae\u5fae\u62bd\u6410\uff0c\u968f\u540e\u4fbf\u878d\u5408\u5728\u4e00\u8d77\uff0c\u53d8\u6210\u4e86\u4e2a\u7c97\u77ed\u7684\u9e1f\u5599\uff0c\u820c\u5934\u4e5f\u53d8\u5f97\u5f88\u7ec6\uff0c\u4e0e\u9e1f\u7c7b\u4f3c\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.faceSkin+]\u8fc5\u901f\u8986\u76d6\u4e86[npc.her]\u7684\u9762\u90e8\uff0c#ELSE\u4e0e\u8eab\u4f53\u7684\u5176\u4f59\u90e8\u5206\u4e00\u6837\uff0c[npc.her]\u7684\u9762\u90e8[npc.materialDescriptor][npc.faceSkin+]\uff0c#ENDIF\u8f6c\u5316\u7ec8\u4e8e\u6b65\u5165\u5c3e\u58f0\uff0c[npc.sheIs]\u6c14\u5598\u5401\u5401\u5730\u652b\u53d6\u7740\u6c27\u6c14\u3002[npc.She]\u53d1\u73b0\u81ea\u5df1\u53ef\u4ee5\u968f\u610f\u5730\u8f6f\u5316\u786c\u5316\u5599\u90e8\u8fb9\u7f18\uff0c\u8fd9\u624d\u677e\u4e86\u53e3\u6c14\uff0c\u8fd9\u4f7f\u5f97[npc.her]\u53ef\u4ee5\u901a\u8fc7\u5f2f\u66f2\u5599\u7684\u8fb9\u7f18\uff0c\u6a21\u4eff\u5404\u79cd\u5634\u5df4\u80fd\u591f\u6446\u51fa\u7684\u6837\u5b50\uff0c\u6765\u5c55\u73b0\u9762\u90e8\u52a8\u4f5c\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldHarpy(\u9e1f\u4e00\u822c\u62df\u4eba\u7684\u9762\u5bb9)]\uff0c[npc.materialDescriptor][npc.faceFullDescription]\u3002\u5728[npc.her]\u7684[npc.mouth]\u91cc\uff0c\u6709\u7740\u4e00\u6839[style.boldHarpy(\u7ec6\u7a84\u7684\u9e1f\u7c7b\u820c\u5934)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.a_feminineDescriptor(true)]\u7684\u9e1f\u4e00\u822c\u7684\u9762\u5e9e\uff0c\u6709\u4eba\u7c7b\u7279\u5f81\uff0c[npc.materialCompositionDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u4e00\u53ea\u5599\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.feminineDescriptor(true)]\u7684\u517d\u6001[npc.legRace]\u9762\u5e9e\uff0c[npc.materialDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u4e00\u53ea\u5599\u3002", Util.newArrayListOfValues(BodyPartTag.FACE_BEAK, BodyPartTag.FACE_NATURAL_BALDNESS_AVIAN)){};
        HORSE_MORPH = new AbstractFaceType(BodyCoveringType.HORSE_HAIR, Race.HORSE_MORPH, MouthType.HORSE_MORPH, null, null, Util.newArrayListOfValues("\u9a6c\u4e00\u822c\u62df\u4eba", "\u9a6c\u4e00\u822c", "\u9a6c\u7c7b"), Util.newArrayListOfValues("\u9a6c\u4e00\u822c\u62df\u4eba", "\u9a6c\u4e00\u822c", "\u9a6c\u7c7b"), "\u9f3b\u5b50", "\u9f3b\u5b50", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.Her]\u7684\u9f3b\u5b50\u548c\u5634\u5df4\u5fae\u5fae\u62bd\u6410\uff0c\u968f\u540e\u4fbf\u8f6c\u5316\u4e3a\u4f3c\u4eba\u7684\u9a6c\u7c7b\u543b\u90e8\uff0c\u820c\u5934\u4e5f\u53d8\u5f97\u5341\u5206\u6709\u529b\uff0c\u4e0e\u9a6c\u7c7b\u4f3c\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.faceSkin+]\u8fc5\u901f\u8986\u76d6\u4e86[npc.her]\u7684\u9762\u90e8#ELSE\u4e0e\u8eab\u4f53\u7684\u5176\u4f59\u90e8\u5206\u4e00\u6837\uff0c[npc.her]\u7684\u9762\u90e8[npc.materialDescriptor][npc.faceSkin+]#ENDIF\uff0c\u8f6c\u5316\u7ec8\u4e8e\u6b65\u5165\u5c3e\u58f0\uff0c[npc.sheIs]\u6c14\u5598\u5401\u5401\u5730\u652b\u53d6\u7740\u6c27\u6c14\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldHorseMorph(\u9a6c\u4e00\u822c\u62df\u4eba\u7684\u9762\u5bb9)]\uff0c[npc.materialDescriptor][npc.faceFullDescription]\u3002\u5728[npc.her]\u7684[npc.mouth]\u91cc\uff0c\u6709\u7740\u4e00\u6839[style.boldHorseMorph(\u6709\u529b\u7684\u9a6c\u7c7b\u820c\u5934)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.a_feminineDescriptor(true)]\u7684\u9a6c\u4e00\u822c\u7684\u9762\u5e9e\uff0c\u6709\u4eba\u7c7b\u7279\u5f81\uff0c[npc.materialCompositionDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u957f\u957f\u7684\u9a6c\u7c7b\u543b\u90e8\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.feminineDescriptor(true)]\u7684\u517d\u6001[npc.legRace]\u9762\u5e9e\uff0c[npc.materialDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u957f\u957f\u7684\u9a6c\u7c7b\u543b\u90e8\u3002", Util.newArrayListOfValues(BodyPartTag.FACE_MUZZLE, BodyPartTag.FACE_NATURAL_BALDNESS_FURRY)){};
        RABBIT_MORPH = new AbstractFaceType(BodyCoveringType.RABBIT_FUR, Race.RABBIT_MORPH, MouthType.RABBIT_MORPH, null, null, Util.newArrayListOfValues("\u5154\u5b50\u822c\u62df\u4eba", "\u5154\u5b50\u822c"), Util.newArrayListOfValues("\u5154\u5b50\u822c\u62df\u4eba", "\u5154\u5b50\u822c"), "\u9f3b\u5b50", "\u9f3b\u5b50", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.Her]\u7684\u9f3b\u5b50\u548c\u5634\u5df4\u5fae\u5fae\u62bd\u6410\uff0c\u968f\u540e\u4fbf\u8f6c\u5316\u4e3a\u4f3c\u4eba\u7684\u5154\u5b50\u543b\u90e8\uff0c\u820c\u5934\u4e5f\u53d8\u5f97\u6bd4\u8f83\u7ec6\u7a84\uff0c\u4e0e\u5154\u5b50\u7c7b\u4f3c\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.faceSkin+]\u8fc5\u901f\u8986\u76d6\u4e86[npc.her]\u7684\u9762\u90e8#ELSE\u4e0e\u8eab\u4f53\u7684\u5176\u4f59\u90e8\u5206\u4e00\u6837\uff0c[npc.her]\u7684\u9762\u90e8[npc.materialDescriptor][npc.faceSkin+]#ENDIF\uff0c\u8f6c\u5316\u7ec8\u4e8e\u6b65\u5165\u5c3e\u58f0\uff0c[npc.sheIs]\u6c14\u5598\u5401\u5401\u5730\u652b\u53d6\u7740\u6c27\u6c14\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldRabbitMorph(\u5154\u5b50\u822c\u62df\u4eba\u7684\u9762\u5bb9)]\uff0c[npc.materialDescriptor][npc.faceFullDescription]\u3002\u5728[npc.her]\u7684[npc.mouth]\u91cc\uff0c\u6709\u7740\u4e00\u6839[style.boldRabbitMorph(\u7ec6\u7a84\u7684\u5154\u5b50\u820c\u5934)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.a_feminineDescriptor(true)]\u7684\u5154\u5b50\u9762\u5e9e\uff0c\u6709\u4eba\u7c7b\u7279\u5f81\uff0c[npc.materialCompositionDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u77ed\u5c0f\u7684\u543b\u90e8\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.feminineDescriptor(true)]\u7684\u517d\u6001[npc.legRace]\u9762\u5e9e\uff0c[npc.materialDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u77ed\u5c0f\u7684\u543b\u90e8\u3002", Util.newArrayListOfValues(BodyPartTag.FACE_MUZZLE, BodyPartTag.FACE_NATURAL_BALDNESS_FURRY)){};
        RAT_MORPH = new AbstractFaceType(BodyCoveringType.RAT_FUR, Race.RAT_MORPH, MouthType.RAT_MORPH, null, null, Util.newArrayListOfValues("\u8001\u9f20\u822c\u62df\u4eba", "\u8001\u9f20\u822c", "\u556e\u9f7f\u7c7b"), Util.newArrayListOfValues("\u8001\u9f20\u822c\u62df\u4eba", "\u8001\u9f20\u822c", "\u556e\u9f7f\u7c7b"), "\u9f3b\u5b50", "\u9f3b\u5b50", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.Her]\u7684\u9f3b\u5b50\u548c\u5634\u5df4\u5fae\u5fae\u62bd\u6410\uff0c\u968f\u540e\u4fbf\u8f6c\u5316\u4e3a\u4f3c\u4eba\u7684\u8001\u9f20\u543b\u90e8\uff0c\u820c\u5934\u4e5f\u53d8\u5f97\u6bd4\u8f83\u7ec6\u7a84\uff0c\u4e0e\u8001\u9f20\u7c7b\u4f3c\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.faceSkin+]\u8fc5\u901f\u8986\u76d6\u4e86[npc.her]\u7684\u9762\u90e8#ELSE\u4e0e\u8eab\u4f53\u7684\u5176\u4f59\u90e8\u5206\u4e00\u6837\uff0c[npc.her]\u7684\u9762\u90e8[npc.materialDescriptor][npc.faceSkin+]#ENDIF\uff0c\u8f6c\u5316\u7ec8\u4e8e\u6b65\u5165\u5c3e\u58f0\uff0c[npc.sheIs]\u6c14\u5598\u5401\u5401\u5730\u652b\u53d6\u7740\u6c27\u6c14\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldRatMorph(\u8001\u9f20\u822c\u62df\u4eba\u7684\u9762\u5bb9)]\uff0c[npc.materialDescriptor][npc.faceFullDescription]\u3002\u5728[npc.her]\u7684[npc.mouth]\u91cc\uff0c\u6709\u7740\u4e00\u6839[style.boldRatMorph(\u7ec6\u7a84\u7684\u8001\u9f20\u820c\u5934)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.a_feminineDescriptor(true)]\u7684\u8001\u9f20\u9762\u5e9e\uff0c\u6709\u4eba\u7c7b\u7279\u5f81\uff0c[npc.materialCompositionDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u957f\u957f\u7684\u556e\u9f7f\u7c7b\u543b\u90e8\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.feminineDescriptor(true)]\u7684\u517d\u6001[npc.legRace]\u9762\u5e9e\uff0c[npc.materialDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u957f\u957f\u7684\u556e\u9f7f\u7c7b\u543b\u90e8\u3002", Util.newArrayListOfValues(BodyPartTag.FACE_MUZZLE, BodyPartTag.FACE_NATURAL_BALDNESS_FURRY)){};
        REINDEER_MORPH = new AbstractFaceType(BodyCoveringType.REINDEER_FUR, Race.REINDEER_MORPH, MouthType.REINDEER_MORPH, null, null, Util.newArrayListOfValues("\u9a6f\u9e7f\u822c\u62df\u4eba", "\u9a6f\u9e7f\u822c", "\u9a6f\u9e7f"), Util.newArrayListOfValues("\u9a6f\u9e7f\u822c\u62df\u4eba", "\u9a6f\u9e7f\u822c", "\u9a6f\u9e7f"), "\u9f3b\u5b50", "\u9f3b\u5b50", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.Her]\u7684\u9f3b\u5b50\u548c\u5634\u5df4\u5fae\u5fae\u62bd\u6410\uff0c\u968f\u540e\u4fbf\u8f6c\u5316\u4e3a\u4f3c\u4eba\u7684\u9a6f\u9e7f\u543b\u90e8\uff0c\u820c\u5934\u4e5f\u53d8\u5f97\u5341\u5206\u6709\u529b\uff0c\u4e0e\u9a6f\u9e7f\u7c7b\u4f3c\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.faceSkin+]\u8fc5\u901f\u8986\u76d6\u4e86[npc.her]\u7684\u9762\u90e8#ELSE\u4e0e\u8eab\u4f53\u7684\u5176\u4f59\u90e8\u5206\u4e00\u6837\uff0c[npc.her]\u7684\u9762\u90e8[npc.materialDescriptor][npc.faceSkin+]#ENDIF\uff0c\u8f6c\u5316\u7ec8\u4e8e\u6b65\u5165\u5c3e\u58f0\uff0c[npc.sheIs]\u6c14\u5598\u5401\u5401\u5730\u652b\u53d6\u7740\u6c27\u6c14\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldReindeerMorph(\u9a6f\u9e7f\u822c\u62df\u4eba\u7684\u9762\u5bb9)]\uff0c[npc.materialDescriptor][npc.faceFullDescription]\u3002\u5728[npc.her]\u7684[npc.mouth]\u91cc\uff0c\u6709\u7740\u4e00\u6839[style.boldReindeerMorph(\u6709\u529b\u7684\u9a6f\u9e7f\u820c\u5934)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.a_feminineDescriptor(true)]\u7684\u9a6f\u9e7f\u9762\u5e9e\uff0c\u6709\u4eba\u7c7b\u7279\u5f81\uff0c[npc.materialCompositionDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u957f\u957f\u7684\u543b\u90e8\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.feminineDescriptor(true)]\u7684\u517d\u6001[npc.legRace]\u9762\u5e9e\uff0c[npc.materialDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u957f\u957f\u7684\u543b\u90e8\u3002", Util.newArrayListOfValues(BodyPartTag.FACE_MUZZLE, BodyPartTag.FACE_NATURAL_BALDNESS_FURRY)){};
        SQUIRREL_MORPH = new AbstractFaceType(BodyCoveringType.SQUIRREL_FUR, Race.SQUIRREL_MORPH, MouthType.SQUIRREL_MORPH, null, null, Util.newArrayListOfValues("\u677e\u9f20\u822c\u62df\u4eba", "\u677e\u9f20\u822c", "\u556e\u9f7f\u7c7b"), Util.newArrayListOfValues("\u677e\u9f20\u822c\u62df\u4eba", "\u677e\u9f20\u822c", "\u556e\u9f7f\u7c7b"), "\u9f3b\u5b50", "\u9f3b\u5b50", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.Her]\u7684\u9f3b\u5b50\u548c\u5634\u5df4\u5fae\u5fae\u62bd\u6410\uff0c\u968f\u540e\u4fbf\u8f6c\u5316\u4e3a\u4f3c\u4eba\u7684\u677e\u9f20\u543b\u90e8\uff0c\u820c\u5934\u4e5f\u53d8\u5f97\u6bd4\u8f83\u7ec6\u7a84\uff0c\u4e0e\u677e\u9f20\u7c7b\u4f3c\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.faceSkin+]\u8fc5\u901f\u8986\u76d6\u4e86[npc.her]\u7684\u9762\u90e8#ELSE\u4e0e\u8eab\u4f53\u7684\u5176\u4f59\u90e8\u5206\u4e00\u6837\uff0c[npc.her]\u7684\u9762\u90e8[npc.materialDescriptor][npc.faceSkin+]#ENDIF\uff0c\u8f6c\u5316\u7ec8\u4e8e\u6b65\u5165\u5c3e\u58f0\uff0c[npc.sheIs]\u6c14\u5598\u5401\u5401\u5730\u652b\u53d6\u7740\u6c27\u6c14\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldSquirrelMorph(\u677e\u9f20\u822c\u62df\u4eba\u7684\u9762\u5bb9)]\uff0c[npc.materialDescriptor][npc.faceFullDescription]\u3002\u5728[npc.her]\u7684[npc.mouth]\u91cc\uff0c\u6709\u7740\u4e00\u6839[style.boldSquirrelMorph(\u7ec6\u7a84\u7684\u677e\u9f20\u820c\u5934)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.a_feminineDescriptor(true)]\u7684\u677e\u9f20\u9762\u5e9e\uff0c\u6709\u4eba\u7c7b\u7279\u5f81\uff0c[npc.materialCompositionDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u77ed\u5c0f\u7684\u543b\u90e8\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.feminineDescriptor(true)]\u7684\u517d\u6001[npc.legRace]\u9762\u5e9e\uff0c[npc.materialDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u77ed\u5c0f\u7684\u543b\u90e8\u3002", Util.newArrayListOfValues(BodyPartTag.FACE_MUZZLE, BodyPartTag.FACE_NATURAL_BALDNESS_FURRY)){};
        WOLF_MORPH = new AbstractFaceType(BodyCoveringType.LYCAN_FUR, Race.WOLF_MORPH, MouthType.WOLF_MORPH, null, null, Util.newArrayListOfValues("\u72fc\u4e00\u822c\u62df\u4eba", "\u72fc\u4e00\u822c"), Util.newArrayListOfValues("\u72fc\u4e00\u822c\u62df\u4eba", "\u72fc\u4e00\u822c"), "\u9f3b\u5b50", "\u9f3b\u5b50", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.Her]\u7684\u9f3b\u5b50\u548c\u5634\u5df4\u5fae\u5fae\u62bd\u6410\uff0c\u968f\u540e\u4fbf\u8f6c\u5316\u4e3a\u4f3c\u4eba\u7684\u72fc\u7c7b\u543b\u90e8\uff0c\u820c\u5934\u4e5f\u53d8\u53c8\u5e73\u53c8\u5bbd\uff0c\u4e0e\u72fc\u7c7b\u4f3c\u3002#IF(npc.getBodyMaterial()==BODY_MATERIAL_FLESH)\u4e00\u5c42[npc.faceSkin+]\u8fc5\u901f\u8986\u76d6\u4e86[npc.her]\u7684\u9762\u90e8#ELSE\u4e0e\u8eab\u4f53\u7684\u5176\u4f59\u90e8\u5206\u4e00\u6837\uff0c[npc.her]\u7684\u9762\u90e8[npc.materialDescriptor][npc.faceSkin+]#ENDIF\uff0c\u8f6c\u5316\u7ec8\u4e8e\u6b65\u5165\u5c3e\u58f0\uff0c[npc.sheIs]\u6c14\u5598\u5401\u5401\u5730\u652b\u53d6\u7740\u6c27\u6c14\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldWolfMorph(\u72fc\u4e00\u822c\u62df\u4eba\u7684\u9762\u5bb9)]\uff0c[npc.materialDescriptor][npc.faceFullDescription]\u3002\u5728[npc.her]\u7684[npc.mouth]\u91cc\uff0c\u6709\u7740\u4e00\u6839[style.boldWolfMorph(\u5e73\u76f4\u7684\u72fc\u7c7b\u820c\u5934)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.a_feminineDescriptor(true)]\u7684\u72fc\u7c7b\u9762\u5e9e\uff0c\u6709\u4eba\u7c7b\u7279\u5f81\uff0c[npc.materialCompositionDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u957f\u957f\u7684\u543b\u90e8\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.feminineDescriptor(true)]\u7684\u517d\u6001[npc.legRace]\u9762\u5e9e\uff0c[npc.materialDescriptor][npc.faceFullDescription(true)]\uff0c\u4e14\u6709\u957f\u957f\u7684\u543b\u90e8\u3002", Util.newArrayListOfValues(BodyPartTag.FACE_MUZZLE, BodyPartTag.FACE_FANGS, BodyPartTag.FACE_NATURAL_BALDNESS_FURRY)){};
        faceToIdMap = new HashMap<AbstractFaceType, String>();
        idToFaceMap = new HashMap<String, AbstractFaceType>();
        allFaceTypes = new ArrayList<AbstractFaceType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("face")) continue;
                try {
                    AbstractFaceType type = new AbstractFaceType(innerEntry.getValue(), entry.getKey(), true){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allFaceTypes.add(type);
                    faceToIdMap.put(type, id);
                    idToFaceMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("face")) continue;
                try {
                    AbstractFaceType type = new AbstractFaceType(innerEntry.getValue(), entry.getKey(), false){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allFaceTypes.add(type);
                    faceToIdMap.put(type, id);
                    idToFaceMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        for (Field f : fieldArray = FaceType.class.getFields()) {
            if (!AbstractFaceType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractFaceType ct = (AbstractFaceType)f.get(null);
                faceToIdMap.put(ct, f.getName());
                idToFaceMap.put(f.getName(), ct);
                allFaceTypes.add(ct);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(allFaceTypes, (t1, t2) -> t1.getRace() == Race.NONE ? -1 : (t2.getRace() == Race.NONE ? 1 : t1.getRace().getName(false).compareTo(t2.getRace().getName(false))));
        typesMap = new HashMap<AbstractRace, List<AbstractFaceType>>();
    }
}

